/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeSignatureRefactoring
extends Refactoring {
    private final List fParameterInfos;
    private CompilationUnitRewrite fBaseCuRewrite;
    private List fExceptionInfos;
    private TextChangeManager fChangeManager;
    private IMethod fMethod;
    private IMethod[] fRippleMethods;
    private SearchResultGroup[] fOccurrences;
    private String fReturnTypeName;
    private String fMethodName;
    private int fVisibility;
    private static final String CONST_CLASS_DECL = "class A{";
    private static final String CONST_ASSIGN = " i=";
    private static final String CONST_CLOSE = ";}";
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ClassInstanceCreation;

    private ChangeSignatureRefactoring(IMethod method) throws JavaModelException {
        Assert.isNotNull(method);
        this.fMethod = method;
        this.fParameterInfos = ChangeSignatureRefactoring.createParameterInfoList(method);
        this.fReturnTypeName = this.getInitialReturnTypeName();
        this.fMethodName = this.getInitialMethodName();
        this.fVisibility = this.getInitialMethodVisibility();
    }

    public static ChangeSignatureRefactoring create(IMethod method) throws JavaModelException {
        if (!ChangeSignatureRefactoring.isAvailable(method)) {
            return null;
        }
        return new ChangeSignatureRefactoring(method);
    }

    public static boolean isAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        return Checks.isAvailable((IJavaElement)method);
    }

    private String getInitialReturnTypeName() throws JavaModelException {
        return Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature()));
    }

    private String getInitialMethodName() {
        return this.fMethod.getElementName();
    }

    private int getInitialMethodVisibility() throws JavaModelException {
        return JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private static List createParameterInfoList(IMethod method) {
        try {
            String[] typeNames = method.getParameterTypes();
            String[] oldNames = method.getParameterNames();
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(typeNames.length);
            for (int i = 0; i < oldNames.length; ++i) {
                result.add(new ParameterInfo(Signature.toString((String)typeNames[i]), oldNames[i], i));
            }
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new ArrayList(0);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ChangeSignatureRefactoring.modify_Parameters");
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setNewMethodName(String newMethodName) {
        Assert.isNotNull(newMethodName);
        this.fMethodName = newMethodName;
    }

    public void setNewReturnTypeName(String newReturnTypeName) {
        Assert.isNotNull(newReturnTypeName);
        this.fReturnTypeName = newReturnTypeName;
    }

    public boolean canChangeNameAndReturnType() {
        try {
            return !this.fMethod.isConstructor();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2);
        this.fVisibility = visibility;
    }

    public int[] getAvailableVisibilities() throws JavaModelException {
        if (this.fMethod.getDeclaringType().isInterface()) {
            return new int[]{1};
        }
        return new int[]{1, 4, 0, 2};
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public List getExceptionInfos() {
        return this.fExceptionInfos;
    }

    public RefactoringStatus checkSignature() {
        RefactoringStatus result = new RefactoringStatus();
        this.checkForDuplicateParameterNames(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkParameters(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkReturnType(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkMethodName(result);
        return result;
    }

    public boolean isSignatureSameAsInitial() throws JavaModelException {
        if (!this.isVisibilitySameAsInitial()) {
            return false;
        }
        if (!this.isMethodNameSameAsInitial()) {
            return false;
        }
        if (!this.isReturnTypeSameAsInitial()) {
            return false;
        }
        if (!this.areExceptionsSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        return this.areNamesSameAsInitial() && this.isOrderSameAsInitial() && this.areParameterTypesSameAsInitial();
    }

    private boolean areParameterTypesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            return false;
        }
        return true;
    }

    private boolean isReturnTypeSameAsInitial() throws JavaModelException {
        return this.fReturnTypeName.equals(this.getInitialReturnTypeName());
    }

    private boolean isMethodNameSameAsInitial() {
        return this.fMethodName.equals(this.getInitialMethodName());
    }

    private boolean areExceptionsSameAsInitial() {
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isOld()) continue;
            return false;
        }
        return true;
    }

    private void checkParameters(RefactoringStatus result) {
        int i = 1;
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) {
                this.checkParameterName(result, info, i);
                if (result.hasFatalError()) {
                    return;
                }
                this.checkParameterType(result, info);
                if (result.hasFatalError()) {
                    return;
                }
                if (info.isAdded()) {
                    this.checkParameterDefaultValue(result, info);
                }
            }
            ++i;
        }
    }

    private void checkParameterName(RefactoringStatus result, ParameterInfo info, int position) {
        if (info.getNewName().trim().length() == 0) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.param_name_not_empty", Integer.toString(position)));
        } else {
            result.merge(Checks.checkTempName(info.getNewName()));
        }
    }

    private void checkReturnType(RefactoringStatus result) {
        if ("".equals(this.fReturnTypeName.trim())) {
            String msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.return_type_not_empty");
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidTypeName(this.fReturnTypeName, true)) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_return_type", new String[]{this.fReturnTypeName});
            result.addFatalError(msg);
        }
    }

    private void checkMethodName(RefactoringStatus result) {
        if (this.isMethodNameSameAsInitial() || !this.canChangeNameAndReturnType()) {
            return;
        }
        if ("".equals(this.fMethodName.trim())) {
            String msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.method_name_not_empty");
            result.addFatalError(msg);
            return;
        }
        if (this.fMethodName.equals(this.fMethod.getDeclaringType().getElementName())) {
            String msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.constructor_name");
            result.addWarning(msg);
        }
        result.merge(Checks.checkMethodName(this.fMethodName));
    }

    private void checkParameterDefaultValue(RefactoringStatus result, ParameterInfo info) {
        if (info.getDefaultValue().trim().equals("")) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.default_value", new String[]{info.getNewName()});
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidExpression(info.getDefaultValue())) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_expression", new String[]{info.getDefaultValue()});
            result.addFatalError(msg);
        }
    }

    private void checkParameterType(RefactoringStatus result, ParameterInfo info) {
        if (!info.isAdded() && !info.isTypeNameChanged()) {
            return;
        }
        if (info.getNewTypeName().trim().equals("")) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.parameter_type", new String[]{info.getNewName()});
            if (info.isAdded() && info.getNewName().trim().equals("")) {
                msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.new_parameter");
            }
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidTypeName(info.getNewTypeName(), false)) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_type_name", new String[]{info.getNewTypeName()});
            result.addFatalError(msg);
        }
    }

    private static boolean isValidTypeName(String string, boolean isVoidAllowed) {
        if ("".equals(string.trim())) {
            return false;
        }
        if (!string.trim().equals(string)) {
            return false;
        }
        if (PrimitiveType.toCode((String)string) == PrimitiveType.VOID) {
            return isVoidAllowed;
        }
        if (!Checks.checkTypeName(string).hasFatalError()) {
            return true;
        }
        if (ChangeSignatureRefactoring.isPrimitiveTypeName(string)) {
            return true;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_CLASS_DECL);
        int offset = cuBuff.length();
        cuBuff.append(string).append(CONST_ASSIGN).append("null").append(CONST_CLOSE);
        ASTParser p = ASTParser.newParser((int)2);
        p.setSource(cuBuff.toString().toCharArray());
        CompilationUnit cu = (CompilationUnit)p.createAST(null);
        Selection selection = Selection.createFromStartLength(offset, string.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        if (!(selected instanceof Type)) {
            return false;
        }
        Type type = (Type)selected;
        if (ChangeSignatureRefactoring.isVoidArrayType(type)) {
            return false;
        }
        return string.equals(cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)type)));
    }

    public static boolean isValidParameterTypeName(String string) {
        return ChangeSignatureRefactoring.isValidTypeName(string, false);
    }

    private static boolean isVoidArrayType(Type type) {
        if (!type.isArrayType()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)type;
        if (!arrayType.getComponentType().isPrimitiveType()) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)arrayType.getComponentType();
        return primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID;
    }

    public static boolean isValidExpression(String string) {
        String trimmed = string.trim();
        if ("".equals(trimmed)) {
            return false;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_CLASS_DECL).append("Object").append(CONST_ASSIGN);
        int offset = cuBuff.length();
        cuBuff.append(trimmed).append(CONST_CLOSE);
        ASTParser p = ASTParser.newParser((int)2);
        p.setSource(cuBuff.toString().toCharArray());
        CompilationUnit cu = (CompilationUnit)p.createAST(null);
        Selection selection = Selection.createFromStartLength(offset, trimmed.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        return selected instanceof Expression && trimmed.equals(cuBuff.substring(cu.getExtendedStartPosition(selected), cu.getExtendedStartPosition(selected) + cu.getExtendedLength(selected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 5);
            RefactoringStatus result = Checks.checkIfCuBroken((IMember)this.fMethod);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IMethod orig = (IMethod)WorkingCopyUtil.getOriginal((IMember)this.fMethod);
            if (orig == null || !orig.exists()) {
                String message = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.method_deleted", this.getCu().getElementName());
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)message);
                return refactoringStatus;
            }
            this.fMethod = orig;
            if (MethodChecks.isVirtual(this.fMethod) && !this.fMethod.getDeclaringType().isInterface()) {
                result.merge(MethodChecks.checkIfComesFromInterface(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            }
            if (this.fMethod.getDeclaringType().isInterface()) {
                result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fBaseCuRewrite = new CompilationUnitRewrite(this.getCu());
            pm.worked(1);
            result.merge(this.createExceptionInfoList());
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus createExceptionInfoList() {
        this.fExceptionInfos = new ArrayList(0);
        try {
            IJavaProject project = this.fMethod.getJavaProject();
            ASTNode nameNode = NodeFinder.perform((ASTNode)this.fBaseCuRewrite.getRoot(), this.fMethod.getNameRange());
            if (nameNode == null || !(nameNode instanceof Name) || !(nameNode.getParent() instanceof MethodDeclaration)) {
                return null;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)nameNode.getParent();
            List exceptions = methodDeclaration.thrownExceptions();
            ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>(exceptions.size());
            for (int i = 0; i < exceptions.size(); ++i) {
                Name name = (Name)exceptions.get(i);
                ITypeBinding typeBinding = name.resolveTypeBinding();
                if (typeBinding == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeSignatureRefactoring.no_exception_binding"));
                }
                IType type = Bindings.findType(typeBinding, project);
                result.add(ExceptionInfo.createInfoForOldException(type, typeBinding));
            }
            this.fExceptionInfos = result;
            return null;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 8);
            RefactoringStatus result = new RefactoringStatus();
            this.clearManagers();
            this.fBaseCuRewrite.clearASTAndImportRewrites();
            if (this.isSignatureSameAsInitial()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeSignatureRefactoring.unchanged"));
                return refactoringStatus;
            }
            result.merge(this.checkSignature());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fRippleMethods = RippleMethodFinder.getRelatedMethods(this.fMethod, (IProgressMonitor)new SubProgressMonitor(pm, 1), null);
            this.fOccurrences = this.findOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            result.merge(this.checkVisibilityChanges());
            if (!this.isOrderSameAsInitial()) {
                result.merge(this.checkReorderings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            if (!this.areNamesSameAsInitial()) {
                result.merge(this.checkRenamings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkAndResolveTypes((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            if (this.mustAnalyzeAstOfDeclaringCu()) {
                result.merge(this.checkCompilationofDeclaringCu());
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.validateModifiesFiles());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void clearManagers() {
        this.fChangeManager = null;
    }

    private RefactoringStatus checkAndResolveTypes(IProgressMonitor pm) throws CoreException {
        String typeName;
        RefactoringStatus result = new RefactoringStatus();
        List notDeletedParams = this.getNotDeletedInfos();
        pm.beginTask("", notDeletedParams.size() + 1);
        Iterator iter = notDeletedParams.iterator();
        while (iter.hasNext()) {
            String typeName2;
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isTypeNameChanged() && !info.isAdded() || ChangeSignatureRefactoring.isPrimitiveTypeName(typeName2 = ChangeSignatureRefactoring.getElementTypeName(info.getNewTypeName()))) continue;
            String qualifiedTypeName = this.resolveType(typeName2, result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            info.setNewTypeName(this.getFullTypeName(info.getNewTypeName(), qualifiedTypeName));
        }
        if (!this.isReturnTypeSameAsInitial() && !ChangeSignatureRefactoring.isPrimitiveTypeName(typeName = ChangeSignatureRefactoring.getElementTypeName(this.fReturnTypeName))) {
            String qualifiedTypeName = this.resolveType(typeName, result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.fReturnTypeName = this.getFullTypeName(this.fReturnTypeName, qualifiedTypeName);
        }
        pm.done();
        return result;
    }

    private String resolveType(String elementTypeName, RefactoringStatus status, IProgressMonitor pm) throws CoreException {
        List typeRefsFound;
        String[][] fqns = this.getMethod().getDeclaringType().resolveType(elementTypeName);
        if (fqns != null) {
            if (fqns.length == 1) {
                return JavaModelUtil.concatenateName(fqns[0][0], fqns[0][1]);
            }
            if (fqns.length > 1) {
                String[] keys = new String[]{elementTypeName, String.valueOf(fqns.length)};
                String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.ambiguous", keys);
                status.addError(msg);
                return elementTypeName;
            }
        }
        if ((typeRefsFound = this.findTypeInfos(elementTypeName, pm)).size() == 0) {
            String[] keys = new String[]{elementTypeName};
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.not_unique", keys);
            status.addError(msg);
            return elementTypeName;
        }
        if (typeRefsFound.size() == 1) {
            TypeInfo typeInfo = (TypeInfo)typeRefsFound.get(0);
            return typeInfo.getFullyQualifiedName();
        }
        Assert.isTrue(typeRefsFound.size() > 1);
        String[] keys = new String[]{elementTypeName, String.valueOf(typeRefsFound.size())};
        String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.ambiguous", keys);
        status.addError(msg);
        return elementTypeName;
    }

    private String getFullTypeName(String typeName, String qualifiedName) {
        int dimStart = typeName.indexOf(91);
        if (dimStart != -1) {
            return qualifiedName + typeName.substring(dimStart);
        }
        return qualifiedName;
    }

    private List findTypeInfos(String typeName, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{this.getMethod().getJavaProject()}, (boolean)true);
        IPackageFragment currPackage = this.getMethod().getDeclaringType().getPackageFragment();
        TypeInfo[] infos = AllTypesCache.getTypesForName(typeName, scope, pm);
        ArrayList<TypeInfo> typeRefsFound = new ArrayList<TypeInfo>();
        for (int i = 0; i < infos.length; ++i) {
            TypeInfo curr = infos[i];
            IType type = curr.resolveType(scope);
            if (type == null || !JavaModelUtil.isVisible((IMember)type, currPackage)) continue;
            typeRefsFound.add(curr);
        }
        return typeRefsFound;
    }

    private static boolean isPrimitiveTypeName(String typeName) {
        return PrimitiveType.toCode((String)typeName) != null;
    }

    private static String getElementTypeName(String typeName) {
        if (typeName.indexOf(91) != -1) {
            typeName = typeName.substring(0, typeName.indexOf(91));
        }
        return typeName.trim();
    }

    private RefactoringStatus checkVisibilityChanges() throws JavaModelException {
        if (this.isVisibilitySameAsInitial()) {
            return null;
        }
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        Assert.isTrue(this.getInitialMethodVisibility() != 2);
        if (this.fVisibility == 2) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.getString("ChangeSignatureRefactoring.non-virtual"));
        }
        return null;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getPreviewOfVisibityString());
        if (Flags.isStatic((int)this.getMethod().getFlags())) {
            buff.append("static ");
        }
        if (!this.getMethod().isConstructor()) {
            buff.append(this.getReturnTypeString()).append(' ');
        }
        buff.append(this.getMethodName()).append('(').append(this.getMethodParameters()).append(')');
        buff.append(this.getMethodThrows());
        return buff.toString();
    }

    private String getPreviewOfVisibityString() {
        String visibilityString = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(visibilityString)) {
            return visibilityString;
        }
        return visibilityString + ' ';
    }

    private String getMethodThrows() {
        String throwsString = " throws ";
        StringBuffer buff = new StringBuffer(" throws ");
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isDeleted()) continue;
            buff.append(info.getType().getElementName());
            buff.append(", ");
        }
        if (buff.length() == " throws ".length()) {
            return "";
        }
        buff.delete(buff.length() - 2, buff.length());
        return buff.toString();
    }

    private void checkForDuplicateParameterNames(RefactoringStatus result) {
        HashSet<String> found = new HashSet<String>();
        HashSet<String> doubled = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            String newName = info.getNewName();
            if (found.contains(newName) && !doubled.contains(newName)) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.duplicate_name", newName));
                doubled.add(newName);
                continue;
            }
            found.add(newName);
        }
    }

    private ICompilationUnit getCu() {
        return this.fMethod.getCompilationUnit();
    }

    private boolean mustAnalyzeAstOfDeclaringCu() throws JavaModelException {
        if (JdtFlags.isAbstract((IMember)this.getMethod())) {
            return false;
        }
        if (JdtFlags.isNative((IMember)this.getMethod())) {
            return false;
        }
        return !this.getMethod().getDeclaringType().isInterface();
    }

    private RefactoringStatus checkCompilationofDeclaringCu() throws CoreException {
        ICompilationUnit cu = this.getCu();
        TextChange change = this.fChangeManager.get(cu);
        String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser p = ASTParser.newParser((int)2);
        p.setSource(newCuSource.toCharArray());
        p.setUnitName(cu.getElementName());
        p.setProject(cu.getJavaProject());
        p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)cu));
        CompilationUnit newCUNode = (CompilationUnit)p.createAST(null);
        IProblem[] problems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fBaseCuRewrite.getRoot());
        RefactoringStatus result = new RefactoringStatus();
        for (int i = 0; i < problems.length; ++i) {
            IProblem problem = problems[i];
            if (!ChangeSignatureRefactoring.shouldReport(problem)) continue;
            result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
        }
        return result;
    }

    private static boolean shouldReport(IProblem problem) {
        if (!problem.isError()) {
            return false;
        }
        return problem.getID() != 67109234;
    }

    public String getReturnTypeString() {
        return this.fReturnTypeName;
    }

    private String getMethodParameters() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureRefactoring.createDeclarationString(info));
            ++i;
        }
        return buff.toString();
    }

    private List getDeletedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private List getNotDeletedInfos() {
        ArrayList all = new ArrayList(this.fParameterInfos);
        all.removeAll(this.getDeletedInfos());
        return all;
    }

    private boolean areNamesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isRenamed()) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderSameAsInitial() {
        int i = 0;
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.getOldIndex() != i) {
                return false;
            }
            if (info.isDeleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringStatus checkReorderings(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 1);
            RefactoringStatus refactoringStatus = this.checkNativeMethods();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringStatus checkRenamings(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 1);
            RefactoringStatus refactoringStatus = this.checkParameterNamesInRippleMethods();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkParameterNamesInRippleMethods() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        Set newParameterNames = this.getNewParameterNamesList();
        for (int i = 0; i < this.fRippleMethods.length; ++i) {
            String[] paramNames = this.fRippleMethods[i].getParameterNames();
            for (int j = 0; j < paramNames.length; ++j) {
                if (!newParameterNames.contains(paramNames[j])) continue;
                String[] args = new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), paramNames[j]};
                String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.already_has", args);
                RefactoringStatusContext context = JavaStatusContext.create(this.fRippleMethods[i].getCompilationUnit(), this.fRippleMethods[i].getNameRange());
                result.addError(msg, context);
            }
        }
        return result;
    }

    private Set getNewParameterNamesList() {
        Set oldNames = this.getOriginalParameterNames();
        Set currentNames = this.getNamesOfNotDeletedParameters();
        currentNames.removeAll(oldNames);
        return currentNames;
    }

    private Set getNamesOfNotDeletedParameters() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            result.add(info.getNewName());
        }
        return result;
    }

    private Set getOriginalParameterNames() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded()) continue;
            result.add(info.getOldName());
        }
        return result;
    }

    private RefactoringStatus checkNativeMethods() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        for (int i = 0; i < this.fRippleMethods.length; ++i) {
            if (!JdtFlags.isNative((IMember)this.fRippleMethods[i])) continue;
            String message = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.native", new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), JavaModelUtil.getFullyQualifiedName(this.fRippleMethods[i].getDeclaringType())});
            result.addError(message, JavaStatusContext.create((IMember)this.fRippleMethods[i]));
        }
        return result;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) {
        pm.beginTask("", 1);
        try {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.restructure_parameters"), (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
            this.clearManagers();
        }
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus result) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.preview"), 2);
        TextChangeManager manager = new TextChangeManager();
        boolean isNoArgConstructor = this.isNoArgConstructor();
        Map namedSubclassMapping = null;
        if (isNoArgConstructor) {
            namedSubclassMapping = this.createNamedSubclassMapping((IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            pm.worked(1);
        }
        for (int i = 0; i < this.fOccurrences.length; ++i) {
            TextChange change;
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            SearchResultGroup group = this.fOccurrences[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu == null) continue;
            CompilationUnitRewrite cuRewrite = cu.equals(this.getCu()) ? this.fBaseCuRewrite : new CompilationUnitRewrite(cu);
            ASTNode[] nodes = ASTNodeSearchUtil.findNodes(group.getSearchResults(), cuRewrite.getRoot());
            for (int j = 0; j < nodes.length; ++j) {
                this.createOccurrenceUpdate(nodes[j], cuRewrite, result).updateNode();
            }
            if (isNoArgConstructor && namedSubclassMapping.containsKey(cu)) {
                Set subtypes = (Set)namedSubclassMapping.get(cu);
                Iterator iter = subtypes.iterator();
                while (iter.hasNext()) {
                    IType subtype = (IType)iter.next();
                    TypeDeclaration subtypeNode = ASTNodeSearchUtil.getTypeDeclarationNode(subtype, cuRewrite.getRoot());
                    if (subtypeNode == null) continue;
                    this.modifyImplicitCallsToNoArgConstructor(subtypeNode, cuRewrite);
                }
            }
            if ((change = cuRewrite.createChange()) == null) continue;
            manager.manage(cu, change);
        }
        pm.done();
        return manager;
    }

    private Map createNamedSubclassMapping(IProgressMonitor pm) throws JavaModelException {
        IType[] subclasses = this.getSubclasses(pm);
        HashMap result = new HashMap();
        for (int i = 0; i < subclasses.length; ++i) {
            IType subclass = subclasses[i];
            if (subclass.isAnonymous()) continue;
            ICompilationUnit cu = subclass.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new HashSet());
            }
            ((Set)result.get(cu)).add(subclass);
        }
        return result;
    }

    private void modifyImplicitCallsToNoArgConstructor(TypeDeclaration subclass, CompilationUnitRewrite cuRewrite) {
        MethodDeclaration[] constructors = this.getAllConstructors(subclass);
        if (constructors.length == 0) {
            this.addNewConstructorToSubclass(subclass, cuRewrite);
        } else {
            for (int i = 0; i < constructors.length; ++i) {
                if (!ChangeSignatureRefactoring.containsImplicitCallToSuperConstructor(constructors[i])) continue;
                this.addExplicitSuperConstructorCall(constructors[i], cuRewrite);
            }
        }
    }

    private void addExplicitSuperConstructorCall(MethodDeclaration constructor, CompilationUnitRewrite cuRewrite) {
        SuperConstructorInvocation superCall = constructor.getAST().newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superCall, cuRewrite.getASTRewrite());
        String msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.add_super_call");
        TextEditGroup description = cuRewrite.createGroupDescription(msg);
        cuRewrite.getASTRewrite().getListRewrite((ASTNode)constructor.getBody(), Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)superCall, description);
    }

    private void addArgumentsToNewSuperConstructorCall(SuperConstructorInvocation superCall, ASTRewrite rewrite) {
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            superCall.arguments().add(i, ChangeSignatureRefactoring.createNewExpression(rewrite, info));
            ++i;
        }
    }

    private static boolean containsImplicitCallToSuperConstructor(MethodDeclaration constructor) {
        Assert.isTrue(constructor.isConstructor());
        Block body = constructor.getBody();
        if (body == null) {
            return false;
        }
        if (body.statements().size() == 0) {
            return true;
        }
        if (body.statements().get(0) instanceof ConstructorInvocation) {
            return false;
        }
        return !(body.statements().get(0) instanceof SuperConstructorInvocation);
    }

    private void addNewConstructorToSubclass(TypeDeclaration subclass, CompilationUnitRewrite cuRewrite) {
        AST ast = subclass.getAST();
        MethodDeclaration newConstructor = ast.newMethodDeclaration();
        newConstructor.setName(ast.newSimpleName(subclass.getName().getIdentifier()));
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.setModifiers(ChangeSignatureRefactoring.getAccessModifier(subclass));
        newConstructor.setReturnType((Type)ast.newPrimitiveType(PrimitiveType.VOID));
        Block body = ast.newBlock();
        newConstructor.setBody(body);
        SuperConstructorInvocation superCall = ast.newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superCall, cuRewrite.getASTRewrite());
        body.statements().add(superCall);
        String msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.add_constructor");
        TextEditGroup description = cuRewrite.createGroupDescription(msg);
        cuRewrite.getASTRewrite().getListRewrite((ASTNode)subclass, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newConstructor, description);
    }

    private static int getAccessModifier(TypeDeclaration subclass) {
        int modifiers = subclass.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            return 1;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return 4;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return 2;
        }
        return 0;
    }

    private MethodDeclaration[] getAllConstructors(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(1);
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isConstructor()) continue;
            result.add(methods[i]);
        }
        return result.toArray(new MethodDeclaration[result.size()]);
    }

    private IType[] getSubclasses(IProgressMonitor pm) throws JavaModelException {
        return this.fMethod.getDeclaringType().newTypeHierarchy(pm).getSubclasses(this.fMethod.getDeclaringType());
    }

    private boolean isNoArgConstructor() throws JavaModelException {
        return this.fMethod.isConstructor() && this.fMethod.getNumberOfParameters() == 0;
    }

    private static Expression createNewExpression(ASTRewrite rewrite, ParameterInfo info) {
        return (Expression)rewrite.createStringPlaceholder(info.getDefaultValue(), 32);
    }

    private boolean isVisibilitySameAsInitial() throws JavaModelException {
        return this.fVisibility == JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fMethod);
    }

    private SearchResultGroup[] findOccurrences(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        if (this.fMethod.isConstructor()) {
            return ConstructorReferenceFinder.getConstructorOccurrences(this.fMethod, pm, status);
        }
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])this.fRippleMethods, 3);
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), pm, status);
    }

    private static String createDeclarationString(ParameterInfo info) {
        return info.getNewTypeName() + " " + info.getNewName();
    }

    private OccurrenceUpdate createOccurrenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
        if (ChangeSignatureRefactoring.isReferenceNode(node)) {
            return new ReferenceUpdate(node, cuRewrite, result);
        }
        if (node instanceof SimpleName && node.getParent() instanceof MethodDeclaration) {
            return new DeclarationUpdate((MethodDeclaration)node.getParent(), cuRewrite, result);
        }
        if (node instanceof SimpleName && (node.getParent() instanceof MemberRef || node.getParent() instanceof MethodRef)) {
            return new DocReferenceUpdate(node.getParent(), cuRewrite, result);
        }
        return new NullOccurrenceUpdate(node, cuRewrite, result);
    }

    private static boolean isReferenceNode(ASTNode node) {
        switch (node.getNodeType()) {
            case 14: 
            case 17: 
            case 32: 
            case 46: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NullOccurrenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;
        private RefactoringStatus fResult;

        protected NullOccurrenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, null);
            this.fNode = node;
            this.fResult = result;
        }

        public void updateNode() throws JavaModelException {
            int start = this.fNode.getStartPosition();
            int length = this.fNode.getLength();
            String msg = "Cannot update found node: nodeType=" + this.fNode.getNodeType() + "; " + this.fNode.toString() + "[" + start + ", " + length + "]";
            JavaPlugin.log(new Exception(msg + ":\n" + this.fCuRewrite.getCu().getSource().substring(start, start + length)));
            this.fResult.addError(msg, JavaStatusContext.create(this.fCuRewrite.getCu(), this.fNode));
        }

        protected ListRewrite getParamgumentsRewrite() {
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo info) {
            return null;
        }

        protected SimpleName getMethodNameNode() {
            return null;
        }
    }

    class DocReferenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected DocReferenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, cuRewrite.createGroupDescription(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.update_javadoc_reference")));
            this.fNode = node;
        }

        public void updateNode() {
            if (this.fNode instanceof MethodRef) {
                this.changeParamguments();
                this.reshuffleElements();
            }
            if (ChangeSignatureRefactoring.this.canChangeNameAndReturnType()) {
                this.changeMethodName();
            }
        }

        protected ASTNode createNewParamgument(ParameterInfo info) {
            return this.createNewMethodRefParameter(info);
        }

        private MethodRefParameter createNewMethodRefParameter(ParameterInfo info) {
            MethodRefParameter newP = this.getASTRewrite().getAST().newMethodRefParameter();
            List parameters = this.getParamgumentsRewrite().getOriginalList();
            if (parameters.size() > 0 && ((MethodRefParameter)parameters.get(0)).getName() != null) {
                newP.setName(this.getASTRewrite().getAST().newSimpleName(info.getNewName()));
            }
            newP.setType(this.createNewTypeNode(info.getNewTypeName()));
            return newP;
        }

        protected SimpleName getMethodNameNode() {
            if (this.fNode instanceof MemberRef) {
                return ((MemberRef)this.fNode).getName();
            }
            if (this.fNode instanceof MethodRef) {
                return ((MethodRef)this.fNode).getName();
            }
            return null;
        }

        protected ListRewrite getParamgumentsRewrite() {
            return this.getASTRewrite().getListRewrite(this.fNode, MethodRef.PARAMETERS_PROPERTY);
        }

        protected void changeParamgumentName(ParameterInfo info) {
            if (!(this.fNode instanceof MethodRef)) {
                return;
            }
            MethodRefParameter oldParam = (MethodRefParameter)((MethodRef)this.fNode).parameters().get(info.getOldIndex());
            SimpleName oldParamName = oldParam.getName();
            if (oldParamName != null) {
                this.getASTRewrite().set((ASTNode)oldParamName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)info.getNewName(), this.fDescription);
            }
        }

        protected void changeParamgumentType(ParameterInfo info) {
            if (!(this.fNode instanceof MethodRef)) {
                return;
            }
            MethodRefParameter oldParam = (MethodRefParameter)((MethodRef)this.fNode).parameters().get(info.getOldIndex());
            this.replaceTypeNode(oldParam.getType(), info.getNewTypeName());
        }
    }

    class DeclarationUpdate
    extends OccurrenceUpdate {
        private MethodDeclaration fMethDecl;
        private RefactoringStatus fResult;

        protected DeclarationUpdate(MethodDeclaration decl, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, cuRewrite.createGroupDescription(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.change_signature")));
            this.fMethDecl = decl;
            this.fResult = result;
        }

        public void updateNode() throws JavaModelException {
            this.changeParamguments();
            if (ChangeSignatureRefactoring.this.canChangeNameAndReturnType()) {
                this.changeMethodName();
                this.changeReturnType();
            }
            if (this.needsVisibilityUpdate()) {
                this.changeVisibility();
            }
            this.reshuffleElements();
            this.changeExceptions();
            this.changeJavadocTags();
            this.checkIfDeletedParametersUsed();
        }

        protected ListRewrite getParamgumentsRewrite() {
            return this.getASTRewrite().getListRewrite((ASTNode)this.fMethDecl, MethodDeclaration.PARAMETERS_PROPERTY);
        }

        protected void changeParamgumentName(ParameterInfo info) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)this.fMethDecl.parameters().get(info.getOldIndex());
            if (!info.getOldName().equals(param.getName().getIdentifier())) {
                return;
            }
            String msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.update_parameter_references");
            TextEditGroup description = this.fCuRewrite.createGroupDescription(msg);
            TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer((VariableDeclaration)param, false);
            analyzer.perform();
            SimpleName[] paramOccurrences = analyzer.getReferenceAndDeclarationNodes();
            for (int j = 0; j < paramOccurrences.length; ++j) {
                SimpleName occurence = paramOccurrences[j];
                this.getASTRewrite().set((ASTNode)occurence, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)info.getNewName(), description);
            }
        }

        protected void changeParamgumentType(ParameterInfo info) {
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)this.fMethDecl.parameters().get(info.getOldIndex());
            this.replaceTypeNode(oldParam.getType(), info.getNewTypeName());
            this.removeExtraDimensions(oldParam);
        }

        private void removeExtraDimensions(SingleVariableDeclaration oldParam) {
            if (oldParam.getExtraDimensions() != 0) {
                this.getASTRewrite().set((ASTNode)oldParam, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), this.fDescription);
            }
        }

        private void changeReturnType() throws JavaModelException {
            if (ChangeSignatureRefactoring.this.isReturnTypeSameAsInitial()) {
                return;
            }
            this.replaceTypeNode(this.fMethDecl.getReturnType(), ChangeSignatureRefactoring.this.fReturnTypeName);
            this.removeExtraDimensions(this.fMethDecl);
        }

        private void removeExtraDimensions(MethodDeclaration methDecl) {
            if (methDecl.getExtraDimensions() != 0) {
                this.getASTRewrite().set((ASTNode)methDecl, (StructuralPropertyDescriptor)MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), this.fDescription);
            }
        }

        private boolean needsVisibilityUpdate() throws JavaModelException {
            if (ChangeSignatureRefactoring.this.isVisibilitySameAsInitial()) {
                return false;
            }
            if (this.isIncreasingVisibility()) {
                return JdtFlags.isHigherVisibility(ChangeSignatureRefactoring.this.fVisibility, JdtFlags.getVisibilityCode((BodyDeclaration)this.fMethDecl));
            }
            return JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((BodyDeclaration)this.fMethDecl), ChangeSignatureRefactoring.this.fVisibility);
        }

        private boolean isIncreasingVisibility() throws JavaModelException {
            return JdtFlags.isHigherVisibility(ChangeSignatureRefactoring.this.fVisibility, JdtFlags.getVisibilityCode((IMember)ChangeSignatureRefactoring.this.fMethod));
        }

        private void changeVisibility() {
            int newModifiers = JdtFlags.clearAccessModifiers(this.fMethDecl.getModifiers()) | ChangeSignatureRefactoring.this.fVisibility;
            this.getASTRewrite().set((ASTNode)this.fMethDecl, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), this.fDescription);
        }

        private void changeExceptions() {
            Iterator iter = ChangeSignatureRefactoring.this.fExceptionInfos.iterator();
            while (iter.hasNext()) {
                ExceptionInfo info = (ExceptionInfo)iter.next();
                if (info.isOld()) continue;
                if (info.isDeleted()) {
                    this.removeExceptionFromNodeList(info, this.fMethDecl.thrownExceptions());
                    continue;
                }
                this.addExceptionToNodeList(info, this.getASTRewrite().getListRewrite((ASTNode)this.fMethDecl, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY));
            }
        }

        private void removeExceptionFromNodeList(ExceptionInfo toRemove, List exceptionsNodeList) {
            ITypeBinding typeToRemove = toRemove.getTypeBinding();
            Iterator iter = exceptionsNodeList.iterator();
            while (iter.hasNext()) {
                Name currentName = (Name)iter.next();
                ITypeBinding currentType = currentName.resolveTypeBinding();
                if (currentType == null || !Bindings.equals((IBinding)typeToRemove, (IBinding)currentType)) continue;
                this.getASTRewrite().remove((ASTNode)currentName, this.fDescription);
                this.getImportRemover().registerRemovedNode((ASTNode)currentName);
            }
        }

        private void addExceptionToNodeList(ExceptionInfo exceptionInfo, ListRewrite exceptionListRewrite) {
            String fullyQualified = JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType());
            Iterator iter = exceptionListRewrite.getOriginalList().iterator();
            while (iter.hasNext()) {
                Name exName = (Name)iter.next();
                ITypeBinding typeBinding = exName.resolveTypeBinding();
                if (typeBinding == null || !typeBinding.getQualifiedName().equals(fullyQualified)) continue;
                return;
            }
            String importedType = this.getImportRewrite().addImport(JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType()));
            this.getImportRemover().registerAddedImport(importedType);
            ASTNode exNode = this.getASTRewrite().createStringPlaceholder(importedType, 42);
            exceptionListRewrite.insertLast(exNode, this.fDescription);
        }

        private void changeJavadocTags() throws JavaModelException {
            TagElement movedTag;
            Iterator iter;
            Iterator infoIter;
            TagElement tag;
            TagElement previousTag;
            Javadoc javadoc = this.fMethDecl.getJavadoc();
            if (javadoc == null) {
                return;
            }
            ITypeBinding typeBinding = Bindings.getBindingOfParentType((ASTNode)this.fMethDecl);
            if (typeBinding == null) {
                return;
            }
            IMethodBinding methodBinding = this.fMethDecl.resolveBinding();
            if (methodBinding == null) {
                return;
            }
            boolean isTopOfRipple = null == Bindings.findDeclarationInHierarchy(typeBinding, methodBinding.getName(), methodBinding.getParameterTypes());
            List tags = javadoc.tags();
            ListRewrite tagsRewrite = this.getASTRewrite().getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            if (!ChangeSignatureRefactoring.this.isReturnTypeSameAsInitial()) {
                if (PrimitiveType.VOID.toString().equals(ChangeSignatureRefactoring.this.fReturnTypeName)) {
                    for (int i = 0; i < tags.size(); ++i) {
                        TagElement tag2 = (TagElement)tags.get(i);
                        if (!"@return".equals(tag2.getTagName())) continue;
                        this.getASTRewrite().remove((ASTNode)tag2, this.fDescription);
                        this.getImportRemover().registerRemovedNode((ASTNode)tag2);
                    }
                } else if (isTopOfRipple && "V".equals(ChangeSignatureRefactoring.this.fMethod.getReturnType())) {
                    TagElement returnNode = this.createReturnTag();
                    previousTag = this.findTagElementToInsertAfter(tags, "@return");
                    this.insertTag(returnNode, previousTag, tagsRewrite);
                    tags = tagsRewrite.getRewrittenList();
                }
            }
            if (!ChangeSignatureRefactoring.this.areNamesSameAsInitial() || !ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                ArrayList<TagElement> paramTags = new ArrayList<TagElement>();
                Iterator iter2 = tags.iterator();
                while (iter2.hasNext()) {
                    tag = (TagElement)iter2.next();
                    String tagName = tag.getTagName();
                    List fragments = tag.fragments();
                    if (!"@param".equals(tagName) || fragments.size() <= 0 || !(fragments.get(0) instanceof SimpleName)) continue;
                    SimpleName simpleName = (SimpleName)fragments.get(0);
                    String identifier = simpleName.getIdentifier();
                    boolean removed = false;
                    for (int i = 0; i < ChangeSignatureRefactoring.this.fParameterInfos.size(); ++i) {
                        ParameterInfo info = (ParameterInfo)ChangeSignatureRefactoring.this.fParameterInfos.get(i);
                        if (!identifier.equals(info.getOldName())) continue;
                        if (info.isDeleted()) {
                            this.getASTRewrite().remove((ASTNode)tag, this.fDescription);
                            this.getImportRemover().registerRemovedNode((ASTNode)tag);
                            removed = true;
                            break;
                        }
                        if (!info.isRenamed()) break;
                        SimpleName newName = simpleName.getAST().newSimpleName(info.getNewName());
                        this.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)newName, this.fDescription);
                        this.getImportRemover().registerRemovedNode((ASTNode)simpleName);
                        break;
                    }
                    if (removed) continue;
                    paramTags.add(tag);
                }
                tags = tagsRewrite.getRewrittenList();
                if (!ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                    previousTag = this.findTagElementToInsertAfter(tags, "@param");
                    infoIter = ChangeSignatureRefactoring.this.fParameterInfos.iterator();
                    while (infoIter.hasNext()) {
                        ParameterInfo info = (ParameterInfo)infoIter.next();
                        String oldName = info.getOldName();
                        String newName = info.getNewName();
                        if (info.isAdded()) {
                            if (!isTopOfRipple) continue;
                            TagElement paramNode = JavadocUtil.createParamTag(newName, this.fCuRewrite.getRoot().getAST(), this.fCuRewrite.getCu().getJavaProject());
                            this.insertTag(paramNode, previousTag, tagsRewrite);
                            previousTag = paramNode;
                            continue;
                        }
                        Iterator tagIter = paramTags.iterator();
                        while (tagIter.hasNext()) {
                            TagElement tag3 = (TagElement)tagIter.next();
                            SimpleName tagName = (SimpleName)tag3.fragments().get(0);
                            if (!oldName.equals(tagName.getIdentifier())) continue;
                            tagIter.remove();
                            TagElement movedTag2 = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag3);
                            this.insertTag(movedTag2, previousTag, tagsRewrite);
                            previousTag = movedTag2;
                        }
                    }
                    iter = paramTags.iterator();
                    while (iter.hasNext()) {
                        TagElement tag4 = (TagElement)iter.next();
                        movedTag = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag4);
                        this.insertTag(movedTag, previousTag, tagsRewrite);
                        previousTag = movedTag;
                    }
                }
                tags = tagsRewrite.getRewrittenList();
            }
            if (!ChangeSignatureRefactoring.this.areExceptionsSameAsInitial()) {
                ArrayList<TagElement> exceptionTags = new ArrayList<TagElement>();
                for (int i = 0; i < tags.size(); ++i) {
                    tag = (TagElement)tags.get(i);
                    if (!"@throws".equals(tag.getTagName()) && !"@exception".equals(tag.getTagName()) || tag.fragments().size() <= 0 || !(tag.fragments().get(0) instanceof Name)) continue;
                    boolean tagDeleted = false;
                    Name name = (Name)tag.fragments().get(0);
                    for (int j = 0; j < ChangeSignatureRefactoring.this.fExceptionInfos.size(); ++j) {
                        ExceptionInfo info = (ExceptionInfo)ChangeSignatureRefactoring.this.fExceptionInfos.get(j);
                        if (!info.isDeleted() || !Bindings.equals((IBinding)info.getTypeBinding(), (IBinding)name.resolveTypeBinding())) continue;
                        this.getASTRewrite().remove((ASTNode)tag, this.fDescription);
                        this.getImportRemover().registerRemovedNode((ASTNode)tag);
                        tagDeleted = true;
                        break;
                    }
                    if (tagDeleted) continue;
                    exceptionTags.add(tag);
                }
                tags = tagsRewrite.getRewrittenList();
                TagElement previousTag2 = this.findTagElementToInsertAfter(tags, "@throws");
                infoIter = ChangeSignatureRefactoring.this.fExceptionInfos.iterator();
                while (infoIter.hasNext()) {
                    ExceptionInfo info = (ExceptionInfo)infoIter.next();
                    if (info.isAdded()) {
                        if (!isTopOfRipple) continue;
                        TagElement excptNode = this.createExceptionTag(info.getType().getElementName());
                        this.insertTag(excptNode, previousTag2, tagsRewrite);
                        previousTag2 = excptNode;
                        continue;
                    }
                    Iterator tagIter = exceptionTags.iterator();
                    while (tagIter.hasNext()) {
                        TagElement tag5 = (TagElement)tagIter.next();
                        Name tagName = (Name)tag5.fragments().get(0);
                        if (!Bindings.equals((IBinding)info.getTypeBinding(), (IBinding)tagName.resolveTypeBinding())) continue;
                        tagIter.remove();
                        TagElement movedTag3 = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag5);
                        this.insertTag(movedTag3, previousTag2, tagsRewrite);
                        previousTag2 = movedTag3;
                    }
                }
                iter = exceptionTags.iterator();
                while (iter.hasNext()) {
                    TagElement tag6 = (TagElement)iter.next();
                    movedTag = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag6);
                    this.insertTag(movedTag, previousTag2, tagsRewrite);
                    previousTag2 = movedTag;
                }
            }
        }

        private TagElement createReturnTag() {
            TagElement returnNode = this.getASTRewrite().getAST().newTagElement();
            returnNode.setTagName("@return");
            TextElement textElement = this.getASTRewrite().getAST().newTextElement();
            String text = StubUtility.getTodoTaskTag(this.fCuRewrite.getCu().getJavaProject());
            if (text != null) {
                textElement.setText(text);
            }
            returnNode.fragments().add(textElement);
            return returnNode;
        }

        private TagElement createExceptionTag(String simpleName) {
            TagElement excptNode = this.getASTRewrite().getAST().newTagElement();
            excptNode.setTagName("@throws");
            SimpleName nameNode = this.getASTRewrite().getAST().newSimpleName(simpleName);
            excptNode.fragments().add(nameNode);
            TextElement textElement = this.getASTRewrite().getAST().newTextElement();
            String text = StubUtility.getTodoTaskTag(this.fCuRewrite.getCu().getJavaProject());
            if (text != null) {
                textElement.setText(text);
            }
            excptNode.fragments().add(textElement);
            return excptNode;
        }

        private void insertTag(TagElement tag, TagElement previousTag, ListRewrite tagsRewrite) {
            if (previousTag == null) {
                tagsRewrite.insertFirst((ASTNode)tag, this.fDescription);
            } else {
                tagsRewrite.insertAfter((ASTNode)tag, (ASTNode)previousTag, this.fDescription);
            }
        }

        private TagElement findTagElementToInsertAfter(List tags, String tagName) {
            List<String> tagOrder = Arrays.asList("@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated", "@value");
            int goalOrdinal = tagOrder.indexOf(tagName);
            if (goalOrdinal == -1) {
                return tags.size() == 0 ? null : (TagElement)tags.get(tags.size());
            }
            for (int i = 0; i < tags.size(); ++i) {
                int tagOrdinal = tagOrder.indexOf(((TagElement)tags.get(i)).getTagName());
                if (tagOrdinal < goalOrdinal) continue;
                return i == 0 ? null : (TagElement)tags.get(i - 1);
            }
            return tags.size() == 0 ? null : (TagElement)tags.get(tags.size() - 1);
        }

        private void checkIfDeletedParametersUsed() {
            String typeName = this.getFullTypeName(this.fMethDecl);
            Iterator iter = ChangeSignatureRefactoring.this.getDeletedInfos().iterator();
            while (iter.hasNext()) {
                ParameterInfo info = (ParameterInfo)iter.next();
                SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)this.fMethDecl.parameters().get(info.getOldIndex());
                TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer((VariableDeclaration)paramDecl, false);
                analyzer.perform();
                SimpleName[] paramRefs = analyzer.getReferenceNodes();
                if (paramRefs.length <= 0) continue;
                RefactoringStatusContext context = JavaStatusContext.create(this.fCuRewrite.getCu(), (ASTNode)paramRefs[0]);
                Object[] keys = new String[]{paramDecl.getName().getIdentifier(), this.fMethDecl.getName().getIdentifier(), typeName};
                String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.parameter_used", keys);
                this.fResult.addError(msg, context);
            }
        }

        private String getFullTypeName(MethodDeclaration decl) {
            TypeDeclaration typeDecl = (TypeDeclaration)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = ChangeSignatureRefactoring.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration);
            AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration == null ? (class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration = ChangeSignatureRefactoring.class$("org.eclipse.jdt.core.dom.AnonymousClassDeclaration")) : class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration);
            if (anonymous != null && ASTNodes.isParent((ASTNode)typeDecl, (ASTNode)anonymous)) {
                ClassInstanceCreation cic = (ClassInstanceCreation)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$ClassInstanceCreation == null ? (class$org$eclipse$jdt$core$dom$ClassInstanceCreation = ChangeSignatureRefactoring.class$("org.eclipse.jdt.core.dom.ClassInstanceCreation")) : class$org$eclipse$jdt$core$dom$ClassInstanceCreation);
                return RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.anonymous_subclass", new String[]{ASTNodes.asString((ASTNode)cic.getName())});
            }
            return typeDecl.getName().getIdentifier();
        }

        protected ASTNode createNewParamgument(ParameterInfo info) {
            return this.createNewSingleVariableDeclaration(info);
        }

        private SingleVariableDeclaration createNewSingleVariableDeclaration(ParameterInfo info) {
            SingleVariableDeclaration newP = this.getASTRewrite().getAST().newSingleVariableDeclaration();
            newP.setName(this.getASTRewrite().getAST().newSimpleName(info.getNewName()));
            newP.setType(this.createNewTypeNode(info.getNewTypeName()));
            return newP;
        }

        protected SimpleName getMethodNameNode() {
            return this.fMethDecl.getName();
        }
    }

    class ReferenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected ReferenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, cuRewrite.createGroupDescription(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.update_reference")));
            this.fNode = node;
        }

        public void updateNode() {
            this.reshuffleElements();
            this.changeMethodName();
        }

        protected ListRewrite getParamgumentsRewrite() {
            if (this.fNode instanceof MethodInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, MethodInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, SuperMethodInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof ClassInstanceCreation) {
                return this.getASTRewrite().getListRewrite(this.fNode, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof ConstructorInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, ConstructorInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof SuperConstructorInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, SuperConstructorInvocation.ARGUMENTS_PROPERTY);
            }
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo info) {
            if (this.isRecursiveReference()) {
                return this.createNewExpressionRecursive(info);
            }
            return ChangeSignatureRefactoring.createNewExpression(this.getASTRewrite(), info);
        }

        private Expression createNewExpressionRecursive(ParameterInfo info) {
            return (Expression)this.getASTRewrite().createStringPlaceholder(info.getNewName(), 32);
        }

        protected SimpleName getMethodNameNode() {
            if (this.fNode instanceof MethodInvocation) {
                return ((MethodInvocation)this.fNode).getName();
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                return ((SuperMethodInvocation)this.fNode).getName();
            }
            return null;
        }

        private boolean isRecursiveReference() {
            MethodDeclaration enclosingMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(this.fNode, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = ChangeSignatureRefactoring.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
            if (enclosingMethodDeclaration == null) {
                return false;
            }
            IMethodBinding enclosingMethodBinding = enclosingMethodDeclaration.resolveBinding();
            if (this.fNode instanceof MethodInvocation) {
                return enclosingMethodBinding == ((MethodInvocation)this.fNode).resolveMethodBinding();
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                IMethodBinding methodBinding = ((SuperMethodInvocation)this.fNode).resolveMethodBinding();
                return this.isSameMethod(methodBinding, enclosingMethodBinding);
            }
            if (this.fNode instanceof ClassInstanceCreation) {
                return enclosingMethodBinding == ((ClassInstanceCreation)this.fNode).resolveConstructorBinding();
            }
            if (this.fNode instanceof ConstructorInvocation) {
                return enclosingMethodBinding == ((ConstructorInvocation)this.fNode).resolveConstructorBinding();
            }
            if (this.fNode instanceof SuperConstructorInvocation) {
                return false;
            }
            Assert.isTrue(false);
            return false;
        }

        private boolean isSameMethod(IMethodBinding m1, IMethodBinding m2) {
            if (m1.isConstructor() ? !m2.isConstructor() : !m1.getName().equals(m2.getName())) {
                return false;
            }
            return Bindings.equals((IBinding[])m1.getParameterTypes(), (IBinding[])m2.getParameterTypes());
        }
    }

    abstract class OccurrenceUpdate {
        protected final CompilationUnitRewrite fCuRewrite;
        protected final TextEditGroup fDescription;

        protected OccurrenceUpdate(CompilationUnitRewrite cuRewrite, TextEditGroup description) {
            this.fCuRewrite = cuRewrite;
            this.fDescription = description;
        }

        protected final ASTRewrite getASTRewrite() {
            return this.fCuRewrite.getASTRewrite();
        }

        protected final ImportRewrite getImportRewrite() {
            return this.fCuRewrite.getImportRewrite();
        }

        protected final ImportRemover getImportRemover() {
            return this.fCuRewrite.getImportRemover();
        }

        public abstract void updateNode() throws JavaModelException;

        protected final void reshuffleElements() {
            ASTNode node;
            if (ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                return;
            }
            ListRewrite listRewrite = this.getParamgumentsRewrite();
            List nodes = listRewrite.getRewrittenList();
            ArrayList<ASTNode> newNodes = new ArrayList<ASTNode>();
            Iterator iter = ChangeSignatureRefactoring.this.fParameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo info = (ParameterInfo)iter.next();
                if (info.isDeleted()) continue;
                if (info.isAdded()) {
                    newNodes.add(this.createNewParamgument(info));
                    continue;
                }
                ASTNode oldNode = (ASTNode)nodes.get(info.getOldIndex());
                ASTNode movedNode = this.getASTRewrite().createMoveTarget(oldNode);
                newNodes.add(movedNode);
            }
            Iterator nodesIter = nodes.iterator();
            Iterator newIter = newNodes.iterator();
            while (nodesIter.hasNext() && newIter.hasNext()) {
                node = (ASTNode)nodesIter.next();
                ASTNode newNode = (ASTNode)newIter.next();
                listRewrite.replace(node, newNode, this.fDescription);
                this.getImportRemover().registerRemovedNode(node);
            }
            while (nodesIter.hasNext()) {
                node = (ASTNode)nodesIter.next();
                listRewrite.remove(node, this.fDescription);
                this.getImportRemover().registerRemovedNode(node);
            }
            while (newIter.hasNext()) {
                node = (ASTNode)newIter.next();
                listRewrite.insertLast(node, this.fDescription);
            }
        }

        protected abstract ListRewrite getParamgumentsRewrite();

        protected final void changeParamguments() {
            Iterator iter = ChangeSignatureRefactoring.this.getParameterInfos().iterator();
            while (iter.hasNext()) {
                ParameterInfo info = (ParameterInfo)iter.next();
                if (info.isAdded() || info.isDeleted()) continue;
                if (info.isRenamed()) {
                    this.changeParamgumentName(info);
                }
                if (!info.isTypeNameChanged()) continue;
                this.changeParamgumentType(info);
            }
        }

        protected void changeParamgumentName(ParameterInfo info) {
        }

        protected void changeParamgumentType(ParameterInfo info) {
        }

        protected final void replaceTypeNode(Type typeNode, String newTypeName) {
            Type newTypeNode = this.createNewTypeNode(newTypeName);
            this.getASTRewrite().replace((ASTNode)typeNode, (ASTNode)newTypeNode, this.fDescription);
            this.getImportRemover().registerRemovedNode((ASTNode)typeNode);
        }

        protected abstract ASTNode createNewParamgument(ParameterInfo var1);

        protected abstract SimpleName getMethodNameNode();

        protected final void changeMethodName() {
            if (!ChangeSignatureRefactoring.this.isMethodNameSameAsInitial()) {
                SimpleName nameNode = this.getMethodNameNode();
                SimpleName newNameNode = nameNode.getAST().newSimpleName(ChangeSignatureRefactoring.this.fMethodName);
                this.getASTRewrite().replace((ASTNode)nameNode, (ASTNode)newNameNode, this.fDescription);
                this.getImportRemover().registerRemovedNode((ASTNode)nameNode);
            }
        }

        protected final Type createNewTypeNode(String newTypeName) {
            String elementTypeName = ChangeSignatureRefactoring.getElementTypeName(newTypeName);
            String importedTypeName = this.getImportRewrite().addImport(elementTypeName);
            this.getImportRemover().registerAddedImport(importedTypeName);
            int dimensions = this.getArrayDimensions(newTypeName);
            Type newTypeNode = (Type)this.getASTRewrite().createStringPlaceholder(importedTypeName, 43);
            if (dimensions != 0) {
                newTypeNode = this.getASTRewrite().getAST().newArrayType(newTypeNode, dimensions);
            }
            return newTypeNode;
        }

        private int getArrayDimensions(String typeName) {
            int dims = 0;
            for (int i = 0; i < typeName.length(); ++i) {
                if (typeName.charAt(i) != '[') continue;
                ++dims;
            }
            return dims;
        }
    }
}

