/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class SuperTypeHierarchyCache {
    private static final int CACHE_SIZE = 8;
    private static ArrayList fgHierarchyCache = new ArrayList(8);
    private static int fgCacheHits = 0;
    private static int fgCacheMisses = 0;

    public static ITypeHierarchy getTypeHierarchy(IType type) throws JavaModelException {
        return SuperTypeHierarchyCache.getTypeHierarchy(type, null);
    }

    public static ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.findTypeHierarchyInCache(type);
        if (hierarchy == null) {
            ++fgCacheMisses;
            hierarchy = type.newSupertypeHierarchy(progressMonitor);
            SuperTypeHierarchyCache.addTypeHierarchyToCache(hierarchy);
        } else {
            ++fgCacheHits;
        }
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTypeHierarchyToCache(ITypeHierarchy hierarchy) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            int nEntries = fgHierarchyCache.size();
            if (nEntries >= 8) {
                int i;
                HierarchyCacheEntry oldest = null;
                ArrayList<HierarchyCacheEntry> obsoleteHierarchies = new ArrayList<HierarchyCacheEntry>(8);
                for (i = 0; i < nEntries; ++i) {
                    HierarchyCacheEntry entry = (HierarchyCacheEntry)fgHierarchyCache.get(i);
                    ITypeHierarchy curr = entry.getTypeHierarchy();
                    if (!curr.exists() || hierarchy.contains(curr.getType())) {
                        obsoleteHierarchies.add(entry);
                        continue;
                    }
                    if (oldest != null && entry.getLastAccess() >= oldest.getLastAccess()) continue;
                    oldest = entry;
                }
                if (!obsoleteHierarchies.isEmpty()) {
                    for (i = 0; i < obsoleteHierarchies.size(); ++i) {
                        ((HierarchyCacheEntry)fgHierarchyCache.get(i)).freeHierarchy();
                    }
                } else if (oldest != null) {
                    oldest.freeHierarchy();
                }
            }
            HierarchyCacheEntry newEntry = new HierarchyCacheEntry(hierarchy);
            fgHierarchyCache.add(newEntry);
        }
    }

    public static boolean hasInCache(IType type) {
        return SuperTypeHierarchyCache.findTypeHierarchyInCache(type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITypeHierarchy findTypeHierarchyInCache(IType type) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            for (int i = fgHierarchyCache.size() - 1; i >= 0; --i) {
                HierarchyCacheEntry curr = (HierarchyCacheEntry)fgHierarchyCache.get(i);
                ITypeHierarchy hierarchy = curr.getTypeHierarchy();
                if (!hierarchy.exists()) {
                    curr.freeHierarchy();
                    continue;
                }
                if (!hierarchy.contains(type)) continue;
                curr.markAsAccessed();
                return hierarchy;
            }
        }
        return null;
    }

    public static int getCacheHits() {
        return fgCacheHits;
    }

    public static int getCacheMisses() {
        return fgCacheMisses;
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private ITypeHierarchy fTypeHierarchy;
        private long fLastAccess;

        public HierarchyCacheEntry(ITypeHierarchy hierarchy) {
            this.fTypeHierarchy = hierarchy;
            this.fTypeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.markAsAccessed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            ArrayList arrayList = fgHierarchyCache;
            synchronized (arrayList) {
                this.freeHierarchy();
            }
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.fTypeHierarchy;
        }

        public void markAsAccessed() {
            this.fLastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.fLastAccess;
        }

        public void freeHierarchy() {
            this.fTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            fgHierarchyCache.remove(this);
        }

        public String toString() {
            return "Superhierarchy of: " + this.fTypeHierarchy.getType().getElementName();
        }
    }
}

