/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import org.eclipse.jdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDropAdapter
implements DropTargetListener {
    private TransferDropTargetListener[] fListeners;
    private TransferDropTargetListener fChosenListener;

    public DelegatingDropAdapter(TransferDropTargetListener[] listeners) {
        this.fListeners = listeners;
        Assert.isNotNull((Object)listeners);
    }

    public void dragEnter(DropTargetEvent event) {
        this.fChosenListener = null;
        event.currentDataType = this.selectPreferredListener(event.dataTypes);
        if (this.fChosenListener != null) {
            this.fChosenListener.dragEnter(event);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragLeave(event);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragOperationChanged(event);
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragOver(event);
        }
    }

    public void drop(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.drop(event);
        }
        this.fChosenListener = null;
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dropAccept(event);
        }
    }

    private TransferData selectPreferredListener(TransferData[] dataTypes) {
        for (int i = 0; i < this.fListeners.length; ++i) {
            TransferData data = this.computeTransferData(dataTypes, this.fListeners[i]);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private TransferData computeTransferData(TransferData[] dataTypes, TransferDropTargetListener listener) {
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!listener.getTransfer().isSupportedType(dataTypes[i])) continue;
            this.fChosenListener = listener;
            return dataTypes[i];
        }
        return null;
    }
}

