/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.OrderedMap;
import org.eclipse.jdt.internal.ui.refactoring.nls.PackageBrowseAdapter;
import org.eclipse.jdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.progress.IProgressService;

public class NLSAccessorConfigurationDialog
extends StatusDialog {
    private OrderedMap fErrorMap = new OrderedMap();
    private SourceFirstPackageSelectionDialogField fResourceBundlePackage;
    private StringButtonDialogField fResourceBundleFile;
    private SourceFirstPackageSelectionDialogField fAccessorPackage;
    private StringDialogField fAccessorClassName;
    private StringDialogField fSubstitutionPattern;
    private NLSRefactoring fRefactoring;

    public NLSAccessorConfigurationDialog(Shell parent, NLSRefactoring refactoring) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRefactoring = refactoring;
        this.setTitle(NLSUIMessages.getString("NLSAccessorConfigurationDialog.title"));
        IDialogFieldListener updateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NLSAccessorConfigurationDialog.this.validateAll();
            }
        };
        ICompilationUnit cu = refactoring.getCu();
        this.fAccessorPackage = new SourceFirstPackageSelectionDialogField(NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.path"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.package"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.browse1"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.browse2"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.default_package"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.dialog.title"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.dialog.message"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.dialog.emtpyMessage"), cu, updateListener, refactoring.getAccessorClassPackage());
        this.fAccessorClassName = this.createStringButtonField(NLSUIMessages.getString("NLSAccessorConfigurationDialog.className"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.browse6"), this.createAccessorFileBrowseAdapter());
        this.fSubstitutionPattern = this.createStringField(NLSUIMessages.getString("NLSAccessorConfigurationDialog.substitutionPattern"));
        this.fResourceBundlePackage = new SourceFirstPackageSelectionDialogField(NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.path"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.package"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.browse3"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.browse4"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.default_package"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.dialog.title"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.dialog.message"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.dialog.emptyMessage"), cu, updateListener, this.fRefactoring.getResourceBundlePackage());
        this.fResourceBundleFile = this.createStringButtonField(NLSUIMessages.getString("NLSAccessorConfigurationDialog.property_file_name"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.browse5"), this.createPropertyFileBrowseAdapter());
        this.initFields();
    }

    private void initFields() {
        this.initAccessorClassFields();
        String resourceBundleName = this.fRefactoring.getResourceBundleName();
        this.fResourceBundleFile.setText(resourceBundleName != null ? resourceBundleName : NLSRefactoring.getDefaultPropertiesFilename());
    }

    private void initAccessorClassFields() {
        String accessorClassName = this.fRefactoring.getAccessorClassName();
        if (accessorClassName == null) {
            accessorClassName = "Messages";
        }
        this.fAccessorClassName.setText(accessorClassName);
        this.fSubstitutionPattern.setText(this.fRefactoring.getSubstitutionPattern());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        int nOfColumns = 4;
        this.initializeDialogUnits((Control)ancestor);
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 4;
        parent.setLayout((Layout)layout);
        this.createAccessorPart(parent, 4, this.convertWidthInCharsToPixels(40));
        Separator s = new Separator(258);
        s.doFillIntoGrid(parent, 4);
        this.createPropertyPart(parent, 4, this.convertWidthInCharsToPixels(40));
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.jdt.ui.externalize_wizard_properties_file_page_context");
        this.validateAll();
        return parent;
    }

    private void createAccessorPart(Composite parent, int nOfColumns, int textWidth) {
        this.createLabel(parent, NLSUIMessages.getString("NLSAccessorConfigurationDialog.resourceBundle.title"), nOfColumns);
        this.fAccessorPackage.createControl(parent, nOfColumns, textWidth);
        this.fAccessorClassName.doFillIntoGrid(parent, nOfColumns);
        LayoutUtil.setWidthHint((Control)this.fAccessorClassName.getTextControl(null), this.convertWidthInCharsToPixels(60));
        this.fAccessorClassName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NLSAccessorConfigurationDialog.this.validateAccessorClassName();
            }
        });
        this.fSubstitutionPattern.doFillIntoGrid(parent, nOfColumns);
        LayoutUtil.setWidthHint((Control)this.fSubstitutionPattern.getTextControl(null), this.convertWidthInCharsToPixels(60));
    }

    private void createPropertyPart(Composite parent, int nOfColumns, int textWidth) {
        Separator label = new Separator(0);
        ((Label)label.getSeparator(parent)).setText(NLSUIMessages.getString("NLSAccessorConfigurationDialog.property_location"));
        label.doFillIntoGrid(parent, nOfColumns, 20);
        this.fResourceBundlePackage.createControl(parent, nOfColumns, textWidth);
        this.fResourceBundleFile.doFillIntoGrid(parent, nOfColumns);
        LayoutUtil.setWidthHint((Control)this.fResourceBundleFile.getTextControl(null), this.convertWidthInCharsToPixels(60));
        this.fResourceBundleFile.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NLSAccessorConfigurationDialog.this.validatePropertyFilename();
            }
        });
    }

    private void createLabel(Composite parent, String text, int N_OF_COLUMNS) {
        Separator label = new Separator(0);
        ((Label)label.getSeparator(parent)).setText(text);
        label.doFillIntoGrid(parent, N_OF_COLUMNS, 20);
    }

    private void browseForPropertyFile() {
        IFile selectedFile;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setIgnoreCase(false);
        dialog.setTitle(NLSUIMessages.getString("NLSAccessorConfigurationDialog.Property_File_Selection"));
        dialog.setMessage(NLSUIMessages.getString("NLSAccessorConfigurationDialog.Choose_the_property_file"));
        dialog.setElements(this.createFileListInput());
        dialog.setFilter("*.properties");
        if (dialog.open() == 0 && (selectedFile = (IFile)dialog.getFirstResult()) != null) {
            this.fResourceBundleFile.setText(selectedFile.getName());
        }
    }

    protected void browseForAccessorClass() {
        IType selectedType;
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        IPackageFragmentRoot root = this.fAccessorPackage.getSelectedFragmentRoot();
        IJavaSearchScope scope = root != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root}) : SearchEngine.createWorkspaceScope();
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)service, 5, scope);
        dialog.setIgnoreCase(true);
        dialog.setTitle(NLSUIMessages.getString("NLSAccessorConfigurationDialog.Accessor_Selection"));
        dialog.setMessage(NLSUIMessages.getString("NLSAccessorConfigurationDialog.Choose_the_accessor_file"));
        dialog.setFilter("*Messages");
        if (dialog.open() == 0 && (selectedType = (IType)dialog.getFirstResult()) != null) {
            this.fAccessorClassName.setText(selectedType.getElementName());
            this.fAccessorPackage.setSelected(selectedType.getPackageFragment());
        }
    }

    private Object[] createFileListInput() {
        try {
            IPackageFragment fPkgFragment = this.fResourceBundlePackage.getSelected();
            if (fPkgFragment == null) {
                return new Object[0];
            }
            ArrayList<Object> result = new ArrayList<Object>(1);
            Object[] nonjava = fPkgFragment.getNonJavaResources();
            for (int i = 0; i < nonjava.length; ++i) {
                if (!NLSAccessorConfigurationDialog.isPropertyFile(nonjava[i])) continue;
                result.add(nonjava[i]);
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), NLSUIMessages.getString("NLSAccessorConfigurationDialog.externalizing"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.exception"));
            return new Object[0];
        }
    }

    private static boolean isPropertyFile(Object o) {
        if (!(o instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)o;
        return ".properties".equals('.' + file.getFileExtension());
    }

    private void validateAll() {
        this.updateStatus(StatusInfo.OK_STATUS);
        this.validateSubstitutionPattern();
        this.validateAccessorClassName();
        this.checkPackageFragment(this.fAccessorPackage, NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.package.root.invalid"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.accessor.package.invalid"));
        this.validatePropertyFilename();
        this.validatePropertyPackage();
    }

    private void validateAccessorClassName() {
        if (this.fAccessorClassName != null) {
            String className = this.fAccessorClassName.getText();
            IStatus status = JavaConventions.validateJavaTypeName((String)className);
            if (status.getSeverity() == 4) {
                this.setInvalid(this.fAccessorClassName, status.getMessage());
                return;
            }
            if (className.indexOf(46) != -1) {
                this.setInvalid(this.fAccessorClassName, NLSUIMessages.getString("NLSAccessorConfigurationDialog.no_dot"));
                return;
            }
            this.setValid(this.fAccessorClassName);
        }
    }

    private void validatePropertyFilename() {
        if (this.fResourceBundleFile != null) {
            String fileName = this.fResourceBundleFile.getText();
            if (fileName == null || fileName.length() == 0) {
                this.setInvalid(this.fResourceBundleFile, NLSUIMessages.getString("NLSAccessorConfigurationDialog.enter_name"));
                return;
            }
            if (!fileName.endsWith(".properties")) {
                this.setInvalid(this.fResourceBundleFile, NLSUIMessages.getFormattedString("NLSAccessorConfigurationDialog.file_name_must_end", ".properties"));
                return;
            }
            this.setValid(this.fResourceBundleFile);
        }
    }

    private void validatePropertyPackage() {
        if (!this.checkPackageFragment(this.fResourceBundlePackage, NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.package.root.invalid"), NLSUIMessages.getString("NLSAccessorConfigurationDialog.property.package.invalid"))) {
            return;
        }
        IPackageFragment help = this.fResourceBundlePackage.getSelected();
        String pkgName = help.getElementName();
        IStatus status = JavaConventions.validatePackageName((String)pkgName);
        if (pkgName.length() > 0 && status.getSeverity() == 4) {
            this.setInvalid(this.fResourceBundlePackage, status.getMessage());
            return;
        }
        IPath pkgPath = new Path(pkgName.replace('.', '/')).makeRelative();
        IJavaProject project = this.fRefactoring.getCu().getJavaProject();
        try {
            IJavaElement element = project.findElement(pkgPath);
            if (element == null || !element.exists()) {
                this.setInvalid(this.fResourceBundlePackage, NLSUIMessages.getString("NLSAccessorConfigurationDialog.must_exist"));
                return;
            }
            IPackageFragment fPkgFragment = (IPackageFragment)element;
            if (!PackageBrowseAdapter.canAddPackage(fPkgFragment)) {
                this.setInvalid(this.fResourceBundlePackage, NLSUIMessages.getString("NLSAccessorConfigurationDialog.incorrect_package"));
                return;
            }
            if (!PackageBrowseAdapter.canAddPackageRoot((IPackageFragmentRoot)fPkgFragment.getParent())) {
                this.setInvalid(this.fResourceBundlePackage, NLSUIMessages.getString("NLSAccessorConfigurationDialog.incorrect_package"));
                return;
            }
        }
        catch (JavaModelException e) {
            this.setInvalid(this.fResourceBundlePackage, e.getStatus().getMessage());
            return;
        }
        this.setValid(this.fResourceBundlePackage);
    }

    private boolean checkPackageFragment(SourceFirstPackageSelectionDialogField selector, String invalidRoot, String invalidFragment) {
        IPackageFragmentRoot root = selector.getSelectedFragmentRoot();
        if (root == null || !root.exists()) {
            this.setInvalid(selector, invalidRoot);
            return false;
        }
        IPackageFragment fragment = selector.getSelected();
        if (fragment == null || !fragment.exists()) {
            this.setInvalid(selector, invalidFragment);
            return false;
        }
        this.setValid(selector);
        return true;
    }

    private void validateSubstitutionPattern() {
        if (this.fSubstitutionPattern.getText() == null || this.fSubstitutionPattern.getText().length() == 0) {
            this.setInvalid(this.fSubstitutionPattern, NLSUIMessages.getString("NLSAccessorConfigurationDialog.substitution.pattern.missing"));
        } else {
            this.setValid(this.fSubstitutionPattern);
        }
    }

    private void setInvalid(Object field, String msg) {
        this.fErrorMap.push(field, msg);
        this.updateErrorMessage();
    }

    private void setValid(Object field) {
        this.fErrorMap.remove(field);
    }

    private void updateErrorMessage() {
        String msg = (String)this.fErrorMap.peek();
        this.updateStatus(new StatusInfo(4, msg));
    }

    protected void okPressed() {
        this.updateRefactoring();
        super.okPressed();
    }

    void updateRefactoring() {
        NLSRefactoring refactoring = this.fRefactoring;
        refactoring.setAccessorClassPackage(this.fAccessorPackage.getSelected());
        refactoring.setAccessorClassName(this.fAccessorClassName.getText());
        refactoring.setResourceBundleName(this.fResourceBundleFile.getText());
        refactoring.setResourceBundlePackage(this.fResourceBundlePackage.getSelected());
        refactoring.setSubstitutionPattern(this.fSubstitutionPattern.getText());
    }

    private StringDialogField createStringField(String label) {
        StringDialogField field = new StringDialogField();
        field.setLabelText(label);
        return field;
    }

    private StringButtonDialogField createStringButtonField(String label, String button, IStringButtonAdapter adapter) {
        StringButtonDialogField field = new StringButtonDialogField(adapter);
        field.setLabelText(label);
        field.setButtonLabel(button);
        return field;
    }

    private IStringButtonAdapter createPropertyFileBrowseAdapter() {
        return new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                NLSAccessorConfigurationDialog.this.browseForPropertyFile();
            }
        };
    }

    private IStringButtonAdapter createAccessorFileBrowseAdapter() {
        return new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                NLSAccessorConfigurationDialog.this.browseForAccessorClass();
            }
        };
    }
}

