/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.IColorManagerExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractJavaScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;
    private boolean fNeedsLazyColorLoading;

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public AbstractJavaScanner(IColorManager manager, IPreferenceStore store) {
        this.fColorManager = manager;
        this.fPreferenceStore = store;
    }

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int length = this.fPropertyNamesColor.length;
        this.fPropertyNamesBold = new String[length];
        this.fPropertyNamesItalic = new String[length];
        this.fNeedsLazyColorLoading = Display.getCurrent() == null;
        for (int i = 0; i < length; ++i) {
            this.fPropertyNamesBold[i] = this.fPropertyNamesColor[i] + "_bold";
            this.fPropertyNamesItalic[i] = this.fPropertyNamesColor[i] + "_italic";
            if (this.fNeedsLazyColorLoading) {
                this.addTokenWithProxyAttribute(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
                continue;
            }
            this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
        }
        this.initializeRules();
    }

    public IToken nextToken() {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return super.nextToken();
    }

    private void resolveProxyAttributes() {
        if (this.fNeedsLazyColorLoading && Display.getCurrent() != null) {
            for (int i = 0; i < this.fPropertyNamesColor.length; ++i) {
                this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
            }
            this.fNeedsLazyColorLoading = true;
        }
    }

    private void addTokenWithProxyAttribute(String colorKey, String boldKey, String italicKey) {
        this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(null, boldKey, italicKey)));
    }

    private void addToken(String colorKey, String boldKey, String italicKey) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
        if (this.fColorManager instanceof IColorManagerExtension) {
            IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
            ext.unbindColor(colorKey);
            ext.bindColor(colorKey, rgb);
        }
        if (!this.fNeedsLazyColorLoading) {
            this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(colorKey, boldKey, italicKey)));
        } else {
            Token token = (Token)this.fTokenMap.get(colorKey);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(colorKey, boldKey, italicKey));
            }
        }
    }

    private TextAttribute createTextAttribute(String colorKey, String boldKey, String italicKey) {
        int style;
        Color color = null;
        if (colorKey != null) {
            color = this.fColorManager.getColor(colorKey);
        }
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        return new TextAttribute(color, null, style);
    }

    protected Token getToken(String key) {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return (Token)this.fTokenMap.get(key);
    }

    private void initializeRules() {
        List rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            for (int i = 0; i < length; ++i) {
                if (!property.equals(this.fPropertyNamesColor[i]) && !property.equals(this.fPropertyNamesBold[i]) && !property.equals(this.fPropertyNamesItalic[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.fPropertyNamesColor[index]);
        if (this.fPropertyNamesColor[index].equals(p)) {
            this.adaptToColorChange(token, event);
        } else if (this.fPropertyNamesBold[index].equals(p)) {
            this.adaptToStyleChange(token, event, 1);
        } else if (this.fPropertyNamesItalic[index].equals(p)) {
            this.adaptToStyleChange(token, event, 2);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            Object data;
            String property = event.getProperty();
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
            }
            if ((data = token.getData()) instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(property), oldAttr.getBackground(), oldAttr.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }
}

