/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IJavaReconcilingListener fJavaReconcilingListener;
    private boolean fIsJavaReconcilingListener;

    public JavaReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = JavaPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        this.fIsJavaReconcilingListener = this.fEditor instanceof IJavaReconcilingListener;
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener = (IJavaReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reconcile() {
        CompilationUnit ast = null;
        try {
            ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            if (unit != null) {
                try {
                    IProblemRequestorExtension extension = this.getProblemRequestorExtension();
                    if (extension != null) {
                        extension.setProgressMonitor(this.fProgressMonitor);
                    }
                    try {
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            if (this.fIsJavaReconcilingListener) {
                                ast = unit.reconcile(2, true, null, this.fProgressMonitor);
                                if (ast != null) {
                                    ASTNodes.setFlagsToAST((ASTNode)ast, 4);
                                }
                            } else {
                                unit.reconcile(0, true, null, this.fProgressMonitor);
                            }
                        }
                    }
                    catch (OperationCanceledException ex) {
                        Assert.isTrue((this.fProgressMonitor == null || this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
                        ast = null;
                    }
                    if (extension != null) {
                        extension.setProgressMonitor(null);
                    }
                }
                catch (JavaModelException javaModelException) {
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (!this.fIsJavaReconcilingListener) throw throwable;
                IProgressMonitor pm = this.fProgressMonitor;
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                this.fJavaReconcilingListener.reconciled(ast, !this.fNotify, pm);
                throw throwable;
            }
            finally {
                this.fNotify = true;
            }
        }
        try {
            if (!this.fIsJavaReconcilingListener) return;
            IProgressMonitor pm = this.fProgressMonitor;
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            this.fJavaReconcilingListener.reconciled(ast, !this.fNotify, pm);
            return;
        }
        finally {
            this.fNotify = true;
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile();
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener.aboutToBeReconciled();
        }
    }
}

