/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling.engine;

import org.eclipse.jdt.internal.ui.text.spelling.engine.IPhoneticDistanceAlgorithm;

public final class DefaultPhoneticDistanceAlgorithm
implements IPhoneticDistanceAlgorithm {
    public static final int COST_CASE = 10;
    public static final int COST_INSERT = 95;
    public static final int COST_REMOVE = 95;
    public static final int COST_SUBSTITUTE = 100;
    public static final int COST_SWAP = 90;

    public final int getDistance(String from, String to) {
        char[] first = (" " + from).toCharArray();
        char[] second = (" " + to).toCharArray();
        int rows = first.length;
        int columns = second.length;
        int[][] metric = new int[rows][columns];
        for (int column = 1; column < columns; ++column) {
            metric[0][column] = metric[0][column - 1] + 95;
        }
        for (int row = 1; row < rows; ++row) {
            metric[row][0] = metric[row - 1][0] + 95;
        }
        int swap = Integer.MAX_VALUE;
        int change = Integer.MAX_VALUE;
        for (int row = 1; row < rows; ++row) {
            char source = first[row];
            for (int column = 1; column < columns; ++column) {
                int insert;
                int remove;
                int minimum;
                char target = second[column];
                int diagonal = metric[row - 1][column - 1];
                if (source == target) {
                    metric[row][column] = diagonal;
                    continue;
                }
                change = Integer.MAX_VALUE;
                if (Character.toLowerCase(source) == Character.toLowerCase(target)) {
                    change = 10 + diagonal;
                }
                swap = Integer.MAX_VALUE;
                if (row != 1 && column != 1 && source == second[column - 1] && first[row - 1] == target) {
                    swap = 90 + metric[row - 2][column - 2];
                }
                if (swap < (minimum = 100 + diagonal)) {
                    minimum = swap;
                }
                if (95 + (remove = metric[row][column - 1]) < minimum) {
                    minimum = 95 + remove;
                }
                if (95 + (insert = metric[row - 1][column]) < minimum) {
                    minimum = 95 + insert;
                }
                if (change < minimum) {
                    minimum = change;
                }
                metric[row][column] = minimum;
            }
        }
        return metric[rows - 1][columns - 1];
    }
}

