/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class HistoryListAction
extends Action {
    private TypeHierarchyViewPart fView;

    public HistoryListAction(TypeHierarchyViewPart view) {
        this.fView = view;
        this.setText(TypeHierarchyMessages.getString("HistoryListAction.label"));
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "history_list.gif");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.history_list_action");
    }

    public void run() {
        IJavaElement[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(JavaPlugin.getActiveWorkbenchShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInputElement(dialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField fHistoryList;
        private IStatus fHistoryStatus;
        private IJavaElement fResult;

        private HistoryListDialog(Shell shell, IJavaElement[] elements) {
            super(shell);
            this.setTitle(TypeHierarchyMessages.getString("HistoryListDialog.title"));
            String[] buttonLabels = new String[]{TypeHierarchyMessages.getString("HistoryListDialog.remove.button")};
            IListAdapter adapter = new IListAdapter(){

                public void customButtonPressed(ListDialogField field, int index) {
                    this.doCustomButtonPressed();
                }

                public void selectionChanged(ListDialogField field) {
                    this.doSelectionChanged();
                }

                public void doubleClicked(ListDialogField field) {
                    this.doDoubleClicked();
                }
            };
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(1088);
            this.fHistoryList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
            this.fHistoryList.setLabelText(TypeHierarchyMessages.getString("HistoryListDialog.label"));
            this.fHistoryList.setElements(Arrays.asList(elements));
            StructuredSelection sel = elements.length > 0 ? new StructuredSelection((Object)elements[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setLayoutData((Object)new GridData(1808));
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = (IJavaElement)selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public IJavaElement getResult() {
            return this.fResult;
        }

        public IJavaElement[] getRemaining() {
            List elems = this.fHistoryList.getElements();
            return elems.toArray(new IJavaElement[elems.size()]);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.history_list_dialog_context");
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }
    }
}

