/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class MethodsContentProvider
implements IStructuredContentProvider,
IWorkingCopyProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private boolean fShowInheritedMethods;
    private TypeHierarchyLifeCycle fHierarchyLifeCycle;
    private TableViewer fViewer;

    public MethodsContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fHierarchyLifeCycle = lifecycle;
        this.fShowInheritedMethods = false;
        this.fViewer = null;
    }

    public void showInheritedMethods(boolean show) {
        if (show != this.fShowInheritedMethods) {
            this.fShowInheritedMethods = show;
            if (this.fViewer != null) {
                this.fViewer.refresh();
            }
        }
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public boolean isShowInheritedMethods() {
        return this.fShowInheritedMethods;
    }

    private void addAll(Object[] arr, List res) {
        if (arr != null) {
            for (int j = 0; j < arr.length; ++j) {
                res.add(arr[j]);
            }
        }
    }

    public Object[] getElements(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            ArrayList res = new ArrayList();
            try {
                ITypeHierarchy hierarchy = this.fHierarchyLifeCycle.getHierarchy();
                if (this.fShowInheritedMethods && hierarchy != null) {
                    IType[] allSupertypes = hierarchy.getAllSupertypes(type);
                    for (int i = allSupertypes.length - 1; i >= 0; --i) {
                        IType superType = allSupertypes[i];
                        if (!superType.exists()) continue;
                        this.addAll(superType.getMethods(), res);
                        this.addAll(superType.getInitializers(), res);
                        this.addAll(superType.getFields(), res);
                    }
                }
                if (type.exists()) {
                    this.addAll(type.getMethods(), res);
                    this.addAll(type.getInitializers(), res);
                    this.addAll(type.getFields(), res);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return res.toArray();
        }
        return NO_ELEMENTS;
    }

    public void inputChanged(Viewer input, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(input instanceof TableViewer));
        this.fViewer = (TableViewer)input;
    }

    public void dispose() {
    }
}

