/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public JavaElementImageProvider() {
        ISharedImages images = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IJavaElement) {
            return this.getJavaImageDescriptor((IJavaElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if ("java".equals(file.getFileExtension())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaElement element, int flags) {
        int adornmentFlags = this.computeJavaAdornmentFlags(element, flags);
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = JavaElementImageProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(IJavaElement element, int renderFlags) {
        try {
            switch (element.getElementType()) {
                case 10: {
                    return JavaPluginImages.DESC_MISC_PRIVATE;
                }
                case 9: {
                    IMember member = (IMember)element;
                    return JavaElementImageProvider.getMethodImageDescriptor(member.getDeclaringType().isInterface(), member.getFlags());
                }
                case 8: {
                    IField field = (IField)element;
                    return JavaElementImageProvider.getFieldImageDescriptor(field.getDeclaringType().isInterface(), field.getFlags());
                }
                case 14: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
                case 11: {
                    return JavaPluginImages.DESC_OBJS_PACKDECL;
                }
                case 13: {
                    return JavaPluginImages.DESC_OBJS_IMPDECL;
                }
                case 12: {
                    return JavaPluginImages.DESC_OBJS_IMPCONT;
                }
                case 7: {
                    IType type = (IType)element;
                    boolean isInterface = type.isInterface();
                    if (JavaElementImageProvider.useLightIcons(renderFlags)) {
                        return isInterface ? JavaPluginImages.DESC_OBJS_INTERFACEALT : JavaPluginImages.DESC_OBJS_CLASSALT;
                    }
                    boolean isInner = type.getDeclaringType() != null;
                    boolean isInInterface = isInner && type.getDeclaringType().isInterface();
                    return JavaElementImageProvider.getTypeImageDescriptor(isInterface, isInner, isInInterface, type.getFlags());
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    if (root.isArchive()) {
                        IPath attach = root.getSourceAttachmentPath();
                        if (root.isExternal()) {
                            if (attach == null) {
                                return JavaPluginImages.DESC_OBJS_EXTJAR;
                            }
                            return JavaPluginImages.DESC_OBJS_EXTJAR_WSRC;
                        }
                        if (attach == null) {
                            return JavaPluginImages.DESC_OBJS_JAR;
                        }
                        return JavaPluginImages.DESC_OBJS_JAR_WSRC;
                    }
                    return JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                }
                case 4: {
                    return this.getPackageFragmentIcon(element, renderFlags);
                }
                case 5: {
                    return JavaPluginImages.DESC_OBJS_CUNIT;
                }
                case 6: {
                    return JavaPluginImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    IJavaProject jp = (IJavaProject)element;
                    if (jp.getProject().isOpen()) {
                        ImageDescriptor result;
                        IProject project = jp.getProject();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = JavaElementImageProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
                        if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                            return result;
                        }
                        return DESC_OBJ_PROJECT;
                    }
                    return DESC_OBJ_PROJECT_CLOSED;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_JAVA_MODEL;
                }
            }
            Assert.isTrue((boolean)false, (String)JavaUIMessages.getString("JavaImageLabelprovider.assert.wrongImage"));
            return null;
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return JavaPluginImages.DESC_OBJS_UNKNOWN;
            }
            JavaPlugin.log(e);
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
    }

    protected ImageDescriptor getPackageFragmentIcon(IJavaElement element, int renderFlags) throws JavaModelException {
        IPackageFragment fragment = (IPackageFragment)element;
        boolean containsJavaElements = false;
        try {
            containsJavaElements = fragment.hasChildren();
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        if (!containsJavaElements && fragment.getNonJavaResources().length > 0) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE_RESOURCES;
        }
        if (!containsJavaElements) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        return JavaPluginImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeJavaAdornmentFlags(IJavaElement element, int renderFlags) {
        int flags = 0;
        if (JavaElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && JavaElementImageProvider.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || JavaElementImageProvider.isInterfaceField(member)) {
                    flags |= 2;
                }
                if (Flags.isSynchronized((int)modifiers) && JavaElementImageProvider.confirmSynchronized((IJavaElement)member)) {
                    flags |= 4;
                }
                if (Flags.isStatic((int)modifiers) || JavaElementImageProvider.isInterfaceField(member)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
                if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)member)) {
                    flags |= 0x10;
                }
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return ((IType)element).isClass();
        }
        return element.getDeclaringType().isClass();
    }

    private static boolean isInterfaceField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }

    public static ImageDescriptor getMethodImageDescriptor(boolean isInInterface, int flags) {
        if (Flags.isPublic((int)flags) || isInInterface) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        return JavaPluginImages.DESC_MISC_DEFAULT;
    }

    public static ImageDescriptor getFieldImageDescriptor(boolean isInInterface, int flags) {
        if (Flags.isPublic((int)flags) || isInInterface) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_DEFAULT;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isInterface, boolean isInner, boolean isInInterface, int flags) {
        if (isInner) {
            if (isInterface) {
                return JavaElementImageProvider.getInnerInterfaceImageDescriptor(isInInterface, flags);
            }
            return JavaElementImageProvider.getInnerClassImageDescriptor(isInInterface, flags);
        }
        if (isInterface) {
            return JavaElementImageProvider.getInterfaceImageDescriptor(flags);
        }
        return JavaElementImageProvider.getClassImageDescriptor(flags);
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornments, size));
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerClassImageDescriptor(boolean isInInterface, int flags) {
        if (Flags.isPublic((int)flags) || isInInterface) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INTERFACE;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(boolean isInInterface, int flags) {
        if (Flags.isPublic((int)flags) || isInInterface) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

