/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.ui.PreferenceConstants;

public class ClassPathDetector
implements IResourceProxyVisitor {
    private HashMap fSourceFolders = new HashMap();
    private List fClassFiles;
    private HashSet fJARFiles = new HashSet(10);
    private IProject fProject;
    private IPath fResultOutputFolder;
    private IClasspathEntry[] fResultClasspath;

    public ClassPathDetector(IProject project) throws CoreException {
        this.fClassFiles = new ArrayList(100);
        this.fProject = project;
        project.accept((IResourceProxyVisitor)this, 0);
        this.fResultClasspath = null;
        this.fResultOutputFolder = null;
        this.detectClasspath();
    }

    private boolean isNested(IPath path, Iterator iter) {
        while (iter.hasNext()) {
            IPath other = (IPath)iter.next();
            if (!other.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    private void detectClasspath() {
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        this.detectSourceFolders(cpEntries);
        IPath outputLocation = this.detectOutputFolder(cpEntries);
        this.detectLibraries(cpEntries, outputLocation);
        if (cpEntries.isEmpty() && this.fClassFiles.isEmpty()) {
            return;
        }
        IClasspathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
        for (int i = 0; i < jreEntries.length; ++i) {
            cpEntries.add(jreEntries[i]);
        }
        IClasspathEntry[] entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        if (!JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)this.fProject), (IClasspathEntry[])entries, (IPath)outputLocation).isOK()) {
            return;
        }
        this.fResultClasspath = entries;
        this.fResultOutputFolder = outputLocation;
    }

    private IPath findInSourceFolders(IPath path) {
        Iterator iter = this.fSourceFolders.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            List cus = (List)this.fSourceFolders.get(key);
            if (!cus.contains(path)) continue;
            return (IPath)key;
        }
        return null;
    }

    private IPath detectOutputFolder(List entries) {
        HashSet<IPath> classFolders = new HashSet<IPath>();
        Iterator iter = this.fClassFiles.iterator();
        while (iter.hasNext()) {
            IClassFileReader reader;
            IFile file = (IFile)iter.next();
            IPath location = file.getLocation();
            if (location == null || (reader = ToolFactory.createDefaultClassFileReader((String)location.toOSString(), (int)17)) == null) continue;
            char[] className = reader.getClassName();
            ISourceAttribute sourceAttribute = reader.getSourceFileAttribute();
            if (className == null || sourceAttribute == null || sourceAttribute.getSourceFileName() == null) continue;
            IPath packPath = file.getParent().getFullPath();
            int idx = CharOperation.lastIndexOf((char)'/', (char[])className) + 1;
            Path relPath = new Path(new String(className, 0, idx));
            IPath cuPath = relPath.append(new String(sourceAttribute.getSourceFileName()));
            IPath resPath = null;
            if (idx == 0) {
                resPath = packPath;
            } else {
                IPath folderPath = this.getFolderPath(packPath, (IPath)relPath);
                if (folderPath != null) {
                    resPath = folderPath;
                }
            }
            if (resPath == null) continue;
            IPath path = this.findInSourceFolders(cuPath);
            if (path != null) {
                return resPath;
            }
            classFolders.add(resPath);
        }
        IPath projPath = this.fProject.getFullPath();
        if (this.fSourceFolders.size() == 1 && classFolders.isEmpty() && this.fSourceFolders.get(projPath) != null) {
            return projPath;
        }
        IPath path = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
        while (classFolders.contains(path)) {
            path = new Path(path.toString() + '1');
        }
        return path;
    }

    private void detectLibraries(ArrayList cpEntries, IPath outputLocation) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        Iterator iter = this.fJARFiles.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            if (this.isNested(path, sourceFolderSet.iterator()) || outputLocation != null && outputLocation.isPrefixOf(path)) continue;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        cpEntries.addAll(res);
    }

    private void detectSourceFolders(ArrayList resEntries) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        Iterator iter = sourceFolderSet.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            Iterator inner = sourceFolderSet.iterator();
            while (inner.hasNext()) {
                IPath other = (IPath)inner.next();
                if (path.equals(other) || !path.isPrefixOf(other)) continue;
                IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                excluded.add(pathToExclude);
            }
            IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        resEntries.addAll(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitCompilationUnit(IFile file) {
        ICompilationUnit workingCopy;
        block11: {
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
            if (cu == null) return;
            workingCopy = null;
            workingCopy = cu.getWorkingCopy(null);
            IPath relPath = this.getPackagePath(workingCopy.getSource());
            IPath packPath = file.getParent().getFullPath();
            String cuName = file.getName();
            if (relPath == null) {
                this.addToMap(this.fSourceFolders, packPath, (IPath)new Path(cuName));
                break block11;
            }
            IPath folderPath = this.getFolderPath(packPath, relPath);
            if (folderPath == null) break block11;
            this.addToMap(this.fSourceFolders, folderPath, relPath.append(cuName));
        }
        Object var9_10 = null;
        if (workingCopy == null) return;
        try {
            workingCopy.discardWorkingCopy();
            return;
        }
        catch (JavaModelException ignore) {}
        return;
        {
            catch (JavaModelException e) {
                Object var9_11 = null;
                if (workingCopy == null) return;
                try {
                    workingCopy.discardWorkingCopy();
                    return;
                }
                catch (JavaModelException ignore) {}
                return;
            }
            catch (InvalidInputException e) {
                Object var9_12 = null;
                if (workingCopy == null) return;
                try {
                    workingCopy.discardWorkingCopy();
                    return;
                }
                catch (JavaModelException ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (workingCopy == null) throw throwable;
            try {
                workingCopy.discardWorkingCopy();
                throw throwable;
            }
            catch (JavaModelException ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private IPath getPackagePath(String source) throws InvalidInputException {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(0, source.length() - 1);
        int tok = scanner.getNextToken();
        if (tok != 214) {
            return null;
        }
        Path res = Path.EMPTY;
        do {
            if ((tok = scanner.getNextToken()) != 5) {
                return res;
            }
            res = res.append(new String(scanner.getCurrentTokenSource()));
        } while ((tok = scanner.getNextToken()) == 6);
        return res;
    }

    private void addToMap(HashMap map, IPath folderPath, IPath relPath) {
        ArrayList<IPath> list = (ArrayList<IPath>)map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    private IPath getFolderPath(IPath packPath, IPath relpath) {
        IPath common;
        int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
        if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals(relpath)) {
            return packPath.uptoSegment(remainingSegments);
        }
        return null;
    }

    private boolean hasExtension(String name, String ext) {
        return name.endsWith(ext) && ext.length() != name.length();
    }

    private boolean isValidCUName(String name) {
        return !JavaConventions.validateCompilationUnitName((String)name).matches(4);
    }

    public boolean visit(IResourceProxy proxy) {
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            if (this.hasExtension(name, ".java") && this.isValidCUName(name)) {
                this.visitCompilationUnit((IFile)proxy.requestResource());
            } else if (this.hasExtension(name, ".class")) {
                this.fClassFiles.add(proxy.requestResource());
            } else if (this.hasExtension(name, ".jar")) {
                this.fJARFiles.add(proxy.requestFullPath());
            }
            return false;
        }
        return true;
    }

    public IPath getOutputLocation() {
        return this.fResultOutputFolder;
    }

    public IClasspathEntry[] getClasspath() {
        return this.fResultClasspath;
    }

    private static class CPSorter
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        private CPSorter() {
        }

        public int compare(Object o1, Object o2) {
            IClasspathEntry e1 = (IClasspathEntry)o1;
            IClasspathEntry e2 = (IClasspathEntry)o2;
            return this.fCollator.compare(e1.getPath().toString(), e2.getPath().toString());
        }
    }
}

