/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.ChangeSignatureWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ModifyParametersAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public ModifyParametersAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ModifyParametersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RefactoringGroup.modify_Parameters_label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.modify_parameters_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(ModifyParametersAction.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length > 1) {
            return false;
        }
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return ChangeSignatureRefactoring.isAvailable((IMethod)elements[0]);
        }
        IJavaElement elementAt = selection.resolveEnclosingElement();
        return elementAt instanceof IMethod && ChangeSignatureRefactoring.isAvailable((IMethod)elementAt);
    }

    public void run(IStructuredSelection selection) {
        try {
            if (ModifyParametersAction.canEnable(selection)) {
                this.startRefactoring(ModifyParametersAction.getSingleSelectedMethod(selection));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            IMethod singleSelectedMethod = this.getSingleSelectedMethod(selection);
            if (ModifyParametersAction.canRunOn(singleSelectedMethod)) {
                this.startRefactoring(singleSelectedMethod);
            } else {
                String unavailable = RefactoringMessages.getString("ModifyParametersAction.unavailable");
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private static boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        return ModifyParametersAction.canRunOn(ModifyParametersAction.getSingleSelectedMethod(selection));
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        if (selection.getFirstElement() instanceof IMethod) {
            return (IMethod)selection.getFirstElement();
        }
        return null;
    }

    private IMethod getSingleSelectedMethod(ITextSelection selection) throws JavaModelException {
        IJavaElement[] elements = this.resolveElements();
        if (elements.length > 1) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return (IMethod)elements[0];
        }
        IJavaElement elementAt = SelectionConverter.getInputAsCompilationUnit(this.fEditor).getElementAt(selection.getOffset());
        if (elementAt instanceof IMethod) {
            return (IMethod)elementAt;
        }
        return null;
    }

    private static boolean canRunOn(IMethod method) throws JavaModelException {
        return ChangeSignatureRefactoring.isAvailable(method);
    }

    private static ChangeSignatureRefactoring createRefactoring(IMethod method) throws JavaModelException {
        return ChangeSignatureRefactoring.create(method);
    }

    private IJavaElement[] resolveElements() {
        return SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"));
    }

    private static RefactoringWizard createWizard(ChangeSignatureRefactoring refactoring) {
        return new ChangeSignatureWizard(refactoring);
    }

    private void startRefactoring(IMethod method) throws JavaModelException {
        ChangeSignatureRefactoring changeSigRefactoring = ModifyParametersAction.createRefactoring(method);
        Assert.isNotNull((Object)changeSigRefactoring);
        if (!ActionUtil.isProcessable(this.getShell(), changeSigRefactoring.getMethod())) {
            return;
        }
        UserInterfaceStarter starter = new UserInterfaceStarter(){

            public void activate(Refactoring refactoring, Shell parent, boolean save) throws CoreException {
                ChangeSignatureRefactoring cr = (ChangeSignatureRefactoring)refactoring;
                RefactoringStatus status = cr.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (status.hasFatalError()) {
                    RefactoringStatusEntry entry = status.getEntryMatchingSeverity(4);
                    if (entry.getCode() == 1 || entry.getCode() == 2) {
                        String message = entry.getMessage();
                        Object newElementToProcess = entry.getData();
                        message = message + RefactoringMessages.getString("RefactoringErrorDialogUtil.okToPerformQuestion");
                        if (newElementToProcess != null && MessageDialog.openQuestion((Shell)ModifyParametersAction.this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), (String)message)) {
                            StructuredSelection mockSelection = new StructuredSelection(newElementToProcess);
                            ModifyParametersAction.this.selectionChanged((IStructuredSelection)mockSelection);
                            if (ModifyParametersAction.this.isEnabled()) {
                                ModifyParametersAction.this.run((IStructuredSelection)mockSelection);
                            } else {
                                MessageDialog.openInformation((Shell)ModifyParametersAction.this.getShell(), (String)ActionMessages.getString("ModifyParameterAction.problem.title"), (String)ActionMessages.getString("ModifyParameterAction.problem.message"));
                            }
                            return;
                        }
                    } else {
                        super.activate(refactoring, parent, save);
                    }
                }
                super.activate(refactoring, parent, save);
            }
        };
        starter.initialize(ModifyParametersAction.createWizard(changeSigRefactoring));
        try {
            starter.activate(changeSigRefactoring, this.getShell(), true);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
        }
    }
}

