/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ConvertLineDelimitersAction
extends TextEditorAction {
    private final String fLineDelimiter;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public ConvertLineDelimitersAction(ITextEditor editor, String lineDelimiter) {
        this(EditorMessages.getResourceBundle(), "dummy", editor, lineDelimiter);
    }

    public ConvertLineDelimitersAction(ResourceBundle bundle, String prefix, ITextEditor editor, String lineDelimiter) {
        super(bundle, prefix, editor);
        this.fLineDelimiter = lineDelimiter;
        String platformLineDelimiter = System.getProperty("line.separator");
        this.setText(EditorMessages.getString(ConvertLineDelimitersAction.getLabelKey(this.fLineDelimiter, platformLineDelimiter)));
        this.update();
    }

    public void run() {
        try {
            IRewriteTarget target;
            IDocument document;
            ITextEditor editor = this.getTextEditor();
            if (editor == null) {
                return;
            }
            if (!this.validateEditorInputState()) {
                return;
            }
            Object adapter = editor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = ConvertLineDelimitersAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget);
            if (adapter instanceof IRewriteTarget && (document = (target = (IRewriteTarget)adapter).getDocument()) != null) {
                Shell shell = this.getTextEditor().getSite().getShell();
                ConvertRunnable runnable = new ConvertRunnable(target, this.fLineDelimiter);
                if (document.getNumberOfLines() < 40) {
                    BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)runnable);
                } else {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    dialog.run(false, true, (IRunnableWithProgress)runnable);
                }
            }
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static String getLabelKey(String lineDelimiter, String platformLineDelimiter) {
        if (lineDelimiter.equals(platformLineDelimiter)) {
            if (lineDelimiter.equals("\r\n")) {
                return "Editor.ConvertLineDelimiter.toWindows.default.label";
            }
            if (lineDelimiter.equals("\n")) {
                return "Editor.ConvertLineDelimiter.toUNIX.default.label";
            }
            if (lineDelimiter.equals("\r")) {
                return "Editor.ConvertLineDelimiter.toMac.default.label";
            }
        } else {
            if (lineDelimiter.equals("\r\n")) {
                return "Editor.ConvertLineDelimiter.toWindows.label";
            }
            if (lineDelimiter.equals("\n")) {
                return "Editor.ConvertLineDelimiter.toUNIX.label";
            }
            if (lineDelimiter.equals("\r")) {
                return "Editor.ConvertLineDelimiter.toMac.label";
            }
        }
        return null;
    }

    private boolean doEnable() {
        return this.canModifyEditor();
    }

    public void update() {
        super.update();
        this.setEnabled(this.doEnable());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConvertRunnable
    implements IRunnableWithProgress,
    Runnable {
        private final IRewriteTarget fRewriteTarget;
        private final String fLineDelimiter;

        public ConvertRunnable(IRewriteTarget rewriteTarget, String lineDelimiter) {
            this.fRewriteTarget = rewriteTarget;
            this.fLineDelimiter = lineDelimiter;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            IDocument document;
            block12: {
                document = this.fRewriteTarget.getDocument();
                int lineCount = document.getNumberOfLines();
                monitor.beginTask(EditorMessages.getString("Editor.ConvertLineDelimiter.title"), lineCount);
                this.fRewriteTarget.setRedraw(false);
                this.fRewriteTarget.beginCompoundChange();
                if (document instanceof IDocumentExtension) {
                    ((IDocumentExtension)document).startSequentialRewrite(true);
                }
                Map partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
                try {
                    try {
                        for (int i = 0; i < lineCount; ++i) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            String delimiter = document.getLineDelimiter(i);
                            if (delimiter != null && delimiter.length() > 0 && !delimiter.equals(this.fLineDelimiter)) {
                                IRegion region = document.getLineInformation(i);
                                document.replace(region.getOffset() + region.getLength(), delimiter.length(), this.fLineDelimiter);
                            }
                            monitor.worked(1);
                        }
                        Object var9_9 = null;
                        if (partitioners == null) break block12;
                    }
                    catch (BadLocationException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (partitioners != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
                    }
                    if (document instanceof IDocumentExtension) {
                        ((IDocumentExtension)document).stopSequentialRewrite();
                    }
                    this.fRewriteTarget.endCompoundChange();
                    this.fRewriteTarget.setRedraw(true);
                    monitor.done();
                    throw throwable;
                }
                TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
            }
            if (document instanceof IDocumentExtension) {
                ((IDocumentExtension)document).stopSequentialRewrite();
            }
            this.fRewriteTarget.endCompoundChange();
            this.fRewriteTarget.setRedraw(true);
            monitor.done();
        }

        public void run() {
            try {
                this.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

