/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ArrayInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class ArrayAllocation
extends ArrayInstruction {
    private int fDimension;
    private int fExprDimension;
    private boolean fHasInitializer;
    private IJavaArrayType[] fCachedArrayTypes;

    public ArrayAllocation(int dimension, int exprDimension, boolean hasInitializer, int start) {
        super(start);
        this.fDimension = dimension;
        this.fExprDimension = exprDimension;
        this.fHasInitializer = hasInitializer;
    }

    public void execute() throws CoreException {
        if (this.fHasInitializer) {
            IJavaArray array = (IJavaArray)this.popValue();
            this.pop();
            this.push(array);
        } else {
            int[] exprDimensions = new int[this.fExprDimension];
            for (int i = this.fExprDimension - 1; i >= 0; --i) {
                exprDimensions[i] = ((IJavaPrimitiveValue)this.popValue()).getIntValue();
            }
            IJavaType type = (IJavaType)this.pop();
            this.fCachedArrayTypes = new IJavaArrayType[this.fDimension + 1];
            int lim = this.fDimension - this.fExprDimension;
            for (int i = this.fDimension; i > lim; --i) {
                this.fCachedArrayTypes[i] = (IJavaArrayType)type;
                type = ((IJavaArrayType)type).getComponentType();
            }
            IJavaArray array = this.createArray(this.fDimension, exprDimensions);
            this.push(array);
        }
    }

    private IJavaArray createArray(int dimension, int[] exprDimensions) throws CoreException {
        IJavaArray array = this.fCachedArrayTypes[dimension].newInstance(exprDimensions[0]);
        if (exprDimensions.length > 1) {
            int i;
            int[] newExprDimension = new int[exprDimensions.length - 1];
            for (i = 0; i < newExprDimension.length; ++i) {
                newExprDimension[i] = exprDimensions[i + 1];
            }
            for (i = 0; i < exprDimensions[0]; ++i) {
                array.setValue(i, this.createArray(dimension - 1, newExprDimension));
            }
        }
        return array;
    }

    public String toString() {
        return InstructionsEvaluationMessages.getString("ArrayAllocation.array_allocation_1");
    }
}

