/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.expression.ExpressionPopupContentProvider;
import org.eclipse.debug.internal.ui.views.expression.PopupInformationControl;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewContentProvider;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class ExpressionInformationControl
extends PopupInformationControl {
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{90, 10};
    private static final String SASH_KEY = "SASH_WEIGHT";
    private IWorkbenchPage page;
    private IExpression exp;
    private VariablesViewer viewer;
    private IDebugModelPresentation modelPresentation;
    private StyledText valueDisplay;
    private SashForm sashForm;
    private Tree tree;

    public ExpressionInformationControl(IWorkbenchPage page, IExpression exp, String commandId) {
        super(page.getWorkbenchWindow().getShell(), DebugUIViewsMessages.getString("ExpressionInformationControl.5"), commandId);
        this.page = page;
        this.exp = exp;
    }

    public void setInformation(String information) {
        VariablesView view = this.getViewToEmulate();
        this.viewer.getContentProvider();
        if (view != null) {
            StructuredViewer structuredViewer = (StructuredViewer)view.getViewer();
            ViewerFilter[] filters = structuredViewer.getFilters();
            for (int i = 0; i < filters.length; ++i) {
                this.viewer.addFilter(filters[i]);
            }
            ((VariablesViewContentProvider)this.viewer.getContentProvider()).setShowLogicalStructure(view.isShowLogicalStructure());
            Map map = view.getPresentationAttributes(this.exp.getModelIdentifier());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                this.modelPresentation.setAttribute(key, map.get(key));
            }
        }
        this.viewer.setInput(new Object[]{this.exp});
        this.viewer.expandToLevel(2);
    }

    private VariablesView getViewToEmulate() {
        VariablesView expressionsView = (VariablesView)this.page.findView("org.eclipse.debug.ui.ExpressionView");
        if (expressionsView != null && expressionsView.isVisible()) {
            return expressionsView;
        }
        VariablesView variablesView = (VariablesView)this.page.findView("org.eclipse.debug.ui.VariableView");
        if (variablesView != null && variablesView.isVisible()) {
            return variablesView;
        }
        if (expressionsView != null) {
            return expressionsView;
        }
        return variablesView;
    }

    protected int[] getInitialSashWeights() {
        IDialogSettings settings = this.getDialogSettings();
        int[] sashes = new int[2];
        try {
            sashes[0] = settings.getInt("SASH_WEIGHT_ONE");
            sashes[1] = settings.getInt("SASH_WEIGHT_TWO");
            return sashes;
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_SASH_WEIGHTS;
        }
    }

    protected void persistSashWeights() {
        IDialogSettings settings = this.getDialogSettings();
        int[] sashes = this.sashForm.getWeights();
        settings.put("SASH_WEIGHT_ONE", sashes[0]);
        settings.put("SASH_WEIGHT_TWO", sashes[1]);
    }

    private void updateValueDisplay(IValue val) {
        IValueDetailListener valueDetailListener = new IValueDetailListener(){

            public void detailComputed(IValue value, String result) {
                Display.getDefault().asyncExec(new Runnable(this, result){
                    private final /* synthetic */ String val$result;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$result = val$result;
                    }

                    public void run() {
                        ExpressionInformationControl.access$100(1.access$000(this.this$1)).setText(this.val$result);
                    }
                });
            }

            static /* synthetic */ ExpressionInformationControl access$000(1 x0) {
                return x0.ExpressionInformationControl.this;
            }
        };
        this.modelPresentation.computeDetail(val, valueDetailListener);
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, parent.getStyle());
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(composite, parent.getStyle());
        this.sashForm.setOrientation(512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.viewer = new VariablesViewer((Composite)this.sashForm, 8);
        this.viewer.setContentProvider((IContentProvider)new ExpressionPopupContentProvider());
        this.modelPresentation = DebugUITools.newDebugModelPresentation();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.modelPresentation);
        this.valueDisplay = new StyledText((Composite)this.sashForm, 584);
        this.valueDisplay.setEditable(false);
        this.tree = this.viewer.getTree();
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TreeItem[] selections = ExpressionInformationControl.this.tree.getSelection();
                    Object data = selections[selections.length - 1].getData();
                    IValue val = null;
                    if (data instanceof IndexedVariablePartition) {
                        return;
                    }
                    if (data instanceof IVariable) {
                        val = ((IVariable)data).getValue();
                    } else if (data instanceof IExpression) {
                        val = ((IExpression)data).getValue();
                    }
                    if (val == null) {
                        return;
                    }
                    ExpressionInformationControl.this.updateValueDisplay(val);
                }
                catch (DebugException ex) {
                    DebugUIPlugin.log(ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Color background = parent.getDisplay().getSystemColor(29);
        Color foreground = parent.getDisplay().getSystemColor(28);
        this.tree.setForeground(foreground);
        this.tree.setBackground(background);
        composite.setForeground(foreground);
        composite.setBackground(background);
        this.valueDisplay.setForeground(foreground);
        this.valueDisplay.setBackground(background);
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        return this.tree;
    }

    public Point computeSizeHint() {
        Point persistedSize = this.getInitialSize();
        if (persistedSize != null) {
            return persistedSize;
        }
        int height = 0;
        int width = 0;
        int itemCount = 0;
        TreeItem[] items = this.tree.getItems();
        GC gc = new GC((Drawable)this.tree);
        for (int i = 0; i < items.length; ++i) {
            width = Math.max(width, this.calculateWidth(items[i], gc));
            ++itemCount;
            TreeItem[] children = items[i].getItems();
            for (int j = 0; j < children.length; ++j) {
                width = Math.max(width, this.calculateWidth(children[j], gc));
                ++itemCount;
            }
        }
        gc.dispose();
        height = itemCount * this.tree.getItemHeight() + 90;
        if ((width += 40) > 300) {
            width = 300;
        }
        if (height > 300) {
            height = 300;
        }
        return this.shell.computeSize(width, height, true);
    }

    private int calculateWidth(TreeItem item, GC gc) {
        int width = 0;
        Image image = item.getImage();
        String text = item.getText();
        if (image != null) {
            width = image.getBounds().width + 2;
        }
        if (text != null && text.length() > 0) {
            width += gc.stringExtent((String)text).x;
        }
        return width;
    }

    public boolean hasContents() {
        return this.viewer != null;
    }

    protected void performCommand() {
        DebugPlugin.getDefault().getExpressionManager().addExpression(this.exp);
        IViewPart part = this.page.findView("org.eclipse.debug.ui.ExpressionView");
        if (part == null) {
            try {
                this.page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        } else {
            this.page.bringToTop((IWorkbenchPart)part);
        }
    }

    static /* synthetic */ StyledText access$100(ExpressionInformationControl x0) {
        return x0.valueDisplay;
    }
}

