/*
 * Copyright  2002,2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.tools.ant.input;

/**
 * Plugin to Ant to handle requests for user input.
 *
 * @author Stefan Bodewig
 * @version $Revision: 1.5.2.3 $
 * @since Ant 1.5
 */
public interface InputHandler {

    /**
     * Handle the request encapsulated in the argument.
     *
     * <p>Precondition: the request.getPrompt will return a non-null
     * value.</p>
     *
     * <p>Postcondition: request.getInput will return a non-null
     * value, request.isInputValid will return true.</p>
     * @param request the request to be processed
     * @throws org.apache.tools.ant.BuildException if the input cannot be read from the console
     */
    void handleInput(InputRequest request)
        throws org.apache.tools.ant.BuildException;
}
