/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.motif;

import org.eclipse.swt.internal.*;

 
public class OS {

	/* Load the SWT library. */
	static {
		Library.loadLibrary ("swt");
	}

	/* OS and locale Constants*/
	public static final boolean IsAIX, IsSunOS, IsLinux, IsHPUX;
	public static final boolean IsDBLocale;
	static {
		
		/* Initialize the OS flags and locale constants */
		String osName = System.getProperty ("os.name");
		boolean isAIX = false, isSunOS = false, isLinux = false, isHPUX = false;
		if (osName.equals ("Linux")) isLinux = true;
		if (osName.equals ("AIX")) isAIX = true;
		if (osName.equals ("Solaris")) isSunOS = true;
		if (osName.equals ("SunOS")) isSunOS = true;
		if (osName.equals ("HP-UX")) isHPUX = true;
		IsAIX = isAIX;  IsSunOS = isSunOS;  IsLinux = isLinux;  IsHPUX = isHPUX;
		IsDBLocale = OS.MB_CUR_MAX () != 1;
	}
	public static final int CODESET = CODESET ();
	public static final int LC_CTYPE = LC_CTYPE ();
	
	static final int RESOURCE_LENGTH = 1024 * 3;
	static final int RESOURCE_START = OS.XtMalloc (RESOURCE_LENGTH);
	static int NextResourceStart = RESOURCE_START;
	static {
		OS.setResourceMem (RESOURCE_START, RESOURCE_START + RESOURCE_LENGTH);
	}
	
	/** Constants */
	public static final int Above = 0;
	public static final int AllPlanes = 0xFFFFFFFF;
	public static final int Below = 1;
	public static final int Button1Mask = (1<<8);
	public static final int Button2Mask = (1<<9);
	public static final int Button3Mask = (1<<10);
	public static final int ButtonPress = 4;
	public static final int ButtonPressMask = 1 << 2;
	public static final int ButtonRelease = 5;
	public static final int ButtonReleaseMask = 1 << 3;
	public static final int ButtonMotionMask = 1 << 13;
	public static final int Button1MotionMask = 1 << 8;
	public static final int Button2MotionMask = 1 << 9;
	public static final int Button3MotionMask = 1 << 10;
	public static final int Button4MotionMask = 1 << 11;
	public static final int Button5MotionMask = 1 << 12;
	public static final int CWBackPixmap = 0x1;
	public static final int CWBitGravity = 0x10;
	public static final int CWCursor = 0x4000;
	public static final int CWDontPropagate = 0x1000;
	public static final int CWEventMask = 0x800;
	public static final int CWHeight = 0x8;
	public static final int CWSibling = 0x20;
	public static final int CWStackMode = 0x40;
	public static final int CWWidth = 0x4;
	public static final int CapButt = 0x1;
	public static final int CapRound = 0x2;
	public static final int ClientMessage = 33;
	public static final int Complex = 0;
	public static final int ConfigureNotify = 22;
	public static final int ControlMask = (1<<2);
	public static final int CoordModeOrigin = 0x0;
	public static final int CopyFromParent = 0;
	public static final int CreateNotify = 16;
	public static final int CurrentTime = 0;
	public static final int DestroyNotify = 17;
	public static final int EnterNotify = 7;
	public static final int EnterWindowMask = 1 << 4;
	public static final int EvenOddRule = 0;
	public static final int Expose = 12;
	public static final int ExposureMask = 1 << 15;
	public static final int FillStippled = 0x2;
	public static final int FocusChangeMask = 1 << 21;
	public static final int FocusIn = 9;
	public static final int FocusOut = 10;
	public static final int ForgetGravity = 0;
	public static final int GCBackground = 0x8;
	public static final int GCForeground = 0x4;
	public static final int GCFunction = 0x1;
	public static final int GCLineWidth = 0x10;
	public static final int GXand = 0x1;
	public static final int GXcopy = 0x3;
	public static final int GXxor = 0x6;
	public static final int GrabModeAsync = 1;
	public static final int GrabSuccess = 0;
	public static final int GraphicsExpose = 13;
	public static final int hpXK_BackTab = 0x1000FF74;
	public static final int IconicState = 0x3;
	public static final int IncludeInferiors = 0x1;
	public static final int IsUnviewable = 0x1;
	public static final int IsViewable = 0x2;
	public static final int JoinMiter = 0x0;
	public static final int KeyPress = 2;
	public static final int KeyPressMask = 1 << 0;
	public static final int KeyRelease = 3;
	public static final int KeyReleaseMask = 1 << 1;
	public static final int LSBFirst = 0;
	public static final int LeaveNotify = 8;
	public static final int LeaveWindowMask = 1 << 5;
	public static final int LineOnOffDash = 0x1;
	public static final int LineSolid = 0x0;
	public static final int MSBFirst = 1;
	public static final int MWM_DECOR_BORDER = 0x2;
	public static final int MWM_DECOR_MAXIMIZE = 0x40;
	public static final int MWM_DECOR_MENU = 0x10;
	public static final int MWM_DECOR_MINIMIZE = 0x20;
	public static final int MWM_DECOR_RESIZEH = 0x4;
	public static final int MWM_DECOR_TITLE = 0x8;
	public static final int MWM_INPUT_FULL_APPLICATION_MODAL = 0x3;
	public static final int MWM_INPUT_MODELESS = 0x0;
	public static final int MWM_INPUT_PRIMARY_APPLICATION_MODAL = 0x1;
	public static final int MWM_INPUT_SYSTEM_MODAL = 0x2;
	public static final int MapNotify = 19;
	public static final int Mod1Mask = (1<<3);
	public static final int Mod1MapIndex = 3;
	public static final int Mod2MapIndex = 4;
	public static final int Mod3MapIndex = 5;
	public static final int Mod4MapIndex = 6;
	public static final int Mod5MapIndex = 7;
	public static final int MotionNotify = 6;
	public static final int None = 0;
	public static final int NormalState = 0x1;
	public static final int NotifyAncestor = 0x0;
	public static final int NotifyInferior = 0x2;
	public static final int NotifyNonlinear = 0x3;
	public static final int NotifyNonlinearVirtual = 0x4;
	public static final int NotifyNormal = 0x0;
	public static final int PMinSize = 1 << 4;
	public static final int PMaxSize = 1 << 5;
	public static final int PointerMotionMask = 1 << 6;
	public static final int PointerMotionHintMask = 1 << 7;
	public static final int PropertyChangeMask = 1 << 22;
	public static final int PropertyNotify = 28;
	public static final int PropModeReplace = 0;
	public static final int QueuedAfterReading = 1;
	public static final int RectangleOut = 0x0;
	public static final int ReparentNotify = 21;
	public static final int ResizeRedirectMask = 1 << 18;
	public static final int RevertToParent = 0x2;
	public static final int ShapeBounding = 0;
	public static final int ShapeClip = 1;
	public static final int ShapeSet = 0;
	public static final int ShiftMask = (1<<0);
	public static final int StructureNotifyMask = 1 << 17;
	public static final int SubstructureNotifyMask = 1 << 19;
	public static final int SubstructureRedirectMask = 1 << 20;
	public static final int SunXK_F36 = 0x1005FF10;
	public static final int SunXK_F37 = 0x1005FF11;
	public static final int UnmapNotify = 18;
	public static final int Unsorted = 0x0;
	public static final int XA_ATOM = 4;
	public static final int XA_FONT = 18;
	public static final int XBufferOverflow = 0xFFFFFFFF;
	public static final int XC_X_cursor = 0;
	public static final int XC_bottom_left_corner = 12;
	public static final int XC_bottom_right_corner = 14;
	public static final int XC_bottom_side = 16;
	public static final int XC_cross = 30;
	public static final int XC_double_arrow = 42;
	public static final int XC_fleur = 52;
	public static final int XC_hand2 = 60;
	public static final int XC_left_ptr = 68;
	public static final int XC_left_side = 70;
	public static final int XC_question_arrow = 92;
	public static final int XC_right_side = 96;
	public static final int XC_sb_h_double_arrow = 108;
	public static final int XC_sb_up_arrow = 114;
	public static final int XC_sb_v_double_arrow = 116;
	public static final int XC_sizing = 120;
	public static final int XC_top_left_corner = 134;
	public static final int XC_top_right_corner = 136;
	public static final int XC_top_side = 138;
	public static final int XC_watch = 150;
	public static final int XC_xterm = 152;
	public static final int XCompoundTextStyle = 1;
	public static final int XEMBED_EMBEDDED_NOTIFY = 0;
	public static final int XEMBED_WINDOW_ACTIVATE = 1;
	public static final int XEMBED_WINDOW_DEACTIVATE = 2;
	public static final int XEMBED_REQUEST_FOCUS = 3;
	public static final int XEMBED_FOCUS_IN = 4;
	public static final int XEMBED_FOCUS_OUT = 5;
	public static final int XEMBED_FOCUS_NEXT = 6;
	public static final int XEMBED_FOCUS_PREV = 7;
	public static final int XEMBED_MODALITY_ON = 10;
	public static final int XEMBED_MODALITY_OFF = 11;
	public static final int XEMBED_REGISTER_ACCELERATOR = 12;
	public static final int XEMBED_UNREGISTER_ACCELERATOR = 13;
	public static final int XEMBED_ACTIVATE_ACCELERATOR = 14;
	public static final int XEMBED_FOCUS_CURRENT = 0;
	public static final int XEMBED_FOCUS_FIRST = 1;
	public static final int XEMBED_FOCUS_LAST = 2;
	public static final int XEMBED_MAPPED = 1 << 0;
	public static final int XK_Alt_L = 0xFFE9;
	public static final int XK_Alt_R = 0xFFEA;
	public static final int XK_BackSpace = 0xFF08;
	public static final int XK_Break = 0xFF6B;
	public static final int XK_Cancel = 0xFF69;
	public static final int XK_Caps_Lock = 0xFFE5;
	public static final int XK_Control_L = 0xFFE3;
	public static final int XK_Control_R = 0xFFE4;
	public static final int XK_Delete = 0xFFFF;
	public static final int XK_Down = 0xFF54;
	public static final int XK_End = 0xFF57;
	public static final int XK_Escape = 0xFF1B;
	public static final int XK_F1 = 0xFFBE;
	public static final int XK_F10 = 0xFFC7;
	public static final int XK_F11 = 0xFFC8;
	public static final int XK_F12 = 0xFFC9;
	public static final int XK_F13 = 0xFFCA;
	public static final int XK_F14 = 0xFFCB;
	public static final int XK_F15 = 0xFFCC;
	public static final int XK_F2 = 0xFFBF;
	public static final int XK_F3 = 0xFFC0;
	public static final int XK_F4 = 0xFFC1;
	public static final int XK_F5 = 0xFFC2;
	public static final int XK_F6 = 0xFFC3;
	public static final int XK_F7 = 0xFFC4;
	public static final int XK_F8 = 0xFFC5;
	public static final int XK_F9 = 0xFFC6;
	public static final int XK_Home = 0xFF50;
	public static final int XK_Help = 0xFF6A;
	public static final int XK_ISO_Left_Tab = 0xFE20;
	public static final int XK_Insert = 0xFF63;
	public static final int XK_KP_Enter = 0xFF8D;
	public static final int XK_KP_F1 = 0xFF91;
	public static final int XK_KP_F2 = 0xFF92;
	public static final int XK_KP_F3 = 0xFF93;
	public static final int XK_KP_F4 = 0xFF94;
	public static final int XK_KP_Home = 0xFF95;
	public static final int XK_KP_Left = 0xFF96;
	public static final int XK_KP_Up = 0xFF97;
	public static final int XK_KP_Right = 0xFF98;
	public static final int XK_KP_Down = 0xFF99;
	public static final int XK_KP_Prior = 0xFF9A;
	public static final int XK_KP_Page_Up = 0xFF9A;
	public static final int XK_KP_Next = 0xFF9B;
	public static final int XK_KP_Page_Down = 0xFF9B;
	public static final int XK_KP_End = 0xFF9C;
	public static final int XK_KP_Insert = 0xFF9E;
	public static final int XK_KP_Delete = 0xFF9F;
	public static final int XK_KP_Equal = 0xFFBD;
	public static final int XK_KP_Multiply = 0xFFAA;
	public static final int XK_KP_Add = 0xFFAB;
	public static final int XK_KP_Subtract = 0xFFAD;
	public static final int XK_KP_Decimal = 0xFFAE;
	public static final int XK_KP_Divide = 0xFFAF;
	public static final int XK_KP_0 = 0xFFB0;
	public static final int XK_KP_1 = 0xFFB1;
	public static final int XK_KP_2 = 0xFFB2;
	public static final int XK_KP_3 = 0xFFB3;
	public static final int XK_KP_4 = 0xFFB4;
	public static final int XK_KP_5 = 0xFFB5;
	public static final int XK_KP_6 = 0xFFB6;
	public static final int XK_KP_7 = 0xFFB7;
	public static final int XK_KP_8 = 0xFFB8;
	public static final int XK_KP_9 = 0xFFB9;
	public static final int XK_Left = 0xFF51;
	public static final int XK_Linefeed = 0xFF0A;
	public static final int XK_Meta_L = 0xFFE7;
	public static final int XK_Meta_R = 0xFFE8;
	public static final int XK_Num_Lock= 0xFF7F;
	public static final int XK_Page_Down = 0xFF56;
	public static final int XK_Page_Up = 0xFF55;
	public static final int XK_Pause = 0xFF13;
	public static final int XK_Print = 0xFF61;
	public static final int XK_R1 = 0xFFD2;
	public static final int XK_R2 = 0xFFD3;
	public static final int XK_R3 = 0xFFD4;
	public static final int XK_R4 = 0xFFD5;
	public static final int XK_R5 = 0xFFD6;
	public static final int XK_R6 = 0xFFD7;
	public static final int XK_R7 = 0xFFD8;
	public static final int XK_R9 = 0xFFDA;
	public static final int XK_R13 = 0xFFDE;
	public static final int XK_R15 = 0xFFE0;
	public static final int XK_Return = 0xFF0D;
	public static final int XK_Right = 0xFF53;
	public static final int XK_Scroll_Lock = 0xFF14;
	public static final int XK_Shift_L = 0xFFE1;
	public static final int XK_Shift_R = 0xFFE2;
	public static final int XK_Tab = 0xFF09;
	public static final int XK_Up = 0xFF52;
	public static final int XK_VoidSymbol = 0xFFFFFF;
	public static final int XK_space = 0x20;
	public static final byte XPAttrMerge = 2;
	public static final byte XPDocAttr = 2;
	public static final byte XPJobAttr = 1;
	public static final byte XPPrinterAttr = 4;
	public static final byte XPSpool = 1;
	public static final int XYBitmap = 0;
	public static final int XmALIGNMENT_BEGINNING = 0x0;
	public static final int XmALIGNMENT_CENTER = 0x1;
	public static final int XmALIGNMENT_END = 0x2;
	public static final int XmARROW_DOWN = 0x1;
	public static final int XmARROW_LEFT = 0x2;
	public static final int XmARROW_RIGHT = 0x3;
	public static final int XmARROW_UP = 0x0;
	public static final int XmATTACH_FORM = 0x1;
	public static final int XmBLEND_ALL = 0x0;
	public static final int XmBROWSE_SELECT = 0x3;
	public static final int XmCHARSET_TEXT = 0x0;
	public static final int XmCOMBO_BOX = 0x0;
	public static final int XmCONSTANT = 0x1;
	public static final int XmCOPY_FAILED = 0x0;
	public static final int XmCOPY_TRUNCATED = 0x2;
	public static final int XmCR_DROP_SITE_ENTER_MESSAGE = 0x2;
	public static final int XmCR_DROP_SITE_LEAVE_MESSAGE = 0x1;
	public static final int XmCR_DROP_SITE_MOTION_MESSAGE = 0x3;
	public static final int XmCR_OPERATION_CHANGED = 0x8;
	public static final int XmClipboardSuccess = 0x1;
	public static final int XmDEFAULT_SELECT_COLOR = -1;
	public static final int XmDIALOG_CANCEL_BUTTON = 0x2;
	public static final int XmDIALOG_FULL_APPLICATION_MODAL = 0x2;
	public static final int XmDIALOG_HELP_BUTTON = 0x7;
	public static final int XmDIALOG_LIST = 0x8;
	public static final int XmDIALOG_LIST_LABEL = 0x9;
	public static final int XmDIALOG_MESSAGE_LABEL = 0xA;
	public static final int XmDIALOG_MODELESS = 0x0;
	public static final int XmDIALOG_OK_BUTTON = 0x4;
	public static final int XmDIALOG_PRIMARY_APPLICATION_MODAL = 0x1;
	public static final int XmDIALOG_SELECTION_LABEL = 0xB;
	public static final int XmDIALOG_SYSTEM_MODAL = 0x3;
	public static final int XmDIALOG_TEXT = 0xD;
	public static final int XmDO_NOTHING = 0x2;
	public static final int XmDRAG_DYNAMIC = 5;
	public static final int XmDRAG_UNDER_NONE = 0;
	public static final byte XmDROP = 0;
	public static final byte XmDROP_COPY = (1 << 1);
	public static final int XmDROP_DOWN_COMBO_BOX = 0x1;
	public static final int XmDROP_DOWN_LIST = 0x2;
	public static final byte XmDROP_LINK = (1 << 2);
	public static final byte XmDROP_MOVE = (1 << 0);
	public static final byte XmDROP_NOOP = 0;
	public static final int XmDROP_SITE_ACTIVE = 0;
	public static final int XmDROP_SITE_COMPOSITE = 1;
	public static final int XmDROP_SITE_INACTIVE = 1;
	public static final int XmDROP_SITE_INVALID = 2;
	public static final int XmDROP_SITE_VALID = 3;
	public static final int XmEXTENDED_SELECT = 0x2;
	public static final byte[] XmFONTLIST_DEFAULT_TAG = {0x46, 0x4F, 0x4E, 0x54, 0x4C, 0x49, 0x53, 0x54, 0x5F, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4C, 0x54, 0x5F, 0x54, 0x41, 0x47, 0x5F, 0x53, 0x54, 0x52, 0x49, 0x4E, 0x47, 0x0};
	public static final int XmFONT_IS_FONT = 0x0;
	public static final int XmFONT_IS_FONTSET = 0x1;
	public static final int XmFOREGROUND_COLOR = 0x1;
	public static final int XmFRAME_TITLE_CHILD = 0x2;
	public static final int XmHIGHLIGHT_COLOR = -3;
	public static final int XmHIGHLIGHT_NORMAL = 0x0;
	public static final int XmHORIZONTAL = 0x2;
	public static final int XmLAST_POSITION = -1;
	public static final int XmMAX_ON_BOTTOM = 0x1;
	public static final int XmMAX_ON_RIGHT = 0x3;
	public static final int XmMAX_ON_TOP = 0x0;
	public static final int XmMERGE_REPLACE = 0x1;
	public static final int XmMULTIPLE_SELECT = 0x1;
	public static final int XmMULTI_LINE_EDIT = 0x0;
	public static final int XmNONE = 0x0;
	public static final int XmN_OF_MANY = 0x1;
	public static final int XmNaccelerator = malloc ("accelerator", 4);
	public static final int XmNacceleratorText = malloc ("acceleratorText", 4);
	public static final int XmNactivateCallback = malloc ("activateCallback", 4);
	public static final int XmNalignment = malloc ("alignment", 1);
	public static final int XmNallowShellResize = malloc ("allowShellResize", 1);
	public static final int XmNancestorSensitive = malloc ("ancestorSensitive", 1);
	public static final int XmNanimationStyle = malloc ("animationStyle", 1);
	public static final int XmNarea = malloc ("area", 4);
	public static final int XmNarmCallback = malloc ("armCallback", 4);
	public static final int XmNarrowDirection = malloc ("arrowDirection", 1);
	public static final int XmNarrowSize = malloc ("arrowSize", 2);
	public static final int XmNarrowSpacing = malloc ("arrowSpacing", 2);
	public static final int XmNbackground = malloc ("background", 4);
	public static final int XmNblendModel = malloc ("blendModel", 1);
	public static final int XmNborderColor = malloc ("borderColor", 4);
	public static final int XmNborderWidth = malloc ("borderWidth", 2);
	public static final int XmNbottomAttachment = malloc ("bottomAttachment", 1);
	public static final int XmNbottomShadowColor = malloc ("bottomShadowColor", 4);
	public static final int XmNbrowseSelectionCallback = malloc ("browseSelectionCallback", 4);
	public static final int XmNcancelCallback = malloc ("cancelCallback", 4);
	public static final int XmNcancelLabelString = malloc ("cancelLabelString", 4);
	public static final int XmNcascadingCallback = malloc ("cascadingCallback", 4);
	public static final int XmNchildHorizontalSpacing = malloc ("childHorizontalSpacing", 2);
	public static final int XmNchildren = malloc ("children", 4);
	public static final int XmNclientData = malloc ("clientData", 4);
	public static final int XmNcolormap = malloc ("colormap", 4);
	public static final int XmNcomboBoxType = malloc ("comboBoxType", 1);
	public static final int XmNconvertProc = malloc ("convertProc", 4);
	public static final int XmNcursorPositionVisible = malloc ("cursorPositionVisible", 1);
	public static final int XmNdecrementCallback = malloc ("decrementCallback", 4);
	public static final int XmNdefaultActionCallback = malloc ("defaultActionCallback", 4);
	public static final int XmNdefaultButtonShadowThickness = malloc ("defaultButtonShadowThickness", 4);
	public static final int XmNdeleteResponse = malloc ("deleteResponse", 1);
	public static final int XmNdialogStyle = malloc ("dialogStyle", 1);
	public static final int XmNdialogTitle = malloc ("dialogTitle", 4);
	public static final int XmNdirMask = malloc ("dirMask", 4);
	public static final int XmNdirSpec = malloc ("dirSpec", 4);
	public static final int XmNdirectory = malloc ("directory", 4);
	public static final int XmNdragCallback = malloc ("dragCallback", 4);
	public static final int XmNdragDropFinishCallback = malloc ("dragDropFinishCallback", 4);
	public static final int XmNdragInitiatorProtocolStyle = malloc ("dragInitiatorProtocolStyle", 1);
	public static final int XmNdragOperations = malloc ("dragOperations", 1);
	public static final int XmNdragProc = malloc ("dragProc", 4);
	public static final int XmNdragReceiverProtocolStyle = malloc ("dragReceiverProtocolStyle", 1);
	public static final int XmNdropFinishCallback = malloc ("dropFinishCallback", 4);
	public static final int XmNdropProc = malloc("dropProc", 4);
	public static final int XmNdropSiteActivity = malloc ("dropSiteActivity", 1);
	public static final int XmNdropSiteOperations = malloc ("dropSiteOperations", 1);
	public static final int XmNdropSiteType = malloc ("dropSiteType", 1);
	public static final int XmNdropTransfers = malloc ("dropTransfers", 4);
	public static final int XmNeditMode = malloc ("editMode", 4);
	public static final int XmNeditable = malloc ("editable", 1);
	public static final int XmNenableThinThickness = malloc ("enableThinThickness", 1);
	public static final int XmNexportTargets = malloc ("exportTargets", 4);
	public static final int XmNexposeCallback = malloc ("exposeCallback", 4);
	public static final int XmNextendedSelectionCallback = malloc ("extendedSelectionCallback", 4);
	public static final int XmNfilterLabelString = malloc ("filterLabelString", 4);
	public static final int XmNfont = malloc ("font", 4);
	public static final int XmNfontList = malloc ("fontList", 4);
	public static final int XmNfontType = malloc ("fontType", 4);
	public static final int XmNforeground = malloc ("foreground", 4);
	public static final int XmNframeChildType = malloc ("frameChildType", 1);
	public static final int XmNheight = malloc ("height", 2);
	public static final int XmNhelpCallback = malloc ("helpCallback", 4);
	public static final int XmNhelpLabelString = malloc ("helpLabelString", 4);
	public static final int XmNhighlightColor = malloc ("highlightColor", 4);
	public static final int XmNhighlightThickness = malloc ("highlightThickness", 2);
	public static final int XmNhorizontalScrollBar = malloc ("horizontalScrollBar", 4);
	public static final int XmNiconMask = malloc ("iconMask", 4);
	public static final int XmNiconName = malloc ("iconName", 4);
	public static final int XmNiconPixmap = malloc ("iconPixmap", 4);
	public static final int XmNiconic = malloc ("iconic", 1);
	public static final int XmNimportTargets = malloc("importTargets", 4);
	public static final int XmNincrement = malloc ("increment", 4);
	public static final int XmNincrementCallback = malloc ("incrementCallback", 4);
	public static final int XmNindicatorOn = malloc ("indicatorOn", 1);
	public static final int XmNindicatorType = malloc ("indicatorType", 1);
	public static final int XmNinitialState = malloc ("initialState", 4);
	public static final int XmNitemCount = malloc ("itemCount", 4);
	public static final int XmNitems = malloc ("items", 4);
	public static final int XmNlabelInsensitivePixmap = malloc ("labelInsensitivePixmap", 4);
	public static final int XmNlabelPixmap = malloc ("labelPixmap", 4);
	public static final int XmNlabelString = malloc ("labelString", 4);
	public static final int XmNlabelType = malloc ("labelType", 1);
	public static final int XmNleftAttachment = malloc ("leftAttachment", 1);
	public static final int XmNlist = malloc ("list", 4);
	public static final int XmNlistMarginHeight = malloc ("listMarginHeight", 2);
	public static final int XmNlistMarginWidth = malloc ("listMarginWidth", 2);
	public static final int XmNlistSizePolicy = malloc ("listSizePolicy", 1);
	public static final int XmNlistSpacing = malloc ("listSpacing", 2);
	public static final int XmNmapCallback = malloc ("mapCallback", 4);
	public static final int XmNmappedWhenManaged = malloc ("mappedWhenManaged", 4);
	public static final int XmNmarginBottom = malloc ("marginBottom", 2);
	public static final int XmNmarginHeight = malloc ("marginHeight", 2);
	public static final int XmNmarginLeft = malloc ("marginLeft", 2);
	public static final int XmNmarginRight = malloc ("marginRight", 2);
	public static final int XmNmarginTop = malloc ("marginTop", 2);
	public static final int XmNmarginWidth = malloc ("marginWidth", 2);
	public static final int XmNmaximum = malloc ("maximum", 4);
	public static final int XmNmenuBar = malloc ("menuBar", 4);
	public static final int XmNmessageString = malloc ("messageString", 4);
	public static final int XmNminimum = malloc ("minimum", 4);
	public static final int XmNmnemonic = malloc ("mnemonic", 4);
	public static final int XmNmodifyVerifyCallback = malloc ("modifyVerifyCallback", 4);
	public static final int XmNmultipleSelectionCallback = malloc ("multipleSelectionCallback", 4);
	public static final int XmNmwmDecorations = malloc ("mwmDecorations", 4);
	public static final int XmNmwmInputMode = malloc ("mwmInputMode", 4);
	public static final int XmNnavigationType = malloc ("navigationType", 1);
	public static final int XmNnoResize = malloc ("noResize", 1);
	public static final int XmNnumChildren = malloc ("numChildren", 4);
	public static final int XmNnumDropTransfers = malloc ("numDropTransfers", 4);
	public static final int XmNnumExportTargets = malloc ("numExportTargets", 4);
	public static final int XmNnumImportTargets = malloc("numImportTargets", 4);
	public static final int XmNokCallback = malloc ("okCallback", 4);
	public static final int XmNokLabelString = malloc ("okLabelString", 4);
	public static final int XmNoperationCursorIcon = malloc ("operationCursorIcon", 4);
	public static final int XmNorientation = malloc ("orientation", 1);
	public static final int XmNoverrideRedirect = malloc ("overrideRedirect", 1);
	public static final int XmNpageDecrementCallback = malloc ("pageDecrementCallback", 4);
	public static final int XmNpageIncrement = malloc ("pageIncrement", 4);
	public static final int XmNpageIncrementCallback = malloc ("pageIncrementCallback", 4);
	public static final int XmNpathMode = malloc ("pathMode", 4);
	public static final int XmNpattern = malloc ("pattern", 4);
	public static final int XmNpositionIndex = malloc ("positionIndex", 2);
	public static final int XmNprocessingDirection = malloc ("processingDirection", 1);
	public static final int XmNrecomputeSize = malloc ("recomputeSize", 1);
	public static final int XmNresizable = malloc ("resizable", 1);
	public static final int XmNresizePolicy = malloc ("resizePolicy", 1);
	public static final int XmNrightAttachment = malloc ("rightAttachment", 1);
	public static final int XmNscaleMultiple = malloc ("scaleMultiple", 4);
	public static final int XmNscrollHorizontal = malloc ("scrollHorizontal", 1);
	public static final int XmNscrollVertical = malloc ("scrollVertical", 1);
	public static final int XmNselectColor = malloc ("selectColor", 1);
	public static final int XmNselectedItemCount = malloc ("selectedItemCount", 4);
	public static final int XmNselectedItems = malloc ("selectedItems", 4);
	public static final int XmNselectedPosition = malloc ("selectedPosition", 4);
	public static final int XmNselectionArrayCount = malloc ("selectionArrayCount", 4);
	public static final int XmNselectionCallback = malloc ("selectionCallback", 4);
	public static final int XmNselectionPolicy = malloc ("selectionPolicy", 1);
	public static final int XmNsensitive = malloc ("sensitive", 1);
	public static final int XmNseparatorType = malloc ("separatorType", 1);
	public static final int XmNset = malloc ("set", 1);
	public static final int XmNshadowThickness = malloc ("shadowThickness", 2);
	public static final int XmNshadowType = malloc ("shadowType", 1);
	public static final int XmNshowArrows = malloc ("showArrows", 4);
	public static final int XmNshowAsDefault = malloc ("showAsDefault", 2);
	public static final int XmNsliderSize = malloc ("sliderSize", 4);
	public static final int XmNsliderVisual = malloc ("sliderVisual", 4);
	public static final int XmNsourceCursorIcon = malloc ("sourceCursorIcon", 4);
	public static final int XmNspotLocation = malloc ("spotLocation", 4);
	public static final int XmNstateCursorIcon = malloc ("stateCursorIcon", 4);
	public static final int XmNsubMenuId = malloc ("subMenuId", 4);
	public static final int XmNsubstitute = malloc ("substitute", 4);
	public static final int XmNtabList = malloc ("tabList", 4);
	public static final int XmNtextField = malloc ("textField", 4);
	public static final int XmNtitle = malloc ("title", 4);
	public static final int XmNtitleString = malloc ("titleString", 4);
	public static final int XmNtoBottomCallback = malloc ("toBottomCallback", 4);
	public static final int XmNtoTopCallback = malloc ("toTopCallback", 4);
	public static final int XmNtopAttachment = malloc ("topAttachment", 1);
	public static final int XmNtopItemPosition = malloc ("topItemPosition", 4);
	public static final int XmNtopShadowColor = malloc ("topShadowColor", 4);
	public static final int XmNtransferProc = malloc ("transferProc", 4);
	public static final int XmNtransferStatus = malloc ("transferStatus", 4);
	public static final int XmNtraversalOn = malloc ("traversalOn", 1);
	public static final int XmNtroughColor = malloc ("troughColor", 4);
	public static final int XmNunmapCallback = malloc ("unmapCallback", 4);
	public static final int XmNuserData = malloc ("userData", 4);
	public static final int XmNvalue = malloc ("value", 4);
	public static final int XmNvalueChangedCallback = malloc ("valueChangedCallback", 4);
	public static final int XmNverifyBell = malloc ("verifyBell", 1);
	public static final int XmNverticalScrollBar = malloc ("verticalScrollBar", 4);
	public static final int XmNvisibleItemCount = malloc ("visibleItemCount", 4);
	public static final int XmNwidth = malloc ("width", 2);
	public static final int XmNwordWrap = malloc ("wordWrap", 1);
	public static final int XmNx = malloc ("x", 2);
	public static final int XmNy = malloc ("y", 2);
	public static final int XmONE_OF_MANY = 0x2;
	public static final int XmOUTPUT_ALL = 0x0;
	public static final int XmPATH_MODE_FULL = 0x0;
	public static final int XmPIXELS = 0x0;
	public static final int XmPIXMAP = 0x1;
	public static final int XmRELATIVE = 0x1;
	public static final int XmRESIZE_NONE = 0x0;
	public static final int XmREVERSED_GROUND_COLORS = -2;
	public static final int XmSET = 0x1;
	public static final int XmSHADOW_ETCHED_IN = 0x5;
	public static final int XmSHADOW_ETCHED_OUT = 0x6;
	public static final int XmSHADOW_IN = 0x7;
	public static final int XmSHADOW_OUT = 0x8;
	public static final int XmSINGLE_LINE = 0x1;
	public static final int XmSINGLE_LINE_EDIT = 0x1;
	public static final int XmSTRING = 0x2;
	public static final int XmSTRING_COMPONENT_SEPARATOR = 0x4;
	public static final int XmSTRING_COMPONENT_TAB = 0xC;
	public static final int XmTRANSFER_FAILURE = 0;
	public static final int XmTRAVERSE_CURRENT = 0x0;
	public static final int XmUNSET = 0x0;
	public static final int XmUNSPECIFIED_PIXMAP = 0x2;
	public static final int XmVARIABLE = 0x0;
	public static final int XmVERTICAL = 0x1;
	public static final int XtGrabNone = 0x0;
	public static final int XtIMAlternateInput = 0x4;
	public static final int XtIMTimer = 0x2;
	public static final int XtIMXEvent = 0x1;
	public static final int XtInputReadMask = 1;
	public static final int XtListTail = 0x1;
	public static final int ZPixmap = 2;
	
	
	static int malloc (String name, int length) {
		int strLen = name.length ();
		if (NextResourceStart + strLen + 2 > RESOURCE_START + RESOURCE_LENGTH) {
			System.out.println ("*** Warning : SWT - Resource overrun.  Increase OS.RESOURCE_LENGTH.");
			System.out.println ("*** Warning : Exiting ...");
			System.exit (0);
		}
		char [] unicode = new char [strLen];
		name.getChars (0, strLen, unicode, 0);
		byte[] buffer = new byte [strLen + 2];
		buffer [0] = (byte) length;
		for (int i = 0; i < strLen; i++) {
			buffer [i+1] = (byte) unicode[i];
		}
		OS.memmove (NextResourceStart, buffer, strLen + 2);
		int result = NextResourceStart + 1;
		NextResourceStart += strLen + 2;
		return result;
	}
	static final native int setResourceMem (int start, int end);
	
/** Natives */
public static final synchronized native int Call(int proc, int arg1, int arg2);
public static final synchronized native int ConnectionNumber(int display);
public static final native int CODESET();
public static final native boolean FD_ISSET(int fd, byte[] fd_set);
public static final native void FD_SET(int fd, byte[] fd_set);
public static final native void FD_ZERO(byte[] fd_set);
public static final native int LC_CTYPE();
public static final native int MB_CUR_MAX();
public static final synchronized native int overrideShellWidgetClass();
public static final synchronized native int shellWidgetClass();
public static final synchronized native int topLevelShellWidgetClass();
public static final synchronized native int transientShellWidgetClass();
public static final synchronized native int xmMenuShellWidgetClass();
public static final synchronized native int XAllocColor(int display, int colormap, XColor color);
public static final synchronized native void XBell(int display, int ms);
public static final synchronized native int XBlackPixel(int display, int screenNum);
public static final synchronized native int XChangeActivePointerGrab(int display, int eventMask, int cursor, int time);
public static final synchronized native void XChangeProperty(int display, int w, int property, int type, int format, int mode, int[] data, int nelements);
public static final synchronized native void XChangeWindowAttributes(int display, int window, int mask, XSetWindowAttributes attributes);
public static final synchronized native int XCheckIfEvent(int display, int event_return, int predicate, int arg);
public static final synchronized native boolean XCheckMaskEvent(int display, int mask, int event);
public static final synchronized native boolean XCheckWindowEvent(int display, int window, int mask, int event);
public static final synchronized native void XClearArea(int display, int window, int x, int y, int width, int height, boolean exposures);
public static final synchronized native void XClipBox(int region, XRectangle rectangle);
public static final synchronized native void XCloseDisplay(int display);
public static final synchronized native void XCopyArea(int display, int src, int dest, int gc, int src_x, int src_y, int width, int height, int dest_x, int dest_y);
public static final synchronized native void XCopyPlane(int display, int src, int dest, int gc, int src_x, int src_y, int width, int height, int dest_x, int dest_y, int plane);
public static final synchronized native int XCreateBitmapFromData(int display, int drawable, byte[] data, int width, int height);
public static final synchronized native int XCreateFontCursor(int display, int shape);
public static final synchronized native int XCreateGC(int display, int window, int mask, XGCValues values);
public static final synchronized native int XCreateImage(int display, int visual, int depth, int format, int offset, int data, int width, int height, int bitmap_pad, int bytes_per_line);
public static final synchronized native int XCreatePixmap(int display, int drawable, int width, int height, int depth);
public static final synchronized native int XCreatePixmapCursor(int display, int source, int mask, XColor foreground_color, XColor background_color, int x, int y);
public static final synchronized native int XCreateRegion();
public static final synchronized native int XCreateWindow(int display, int parent, int x, int y, int width, int height, int border_width, int depth, int clazz, int visual, long value_mask, XSetWindowAttributes attributes);
public static final synchronized native int XDefaultColormap(int display, int screen_number);
public static final synchronized native int XDefaultColormapOfScreen(int screen);
public static final synchronized native int XDefaultDepthOfScreen(int screen);
public static final synchronized native int XDefaultGCOfScreen(int screen);
public static final synchronized native int XDefaultRootWindow(int display);
public static final synchronized native int XDefaultScreen(int display);
public static final synchronized native int XDefaultScreenOfDisplay(int display);
public static final synchronized native int XDefaultVisual(int display, int screen_number);
public static final synchronized native void XDefineCursor(int display, int window, int cursor);
public static final synchronized native int XDestroyImage(int ximage);
public static final synchronized native void XDestroyRegion(int region);
public static final synchronized native void XDestroyWindow(int display, int w);
public static final synchronized native int XDisplayHeight(int display, int screen);
public static final synchronized native int XDisplayHeightMM(int display, int screen);
public static final synchronized native int XDisplayWidth(int display, int screen);
public static final synchronized native int XDisplayWidthMM(int display, int screen);
public static final synchronized native void XDrawArc(int display, int drawable, int gc, int x1, int y1, int x2, int y2, int a1, int a2);
public static final synchronized native void XDrawLine(int display, int drawable, int gc, int x1, int y1, int x2, int y2);
public static final synchronized native void XDrawLines(int display, int drawable, int gc, short[] xPoints, int nPoints, int mode);
public static final synchronized native void XDrawRectangle(int display, int drawable, int gc, int x, int y, int width, int height);
public static final synchronized native void XDrawPoint(int display, int drawable, int gc, int x, int y);
public static final synchronized native boolean XEmptyRegion(int region);
public static final synchronized native int XEventsQueued(int display, int mode);
public static final synchronized native void XFillArc(int display, int drawable, int gc, int x1, int y1, int x2, int y2, int a1, int a2);
public static final synchronized native int XFillPolygon(int display, int drawable, int gc, short[] xPoints, int nPoints, int mode, int style);
public static final synchronized native void XFillRectangle(int display, int drawable, int gc, int x, int y, int width, int height);
public static final synchronized native boolean XFilterEvent(int event, int window);
public static final synchronized native void XFlush(int display);
public static final synchronized native int XFontsOfFontSet(int fontSet, int[] fontStructs, int[] fontNames);
public static final synchronized native int XFree(int address);
public static final synchronized native int XFreeColors(int display, int colormap, int[] pixels, int npixels, int planes);
public static final synchronized native void XFreeCursor(int display, int pixmap);
public static final synchronized native void XFreeFont(int display, int font_struct);
public static final synchronized native void XFreeFontNames(int list);
public static final synchronized native void XFreeGC(int display, int gc);
public static final synchronized native void XFreePixmap(int display, int pixmap);
public static final synchronized native void XFreeStringList(int list);
public static final synchronized native int XGetGCValues(int display, int gc, int valuemask, XGCValues values);
public static final synchronized native int XGetGeometry(int display, int drawable, int[] root_return, int[] x_return, int[] y_return, int[] width_return, int[] height_return, int[] border_width_return, int[] depth_return);
public static final synchronized native int XGetImage(int display, int drawable, int x, int y, int width, int height, int plane_mask, int format);
public static final synchronized native int XGetInputFocus(int display, int[] window, int[] revert);
public static final synchronized native boolean XGetWindowAttributes(int display, int window, XWindowAttributes attributes);
public static final synchronized native int XGetWindowProperty(int display, int window, int property, int offset, int length, boolean delete, int req_type, int[] actual_type_return, int[] actual_format_return, int[] nitems_return, int[] bytes_after_return, int[] prop_return);
public static final synchronized native int XGrabKeyboard(int display, int grabWindow, int ownerEvents, int pointerMode, int keyboardMode, int time);
public static final synchronized native int XGrabPointer(int display, int grabWindow, int ownerEvents, int eventMask, int pointerMode, int keyboardMode, int confineToWindow, int cursor, int time);
public static final synchronized native int XInitThreads();
public static final synchronized native int XInternAtom(int display, byte[] name, boolean ifExists);
public static final synchronized native void XIntersectRegion(int sra, int srb, int dr_return);
public static final synchronized native int XKeysymToKeycode(int display, int keysym);
public static final synchronized native int XKeysymToString(int keysym);
public static final synchronized native int XListFonts(int display, byte[] pattern, int maxnames, int[] actual_count_return);
public static final synchronized native int XListProperties(int display, int window, int[] num_prop_return);
public static final synchronized native int XLocaleOfFontSet(int fontSet);
public static final synchronized native int XLookupString(XKeyEvent event, byte[] string, int size, int[] keysym, int[] status);
public static final synchronized native int XLowerWindow(int display, int window);
public static final synchronized native void XMapWindow(int display, int w);
public static final synchronized native int XGetModifierMapping(int display);
public static final synchronized native int XGetIconSizes(int display, int w, int[] size_list_return, int[] count_return);
public static final synchronized native void XMoveResizeWindow(int display, int w, int x, int y, int width, int height);
public static final synchronized native int XOpenDisplay(byte[] display_name);
public static final synchronized native boolean XPointInRegion(int region, int x, int y);
public static final synchronized native int XPolygonRegion(short[] points, int n, int fill_rule);
public static final synchronized native int XPutImage(int display, int drawable, int gc, int image, int srcX, int srcY, int destX, int destY, int width, int height);
public static final synchronized native int XQueryColor(int display, int colormap, XColor color);
public static final synchronized native int XQueryBestCursor(int display, int d, int width, int height, int[] width_return, int[] height_return);
public static final synchronized native int XQueryPointer(int display, int window, int[] root, int[] child, int[] rootX, int[] rootY, int[] windowX, int[] windowY, int[] mask);
public static final synchronized native int XQueryTree(int display, int window, int[] root_return, int[] parent_return, int[] children_return, int[] nChildren_return);
public static final synchronized native int XRaiseWindow(int display, int window);
public static final synchronized native int XReconfigureWMWindow(int display, int window, int screen, int valueMask, XWindowChanges values);
public static final synchronized native int XRectInRegion(int region, int x, int y, int width, int height);
public static final synchronized native int XReparentWindow(int display, int win, int parent, int x, int y);
public static final synchronized native void XResizeWindow(int display, int w, int width, int height);
public static final synchronized native int XRootWindowOfScreen(int screen);
public static final synchronized native void XSelectInput(int display, int window, int mask);
public static final synchronized native int XSendEvent(int display, int window, boolean propagate, int event_mask, int event);
public static final synchronized native void XSetBackground(int display, int gc, int background);
public static final synchronized native void XSetClipMask(int display, int gc, int pixmap);
public static final synchronized native void XSetClipRectangles(int display, int gc, int clip_x_origin, int clip_y_origin, XRectangle rectangles, int n, int ordering);
public static final synchronized native int XSetDashes(int display, int gc, int dash_offset, byte[] dash_list, int n);
public static final synchronized native int XSetErrorHandler(int handler);
public static final synchronized native void XSetFillStyle(int display, int gc, int fill_style);
public static final synchronized native void XSetForeground(int display, int gc, int foreground);
public static final synchronized native void XSetFunction(int display, int gc, int function);
public static final synchronized native void XSetGraphicsExposures(int display, int gc, boolean graphics_exposures);
public static final synchronized native int XSetIOErrorHandler(int handler);
public static final synchronized native int XSetInputFocus(int display, int window, int revert, int time);
public static final synchronized native int XSetLineAttributes(int display, int gc, int lineWidth, int lineStyle, int capStyle, int joinStyle);
public static final synchronized native void XSetRegion(int display, int gc, int region);
public static final synchronized native void XSetStipple(int display, int gc, int pixmap);
public static final synchronized native void XSetSubwindowMode(int display, int gc, int subwindow_mode);
public static final synchronized native void XSetWMNormalHints(int display, int w, XSizeHints hints);
public static final synchronized native void XShapeCombineMask(int display, int dest, int dest_kind, int x_off, int y_off, int src, int op);
public static final synchronized native void XShapeCombineRegion(int display, int dest, int dest_kind, int x_off, int y_off, int region, int op);
public static final synchronized native void XSubtractRegion(int sra, int srb, int dr_return);
public static final synchronized native void XSync(int display, boolean discard);
public static final synchronized native int XSynchronize(int display, boolean onoff);
public static final synchronized native void XTestFakeButtonEvent(int display, int button, boolean is_press, int delay);
public static final synchronized native void XTestFakeKeyEvent(int display, int keycode, boolean is_press, int delay);
public static final synchronized native void XTestFakeMotionEvent(int display, int screen_number, int x, int y, int delay);
public static final synchronized native void XUndefineCursor(int display, int window);
public static final synchronized native int XUngrabKeyboard(int display, int time);
public static final synchronized native int XUngrabPointer(int display, int time);
public static final synchronized native void XUnionRectWithRegion(XRectangle rectangle, int src_region, int dest_region_return);
public static final synchronized native void XUnionRegion(int sra, int srb, int dr_return);
public static final synchronized native void XUnmapWindow(int display, int window);
public static final synchronized native int XWarpPointer(int display, int sourceWindow, int destWindow, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int destX, int destY);
public static final synchronized native int XWhitePixel(int display, int screenNum);
public static final synchronized native void XWithdrawWindow(int display, int window, int screen);
public static final synchronized native boolean XineramaIsActive(int dpy);
public static final synchronized native int XineramaQueryScreens(int dpy, int[] number);
public static final synchronized native void XmAddWMProtocolCallback(int shell, int protocol, int callback, int closure);
public static final synchronized native void XmChangeColor(int widget, int pixel);
public static final synchronized native int XmClipboardCopy(int display, int window, int item_id, byte[] format_name, byte[] buffer, int length, int private_id, int[] data_id);
public static final synchronized native int XmClipboardEndCopy(int display, int window, int item_id);
public static final synchronized native int XmClipboardEndRetrieve(int display, int window);
public static final synchronized native int XmClipboardInquireCount(int display, int window, int[] count, int[] max_format_name_length);
public static final synchronized native int XmClipboardInquireFormat(int display, int window, int index, byte[] format_name_buf, int buffer_len, int[] copied_len);
public static final synchronized native int XmClipboardInquireLength(int display, int widget, byte[] format_name, int[] length);
public static final synchronized native int XmClipboardRetrieve(int display, int window, byte[] format_name, byte[] buffer, int length, int[] num_bytes, int[] private_id);
public static final synchronized native int XmClipboardStartCopy(int display, int window, int clip_label, int timestamp, int widget, int callback, int[] item_id);
public static final synchronized native int XmClipboardStartRetrieve(int display, int window, int timestamp);
public static final synchronized native void XmComboBoxAddItem(int widget, int xmString, int position, boolean unique);
public static final synchronized native void XmComboBoxDeletePos(int widget, int position);
public static final synchronized native void XmComboBoxSelectItem(int widget, int xmString);
public static final synchronized native int XmCreateArrowButton(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateCascadeButtonGadget(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateComboBox(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateDialogShell(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateDrawingArea(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateDrawnButton(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateErrorDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateFileSelectionDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateForm(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateFrame(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateInformationDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateLabel(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateList(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateMainWindow(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateMenuBar(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateMessageDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreatePopupMenu(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreatePulldownMenu(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreatePushButton(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreatePushButtonGadget(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateQuestionDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateScale(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateScrollBar(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateScrolledList(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateScrolledText(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateSeparator(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateSeparatorGadget(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateTextField(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateToggleButton(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateToggleButtonGadget(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateWarningDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native int XmCreateWorkingDialog(int parent, byte[] name, int[] arglist, int argcount);
public static final synchronized native boolean XmDestroyPixmap(int screen, int pixmap);
public static final synchronized native void XmDragCancel(int dragcontext);
public static final synchronized native int XmDragStart(int widget, int event, int[] arglist, int argcount);
public static final synchronized native void XmDropSiteRegister(int widget, int[] arglist, int argcount);
public static final synchronized native void XmDropSiteUnregister(int widget);
public static final synchronized native void XmDropSiteUpdate(int widget, int[] arglist, int argcount);
public static final synchronized native void XmDropTransferAdd(int drop_transfer, int[] transfers, int num_transfers);
public static final synchronized native int XmDropTransferStart(int widget, int[] arglist, int argcount);
public static final synchronized native int XmFileSelectionBoxGetChild(int widget, int child);
public static final synchronized native int XmFontListAppendEntry(int oldList, int entry);
public static final synchronized native int XmFontListCopy(int fontlist);
public static final synchronized native void XmFontListEntryFree(int[] entry);
public static final synchronized native int XmFontListEntryGetFont(int entry, int[] type_return);
public static final synchronized native int XmFontListEntryLoad(int display, byte[] fontName, int type, byte[] tag);
public static final synchronized native void XmFontListFree(int list);
public static final synchronized native void XmFontListFreeFontContext(int context);
public static final synchronized native boolean XmFontListInitFontContext(int[] context, int fontList);
public static final synchronized native int XmFontListNextEntry(int context);
public static final synchronized native int XmGetAtomName(int display, int atom);
public static final synchronized native int XmGetDragContext(int widget, int timestamp);
public static final synchronized native int XmGetFocusWidget(int widget);
public static final synchronized native int XmGetPixmap(int screen, byte[] name, int fgPixel, int bgPixel);
public static final synchronized native int XmGetPixmapByDepth(int screen, byte[] image_name, int foreground, int background, int depth);
public static final synchronized native int XmGetXmDisplay(int display);
public static final synchronized native int XmImMbLookupString(int widget, XKeyEvent event, byte[] string, int size, int[] keysym, int[] status);
public static final synchronized native void XmImRegister(int widget, int reserved);
public static final synchronized native void XmImSetFocusValues(int widget, int[] args, int num_args);
public static final synchronized native void XmImSetValues(int widget, int[] args, int num_args);
public static final synchronized native void XmImUnregister(int widget);
public static final synchronized native void XmImUnsetFocus(int widget);
public static final synchronized native int XmInternAtom(int display, byte[] name, boolean only_if_exists);
public static final synchronized native void XmListAddItemUnselected(int list, int xmString, int position);
public static final synchronized native void XmListDeleteAllItems(int list);
public static final synchronized native void XmListDeleteItemsPos(int list, int item_count, int position);
public static final synchronized native void XmListDeletePos(int list, int position);
public static final synchronized native void XmListDeletePositions(int list, int[] position_list, int position_count);
public static final synchronized native void XmListDeselectAllItems(int list);
public static final synchronized native void XmListDeselectPos(int list, int position);
public static final synchronized native int XmListGetKbdItemPos(int list);
public static final synchronized native boolean XmListGetSelectedPos(int list, int[] positions, int[] count);
public static final synchronized native int XmListItemPos(int list, int xmString);
public static final synchronized native boolean XmListPosSelected(int list, int position);
public static final synchronized native void XmListReplaceItemsPosUnselected(int list, int[] new_items, int item_count, int position);
public static final synchronized native void XmListSelectPos(int list, int position, boolean notify);
public static final synchronized native boolean XmListSetKbdItemPos(int list, int position);
public static final synchronized native void XmListSetPos(int list, int position);
public static final synchronized native void XmListUpdateSelectedList(int list);
public static final synchronized native void XmMainWindowSetAreas(int widget, int menu, int command, int hscroll, int vscroll, int wregion);
public static final synchronized native int XmMessageBoxGetChild(int widget, int child);
public static final synchronized native int XmParseMappingCreate(int[] argList, int argCount);
public static final synchronized native void XmParseMappingFree(int parseMapping);
public static final synchronized native boolean XmProcessTraversal(int widget, int dir);
public static final synchronized native int XmRenderTableAddRenditions(int oldTable, int[] renditions, int renditionCount, int mergeMode);
public static final synchronized native void XmRenderTableFree(int renderTable);
public static final synchronized native int XmRenditionCreate(int widget, byte[] tag, int[] argList, int argCount);
public static final synchronized native void XmRenditionFree(int rendition);
public static final synchronized native int XmStringBaseline(int fontList, int xmString);
public static final synchronized native boolean XmStringCompare(int xmString1, int xmString2);
public static final synchronized native int XmStringComponentCreate(int type, int length, byte[] value);
public static final synchronized native int XmStringConcat(int xmString1, int xmString2);
public static final synchronized native int XmStringCreate(byte[] string, byte[] charset);
public static final synchronized native int XmStringCreateLocalized(byte[] string);
public static final synchronized native void XmStringDraw(int display, int window, int renderTable, int xmString, int gc, int x, int y, int width, int align, int lay_dir, XRectangle clip);
public static final synchronized native void XmStringDrawImage(int display, int window, int renderTable, int xmString, int gc, int x, int y, int width, int align, int lay_dir, XRectangle clip);
public static final synchronized native void XmStringDrawUnderline(int display, int window, int fontlist, int xmString, int gc, int x, int y, int width, int align, int lay_dir, XRectangle clip, int xmStringUnderline);
public static final synchronized native boolean XmStringEmpty(int s1);
public static final synchronized native void XmStringExtent(int fontList, int xmString, short[] width, short[] height);
public static final synchronized native void XmStringFree(int xmString);
public static final synchronized native int XmStringGenerate(byte[] text, byte[] tag, int type, byte[] rendition);
public static final synchronized native int XmStringHeight(int fontList, int xmString);
public static final synchronized native int XmStringParseText(byte[] text, int textEnd, byte[] tag, int tagType, int[] parseTable, int parseCount, int callData);
public static final synchronized native int XmStringUnparse(int xmString, byte[] tag, int tagType, int outputType, int[] parseTable, int parseCount, int parseModel);
public static final synchronized native int XmStringWidth(int fontList, int xmString);
public static final synchronized native int XmTabCreate(int value, byte units, byte offsetModel, byte alignment, byte[] decimal);
public static final synchronized native void XmTabFree(int tab);
public static final synchronized native void XmTabListFree(int tabList);
public static final synchronized native int XmTabListInsertTabs(int oldList, int[] tabs, int tab_count, int position);
public static final synchronized native void XmTextClearSelection(int widget, int time);
public static final synchronized native boolean XmTextCopy(int widget, int time);
public static final synchronized native boolean XmTextCut(int widget, int time);
public static final synchronized native void XmTextDisableRedisplay(int widget);
public static final synchronized native void XmTextEnableRedisplay(int widget);
public static final synchronized native boolean XmTextFieldPaste(int widget);
public static final synchronized native int XmTextGetInsertionPosition(int widget);
public static final synchronized native int XmTextGetLastPosition(int widget);
public static final synchronized native int XmTextGetMaxLength(int widget);
public static final synchronized native int XmTextGetSelection(int widget);
public static final synchronized native boolean XmTextGetSelectionPosition(int widget, int[] left, int[] right);
public static final synchronized native int XmTextGetString(int widget);
public static final synchronized native int XmTextGetSubstring(int widget, int start, int num_chars, int buffer_size, byte[] buffer);
public static final synchronized native int XmTextGetSubstringWcs(int widget, int start, int num_chars, int buffer_size, char[] buffer);
public static final synchronized native void XmTextInsert(int widget, int position, byte[] value);
public static final synchronized native boolean XmTextPaste(int widget);
public static final synchronized native boolean XmTextPosToXY(int widget, int position, short[] x, short[] y);
public static final synchronized native void XmTextReplace(int widget, int from_pos, int to_pos, byte[] value);
public static final synchronized native void XmTextScroll(int widget, int lines);
public static final synchronized native void XmTextSetEditable(int widget, boolean editable);
public static final synchronized native void XmTextSetHighlight(int widget, int left, int right, int mode);
public static final synchronized native void XmTextSetInsertionPosition(int widget, int position);
public static final synchronized native void XmTextSetMaxLength(int widget, int max_length);
public static final synchronized native void XmTextSetSelection(int widget, int first, int last, int time);
public static final synchronized native void XmTextSetString(int widget, byte[] value);
public static final synchronized native void XmTextShowPosition(int widget, int position);
public static final synchronized native void XmUpdateDisplay(int widget);
public static final synchronized native boolean XmWidgetGetDisplayRect(int region, XRectangle rectangle);
public static final synchronized native int XmbTextListToTextProperty(int display, int list, int count, int style, XTextProperty text_prop_return);
public static final synchronized native int XmbTextPropertyToTextList(int display, XTextProperty text_prop, int[] list_return, int[] count_return);
public static final synchronized native void XpCancelJob(int display, boolean discard);
public static final synchronized native int XpCreateContext(int display, byte[] printer_name);
public static final synchronized native void XpDestroyContext(int display, int print_context);
public static final synchronized native void XpEndJob(int display);
public static final synchronized native void XpEndPage(int display);
public static final synchronized native void XpFreePrinterList(int printer_list);
public static final synchronized native int XpGetOneAttribute(int display, int print_context, byte type, byte[] attribute_name);
public static final synchronized native int XpGetPageDimensions(int display, int print_context, short[] width, short[] height, XRectangle reproducible_area);
public static final synchronized native int XpGetPrinterList(int display, byte[] printer_name, int[] list_count);
public static final synchronized native int XpGetScreenOfContext(int display, int print_context);
public static final synchronized native void XpSetAttributes(int display, int print_context, byte type, byte[] pool, byte replacement_rule);
public static final synchronized native void XpSetContext(int display, int print_context);
public static final synchronized native void XpStartJob(int display, byte save_data);
public static final synchronized native void XpStartPage(int display, int window);
public static final synchronized native void XtAddCallback(int widget, int callback_name, int callback, int client_data);
public static final synchronized native void XtAddEventHandler(int widget, int event_mask, boolean nonmaskable, int proc, int client_data);
public static final synchronized native void XtAddExposureToRegion(int event, int region);
public static final synchronized native int XtAppAddInput(int app_context, int source, int condition, int proc, int client_data);
public static final synchronized native int XtAppAddTimeOut(int app_context, int interval, int proc, int client_data);
public static final synchronized native int XtAppCreateShell(byte[] appName, byte[] appClass, int widgetClass, int display, int[] argList, int argCount);
public static final synchronized native int XtAppGetSelectionTimeout(int appContext);
public static final synchronized native void XtAppNextEvent(int appContext, int event);
public static final synchronized native boolean XtAppPeekEvent(int appContext, int event);
public static final synchronized native int XtAppPending(int appContext);
public static final synchronized native void XtAppProcessEvent(int appContext, int inputMask);
public static final synchronized native int XtAppSetErrorHandler(int app_context, int handler);
public static final synchronized native void XtAppSetFallbackResources(int app_context, int specification_list);
public static final synchronized native void XtAppSetSelectionTimeout(int appContext, int timeout);
public static final synchronized native int XtAppSetWarningHandler(int app_context, int handler);
public static final synchronized native int XtBuildEventMask(int widget);
public static final synchronized native void XtCallActionProc(int widget, byte[] action, int event, int[] params, int num_params);
public static final synchronized native int XtClass(int widget);
public static final synchronized native void XtConfigureWidget(int widget, int x, int y, int width, int height, int borderWidth);
public static final synchronized native int XtCreateApplicationContext();
public static final synchronized native int XtCreatePopupShell(byte[] name, int widgetClass, int parent, int[] argList, int argCount);
public static final synchronized native void XtDestroyApplicationContext(int appContext);
public static final synchronized native void XtDestroyWidget(int widget);
public static final synchronized native boolean XtDispatchEvent(int event);
public static final synchronized native int XtDisplay(int widget);
public static final synchronized native int XtDisplayToApplicationContext(int display);
public static final synchronized native void XtFree(int ptr);
public static final synchronized native int XtGetMultiClickTime(int display);
public static final synchronized native void XtGetValues(int widget, int[] argList, int numArgs);
public static final synchronized native void XtInsertEventHandler(int w, int event_mask, boolean nonmaskable, int proc, int client_data, int position);
public static final synchronized native boolean XtIsManaged(int widget);
public static final synchronized native boolean XtIsRealized(int widget);
public static final synchronized native boolean XtIsSubclass(int widget, int widgetClass);
public static final synchronized native boolean XtIsTopLevelShell(int widget);
public static final synchronized native int XtLastTimestampProcessed(int display);
public static final synchronized native int XtMalloc(int size);
public static final synchronized native void XtManageChild(int widget);
public static final synchronized native void XtMapWidget(int widget);
public static final synchronized native void XtMoveWidget(int widget, int x, int y);
public static final synchronized native int XtNameToWidget(int reference, byte[] names);
public static final synchronized native int XtOpenDisplay(int xtAppContext, byte[] displayName, byte[] applicationName, byte[] applicationClass, int options, int numOptions, int[] argc, int argv);
public static final synchronized native void XtOverrideTranslations(int w, int translations);
public static final synchronized native int XtParent(int widget);
public static final synchronized native int XtParseTranslationTable(byte[] string);
public static final synchronized native void XtPopdown(int widget);
public static final synchronized native void XtPopup(int widget, int flags);
public static final synchronized native int XtQueryGeometry(int widget, XtWidgetGeometry intended, XtWidgetGeometry preferred_return);
public static final synchronized native void XtRealizeWidget(int widget);
public static final synchronized native void XtRegisterDrawable(int display, int drawable, int widget);
public static final synchronized native void XtRemoveEventHandler(int widget, int event_mask, boolean nonmaskable, int proc, int client_data);
public static final synchronized native void XtRemoveInput(int id);
public static final synchronized native void XtRemoveTimeOut(int id);
public static final synchronized native void XtResizeWidget(int widget, int width, int height, int borderWidth);
public static final synchronized native void XtResizeWindow(int widget);
public static final synchronized native int XtSetLanguageProc(int appContext, int languageProc, int pointer);
public static final synchronized native void XtSetMappedWhenManaged(int widget, boolean flag);
public static final synchronized native void XtSetValues(int widget, int[] argList, int numArgs);
public static final synchronized native void XtToolkitInitialize();
public static final synchronized native boolean XtToolkitThreadInitialize();
public static final synchronized native void XtTranslateCoords(int widget, short x, short y, short[] root_x, short[] root_y);
public static final synchronized native void XtUnmanageChild(int widget);
public static final synchronized native void XtUnmapWidget(int widget);
public static final synchronized native void XtUnregisterDrawable(int display, int drawable);
public static final synchronized native int XtWindow(int widget);
public static final synchronized native int XtWindowToWidget(int display, int widget);
public static final synchronized native void _XmSetMenuTraversal(int menu, boolean traversal);
public static final native int close(int filedes);
public static final native int fd_set_sizeof();
public static final native int getenv(byte[] name);
public static final native int iconv(int cd, int[] inBuf, int[] inBytesLeft, int[] outBuf, int[] outBytesLeft);
public static final native int iconv_close(int cd);
public static final native int iconv_open(byte[] tocode, byte[] fromcode);
public static final native void memmove(int dest, XImage src, int count);
public static final native void memmove(int dest, XmDragProcCallbackStruct src, int count);
public static final native void memmove(int dest, XmTextBlockRec src, int count);
public static final native void memmove(int dest, XmTextVerifyCallbackStruct src, int count);
public static final native void memmove(int dest, byte[] src, int count);
public static final native void memmove(int dest, char[] src, int count);
public static final native void memmove(int dest, int[] src, int count);
public static final native void memmove(Visual dest, int src, int count);
public static final native void memmove(XButtonEvent dest, int src, int count);
public static final native void memmove(int dest, XButtonEvent src, int count);
public static final native void memmove(XCharStruct dest, int src, int count);
public static final native void memmove(XClientMessageEvent dest, int src, int count);
public static final native void memmove(XConfigureEvent dest, int src, int count);
public static final native void memmove(XCreateWindowEvent dest, int src, int count);
public static final native void memmove(XCrossingEvent dest, int src, int count);
public static final native void memmove(XDestroyWindowEvent dest, int src, int count);
public static final native void memmove(XExposeEvent dest, int src, int count);
public static final native void memmove(XFocusChangeEvent dest, int src, int count);
public static final native void memmove(XFontStruct dest, int src, int count);
public static final native void memmove(XImage dest, int src, int count);
public static final native void memmove(XineramaScreenInfo dest, int src, int count);
public static final native void memmove(XKeyEvent dest, int src, int count);
public static final native void memmove(XEvent dest, int src, int count);
public static final native void memmove(XModifierKeymap dest, int src, int count);
public static final native void memmove(XMotionEvent dest, int src, int count);
public static final native void memmove(XPropertyEvent dest, int src, int count);
public static final native void memmove(XReparentEvent dest, int src, int count);
public static final native void memmove(XmAnyCallbackStruct dest, int src, int count);
public static final native void memmove(XmDragProcCallbackStruct dest, int src, int count);
public static final native void memmove(XmDropFinishCallbackStruct dest, int src, int count);
public static final native void memmove(XmDropProcCallbackStruct dest, int src, int count);
public static final native void memmove(XmTextBlockRec dest, int src, int count);
public static final native void memmove(XmTextVerifyCallbackStruct dest, int src, int count);
public static final native void memmove(byte[] dest, int src, int count);
public static final native void memmove(char[] dest, int src, int count);
public static final native void memmove(int[] dest, int src, int count);
public static final native void memmove(int dest, short[] src, int count);
public static final native void memmove(int dest, XExposeEvent src, int count);
public static final native void memmove(int dest, XClientMessageEvent src, int count);
public static final native void memmove(int dest, XConfigureEvent src, int count);
public static final native void memmove(int dest, XKeyEvent src, int count);
public static final native void memmove(XIconSize dest, int src, int count);
public static final native int nl_langinfo(int item);
public static final native int pipe(int[] filedes);
public static final native int read(int filedes, byte[] buf, int nbyte);
public static final native int select(int n, byte[] readfds, byte[] writefds, byte[] exceptfds, int[] timeout);
public static final native int setlocale(int category, byte[] locale);
public static final native int strlen(int string);
public static final native int write(int filedes, byte[] buf, int nbyte);

}
