/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Regexp<T extends Comparable<T>>
implements Filter {
    protected String value;
    protected FilterType filterType;
    protected Pattern pattern;
    protected boolean not;

    public Regexp() {
    }

    public Regexp(String value, FilterType filterType, boolean not) {
        this.value = value;
        this.filterType = filterType;
        this.not = not;
        try {
            this.pattern = Pattern.compile(this.value);
        }
        catch (PatternSyntaxException e) {
            throw new PatternSyntaxException("Regular expression error", value, e.getIndex());
        }
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return true;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (this.filterType != FilterType.VALUE_FILTER) {
            return false;
        }
        return this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find() != this.not;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public Filter copy() {
        return new Regexp<T>(this.value, this.filterType, this.not);
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.write(this.value, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Boolean)this.not, (OutputStream)outputStream);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to serialize outputStream of type:", ex);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.value = ReadWriteIOUtils.readString(buffer);
        if (this.value != null) {
            try {
                this.pattern = Pattern.compile(this.value);
            }
            catch (PatternSyntaxException e) {
                throw new PatternSyntaxException("Regular expression error", this.value, e.getIndex());
            }
        }
        this.not = ReadWriteIOUtils.readBool(buffer);
    }

    public String toString() {
        return (Object)((Object)this.filterType) + (this.not ? " not regexp " : " regexp ") + this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Regexp && Objects.equals(((Regexp)o).value, this.value) && ((Regexp)o).filterType == this.filterType && ((Regexp)o).not == this.not;
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.REGEXP;
    }

    public static class MatcherInput
    implements CharSequence {
        private final CharSequence value;
        private final AccessCount access;

        public MatcherInput(CharSequence value, AccessCount access) {
            this.value = value;
            this.access = access;
        }

        @Override
        public char charAt(int index) {
            this.access.check();
            return this.value.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new MatcherInput(this.value.subSequence(start, end), this.access);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }

    public static class AccessCount {
        private int count;
        private final int accessThreshold = TSFileDescriptor.getInstance().getConfig().getPatternMatchingThreshold();

        public void check() throws IllegalStateException {
            if (this.count++ > this.accessThreshold) {
                throw new IllegalStateException("Pattern access threshold exceeded");
            }
        }
    }
}

