/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.headers;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.util.annotations.UInt32Primitive;

public class SymmetricSecurityHeader {
    public static final int SYMMETRIC_SECURITY_HEADER_SIZE = 4;
    @UInt32Primitive
    private final long tokenId;

    public SymmetricSecurityHeader(long tokenId) {
        this.tokenId = tokenId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymmetricSecurityHeader that = (SymmetricSecurityHeader)o;
        return this.tokenId == that.tokenId;
    }

    public int hashCode() {
        return (int)(this.tokenId ^ this.tokenId >>> 32);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokenId", this.tokenId).toString();
    }

    public static ByteBuf encode(SymmetricSecurityHeader header, ByteBuf buffer) {
        buffer.writeIntLE((int)header.getTokenId());
        return buffer;
    }

    public static SymmetricSecurityHeader decode(ByteBuf buffer) {
        return new SymmetricSecurityHeader(buffer.readUnsignedIntLE());
    }
}

