/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeTransferFileSealReqV1
extends TPipeTransferReq {
    private transient String fileName;
    private transient long fileLength;

    public final String getFileName() {
        return this.fileName;
    }

    public final long getFileLength() {
        return this.fileLength;
    }

    protected abstract PipeRequestType getPlanType();

    protected PipeTransferFileSealReqV1 convertToTPipeTransferReq(String fileName, long fileLength) throws IOException {
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)fileLength, (OutputStream)outputStream);
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    public PipeTransferFileSealReqV1 translateFromTPipeTransferReq(TPipeTransferReq req) {
        this.fileName = ReadWriteIOUtils.readString((ByteBuffer)req.body);
        this.fileLength = ReadWriteIOUtils.readLong((ByteBuffer)req.body);
        this.version = req.version;
        this.type = req.type;
        return this;
    }

    public byte[] convertToTPipeTransferSnapshotSealBytes(String fileName, long fileLength) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBSinkRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)this.getPlanType().getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)fileLength, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferFileSealReqV1 that = (PipeTransferFileSealReqV1)((Object)obj);
        return this.fileName.equals(that.fileName) && this.fileLength == that.fileLength && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileLength, this.version, this.type, this.body);
    }
}

