/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.receiver.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeUnion;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.receiver.IoTDBFileReceiver;
import org.apache.iotdb.commons.pipe.receiver.PipeReceiverStatusHandler;
import org.apache.iotdb.commons.pipe.sink.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFileSealReqV1;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeCreateTableOrViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteDevicesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AddTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableColumnCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.AddTableViewColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.CommitDeleteViewColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.CommitDeleteViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.RenameViewColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.RenameViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.SetViewCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.SetViewPropertiesPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.metric.receiver.PipeConfigNodeReceiverMetrics;
import org.apache.iotdb.confignode.manager.pipe.receiver.visitor.PipeConfigPhysicalPlanExceptionVisitor;
import org.apache.iotdb.confignode.manager.pipe.receiver.visitor.PipeConfigPhysicalPlanTSStatusVisitor;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigNodeHandshakeV1Req;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigNodeHandshakeV2Req;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigPlanReq;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigSnapshotPieceReq;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigSnapshotSealReq;
import org.apache.iotdb.confignode.manager.pipe.source.IoTDBConfigRegionSource;
import org.apache.iotdb.confignode.persistence.schema.CNPhysicalPlanGenerator;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.confignode.persistence.schema.ConfigNodeSnapshotParser;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AddTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.CreateTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.DropTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.DropTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.RenameTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.RenameTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.SetTablePropertiesProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.AddViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.CreateTableViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.DropViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.DropViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.RenameViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.RenameViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.SetViewPropertiesProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigNodeReceiver
extends IoTDBFileReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigNodeReceiver.class);
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final AtomicInteger QUERY_ID_GENERATOR = new AtomicInteger(0);
    private static final PipeConfigPhysicalPlanTSStatusVisitor STATUS_VISITOR = new PipeConfigPhysicalPlanTSStatusVisitor();
    private static final PipeConfigPhysicalPlanExceptionVisitor EXCEPTION_VISITOR = new PipeConfigPhysicalPlanExceptionVisitor();
    private final ConfigManager configManager = ConfigNode.getInstance().getConfigManager();

    public TPipeTransferResp receive(TPipeTransferReq req) {
        try {
            short rawRequestType = req.getType();
            if (PipeRequestType.isValidatedRequestType((short)rawRequestType)) {
                PipeRequestType type = PipeRequestType.valueOf((short)rawRequestType);
                if (this.needHandshake(type)) {
                    return new TPipeTransferResp(new TSStatus(TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()).setMessage("The receiver ConfigNode has set up a new receiver and the sender must re-send its handshake request."));
                }
                long startTime = System.nanoTime();
                switch (type) {
                    case HANDSHAKE_CONFIGNODE_V1: {
                        TPipeTransferResp resp = this.handleTransferHandshakeV1(PipeTransferConfigNodeHandshakeV1Req.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordHandshakeConfigNodeV1Timer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case HANDSHAKE_CONFIGNODE_V2: {
                        TPipeTransferResp resp = this.handleTransferHandshakeV2(PipeTransferConfigNodeHandshakeV2Req.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordHandshakeConfigNodeV2Timer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_CONFIG_PLAN: {
                        TPipeTransferResp resp = this.handleTransferConfigPlan(PipeTransferConfigPlanReq.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordTransferConfigPlanTimer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_CONFIG_SNAPSHOT_PIECE: {
                        TPipeTransferResp resp = this.handleTransferFilePiece(PipeTransferConfigSnapshotPieceReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, false);
                        PipeConfigNodeReceiverMetrics.getInstance().recordTransferConfigSnapshotPieceTimer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_CONFIG_SNAPSHOT_SEAL: {
                        TPipeTransferResp resp = this.handleTransferFileSealV2(PipeTransferConfigSnapshotSealReq.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordTransferConfigSnapshotSealTimer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_COMPRESSED: {
                        return this.receive(PipeTransferCompressedReq.fromTPipeTransferReq((TPipeTransferReq)req));
                    }
                }
            }
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("Unsupported PipeRequestType on ConfigNode %s.", rawRequestType));
            LOGGER.warn("Receiver id = {}: Unsupported PipeRequestType on ConfigNode, response status = {}.", (Object)this.receiverId.get(), (Object)status);
            return new TPipeTransferResp(status);
        }
        catch (Exception e) {
            String error = "Exception encountered while handling pipe transfer request. Root cause: " + e.getMessage();
            LOGGER.warn("Receiver id = {}: {}", new Object[]{this.receiverId.get(), error, e});
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)error));
        }
    }

    private boolean needHandshake(PipeRequestType type) {
        return Objects.isNull(this.receiverFileDirWithIdSuffix.get()) && type != PipeRequestType.HANDSHAKE_CONFIGNODE_V1 && type != PipeRequestType.HANDSHAKE_CONFIGNODE_V2;
    }

    private TPipeTransferResp handleTransferConfigPlan(PipeTransferConfigPlanReq req) throws IOException {
        return new TPipeTransferResp(this.executePlanAndClassifyExceptions(ConfigPhysicalPlan.Factory.create(req.body)));
    }

    private TSStatus executePlanAndClassifyExceptions(ConfigPhysicalPlan plan) {
        TSStatus result;
        try {
            result = this.checkPermission(plan);
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Receiver id = {}: Permission check failed while executing plan {}: {}", new Object[]{this.receiverId.get(), plan, result});
                return result;
            }
            result = this.executePlan(plan);
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Receiver id = {}: Failure status encountered while executing plan {}: {}", new Object[]{this.receiverId.get(), plan, result});
                result = (TSStatus)STATUS_VISITOR.process(plan, result);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Receiver id = {}: Exception encountered while executing plan {}: ", new Object[]{this.receiverId.get(), plan, e});
            result = (TSStatus)EXCEPTION_VISITOR.process(plan, e);
        }
        return result;
    }

    private TSStatus checkPermission(ConfigPhysicalPlan plan) {
        TSStatus status = this.loginIfNecessary();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        switch (plan.getType()) {
            case CreateDatabase: {
                return PathUtils.isTableModelDatabase((String)((DatabaseSchemaPlan)plan).getSchema().getName()) ? this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((DatabaseSchemaPlan)plan).getSchema().getName(), PrivilegeType.CREATE)).getStatus() : this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.MANAGE_DATABASE)).getStatus();
            }
            case AlterDatabase: {
                return PathUtils.isTableModelDatabase((String)((DatabaseSchemaPlan)plan).getSchema().getName()) ? this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((DatabaseSchemaPlan)plan).getSchema().getName(), PrivilegeType.ALTER)).getStatus() : this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.MANAGE_DATABASE)).getStatus();
            }
            case DeleteDatabase: {
                return PathUtils.isTableModelDatabase((String)((DeleteDatabasePlan)plan).getName()) ? this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((DeleteDatabasePlan)plan).getName(), PrivilegeType.DROP)).getStatus() : this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.MANAGE_DATABASE)).getStatus();
            }
            case ExtendSchemaTemplate: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.EXTEND_TEMPLATE)).getStatus();
            }
            case CreateSchemaTemplate: 
            case CommitSetSchemaTemplate: 
            case PipeUnsetTemplate: {
                return CommonDescriptor.getInstance().getConfig().getAdminName().equals(this.username) ? StatusUtils.OK : new TSStatus(TSStatusCode.NO_PERMISSION.getStatusCode()).setMessage("Only the admin user can perform this operation");
            }
            case PipeDeleteTimeSeries: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(new ArrayList(PathPatternTree.deserialize((ByteBuffer)((PipeDeleteTimeSeriesPlan)plan).getPatternTreeBytes()).getAllPathPatterns()), PrivilegeType.WRITE_SCHEMA)).getStatus();
            }
            case PipeDeleteLogicalView: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(new ArrayList(PathPatternTree.deserialize((ByteBuffer)((PipeDeleteLogicalViewPlan)plan).getPatternTreeBytes()).getAllPathPatterns()), PrivilegeType.WRITE_SCHEMA)).getStatus();
            }
            case PipeDeactivateTemplate: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(new ArrayList<PartialPath>(((PipeDeactivateTemplatePlan)plan).getTemplateSetInfo().keySet()), PrivilegeType.WRITE_SCHEMA)).getStatus();
            }
            case SetTTL: {
                return Objects.equals(this.configManager.getTTLManager().getAllTTL().get(String.join((CharSequence)String.valueOf('.'), ((SetTTLPlan)plan).getPathPattern())), ((SetTTLPlan)plan).getTTL()) ? StatusUtils.OK : this.configManager.checkUserPrivileges(this.username, ((SetTTLPlan)plan).isDataBase() ? new PrivilegeUnion(PrivilegeType.MANAGE_DATABASE) : new PrivilegeUnion(Collections.singletonList(new PartialPath(((SetTTLPlan)plan).getPathPattern())), PrivilegeType.WRITE_SCHEMA)).getStatus();
            }
            case UpdateTriggerStateInTable: 
            case DeleteTriggerInTable: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.USE_TRIGGER)).getStatus();
            }
            case PipeCreateTableOrView: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((PipeCreateTableOrViewPlan)plan).getDatabase(), ((PipeCreateTableOrViewPlan)plan).getTable().getTableName(), PrivilegeType.CREATE)).getStatus();
            }
            case AddTableColumn: 
            case AddViewColumn: 
            case SetTableProperties: 
            case SetViewProperties: 
            case CommitDeleteColumn: 
            case CommitDeleteViewColumn: 
            case SetTableComment: 
            case SetViewComment: 
            case SetTableColumnComment: 
            case RenameTableColumn: 
            case RenameViewColumn: 
            case RenameTable: 
            case RenameView: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((AbstractTablePlan)plan).getDatabase(), ((AbstractTablePlan)plan).getTableName(), PrivilegeType.ALTER)).getStatus();
            }
            case CommitDeleteTable: 
            case CommitDeleteView: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((CommitDeleteTablePlan)plan).getDatabase(), ((CommitDeleteTablePlan)plan).getTableName(), PrivilegeType.DROP)).getStatus();
            }
            case GrantRole: 
            case GrantUser: 
            case RevokeUser: 
            case RevokeRole: {
                for (int permission : ((AuthorTreePlan)plan).getPermissions()) {
                    status = this.configManager.checkUserPrivilegeGrantOpt(this.username, PrivilegeType.values()[permission].isPathPrivilege() ? new PrivilegeUnion(((AuthorTreePlan)plan).getNodeNameList(), PrivilegeType.values()[permission], true) : new PrivilegeUnion(PrivilegeType.values()[permission], true)).getStatus();
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case RGrantUserAny: 
            case RGrantRoleAny: 
            case RRevokeUserAny: 
            case RRevokeRoleAny: {
                for (int permission : ((AuthorRelationalPlan)plan).getPermissions()) {
                    status = this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.values()[permission], true, true)).getStatus();
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case RGrantUserAll: 
            case RGrantRoleAll: 
            case RRevokeUserAll: 
            case RRevokeRoleAll: {
                for (PrivilegeType privilegeType : PrivilegeType.values()) {
                    if (privilegeType.isRelationalPrivilege()) {
                        status = this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(privilegeType, true, true)).getStatus();
                    } else {
                        if (!privilegeType.forRelationalSys()) continue;
                        status = this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(privilegeType, true)).getStatus();
                    }
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case RGrantUserDBPriv: 
            case RGrantRoleDBPriv: 
            case RRevokeUserDBPriv: 
            case RRevokeRoleDBPriv: {
                for (int permission : ((AuthorRelationalPlan)plan).getPermissions()) {
                    status = this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((AuthorRelationalPlan)plan).getDatabaseName(), PrivilegeType.values()[permission], true)).getStatus();
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case RGrantUserTBPriv: 
            case RGrantRoleTBPriv: 
            case RRevokeUserTBPriv: 
            case RRevokeRoleTBPriv: {
                for (int permission : ((AuthorRelationalPlan)plan).getPermissions()) {
                    status = this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(((AuthorRelationalPlan)plan).getDatabaseName(), ((AuthorRelationalPlan)plan).getTableName(), PrivilegeType.values()[permission], true)).getStatus();
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case RGrantUserSysPri: 
            case RGrantRoleSysPri: 
            case RRevokeUserSysPri: 
            case RRevokeRoleSysPri: {
                for (int permission : ((AuthorRelationalPlan)plan).getPermissions()) {
                    status = this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.values()[permission], true)).getStatus();
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case UpdateUser: 
            case RUpdateUser: {
                return ((AuthorPlan)plan).getUserName().equals(this.username) ? StatusUtils.OK : this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.MANAGE_USER)).getStatus();
            }
            case CreateUser: 
            case RCreateUser: 
            case CreateUserWithRawPassword: 
            case DropUser: 
            case RDropUser: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.MANAGE_USER)).getStatus();
            }
            case CreateRole: 
            case RCreateRole: 
            case DropRole: 
            case RDropRole: 
            case GrantRoleToUser: 
            case RGrantUserRole: 
            case RevokeRoleFromUser: 
            case RRevokeUserRole: {
                return this.configManager.checkUserPrivileges(this.username, new PrivilegeUnion(PrivilegeType.MANAGE_ROLE)).getStatus();
            }
        }
        return StatusUtils.OK;
    }

    private TSStatus executePlan(ConfigPhysicalPlan plan) throws ConsensusException {
        String queryId = this.generatePseudoQueryId();
        switch (plan.getType()) {
            case CreateDatabase: {
                TDatabaseSchema schema = ((DatabaseSchemaPlan)plan).getSchema();
                schema.setSchemaReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor());
                schema.setDataReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
                schema.setTimePartitionInterval(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval());
                schema.setMinSchemaRegionGroupNum(ConfigNodeDescriptor.getInstance().getConf().getDefaultSchemaRegionGroupNumPerDatabase());
                schema.setMinDataRegionGroupNum(ConfigNodeDescriptor.getInstance().getConf().getDefaultDataRegionGroupNumPerDatabase());
                schema.setMaxSchemaRegionGroupNum(schema.getMinSchemaRegionGroupNum());
                schema.setMaxDataRegionGroupNum(schema.getMinDataRegionGroupNum());
                return this.configManager.getClusterSchemaManager().setDatabase((DatabaseSchemaPlan)plan, true);
            }
            case AlterDatabase: {
                return this.configManager.getClusterSchemaManager().alterDatabase((DatabaseSchemaPlan)plan, true);
            }
            case DeleteDatabase: {
                return this.configManager.deleteDatabases(new TDeleteDatabasesReq(Collections.singletonList(((DeleteDatabasePlan)plan).getName())).setIsGeneratedByPipe(true).setIsTableModel(PathUtils.isTableModelDatabase((String)((DeleteDatabasePlan)plan).getName())));
            }
            case ExtendSchemaTemplate: {
                return this.configManager.getClusterSchemaManager().extendSchemaTemplate(((ExtendSchemaTemplatePlan)plan).getTemplateExtendInfo(), true);
            }
            case CommitSetSchemaTemplate: {
                return this.configManager.setSchemaTemplate(new TSetSchemaTemplateReq(queryId, ((CommitSetSchemaTemplatePlan)plan).getName(), ((CommitSetSchemaTemplatePlan)plan).getPath()).setIsGeneratedByPipe(true));
            }
            case PipeUnsetTemplate: {
                return this.configManager.unsetSchemaTemplate(new TUnsetSchemaTemplateReq(queryId, ((PipeUnsetSchemaTemplatePlan)plan).getName(), ((PipeUnsetSchemaTemplatePlan)plan).getPath()).setIsGeneratedByPipe(true));
            }
            case PipeDeleteTimeSeries: {
                return this.configManager.deleteTimeSeries(new TDeleteTimeSeriesReq(queryId, ((PipeDeleteTimeSeriesPlan)plan).getPatternTreeBytes()).setIsGeneratedByPipe(true));
            }
            case PipeDeleteLogicalView: {
                return this.configManager.deleteLogicalView(new TDeleteLogicalViewReq(queryId, ((PipeDeleteLogicalViewPlan)plan).getPatternTreeBytes()).setIsGeneratedByPipe(true));
            }
            case PipeDeactivateTemplate: {
                return this.configManager.getProcedureManager().deactivateTemplate(queryId, ((PipeDeactivateTemplatePlan)plan).getTemplateSetInfo(), true);
            }
            case UpdateTriggerStateInTable: {
                return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            }
            case DeleteTriggerInTable: {
                return this.configManager.dropTrigger(new TDropTriggerReq(((DeleteTriggerInTablePlan)plan).getTriggerName()).setIsGeneratedByPipe(true));
            }
            case SetTTL: {
                return ((SetTTLPlan)plan).getTTL() == -1L ? this.configManager.getTTLManager().unsetTTL((SetTTLPlan)plan, true) : this.configManager.getTTLManager().setTTL((SetTTLPlan)plan, true);
            }
            case PipeCreateTableOrView: {
                return this.executeIdempotentCreateTableOrView((PipeCreateTableOrViewPlan)plan, queryId);
            }
            case AddTableColumn: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((AddTableColumnPlan)plan).getDatabase(), null, ((AddTableColumnPlan)plan).getTableName(), queryId, ProcedureType.ADD_TABLE_COLUMN_PROCEDURE, new AddTableColumnProcedure(((AddTableColumnPlan)plan).getDatabase(), ((AddTableColumnPlan)plan).getTableName(), queryId, ((AddTableColumnPlan)plan).getColumnSchemaList(), true));
            }
            case AddViewColumn: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((AddTableViewColumnPlan)plan).getDatabase(), null, ((AddTableViewColumnPlan)plan).getTableName(), queryId, ProcedureType.ADD_VIEW_COLUMN_PROCEDURE, new AddViewColumnProcedure(((AddTableViewColumnPlan)plan).getDatabase(), ((AddTableViewColumnPlan)plan).getTableName(), queryId, ((AddTableViewColumnPlan)plan).getColumnSchemaList(), true));
            }
            case SetTableProperties: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((SetTablePropertiesPlan)plan).getDatabase(), null, ((SetTablePropertiesPlan)plan).getTableName(), queryId, ProcedureType.SET_TABLE_PROPERTIES_PROCEDURE, new SetTablePropertiesProcedure(((SetTablePropertiesPlan)plan).getDatabase(), ((SetTablePropertiesPlan)plan).getTableName(), queryId, ((SetTablePropertiesPlan)plan).getProperties(), true));
            }
            case SetViewProperties: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((SetViewPropertiesPlan)plan).getDatabase(), null, ((SetViewPropertiesPlan)plan).getTableName(), queryId, ProcedureType.SET_VIEW_PROPERTIES_PROCEDURE, new SetViewPropertiesProcedure(((SetViewPropertiesPlan)plan).getDatabase(), ((SetViewPropertiesPlan)plan).getTableName(), queryId, ((SetViewPropertiesPlan)plan).getProperties(), true));
            }
            case CommitDeleteColumn: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((CommitDeleteColumnPlan)plan).getDatabase(), null, ((CommitDeleteColumnPlan)plan).getTableName(), queryId, ProcedureType.DROP_TABLE_COLUMN_PROCEDURE, new DropTableColumnProcedure(((CommitDeleteColumnPlan)plan).getDatabase(), ((CommitDeleteColumnPlan)plan).getTableName(), queryId, ((CommitDeleteColumnPlan)plan).getColumnName(), true));
            }
            case CommitDeleteViewColumn: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((CommitDeleteViewColumnPlan)plan).getDatabase(), null, ((CommitDeleteViewColumnPlan)plan).getTableName(), queryId, ProcedureType.DROP_VIEW_COLUMN_PROCEDURE, new DropViewColumnProcedure(((CommitDeleteViewColumnPlan)plan).getDatabase(), ((CommitDeleteViewColumnPlan)plan).getTableName(), queryId, ((CommitDeleteViewColumnPlan)plan).getColumnName(), true));
            }
            case RenameTableColumn: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((RenameTableColumnPlan)plan).getDatabase(), null, ((RenameTableColumnPlan)plan).getTableName(), queryId, ProcedureType.RENAME_TABLE_COLUMN_PROCEDURE, new RenameTableColumnProcedure(((RenameTableColumnPlan)plan).getDatabase(), ((RenameTableColumnPlan)plan).getTableName(), queryId, ((RenameTableColumnPlan)plan).getOldName(), ((RenameTableColumnPlan)plan).getNewName(), true));
            }
            case RenameViewColumn: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((RenameViewColumnPlan)plan).getDatabase(), null, ((RenameViewColumnPlan)plan).getTableName(), queryId, ProcedureType.RENAME_VIEW_COLUMN_PROCEDURE, new RenameViewColumnProcedure(((RenameViewColumnPlan)plan).getDatabase(), ((RenameViewColumnPlan)plan).getTableName(), queryId, ((RenameViewColumnPlan)plan).getOldName(), ((RenameViewColumnPlan)plan).getNewName(), true));
            }
            case CommitDeleteTable: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((CommitDeleteTablePlan)plan).getDatabase(), null, ((CommitDeleteTablePlan)plan).getTableName(), queryId, ProcedureType.DROP_TABLE_PROCEDURE, new DropTableProcedure(((CommitDeleteTablePlan)plan).getDatabase(), ((CommitDeleteTablePlan)plan).getTableName(), queryId, true));
            }
            case CommitDeleteView: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((CommitDeleteViewPlan)plan).getDatabase(), null, ((CommitDeleteViewPlan)plan).getTableName(), queryId, ProcedureType.DROP_VIEW_PROCEDURE, new DropViewProcedure(((CommitDeleteViewPlan)plan).getDatabase(), ((CommitDeleteViewPlan)plan).getTableName(), queryId, true));
            }
            case SetTableComment: {
                return this.configManager.getClusterSchemaManager().setTableComment(((SetTableCommentPlan)plan).getDatabase(), ((SetTableCommentPlan)plan).getTableName(), ((SetTableCommentPlan)plan).getComment(), false, true);
            }
            case SetViewComment: {
                return this.configManager.getClusterSchemaManager().setTableComment(((SetViewCommentPlan)plan).getDatabase(), ((SetViewCommentPlan)plan).getTableName(), ((SetViewCommentPlan)plan).getComment(), true, true);
            }
            case SetTableColumnComment: {
                return this.configManager.getClusterSchemaManager().setTableColumnComment(((SetTableColumnCommentPlan)plan).getDatabase(), ((SetTableColumnCommentPlan)plan).getTableName(), ((SetTableColumnCommentPlan)plan).getColumnName(), ((SetTableColumnCommentPlan)plan).getComment(), true);
            }
            case PipeDeleteDevices: {
                return this.configManager.getProcedureManager().deleteDevices(new TDeleteTableDeviceReq(((PipeDeleteDevicesPlan)plan).getDatabase(), ((PipeDeleteDevicesPlan)plan).getTableName(), queryId, ByteBuffer.wrap(((PipeDeleteDevicesPlan)plan).getPatternBytes()), ByteBuffer.wrap(((PipeDeleteDevicesPlan)plan).getFilterBytes()), ByteBuffer.wrap(((PipeDeleteDevicesPlan)plan).getModBytes())), true).getStatus();
            }
            case RenameTable: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((RenameTablePlan)plan).getDatabase(), null, ((RenameTablePlan)plan).getTableName(), ((RenameTablePlan)plan).getNewName(), queryId, ProcedureType.RENAME_TABLE_PROCEDURE, new RenameTableProcedure(((RenameTablePlan)plan).getDatabase(), ((RenameTablePlan)plan).getTableName(), queryId, ((RenameTablePlan)plan).getNewName(), true));
            }
            case RenameView: {
                return this.configManager.getProcedureManager().executeWithoutDuplicate(((RenameViewPlan)plan).getDatabase(), null, ((RenameViewPlan)plan).getTableName(), queryId, ProcedureType.RENAME_VIEW_PROCEDURE, new RenameViewProcedure(((RenameViewPlan)plan).getDatabase(), ((RenameViewPlan)plan).getTableName(), queryId, ((RenameViewPlan)plan).getNewName(), true));
            }
            case GrantRole: 
            case GrantUser: 
            case RevokeUser: 
            case RevokeRole: 
            case RGrantUserAny: 
            case RGrantRoleAny: 
            case RRevokeUserAny: 
            case RRevokeRoleAny: 
            case RGrantUserAll: 
            case RGrantRoleAll: 
            case RRevokeUserAll: 
            case RRevokeRoleAll: 
            case RGrantUserDBPriv: 
            case RGrantRoleDBPriv: 
            case RRevokeUserDBPriv: 
            case RRevokeRoleDBPriv: 
            case RGrantUserTBPriv: 
            case RGrantRoleTBPriv: 
            case RRevokeUserTBPriv: 
            case RRevokeRoleTBPriv: 
            case RGrantUserSysPri: 
            case RGrantRoleSysPri: 
            case RRevokeUserSysPri: 
            case RRevokeRoleSysPri: 
            case UpdateUser: 
            case CreateUser: 
            case RCreateUser: 
            case CreateUserWithRawPassword: 
            case DropUser: 
            case RDropUser: 
            case CreateRole: 
            case RCreateRole: 
            case DropRole: 
            case RDropRole: 
            case GrantRoleToUser: 
            case RGrantUserRole: 
            case RevokeRoleFromUser: 
            case RRevokeUserRole: {
                return this.configManager.getPermissionManager().operatePermission((AuthorPlan)plan, true);
            }
        }
        return this.configManager.getConsensusManager().write(new PipeEnrichedPlan(plan));
    }

    private TSStatus executeIdempotentCreateTableOrView(PipeCreateTableOrViewPlan plan, String queryId) throws ConsensusException {
        String database = plan.getDatabase();
        TsTable table = plan.getTable();
        boolean isView = TreeViewSchema.isTreeViewTable((TsTable)table);
        TSStatus result = this.configManager.getProcedureManager().executeWithoutDuplicate(database, table, table.getTableName(), queryId, isView ? ProcedureType.CREATE_TABLE_VIEW_PROCEDURE : ProcedureType.CREATE_TABLE_PROCEDURE, isView ? new CreateTableViewProcedure(database, table, true, true) : new CreateTableProcedure(database, table, true));
        if (!isView && result.getCode() == TSStatusCode.TABLE_ALREADY_EXISTS.getStatusCode()) {
            result = this.executePlan(new AddTableColumnPlan(database, table.getTableName(), table.getColumnList(), false));
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.getCode() != TSStatusCode.COLUMN_ALREADY_EXISTS.getStatusCode()) {
                return result;
            }
            Optional tableComment = table.getPropValue("__comment");
            if (tableComment.isPresent()) {
                result = this.executePlan(new SetTableCommentPlan(database, table.getTableName(), (String)tableComment.get()));
            }
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return result;
            }
            for (TsTableColumnSchema schema : table.getColumnList()) {
                String columnComment = (String)schema.getProps().get("__comment");
                if (Objects.nonNull(columnComment)) {
                    result = this.executePlan(new SetTableColumnCommentPlan(database, table.getTableName(), schema.getColumnName(), columnComment));
                }
                if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                return result;
            }
        }
        return result;
    }

    private String generatePseudoQueryId() {
        return "pipe_" + System.currentTimeMillis() + "_" + QUERY_ID_GENERATOR.getAndIncrement();
    }

    protected String getClusterId() {
        return this.configManager.getClusterManager().getClusterId();
    }

    protected boolean shouldLogin() {
        return true;
    }

    protected TSStatus login() {
        return this.configManager.login(this.username, this.password).getStatus();
    }

    protected String getReceiverFileBaseDir() {
        return ConfigNodeDescriptor.getInstance().getConf().getPipeReceiverFileDir();
    }

    protected void markFileBaseDirStateAbnormal(String dir) {
    }

    protected String getSenderHost() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        return session != null ? session.getClientAddress() : "unknown";
    }

    protected String getSenderPort() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        return session != null ? String.valueOf(session.getClientPort()) : "unknown";
    }

    protected TSStatus loadFileV1(PipeTransferFileSealReqV1 req, String fileAbsolutePath) {
        throw new UnsupportedOperationException("IoTDBConfigNodeReceiver does not support load file V1.");
    }

    protected TSStatus loadFileV2(PipeTransferFileSealReqV2 req, List<String> fileAbsolutePaths) throws IOException {
        Map parameters = req.getParameters();
        CNPhysicalPlanGenerator generator = ConfigNodeSnapshotParser.translate2PhysicalPlan(Paths.get(fileAbsolutePaths.get(0), new String[0]), fileAbsolutePaths.size() > 1 ? Paths.get(fileAbsolutePaths.get(1), new String[0]) : null, CNSnapshotFileType.deserialize(Byte.parseByte((String)parameters.get("fileType"))));
        if (Objects.isNull(generator)) {
            throw new IOException(String.format("The config region snapshots %s cannot be parsed.", fileAbsolutePaths));
        }
        Set<ConfigPhysicalPlanType> executionTypes = PipeConfigRegionSnapshotEvent.getConfigPhysicalPlanTypeSet((String)parameters.get("Type"));
        IoTDBTreePattern treePattern = new IoTDBTreePattern(parameters.containsKey("tree"), (String)parameters.get("PathPattern"));
        TablePattern tablePattern = new TablePattern(parameters.containsKey("table"), (String)parameters.get("database_pattern"), (String)parameters.get("TableName"));
        ArrayList results = new ArrayList();
        while (generator.hasNext()) {
            IoTDBConfigRegionSource.parseConfigPlan(generator.next(), treePattern, tablePattern).filter(configPhysicalPlan -> IoTDBConfigRegionSource.isTypeListened(configPhysicalPlan, executionTypes, treePattern, tablePattern)).ifPresent(configPhysicalPlan -> results.add(this.executePlanAndClassifyExceptions((ConfigPhysicalPlan)configPhysicalPlan)));
        }
        return PipeReceiverStatusHandler.getPriorStatus(results);
    }

    protected void closeSession() {
    }
}

