/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.mqtt;

import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.security.IAuthenticator;
import io.moquette.interception.InterceptHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.pipe.source.mqtt.MQTTPublishHandler;
import org.apache.iotdb.db.protocol.mqtt.BrokerAuthenticator;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class MQTTSource
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTTSource.class);
    protected String pipeName;
    protected long creationTime;
    protected PipeTaskMeta pipeTaskMeta;
    protected final UnboundedBlockingPendingQueue<EnrichedEvent> pendingQueue = new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
    protected IConfig config;
    protected List<InterceptHandler> handlers;
    protected IAuthenticator authenticator;
    private final Server server = new Server();
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);

    public void validate(PipeParameterValidator validator) throws Exception {
        if (!validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.single-mode", "source.single-mode"), true)) {
            throw new PipeParameterNotValidException("single mode should be true in MQTT extractor");
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.config = this.createBrokerConfig(parameters);
        this.handlers = new ArrayList<InterceptHandler>(1);
        this.handlers.add((InterceptHandler)new MQTTPublishHandler(parameters, environment, this.pendingQueue));
        this.authenticator = new BrokerAuthenticator();
    }

    private IConfig createBrokerConfig(PipeParameters pipeParameters) {
        Properties properties = new Properties();
        properties.setProperty("host", pipeParameters.getStringOrDefault("mqtt.host", "127.0.0.1"));
        properties.setProperty("port", pipeParameters.getStringOrDefault("mqtt.port", "1883"));
        properties.setProperty("intercept.thread_pool.size", pipeParameters.getStringOrDefault("mqtt.pool-size", String.valueOf(1)));
        properties.setProperty("data_path", pipeParameters.getStringOrDefault("mqtt.data-path", "data/"));
        properties.setProperty("immediate_buffer_flush", pipeParameters.getStringOrDefault("mqtt.immediate-flush", String.valueOf(true)));
        properties.setProperty("allow_anonymous", pipeParameters.getStringOrDefault("mqtt.allow-anonymous", String.valueOf(false)));
        properties.setProperty("allow_zero_byte_client_id", pipeParameters.getStringOrDefault("mqtt.allow-zero-byte-client-id", String.valueOf(true)));
        properties.setProperty("netty.mqtt.message_size", pipeParameters.getStringOrDefault("mqtt.max-message-size", String.valueOf(0x100000L)));
        return new MemoryConfig(properties);
    }

    public void start() throws Exception {
        try {
            this.server.startServer(this.config, this.handlers, null, this.authenticator, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while starting server", e);
        }
        LOGGER.info("Start MQTT Extractor successfully, listening on ip {}, port {}", (Object)this.config.getProperty("host"), (Object)this.config.getProperty("port"));
    }

    public Event supply() throws Exception {
        return this.isClosed.get() ? null : this.pendingQueue.directPoll();
    }

    public void close() throws Exception {
        if (!this.isClosed.get()) {
            this.server.stopServer();
            this.isClosed.set(true);
        }
    }
}

