/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.QueryState;
import org.apache.iotdb.db.queryengine.execution.StateMachine;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.rpc.RpcUtils;

public class QueryStateMachine {
    private final StateMachine<QueryState> queryState;
    private final AtomicReference<Throwable> failureException = new AtomicReference();
    private final AtomicReference<TSStatus> failureStatus = new AtomicReference();

    public QueryStateMachine(QueryId queryId, ExecutorService executor) {
        this.queryState = new StateMachine<QueryState>(queryId.toString(), executor, QueryState.QUEUED, QueryState.TERMINAL_INSTANCE_STATES);
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public QueryState getState() {
        return this.queryState.get();
    }

    public void transitionToQueued() {
        this.queryState.set(QueryState.QUEUED);
        this.failureException.set(null);
        this.failureStatus.set(null);
    }

    public void transitionToPlanned() {
        this.queryState.setIf(QueryState.PLANNED, currentState -> currentState == QueryState.QUEUED);
    }

    public void transitionToDispatching() {
        this.queryState.setIf(QueryState.DISPATCHING, currentState -> currentState == QueryState.PLANNED);
    }

    public void transitionToPendingRetry(TSStatus failureStatus) {
        this.failureStatus.compareAndSet(null, failureStatus);
        this.queryState.setIf(QueryState.PENDING_RETRY, currentState -> currentState == QueryState.DISPATCHING);
    }

    public void transitionToRunning() {
        this.queryState.setIf(QueryState.RUNNING, currentState -> currentState == QueryState.DISPATCHING || currentState == QueryState.QUEUED);
    }

    public void transitionToFinished() {
        this.transitionToDoneState(QueryState.FINISHED);
    }

    public void transitionToCanceled() {
        this.transitionToDoneState(QueryState.CANCELED);
    }

    public void transitionToCanceled(Throwable throwable, TSStatus failureStatus) {
        this.failureStatus.compareAndSet(null, failureStatus);
        this.failureException.compareAndSet(null, throwable);
        this.transitionToDoneState(QueryState.CANCELED);
    }

    public void transitionToAborted() {
        this.transitionToDoneState(QueryState.ABORTED);
    }

    public void transitionToFailed() {
        this.transitionToDoneState(QueryState.FAILED);
    }

    public void transitionToFailed(Throwable throwable) {
        this.failureException.compareAndSet(null, throwable);
        this.transitionToDoneState(QueryState.FAILED);
    }

    public void transitionToFailed(TSStatus failureStatus) {
        this.failureStatus.compareAndSet(null, failureStatus);
        this.transitionToDoneState(QueryState.FAILED);
    }

    private boolean transitionToDoneState(QueryState doneState) {
        Objects.requireNonNull(doneState, "doneState is null");
        Preconditions.checkArgument((boolean)doneState.isDone(), (String)"doneState %s is not a done state", (Object)((Object)doneState));
        return this.queryState.setIf(doneState, currentState -> !currentState.isDone());
    }

    public String getFailureMessage() {
        Throwable throwable = this.failureException.get();
        if (throwable != null) {
            return throwable.getMessage();
        }
        return "no detailed failure reason in QueryStateMachine";
    }

    public Throwable getFailureException() {
        Throwable throwable = this.failureException.get();
        if (throwable == null) {
            return new IoTDBException(this.getFailureStatus().getMessage(), this.getFailureStatus().code);
        }
        return throwable;
    }

    public TSStatus getFailureStatus() {
        TSStatus status = this.failureStatus.get();
        if (status != null) {
            return status;
        }
        Throwable throwable = this.failureException.get();
        if (throwable != null) {
            Throwable t = ErrorHandlingUtils.getRootCause(throwable);
            if (t instanceof IoTDBRuntimeException) {
                return RpcUtils.getStatus((int)((IoTDBRuntimeException)t).getErrorCode(), (String)t.getMessage());
            }
            if (t instanceof IoTDBException) {
                return RpcUtils.getStatus((int)((IoTDBException)t).getErrorCode(), (String)t.getMessage());
            }
        }
        return this.failureStatus.get();
    }
}

