/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ByteStringConversions {
    private ByteStringConversions() {
    }

    @Nullable
    static UUID byteStringToGuid(@NotNull ByteString bs) {
        if (bs.length() != 16) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bs.bytesOrEmpty());
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return new UUID(high, low);
    }

    @NotNull
    static String byteStringToString(@NotNull ByteString bs) {
        return ByteBufUtil.hexDump((byte[])bs.bytesOrEmpty());
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof ByteString) {
            ByteString bs = (ByteString)o;
            return implicit ? ByteStringConversions.implicitConversion(bs, targetType) : ByteStringConversions.explicitConversion(bs, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull ByteString bs, BuiltinDataType targetType) {
        switch (targetType) {
            case Guid: {
                return ByteStringConversions.byteStringToGuid(bs);
            }
            case String: {
                return ByteStringConversions.byteStringToString(bs);
            }
        }
        return ByteStringConversions.implicitConversion(bs, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull ByteString bs, BuiltinDataType targetType) {
        return null;
    }
}

