/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRowCollector;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventParser;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;

public class TabletInsertionEventTreePatternParser
extends TabletInsertionEventParser {
    private final TreePattern pattern;

    public TabletInsertionEventTreePatternParser(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, InsertNode insertNode, TreePattern pattern) {
        super(pipeTaskMeta, sourceEvent);
        this.pattern = pattern;
        if (insertNode instanceof InsertRowNode) {
            this.parse((InsertRowNode)insertNode);
        } else if (insertNode instanceof InsertTabletNode) {
            this.parse((InsertTabletNode)insertNode);
        } else {
            throw new UnSupportedDataTypeException(String.format("InsertNode type %s is not supported.", insertNode.getClass().getName()));
        }
    }

    public TabletInsertionEventTreePatternParser(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, Tablet tablet, boolean isAligned, TreePattern pattern) {
        super(pipeTaskMeta, sourceEvent);
        this.pattern = pattern;
        this.parse(tablet, isAligned);
    }

    @TestOnly
    public TabletInsertionEventTreePatternParser(InsertNode insertNode, TreePattern pattern) {
        this(null, null, insertNode, pattern);
    }

    @Override
    protected Object getPattern() {
        return this.pattern;
    }

    @Override
    protected void generateColumnIndexMapper(String[] originMeasurementList, Integer[] originColumnIndex2FilteredColumnIndexMapperList) {
        block3: {
            int originColumnSize;
            block2: {
                originColumnSize = originMeasurementList.length;
                if (!Objects.isNull(this.pattern) && !this.pattern.isRoot() && !this.pattern.coversDevice(this.deviceId)) break block2;
                for (int i = 0; i < originColumnSize; ++i) {
                    originColumnIndex2FilteredColumnIndexMapperList[i] = i;
                }
                break block3;
            }
            if (!this.pattern.mayOverlapWithDevice(this.deviceId)) break block3;
            int filteredCount = 0;
            for (int i = 0; i < originColumnSize; ++i) {
                String measurement = originMeasurementList[i];
                if (measurement == null || !this.pattern.matchesMeasurement(this.deviceId, measurement)) continue;
                originColumnIndex2FilteredColumnIndexMapperList[i] = filteredCount++;
            }
        }
    }

    @Override
    public List<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (this.valueColumns.length == 0 || this.timestampColumn.length == 0) {
            return Collections.emptyList();
        }
        PipeRowCollector rowCollector = new PipeRowCollector(this.pipeTaskMeta, this.sourceEvent);
        for (int i = 0; i < this.rowCount; ++i) {
            consumer.accept(new PipeRow(i, Objects.nonNull(this.deviceIdString) ? this.deviceIdString : this.deviceId.toString(), this.isAligned, this.measurementSchemaList, this.timestampColumn, this.valueColumnDataTypes, this.valueColumns, this.nullValueColumnBitmaps, this.columnNameStringList), rowCollector);
        }
        return rowCollector.convertToTabletInsertionEvents(this.shouldReport);
    }

    @Override
    public List<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        PipeRowCollector rowCollector = new PipeRowCollector(this.pipeTaskMeta, this.sourceEvent);
        consumer.accept(this.convertToTablet(), rowCollector);
        return rowCollector.convertToTabletInsertionEvents(this.shouldReport);
    }

    @Override
    public Tablet convertToTablet() {
        if (this.tablet != null) {
            return this.tablet;
        }
        this.tablet = new Tablet(Objects.nonNull(this.deviceIdString) ? this.deviceIdString : this.deviceId.toString(), Arrays.asList(this.measurementSchemaList), this.timestampColumn, this.valueColumns, this.nullValueColumnBitmaps, this.rowCount);
        return this.tablet;
    }
}

