/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.LabelPair;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.TBlock;

class KeepOutWindow
extends DFrame
implements ActionListener {
    private static final String KEEP_OUT_REASONS_PREF = "\":#|7:rmr P4*I7";
    private static final int DEFAULT_REASONS_LENGTH = 10;
    private final Client client;
    private final ATextField nameIn = new ATextField();
    private final ATextField timeIn = new ATextField();
    private final JComboBox<String> reasonIn = new JComboBox();
    private final JButton okBut;
    private final ArrayList<String> defaultReasons = new ArrayList();
    private static final NumberFormat nf = NumberFormat.getInstance();

    public KeepOutWindow(String who, Client client, Component parent) {
        super(Defs.getString(-903340734), parent);
        Iterator iter = ((ArrayList)Prefs.getObj(KEEP_OUT_REASONS_PREF, new ArrayList())).iterator();
        while (iter.hasNext()) {
            this.defaultReasons.add((String)iter.next());
        }
        this.getMainPanel().add("xGrow=t,yGrow=t", new TBlock(Defs.getString(-903340743), 30));
        LabelPair.Group group = new LabelPair.Group();
        if (who != null) {
            this.nameIn.setText(who);
        }
        this.getMainPanel().add("x=0,yGrow=f", new LabelPair(Defs.getString(-903340680), this.nameIn, group));
        this.timeIn.setText(nf.format(24L));
        this.getMainPanel().add("x=0", new LabelPair(Defs.getString(-903340712), this.timeIn, group));
        this.getMainPanel().add("x=0", new JLabel(Defs.getString(-903340633)));
        this.reasonIn.setEditable(true);
        Iterator<String> iter2 = this.defaultReasons.iterator();
        while (iter2.hasNext()) {
            this.reasonIn.addItem(iter2.next());
        }
        this.getMainPanel().add("x=0", this.reasonIn);
        this.okBut = this.addButton(Defs.getString(1436228518), this);
        this.addButton(Defs.getString(1436228510), this);
        this.client = client;
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okBut) {
            String name = this.nameIn.getText().trim();
            ParsePosition pp = new ParsePosition(0);
            String time = this.timeIn.getText().trim();
            int timeout = nf.parse(time, pp).intValue() * 60 * 60;
            String reason = (String)this.reasonIn.getSelectedItem();
            if (reason == null) {
                reason = "";
            }
            if (reason.length() > 500) {
                reason = reason.substring(0, 500);
            }
            if (!User.nameValid(name) || pp.getIndex() != time.length() || time.length() == 0 || timeout <= 0 || timeout > 172800 || reason.length() == 0) {
                new Errout(Defs.getString(-903340735), this);
                return;
            }
            this.client.sendKeepOut(name, timeout, reason);
            this.defaultReasons.remove(reason);
            this.defaultReasons.add(0, reason);
            while (this.defaultReasons.size() > 10) {
                this.defaultReasons.remove(10);
            }
            Prefs.putObj(KEEP_OUT_REASONS_PREF, this.defaultReasons);
        }
        this.dispose();
    }

    static {
        nf.setParseIntegerOnly(true);
    }
}

