/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.ServerStats;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;

public class ServerStatsWindow
extends AFrame
implements ActionListener,
EventListener {
    private final JLabel serverVersOut;
    private AFrame parent;
    private final JLabel upSinceLabel;
    private final JLabel upForLabel;
    private final JLabel respTimeLabel;
    private final JLabel[] gridLabels = new JLabel[8];
    private final JLabel dataInLabel;
    private final JLabel packetsInLabel;
    private final JLabel dataOutLabel;
    private final JLabel packetsOutLabel;
    private long serverStartDate = 0L;
    private final JButton okBut;
    private final JButton helpBut;
    private static final NumberFormat bigNum = ServerStatsWindow.makeBigNumberFormat();
    private final Timer timer;
    private int secondsSinceUpdate = 0;
    private boolean requestSent = false;
    private long avgPingTime;
    private int numRequestsSent;
    private final Client client;

    public ServerStatsWindow(Client newClient, AFrame newParent) {
        super(Defs.getString(-903340605), newParent);
        this.parent = newParent;
        this.client = newClient;
        GuiClientUtil.addToWindowList(newClient, this);
        this.getContentPane().setLayout(new GCLayout());
        JPanel jp = ServerStatsWindow.createBorderedPanel(new GCLayout());
        this.getContentPane().add("xGrow=t,xSpan=2", jp);
        this.serverVersOut = new JLabel("", 4);
        jp.add("xGrow=t", this.lvPair(-903340604, this.serverVersOut));
        this.upSinceLabel = new JLabel("", 4);
        jp.add("x=0", this.lvPair(-903340575, this.upSinceLabel));
        this.upForLabel = new JLabel("", 4);
        jp.add("x=0", this.lvPair(-903340577, this.upForLabel));
        jp = ServerStatsWindow.createBorderedPanel(new GCLayout());
        this.getContentPane().add("x=0", jp);
        this.packetsInLabel = new JLabel("", 4);
        jp.add("xGrow=t,xBorder=0", this.lvPair(-903340766, this.packetsInLabel));
        jp.add("xGrow=f", new JLabel(Defs.getString(-903340692)));
        this.dataInLabel = new JLabel("", 4);
        jp.add("x=0", this.dataInLabel);
        jp.add(new JLabel(Defs.getString(-903340790)));
        this.packetsOutLabel = new JLabel("", 4);
        jp.add("x=0", this.lvPair(-903340765, this.packetsOutLabel));
        jp.add(new JLabel(Defs.getString(-903340692)));
        this.dataOutLabel = new JLabel("", 4);
        jp.add("x=0", this.dataOutLabel);
        jp.add(new JLabel(Defs.getString(-903340790)));
        this.respTimeLabel = new JLabel("", 4);
        jp.add("x=0", this.lvPair(-903340621, this.respTimeLabel));
        jp.add(new JLabel(Defs.getString(-903340684)));
        jp = ServerStatsWindow.createBorderedPanel(new GCLayout());
        MatteBorder border1 = BorderFactory.createMatteBorder(1, 1, 0, 0, Color.black);
        MatteBorder border2 = BorderFactory.createMatteBorder(1, 1, 0, 1, Color.black);
        this.getContentPane().add("x=0", jp);
        JLabel l = new JLabel();
        jp.add("xGrow=f,yGrow=t,xBorder=0,yBorder=0", l);
        l.setBorder(border1);
        l.setBackground(Color.gray);
        l.setOpaque(true);
        l = new JLabel(Defs.getString(-903340767), 0);
        jp.add("xGrow=t", l);
        l.setBorder(border1);
        l.setBackground(Color.gray);
        l.setOpaque(true);
        l = new JLabel(Defs.getString(-903340694), 0);
        jp.add(l);
        l.setBorder(border2);
        l.setBackground(Color.gray);
        l.setOpaque(true);
        int[] rows = new int[]{-903340572, -903340815, -903340617, -903340722};
        for (int i = 0; i < rows.length; ++i) {
            l = new JLabel(Defs.getString(rows[i]));
            jp.add("x=0,xGrow=f", l);
            if (i == rows.length - 1) {
                border1 = BorderFactory.createMatteBorder(1, 1, 1, 0, Color.black);
                border2 = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black);
            }
            l.setBorder(border1);
            l.setBackground(Color.gray);
            l.setOpaque(true);
            JLabel jLabel = new JLabel("-", 0);
            this.gridLabels[i * 2] = jLabel;
            jp.add(jLabel);
            this.gridLabels[i * 2].setBorder(border1);
            JLabel jLabel2 = new JLabel("-", 0);
            this.gridLabels[i * 2 + 1] = jLabel2;
            jp.add(jLabel2);
            this.gridLabels[i * 2 + 1].setBorder(border2);
        }
        this.okBut = new JButton(Defs.getString(1436228518));
        this.getContentPane().add("x=0,xSpan=1", this.okBut);
        this.okBut.addActionListener(this);
        this.helpBut = new JButton(Defs.getString(1436228516));
        this.getContentPane().add(this.helpBut);
        this.helpBut.addActionListener(this);
        this.reqData();
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    private void reqData() {
        if (!this.requestSent) {
            this.client.requestServerStats(this);
            this.requestSent = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.okBut) {
            this.dispose();
        } else if (evt.getSource() == this.helpBut) {
            GuiUtil.loadHelp("serverStatsWin.html");
        } else {
            if (++this.secondsSinceUpdate >= 60) {
                this.reqData();
                this.secondsSinceUpdate = 0;
            }
            if (this.isVisible() && this.serverStartDate != 0L) {
                this.setUpFor();
            }
        }
    }

    private void setUpFor() {
        long SEC = 1000L;
        long MIN = 60000L;
        long HOUR = 3600000L;
        long DAY = 86400000L;
        long msDiff = System.currentTimeMillis() - this.serverStartDate;
        int days = (int)(msDiff / 86400000L);
        int hours = (int)((msDiff -= (long)days * 86400000L) / 3600000L);
        int mins = (int)((msDiff -= (long)hours * 3600000L) / 60000L);
        int secs = (int)((msDiff -= (long)mins * 60000L) / 1000L);
        Object[] args = new Object[]{days, hours, mins, secs};
        this.upForLabel.setText(Defs.getString(-903340764, args));
    }

    @Override
    public void handleEvent(Event event) {
        this.requestSent = false;
        ServerStats ss = (ServerStats)event.arg;
        this.serverVersOut.setText(Defs.getString(-669080761, new Object[]{ss.versionMajor, ss.versionMinor, ss.versionBugfix}));
        if (this.serverStartDate == 0L) {
            this.serverStartDate = ss.startupTime;
            this.upSinceLabel.setText(DateFormat.getDateTimeInstance(3, 2).format(new Date(this.serverStartDate)));
            this.setUpFor();
        }
        for (int i = 0; i < this.gridLabels.length; i += 2) {
            this.gridLabels[i].setText(bigNum.format(ss.getCurrent(i / 2)));
            this.gridLabels[i].setHorizontalAlignment(4);
            this.gridLabels[i + 1].setText(bigNum.format(ss.getMax(i / 2)));
            this.gridLabels[i + 1].setHorizontalAlignment(4);
        }
        this.dataInLabel.setText(bigNum.format(ss.bytesIn));
        this.packetsInLabel.setText(bigNum.format(ss.messagesIn));
        this.dataOutLabel.setText(bigNum.format(ss.bytesOut));
        this.packetsOutLabel.setText(bigNum.format(ss.messagesOut));
        this.avgPingTime = (this.avgPingTime * (long)(++this.numRequestsSent) + (long)ss.pingTime + 2L) / (long)(this.numRequestsSent + 1);
        if (this.numRequestsSent < 4) {
            ++this.numRequestsSent;
        }
        this.respTimeLabel.setText(bigNum.format(ss.pingTime));
        if (this.parent != null) {
            this.pack(this.parent);
            this.setResizable(false);
            this.setVisible(true);
            this.parent = null;
        }
    }

    private static NumberFormat makeBigNumberFormat() {
        NumberFormat result = NumberFormat.getInstance();
        result.setGroupingUsed(true);
        return result;
    }

    private JComponent lvPair(int label, JComponent value) {
        JPanel result = new JPanel(new GCLayout());
        result.add(new JLabel(Defs.getString(label)));
        result.add("xGrow=t", value);
        return result;
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
    }
}

