// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/bigquery/storage/v1alpha/metastore_partition.proto

package storagepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for CreateMetastorePartition. The MetastorePartition is
// uniquely identified by values, which is an ordered list. Hence, there is no
// separate name or partition id field.
type CreateMetastorePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to where the metastore partition to be
	// added, in the format of
	// projects/{project}/databases/{databases}/tables/{table}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The metastore partition to be added.
	MetastorePartition *MetastorePartition `protobuf:"bytes,2,opt,name=metastore_partition,json=metastorePartition,proto3" json:"metastore_partition,omitempty"`
}

func (x *CreateMetastorePartitionRequest) Reset() {
	*x = CreateMetastorePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMetastorePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMetastorePartitionRequest) ProtoMessage() {}

func (x *CreateMetastorePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMetastorePartitionRequest.ProtoReflect.Descriptor instead.
func (*CreateMetastorePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{0}
}

func (x *CreateMetastorePartitionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMetastorePartitionRequest) GetMetastorePartition() *MetastorePartition {
	if x != nil {
		return x.MetastorePartition
	}
	return nil
}

// Request message for BatchCreateMetastorePartitions.
type BatchCreateMetastorePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to where the metastore partitions to be
	// added, in the format of
	// projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Requests to add metastore partitions to the table.
	Requests []*CreateMetastorePartitionRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	// Optional. Mimics the ifNotExists flag in IMetaStoreClient
	// add_partitions(..). If the flag is set to false, the server will return
	// ALREADY_EXISTS if any partition already exists. If the flag is set to true,
	// the server will skip existing partitions and insert only the non-existing
	// partitions.
	SkipExistingPartitions bool `protobuf:"varint,3,opt,name=skip_existing_partitions,json=skipExistingPartitions,proto3" json:"skip_existing_partitions,omitempty"`
}

func (x *BatchCreateMetastorePartitionsRequest) Reset() {
	*x = BatchCreateMetastorePartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateMetastorePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateMetastorePartitionsRequest) ProtoMessage() {}

func (x *BatchCreateMetastorePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateMetastorePartitionsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateMetastorePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{1}
}

func (x *BatchCreateMetastorePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateMetastorePartitionsRequest) GetRequests() []*CreateMetastorePartitionRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchCreateMetastorePartitionsRequest) GetSkipExistingPartitions() bool {
	if x != nil {
		return x.SkipExistingPartitions
	}
	return false
}

// Response message for BatchCreateMetastorePartitions.
type BatchCreateMetastorePartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of metastore partitions that have been created.
	Partitions []*MetastorePartition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
}

func (x *BatchCreateMetastorePartitionsResponse) Reset() {
	*x = BatchCreateMetastorePartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateMetastorePartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateMetastorePartitionsResponse) ProtoMessage() {}

func (x *BatchCreateMetastorePartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateMetastorePartitionsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateMetastorePartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{2}
}

func (x *BatchCreateMetastorePartitionsResponse) GetPartitions() []*MetastorePartition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

// Request message for BatchDeleteMetastorePartitions. The MetastorePartition is
// uniquely identified by values, which is an ordered list. Hence, there is no
// separate name or partition id field.
type BatchDeleteMetastorePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to which these metastore partitions
	// belong, in the format of
	// projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The list of metastore partitions (identified by its values) to be
	// deleted. A maximum of 100 partitions can be deleted in a batch.
	PartitionValues []*MetastorePartitionValues `protobuf:"bytes,2,rep,name=partition_values,json=partitionValues,proto3" json:"partition_values,omitempty"`
}

func (x *BatchDeleteMetastorePartitionsRequest) Reset() {
	*x = BatchDeleteMetastorePartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteMetastorePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteMetastorePartitionsRequest) ProtoMessage() {}

func (x *BatchDeleteMetastorePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteMetastorePartitionsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteMetastorePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{3}
}

func (x *BatchDeleteMetastorePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteMetastorePartitionsRequest) GetPartitionValues() []*MetastorePartitionValues {
	if x != nil {
		return x.PartitionValues
	}
	return nil
}

// Request message for UpdateMetastorePartition.
type UpdateMetastorePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The metastore partition to be updated.
	MetastorePartition *MetastorePartition `protobuf:"bytes,1,opt,name=metastore_partition,json=metastorePartition,proto3" json:"metastore_partition,omitempty"`
	// Optional. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMetastorePartitionRequest) Reset() {
	*x = UpdateMetastorePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMetastorePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMetastorePartitionRequest) ProtoMessage() {}

func (x *UpdateMetastorePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMetastorePartitionRequest.ProtoReflect.Descriptor instead.
func (*UpdateMetastorePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateMetastorePartitionRequest) GetMetastorePartition() *MetastorePartition {
	if x != nil {
		return x.MetastorePartition
	}
	return nil
}

func (x *UpdateMetastorePartitionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for BatchUpdateMetastorePartitions.
type BatchUpdateMetastorePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to which these metastore partitions
	// belong, in the format of
	// projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Requests to update metastore partitions in the table.
	Requests []*UpdateMetastorePartitionRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateMetastorePartitionsRequest) Reset() {
	*x = BatchUpdateMetastorePartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateMetastorePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateMetastorePartitionsRequest) ProtoMessage() {}

func (x *BatchUpdateMetastorePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateMetastorePartitionsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateMetastorePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{5}
}

func (x *BatchUpdateMetastorePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateMetastorePartitionsRequest) GetRequests() []*UpdateMetastorePartitionRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchUpdateMetastorePartitions.
type BatchUpdateMetastorePartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of metastore partitions that have been updated.
	Partitions []*MetastorePartition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
}

func (x *BatchUpdateMetastorePartitionsResponse) Reset() {
	*x = BatchUpdateMetastorePartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateMetastorePartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateMetastorePartitionsResponse) ProtoMessage() {}

func (x *BatchUpdateMetastorePartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateMetastorePartitionsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateMetastorePartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{6}
}

func (x *BatchUpdateMetastorePartitionsResponse) GetPartitions() []*MetastorePartition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

// Request message for ListMetastorePartitions.
type ListMetastorePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to which these metastore partitions
	// belong, in the format of
	// projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. SQL text filtering statement, similar to a WHERE clause in a
	// query. Only supports single-row expressions.  Aggregate functions are not
	// supported.
	//
	// Examples: "int_field > 5"
	//
	//	"date_field = CAST('2014-9-27' as DATE)"
	//	"nullable_field is not NULL"
	//	"st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
	//	"numeric_field BETWEEN 1.0 AND 5.0"
	//
	// Restricted to a maximum length for 1 MB.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListMetastorePartitionsRequest) Reset() {
	*x = ListMetastorePartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMetastorePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetastorePartitionsRequest) ProtoMessage() {}

func (x *ListMetastorePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetastorePartitionsRequest.ProtoReflect.Descriptor instead.
func (*ListMetastorePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{7}
}

func (x *ListMetastorePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMetastorePartitionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListMetastorePartitions.
type ListMetastorePartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response depends on the number of metastore partitions to be returned;
	// it can be a list of partitions or a list of
	// [ReadStream]((https://cloud.google.com/bigquery/docs/reference/storage/rpc/google.cloud.bigquery.storage.v1#readstream))
	// objects. For the second situation, the BigQuery [Read API
	// ReadRows](https://cloud.google.com/bigquery/docs/reference/storage#read_from_a_session_stream)
	// method must be used to stream the data and convert it into a list of
	// partitions.
	//
	// Types that are assignable to Response:
	//
	//	*ListMetastorePartitionsResponse_Partitions
	//	*ListMetastorePartitionsResponse_Streams
	Response isListMetastorePartitionsResponse_Response `protobuf_oneof:"response"`
}

func (x *ListMetastorePartitionsResponse) Reset() {
	*x = ListMetastorePartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMetastorePartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetastorePartitionsResponse) ProtoMessage() {}

func (x *ListMetastorePartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetastorePartitionsResponse.ProtoReflect.Descriptor instead.
func (*ListMetastorePartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{8}
}

func (m *ListMetastorePartitionsResponse) GetResponse() isListMetastorePartitionsResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *ListMetastorePartitionsResponse) GetPartitions() *MetastorePartitionList {
	if x, ok := x.GetResponse().(*ListMetastorePartitionsResponse_Partitions); ok {
		return x.Partitions
	}
	return nil
}

func (x *ListMetastorePartitionsResponse) GetStreams() *StreamList {
	if x, ok := x.GetResponse().(*ListMetastorePartitionsResponse_Streams); ok {
		return x.Streams
	}
	return nil
}

type isListMetastorePartitionsResponse_Response interface {
	isListMetastorePartitionsResponse_Response()
}

type ListMetastorePartitionsResponse_Partitions struct {
	// The list of partitions.
	Partitions *MetastorePartitionList `protobuf:"bytes,1,opt,name=partitions,proto3,oneof"`
}

type ListMetastorePartitionsResponse_Streams struct {
	// The list of streams.
	Streams *StreamList `protobuf:"bytes,2,opt,name=streams,proto3,oneof"`
}

func (*ListMetastorePartitionsResponse_Partitions) isListMetastorePartitionsResponse_Response() {}

func (*ListMetastorePartitionsResponse_Streams) isListMetastorePartitionsResponse_Response() {}

// The top-level message sent by the client to the
// [Partitions.StreamMetastorePartitions][] method.
// Follows the default gRPC streaming maximum size of 4 MB.
type StreamMetastorePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to where the partition to be added, in the
	// format of
	// projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A list of metastore partitions to be added to the table.
	MetastorePartitions []*MetastorePartition `protobuf:"bytes,2,rep,name=metastore_partitions,json=metastorePartitions,proto3" json:"metastore_partitions,omitempty"`
	// Optional. Mimics the ifNotExists flag in IMetaStoreClient
	// add_partitions(..). If the flag is set to false, the server will return
	// ALREADY_EXISTS on commit if any partition already exists. If the flag is
	// set to true:
	//  1. the server will skip existing partitions
	//     insert only the non-existing partitions as part of the commit.
	//  2. The client must set the `skip_existing_partitions` field to true for
	//     all requests in the stream.
	SkipExistingPartitions bool `protobuf:"varint,3,opt,name=skip_existing_partitions,json=skipExistingPartitions,proto3" json:"skip_existing_partitions,omitempty"`
}

func (x *StreamMetastorePartitionsRequest) Reset() {
	*x = StreamMetastorePartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamMetastorePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamMetastorePartitionsRequest) ProtoMessage() {}

func (x *StreamMetastorePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamMetastorePartitionsRequest.ProtoReflect.Descriptor instead.
func (*StreamMetastorePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{9}
}

func (x *StreamMetastorePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *StreamMetastorePartitionsRequest) GetMetastorePartitions() []*MetastorePartition {
	if x != nil {
		return x.MetastorePartitions
	}
	return nil
}

func (x *StreamMetastorePartitionsRequest) GetSkipExistingPartitions() bool {
	if x != nil {
		return x.SkipExistingPartitions
	}
	return false
}

// This is the response message sent by the server
// to the client for the [Partitions.StreamMetastorePartitions][] method when
// the commit is successful. Server will close the stream after sending this
// message.
type StreamMetastorePartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total count of partitions streamed by the client during the lifetime of the
	// stream. This is only set in the final response message before closing the
	// stream.
	TotalPartitionsStreamedCount int64 `protobuf:"varint,2,opt,name=total_partitions_streamed_count,json=totalPartitionsStreamedCount,proto3" json:"total_partitions_streamed_count,omitempty"`
	// Total count of partitions inserted by the server during the lifetime of the
	// stream. This is only set in the final response message before closing the
	// stream.
	TotalPartitionsInsertedCount int64 `protobuf:"varint,3,opt,name=total_partitions_inserted_count,json=totalPartitionsInsertedCount,proto3" json:"total_partitions_inserted_count,omitempty"`
}

func (x *StreamMetastorePartitionsResponse) Reset() {
	*x = StreamMetastorePartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamMetastorePartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamMetastorePartitionsResponse) ProtoMessage() {}

func (x *StreamMetastorePartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamMetastorePartitionsResponse.ProtoReflect.Descriptor instead.
func (*StreamMetastorePartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{10}
}

func (x *StreamMetastorePartitionsResponse) GetTotalPartitionsStreamedCount() int64 {
	if x != nil {
		return x.TotalPartitionsStreamedCount
	}
	return 0
}

func (x *StreamMetastorePartitionsResponse) GetTotalPartitionsInsertedCount() int64 {
	if x != nil {
		return x.TotalPartitionsInsertedCount
	}
	return 0
}

// Structured custom error message for batch size too large error.
// The error can be attached as error details in the returned rpc Status for
// more structured error handling in the client.
type BatchSizeTooLargeError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items that are supported in a single batch. This is
	// returned as a hint to the client to adjust the batch size.
	MaxBatchSize int64 `protobuf:"varint,1,opt,name=max_batch_size,json=maxBatchSize,proto3" json:"max_batch_size,omitempty"`
	// Optional. The error message that is returned to the client.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *BatchSizeTooLargeError) Reset() {
	*x = BatchSizeTooLargeError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchSizeTooLargeError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchSizeTooLargeError) ProtoMessage() {}

func (x *BatchSizeTooLargeError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchSizeTooLargeError.ProtoReflect.Descriptor instead.
func (*BatchSizeTooLargeError) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP(), []int{11}
}

func (x *BatchSizeTooLargeError) GetMaxBatchSize() int64 {
	if x != nil {
		return x.MaxBatchSize
	}
	return 0
}

func (x *BatchSizeTooLargeError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

var File_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xd1, 0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x02, 0x0a, 0x25, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x67,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x18, 0x73, 0x6b, 0x69, 0x70, 0x5f,
	0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16,
	0x73, 0x6b, 0x69, 0x70, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x26, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x59, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd7, 0x01, 0x0a,
	0x25, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xd4, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6f, 0x0a, 0x13, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xcf, 0x01,
	0x0a, 0x25, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22,
	0x83, 0x01, 0x0a, 0x26, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x7c, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0xdd, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x07, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x93, 0x02, 0x0a, 0x20, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x71, 0x0a, 0x14, 0x6d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x18, 0x73, 0x6b,
	0x69, 0x70, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x73, 0x6b, 0x69, 0x70, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x21, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x45, 0x0a, 0x1f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x65,
	0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x1f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x1c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x68, 0x0a,
	0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x6f, 0x4c, 0x61, 0x72,
	0x67, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0c, 0x6d, 0x61, 0x78, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x32, 0x82, 0x0b, 0x0a, 0x19, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9d, 0x02, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a,
	0x22, 0x53, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x9d,
	0x02, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x87,
	0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x12, 0x4c, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x12, 0xb4, 0x01, 0x0a, 0x19, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x1a,
	0x7b, 0xca, 0x41, 0x1e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xba, 0x02, 0xea,
	0x41, 0x55, 0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x7d, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x42, 0x1e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68,
	0x61, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescData = file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDesc
)

func file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescData)
	})
	return file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDescData
}

var file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_goTypes = []any{
	(*CreateMetastorePartitionRequest)(nil),        // 0: google.cloud.bigquery.storage.v1alpha.CreateMetastorePartitionRequest
	(*BatchCreateMetastorePartitionsRequest)(nil),  // 1: google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsRequest
	(*BatchCreateMetastorePartitionsResponse)(nil), // 2: google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsResponse
	(*BatchDeleteMetastorePartitionsRequest)(nil),  // 3: google.cloud.bigquery.storage.v1alpha.BatchDeleteMetastorePartitionsRequest
	(*UpdateMetastorePartitionRequest)(nil),        // 4: google.cloud.bigquery.storage.v1alpha.UpdateMetastorePartitionRequest
	(*BatchUpdateMetastorePartitionsRequest)(nil),  // 5: google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsRequest
	(*BatchUpdateMetastorePartitionsResponse)(nil), // 6: google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsResponse
	(*ListMetastorePartitionsRequest)(nil),         // 7: google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsRequest
	(*ListMetastorePartitionsResponse)(nil),        // 8: google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse
	(*StreamMetastorePartitionsRequest)(nil),       // 9: google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
	(*StreamMetastorePartitionsResponse)(nil),      // 10: google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsResponse
	(*BatchSizeTooLargeError)(nil),                 // 11: google.cloud.bigquery.storage.v1alpha.BatchSizeTooLargeError
	(*MetastorePartition)(nil),                     // 12: google.cloud.bigquery.storage.v1alpha.MetastorePartition
	(*MetastorePartitionValues)(nil),               // 13: google.cloud.bigquery.storage.v1alpha.MetastorePartitionValues
	(*fieldmaskpb.FieldMask)(nil),                  // 14: google.protobuf.FieldMask
	(*MetastorePartitionList)(nil),                 // 15: google.cloud.bigquery.storage.v1alpha.MetastorePartitionList
	(*StreamList)(nil),                             // 16: google.cloud.bigquery.storage.v1alpha.StreamList
	(*emptypb.Empty)(nil),                          // 17: google.protobuf.Empty
}
var file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_depIdxs = []int32{
	12, // 0: google.cloud.bigquery.storage.v1alpha.CreateMetastorePartitionRequest.metastore_partition:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartition
	0,  // 1: google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsRequest.requests:type_name -> google.cloud.bigquery.storage.v1alpha.CreateMetastorePartitionRequest
	12, // 2: google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsResponse.partitions:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartition
	13, // 3: google.cloud.bigquery.storage.v1alpha.BatchDeleteMetastorePartitionsRequest.partition_values:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartitionValues
	12, // 4: google.cloud.bigquery.storage.v1alpha.UpdateMetastorePartitionRequest.metastore_partition:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartition
	14, // 5: google.cloud.bigquery.storage.v1alpha.UpdateMetastorePartitionRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 6: google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsRequest.requests:type_name -> google.cloud.bigquery.storage.v1alpha.UpdateMetastorePartitionRequest
	12, // 7: google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsResponse.partitions:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartition
	15, // 8: google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse.partitions:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartitionList
	16, // 9: google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse.streams:type_name -> google.cloud.bigquery.storage.v1alpha.StreamList
	12, // 10: google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest.metastore_partitions:type_name -> google.cloud.bigquery.storage.v1alpha.MetastorePartition
	1,  // 11: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.BatchCreateMetastorePartitions:input_type -> google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsRequest
	3,  // 12: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.BatchDeleteMetastorePartitions:input_type -> google.cloud.bigquery.storage.v1alpha.BatchDeleteMetastorePartitionsRequest
	5,  // 13: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.BatchUpdateMetastorePartitions:input_type -> google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsRequest
	7,  // 14: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.ListMetastorePartitions:input_type -> google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsRequest
	9,  // 15: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.StreamMetastorePartitions:input_type -> google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
	2,  // 16: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.BatchCreateMetastorePartitions:output_type -> google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsResponse
	17, // 17: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.BatchDeleteMetastorePartitions:output_type -> google.protobuf.Empty
	6,  // 18: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.BatchUpdateMetastorePartitions:output_type -> google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsResponse
	8,  // 19: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.ListMetastorePartitions:output_type -> google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse
	10, // 20: google.cloud.bigquery.storage.v1alpha.MetastorePartitionService.StreamMetastorePartitions:output_type -> google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsResponse
	16, // [16:21] is the sub-list for method output_type
	11, // [11:16] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_init() }
func file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_init() {
	if File_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto != nil {
		return
	}
	file_google_cloud_bigquery_storage_v1alpha_partition_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*CreateMetastorePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*BatchCreateMetastorePartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*BatchCreateMetastorePartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*BatchDeleteMetastorePartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateMetastorePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*BatchUpdateMetastorePartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*BatchUpdateMetastorePartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ListMetastorePartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ListMetastorePartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*StreamMetastorePartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*StreamMetastorePartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*BatchSizeTooLargeError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes[8].OneofWrappers = []any{
		(*ListMetastorePartitionsResponse_Partitions)(nil),
		(*ListMetastorePartitionsResponse_Streams)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_depIdxs,
		MessageInfos:      file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto = out.File
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_rawDesc = nil
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_goTypes = nil
	file_google_cloud_bigquery_storage_v1alpha_metastore_partition_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MetastorePartitionServiceClient is the client API for MetastorePartitionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetastorePartitionServiceClient interface {
	// Adds metastore partitions to a table.
	BatchCreateMetastorePartitions(ctx context.Context, in *BatchCreateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchCreateMetastorePartitionsResponse, error)
	// Deletes metastore partitions from a table.
	BatchDeleteMetastorePartitions(ctx context.Context, in *BatchDeleteMetastorePartitionsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates metastore partitions in a table.
	BatchUpdateMetastorePartitions(ctx context.Context, in *BatchUpdateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchUpdateMetastorePartitionsResponse, error)
	// Gets metastore partitions from a table.
	ListMetastorePartitions(ctx context.Context, in *ListMetastorePartitionsRequest, opts ...grpc.CallOption) (*ListMetastorePartitionsResponse, error)
	// This is a bi-di streaming rpc method that allows the client to send
	// a stream of partitions and commit all of them atomically at the end.
	// If the commit is successful, the server will return a
	// response and close the stream. If the commit fails (due to duplicate
	// partitions or other reason), the server will close the stream with an
	// error. This method is only available via the gRPC API (not REST).
	StreamMetastorePartitions(ctx context.Context, opts ...grpc.CallOption) (MetastorePartitionService_StreamMetastorePartitionsClient, error)
}

type metastorePartitionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetastorePartitionServiceClient(cc grpc.ClientConnInterface) MetastorePartitionServiceClient {
	return &metastorePartitionServiceClient{cc}
}

func (c *metastorePartitionServiceClient) BatchCreateMetastorePartitions(ctx context.Context, in *BatchCreateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchCreateMetastorePartitionsResponse, error) {
	out := new(BatchCreateMetastorePartitionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchCreateMetastorePartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) BatchDeleteMetastorePartitions(ctx context.Context, in *BatchDeleteMetastorePartitionsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchDeleteMetastorePartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) BatchUpdateMetastorePartitions(ctx context.Context, in *BatchUpdateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchUpdateMetastorePartitionsResponse, error) {
	out := new(BatchUpdateMetastorePartitionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchUpdateMetastorePartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) ListMetastorePartitions(ctx context.Context, in *ListMetastorePartitionsRequest, opts ...grpc.CallOption) (*ListMetastorePartitionsResponse, error) {
	out := new(ListMetastorePartitionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/ListMetastorePartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) StreamMetastorePartitions(ctx context.Context, opts ...grpc.CallOption) (MetastorePartitionService_StreamMetastorePartitionsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_MetastorePartitionService_serviceDesc.Streams[0], "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/StreamMetastorePartitions", opts...)
	if err != nil {
		return nil, err
	}
	x := &metastorePartitionServiceStreamMetastorePartitionsClient{stream}
	return x, nil
}

type MetastorePartitionService_StreamMetastorePartitionsClient interface {
	Send(*StreamMetastorePartitionsRequest) error
	Recv() (*StreamMetastorePartitionsResponse, error)
	grpc.ClientStream
}

type metastorePartitionServiceStreamMetastorePartitionsClient struct {
	grpc.ClientStream
}

func (x *metastorePartitionServiceStreamMetastorePartitionsClient) Send(m *StreamMetastorePartitionsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *metastorePartitionServiceStreamMetastorePartitionsClient) Recv() (*StreamMetastorePartitionsResponse, error) {
	m := new(StreamMetastorePartitionsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// MetastorePartitionServiceServer is the server API for MetastorePartitionService service.
type MetastorePartitionServiceServer interface {
	// Adds metastore partitions to a table.
	BatchCreateMetastorePartitions(context.Context, *BatchCreateMetastorePartitionsRequest) (*BatchCreateMetastorePartitionsResponse, error)
	// Deletes metastore partitions from a table.
	BatchDeleteMetastorePartitions(context.Context, *BatchDeleteMetastorePartitionsRequest) (*emptypb.Empty, error)
	// Updates metastore partitions in a table.
	BatchUpdateMetastorePartitions(context.Context, *BatchUpdateMetastorePartitionsRequest) (*BatchUpdateMetastorePartitionsResponse, error)
	// Gets metastore partitions from a table.
	ListMetastorePartitions(context.Context, *ListMetastorePartitionsRequest) (*ListMetastorePartitionsResponse, error)
	// This is a bi-di streaming rpc method that allows the client to send
	// a stream of partitions and commit all of them atomically at the end.
	// If the commit is successful, the server will return a
	// response and close the stream. If the commit fails (due to duplicate
	// partitions or other reason), the server will close the stream with an
	// error. This method is only available via the gRPC API (not REST).
	StreamMetastorePartitions(MetastorePartitionService_StreamMetastorePartitionsServer) error
}

// UnimplementedMetastorePartitionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetastorePartitionServiceServer struct {
}

func (*UnimplementedMetastorePartitionServiceServer) BatchCreateMetastorePartitions(context.Context, *BatchCreateMetastorePartitionsRequest) (*BatchCreateMetastorePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateMetastorePartitions not implemented")
}
func (*UnimplementedMetastorePartitionServiceServer) BatchDeleteMetastorePartitions(context.Context, *BatchDeleteMetastorePartitionsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteMetastorePartitions not implemented")
}
func (*UnimplementedMetastorePartitionServiceServer) BatchUpdateMetastorePartitions(context.Context, *BatchUpdateMetastorePartitionsRequest) (*BatchUpdateMetastorePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateMetastorePartitions not implemented")
}
func (*UnimplementedMetastorePartitionServiceServer) ListMetastorePartitions(context.Context, *ListMetastorePartitionsRequest) (*ListMetastorePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetastorePartitions not implemented")
}
func (*UnimplementedMetastorePartitionServiceServer) StreamMetastorePartitions(MetastorePartitionService_StreamMetastorePartitionsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamMetastorePartitions not implemented")
}

func RegisterMetastorePartitionServiceServer(s *grpc.Server, srv MetastorePartitionServiceServer) {
	s.RegisterService(&_MetastorePartitionService_serviceDesc, srv)
}

func _MetastorePartitionService_BatchCreateMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).BatchCreateMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchCreateMetastorePartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).BatchCreateMetastorePartitions(ctx, req.(*BatchCreateMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_BatchDeleteMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).BatchDeleteMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchDeleteMetastorePartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).BatchDeleteMetastorePartitions(ctx, req.(*BatchDeleteMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_BatchUpdateMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).BatchUpdateMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchUpdateMetastorePartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).BatchUpdateMetastorePartitions(ctx, req.(*BatchUpdateMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_ListMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).ListMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/ListMetastorePartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).ListMetastorePartitions(ctx, req.(*ListMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_StreamMetastorePartitions_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MetastorePartitionServiceServer).StreamMetastorePartitions(&metastorePartitionServiceStreamMetastorePartitionsServer{stream})
}

type MetastorePartitionService_StreamMetastorePartitionsServer interface {
	Send(*StreamMetastorePartitionsResponse) error
	Recv() (*StreamMetastorePartitionsRequest, error)
	grpc.ServerStream
}

type metastorePartitionServiceStreamMetastorePartitionsServer struct {
	grpc.ServerStream
}

func (x *metastorePartitionServiceStreamMetastorePartitionsServer) Send(m *StreamMetastorePartitionsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *metastorePartitionServiceStreamMetastorePartitionsServer) Recv() (*StreamMetastorePartitionsRequest, error) {
	m := new(StreamMetastorePartitionsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _MetastorePartitionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1alpha.MetastorePartitionService",
	HandlerType: (*MetastorePartitionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchCreateMetastorePartitions",
			Handler:    _MetastorePartitionService_BatchCreateMetastorePartitions_Handler,
		},
		{
			MethodName: "BatchDeleteMetastorePartitions",
			Handler:    _MetastorePartitionService_BatchDeleteMetastorePartitions_Handler,
		},
		{
			MethodName: "BatchUpdateMetastorePartitions",
			Handler:    _MetastorePartitionService_BatchUpdateMetastorePartitions_Handler,
		},
		{
			MethodName: "ListMetastorePartitions",
			Handler:    _MetastorePartitionService_ListMetastorePartitions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamMetastorePartitions",
			Handler:       _MetastorePartitionService_StreamMetastorePartitions_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1alpha/metastore_partition.proto",
}
