// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/datalabeling/v1beta1/human_annotation_config.proto

package datalabelingpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StringAggregationType int32

const (
	StringAggregationType_STRING_AGGREGATION_TYPE_UNSPECIFIED StringAggregationType = 0
	// Majority vote to aggregate answers.
	StringAggregationType_MAJORITY_VOTE StringAggregationType = 1
	// Unanimous answers will be adopted.
	StringAggregationType_UNANIMOUS_VOTE StringAggregationType = 2
	// Preserve all answers by crowd compute.
	StringAggregationType_NO_AGGREGATION StringAggregationType = 3
)

// Enum value maps for StringAggregationType.
var (
	StringAggregationType_name = map[int32]string{
		0: "STRING_AGGREGATION_TYPE_UNSPECIFIED",
		1: "MAJORITY_VOTE",
		2: "UNANIMOUS_VOTE",
		3: "NO_AGGREGATION",
	}
	StringAggregationType_value = map[string]int32{
		"STRING_AGGREGATION_TYPE_UNSPECIFIED": 0,
		"MAJORITY_VOTE":                       1,
		"UNANIMOUS_VOTE":                      2,
		"NO_AGGREGATION":                      3,
	}
)

func (x StringAggregationType) Enum() *StringAggregationType {
	p := new(StringAggregationType)
	*p = x
	return p
}

func (x StringAggregationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StringAggregationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_enumTypes[0].Descriptor()
}

func (StringAggregationType) Type() protoreflect.EnumType {
	return &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_enumTypes[0]
}

func (x StringAggregationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StringAggregationType.Descriptor instead.
func (StringAggregationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{0}
}

// Configuration for how human labeling task should be done.
type HumanAnnotationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Instruction resource name.
	Instruction string `protobuf:"bytes,1,opt,name=instruction,proto3" json:"instruction,omitempty"`
	// Required. A human-readable name for AnnotatedDataset defined by
	// users. Maximum of 64 characters
	// .
	AnnotatedDatasetDisplayName string `protobuf:"bytes,2,opt,name=annotated_dataset_display_name,json=annotatedDatasetDisplayName,proto3" json:"annotated_dataset_display_name,omitempty"`
	// Optional. A human-readable description for AnnotatedDataset.
	// The description can be up to 10000 characters long.
	AnnotatedDatasetDescription string `protobuf:"bytes,3,opt,name=annotated_dataset_description,json=annotatedDatasetDescription,proto3" json:"annotated_dataset_description,omitempty"`
	// Optional. A human-readable label used to logically group labeling tasks.
	// This string must match the regular expression `[a-zA-Z\\d_-]{0,128}`.
	LabelGroup string `protobuf:"bytes,4,opt,name=label_group,json=labelGroup,proto3" json:"label_group,omitempty"`
	// Optional. The Language of this question, as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	// Default value is en-US.
	// Only need to set this when task is language related. For example, French
	// text classification.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Replication of questions. Each question will be sent to up to
	// this number of contributors to label. Aggregated answers will be returned.
	// Default is set to 1.
	// For image related labeling, valid values are 1, 3, 5.
	ReplicaCount int32 `protobuf:"varint,6,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	// Optional. Maximum duration for contributors to answer a question. Maximum
	// is 3600 seconds. Default is 3600 seconds.
	QuestionDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=question_duration,json=questionDuration,proto3" json:"question_duration,omitempty"`
	// Optional. If you want your own labeling contributors to manage and work on
	// this labeling request, you can set these contributors here. We will give
	// them access to the question types in crowdcompute. Note that these
	// emails must be registered in crowdcompute worker UI:
	// https://crowd-compute.appspot.com/
	ContributorEmails []string `protobuf:"bytes,9,rep,name=contributor_emails,json=contributorEmails,proto3" json:"contributor_emails,omitempty"`
	// Email of the user who started the labeling task and should be notified by
	// email. If empty no notification will be sent.
	UserEmailAddress string `protobuf:"bytes,10,opt,name=user_email_address,json=userEmailAddress,proto3" json:"user_email_address,omitempty"`
}

func (x *HumanAnnotationConfig) Reset() {
	*x = HumanAnnotationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAnnotationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAnnotationConfig) ProtoMessage() {}

func (x *HumanAnnotationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAnnotationConfig.ProtoReflect.Descriptor instead.
func (*HumanAnnotationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{0}
}

func (x *HumanAnnotationConfig) GetInstruction() string {
	if x != nil {
		return x.Instruction
	}
	return ""
}

func (x *HumanAnnotationConfig) GetAnnotatedDatasetDisplayName() string {
	if x != nil {
		return x.AnnotatedDatasetDisplayName
	}
	return ""
}

func (x *HumanAnnotationConfig) GetAnnotatedDatasetDescription() string {
	if x != nil {
		return x.AnnotatedDatasetDescription
	}
	return ""
}

func (x *HumanAnnotationConfig) GetLabelGroup() string {
	if x != nil {
		return x.LabelGroup
	}
	return ""
}

func (x *HumanAnnotationConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *HumanAnnotationConfig) GetReplicaCount() int32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

func (x *HumanAnnotationConfig) GetQuestionDuration() *durationpb.Duration {
	if x != nil {
		return x.QuestionDuration
	}
	return nil
}

func (x *HumanAnnotationConfig) GetContributorEmails() []string {
	if x != nil {
		return x.ContributorEmails
	}
	return nil
}

func (x *HumanAnnotationConfig) GetUserEmailAddress() string {
	if x != nil {
		return x.UserEmailAddress
	}
	return ""
}

// Config for image classification human labeling task.
type ImageClassificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Optional. If allow_multi_label is true, contributors are able to choose
	// multiple labels for one image.
	AllowMultiLabel bool `protobuf:"varint,2,opt,name=allow_multi_label,json=allowMultiLabel,proto3" json:"allow_multi_label,omitempty"`
	// Optional. The type of how to aggregate answers.
	AnswerAggregationType StringAggregationType `protobuf:"varint,3,opt,name=answer_aggregation_type,json=answerAggregationType,proto3,enum=google.cloud.datalabeling.v1beta1.StringAggregationType" json:"answer_aggregation_type,omitempty"`
}

func (x *ImageClassificationConfig) Reset() {
	*x = ImageClassificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageClassificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageClassificationConfig) ProtoMessage() {}

func (x *ImageClassificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageClassificationConfig.ProtoReflect.Descriptor instead.
func (*ImageClassificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{1}
}

func (x *ImageClassificationConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *ImageClassificationConfig) GetAllowMultiLabel() bool {
	if x != nil {
		return x.AllowMultiLabel
	}
	return false
}

func (x *ImageClassificationConfig) GetAnswerAggregationType() StringAggregationType {
	if x != nil {
		return x.AnswerAggregationType
	}
	return StringAggregationType_STRING_AGGREGATION_TYPE_UNSPECIFIED
}

// Config for image bounding poly (and bounding box) human labeling task.
type BoundingPolyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Optional. Instruction message showed on contributors UI.
	InstructionMessage string `protobuf:"bytes,2,opt,name=instruction_message,json=instructionMessage,proto3" json:"instruction_message,omitempty"`
}

func (x *BoundingPolyConfig) Reset() {
	*x = BoundingPolyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundingPolyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundingPolyConfig) ProtoMessage() {}

func (x *BoundingPolyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundingPolyConfig.ProtoReflect.Descriptor instead.
func (*BoundingPolyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{2}
}

func (x *BoundingPolyConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *BoundingPolyConfig) GetInstructionMessage() string {
	if x != nil {
		return x.InstructionMessage
	}
	return ""
}

// Config for image polyline human labeling task.
type PolylineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Optional. Instruction message showed on contributors UI.
	InstructionMessage string `protobuf:"bytes,2,opt,name=instruction_message,json=instructionMessage,proto3" json:"instruction_message,omitempty"`
}

func (x *PolylineConfig) Reset() {
	*x = PolylineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolylineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolylineConfig) ProtoMessage() {}

func (x *PolylineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolylineConfig.ProtoReflect.Descriptor instead.
func (*PolylineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{3}
}

func (x *PolylineConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *PolylineConfig) GetInstructionMessage() string {
	if x != nil {
		return x.InstructionMessage
	}
	return ""
}

// Config for image segmentation
type SegmentationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name. format:
	// projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Instruction message showed on labelers UI.
	InstructionMessage string `protobuf:"bytes,2,opt,name=instruction_message,json=instructionMessage,proto3" json:"instruction_message,omitempty"`
}

func (x *SegmentationConfig) Reset() {
	*x = SegmentationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentationConfig) ProtoMessage() {}

func (x *SegmentationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentationConfig.ProtoReflect.Descriptor instead.
func (*SegmentationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{4}
}

func (x *SegmentationConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *SegmentationConfig) GetInstructionMessage() string {
	if x != nil {
		return x.InstructionMessage
	}
	return ""
}

// Config for video classification human labeling task.
// Currently two types of video classification are supported:
// 1. Assign labels on the entire video.
// 2. Split the video into multiple video clips based on camera shot, and
// assign labels on each video clip.
type VideoClassificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of annotation spec set configs.
	// Since watching a video clip takes much longer time than an image, we
	// support label with multiple AnnotationSpecSet at the same time. Labels
	// in each AnnotationSpecSet will be shown in a group to contributors.
	// Contributors can select one or more (depending on whether to allow multi
	// label) from each group.
	AnnotationSpecSetConfigs []*VideoClassificationConfig_AnnotationSpecSetConfig `protobuf:"bytes,1,rep,name=annotation_spec_set_configs,json=annotationSpecSetConfigs,proto3" json:"annotation_spec_set_configs,omitempty"`
	// Optional. Option to apply shot detection on the video.
	ApplyShotDetection bool `protobuf:"varint,2,opt,name=apply_shot_detection,json=applyShotDetection,proto3" json:"apply_shot_detection,omitempty"`
}

func (x *VideoClassificationConfig) Reset() {
	*x = VideoClassificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationConfig) ProtoMessage() {}

func (x *VideoClassificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationConfig.ProtoReflect.Descriptor instead.
func (*VideoClassificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{5}
}

func (x *VideoClassificationConfig) GetAnnotationSpecSetConfigs() []*VideoClassificationConfig_AnnotationSpecSetConfig {
	if x != nil {
		return x.AnnotationSpecSetConfigs
	}
	return nil
}

func (x *VideoClassificationConfig) GetApplyShotDetection() bool {
	if x != nil {
		return x.ApplyShotDetection
	}
	return false
}

// Config for video object detection human labeling task.
// Object detection will be conducted on the images extracted from the video,
// and those objects will be labeled with bounding boxes.
// User need to specify the number of images to be extracted per second as the
// extraction frame rate.
type ObjectDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Required. Number of frames per second to be extracted from the video.
	ExtractionFrameRate float64 `protobuf:"fixed64,3,opt,name=extraction_frame_rate,json=extractionFrameRate,proto3" json:"extraction_frame_rate,omitempty"`
}

func (x *ObjectDetectionConfig) Reset() {
	*x = ObjectDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionConfig) ProtoMessage() {}

func (x *ObjectDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionConfig.ProtoReflect.Descriptor instead.
func (*ObjectDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{6}
}

func (x *ObjectDetectionConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *ObjectDetectionConfig) GetExtractionFrameRate() float64 {
	if x != nil {
		return x.ExtractionFrameRate
	}
	return 0
}

// Config for video object tracking human labeling task.
type ObjectTrackingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
}

func (x *ObjectTrackingConfig) Reset() {
	*x = ObjectTrackingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectTrackingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectTrackingConfig) ProtoMessage() {}

func (x *ObjectTrackingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectTrackingConfig.ProtoReflect.Descriptor instead.
func (*ObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{7}
}

func (x *ObjectTrackingConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

// Config for video event human labeling task.
type EventConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of annotation spec set resource name. Similar to video
	// classification, we support selecting event from multiple AnnotationSpecSet
	// at the same time.
	AnnotationSpecSets []string `protobuf:"bytes,1,rep,name=annotation_spec_sets,json=annotationSpecSets,proto3" json:"annotation_spec_sets,omitempty"`
}

func (x *EventConfig) Reset() {
	*x = EventConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventConfig) ProtoMessage() {}

func (x *EventConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventConfig.ProtoReflect.Descriptor instead.
func (*EventConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{8}
}

func (x *EventConfig) GetAnnotationSpecSets() []string {
	if x != nil {
		return x.AnnotationSpecSets
	}
	return nil
}

// Config for text classification human labeling task.
type TextClassificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If allow_multi_label is true, contributors are able to choose
	// multiple labels for one text segment.
	AllowMultiLabel bool `protobuf:"varint,1,opt,name=allow_multi_label,json=allowMultiLabel,proto3" json:"allow_multi_label,omitempty"`
	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,2,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Optional. Configs for sentiment selection.
	SentimentConfig *SentimentConfig `protobuf:"bytes,3,opt,name=sentiment_config,json=sentimentConfig,proto3" json:"sentiment_config,omitempty"`
}

func (x *TextClassificationConfig) Reset() {
	*x = TextClassificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextClassificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextClassificationConfig) ProtoMessage() {}

func (x *TextClassificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextClassificationConfig.ProtoReflect.Descriptor instead.
func (*TextClassificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{9}
}

func (x *TextClassificationConfig) GetAllowMultiLabel() bool {
	if x != nil {
		return x.AllowMultiLabel
	}
	return false
}

func (x *TextClassificationConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *TextClassificationConfig) GetSentimentConfig() *SentimentConfig {
	if x != nil {
		return x.SentimentConfig
	}
	return nil
}

// Config for setting up sentiments.
type SentimentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to true, contributors will have the option to select sentiment of
	// the label they selected, to mark it as negative or positive label. Default
	// is false.
	EnableLabelSentimentSelection bool `protobuf:"varint,1,opt,name=enable_label_sentiment_selection,json=enableLabelSentimentSelection,proto3" json:"enable_label_sentiment_selection,omitempty"`
}

func (x *SentimentConfig) Reset() {
	*x = SentimentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SentimentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SentimentConfig) ProtoMessage() {}

func (x *SentimentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SentimentConfig.ProtoReflect.Descriptor instead.
func (*SentimentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{10}
}

func (x *SentimentConfig) GetEnableLabelSentimentSelection() bool {
	if x != nil {
		return x.EnableLabelSentimentSelection
	}
	return false
}

// Config for text entity extraction human labeling task.
type TextEntityExtractionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
}

func (x *TextEntityExtractionConfig) Reset() {
	*x = TextEntityExtractionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextEntityExtractionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextEntityExtractionConfig) ProtoMessage() {}

func (x *TextEntityExtractionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextEntityExtractionConfig.ProtoReflect.Descriptor instead.
func (*TextEntityExtractionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{11}
}

func (x *TextEntityExtractionConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

// Annotation spec set with the setting of allowing multi labels or not.
type VideoClassificationConfig_AnnotationSpecSetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Annotation spec set resource name.
	AnnotationSpecSet string `protobuf:"bytes,1,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Optional. If allow_multi_label is true, contributors are able to
	// choose multiple labels from one annotation spec set.
	AllowMultiLabel bool `protobuf:"varint,2,opt,name=allow_multi_label,json=allowMultiLabel,proto3" json:"allow_multi_label,omitempty"`
}

func (x *VideoClassificationConfig_AnnotationSpecSetConfig) Reset() {
	*x = VideoClassificationConfig_AnnotationSpecSetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationConfig_AnnotationSpecSetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationConfig_AnnotationSpecSetConfig) ProtoMessage() {}

func (x *VideoClassificationConfig_AnnotationSpecSetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationConfig_AnnotationSpecSetConfig.ProtoReflect.Descriptor instead.
func (*VideoClassificationConfig_AnnotationSpecSetConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP(), []int{5, 0}
}

func (x *VideoClassificationConfig_AnnotationSpecSetConfig) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *VideoClassificationConfig_AnnotationSpecSetConfig) GetAllowMultiLabel() bool {
	if x != nil {
		return x.AllowMultiLabel
	}
	return false
}

var File_google_cloud_datalabeling_v1beta1_human_annotation_config_proto protoreflect.FileDescriptor

var file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfa, 0x03, 0x0a, 0x15, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x25, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x1e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x1b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x47, 0x0a, 0x1d, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x11, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x32, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x75, 0x73, 0x65, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x22, 0xf8, 0x01, 0x0a, 0x19, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x75, 0x0a, 0x17, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x7f, 0x0a,
	0x12, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x7b,
	0x0a, 0x0e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x7a, 0x0a, 0x12, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xee, 0x02, 0x0a, 0x19, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x98, 0x01, 0x0a, 0x1b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0x35, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x53, 0x68, 0x6f, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x7f, 0x0a, 0x17, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x85, 0x01, 0x0a, 0x15, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x65, 0x78, 0x74,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65,
	0x22, 0x4b, 0x0a, 0x14, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x22, 0x44, 0x0a,
	0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x35, 0x0a, 0x14,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f,
	0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53,
	0x65, 0x74, 0x73, 0x22, 0xe4, 0x01, 0x0a, 0x18, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x62, 0x0a, 0x10, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5a, 0x0a, 0x0f, 0x53, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a,
	0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x51, 0x0a, 0x1a, 0x54, 0x65, 0x78, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x2a, 0x7b, 0x0a, 0x15, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x47, 0x47,
	0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x4d,
	0x41, 0x4a, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x56, 0x4f, 0x54, 0x45, 0x10, 0x01, 0x12, 0x12,
	0x0a, 0x0e, 0x55, 0x4e, 0x41, 0x4e, 0x49, 0x4d, 0x4f, 0x55, 0x53, 0x5f, 0x56, 0x4f, 0x54, 0x45,
	0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x42, 0xe7, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x50, 0x01, 0x5a, 0x4d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescOnce sync.Once
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescData = file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDesc
)

func file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescGZIP() []byte {
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescData)
	})
	return file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDescData
}

var file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_goTypes = []interface{}{
	(StringAggregationType)(0),                                // 0: google.cloud.datalabeling.v1beta1.StringAggregationType
	(*HumanAnnotationConfig)(nil),                             // 1: google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	(*ImageClassificationConfig)(nil),                         // 2: google.cloud.datalabeling.v1beta1.ImageClassificationConfig
	(*BoundingPolyConfig)(nil),                                // 3: google.cloud.datalabeling.v1beta1.BoundingPolyConfig
	(*PolylineConfig)(nil),                                    // 4: google.cloud.datalabeling.v1beta1.PolylineConfig
	(*SegmentationConfig)(nil),                                // 5: google.cloud.datalabeling.v1beta1.SegmentationConfig
	(*VideoClassificationConfig)(nil),                         // 6: google.cloud.datalabeling.v1beta1.VideoClassificationConfig
	(*ObjectDetectionConfig)(nil),                             // 7: google.cloud.datalabeling.v1beta1.ObjectDetectionConfig
	(*ObjectTrackingConfig)(nil),                              // 8: google.cloud.datalabeling.v1beta1.ObjectTrackingConfig
	(*EventConfig)(nil),                                       // 9: google.cloud.datalabeling.v1beta1.EventConfig
	(*TextClassificationConfig)(nil),                          // 10: google.cloud.datalabeling.v1beta1.TextClassificationConfig
	(*SentimentConfig)(nil),                                   // 11: google.cloud.datalabeling.v1beta1.SentimentConfig
	(*TextEntityExtractionConfig)(nil),                        // 12: google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
	(*VideoClassificationConfig_AnnotationSpecSetConfig)(nil), // 13: google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
	(*durationpb.Duration)(nil),                               // 14: google.protobuf.Duration
}
var file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_depIdxs = []int32{
	14, // 0: google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.question_duration:type_name -> google.protobuf.Duration
	0,  // 1: google.cloud.datalabeling.v1beta1.ImageClassificationConfig.answer_aggregation_type:type_name -> google.cloud.datalabeling.v1beta1.StringAggregationType
	13, // 2: google.cloud.datalabeling.v1beta1.VideoClassificationConfig.annotation_spec_set_configs:type_name -> google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
	11, // 3: google.cloud.datalabeling.v1beta1.TextClassificationConfig.sentiment_config:type_name -> google.cloud.datalabeling.v1beta1.SentimentConfig
	4,  // [4:4] is the sub-list for method output_type
	4,  // [4:4] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_init() }
func file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_init() {
	if File_google_cloud_datalabeling_v1beta1_human_annotation_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HumanAnnotationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageClassificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundingPolyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolylineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectTrackingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextClassificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SentimentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextEntityExtractionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationConfig_AnnotationSpecSetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_msgTypes,
	}.Build()
	File_google_cloud_datalabeling_v1beta1_human_annotation_config_proto = out.File
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_rawDesc = nil
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_goTypes = nil
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_depIdxs = nil
}
