// Java class srp.Auth is a proxy for talking to a Go program.
//   gobind -lang=java go-srp
//
// File is generated by gobind. Do not edit.
package srp;

import go.Seq;

/**
 * Auth stores byte data for the calculation of SRP proofs.
 * Changed SrpAuto to Auth because the name will be used as srp.SrpAuto by other packages and as SrpSrpAuth on mobile
 * Also the data from the API called Auth. it could be match the meaning and reduce the confusion
 */
public final class Auth implements Seq.Proxy {
	static { Srp.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	/**
	 * NewAuth Creates new Auth from strings input. Salt and server ephemeral are in
	base64 format. Modulus is base64 with signature attached. The signature is
	verified against server key. The version controls password hash algorithm.
	
	Parameters:
		 - version int: The *x* component of the vector.
		 - username string: The *y* component of the vector.
		 - password string: The *z* component of the vector.
		 - salt string:
	Returns:
	  - auth *Auth: the pre caculated auth information
	  - err error: throw error
	Usage:
	
	Warnings:
		 - Be carefull! Poos can hurt.
	 */
	public Auth(long version, String username, String password, String salt, String signedModulus, String serverEphemeral) {
		this.refnum = __NewAuth(version, username, password, salt, signedModulus, serverEphemeral);
		Seq.trackGoRef(refnum, this);
	}
	
	private static native int __NewAuth(long version, String username, String password, String salt, String signedModulus, String serverEphemeral);
	
	/**
	 * NewAuthForVerifier Creates new Auth from strings input. Salt and server ephemeral are in
	base64 format. Modulus is base64 with signature attached. The signature is
	verified against server key. The version controls password hash algorithm.
	
	Parameters:
		 - version int: The *x* component of the vector.
		 - username string: The *y* component of the vector.
		 - password string: The *z* component of the vector.
		 - salt string:
	Returns:
	  - auth *Auth: the pre caculated auth information
	  - err error: throw error
	Usage:
	
	Warnings:
		 - none.
	 */
	public Auth(String password, String signedModulus, byte[] rawSalt) {
		this.refnum = __NewAuthForVerifier(password, signedModulus, rawSalt);
		Seq.trackGoRef(refnum, this);
	}
	
	private static native int __NewAuthForVerifier(String password, String signedModulus, byte[] rawSalt);
	
	Auth(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	public final native byte[] getModulus();
	public final native void setModulus(byte[] v);
	
	public final native byte[] getServerEphemeral();
	public final native void setServerEphemeral(byte[] v);
	
	public final native byte[] getHashedPassword();
	public final native void setHashedPassword(byte[] v);
	
	/**
	 * GenerateProofs calculates SPR proofs.
	 */
	public native Proofs generateProofs(long bitLength) throws Exception;
	/**
	 * GenerateVerifier verifier for update pwds and create accounts
	 */
	public native byte[] generateVerifier(long bitLength) throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof Auth)) {
		    return false;
		}
		Auth that = (Auth)o;
		byte[] thisModulus = getModulus();
		byte[] thatModulus = that.getModulus();
		if (thisModulus == null) {
			if (thatModulus != null) {
			    return false;
			}
		} else if (!thisModulus.equals(thatModulus)) {
		    return false;
		}
		byte[] thisServerEphemeral = getServerEphemeral();
		byte[] thatServerEphemeral = that.getServerEphemeral();
		if (thisServerEphemeral == null) {
			if (thatServerEphemeral != null) {
			    return false;
			}
		} else if (!thisServerEphemeral.equals(thatServerEphemeral)) {
		    return false;
		}
		byte[] thisHashedPassword = getHashedPassword();
		byte[] thatHashedPassword = that.getHashedPassword();
		if (thisHashedPassword == null) {
			if (thatHashedPassword != null) {
			    return false;
			}
		} else if (!thisHashedPassword.equals(thatHashedPassword)) {
		    return false;
		}
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {getModulus(), getServerEphemeral(), getHashedPassword()});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("Auth").append("{");
		b.append("Modulus:").append(getModulus()).append(",");
		b.append("ServerEphemeral:").append(getServerEphemeral()).append(",");
		b.append("HashedPassword:").append(getHashedPassword()).append(",");
		return b.append("}").toString();
	}
}

