// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lakeformation

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddLFTagsToResource = "AddLFTagsToResource"

// AddLFTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddLFTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddLFTagsToResource for more information on using the AddLFTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddLFTagsToResourceRequest method.
//    req, resp := client.AddLFTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AddLFTagsToResource
func (c *LakeFormation) AddLFTagsToResourceRequest(input *AddLFTagsToResourceInput) (req *request.Request, output *AddLFTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddLFTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddLFTagsToResourceInput{}
	}

	output = &AddLFTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddLFTagsToResource API operation for AWS Lake Formation.
//
// Attaches one or more tags to an existing resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation AddLFTagsToResource for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AddLFTagsToResource
func (c *LakeFormation) AddLFTagsToResource(input *AddLFTagsToResourceInput) (*AddLFTagsToResourceOutput, error) {
	req, out := c.AddLFTagsToResourceRequest(input)
	return out, req.Send()
}

// AddLFTagsToResourceWithContext is the same as AddLFTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddLFTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) AddLFTagsToResourceWithContext(ctx aws.Context, input *AddLFTagsToResourceInput, opts ...request.Option) (*AddLFTagsToResourceOutput, error) {
	req, out := c.AddLFTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGrantPermissions = "BatchGrantPermissions"

// BatchGrantPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGrantPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGrantPermissions for more information on using the BatchGrantPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGrantPermissionsRequest method.
//    req, resp := client.BatchGrantPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions
func (c *LakeFormation) BatchGrantPermissionsRequest(input *BatchGrantPermissionsInput) (req *request.Request, output *BatchGrantPermissionsOutput) {
	op := &request.Operation{
		Name:       opBatchGrantPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGrantPermissionsInput{}
	}

	output = &BatchGrantPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGrantPermissions API operation for AWS Lake Formation.
//
// Batch operation to grant permissions to the principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation BatchGrantPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions
func (c *LakeFormation) BatchGrantPermissions(input *BatchGrantPermissionsInput) (*BatchGrantPermissionsOutput, error) {
	req, out := c.BatchGrantPermissionsRequest(input)
	return out, req.Send()
}

// BatchGrantPermissionsWithContext is the same as BatchGrantPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGrantPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) BatchGrantPermissionsWithContext(ctx aws.Context, input *BatchGrantPermissionsInput, opts ...request.Option) (*BatchGrantPermissionsOutput, error) {
	req, out := c.BatchGrantPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchRevokePermissions = "BatchRevokePermissions"

// BatchRevokePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchRevokePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchRevokePermissions for more information on using the BatchRevokePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchRevokePermissionsRequest method.
//    req, resp := client.BatchRevokePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions
func (c *LakeFormation) BatchRevokePermissionsRequest(input *BatchRevokePermissionsInput) (req *request.Request, output *BatchRevokePermissionsOutput) {
	op := &request.Operation{
		Name:       opBatchRevokePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchRevokePermissionsInput{}
	}

	output = &BatchRevokePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchRevokePermissions API operation for AWS Lake Formation.
//
// Batch operation to revoke permissions from the principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation BatchRevokePermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions
func (c *LakeFormation) BatchRevokePermissions(input *BatchRevokePermissionsInput) (*BatchRevokePermissionsOutput, error) {
	req, out := c.BatchRevokePermissionsRequest(input)
	return out, req.Send()
}

// BatchRevokePermissionsWithContext is the same as BatchRevokePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See BatchRevokePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) BatchRevokePermissionsWithContext(ctx aws.Context, input *BatchRevokePermissionsInput, opts ...request.Option) (*BatchRevokePermissionsOutput, error) {
	req, out := c.BatchRevokePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLFTag = "CreateLFTag"

// CreateLFTagRequest generates a "aws/request.Request" representing the
// client's request for the CreateLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLFTag for more information on using the CreateLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLFTagRequest method.
//    req, resp := client.CreateLFTagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLFTag
func (c *LakeFormation) CreateLFTagRequest(input *CreateLFTagInput) (req *request.Request, output *CreateLFTagOutput) {
	op := &request.Operation{
		Name:       opCreateLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLFTagInput{}
	}

	output = &CreateLFTagOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateLFTag API operation for AWS Lake Formation.
//
// Creates a tag with the specified name and values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CreateLFTag for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLFTag
func (c *LakeFormation) CreateLFTag(input *CreateLFTagInput) (*CreateLFTagOutput, error) {
	req, out := c.CreateLFTagRequest(input)
	return out, req.Send()
}

// CreateLFTagWithContext is the same as CreateLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CreateLFTagWithContext(ctx aws.Context, input *CreateLFTagInput, opts ...request.Option) (*CreateLFTagOutput, error) {
	req, out := c.CreateLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLFTag = "DeleteLFTag"

// DeleteLFTagRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLFTag for more information on using the DeleteLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLFTagRequest method.
//    req, resp := client.DeleteLFTagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLFTag
func (c *LakeFormation) DeleteLFTagRequest(input *DeleteLFTagInput) (req *request.Request, output *DeleteLFTagOutput) {
	op := &request.Operation{
		Name:       opDeleteLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLFTagInput{}
	}

	output = &DeleteLFTagOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLFTag API operation for AWS Lake Formation.
//
// Deletes the specified tag key name. If the attribute key does not exist or
// the tag does not exist, then the operation will not do anything. If the attribute
// key exists, then the operation checks if any resources are tagged with this
// attribute key, if yes, the API throws a 400 Exception with the message "Delete
// not allowed" as the tag key is still attached with resources. You can consider
// untagging resources with this tag key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeleteLFTag for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLFTag
func (c *LakeFormation) DeleteLFTag(input *DeleteLFTagInput) (*DeleteLFTagOutput, error) {
	req, out := c.DeleteLFTagRequest(input)
	return out, req.Send()
}

// DeleteLFTagWithContext is the same as DeleteLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeleteLFTagWithContext(ctx aws.Context, input *DeleteLFTagInput, opts ...request.Option) (*DeleteLFTagOutput, error) {
	req, out := c.DeleteLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterResource = "DeregisterResource"

// DeregisterResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterResource for more information on using the DeregisterResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterResourceRequest method.
//    req, resp := client.DeregisterResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource
func (c *LakeFormation) DeregisterResourceRequest(input *DeregisterResourceInput) (req *request.Request, output *DeregisterResourceOutput) {
	op := &request.Operation{
		Name:       opDeregisterResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterResourceInput{}
	}

	output = &DeregisterResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterResource API operation for AWS Lake Formation.
//
// Deregisters the resource as managed by the Data Catalog.
//
// When you deregister a path, Lake Formation removes the path from the inline
// policy attached to your service-linked role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeregisterResource for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource
func (c *LakeFormation) DeregisterResource(input *DeregisterResourceInput) (*DeregisterResourceOutput, error) {
	req, out := c.DeregisterResourceRequest(input)
	return out, req.Send()
}

// DeregisterResourceWithContext is the same as DeregisterResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeregisterResourceWithContext(ctx aws.Context, input *DeregisterResourceInput, opts ...request.Option) (*DeregisterResourceOutput, error) {
	req, out := c.DeregisterResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResource = "DescribeResource"

// DescribeResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResource for more information on using the DescribeResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceRequest method.
//    req, resp := client.DescribeResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource
func (c *LakeFormation) DescribeResourceRequest(input *DescribeResourceInput) (req *request.Request, output *DescribeResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceInput{}
	}

	output = &DescribeResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResource API operation for AWS Lake Formation.
//
// Retrieves the current data access role for the given resource registered
// in AWS Lake Formation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DescribeResource for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource
func (c *LakeFormation) DescribeResource(input *DescribeResourceInput) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	return out, req.Send()
}

// DescribeResourceWithContext is the same as DescribeResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DescribeResourceWithContext(ctx aws.Context, input *DescribeResourceInput, opts ...request.Option) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataLakeSettings = "GetDataLakeSettings"

// GetDataLakeSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetDataLakeSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataLakeSettings for more information on using the GetDataLakeSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataLakeSettingsRequest method.
//    req, resp := client.GetDataLakeSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings
func (c *LakeFormation) GetDataLakeSettingsRequest(input *GetDataLakeSettingsInput) (req *request.Request, output *GetDataLakeSettingsOutput) {
	op := &request.Operation{
		Name:       opGetDataLakeSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataLakeSettingsInput{}
	}

	output = &GetDataLakeSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataLakeSettings API operation for AWS Lake Formation.
//
// Retrieves the list of the data lake administrators of a Lake Formation-managed
// data lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetDataLakeSettings for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings
func (c *LakeFormation) GetDataLakeSettings(input *GetDataLakeSettingsInput) (*GetDataLakeSettingsOutput, error) {
	req, out := c.GetDataLakeSettingsRequest(input)
	return out, req.Send()
}

// GetDataLakeSettingsWithContext is the same as GetDataLakeSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataLakeSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetDataLakeSettingsWithContext(ctx aws.Context, input *GetDataLakeSettingsInput, opts ...request.Option) (*GetDataLakeSettingsOutput, error) {
	req, out := c.GetDataLakeSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEffectivePermissionsForPath = "GetEffectivePermissionsForPath"

// GetEffectivePermissionsForPathRequest generates a "aws/request.Request" representing the
// client's request for the GetEffectivePermissionsForPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEffectivePermissionsForPath for more information on using the GetEffectivePermissionsForPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEffectivePermissionsForPathRequest method.
//    req, resp := client.GetEffectivePermissionsForPathRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath
func (c *LakeFormation) GetEffectivePermissionsForPathRequest(input *GetEffectivePermissionsForPathInput) (req *request.Request, output *GetEffectivePermissionsForPathOutput) {
	op := &request.Operation{
		Name:       opGetEffectivePermissionsForPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEffectivePermissionsForPathInput{}
	}

	output = &GetEffectivePermissionsForPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEffectivePermissionsForPath API operation for AWS Lake Formation.
//
// Returns the Lake Formation permissions for a specified table or database
// resource located at a path in Amazon S3. GetEffectivePermissionsForPath will
// not return databases and tables if the catalog is encrypted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetEffectivePermissionsForPath for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath
func (c *LakeFormation) GetEffectivePermissionsForPath(input *GetEffectivePermissionsForPathInput) (*GetEffectivePermissionsForPathOutput, error) {
	req, out := c.GetEffectivePermissionsForPathRequest(input)
	return out, req.Send()
}

// GetEffectivePermissionsForPathWithContext is the same as GetEffectivePermissionsForPath with the addition of
// the ability to pass a context and additional request options.
//
// See GetEffectivePermissionsForPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetEffectivePermissionsForPathWithContext(ctx aws.Context, input *GetEffectivePermissionsForPathInput, opts ...request.Option) (*GetEffectivePermissionsForPathOutput, error) {
	req, out := c.GetEffectivePermissionsForPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEffectivePermissionsForPathPages iterates over the pages of a GetEffectivePermissionsForPath operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEffectivePermissionsForPath method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEffectivePermissionsForPath operation.
//    pageNum := 0
//    err := client.GetEffectivePermissionsForPathPages(params,
//        func(page *lakeformation.GetEffectivePermissionsForPathOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LakeFormation) GetEffectivePermissionsForPathPages(input *GetEffectivePermissionsForPathInput, fn func(*GetEffectivePermissionsForPathOutput, bool) bool) error {
	return c.GetEffectivePermissionsForPathPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEffectivePermissionsForPathPagesWithContext same as GetEffectivePermissionsForPathPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetEffectivePermissionsForPathPagesWithContext(ctx aws.Context, input *GetEffectivePermissionsForPathInput, fn func(*GetEffectivePermissionsForPathOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEffectivePermissionsForPathInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEffectivePermissionsForPathRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEffectivePermissionsForPathOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetLFTag = "GetLFTag"

// GetLFTagRequest generates a "aws/request.Request" representing the
// client's request for the GetLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLFTag for more information on using the GetLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLFTagRequest method.
//    req, resp := client.GetLFTagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetLFTag
func (c *LakeFormation) GetLFTagRequest(input *GetLFTagInput) (req *request.Request, output *GetLFTagOutput) {
	op := &request.Operation{
		Name:       opGetLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLFTagInput{}
	}

	output = &GetLFTagOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLFTag API operation for AWS Lake Formation.
//
// Returns a tag definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetLFTag for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetLFTag
func (c *LakeFormation) GetLFTag(input *GetLFTagInput) (*GetLFTagOutput, error) {
	req, out := c.GetLFTagRequest(input)
	return out, req.Send()
}

// GetLFTagWithContext is the same as GetLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See GetLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetLFTagWithContext(ctx aws.Context, input *GetLFTagInput, opts ...request.Option) (*GetLFTagOutput, error) {
	req, out := c.GetLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceLFTags = "GetResourceLFTags"

// GetResourceLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceLFTags for more information on using the GetResourceLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceLFTagsRequest method.
//    req, resp := client.GetResourceLFTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetResourceLFTags
func (c *LakeFormation) GetResourceLFTagsRequest(input *GetResourceLFTagsInput) (req *request.Request, output *GetResourceLFTagsOutput) {
	op := &request.Operation{
		Name:       opGetResourceLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceLFTagsInput{}
	}

	output = &GetResourceLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceLFTags API operation for AWS Lake Formation.
//
// Returns the tags applied to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetResourceLFTags for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * GlueEncryptionException
//   An encryption operation failed.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetResourceLFTags
func (c *LakeFormation) GetResourceLFTags(input *GetResourceLFTagsInput) (*GetResourceLFTagsOutput, error) {
	req, out := c.GetResourceLFTagsRequest(input)
	return out, req.Send()
}

// GetResourceLFTagsWithContext is the same as GetResourceLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetResourceLFTagsWithContext(ctx aws.Context, input *GetResourceLFTagsInput, opts ...request.Option) (*GetResourceLFTagsOutput, error) {
	req, out := c.GetResourceLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGrantPermissions = "GrantPermissions"

// GrantPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the GrantPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GrantPermissions for more information on using the GrantPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GrantPermissionsRequest method.
//    req, resp := client.GrantPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions
func (c *LakeFormation) GrantPermissionsRequest(input *GrantPermissionsInput) (req *request.Request, output *GrantPermissionsOutput) {
	op := &request.Operation{
		Name:       opGrantPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GrantPermissionsInput{}
	}

	output = &GrantPermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// GrantPermissions API operation for AWS Lake Formation.
//
// Grants permissions to the principal to access metadata in the Data Catalog
// and data organized in underlying data storage such as Amazon S3.
//
// For information about permissions, see Security and Access Control to Metadata
// and Data (https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GrantPermissions for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions
func (c *LakeFormation) GrantPermissions(input *GrantPermissionsInput) (*GrantPermissionsOutput, error) {
	req, out := c.GrantPermissionsRequest(input)
	return out, req.Send()
}

// GrantPermissionsWithContext is the same as GrantPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See GrantPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GrantPermissionsWithContext(ctx aws.Context, input *GrantPermissionsInput, opts ...request.Option) (*GrantPermissionsOutput, error) {
	req, out := c.GrantPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLFTags = "ListLFTags"

// ListLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLFTags for more information on using the ListLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLFTagsRequest method.
//    req, resp := client.ListLFTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags
func (c *LakeFormation) ListLFTagsRequest(input *ListLFTagsInput) (req *request.Request, output *ListLFTagsOutput) {
	op := &request.Operation{
		Name:       opListLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLFTagsInput{}
	}

	output = &ListLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLFTags API operation for AWS Lake Formation.
//
// Lists tags that the requester has permission to view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListLFTags for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags
func (c *LakeFormation) ListLFTags(input *ListLFTagsInput) (*ListLFTagsOutput, error) {
	req, out := c.ListLFTagsRequest(input)
	return out, req.Send()
}

// ListLFTagsWithContext is the same as ListLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListLFTagsWithContext(ctx aws.Context, input *ListLFTagsInput, opts ...request.Option) (*ListLFTagsOutput, error) {
	req, out := c.ListLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionsRequest method.
//    req, resp := client.ListPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions
func (c *LakeFormation) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for AWS Lake Formation.
//
// Returns a list of the principal permissions on the resource, filtered by
// the permissions of the caller. For example, if you are granted an ALTER permission,
// you are able to see only the principal permissions for ALTER.
//
// This operation returns only those permissions that have been explicitly granted.
//
// For information about permissions, see Security and Access Control to Metadata
// and Data (https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions
func (c *LakeFormation) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionsPages iterates over the pages of a ListPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPermissions operation.
//    pageNum := 0
//    err := client.ListPermissionsPages(params,
//        func(page *lakeformation.ListPermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LakeFormation) ListPermissionsPages(input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool) error {
	return c.ListPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionsPagesWithContext same as ListPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListPermissionsPagesWithContext(ctx aws.Context, input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources
func (c *LakeFormation) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS Lake Formation.
//
// Lists the resources registered to be managed by the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources
func (c *LakeFormation) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResources operation.
//    pageNum := 0
//    err := client.ListResourcesPages(params,
//        func(page *lakeformation.ListResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LakeFormation) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDataLakeSettings = "PutDataLakeSettings"

// PutDataLakeSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutDataLakeSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDataLakeSettings for more information on using the PutDataLakeSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDataLakeSettingsRequest method.
//    req, resp := client.PutDataLakeSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings
func (c *LakeFormation) PutDataLakeSettingsRequest(input *PutDataLakeSettingsInput) (req *request.Request, output *PutDataLakeSettingsOutput) {
	op := &request.Operation{
		Name:       opPutDataLakeSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDataLakeSettingsInput{}
	}

	output = &PutDataLakeSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDataLakeSettings API operation for AWS Lake Formation.
//
// Sets the list of data lake administrators who have admin privileges on all
// resources managed by Lake Formation. For more information on admin privileges,
// see Granting Lake Formation Permissions (https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html).
//
// This API replaces the current list of data lake admins with the new list
// being passed. To add an admin, fetch the current list and add the new admin
// to that list and pass that list in this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation PutDataLakeSettings for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings
func (c *LakeFormation) PutDataLakeSettings(input *PutDataLakeSettingsInput) (*PutDataLakeSettingsOutput, error) {
	req, out := c.PutDataLakeSettingsRequest(input)
	return out, req.Send()
}

// PutDataLakeSettingsWithContext is the same as PutDataLakeSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutDataLakeSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) PutDataLakeSettingsWithContext(ctx aws.Context, input *PutDataLakeSettingsInput, opts ...request.Option) (*PutDataLakeSettingsOutput, error) {
	req, out := c.PutDataLakeSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterResource = "RegisterResource"

// RegisterResourceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterResource for more information on using the RegisterResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterResourceRequest method.
//    req, resp := client.RegisterResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource
func (c *LakeFormation) RegisterResourceRequest(input *RegisterResourceInput) (req *request.Request, output *RegisterResourceOutput) {
	op := &request.Operation{
		Name:       opRegisterResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterResourceInput{}
	}

	output = &RegisterResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterResource API operation for AWS Lake Formation.
//
// Registers the resource as managed by the Data Catalog.
//
// To add or update data, Lake Formation needs read/write access to the chosen
// Amazon S3 path. Choose a role that you know has permission to do this, or
// choose the AWSServiceRoleForLakeFormationDataAccess service-linked role.
// When you register the first Amazon S3 path, the service-linked role and a
// new inline policy are created on your behalf. Lake Formation adds the first
// path to the inline policy and attaches it to the service-linked role. When
// you register subsequent paths, Lake Formation adds the path to the existing
// policy.
//
// The following request registers a new location and gives AWS Lake Formation
// permission to use the service-linked role to access that location.
//
// ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true
//
// If UseServiceLinkedRole is not set to true, you must provide or set the RoleArn:
//
// arn:aws:iam::12345:role/my-data-access-role
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation RegisterResource for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource
func (c *LakeFormation) RegisterResource(input *RegisterResourceInput) (*RegisterResourceOutput, error) {
	req, out := c.RegisterResourceRequest(input)
	return out, req.Send()
}

// RegisterResourceWithContext is the same as RegisterResource with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) RegisterResourceWithContext(ctx aws.Context, input *RegisterResourceInput, opts ...request.Option) (*RegisterResourceOutput, error) {
	req, out := c.RegisterResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveLFTagsFromResource = "RemoveLFTagsFromResource"

// RemoveLFTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveLFTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveLFTagsFromResource for more information on using the RemoveLFTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveLFTagsFromResourceRequest method.
//    req, resp := client.RemoveLFTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RemoveLFTagsFromResource
func (c *LakeFormation) RemoveLFTagsFromResourceRequest(input *RemoveLFTagsFromResourceInput) (req *request.Request, output *RemoveLFTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveLFTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveLFTagsFromResourceInput{}
	}

	output = &RemoveLFTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveLFTagsFromResource API operation for AWS Lake Formation.
//
// Removes a tag from the resource. Only database, table, or tableWithColumns
// resource are allowed. To tag columns, use the column inclusion list in tableWithColumns
// to specify column input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation RemoveLFTagsFromResource for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * GlueEncryptionException
//   An encryption operation failed.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RemoveLFTagsFromResource
func (c *LakeFormation) RemoveLFTagsFromResource(input *RemoveLFTagsFromResourceInput) (*RemoveLFTagsFromResourceOutput, error) {
	req, out := c.RemoveLFTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveLFTagsFromResourceWithContext is the same as RemoveLFTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveLFTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) RemoveLFTagsFromResourceWithContext(ctx aws.Context, input *RemoveLFTagsFromResourceInput, opts ...request.Option) (*RemoveLFTagsFromResourceOutput, error) {
	req, out := c.RemoveLFTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokePermissions = "RevokePermissions"

// RevokePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the RevokePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokePermissions for more information on using the RevokePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokePermissionsRequest method.
//    req, resp := client.RevokePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions
func (c *LakeFormation) RevokePermissionsRequest(input *RevokePermissionsInput) (req *request.Request, output *RevokePermissionsOutput) {
	op := &request.Operation{
		Name:       opRevokePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokePermissionsInput{}
	}

	output = &RevokePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokePermissions API operation for AWS Lake Formation.
//
// Revokes permissions to the principal to access metadata in the Data Catalog
// and data organized in underlying data storage such as Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation RevokePermissions for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions
func (c *LakeFormation) RevokePermissions(input *RevokePermissionsInput) (*RevokePermissionsOutput, error) {
	req, out := c.RevokePermissionsRequest(input)
	return out, req.Send()
}

// RevokePermissionsWithContext is the same as RevokePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See RevokePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) RevokePermissionsWithContext(ctx aws.Context, input *RevokePermissionsInput, opts ...request.Option) (*RevokePermissionsOutput, error) {
	req, out := c.RevokePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchDatabasesByLFTags = "SearchDatabasesByLFTags"

// SearchDatabasesByLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDatabasesByLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDatabasesByLFTags for more information on using the SearchDatabasesByLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchDatabasesByLFTagsRequest method.
//    req, resp := client.SearchDatabasesByLFTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags
func (c *LakeFormation) SearchDatabasesByLFTagsRequest(input *SearchDatabasesByLFTagsInput) (req *request.Request, output *SearchDatabasesByLFTagsOutput) {
	op := &request.Operation{
		Name:       opSearchDatabasesByLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchDatabasesByLFTagsInput{}
	}

	output = &SearchDatabasesByLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDatabasesByLFTags API operation for AWS Lake Formation.
//
// This operation allows a search on DATABASE resources by TagCondition. This
// operation is used by admins who want to grant user permissions on certain
// TagConditions. Before making a grant, the admin can use SearchDatabasesByTags
// to find all resources where the given TagConditions are valid to verify whether
// the returned resources can be shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation SearchDatabasesByLFTags for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * GlueEncryptionException
//   An encryption operation failed.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags
func (c *LakeFormation) SearchDatabasesByLFTags(input *SearchDatabasesByLFTagsInput) (*SearchDatabasesByLFTagsOutput, error) {
	req, out := c.SearchDatabasesByLFTagsRequest(input)
	return out, req.Send()
}

// SearchDatabasesByLFTagsWithContext is the same as SearchDatabasesByLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDatabasesByLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) SearchDatabasesByLFTagsWithContext(ctx aws.Context, input *SearchDatabasesByLFTagsInput, opts ...request.Option) (*SearchDatabasesByLFTagsOutput, error) {
	req, out := c.SearchDatabasesByLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchTablesByLFTags = "SearchTablesByLFTags"

// SearchTablesByLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the SearchTablesByLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchTablesByLFTags for more information on using the SearchTablesByLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchTablesByLFTagsRequest method.
//    req, resp := client.SearchTablesByLFTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags
func (c *LakeFormation) SearchTablesByLFTagsRequest(input *SearchTablesByLFTagsInput) (req *request.Request, output *SearchTablesByLFTagsOutput) {
	op := &request.Operation{
		Name:       opSearchTablesByLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchTablesByLFTagsInput{}
	}

	output = &SearchTablesByLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchTablesByLFTags API operation for AWS Lake Formation.
//
// This operation allows a search on TABLE resources by LFTags. This will be
// used by admins who want to grant user permissions on certain LFTags. Before
// making a grant, the admin can use SearchTablesByLFTags to find all resources
// where the given LFTags are valid to verify whether the returned resources
// can be shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation SearchTablesByLFTags for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * GlueEncryptionException
//   An encryption operation failed.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags
func (c *LakeFormation) SearchTablesByLFTags(input *SearchTablesByLFTagsInput) (*SearchTablesByLFTagsOutput, error) {
	req, out := c.SearchTablesByLFTagsRequest(input)
	return out, req.Send()
}

// SearchTablesByLFTagsWithContext is the same as SearchTablesByLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See SearchTablesByLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) SearchTablesByLFTagsWithContext(ctx aws.Context, input *SearchTablesByLFTagsInput, opts ...request.Option) (*SearchTablesByLFTagsOutput, error) {
	req, out := c.SearchTablesByLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLFTag = "UpdateLFTag"

// UpdateLFTagRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLFTag for more information on using the UpdateLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLFTagRequest method.
//    req, resp := client.UpdateLFTagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLFTag
func (c *LakeFormation) UpdateLFTagRequest(input *UpdateLFTagInput) (req *request.Request, output *UpdateLFTagOutput) {
	op := &request.Operation{
		Name:       opUpdateLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLFTagInput{}
	}

	output = &UpdateLFTagOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLFTag API operation for AWS Lake Formation.
//
// Updates the list of possible values for the specified tag key. If the tag
// does not exist, the operation throws an EntityNotFoundException. The values
// in the delete key values will be deleted from list of possible values. If
// any value in the delete key values is attached to a resource, then API errors
// out with a 400 Exception - "Update not allowed". Untag the attribute before
// deleting the tag key's value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateLFTag for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLFTag
func (c *LakeFormation) UpdateLFTag(input *UpdateLFTagInput) (*UpdateLFTagOutput, error) {
	req, out := c.UpdateLFTagRequest(input)
	return out, req.Send()
}

// UpdateLFTagWithContext is the same as UpdateLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateLFTagWithContext(ctx aws.Context, input *UpdateLFTagInput, opts ...request.Option) (*UpdateLFTagOutput, error) {
	req, out := c.UpdateLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResource for more information on using the UpdateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceRequest method.
//    req, resp := client.UpdateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource
func (c *LakeFormation) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *UpdateResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	output = &UpdateResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResource API operation for AWS Lake Formation.
//
// Updates the data access role used for vending access to the given (registered)
// resource in AWS Lake Formation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateResource for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource
func (c *LakeFormation) UpdateResource(input *UpdateResourceInput) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	return out, req.Send()
}

// UpdateResourceWithContext is the same as UpdateResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateResourceWithContext(ctx aws.Context, input *UpdateResourceInput, opts ...request.Option) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to a resource was denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddLFTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The tags to attach to the resource.
	//
	// LFTags is a required field
	LFTags []*LFTagPair `min:"1" type:"list" required:"true"`

	// The resource to which to attach a tag.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddLFTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLFTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddLFTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddLFTagsToResourceInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.LFTags == nil {
		invalidParams.Add(request.NewErrParamRequired("LFTags"))
	}
	if s.LFTags != nil && len(s.LFTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LFTags", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.LFTags != nil {
		for i, v := range s.LFTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LFTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *AddLFTagsToResourceInput) SetCatalogId(v string) *AddLFTagsToResourceInput {
	s.CatalogId = &v
	return s
}

// SetLFTags sets the LFTags field's value.
func (s *AddLFTagsToResourceInput) SetLFTags(v []*LFTagPair) *AddLFTagsToResourceInput {
	s.LFTags = v
	return s
}

// SetResource sets the Resource field's value.
func (s *AddLFTagsToResourceInput) SetResource(v *Resource) *AddLFTagsToResourceInput {
	s.Resource = v
	return s
}

type AddLFTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to tag the resource.
	Failures []*LFTagError `type:"list"`
}

// String returns the string representation
func (s AddLFTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLFTagsToResourceOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *AddLFTagsToResourceOutput) SetFailures(v []*LFTagError) *AddLFTagsToResourceOutput {
	s.Failures = v
	return s
}

// A resource to be created or added already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchGrantPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of up to 20 entries for resource permissions to be granted by batch
	// operation to the principal.
	//
	// Entries is a required field
	Entries []*BatchPermissionsRequestEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGrantPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGrantPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGrantPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGrantPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchGrantPermissionsInput) SetCatalogId(v string) *BatchGrantPermissionsInput {
	s.CatalogId = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchGrantPermissionsInput) SetEntries(v []*BatchPermissionsRequestEntry) *BatchGrantPermissionsInput {
	s.Entries = v
	return s
}

type BatchGrantPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to grant permissions to the resources.
	Failures []*BatchPermissionsFailureEntry `type:"list"`
}

// String returns the string representation
func (s BatchGrantPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGrantPermissionsOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchGrantPermissionsOutput) SetFailures(v []*BatchPermissionsFailureEntry) *BatchGrantPermissionsOutput {
	s.Failures = v
	return s
}

// A list of failures when performing a batch grant or batch revoke operation.
type BatchPermissionsFailureEntry struct {
	_ struct{} `type:"structure"`

	// An error message that applies to the failure of the entry.
	Error *ErrorDetail `type:"structure"`

	// An identifier for an entry of the batch request.
	RequestEntry *BatchPermissionsRequestEntry `type:"structure"`
}

// String returns the string representation
func (s BatchPermissionsFailureEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPermissionsFailureEntry) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BatchPermissionsFailureEntry) SetError(v *ErrorDetail) *BatchPermissionsFailureEntry {
	s.Error = v
	return s
}

// SetRequestEntry sets the RequestEntry field's value.
func (s *BatchPermissionsFailureEntry) SetRequestEntry(v *BatchPermissionsRequestEntry) *BatchPermissionsFailureEntry {
	s.RequestEntry = v
	return s
}

// A permission to a resource granted by batch operation to the principal.
type BatchPermissionsRequestEntry struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the batch permissions request entry.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The permissions to be granted.
	Permissions []*string `type:"list"`

	// Indicates if the option to pass permissions is granted.
	PermissionsWithGrantOption []*string `type:"list"`

	// The principal to be granted a permission.
	Principal *DataLakePrincipal `type:"structure"`

	// The resource to which the principal is to be granted a permission.
	Resource *Resource `type:"structure"`
}

// String returns the string representation
func (s BatchPermissionsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPermissionsRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPermissionsRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPermissionsRequestEntry"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *BatchPermissionsRequestEntry) SetId(v string) *BatchPermissionsRequestEntry {
	s.Id = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *BatchPermissionsRequestEntry) SetPermissions(v []*string) *BatchPermissionsRequestEntry {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *BatchPermissionsRequestEntry) SetPermissionsWithGrantOption(v []*string) *BatchPermissionsRequestEntry {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *BatchPermissionsRequestEntry) SetPrincipal(v *DataLakePrincipal) *BatchPermissionsRequestEntry {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *BatchPermissionsRequestEntry) SetResource(v *Resource) *BatchPermissionsRequestEntry {
	s.Resource = v
	return s
}

type BatchRevokePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of up to 20 entries for resource permissions to be revoked by batch
	// operation to the principal.
	//
	// Entries is a required field
	Entries []*BatchPermissionsRequestEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchRevokePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchRevokePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchRevokePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchRevokePermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchRevokePermissionsInput) SetCatalogId(v string) *BatchRevokePermissionsInput {
	s.CatalogId = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchRevokePermissionsInput) SetEntries(v []*BatchPermissionsRequestEntry) *BatchRevokePermissionsInput {
	s.Entries = v
	return s
}

type BatchRevokePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to revoke permissions to the resources.
	Failures []*BatchPermissionsFailureEntry `type:"list"`
}

// String returns the string representation
func (s BatchRevokePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchRevokePermissionsOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchRevokePermissionsOutput) SetFailures(v []*BatchPermissionsFailureEntry) *BatchRevokePermissionsOutput {
	s.Failures = v
	return s
}

// A structure for the catalog object.
type CatalogResource struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CatalogResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CatalogResource) GoString() string {
	return s.String()
}

// A structure containing the name of a column resource and the tags attached
// to it.
type ColumnLFTag struct {
	_ struct{} `type:"structure"`

	// The tags attached to a column resource.
	LFTags []*LFTagPair `min:"1" type:"list"`

	// The name of a column resource.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ColumnLFTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnLFTag) GoString() string {
	return s.String()
}

// SetLFTags sets the LFTags field's value.
func (s *ColumnLFTag) SetLFTags(v []*LFTagPair) *ColumnLFTag {
	s.LFTags = v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnLFTag) SetName(v string) *ColumnLFTag {
	s.Name = &v
	return s
}

// A wildcard object, consisting of an optional list of excluded column names
// or indexes.
type ColumnWildcard struct {
	_ struct{} `type:"structure"`

	// Excludes column names. Any column with this name will be excluded.
	ExcludedColumnNames []*string `type:"list"`
}

// String returns the string representation
func (s ColumnWildcard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnWildcard) GoString() string {
	return s.String()
}

// SetExcludedColumnNames sets the ExcludedColumnNames field's value.
func (s *ColumnWildcard) SetExcludedColumnNames(v []*string) *ColumnWildcard {
	s.ExcludedColumnNames = v
	return s
}

// Two processes are trying to modify a resource simultaneously.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateLFTagInput) SetCatalogId(v string) *CreateLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *CreateLFTagInput) SetTagKey(v string) *CreateLFTagInput {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *CreateLFTagInput) SetTagValues(v []*string) *CreateLFTagInput {
	s.TagValues = v
	return s
}

type CreateLFTagOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLFTagOutput) GoString() string {
	return s.String()
}

// The AWS Lake Formation principal. Supported principals are IAM users or IAM
// roles.
type DataLakePrincipal struct {
	_ struct{} `type:"structure"`

	// An identifier for the AWS Lake Formation principal.
	DataLakePrincipalIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DataLakePrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataLakePrincipal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakePrincipal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakePrincipal"}
	if s.DataLakePrincipalIdentifier != nil && len(*s.DataLakePrincipalIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataLakePrincipalIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataLakePrincipalIdentifier sets the DataLakePrincipalIdentifier field's value.
func (s *DataLakePrincipal) SetDataLakePrincipalIdentifier(v string) *DataLakePrincipal {
	s.DataLakePrincipalIdentifier = &v
	return s
}

// A structure representing a list of AWS Lake Formation principals designated
// as data lake administrators and lists of principal permission entries for
// default create database and default create table permissions.
type DataLakeSettings struct {
	_ struct{} `type:"structure"`

	// A structure representing a list of up to three principal permissions entries
	// for default create database permissions.
	CreateDatabaseDefaultPermissions []*PrincipalPermissions `type:"list"`

	// A structure representing a list of up to three principal permissions entries
	// for default create table permissions.
	CreateTableDefaultPermissions []*PrincipalPermissions `type:"list"`

	// A list of AWS Lake Formation principals. Supported principals are IAM users
	// or IAM roles.
	DataLakeAdmins []*DataLakePrincipal `type:"list"`

	// A list of the resource-owning account IDs that the caller's account can use
	// to share their user access details (user ARNs). The user ARNs can be logged
	// in the resource owner's AWS CloudTrail log.
	//
	// You may want to specify this property when you are in a high-trust boundary,
	// such as the same team or company.
	TrustedResourceOwners []*string `type:"list"`
}

// String returns the string representation
func (s DataLakeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataLakeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeSettings"}
	if s.CreateDatabaseDefaultPermissions != nil {
		for i, v := range s.CreateDatabaseDefaultPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateDatabaseDefaultPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CreateTableDefaultPermissions != nil {
		for i, v := range s.CreateTableDefaultPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateTableDefaultPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataLakeAdmins != nil {
		for i, v := range s.DataLakeAdmins {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataLakeAdmins", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateDatabaseDefaultPermissions sets the CreateDatabaseDefaultPermissions field's value.
func (s *DataLakeSettings) SetCreateDatabaseDefaultPermissions(v []*PrincipalPermissions) *DataLakeSettings {
	s.CreateDatabaseDefaultPermissions = v
	return s
}

// SetCreateTableDefaultPermissions sets the CreateTableDefaultPermissions field's value.
func (s *DataLakeSettings) SetCreateTableDefaultPermissions(v []*PrincipalPermissions) *DataLakeSettings {
	s.CreateTableDefaultPermissions = v
	return s
}

// SetDataLakeAdmins sets the DataLakeAdmins field's value.
func (s *DataLakeSettings) SetDataLakeAdmins(v []*DataLakePrincipal) *DataLakeSettings {
	s.DataLakeAdmins = v
	return s
}

// SetTrustedResourceOwners sets the TrustedResourceOwners field's value.
func (s *DataLakeSettings) SetTrustedResourceOwners(v []*string) *DataLakeSettings {
	s.TrustedResourceOwners = v
	return s
}

// A structure for a data location object where permissions are granted or revoked.
type DataLocationResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog where the location is registered with
	// AWS Lake Formation. By default, it is the account ID of the caller.
	CatalogId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) that uniquely identifies the data location
	// resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DataLocationResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataLocationResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLocationResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLocationResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DataLocationResource) SetCatalogId(v string) *DataLocationResource {
	s.CatalogId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DataLocationResource) SetResourceArn(v string) *DataLocationResource {
	s.ResourceArn = &v
	return s
}

// A structure for the database object.
type DatabaseResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, it is the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The name of the database resource. Unique to the Data Catalog.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DatabaseResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatabaseResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DatabaseResource) SetCatalogId(v string) *DatabaseResource {
	s.CatalogId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatabaseResource) SetName(v string) *DatabaseResource {
	s.Name = &v
	return s
}

type DeleteLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag to delete.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteLFTagInput) SetCatalogId(v string) *DeleteLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *DeleteLFTagInput) SetTagKey(v string) *DeleteLFTagInput {
	s.TagKey = &v
	return s
}

type DeleteLFTagOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLFTagOutput) GoString() string {
	return s.String()
}

type DeregisterResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to deregister.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeregisterResourceInput) SetResourceArn(v string) *DeregisterResourceInput {
	s.ResourceArn = &v
	return s
}

type DeregisterResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterResourceOutput) GoString() string {
	return s.String()
}

type DescribeResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourceInput) SetResourceArn(v string) *DescribeResourceInput {
	s.ResourceArn = &v
	return s
}

type DescribeResourceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about an AWS Lake Formation resource.
	ResourceInfo *ResourceInfo `type:"structure"`
}

// String returns the string representation
func (s DescribeResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceOutput) GoString() string {
	return s.String()
}

// SetResourceInfo sets the ResourceInfo field's value.
func (s *DescribeResourceOutput) SetResourceInfo(v *ResourceInfo) *DescribeResourceOutput {
	s.ResourceInfo = v
	return s
}

// A structure containing the additional details to be returned in the AdditionalDetails
// attribute of PrincipalResourcePermissions.
//
// If a catalog resource is shared through AWS Resource Access Manager (AWS
// RAM), then there will exist a corresponding RAM resource share ARN.
type DetailsMap struct {
	_ struct{} `type:"structure"`

	// A resource share ARN for a catalog resource shared through AWS Resource Access
	// Manager (AWS RAM).
	ResourceShare []*string `type:"list"`
}

// String returns the string representation
func (s DetailsMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetailsMap) GoString() string {
	return s.String()
}

// SetResourceShare sets the ResourceShare field's value.
func (s *DetailsMap) SetResourceShare(v []*string) *DetailsMap {
	s.ResourceShare = v
	return s
}

// A specified entity does not exist
type EntityNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EntityNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityNotFoundException) GoString() string {
	return s.String()
}

func newErrorEntityNotFoundException(v protocol.ResponseMetadata) error {
	return &EntityNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityNotFoundException) Code() string {
	return "EntityNotFoundException"
}

// Message returns the exception's message.
func (s *EntityNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityNotFoundException) OrigErr() error {
	return nil
}

func (s *EntityNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about an error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The code associated with this error.
	ErrorCode *string `min:"1" type:"string"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// This structure describes the filtering of columns in a table based on a filter
// condition.
type FilterCondition struct {
	_ struct{} `type:"structure"`

	// The comparison operator used in the filter condition.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The field to filter in the filter condition.
	Field *string `type:"string" enum:"FieldNameString"`

	// A string with values used in evaluating the filter condition.
	StringValueList []*string `type:"list"`
}

// String returns the string representation
func (s FilterCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterCondition) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *FilterCondition) SetComparisonOperator(v string) *FilterCondition {
	s.ComparisonOperator = &v
	return s
}

// SetField sets the Field field's value.
func (s *FilterCondition) SetField(v string) *FilterCondition {
	s.Field = &v
	return s
}

// SetStringValueList sets the StringValueList field's value.
func (s *FilterCondition) SetStringValueList(v []*string) *FilterCondition {
	s.StringValueList = v
	return s
}

type GetDataLakeSettingsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDataLakeSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataLakeSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataLakeSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataLakeSettingsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetDataLakeSettingsInput) SetCatalogId(v string) *GetDataLakeSettingsInput {
	s.CatalogId = &v
	return s
}

type GetDataLakeSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A structure representing a list of AWS Lake Formation principals designated
	// as data lake administrators.
	DataLakeSettings *DataLakeSettings `type:"structure"`
}

// String returns the string representation
func (s GetDataLakeSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataLakeSettingsOutput) GoString() string {
	return s.String()
}

// SetDataLakeSettings sets the DataLakeSettings field's value.
func (s *GetDataLakeSettingsOutput) SetDataLakeSettings(v *DataLakeSettings) *GetDataLakeSettingsOutput {
	s.DataLakeSettings = v
	return s
}

type GetEffectivePermissionsForPathInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the resource for which you want to get
	// permissions.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetEffectivePermissionsForPathInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEffectivePermissionsForPathInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEffectivePermissionsForPathInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEffectivePermissionsForPathInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetEffectivePermissionsForPathInput) SetCatalogId(v string) *GetEffectivePermissionsForPathInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEffectivePermissionsForPathInput) SetMaxResults(v int64) *GetEffectivePermissionsForPathInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEffectivePermissionsForPathInput) SetNextToken(v string) *GetEffectivePermissionsForPathInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetEffectivePermissionsForPathInput) SetResourceArn(v string) *GetEffectivePermissionsForPathInput {
	s.ResourceArn = &v
	return s
}

type GetEffectivePermissionsForPathOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// A list of the permissions for the specified table or database resource located
	// at the path in Amazon S3.
	Permissions []*PrincipalResourcePermissions `type:"list"`
}

// String returns the string representation
func (s GetEffectivePermissionsForPathOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEffectivePermissionsForPathOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetEffectivePermissionsForPathOutput) SetNextToken(v string) *GetEffectivePermissionsForPathOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GetEffectivePermissionsForPathOutput) SetPermissions(v []*PrincipalResourcePermissions) *GetEffectivePermissionsForPathOutput {
	s.Permissions = v
	return s
}

type GetLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetLFTagInput) SetCatalogId(v string) *GetLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetLFTagInput) SetTagKey(v string) *GetLFTagInput {
	s.TagKey = &v
	return s
}

type GetLFTagOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag.
	TagKey *string `min:"1" type:"string"`

	// A list of possible values an attribute can take.
	TagValues []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GetLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLFTagOutput) GoString() string {
	return s.String()
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetLFTagOutput) SetCatalogId(v string) *GetLFTagOutput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetLFTagOutput) SetTagKey(v string) *GetLFTagOutput {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *GetLFTagOutput) SetTagValues(v []*string) *GetLFTagOutput {
	s.TagValues = v
	return s
}

type GetResourceLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The resource for which you want to return tags.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`

	// Indicates whether to show the assigned tags.
	ShowAssignedLFTags *bool `type:"boolean"`
}

// String returns the string representation
func (s GetResourceLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetResourceLFTagsInput) SetCatalogId(v string) *GetResourceLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *GetResourceLFTagsInput) SetResource(v *Resource) *GetResourceLFTagsInput {
	s.Resource = v
	return s
}

// SetShowAssignedLFTags sets the ShowAssignedLFTags field's value.
func (s *GetResourceLFTagsInput) SetShowAssignedLFTags(v bool) *GetResourceLFTagsInput {
	s.ShowAssignedLFTags = &v
	return s
}

type GetResourceLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags applied to a database resource.
	LFTagOnDatabase []*LFTagPair `min:"1" type:"list"`

	// A list of tags applied to a column resource.
	LFTagsOnColumns []*ColumnLFTag `type:"list"`

	// A list of tags applied to a table resource.
	LFTagsOnTable []*LFTagPair `min:"1" type:"list"`
}

// String returns the string representation
func (s GetResourceLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceLFTagsOutput) GoString() string {
	return s.String()
}

// SetLFTagOnDatabase sets the LFTagOnDatabase field's value.
func (s *GetResourceLFTagsOutput) SetLFTagOnDatabase(v []*LFTagPair) *GetResourceLFTagsOutput {
	s.LFTagOnDatabase = v
	return s
}

// SetLFTagsOnColumns sets the LFTagsOnColumns field's value.
func (s *GetResourceLFTagsOutput) SetLFTagsOnColumns(v []*ColumnLFTag) *GetResourceLFTagsOutput {
	s.LFTagsOnColumns = v
	return s
}

// SetLFTagsOnTable sets the LFTagsOnTable field's value.
func (s *GetResourceLFTagsOutput) SetLFTagsOnTable(v []*LFTagPair) *GetResourceLFTagsOutput {
	s.LFTagsOnTable = v
	return s
}

// An encryption operation failed.
type GlueEncryptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s GlueEncryptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlueEncryptionException) GoString() string {
	return s.String()
}

func newErrorGlueEncryptionException(v protocol.ResponseMetadata) error {
	return &GlueEncryptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GlueEncryptionException) Code() string {
	return "GlueEncryptionException"
}

// Message returns the exception's message.
func (s *GlueEncryptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GlueEncryptionException) OrigErr() error {
	return nil
}

func (s *GlueEncryptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GlueEncryptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GlueEncryptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GrantPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The permissions granted to the principal on the resource. AWS Lake Formation
	// defines privileges to grant and revoke access to metadata in the Data Catalog
	// and data organized in underlying data storage such as Amazon S3. AWS Lake
	// Formation requires that each principal be authorized to perform a specific
	// task on AWS Lake Formation resources.
	//
	// Permissions is a required field
	Permissions []*string `type:"list" required:"true"`

	// Indicates a list of the granted permissions that the principal may pass to
	// other users. These permissions may only be a subset of the permissions granted
	// in the Privileges.
	PermissionsWithGrantOption []*string `type:"list"`

	// The principal to be granted the permissions on the resource. Supported principals
	// are IAM users or IAM roles, and they are defined by their principal type
	// and their ARN.
	//
	// Note that if you define a resource with a particular ARN, then later delete,
	// and recreate a resource with that same ARN, the resource maintains the permissions
	// already granted.
	//
	// Principal is a required field
	Principal *DataLakePrincipal `type:"structure" required:"true"`

	// The resource to which permissions are to be granted. Resources in AWS Lake
	// Formation are the Data Catalog, databases, and tables.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation
func (s GrantPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GrantPermissionsInput) SetCatalogId(v string) *GrantPermissionsInput {
	s.CatalogId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GrantPermissionsInput) SetPermissions(v []*string) *GrantPermissionsInput {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *GrantPermissionsInput) SetPermissionsWithGrantOption(v []*string) *GrantPermissionsInput {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GrantPermissionsInput) SetPrincipal(v *DataLakePrincipal) *GrantPermissionsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *GrantPermissionsInput) SetResource(v *Resource) *GrantPermissionsInput {
	s.Resource = v
	return s
}

type GrantPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GrantPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantPermissionsOutput) GoString() string {
	return s.String()
}

// An internal service error occurred.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input provided was not valid.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that allows an admin to grant user permissions on certain conditions.
// For example, granting a role access to all columns not tagged 'PII' of tables
// tagged 'Prod'.
type LFTag struct {
	_ struct{} `type:"structure"`

	// The key-name for the tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s LFTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LFTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTag"}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagKey sets the TagKey field's value.
func (s *LFTag) SetTagKey(v string) *LFTag {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *LFTag) SetTagValues(v []*string) *LFTag {
	s.TagValues = v
	return s
}

// A structure containing an error related to a TagResource or UnTagResource
// operation.
type LFTagError struct {
	_ struct{} `type:"structure"`

	// An error that occurred with the attachment or detachment of the tag.
	Error *ErrorDetail `type:"structure"`

	// The key-name of the tag.
	LFTag *LFTagPair `type:"structure"`
}

// String returns the string representation
func (s LFTagError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LFTagError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *LFTagError) SetError(v *ErrorDetail) *LFTagError {
	s.Error = v
	return s
}

// SetLFTag sets the LFTag field's value.
func (s *LFTagError) SetLFTag(v *LFTagPair) *LFTagError {
	s.LFTag = v
	return s
}

// A structure containing a tag key and values for a resource.
type LFTagKeyResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s LFTagKeyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LFTagKeyResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTagKeyResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTagKeyResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *LFTagKeyResource) SetCatalogId(v string) *LFTagKeyResource {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *LFTagKeyResource) SetTagKey(v string) *LFTagKeyResource {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *LFTagKeyResource) SetTagValues(v []*string) *LFTagKeyResource {
	s.TagValues = v
	return s
}

// A structure containing a tag key-value pair.
type LFTagPair struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s LFTagPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LFTagPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTagPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTagPair"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *LFTagPair) SetCatalogId(v string) *LFTagPair {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *LFTagPair) SetTagKey(v string) *LFTagPair {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *LFTagPair) SetTagValues(v []*string) *LFTagPair {
	s.TagValues = v
	return s
}

// A structure containing a list of tag conditions that apply to a resource's
// tag policy.
type LFTagPolicyResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of tag conditions that apply to the resource's tag policy.
	//
	// Expression is a required field
	Expression []*LFTag `min:"1" type:"list" required:"true"`

	// The resource type for which the tag policy applies.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s LFTagPolicyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LFTagPolicyResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTagPolicyResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTagPolicyResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Expression != nil {
		for i, v := range s.Expression {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Expression", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *LFTagPolicyResource) SetCatalogId(v string) *LFTagPolicyResource {
	s.CatalogId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *LFTagPolicyResource) SetExpression(v []*LFTag) *LFTagPolicyResource {
	s.Expression = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LFTagPolicyResource) SetResourceType(v string) *LFTagPolicyResource {
	s.ResourceType = &v
	return s
}

type ListLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// If resource share type is ALL, returns both in-account tags and shared tags
	// that the requester has permission to view. If resource share type is FOREIGN,
	// returns all share tags that the requester can view. If no resource share
	// type is passed, lists tags in the given catalog ID that the requester has
	// permission to view.
	ResourceShareType *string `type:"string" enum:"ResourceShareType"`
}

// String returns the string representation
func (s ListLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ListLFTagsInput) SetCatalogId(v string) *ListLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLFTagsInput) SetMaxResults(v int64) *ListLFTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLFTagsInput) SetNextToken(v string) *ListLFTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceShareType sets the ResourceShareType field's value.
func (s *ListLFTagsInput) SetResourceShareType(v string) *ListLFTagsInput {
	s.ResourceShareType = &v
	return s
}

type ListLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags that the requested has permission to view.
	LFTags []*LFTagPair `min:"1" type:"list"`

	// A continuation token, present if the current list segment is not the last.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLFTagsOutput) GoString() string {
	return s.String()
}

// SetLFTags sets the LFTags field's value.
func (s *ListLFTagsOutput) SetLFTags(v []*LFTagPair) *ListLFTagsOutput {
	s.LFTags = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLFTagsOutput) SetNextToken(v string) *ListLFTagsOutput {
	s.NextToken = &v
	return s
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// Specifies a principal to filter the permissions returned.
	Principal *DataLakePrincipal `type:"structure"`

	// A resource where you will get a list of the principal permissions.
	//
	// This operation does not support getting privileges on a table with columns.
	// Instead, call this operation on the table, and the operation returns the
	// table and the table w columns.
	Resource *Resource `type:"structure"`

	// Specifies a resource type to filter the permissions returned.
	ResourceType *string `type:"string" enum:"DataLakeResourceType"`
}

// String returns the string representation
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ListPermissionsInput) SetCatalogId(v string) *ListPermissionsInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListPermissionsInput) SetPrincipal(v *DataLakePrincipal) *ListPermissionsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *ListPermissionsInput) SetResource(v *Resource) *ListPermissionsInput {
	s.Resource = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPermissionsInput) SetResourceType(v string) *ListPermissionsInput {
	s.ResourceType = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// A list of principals and their permissions on the resource for the specified
	// principal and resource types.
	PrincipalResourcePermissions []*PrincipalResourcePermissions `type:"list"`
}

// String returns the string representation
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPrincipalResourcePermissions sets the PrincipalResourcePermissions field's value.
func (s *ListPermissionsOutput) SetPrincipalResourcePermissions(v []*PrincipalResourcePermissions) *ListPermissionsOutput {
	s.PrincipalResourcePermissions = v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// Any applicable row-level and/or column-level filtering conditions for the
	// resources.
	FilterConditionList []*FilterCondition `min:"1" type:"list"`

	// The maximum number of resource results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve these resources.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.FilterConditionList != nil && len(s.FilterConditionList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterConditionList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterConditionList sets the FilterConditionList field's value.
func (s *ListResourcesInput) SetFilterConditionList(v []*FilterCondition) *ListResourcesInput {
	s.FilterConditionList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is not the first call to retrieve these resources.
	NextToken *string `type:"string"`

	// A summary of the data lake resources.
	ResourceInfoList []*ResourceInfo `type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceInfoList sets the ResourceInfoList field's value.
func (s *ListResourcesOutput) SetResourceInfoList(v []*ResourceInfo) *ListResourcesOutput {
	s.ResourceInfoList = v
	return s
}

// The operation timed out.
type OperationTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OperationTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationTimeoutException) GoString() string {
	return s.String()
}

func newErrorOperationTimeoutException(v protocol.ResponseMetadata) error {
	return &OperationTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationTimeoutException) Code() string {
	return "OperationTimeoutException"
}

// Message returns the exception's message.
func (s *OperationTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationTimeoutException) OrigErr() error {
	return nil
}

func (s *OperationTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Permissions granted to a principal.
type PrincipalPermissions struct {
	_ struct{} `type:"structure"`

	// The permissions that are granted to the principal.
	Permissions []*string `type:"list"`

	// The principal who is granted permissions.
	Principal *DataLakePrincipal `type:"structure"`
}

// String returns the string representation
func (s PrincipalPermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrincipalPermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrincipalPermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrincipalPermissions"}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissions sets the Permissions field's value.
func (s *PrincipalPermissions) SetPermissions(v []*string) *PrincipalPermissions {
	s.Permissions = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PrincipalPermissions) SetPrincipal(v *DataLakePrincipal) *PrincipalPermissions {
	s.Principal = v
	return s
}

// The permissions granted or revoked on a resource.
type PrincipalResourcePermissions struct {
	_ struct{} `type:"structure"`

	// This attribute can be used to return any additional details of PrincipalResourcePermissions.
	// Currently returns only as a RAM resource share ARN.
	AdditionalDetails *DetailsMap `type:"structure"`

	// The permissions to be granted or revoked on the resource.
	Permissions []*string `type:"list"`

	// Indicates whether to grant the ability to grant permissions (as a subset
	// of permissions granted).
	PermissionsWithGrantOption []*string `type:"list"`

	// The Data Lake principal to be granted or revoked permissions.
	Principal *DataLakePrincipal `type:"structure"`

	// The resource where permissions are to be granted or revoked.
	Resource *Resource `type:"structure"`
}

// String returns the string representation
func (s PrincipalResourcePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrincipalResourcePermissions) GoString() string {
	return s.String()
}

// SetAdditionalDetails sets the AdditionalDetails field's value.
func (s *PrincipalResourcePermissions) SetAdditionalDetails(v *DetailsMap) *PrincipalResourcePermissions {
	s.AdditionalDetails = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *PrincipalResourcePermissions) SetPermissions(v []*string) *PrincipalResourcePermissions {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *PrincipalResourcePermissions) SetPermissionsWithGrantOption(v []*string) *PrincipalResourcePermissions {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PrincipalResourcePermissions) SetPrincipal(v *DataLakePrincipal) *PrincipalResourcePermissions {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *PrincipalResourcePermissions) SetResource(v *Resource) *PrincipalResourcePermissions {
	s.Resource = v
	return s
}

type PutDataLakeSettingsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A structure representing a list of AWS Lake Formation principals designated
	// as data lake administrators.
	//
	// DataLakeSettings is a required field
	DataLakeSettings *DataLakeSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutDataLakeSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDataLakeSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDataLakeSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDataLakeSettingsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DataLakeSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLakeSettings"))
	}
	if s.DataLakeSettings != nil {
		if err := s.DataLakeSettings.Validate(); err != nil {
			invalidParams.AddNested("DataLakeSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *PutDataLakeSettingsInput) SetCatalogId(v string) *PutDataLakeSettingsInput {
	s.CatalogId = &v
	return s
}

// SetDataLakeSettings sets the DataLakeSettings field's value.
func (s *PutDataLakeSettingsInput) SetDataLakeSettings(v *DataLakeSettings) *PutDataLakeSettingsInput {
	s.DataLakeSettings = v
	return s
}

type PutDataLakeSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDataLakeSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDataLakeSettingsOutput) GoString() string {
	return s.String()
}

type RegisterResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to register.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The identifier for the role that registers the resource.
	RoleArn *string `type:"string"`

	// Designates an AWS Identity and Access Management (IAM) service-linked role
	// by registering this role with the Data Catalog. A service-linked role is
	// a unique type of IAM role that is linked directly to Lake Formation.
	//
	// For more information, see Using Service-Linked Roles for Lake Formation (https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html).
	UseServiceLinkedRole *bool `type:"boolean"`
}

// String returns the string representation
func (s RegisterResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RegisterResourceInput) SetResourceArn(v string) *RegisterResourceInput {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RegisterResourceInput) SetRoleArn(v string) *RegisterResourceInput {
	s.RoleArn = &v
	return s
}

// SetUseServiceLinkedRole sets the UseServiceLinkedRole field's value.
func (s *RegisterResourceInput) SetUseServiceLinkedRole(v bool) *RegisterResourceInput {
	s.UseServiceLinkedRole = &v
	return s
}

type RegisterResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterResourceOutput) GoString() string {
	return s.String()
}

type RemoveLFTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The tags to be removed from the resource.
	//
	// LFTags is a required field
	LFTags []*LFTagPair `min:"1" type:"list" required:"true"`

	// The resource where you want to remove a tag.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation
func (s RemoveLFTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveLFTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveLFTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveLFTagsFromResourceInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.LFTags == nil {
		invalidParams.Add(request.NewErrParamRequired("LFTags"))
	}
	if s.LFTags != nil && len(s.LFTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LFTags", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.LFTags != nil {
		for i, v := range s.LFTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LFTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *RemoveLFTagsFromResourceInput) SetCatalogId(v string) *RemoveLFTagsFromResourceInput {
	s.CatalogId = &v
	return s
}

// SetLFTags sets the LFTags field's value.
func (s *RemoveLFTagsFromResourceInput) SetLFTags(v []*LFTagPair) *RemoveLFTagsFromResourceInput {
	s.LFTags = v
	return s
}

// SetResource sets the Resource field's value.
func (s *RemoveLFTagsFromResourceInput) SetResource(v *Resource) *RemoveLFTagsFromResourceInput {
	s.Resource = v
	return s
}

type RemoveLFTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to untag a resource.
	Failures []*LFTagError `type:"list"`
}

// String returns the string representation
func (s RemoveLFTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveLFTagsFromResourceOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *RemoveLFTagsFromResourceOutput) SetFailures(v []*LFTagError) *RemoveLFTagsFromResourceOutput {
	s.Failures = v
	return s
}

// A structure for the resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	Catalog *CatalogResource `type:"structure"`

	// The location of an Amazon S3 path where permissions are granted or revoked.
	DataLocation *DataLocationResource `type:"structure"`

	// The database for the resource. Unique to the Data Catalog. A database is
	// a set of associated table definitions organized into a logical group. You
	// can Grant and Revoke database permissions to a principal.
	Database *DatabaseResource `type:"structure"`

	// The tag key and values attached to a resource.
	LFTag *LFTagKeyResource `type:"structure"`

	// A list of tag conditions that define a resource's tag policy.
	LFTagPolicy *LFTagPolicyResource `type:"structure"`

	// The table for the resource. A table is a metadata definition that represents
	// your data. You can Grant and Revoke table privileges to a principal.
	Table *TableResource `type:"structure"`

	// The table with columns for the resource. A principal with permissions to
	// this resource can select metadata from the columns of a table in the Data
	// Catalog and the underlying data in Amazon S3.
	TableWithColumns *TableWithColumnsResource `type:"structure"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.DataLocation != nil {
		if err := s.DataLocation.Validate(); err != nil {
			invalidParams.AddNested("DataLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.Database != nil {
		if err := s.Database.Validate(); err != nil {
			invalidParams.AddNested("Database", err.(request.ErrInvalidParams))
		}
	}
	if s.LFTag != nil {
		if err := s.LFTag.Validate(); err != nil {
			invalidParams.AddNested("LFTag", err.(request.ErrInvalidParams))
		}
	}
	if s.LFTagPolicy != nil {
		if err := s.LFTagPolicy.Validate(); err != nil {
			invalidParams.AddNested("LFTagPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.Table != nil {
		if err := s.Table.Validate(); err != nil {
			invalidParams.AddNested("Table", err.(request.ErrInvalidParams))
		}
	}
	if s.TableWithColumns != nil {
		if err := s.TableWithColumns.Validate(); err != nil {
			invalidParams.AddNested("TableWithColumns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *Resource) SetCatalog(v *CatalogResource) *Resource {
	s.Catalog = v
	return s
}

// SetDataLocation sets the DataLocation field's value.
func (s *Resource) SetDataLocation(v *DataLocationResource) *Resource {
	s.DataLocation = v
	return s
}

// SetDatabase sets the Database field's value.
func (s *Resource) SetDatabase(v *DatabaseResource) *Resource {
	s.Database = v
	return s
}

// SetLFTag sets the LFTag field's value.
func (s *Resource) SetLFTag(v *LFTagKeyResource) *Resource {
	s.LFTag = v
	return s
}

// SetLFTagPolicy sets the LFTagPolicy field's value.
func (s *Resource) SetLFTagPolicy(v *LFTagPolicyResource) *Resource {
	s.LFTagPolicy = v
	return s
}

// SetTable sets the Table field's value.
func (s *Resource) SetTable(v *TableResource) *Resource {
	s.Table = v
	return s
}

// SetTableWithColumns sets the TableWithColumns field's value.
func (s *Resource) SetTableWithColumns(v *TableWithColumnsResource) *Resource {
	s.TableWithColumns = v
	return s
}

// A structure containing information about an AWS Lake Formation resource.
type ResourceInfo struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was last modified.
	LastModified *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// The IAM role that registered a resource.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s ResourceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInfo) GoString() string {
	return s.String()
}

// SetLastModified sets the LastModified field's value.
func (s *ResourceInfo) SetLastModified(v time.Time) *ResourceInfo {
	s.LastModified = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceInfo) SetResourceArn(v string) *ResourceInfo {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ResourceInfo) SetRoleArn(v string) *ResourceInfo {
	s.RoleArn = &v
	return s
}

// A resource numerical limit was exceeded.
type ResourceNumberLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNumberLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNumberLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceNumberLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceNumberLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNumberLimitExceededException) Code() string {
	return "ResourceNumberLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceNumberLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNumberLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceNumberLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNumberLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNumberLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RevokePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The permissions revoked to the principal on the resource. For information
	// about permissions, see Security and Access Control to Metadata and Data (https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
	//
	// Permissions is a required field
	Permissions []*string `type:"list" required:"true"`

	// Indicates a list of permissions for which to revoke the grant option allowing
	// the principal to pass permissions to other principals.
	PermissionsWithGrantOption []*string `type:"list"`

	// The principal to be revoked permissions on the resource.
	//
	// Principal is a required field
	Principal *DataLakePrincipal `type:"structure" required:"true"`

	// The resource to which permissions are to be revoked.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation
func (s RevokePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokePermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *RevokePermissionsInput) SetCatalogId(v string) *RevokePermissionsInput {
	s.CatalogId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *RevokePermissionsInput) SetPermissions(v []*string) *RevokePermissionsInput {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *RevokePermissionsInput) SetPermissionsWithGrantOption(v []*string) *RevokePermissionsInput {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *RevokePermissionsInput) SetPrincipal(v *DataLakePrincipal) *RevokePermissionsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *RevokePermissionsInput) SetResource(v *Resource) *RevokePermissionsInput {
	s.Resource = v
	return s
}

type RevokePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokePermissionsOutput) GoString() string {
	return s.String()
}

type SearchDatabasesByLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of conditions (LFTag structures) to search for in database resources.
	//
	// Expression is a required field
	Expression []*LFTag `min:"1" type:"list" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SearchDatabasesByLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDatabasesByLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDatabasesByLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchDatabasesByLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Expression != nil {
		for i, v := range s.Expression {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Expression", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *SearchDatabasesByLFTagsInput) SetCatalogId(v string) *SearchDatabasesByLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *SearchDatabasesByLFTagsInput) SetExpression(v []*LFTag) *SearchDatabasesByLFTagsInput {
	s.Expression = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchDatabasesByLFTagsInput) SetMaxResults(v int64) *SearchDatabasesByLFTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDatabasesByLFTagsInput) SetNextToken(v string) *SearchDatabasesByLFTagsInput {
	s.NextToken = &v
	return s
}

type SearchDatabasesByLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of databases that meet the tag conditions.
	DatabaseList []*TaggedDatabase `type:"list"`

	// A continuation token, present if the current list segment is not the last.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SearchDatabasesByLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDatabasesByLFTagsOutput) GoString() string {
	return s.String()
}

// SetDatabaseList sets the DatabaseList field's value.
func (s *SearchDatabasesByLFTagsOutput) SetDatabaseList(v []*TaggedDatabase) *SearchDatabasesByLFTagsOutput {
	s.DatabaseList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDatabasesByLFTagsOutput) SetNextToken(v string) *SearchDatabasesByLFTagsOutput {
	s.NextToken = &v
	return s
}

type SearchTablesByLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of conditions (LFTag structures) to search for in table resources.
	//
	// Expression is a required field
	Expression []*LFTag `min:"1" type:"list" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SearchTablesByLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchTablesByLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchTablesByLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchTablesByLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Expression != nil {
		for i, v := range s.Expression {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Expression", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *SearchTablesByLFTagsInput) SetCatalogId(v string) *SearchTablesByLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *SearchTablesByLFTagsInput) SetExpression(v []*LFTag) *SearchTablesByLFTagsInput {
	s.Expression = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchTablesByLFTagsInput) SetMaxResults(v int64) *SearchTablesByLFTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchTablesByLFTagsInput) SetNextToken(v string) *SearchTablesByLFTagsInput {
	s.NextToken = &v
	return s
}

type SearchTablesByLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, present if the current list segment is not the last.
	NextToken *string `type:"string"`

	// A list of tables that meet the tag conditions.
	TableList []*TaggedTable `type:"list"`
}

// String returns the string representation
func (s SearchTablesByLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchTablesByLFTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchTablesByLFTagsOutput) SetNextToken(v string) *SearchTablesByLFTagsOutput {
	s.NextToken = &v
	return s
}

// SetTableList sets the TableList field's value.
func (s *SearchTablesByLFTagsOutput) SetTableList(v []*TaggedTable) *SearchTablesByLFTagsOutput {
	s.TableList = v
	return s
}

// A structure for the table object. A table is a metadata definition that represents
// your data. You can Grant and Revoke table privileges to a principal.
type TableResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, it is the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The name of the database for the table. Unique to a Data Catalog. A database
	// is a set of associated table definitions organized into a logical group.
	// You can Grant and Revoke database privileges to a principal.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table.
	Name *string `min:"1" type:"string"`

	// A wildcard object representing every table under a database.
	//
	// At least one of TableResource$Name or TableResource$TableWildcard is required.
	TableWildcard *TableWildcard `type:"structure"`
}

// String returns the string representation
func (s TableResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *TableResource) SetCatalogId(v string) *TableResource {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *TableResource) SetDatabaseName(v string) *TableResource {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *TableResource) SetName(v string) *TableResource {
	s.Name = &v
	return s
}

// SetTableWildcard sets the TableWildcard field's value.
func (s *TableResource) SetTableWildcard(v *TableWildcard) *TableResource {
	s.TableWildcard = v
	return s
}

// A wildcard object representing every table under a database.
type TableWildcard struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TableWildcard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableWildcard) GoString() string {
	return s.String()
}

// A structure for a table with columns object. This object is only used when
// granting a SELECT permission.
//
// This object must take a value for at least one of ColumnsNames, ColumnsIndexes,
// or ColumnsWildcard.
type TableWithColumnsResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, it is the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The list of column names for the table. At least one of ColumnNames or ColumnWildcard
	// is required.
	ColumnNames []*string `type:"list"`

	// A wildcard specified by a ColumnWildcard object. At least one of ColumnNames
	// or ColumnWildcard is required.
	ColumnWildcard *ColumnWildcard `type:"structure"`

	// The name of the database for the table with columns resource. Unique to the
	// Data Catalog. A database is a set of associated table definitions organized
	// into a logical group. You can Grant and Revoke database privileges to a principal.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table resource. A table is a metadata definition that represents
	// your data. You can Grant and Revoke table privileges to a principal.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TableWithColumnsResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableWithColumnsResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableWithColumnsResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableWithColumnsResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *TableWithColumnsResource) SetCatalogId(v string) *TableWithColumnsResource {
	s.CatalogId = &v
	return s
}

// SetColumnNames sets the ColumnNames field's value.
func (s *TableWithColumnsResource) SetColumnNames(v []*string) *TableWithColumnsResource {
	s.ColumnNames = v
	return s
}

// SetColumnWildcard sets the ColumnWildcard field's value.
func (s *TableWithColumnsResource) SetColumnWildcard(v *ColumnWildcard) *TableWithColumnsResource {
	s.ColumnWildcard = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *TableWithColumnsResource) SetDatabaseName(v string) *TableWithColumnsResource {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *TableWithColumnsResource) SetName(v string) *TableWithColumnsResource {
	s.Name = &v
	return s
}

// A structure describing a database resource with tags.
type TaggedDatabase struct {
	_ struct{} `type:"structure"`

	// A database that has tags attached to it.
	Database *DatabaseResource `type:"structure"`

	// A list of tags attached to the database.
	LFTags []*LFTagPair `min:"1" type:"list"`
}

// String returns the string representation
func (s TaggedDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaggedDatabase) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *TaggedDatabase) SetDatabase(v *DatabaseResource) *TaggedDatabase {
	s.Database = v
	return s
}

// SetLFTags sets the LFTags field's value.
func (s *TaggedDatabase) SetLFTags(v []*LFTagPair) *TaggedDatabase {
	s.LFTags = v
	return s
}

// A structure describing a table resource with tags.
type TaggedTable struct {
	_ struct{} `type:"structure"`

	// A list of tags attached to the database where the table resides.
	LFTagOnDatabase []*LFTagPair `min:"1" type:"list"`

	// A list of tags attached to columns in the table.
	LFTagsOnColumns []*ColumnLFTag `type:"list"`

	// A list of tags attached to the table.
	LFTagsOnTable []*LFTagPair `min:"1" type:"list"`

	// A table that has tags attached to it.
	Table *TableResource `type:"structure"`
}

// String returns the string representation
func (s TaggedTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaggedTable) GoString() string {
	return s.String()
}

// SetLFTagOnDatabase sets the LFTagOnDatabase field's value.
func (s *TaggedTable) SetLFTagOnDatabase(v []*LFTagPair) *TaggedTable {
	s.LFTagOnDatabase = v
	return s
}

// SetLFTagsOnColumns sets the LFTagsOnColumns field's value.
func (s *TaggedTable) SetLFTagsOnColumns(v []*ColumnLFTag) *TaggedTable {
	s.LFTagsOnColumns = v
	return s
}

// SetLFTagsOnTable sets the LFTagsOnTable field's value.
func (s *TaggedTable) SetLFTagsOnTable(v []*LFTagPair) *TaggedTable {
	s.LFTagsOnTable = v
	return s
}

// SetTable sets the Table field's value.
func (s *TaggedTable) SetTable(v *TableResource) *TaggedTable {
	s.Table = v
	return s
}

type UpdateLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the tag for which to add or delete values.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of tag values to add from the tag.
	TagValuesToAdd []*string `min:"1" type:"list"`

	// A list of tag values to delete from the tag.
	TagValuesToDelete []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValuesToAdd != nil && len(s.TagValuesToAdd) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValuesToAdd", 1))
	}
	if s.TagValuesToDelete != nil && len(s.TagValuesToDelete) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValuesToDelete", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateLFTagInput) SetCatalogId(v string) *UpdateLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *UpdateLFTagInput) SetTagKey(v string) *UpdateLFTagInput {
	s.TagKey = &v
	return s
}

// SetTagValuesToAdd sets the TagValuesToAdd field's value.
func (s *UpdateLFTagInput) SetTagValuesToAdd(v []*string) *UpdateLFTagInput {
	s.TagValuesToAdd = v
	return s
}

// SetTagValuesToDelete sets the TagValuesToDelete field's value.
func (s *UpdateLFTagInput) SetTagValuesToDelete(v []*string) *UpdateLFTagInput {
	s.TagValuesToDelete = v
	return s
}

type UpdateLFTagOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLFTagOutput) GoString() string {
	return s.String()
}

type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The new role to use for the given resource registered in AWS Lake Formation.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateResourceInput) SetResourceArn(v string) *UpdateResourceInput {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateResourceInput) SetRoleArn(v string) *UpdateResourceInput {
	s.RoleArn = &v
	return s
}

type UpdateResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceOutput) GoString() string {
	return s.String()
}

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"

	// ComparisonOperatorContains is a ComparisonOperator enum value
	ComparisonOperatorContains = "CONTAINS"

	// ComparisonOperatorNotContains is a ComparisonOperator enum value
	ComparisonOperatorNotContains = "NOT_CONTAINS"

	// ComparisonOperatorBeginsWith is a ComparisonOperator enum value
	ComparisonOperatorBeginsWith = "BEGINS_WITH"

	// ComparisonOperatorIn is a ComparisonOperator enum value
	ComparisonOperatorIn = "IN"

	// ComparisonOperatorBetween is a ComparisonOperator enum value
	ComparisonOperatorBetween = "BETWEEN"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorEq,
		ComparisonOperatorNe,
		ComparisonOperatorLe,
		ComparisonOperatorLt,
		ComparisonOperatorGe,
		ComparisonOperatorGt,
		ComparisonOperatorContains,
		ComparisonOperatorNotContains,
		ComparisonOperatorBeginsWith,
		ComparisonOperatorIn,
		ComparisonOperatorBetween,
	}
}

const (
	// DataLakeResourceTypeCatalog is a DataLakeResourceType enum value
	DataLakeResourceTypeCatalog = "CATALOG"

	// DataLakeResourceTypeDatabase is a DataLakeResourceType enum value
	DataLakeResourceTypeDatabase = "DATABASE"

	// DataLakeResourceTypeTable is a DataLakeResourceType enum value
	DataLakeResourceTypeTable = "TABLE"

	// DataLakeResourceTypeDataLocation is a DataLakeResourceType enum value
	DataLakeResourceTypeDataLocation = "DATA_LOCATION"

	// DataLakeResourceTypeLfTag is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTag = "LF_TAG"

	// DataLakeResourceTypeLfTagPolicy is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTagPolicy = "LF_TAG_POLICY"

	// DataLakeResourceTypeLfTagPolicyDatabase is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTagPolicyDatabase = "LF_TAG_POLICY_DATABASE"

	// DataLakeResourceTypeLfTagPolicyTable is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTagPolicyTable = "LF_TAG_POLICY_TABLE"
)

// DataLakeResourceType_Values returns all elements of the DataLakeResourceType enum
func DataLakeResourceType_Values() []string {
	return []string{
		DataLakeResourceTypeCatalog,
		DataLakeResourceTypeDatabase,
		DataLakeResourceTypeTable,
		DataLakeResourceTypeDataLocation,
		DataLakeResourceTypeLfTag,
		DataLakeResourceTypeLfTagPolicy,
		DataLakeResourceTypeLfTagPolicyDatabase,
		DataLakeResourceTypeLfTagPolicyTable,
	}
}

const (
	// FieldNameStringResourceArn is a FieldNameString enum value
	FieldNameStringResourceArn = "RESOURCE_ARN"

	// FieldNameStringRoleArn is a FieldNameString enum value
	FieldNameStringRoleArn = "ROLE_ARN"

	// FieldNameStringLastModified is a FieldNameString enum value
	FieldNameStringLastModified = "LAST_MODIFIED"
)

// FieldNameString_Values returns all elements of the FieldNameString enum
func FieldNameString_Values() []string {
	return []string{
		FieldNameStringResourceArn,
		FieldNameStringRoleArn,
		FieldNameStringLastModified,
	}
}

const (
	// PermissionAll is a Permission enum value
	PermissionAll = "ALL"

	// PermissionSelect is a Permission enum value
	PermissionSelect = "SELECT"

	// PermissionAlter is a Permission enum value
	PermissionAlter = "ALTER"

	// PermissionDrop is a Permission enum value
	PermissionDrop = "DROP"

	// PermissionDelete is a Permission enum value
	PermissionDelete = "DELETE"

	// PermissionInsert is a Permission enum value
	PermissionInsert = "INSERT"

	// PermissionDescribe is a Permission enum value
	PermissionDescribe = "DESCRIBE"

	// PermissionCreateDatabase is a Permission enum value
	PermissionCreateDatabase = "CREATE_DATABASE"

	// PermissionCreateTable is a Permission enum value
	PermissionCreateTable = "CREATE_TABLE"

	// PermissionDataLocationAccess is a Permission enum value
	PermissionDataLocationAccess = "DATA_LOCATION_ACCESS"

	// PermissionCreateTag is a Permission enum value
	PermissionCreateTag = "CREATE_TAG"

	// PermissionAlterTag is a Permission enum value
	PermissionAlterTag = "ALTER_TAG"

	// PermissionDeleteTag is a Permission enum value
	PermissionDeleteTag = "DELETE_TAG"

	// PermissionDescribeTag is a Permission enum value
	PermissionDescribeTag = "DESCRIBE_TAG"

	// PermissionAssociateTag is a Permission enum value
	PermissionAssociateTag = "ASSOCIATE_TAG"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionAll,
		PermissionSelect,
		PermissionAlter,
		PermissionDrop,
		PermissionDelete,
		PermissionInsert,
		PermissionDescribe,
		PermissionCreateDatabase,
		PermissionCreateTable,
		PermissionDataLocationAccess,
		PermissionCreateTag,
		PermissionAlterTag,
		PermissionDeleteTag,
		PermissionDescribeTag,
		PermissionAssociateTag,
	}
}

const (
	// ResourceShareTypeForeign is a ResourceShareType enum value
	ResourceShareTypeForeign = "FOREIGN"

	// ResourceShareTypeAll is a ResourceShareType enum value
	ResourceShareTypeAll = "ALL"
)

// ResourceShareType_Values returns all elements of the ResourceShareType enum
func ResourceShareType_Values() []string {
	return []string{
		ResourceShareTypeForeign,
		ResourceShareTypeAll,
	}
}

const (
	// ResourceTypeDatabase is a ResourceType enum value
	ResourceTypeDatabase = "DATABASE"

	// ResourceTypeTable is a ResourceType enum value
	ResourceTypeTable = "TABLE"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeDatabase,
		ResourceTypeTable,
	}
}
