// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by goyacc -o proto.y.go -l -p proto proto.y. DO NOT EDIT.
package parser

import __yyfmt__ "fmt"

//lint:file-ignore SA4006 generated parser has unused values

import (
	"math"

	"github.com/bufbuild/protocompile/ast"
)

type protoSymType struct {
	yys       int
	file      *ast.FileNode
	syn       *ast.SyntaxNode
	fileDecl  ast.FileElement
	fileDecls []ast.FileElement
	pkg       *ast.PackageNode
	imprt     *ast.ImportNode
	msg       *ast.MessageNode
	msgDecl   ast.MessageElement
	msgDecls  []ast.MessageElement
	fld       *ast.FieldNode
	mapFld    *ast.MapFieldNode
	mapType   *ast.MapTypeNode
	grp       *ast.GroupNode
	oo        *ast.OneOfNode
	ooDecl    ast.OneOfElement
	ooDecls   []ast.OneOfElement
	ext       *ast.ExtensionRangeNode
	resvd     *ast.ReservedNode
	en        *ast.EnumNode
	enDecl    ast.EnumElement
	enDecls   []ast.EnumElement
	env       *ast.EnumValueNode
	extend    *ast.ExtendNode
	extDecl   ast.ExtendElement
	extDecls  []ast.ExtendElement
	svc       *ast.ServiceNode
	svcDecl   ast.ServiceElement
	svcDecls  []ast.ServiceElement
	mtd       *ast.RPCNode
	rpcType   *ast.RPCTypeNode
	rpcDecl   ast.RPCElement
	rpcDecls  []ast.RPCElement
	opt       *ast.OptionNode
	opts      *compactOptionList
	ref       *ast.FieldReferenceNode
	optNms    *fieldRefList
	cmpctOpts *ast.CompactOptionsNode
	rng       *ast.RangeNode
	rngs      *rangeList
	names     *nameList
	cid       *identList
	tid       ast.IdentValueNode
	sl        *valueList
	msgField  *ast.MessageFieldNode
	msgEntry  *messageFieldEntry
	msgLit    *messageFieldList
	v         ast.ValueNode
	il        ast.IntValueNode
	str       *stringList
	s         *ast.StringLiteralNode
	i         *ast.UintLiteralNode
	f         *ast.FloatLiteralNode
	id        *ast.IdentNode
	b         *ast.RuneNode
	err       error
}

const _STRING_LIT = 57346
const _INT_LIT = 57347
const _FLOAT_LIT = 57348
const _NAME = 57349
const _SYNTAX = 57350
const _IMPORT = 57351
const _WEAK = 57352
const _PUBLIC = 57353
const _PACKAGE = 57354
const _OPTION = 57355
const _TRUE = 57356
const _FALSE = 57357
const _INF = 57358
const _NAN = 57359
const _REPEATED = 57360
const _OPTIONAL = 57361
const _REQUIRED = 57362
const _DOUBLE = 57363
const _FLOAT = 57364
const _INT32 = 57365
const _INT64 = 57366
const _UINT32 = 57367
const _UINT64 = 57368
const _SINT32 = 57369
const _SINT64 = 57370
const _FIXED32 = 57371
const _FIXED64 = 57372
const _SFIXED32 = 57373
const _SFIXED64 = 57374
const _BOOL = 57375
const _STRING = 57376
const _BYTES = 57377
const _GROUP = 57378
const _ONEOF = 57379
const _MAP = 57380
const _EXTENSIONS = 57381
const _TO = 57382
const _MAX = 57383
const _RESERVED = 57384
const _ENUM = 57385
const _MESSAGE = 57386
const _EXTEND = 57387
const _SERVICE = 57388
const _RPC = 57389
const _STREAM = 57390
const _RETURNS = 57391
const _ERROR = 57392

var protoToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"_STRING_LIT",
	"_INT_LIT",
	"_FLOAT_LIT",
	"_NAME",
	"_SYNTAX",
	"_IMPORT",
	"_WEAK",
	"_PUBLIC",
	"_PACKAGE",
	"_OPTION",
	"_TRUE",
	"_FALSE",
	"_INF",
	"_NAN",
	"_REPEATED",
	"_OPTIONAL",
	"_REQUIRED",
	"_DOUBLE",
	"_FLOAT",
	"_INT32",
	"_INT64",
	"_UINT32",
	"_UINT64",
	"_SINT32",
	"_SINT64",
	"_FIXED32",
	"_FIXED64",
	"_SFIXED32",
	"_SFIXED64",
	"_BOOL",
	"_STRING",
	"_BYTES",
	"_GROUP",
	"_ONEOF",
	"_MAP",
	"_EXTENSIONS",
	"_TO",
	"_MAX",
	"_RESERVED",
	"_ENUM",
	"_MESSAGE",
	"_EXTEND",
	"_SERVICE",
	"_RPC",
	"_STREAM",
	"_RETURNS",
	"_ERROR",
	"'='",
	"';'",
	"':'",
	"'{'",
	"'}'",
	"'\\\\'",
	"'/'",
	"'?'",
	"'.'",
	"','",
	"'>'",
	"'<'",
	"'+'",
	"'-'",
	"'('",
	"')'",
	"'['",
	"']'",
	"'*'",
	"'&'",
	"'^'",
	"'%'",
	"'$'",
	"'#'",
	"'@'",
	"'!'",
	"'~'",
	"'`'",
}

var protoStatenames = [...]string{}

const protoEofCode = 1
const protoErrCode = 2
const protoInitialStackSize = 16

var protoExca = [...]int16{
	-1, 0,
	1, 4,
	-2, 0,
	-1, 1,
	1, -1,
	-2, 0,
	-1, 2,
	1, 1,
	-2, 0,
	-1, 3,
	1, 2,
	-2, 0,
	-1, 22,
	1, 3,
	-2, 0,
	-1, 95,
	55, 185,
	-2, 0,
	-1, 96,
	55, 173,
	-2, 0,
	-1, 97,
	55, 202,
	-2, 0,
	-1, 99,
	55, 210,
	-2, 0,
	-1, 110,
	55, 54,
	-2, 0,
	-1, 289,
	55, 52,
	61, 52,
	-2, 0,
	-1, 354,
	61, 54,
	-2, 0,
	-1, 370,
	55, 124,
	-2, 0,
	-1, 404,
	61, 54,
	-2, 0,
	-1, 409,
	61, 54,
	-2, 0,
	-1, 497,
	61, 54,
	-2, 0,
	-1, 547,
	55, 185,
	-2, 0,
	-1, 551,
	55, 185,
	-2, 0,
	-1, 555,
	55, 185,
	-2, 0,
	-1, 573,
	55, 222,
	-2, 0,
	-1, 580,
	55, 185,
	-2, 0,
	-1, 583,
	55, 185,
	-2, 0,
	-1, 586,
	55, 185,
	-2, 0,
	-1, 607,
	55, 185,
	-2, 0,
	-1, 619,
	55, 185,
	-2, 0,
}

const protoPrivate = 57344

const protoLast = 2396

var protoAct = [...]int16{
	31, 118, 117, 125, 8, 106, 8, 8, 496, 494,
	593, 423, 366, 406, 399, 430, 81, 325, 77, 79,
	80, 82, 84, 327, 316, 107, 8, 310, 411, 408,
	105, 280, 124, 228, 139, 177, 407, 413, 30, 425,
	544, 26, 351, 110, 605, 607, 569, 567, 412, 565,
	85, 354, 555, 87, 88, 89, 352, 75, 367, 367,
	553, 367, 367, 551, 367, 367, 549, 547, 545, 537,
	536, 531, 524, 514, 512, 367, 367, 481, 500, 499,
	367, 367, 365, 367, 574, 414, 367, 367, 110, 367,
	535, 400, 367, 109, 77, 94, 409, 367, 328, 116,
	178, 104, 405, 281, 110, 98, 328, 346, 319, 346,
	576, 292, 409, 103, 346, 345, 577, 345, 543, 301,
	346, 564, 345, 541, 346, 504, 598, 344, 345, 503,
	230, 185, 345, 115, 485, 309, 346, 313, 314, 287,
	597, 538, 515, 350, 345, 501, 480, 391, 303, 305,
	307, 349, 374, 29, 328, 368, 523, 329, 338, 320,
	343, 93, 434, 318, 317, 329, 315, 440, 441, 442,
	443, 444, 445, 17, 446, 447, 448, 449, 91, 619,
	178, 450, 451, 452, 453, 454, 455, 456, 457, 458,
	459, 460, 461, 462, 463, 464, 436, 465, 466, 467,
	468, 469, 470, 471, 472, 473, 474, 475, 476, 477,
	317, 185, 322, 329, 14, 517, 572, 586, 573, 438,
	4, 15, 284, 583, 16, 17, 580, 14, 596, 284,
	596, 370, 99, 17, 15, 97, 336, 16, 17, 17,
	17, 17, 96, 95, 617, 611, 591, 590, 589, 333,
	334, 335, 584, 581, 578, 19, 18, 20, 21, 337,
	230, 331, 571, 563, 13, 557, 527, 285, 19, 18,
	20, 21, 283, 519, 285, 339, 422, 13, 595, 283,
	595, 609, 390, 281, 373, 372, 342, 341, 332, 323,
	292, 302, 286, 102, 101, 100, 90, 355, 86, 25,
	561, 560, 516, 488, 358, 359, 360, 361, 362, 363,
	487, 340, 486, 420, 419, 356, 418, 417, 347, 416,
	415, 353, 397, 371, 364, 324, 92, 24, 490, 427,
	392, 369, 29, 5, 394, 395, 396, 23, 27, 28,
	122, 11, 388, 11, 11, 588, 120, 10, 389, 10,
	10, 587, 109, 299, 297, 292, 23, 355, 355, 530,
	398, 29, 312, 11, 298, 428, 296, 294, 77, 10,
	529, 528, 121, 9, 431, 9, 9, 295, 511, 510,
	509, 403, 401, 376, 377, 378, 379, 380, 381, 382,
	383, 384, 385, 386, 387, 9, 426, 508, 507, 479,
	317, 506, 482, 109, 489, 292, 478, 312, 421, 483,
	292, 393, 29, 282, 279, 3, 484, 492, 22, 12,
	227, 179, 176, 123, 326, 311, 180, 128, 429, 137,
	127, 433, 126, 431, 513, 505, 520, 521, 229, 432,
	119, 289, 434, 290, 435, 518, 235, 440, 441, 442,
	443, 444, 445, 17, 446, 447, 448, 449, 134, 437,
	522, 450, 451, 452, 453, 454, 455, 456, 457, 458,
	459, 460, 461, 462, 463, 464, 436, 465, 466, 467,
	468, 469, 470, 471, 472, 473, 474, 475, 476, 477,
	236, 525, 140, 183, 439, 238, 143, 526, 292, 438,
	375, 108, 532, 291, 76, 533, 592, 355, 534, 424,
	7, 6, 2, 1, 0, 542, 77, 109, 0, 546,
	548, 550, 552, 554, 556, 559, 539, 558, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 109,
	0, 566, 568, 570, 0, 562, 0, 0, 575, 0,
	579, 0, 0, 0, 582, 0, 0, 0, 585, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 594, 0, 0,
	0, 301, 0, 600, 301, 0, 602, 301, 0, 604,
	0, 0, 0, 0, 0, 0, 594, 0, 109, 109,
	606, 608, 301, 610, 301, 0, 301, 612, 613, 0,
	618, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	301, 0, 621, 301, 495, 0, 29, 114, 111, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 0, 0, 0, 0, 110, 0, 0, 0,
	0, 0, 0, 0, 497, 113, 112, 0, 0, 0,
	493, 29, 114, 111, 32, 33, 34, 35, 36, 37,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 0, 0, 0,
	0, 110, 0, 0, 0, 0, 0, 0, 0, 404,
	113, 112, 0, 0, 402, 29, 114, 111, 32, 33,
	34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
	74, 0, 0, 0, 0, 110, 0, 0, 0, 0,
	0, 0, 0, 497, 113, 112, 29, 114, 111, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 0, 0, 0, 0, 110, 0, 0, 0,
	0, 0, 540, 0, 0, 113, 112, 32, 33, 34,
	35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 502, 0, 0, 0, 293, 32, 33,
	34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
	74, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 498, 0, 0, 0, 293, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 410, 0, 0, 0, 293,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 348, 0, 0, 0,
	293, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 288, 0, 0,
	0, 293, 32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 293, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 130, 0, 0,
	0, 78, 144, 145, 146, 147, 148, 149, 17, 150,
	151, 152, 153, 133, 132, 131, 154, 155, 156, 157,
	158, 159, 160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 136, 142, 135, 170, 171, 138, 19, 18,
	20, 172, 173, 174, 175, 0, 0, 129, 0, 0,
	622, 130, 0, 0, 141, 0, 144, 145, 146, 147,
	148, 149, 17, 150, 151, 152, 153, 133, 132, 131,
	154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
	164, 165, 166, 167, 168, 169, 136, 142, 135, 170,
	171, 138, 19, 18, 20, 172, 173, 174, 175, 0,
	0, 129, 0, 0, 620, 130, 0, 0, 141, 0,
	144, 145, 146, 147, 148, 149, 17, 150, 151, 152,
	153, 133, 132, 131, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
	136, 142, 135, 170, 171, 138, 19, 18, 20, 172,
	173, 174, 175, 0, 0, 129, 0, 0, 616, 130,
	0, 0, 141, 0, 144, 145, 146, 147, 148, 149,
	17, 150, 151, 152, 153, 133, 132, 131, 154, 155,
	156, 157, 158, 159, 160, 161, 162, 163, 164, 165,
	166, 167, 168, 169, 136, 142, 135, 170, 171, 138,
	19, 18, 20, 172, 173, 174, 175, 0, 0, 129,
	0, 0, 615, 130, 0, 0, 141, 0, 144, 145,
	146, 147, 148, 149, 17, 150, 151, 152, 153, 133,
	132, 131, 154, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169, 136, 142,
	135, 170, 171, 138, 19, 18, 20, 172, 173, 174,
	175, 0, 0, 129, 0, 0, 614, 130, 0, 0,
	141, 0, 144, 145, 146, 147, 148, 149, 17, 150,
	151, 152, 153, 133, 132, 131, 154, 155, 156, 157,
	158, 159, 160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 136, 142, 135, 170, 171, 138, 19, 18,
	20, 172, 173, 174, 175, 0, 0, 129, 0, 0,
	603, 130, 0, 0, 141, 0, 144, 145, 146, 147,
	148, 149, 17, 150, 151, 152, 153, 133, 132, 131,
	154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
	164, 165, 166, 167, 168, 169, 136, 142, 135, 170,
	171, 138, 19, 18, 20, 172, 173, 174, 175, 0,
	0, 129, 0, 0, 601, 130, 0, 0, 141, 0,
	144, 145, 146, 147, 148, 149, 17, 150, 151, 152,
	153, 133, 132, 131, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
	136, 142, 135, 170, 171, 138, 19, 18, 20, 172,
	173, 174, 175, 0, 0, 129, 0, 0, 599, 130,
	0, 0, 141, 0, 144, 145, 146, 147, 148, 149,
	17, 150, 151, 152, 153, 133, 132, 131, 154, 155,
	156, 157, 158, 159, 160, 161, 162, 163, 164, 165,
	166, 167, 168, 169, 136, 142, 135, 170, 171, 138,
	19, 18, 20, 172, 173, 174, 175, 0, 0, 129,
	0, 0, 300, 130, 0, 0, 141, 0, 144, 145,
	146, 147, 148, 149, 17, 150, 151, 152, 153, 133,
	132, 131, 154, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169, 136, 142,
	135, 170, 171, 138, 19, 18, 20, 172, 173, 174,
	175, 0, 0, 129, 0, 0, 231, 0, 0, 0,
	141, 239, 240, 241, 242, 243, 244, 245, 246, 247,
	248, 249, 234, 233, 232, 250, 251, 252, 253, 254,
	255, 256, 257, 258, 259, 260, 261, 262, 263, 264,
	265, 266, 267, 268, 269, 270, 271, 272, 273, 274,
	275, 276, 277, 278, 0, 0, 0, 0, 0, 330,
	231, 0, 0, 237, 0, 239, 240, 241, 242, 243,
	244, 245, 246, 247, 248, 249, 234, 233, 232, 250,
	251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
	261, 262, 263, 264, 265, 266, 267, 268, 269, 270,
	271, 272, 273, 274, 275, 276, 277, 278, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 237, 32, 33,
	34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
	74, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	83, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 491, 74, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 83, 32, 33, 34, 35, 36, 37,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 308, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 83, 32, 33, 34,
	35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 306, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 83,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 304,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 0, 0, 0, 0, 0, 182, 0,
	0, 0, 83, 186, 187, 188, 189, 190, 191, 17,
	192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
	202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219, 184, 220,
	221, 222, 223, 224, 225, 226, 0, 182, 181, 0,
	0, 321, 186, 187, 188, 189, 190, 191, 17, 192,
	193, 194, 195, 196, 197, 198, 199, 200, 201, 202,
	203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
	213, 214, 215, 216, 217, 218, 219, 184, 220, 221,
	222, 223, 224, 225, 226, 357, 0, 181, 0, 0,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74,
}

var protoPact = [...]int16{
	212, -1000, 225, 225, 276, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 247, 328, 2346, 1236, 2346, 2346,
	1941, 2346, 225, -1000, 408, -1000, 246, 408, 408, 408,
	244, 119, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 275, 102, -1000, 1941, 189,
	188, 181, -1000, 2346, 178, 243, -1000, 242, 241, -1000,
	-1000, 2346, 812, 1236, 33, 1781, 2255, 1888, -1000, 227,
	-1000, -1000, -1000, -1000, 240, -1000, -1000, -1000, -1000, -1000,
	1175, -1000, 361, 348, -1000, -1000, -1000, 1727, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	239, 2153, 2100, 2047, 2346, 402, 2346, 2346, 357, -1000,
	-1000, 2346, 46, 100, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 2206, -1000, -1000, -1000,
	-1000, -1000, 237, 274, 149, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 1834, -1000, -1000,
	-1000, 236, 2153, 2100, 2047, 2346, -1000, 2346, 99, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 220,
	-1000, -1000, -1000, -1000, 235, 2346, -1000, 105, 72, 1114,
	91, -11, -1000, 2303, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 2346, 2346, 2346, 2346, 2346, 2346, 273,
	30, 95, 291, 177, 272, 233, 232, 92, -1000, 360,
	2346, -1000, -1000, -1000, 101, 230, 87, 290, -1000, 406,
	-1000, -1000, -1000, 2346, 2346, 2346, 271, -1000, 2346, -1000,
	-1000, -1000, 26, -1000, -1000, -1000, -1000, -1000, 84, -1000,
	-1000, 687, 34, -1000, 1053, -1000, -20, 17, 269, 268,
	266, 265, 263, 262, 403, -1000, 224, 1236, 402, 324,
	440, 401, -1000, -1000, 408, 86, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 25,
	-1000, 101, 93, -1000, 261, 259, 252, 399, -1000, 279,
	1994, -1000, 622, -1000, 992, -1000, 11, 10, 85, 931,
	68, 64, -1000, 2346, -1000, 396, 393, 392, 375, 374,
	373, 22, -1000, 5, 82, 251, -1000, -1000, -1000, 160,
	-1000, -1000, -1000, -1000, 221, 2346, 2346, -1000, 2346, 97,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 20, -1000,
	1941, -1000, 214, -1000, -1000, -1000, 366, 365, 354, 19,
	26, 1941, 24, -1000, 2, 1, 81, 870, 62, -1000,
	-1000, 50, 57, -1000, -1000, -28, 16, 13, 14, 9,
	8, -2, -1000, 213, -1000, 1236, 812, -1000, -1000, -1000,
	250, 249, -1000, 2346, -1000, 211, 60, -1000, -3, -5,
	-6, -1000, 210, 164, 18, -1000, -1000, -1000, 751, 49,
	55, -1000, -1000, -1000, -1000, -1000, 202, 1781, 172, -1000,
	201, 1781, 169, -1000, 200, 1781, 163, -1000, -1000, -1000,
	346, 340, -1000, -1000, -1000, -1000, 196, -1000, 195, -1000,
	194, -1000, -1000, 228, -1000, -1000, 80, 66, -1000, 1673,
	1781, -1000, 1619, 1781, -1000, 1565, 1781, -8, -9, -1000,
	-1000, -1000, 226, -1000, -1000, -1000, 193, 751, 751, -1000,
	1511, -1000, 1457, -1000, 1403, -1000, 192, 1781, 125, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 1349, 1781,
	-1000, 1295, -1000,
}

var protoPgo = [...]int16{
	0, 513, 512, 333, 415, 511, 510, 3, 509, 11,
	10, 506, 504, 503, 39, 12, 8, 30, 5, 29,
	501, 23, 0, 500, 496, 495, 494, 493, 21, 492,
	490, 459, 16, 458, 446, 444, 9, 13, 443, 441,
	28, 440, 439, 438, 432, 32, 431, 430, 429, 372,
	1, 2, 15, 428, 24, 427, 426, 34, 425, 424,
	27, 17, 423, 346, 35, 422, 421, 340, 33, 420,
	25, 419, 31, 414, 413, 14,
}

var protoR1 = [...]int8{
	0, 1, 1, 1, 1, 4, 4, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 2, 5, 5,
	5, 6, 28, 28, 29, 29, 30, 30, 31, 31,
	7, 14, 14, 12, 12, 16, 16, 17, 17, 17,
	20, 20, 20, 20, 20, 20, 20, 20, 70, 70,
	18, 18, 40, 40, 40, 39, 39, 39, 39, 39,
	39, 38, 38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 13, 13, 13, 13, 37, 37, 19, 19,
	19, 36, 36, 36, 36, 36, 36, 32, 32, 33,
	33, 34, 34, 35, 35, 41, 41, 41, 41, 41,
	41, 41, 41, 43, 43, 43, 43, 43, 43, 43,
	43, 15, 9, 9, 8, 45, 45, 45, 45, 45,
	45, 44, 53, 53, 53, 52, 52, 52, 52, 52,
	42, 42, 46, 46, 47, 47, 48, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23, 23, 62,
	62, 60, 60, 58, 58, 58, 61, 61, 59, 59,
	59, 21, 21, 55, 55, 56, 56, 57, 54, 54,
	63, 65, 65, 65, 64, 64, 64, 64, 64, 64,
	66, 66, 49, 51, 51, 51, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50, 50, 67,
	69, 69, 69, 68, 68, 68, 68, 71, 73, 73,
	73, 72, 72, 72, 72, 72, 74, 74, 75, 75,
	11, 11, 11, 10, 10, 10, 10, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	27, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22,
}

var protoR2 = [...]int8{
	0, 1, 1, 2, 0, 2, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 1, 4, 3, 4,
	4, 3, 1, 3, 1, 3, 1, 3, 1, 3,
	5, 1, 3, 1, 3, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 1, 2, 2, 1, 2,
	3, 3, 1, 2, 0, 1, 2, 2, 2, 2,
	1, 3, 3, 4, 4, 5, 5, 4, 3, 2,
	5, 4, 1, 3, 5, 3, 1, 3, 1, 3,
	3, 1, 3, 3, 5, 3, 5, 1, 2, 1,
	2, 1, 2, 1, 2, 6, 6, 6, 7, 7,
	7, 5, 6, 6, 6, 6, 7, 7, 7, 5,
	6, 3, 1, 3, 3, 8, 8, 8, 9, 9,
	9, 5, 2, 1, 0, 1, 1, 1, 2, 1,
	5, 6, 7, 8, 5, 6, 6, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 3,
	4, 1, 3, 1, 3, 3, 1, 3, 1, 3,
	3, 1, 2, 3, 1, 3, 1, 3, 1, 3,
	5, 2, 1, 0, 1, 1, 1, 1, 2, 1,
	4, 5, 5, 2, 1, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 1, 5,
	2, 1, 0, 1, 1, 2, 1, 5, 2, 1,
	0, 1, 1, 1, 2, 1, 6, 8, 4, 3,
	2, 1, 0, 1, 1, 2, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1,
}

var protoChk = [...]int16{
	-1000, -1, -2, -4, 8, -3, -5, -6, -7, -49,
	-63, -67, -71, 52, 2, 9, 12, 13, 44, 43,
	45, 46, -4, -3, 51, 52, -70, 10, 11, 4,
	-28, -22, 7, 8, 9, 10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
	35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, -14, -12, -22, 65, -22,
	-22, -32, -28, 59, -22, -70, 52, -70, -70, -70,
	52, 59, 51, 59, -32, 54, 54, 54, -28, 54,
	52, 52, 52, -28, -16, -17, -18, -70, -20, -22,
	54, 6, 64, 63, 5, -14, 66, -51, -50, -41,
	-63, -49, -67, -62, -45, -7, -44, -47, -55, 52,
	2, 20, 19, 18, -33, 39, 37, -48, 42, -57,
	-29, 59, 38, -24, 7, 8, 9, 10, 11, 12,
	14, 15, 16, 17, 21, 22, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
	40, 41, 46, 47, 48, 49, -65, -64, -7, -66,
	-56, 52, 2, -27, 42, -57, 7, 8, 9, 10,
	11, 12, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	43, 44, 45, 46, 47, 48, 49, -69, -68, -43,
	-45, 2, 20, 19, 18, -34, -30, 59, -25, 7,
	8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
	21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
	31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, -73,
	-72, -7, -74, 52, 2, 47, 52, -40, 2, -39,
	-38, -13, -22, 67, 6, 16, 5, 6, 16, 5,
	55, -50, 52, -32, 36, -32, 36, -32, 36, -22,
	-60, -58, 5, -22, -22, -60, -54, -70, -28, 62,
	59, 55, -64, 52, 51, -61, -59, -21, 5, 64,
	55, -68, 52, -32, -32, -32, -22, -28, 59, 55,
	-72, 52, -22, 55, 55, 60, 52, -40, 2, 60,
	52, 53, 67, -19, 62, -18, -28, 2, -22, -22,
	-22, -22, -22, -22, 51, 52, -15, 67, 60, 40,
	54, 51, 52, 52, 60, -23, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34, -28, -21,
	52, 60, 40, 5, -22, -22, -22, 51, -28, -75,
	65, -17, 67, -19, 62, 68, -37, 2, -19, 62,
	2, -40, 68, 57, 68, 51, 51, 51, 51, 51,
	51, 5, 52, -9, -8, -14, -60, 5, 41, -53,
	-52, -7, -42, -46, 2, -35, 36, -31, 59, -26,
	7, 8, 9, 10, 11, 12, 14, 15, 16, 17,
	21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
	31, 32, 33, 34, 35, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 5, -54,
	60, 52, -15, -61, -21, 41, 51, 51, 51, 5,
	49, 48, -32, 68, -36, 2, -16, 62, 2, 68,
	68, 60, 2, 61, 61, -28, 5, 5, 5, 5,
	5, 5, 52, -15, 68, 60, 51, 55, -52, 52,
	-22, -22, -28, 59, 52, -15, -32, 52, 5, 5,
	5, 52, -15, -75, -32, 66, 68, 68, 60, -40,
	2, 61, -37, 61, 68, 52, -15, 54, -15, 52,
	-15, 54, -15, 52, -15, 54, -15, 52, -9, -16,
	51, 51, -28, 52, 61, 52, -15, 52, -15, 52,
	-15, 52, 52, 54, 66, -36, 61, 61, 52, -51,
	54, 52, -51, 54, 52, -51, 54, 5, 5, 52,
	52, 52, -11, -10, -7, 52, 2, 60, 60, 55,
	-51, 55, -51, 55, -51, 52, -15, 54, -15, 55,
	-10, 52, -36, -36, 55, 55, 55, 52, -51, 54,
	55, -51, 55,
}

var protoDef = [...]int16{
	-2, -2, -2, -2, 0, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 16, 0, 0, 0, 0, 0,
	0, 0, -2, 5, 0, 15, 0, 0, 0, 48,
	0, 22, 380, 381, 382, 383, 384, 385, 386, 387,
	388, 389, 390, 391, 392, 393, 394, 395, 396, 397,
	398, 399, 400, 401, 402, 403, 404, 405, 406, 407,
	408, 409, 410, 411, 412, 413, 414, 415, 416, 417,
	418, 419, 420, 421, 422, 0, 31, 33, 0, 0,
	0, 0, 87, 0, 0, 0, 18, 0, 0, 49,
	21, 0, 0, 0, 0, -2, -2, -2, 88, -2,
	17, 19, 20, 23, 0, 35, 36, 37, 38, 39,
	-2, 40, 0, 0, 45, 32, 34, 0, 184, 186,
	187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
	198, 0, 0, 0, 0, 0, 0, 0, 0, 164,
	89, 0, 253, 24, 227, 228, 229, 230, 231, 232,
	233, 234, 235, 236, 237, 238, 239, 240, 241, 242,
	243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
	254, 255, 256, 257, 258, 259, 0, 172, 174, 175,
	176, 177, 179, 0, 0, 166, 300, 301, 302, 303,
	304, 305, 306, 307, 308, 309, 310, 311, 312, 313,
	314, 315, 316, 317, 318, 319, 320, 321, 322, 323,
	324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
	334, 335, 336, 337, 338, 339, 340, 0, 201, 203,
	204, 206, 0, 0, 0, 0, 91, 0, 26, 260,
	261, 262, 263, 264, 265, 266, 267, 268, 269, 270,
	271, 272, 273, 274, 275, 276, 277, 278, 279, 280,
	281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
	291, 292, 293, 294, 295, 296, 297, 298, 299, 0,
	209, 211, 212, 213, 215, 0, 30, 0, 60, -2,
	55, 0, 72, 0, 41, 44, 47, 42, 43, 46,
	182, 183, 197, 0, 409, 0, 409, 0, 409, 0,
	0, 151, 153, 0, 0, 0, 0, 168, 90, 0,
	0, 170, 171, 178, 0, 0, 156, 158, 161, 0,
	199, 200, 205, 0, 0, 0, 0, 92, 0, 207,
	208, 214, 0, 50, 51, 58, 59, 53, 60, 56,
	57, 0, 0, 69, -2, 78, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 149, 0, 0, 0, 0,
	-2, 0, 163, 167, 0, 0, 137, 138, 139, 140,
	141, 142, 143, 144, 145, 146, 147, 148, 25, 0,
	165, 0, 0, 162, 0, 0, 0, 0, 27, 0,
	0, 61, 0, 68, -2, 62, 0, 0, 76, -2,
	60, 0, 73, 0, 75, 0, 0, 0, 0, 0,
	0, 0, 150, 0, 112, 0, 152, 154, 155, 0,
	123, 125, 126, 127, 129, 0, 366, 93, 0, 28,
	341, 342, 343, 344, 345, 346, 347, 348, 349, 350,
	351, 352, 353, 354, 355, 356, 357, 358, 359, 360,
	361, 362, 363, 364, 365, 367, 368, 369, 370, 371,
	372, 373, 374, 375, 376, 377, 378, 379, 0, 169,
	0, 180, 0, 157, 159, 160, 0, 0, 0, 0,
	0, 421, 0, 63, 0, 0, 81, -2, 60, 64,
	67, 0, 60, 71, 79, 0, 0, 0, 0, 0,
	0, 0, 101, 0, 111, 0, 0, 121, 122, 128,
	0, 0, 94, 0, 134, 0, 0, 181, 0, 0,
	0, 109, 0, 0, 0, 219, 65, 66, 0, 0,
	60, 70, 77, 80, 74, 95, 0, -2, 0, 96,
	0, -2, 0, 97, 0, -2, 0, 102, 113, 114,
	0, 0, 29, 135, 136, 103, 0, 104, 0, 105,
	0, 110, 216, -2, 218, 82, 83, 85, 98, 0,
	-2, 99, 0, -2, 100, 0, -2, 0, 0, 106,
	107, 108, 0, 221, 223, 224, 226, 0, 0, 115,
	0, 116, 0, 117, 0, 130, 0, -2, 0, 217,
	220, 225, 84, 86, 118, 119, 120, 131, 0, -2,
	132, 0, 133,
}

var protoTok1 = [...]int8{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 76, 3, 74, 73, 72, 70, 3,
	65, 66, 69, 63, 60, 64, 59, 57, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 53, 52,
	62, 51, 61, 58, 75, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 67, 56, 68, 71, 3, 78, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 54, 3, 55, 77,
}

var protoTok2 = [...]int8{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50,
}

var protoTok3 = [...]int8{
	0,
}

var protoErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

/*	parser for yacc output	*/

var (
	protoDebug        = 0
	protoErrorVerbose = false
)

type protoLexer interface {
	Lex(lval *protoSymType) int
	Error(s string)
}

type protoParser interface {
	Parse(protoLexer) int
	Lookahead() int
}

type protoParserImpl struct {
	lval  protoSymType
	stack [protoInitialStackSize]protoSymType
	char  int
}

func (p *protoParserImpl) Lookahead() int {
	return p.char
}

func protoNewParser() protoParser {
	return &protoParserImpl{}
}

const protoFlag = -1000

func protoTokname(c int) string {
	if c >= 1 && c-1 < len(protoToknames) {
		if protoToknames[c-1] != "" {
			return protoToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func protoStatname(s int) string {
	if s >= 0 && s < len(protoStatenames) {
		if protoStatenames[s] != "" {
			return protoStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func protoErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !protoErrorVerbose {
		return "syntax error"
	}

	for _, e := range protoErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + protoTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := int(protoPact[state])
	for tok := TOKSTART; tok-1 < len(protoToknames); tok++ {
		if n := base + tok; n >= 0 && n < protoLast && int(protoChk[int(protoAct[n])]) == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if protoDef[state] == -2 {
		i := 0
		for protoExca[i] != -1 || int(protoExca[i+1]) != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; protoExca[i] >= 0; i += 2 {
			tok := int(protoExca[i])
			if tok < TOKSTART || protoExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if protoExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += protoTokname(tok)
	}
	return res
}

func protolex1(lex protoLexer, lval *protoSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = int(protoTok1[0])
		goto out
	}
	if char < len(protoTok1) {
		token = int(protoTok1[char])
		goto out
	}
	if char >= protoPrivate {
		if char < protoPrivate+len(protoTok2) {
			token = int(protoTok2[char-protoPrivate])
			goto out
		}
	}
	for i := 0; i < len(protoTok3); i += 2 {
		token = int(protoTok3[i+0])
		if token == char {
			token = int(protoTok3[i+1])
			goto out
		}
	}

out:
	if token == 0 {
		token = int(protoTok2[1]) /* unknown char */
	}
	if protoDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", protoTokname(token), uint(char))
	}
	return char, token
}

func protoParse(protolex protoLexer) int {
	return protoNewParser().Parse(protolex)
}

func (protorcvr *protoParserImpl) Parse(protolex protoLexer) int {
	var proton int
	var protoVAL protoSymType
	var protoDollar []protoSymType
	_ = protoDollar // silence set and not used
	protoS := protorcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	protostate := 0
	protorcvr.char = -1
	prototoken := -1 // protorcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		protostate = -1
		protorcvr.char = -1
		prototoken = -1
	}()
	protop := -1
	goto protostack

ret0:
	return 0

ret1:
	return 1

protostack:
	/* put a state and value onto the stack */
	if protoDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", protoTokname(prototoken), protoStatname(protostate))
	}

	protop++
	if protop >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoS[protop] = protoVAL
	protoS[protop].yys = protostate

protonewstate:
	proton = int(protoPact[protostate])
	if proton <= protoFlag {
		goto protodefault /* simple state */
	}
	if protorcvr.char < 0 {
		protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
	}
	proton += prototoken
	if proton < 0 || proton >= protoLast {
		goto protodefault
	}
	proton = int(protoAct[proton])
	if int(protoChk[proton]) == prototoken { /* valid shift */
		protorcvr.char = -1
		prototoken = -1
		protoVAL = protorcvr.lval
		protostate = proton
		if Errflag > 0 {
			Errflag--
		}
		goto protostack
	}

protodefault:
	/* default state action */
	proton = int(protoDef[protostate])
	if proton == -2 {
		if protorcvr.char < 0 {
			protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if protoExca[xi+0] == -1 && int(protoExca[xi+1]) == protostate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			proton = int(protoExca[xi+0])
			if proton < 0 || proton == prototoken {
				break
			}
		}
		proton = int(protoExca[xi+1])
		if proton < 0 {
			goto ret0
		}
	}
	if proton == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			protolex.Error(protoErrorMessage(protostate, prototoken))
			Nerrs++
			if protoDebug >= 1 {
				__yyfmt__.Printf("%s", protoStatname(protostate))
				__yyfmt__.Printf(" saw %s\n", protoTokname(prototoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for protop >= 0 {
				proton = int(protoPact[protoS[protop].yys]) + protoErrCode
				if proton >= 0 && proton < protoLast {
					protostate = int(protoAct[proton]) /* simulate a shift of "error" */
					if int(protoChk[protostate]) == protoErrCode {
						goto protostack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if protoDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", protoS[protop].yys)
				}
				protop--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if protoDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", protoTokname(prototoken))
			}
			if prototoken == protoEofCode {
				goto ret1
			}
			protorcvr.char = -1
			prototoken = -1
			goto protonewstate /* try again in the same state */
		}
	}

	/* reduction by production proton */
	if protoDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", proton, protoStatname(protostate))
	}

	protont := proton
	protopt := protop
	_ = protopt // guard against "declared and not used"

	protop -= int(protoR2[proton])
	// protop is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if protop+1 >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoVAL = protoS[protop+1]

	/* consult goto table to find next state */
	proton = int(protoR1[proton])
	protog := int(protoPgo[proton])
	protoj := protog + protoS[protop].yys + 1

	if protoj >= protoLast {
		protostate = int(protoAct[protog])
	} else {
		protostate = int(protoAct[protoj])
		if int(protoChk[protostate]) != -proton {
			protostate = int(protoAct[protog])
		}
	}
	// dummy call; replaced with literal code
	switch protont {

	case 1:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 2:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, protoDollar[1].fileDecls, lex.eof)
			lex.res = protoVAL.file
		}
	case 3:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, protoDollar[2].fileDecls, lex.eof)
			lex.res = protoVAL.file
		}
	case 4:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 5:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].fileDecl != nil {
				protoVAL.fileDecls = append(protoDollar[1].fileDecls, protoDollar[2].fileDecl)
			} else {
				protoVAL.fileDecls = protoDollar[1].fileDecls
			}
		}
	case 6:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].fileDecl != nil {
				protoVAL.fileDecls = []ast.FileElement{protoDollar[1].fileDecl}
			} else {
				protoVAL.fileDecls = nil
			}
		}
	case 7:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].imprt
		}
	case 8:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].pkg
		}
	case 9:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].opt
		}
	case 10:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].msg
		}
	case 11:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].en
		}
	case 12:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].extend
		}
	case 13:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = protoDollar[1].svc
		}
	case 14:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 15:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileDecl = nil
		}
	case 16:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileDecl = nil
		}
	case 17:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.syn = ast.NewSyntaxNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, protoDollar[3].str.toStringValueNode(), protoDollar[4].b)
		}
	case 18:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.imprt = ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, nil, protoDollar[2].str.toStringValueNode(), protoDollar[3].b)
		}
	case 19:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.imprt = ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, protoDollar[2].id.ToKeyword(), protoDollar[3].str.toStringValueNode(), protoDollar[4].b)
		}
	case 20:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.imprt = ast.NewImportNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), nil, protoDollar[3].str.toStringValueNode(), protoDollar[4].b)
		}
	case 21:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.pkg = ast.NewPackageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 22:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, nil, nil}
		}
	case 23:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, protoDollar[2].b, protoDollar[3].cid}
		}
	case 24:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, nil, nil}
		}
	case 25:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, protoDollar[2].b, protoDollar[3].cid}
		}
	case 26:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, nil, nil}
		}
	case 27:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, protoDollar[2].b, protoDollar[3].cid}
		}
	case 28:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, nil, nil}
		}
	case 29:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cid = &identList{protoDollar[1].id, protoDollar[2].b, protoDollar[3].cid}
		}
	case 30:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			refs, dots := protoDollar[2].optNms.toNodes()
			optName := ast.NewOptionNameNode(refs, dots)
			protoVAL.opt = ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, protoDollar[5].b)
		}
	case 31:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefList{protoDollar[1].ref, nil, nil}
		}
	case 32:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.optNms = &fieldRefList{protoDollar[1].ref, protoDollar[2].b, protoDollar[3].optNms}
		}
	case 33:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ref = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 34:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].tid, protoDollar[3].b)
		}
	case 37:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].str.toStringValueNode()
		}
	case 39:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 40:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].f
		}
	case 41:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 42:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 43:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 44:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 45:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].i
		}
	case 46:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewPositiveUintLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 47:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].i.Val > math.MaxInt64+1 {
				// can't represent as int so treat as float literal
				protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].i)
			} else {
				protoVAL.v = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
			}
		}
	case 48:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.str = &stringList{protoDollar[1].s, nil}
		}
	case 49:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.str = &stringList{protoDollar[1].s, protoDollar[2].str}
		}
	case 50:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			fields, delims := protoDollar[2].msgLit.toNodes()
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delims, protoDollar[3].b)
		}
	case 51:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = nil
		}
	case 52:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgEntry != nil {
				protoVAL.msgLit = &messageFieldList{protoDollar[1].msgEntry, nil}
			} else {
				protoVAL.msgLit = nil
			}
		}
	case 53:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgEntry != nil {
				protoVAL.msgLit = &messageFieldList{protoDollar[1].msgEntry, protoDollar[2].msgLit}
			} else {
				protoVAL.msgLit = protoDollar[2].msgLit
			}
		}
	case 54:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.msgLit = nil
		}
	case 55:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgField != nil {
				protoVAL.msgEntry = &messageFieldEntry{protoDollar[1].msgField, nil}
			} else {
				protoVAL.msgEntry = nil
			}
		}
	case 56:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgField != nil {
				protoVAL.msgEntry = &messageFieldEntry{protoDollar[1].msgField, protoDollar[2].b}
			} else {
				protoVAL.msgEntry = nil
			}
		}
	case 57:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgField != nil {
				protoVAL.msgEntry = &messageFieldEntry{protoDollar[1].msgField, protoDollar[2].b}
			} else {
				protoVAL.msgEntry = nil
			}
		}
	case 58:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgEntry = nil
		}
	case 59:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgEntry = nil
		}
	case 60:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgEntry = nil
		}
	case 61:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, protoDollar[2].b, protoDollar[3].v)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 62:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				val := ast.NewArrayLiteralNode(protoDollar[2].b, nil, nil, protoDollar[3].b)
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, nil, val)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 63:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				val := ast.NewArrayLiteralNode(protoDollar[3].b, nil, nil, protoDollar[4].b)
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, protoDollar[2].b, val)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 64:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				vals, commas := protoDollar[3].sl.toNodes()
				val := ast.NewArrayLiteralNode(protoDollar[2].b, vals, commas, protoDollar[4].b)
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, nil, val)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 65:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			if protoDollar[1].ref != nil {
				vals, commas := protoDollar[4].sl.toNodes()
				val := ast.NewArrayLiteralNode(protoDollar[3].b, vals, commas, protoDollar[5].b)
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, protoDollar[2].b, val)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 66:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.msgField = nil
		}
	case 67:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.msgField = nil
		}
	case 68:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].ref != nil && protoDollar[3].v != nil {
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, protoDollar[2].b, protoDollar[3].v)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 69:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].ref != nil && protoDollar[2].v != nil {
				protoVAL.msgField = ast.NewMessageFieldNode(protoDollar[1].ref, nil, protoDollar[2].v)
			} else {
				protoVAL.msgField = nil
			}
		}
	case 70:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.msgField = nil
		}
	case 71:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.msgField = nil
		}
	case 72:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ref = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 73:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 74:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.ref = ast.NewAnyTypeReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b, protoDollar[4].cid.toIdentValueNode(nil), protoDollar[5].b)
		}
	case 75:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = nil
		}
	case 76:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].v == nil {
				protoVAL.sl = nil
			} else {
				protoVAL.sl = &valueList{protoDollar[1].v, nil, nil}
			}
		}
	case 77:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].v == nil {
				protoVAL.sl = nil
			} else {
				protoVAL.sl = &valueList{protoDollar[1].v, protoDollar[2].b, protoDollar[3].sl}
			}
		}
	case 78:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].v
		}
	case 79:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			fields, delims := protoDollar[2].msgLit.toNodes()
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delims, protoDollar[3].b)
		}
	case 80:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = nil
		}
	case 81:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueList{protoDollar[1].v, nil, nil}
		}
	case 82:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.sl = &valueList{protoDollar[1].v, protoDollar[2].b, protoDollar[3].sl}
		}
	case 83:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			fields, delims := protoDollar[2].msgLit.toNodes()
			msg := ast.NewMessageLiteralNode(protoDollar[1].b, fields, delims, protoDollar[3].b)
			protoVAL.sl = &valueList{msg, nil, nil}
		}
	case 84:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			fields, delims := protoDollar[2].msgLit.toNodes()
			msg := ast.NewMessageLiteralNode(protoDollar[1].b, fields, delims, protoDollar[3].b)
			protoVAL.sl = &valueList{msg, protoDollar[4].b, protoDollar[5].sl}
		}
	case 85:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.sl = nil
		}
	case 86:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.sl = protoDollar[5].sl
		}
	case 87:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 88:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 89:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 90:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 91:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 92:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 93:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 94:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 95:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 96:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 97:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 98:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 99:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 100:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 101:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 102:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 103:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 104:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 105:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 106:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 107:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 108:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 109:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 110:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 111:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			opts, commas := protoDollar[2].opts.toNodes()
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, opts, commas, protoDollar[3].b)
		}
	case 112:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionList{protoDollar[1].opt, nil, nil}
		}
	case 113:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.opts = &compactOptionList{protoDollar[1].opt, protoDollar[2].b, protoDollar[3].opts}
		}
	case 114:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			refs, dots := protoDollar[1].optNms.toNodes()
			optName := ast.NewOptionNameNode(refs, dots)
			protoVAL.opt = ast.NewCompactOptionNode(optName, protoDollar[2].b, protoDollar[3].v)
		}
	case 115:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgDecls, protoDollar[8].b)
		}
	case 116:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgDecls, protoDollar[8].b)
		}
	case 117:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgDecls, protoDollar[8].b)
		}
	case 118:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgDecls, protoDollar[9].b)
		}
	case 119:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgDecls, protoDollar[9].b)
		}
	case 120:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgDecls, protoDollar[9].b)
		}
	case 121:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.oo = ast.NewOneOfNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].ooDecls, protoDollar[5].b)
		}
	case 122:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].ooDecl != nil {
				protoVAL.ooDecls = append(protoDollar[1].ooDecls, protoDollar[2].ooDecl)
			} else {
				protoVAL.ooDecls = protoDollar[1].ooDecls
			}
		}
	case 123:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].ooDecl != nil {
				protoVAL.ooDecls = []ast.OneOfElement{protoDollar[1].ooDecl}
			} else {
				protoVAL.ooDecls = nil
			}
		}
	case 124:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.ooDecls = nil
		}
	case 125:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooDecl = protoDollar[1].opt
		}
	case 126:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooDecl = protoDollar[1].fld
		}
	case 127:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooDecl = protoDollar[1].grp
		}
	case 128:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ooDecl = nil
		}
	case 129:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooDecl = nil
		}
	case 130:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 131:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 132:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b, protoDollar[6].msgDecls, protoDollar[7].b)
		}
	case 133:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b, protoDollar[7].msgDecls, protoDollar[8].b)
		}
	case 134:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.mapFld = ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 135:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapFld = ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 136:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapType = ast.NewMapTypeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, protoDollar[3].id, protoDollar[4].b, protoDollar[5].tid, protoDollar[6].b)
		}
	case 149:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			ranges, commas := protoDollar[2].rngs.toNodes()
			protoVAL.ext = ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), ranges, commas, nil, protoDollar[3].b)
		}
	case 150:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			ranges, commas := protoDollar[2].rngs.toNodes()
			protoVAL.ext = ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), ranges, commas, protoDollar[3].cmpctOpts, protoDollar[4].b)
		}
	case 151:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeList{protoDollar[1].rng, nil, nil}
		}
	case 152:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rngs = &rangeList{protoDollar[1].rng, protoDollar[2].b, protoDollar[3].rngs}
		}
	case 153:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, nil, nil, nil)
		}
	case 154:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), protoDollar[3].i, nil)
		}
	case 155:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 156:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeList{protoDollar[1].rng, nil, nil}
		}
	case 157:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rngs = &rangeList{protoDollar[1].rng, protoDollar[2].b, protoDollar[3].rngs}
		}
	case 158:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, nil, nil, nil)
		}
	case 159:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), protoDollar[3].il, nil)
		}
	case 160:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 161:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.il = protoDollar[1].i
		}
	case 162:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.il = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 163:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			ranges, commas := protoDollar[2].rngs.toNodes()
			protoVAL.resvd = ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), ranges, commas, protoDollar[3].b)
		}
	case 165:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			ranges, commas := protoDollar[2].rngs.toNodes()
			protoVAL.resvd = ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), ranges, commas, protoDollar[3].b)
		}
	case 167:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			names, commas := protoDollar[2].names.toNodes()
			protoVAL.resvd = ast.NewReservedNamesNode(protoDollar[1].id.ToKeyword(), names, commas, protoDollar[3].b)
		}
	case 168:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameList{protoDollar[1].str.toStringValueNode(), nil, nil}
		}
	case 169:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.names = &nameList{protoDollar[1].str.toStringValueNode(), protoDollar[2].b, protoDollar[3].names}
		}
	case 170:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.en = ast.NewEnumNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].enDecls, protoDollar[5].b)
		}
	case 171:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].enDecl != nil {
				protoVAL.enDecls = append(protoDollar[1].enDecls, protoDollar[2].enDecl)
			} else {
				protoVAL.enDecls = protoDollar[1].enDecls
			}
		}
	case 172:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].enDecl != nil {
				protoVAL.enDecls = []ast.EnumElement{protoDollar[1].enDecl}
			} else {
				protoVAL.enDecls = nil
			}
		}
	case 173:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.enDecls = nil
		}
	case 174:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enDecl = protoDollar[1].opt
		}
	case 175:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enDecl = protoDollar[1].env
		}
	case 176:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enDecl = protoDollar[1].resvd
		}
	case 177:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enDecl = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 178:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enDecl = nil
		}
	case 179:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enDecl = nil
		}
	case 180:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.env = ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, nil, protoDollar[4].b)
		}
	case 181:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.env = ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, protoDollar[4].cmpctOpts, protoDollar[5].b)
		}
	case 182:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.msg = ast.NewMessageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].msgDecls, protoDollar[5].b)
		}
	case 183:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].msgDecl != nil {
				protoVAL.msgDecls = append(protoDollar[1].msgDecls, protoDollar[2].msgDecl)
			} else {
				protoVAL.msgDecls = protoDollar[1].msgDecls
			}
		}
	case 184:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgDecl != nil {
				protoVAL.msgDecls = []ast.MessageElement{protoDollar[1].msgDecl}
			} else {
				protoVAL.msgDecls = nil
			}
		}
	case 185:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.msgDecls = nil
		}
	case 186:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].fld
		}
	case 187:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].en
		}
	case 188:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].msg
		}
	case 189:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].extend
		}
	case 190:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].ext
		}
	case 191:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].grp
		}
	case 192:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].opt
		}
	case 193:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].oo
		}
	case 194:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].mapFld
		}
	case 195:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = protoDollar[1].resvd
		}
	case 196:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 197:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgDecl = nil
		}
	case 198:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgDecl = nil
		}
	case 199:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.extend = ast.NewExtendNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].b, protoDollar[4].extDecls, protoDollar[5].b)
		}
	case 200:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].extDecl != nil {
				protoVAL.extDecls = append(protoDollar[1].extDecls, protoDollar[2].extDecl)
			} else {
				protoVAL.extDecls = protoDollar[1].extDecls
			}
		}
	case 201:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].extDecl != nil {
				protoVAL.extDecls = []ast.ExtendElement{protoDollar[1].extDecl}
			} else {
				protoVAL.extDecls = nil
			}
		}
	case 202:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.extDecls = nil
		}
	case 203:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extDecl = protoDollar[1].fld
		}
	case 204:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extDecl = protoDollar[1].grp
		}
	case 205:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.extDecl = nil
		}
	case 206:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extDecl = nil
		}
	case 207:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.svc = ast.NewServiceNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].svcDecls, protoDollar[5].b)
		}
	case 208:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].svcDecl != nil {
				protoVAL.svcDecls = append(protoDollar[1].svcDecls, protoDollar[2].svcDecl)
			} else {
				protoVAL.svcDecls = protoDollar[1].svcDecls
			}
		}
	case 209:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].svcDecl != nil {
				protoVAL.svcDecls = []ast.ServiceElement{protoDollar[1].svcDecl}
			} else {
				protoVAL.svcDecls = nil
			}
		}
	case 210:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.svcDecls = nil
		}
	case 211:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcDecl = protoDollar[1].opt
		}
	case 212:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcDecl = protoDollar[1].mtd
		}
	case 213:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcDecl = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 214:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcDecl = nil
		}
	case 215:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcDecl = nil
		}
	case 216:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mtd = ast.NewRPCNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].rpcType, protoDollar[4].id.ToKeyword(), protoDollar[5].rpcType, protoDollar[6].b)
		}
	case 217:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.mtd = ast.NewRPCNodeWithBody(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].rpcType, protoDollar[4].id.ToKeyword(), protoDollar[5].rpcType, protoDollar[6].b, protoDollar[7].rpcDecls, protoDollar[8].b)
		}
	case 218:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.rpcType = ast.NewRPCTypeNode(protoDollar[1].b, protoDollar[2].id.ToKeyword(), protoDollar[3].tid, protoDollar[4].b)
		}
	case 219:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rpcType = ast.NewRPCTypeNode(protoDollar[1].b, nil, protoDollar[2].tid, protoDollar[3].b)
		}
	case 220:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].rpcDecl != nil {
				protoVAL.rpcDecls = append(protoDollar[1].rpcDecls, protoDollar[2].rpcDecl)
			} else {
				protoVAL.rpcDecls = protoDollar[1].rpcDecls
			}
		}
	case 221:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].rpcDecl != nil {
				protoVAL.rpcDecls = []ast.RPCElement{protoDollar[1].rpcDecl}
			} else {
				protoVAL.rpcDecls = nil
			}
		}
	case 222:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.rpcDecls = nil
		}
	case 223:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rpcDecl = protoDollar[1].opt
		}
	case 224:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rpcDecl = ast.NewEmptyDeclNode(protoDollar[1].b)
		}
	case 225:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.rpcDecl = nil
		}
	case 226:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rpcDecl = nil
		}
	}
	goto protostack /* stack new state and value */
}
