// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.


package v1

import (
	"bytes"
	"context"
	"fmt"
	"io/ioutil"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	mpc_keyspb "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/mpc_keys/v1"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/encoding/protojson"
)

var newMPCKeyClientHook clientHook

// MPCKeyCallOptions contains the retry settings for each method of MPCKeyClient.
type MPCKeyCallOptions struct {
	RegisterDevice []gax.CallOption
	GetDevice []gax.CallOption
	CreateDeviceGroup []gax.CallOption
	GetDeviceGroup []gax.CallOption
	ListMPCOperations []gax.CallOption
	CreateMPCKey []gax.CallOption
	GetMPCKey []gax.CallOption
	CreateSignature []gax.CallOption
	PrepareDeviceArchive []gax.CallOption
	PrepareDeviceBackup []gax.CallOption
	AddDevice []gax.CallOption
	RevokeDevice []gax.CallOption
}

func defaultMPCKeyGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("api.developer.coinbase.com/waas/mpc_keys:443"),
		internaloption.WithDefaultMTLSEndpoint("api.developer.coinbase.com/waas/mpc_keys:443"),
		internaloption.WithDefaultAudience("https://api.developer.coinbase.com/waas/mpc_keys/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
		grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultMPCKeyCallOptions() *MPCKeyCallOptions {
	return &MPCKeyCallOptions{
		RegisterDevice: []gax.CallOption{
		},
		GetDevice: []gax.CallOption{
		},
		CreateDeviceGroup: []gax.CallOption{
		},
		GetDeviceGroup: []gax.CallOption{
		},
		ListMPCOperations: []gax.CallOption{
		},
		CreateMPCKey: []gax.CallOption{
		},
		GetMPCKey: []gax.CallOption{
		},
		CreateSignature: []gax.CallOption{
		},
		PrepareDeviceArchive: []gax.CallOption{
		},
		PrepareDeviceBackup: []gax.CallOption{
		},
		AddDevice: []gax.CallOption{
		},
		RevokeDevice: []gax.CallOption{
		},
	}
}

func defaultMPCKeyRESTCallOptions() *MPCKeyCallOptions {
	return &MPCKeyCallOptions{
		RegisterDevice: []gax.CallOption{
		},
		GetDevice: []gax.CallOption{
		},
		CreateDeviceGroup: []gax.CallOption{
		},
		GetDeviceGroup: []gax.CallOption{
		},
		ListMPCOperations: []gax.CallOption{
		},
		CreateMPCKey: []gax.CallOption{
		},
		GetMPCKey: []gax.CallOption{
		},
		CreateSignature: []gax.CallOption{
		},
		PrepareDeviceArchive: []gax.CallOption{
		},
		PrepareDeviceBackup: []gax.CallOption{
		},
		AddDevice: []gax.CallOption{
		},
		RevokeDevice: []gax.CallOption{
		},
	}
}

// internalMPCKeyClient is an interface that defines the methods available from .
type internalMPCKeyClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	RegisterDevice(context.Context, *mpc_keyspb.RegisterDeviceRequest, ...gax.CallOption) (*mpc_keyspb.Device, error)
	GetDevice(context.Context, *mpc_keyspb.GetDeviceRequest, ...gax.CallOption) (*mpc_keyspb.Device, error)
	CreateDeviceGroup(context.Context, *mpc_keyspb.CreateDeviceGroupRequest, ...gax.CallOption) (*CreateDeviceGroupOperation, error)
	CreateDeviceGroupOperation(name string) *CreateDeviceGroupOperation
	GetDeviceGroup(context.Context, *mpc_keyspb.GetDeviceGroupRequest, ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error)
	ListMPCOperations(context.Context, *mpc_keyspb.ListMPCOperationsRequest, ...gax.CallOption) (*mpc_keyspb.ListMPCOperationsResponse, error)
	CreateMPCKey(context.Context, *mpc_keyspb.CreateMPCKeyRequest, ...gax.CallOption) (*mpc_keyspb.MPCKey, error)
	GetMPCKey(context.Context, *mpc_keyspb.GetMPCKeyRequest, ...gax.CallOption) (*mpc_keyspb.MPCKey, error)
	CreateSignature(context.Context, *mpc_keyspb.CreateSignatureRequest, ...gax.CallOption) (*CreateSignatureOperation, error)
	CreateSignatureOperation(name string) *CreateSignatureOperation
	PrepareDeviceArchive(context.Context, *mpc_keyspb.PrepareDeviceArchiveRequest, ...gax.CallOption) (*PrepareDeviceArchiveOperation, error)
	PrepareDeviceArchiveOperation(name string) *PrepareDeviceArchiveOperation
	PrepareDeviceBackup(context.Context, *mpc_keyspb.PrepareDeviceBackupRequest, ...gax.CallOption) (*PrepareDeviceBackupOperation, error)
	PrepareDeviceBackupOperation(name string) *PrepareDeviceBackupOperation
	AddDevice(context.Context, *mpc_keyspb.AddDeviceRequest, ...gax.CallOption) (*AddDeviceOperation, error)
	AddDeviceOperation(name string) *AddDeviceOperation
	RevokeDevice(context.Context, *mpc_keyspb.RevokeDeviceRequest, ...gax.CallOption) error
}

// MPCKeyClient is a client for interacting with .
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// MPCKeyService provides APIs for participating in cryptographic operations through
// multi-party computation (MPC). It should be be used in conjunction with the client-side
// WaaS SDK. The cryptographic Keys are created using an underlying hierarchically deterministic
// (HD) Tree, following the conventions of BIP-32 and BIP-44.
//
// The general flow is as follows:
//
// Call RegisterDevice to enroll the mobile Device.
//
// Call CreateDeviceGroup with the registered Device as its sole member and at least
// one HardenedChild set on the Seed.
//
// Poll for the pending DeviceGroup with ListMPCOperations and compute the MPCOperation
// using the WaaS SDK.
//
// Call CreateMPCKey, specifying the created DeviceGroup and desired derivation path.
//
// Call CreateSignature, specifying the created MPCKey and payload.
//
// Poll for the pending Signature with ListMPCOperations and compute the MPCOperation
// using the SDK.
type MPCKeyClient struct {
	// The internal transport-dependent client.
	internalClient internalMPCKeyClient

	// The call options for this service.
	CallOptions *MPCKeyCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient

}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *MPCKeyClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *MPCKeyClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *MPCKeyClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// RegisterDevice registers a new Device. A Device must be registered before it can be added to a DeviceGroup.
func (c *MPCKeyClient) RegisterDevice(ctx context.Context, req *mpc_keyspb.RegisterDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error) {
	return c.internalClient.RegisterDevice(ctx, req, opts...)
}

// GetDevice retrieves a Device by resource name.
func (c *MPCKeyClient) GetDevice(ctx context.Context, req *mpc_keyspb.GetDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error) {
	return c.internalClient.GetDevice(ctx, req, opts...)
}

// CreateDeviceGroup creates a DeviceGroup. The DeviceGroup must contain exactly one registered Device, and
// the Seed in the DeviceGroup must have at least one HardenedChild. After calling this,
// use ListMPCOperations to poll for the pending CreateDeviceGroup operation, and use the WaaS SDK’s
// ComputeMPCOperation to complete the operation.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *MPCKeyClient) CreateDeviceGroup(ctx context.Context, req *mpc_keyspb.CreateDeviceGroupRequest, opts ...gax.CallOption) (*CreateDeviceGroupOperation, error) {
	return c.internalClient.CreateDeviceGroup(ctx, req, opts...)
}

// CreateDeviceGroupOperation returns a new CreateDeviceGroupOperation from a given name.
// The name must be that of a previously created CreateDeviceGroupOperation, possibly from a different process.
func (c *MPCKeyClient) CreateDeviceGroupOperation(name string) *CreateDeviceGroupOperation {
	return c.internalClient.CreateDeviceGroupOperation(name)
}

// GetDeviceGroup retrieves a DeviceGroup by resource name.
func (c *MPCKeyClient) GetDeviceGroup(ctx context.Context, req *mpc_keyspb.GetDeviceGroupRequest, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	return c.internalClient.GetDeviceGroup(ctx, req, opts...)
}

// ListMPCOperations lists the pending MPCOperations awaiting computation associated with the given
// parent DeviceGroup. Use this API in combination with the WaaS SDK’s computeMPCOperation
// method to complete the operation.
func (c *MPCKeyClient) ListMPCOperations(ctx context.Context, req *mpc_keyspb.ListMPCOperationsRequest, opts ...gax.CallOption) (*mpc_keyspb.ListMPCOperationsResponse, error) {
	return c.internalClient.ListMPCOperations(ctx, req, opts...)
}

// CreateMPCKey creates an MPCKey. There must be a HardenedChild in the Seed of the parent
// DeviceGroup which is a prefix of the derivation path provided in the MPCKey.
func (c *MPCKeyClient) CreateMPCKey(ctx context.Context, req *mpc_keyspb.CreateMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error) {
	return c.internalClient.CreateMPCKey(ctx, req, opts...)
}

// GetMPCKey retrieves an MPCKey by resource name.
func (c *MPCKeyClient) GetMPCKey(ctx context.Context, req *mpc_keyspb.GetMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error) {
	return c.internalClient.GetMPCKey(ctx, req, opts...)
}

// CreateSignature creates a Signature using an MPCKey. After calling this, use ListMPCOperations
// to poll for the pending CreateSignature operation, and use the WaaS SDK’s
// computeMPCOperation to complete the operation.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *MPCKeyClient) CreateSignature(ctx context.Context, req *mpc_keyspb.CreateSignatureRequest, opts ...gax.CallOption) (*CreateSignatureOperation, error) {
	return c.internalClient.CreateSignature(ctx, req, opts...)
}

// CreateSignatureOperation returns a new CreateSignatureOperation from a given name.
// The name must be that of a previously created CreateSignatureOperation, possibly from a different process.
func (c *MPCKeyClient) CreateSignatureOperation(name string) *CreateSignatureOperation {
	return c.internalClient.CreateSignatureOperation(name)
}

// PrepareDeviceArchive prepares an archive in the local storage of the given Device. The archive contains cryptographic materials
// that can be used to export MPCKeys, which have the given DeviceGroup as their parent.
// The Device specified in the request must be a member of this DeviceGroup and must participate
// in the associated MPC operation for the archive to be prepared. After calling this,
// use ListMPCOperations to poll for the pending PrepareDeviceArchive operation, and use the WaaS SDK’s
// ComputeMPCOperation to complete the operation. Once the operation completes, the Device can utilize the
// WaaS SDK to export the private keys corresponding to each of the MPCKeys under this DeviceGroup.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *MPCKeyClient) PrepareDeviceArchive(ctx context.Context, req *mpc_keyspb.PrepareDeviceArchiveRequest, opts ...gax.CallOption) (*PrepareDeviceArchiveOperation, error) {
	return c.internalClient.PrepareDeviceArchive(ctx, req, opts...)
}

// PrepareDeviceArchiveOperation returns a new PrepareDeviceArchiveOperation from a given name.
// The name must be that of a previously created PrepareDeviceArchiveOperation, possibly from a different process.
func (c *MPCKeyClient) PrepareDeviceArchiveOperation(name string) *PrepareDeviceArchiveOperation {
	return c.internalClient.PrepareDeviceArchiveOperation(name)
}

// PrepareDeviceBackup prepares a backup in the given Device. The backup contains certain cryptographic materials
// that can be used to restore MPCKeys, which have the given DeviceGroup as their parent, on a new Device.
// The Device specified in the request must be a member of this DeviceGroup and must participate in the associated
// MPC operation for the backup to be prepared.
// After calling this RPC, use ListMPCOperations to poll for the pending PrepareDeviceBackup operation,
// and use the WaaS SDK’s ComputeMPCOperation to complete the operation. Once the operation completes,
// the Device can utilize WaaS SDK to download the backup bundle. We recommend storing this backup bundle securely
// in a storage provider of your choice. If the user loses access to their existing Device and wants to recover
// MPCKeys in the given DeviceGroup on a new Device, use AddDevice RPC on the MPCKeyService.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *MPCKeyClient) PrepareDeviceBackup(ctx context.Context, req *mpc_keyspb.PrepareDeviceBackupRequest, opts ...gax.CallOption) (*PrepareDeviceBackupOperation, error) {
	return c.internalClient.PrepareDeviceBackup(ctx, req, opts...)
}

// PrepareDeviceBackupOperation returns a new PrepareDeviceBackupOperation from a given name.
// The name must be that of a previously created PrepareDeviceBackupOperation, possibly from a different process.
func (c *MPCKeyClient) PrepareDeviceBackupOperation(name string) *PrepareDeviceBackupOperation {
	return c.internalClient.PrepareDeviceBackupOperation(name)
}

// AddDevice adds a Device to an existing DeviceGroup. Prior to this API being called, the Device must be registered using
// RegisterDevice RPC. The Device must have access to the backup created with PrepareDeviceBackup RPC to compute this
// operation. After calling this RPC, use ListMPCOperations to poll for the pending AddDevice operation,
// and use the WaaS SDK’s ComputeAddDeviceMPCOperation to complete the operation.
// After the operation is computed on WaaS SDK, the Device will have access to cryptographic materials
// required to process MPCOperations for this DeviceGroup.
// Once the operation completes on MPCKeyService, the Device will be added to the given DeviceGroup as a new member
// and all existing Devices in the DeviceGroup will stay functional.
// Use the RevokeDevice RPC to remove any of the existing Devices from the DeviceGroup.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *MPCKeyClient) AddDevice(ctx context.Context, req *mpc_keyspb.AddDeviceRequest, opts ...gax.CallOption) (*AddDeviceOperation, error) {
	return c.internalClient.AddDevice(ctx, req, opts...)
}

// AddDeviceOperation returns a new AddDeviceOperation from a given name.
// The name must be that of a previously created AddDeviceOperation, possibly from a different process.
func (c *MPCKeyClient) AddDeviceOperation(name string) *AddDeviceOperation {
	return c.internalClient.AddDeviceOperation(name)
}

// RevokeDevice revokes a registered Device. This operation removes the registered Device from all the DeviceGroups that it is a
// part of. Once the Device is revoked, cryptographic materials in your physical Device are invalidated,
// and the Device can no longer participate in any MPCOperations of the DeviceGroups it was a part of.
// Use this API in scenarios such as losing the existing Device, switching to a new physical Device, etc.
// Ensure that a new Device is successfully added to your DeviceGroups using the AddDevice RPC before invoking
// the RevokeDevice RPC.
func (c *MPCKeyClient) RevokeDevice(ctx context.Context, req *mpc_keyspb.RevokeDeviceRequest, opts ...gax.CallOption) error {
	return c.internalClient.RevokeDevice(ctx, req, opts...)
}

// mPCKeyGRPCClient is a client for interacting with  over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type mPCKeyGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing MPCKeyClient
	CallOptions **MPCKeyCallOptions

	// The gRPC API client.
	mPCKeyClient mpc_keyspb.MPCKeyServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewMPCKeyClient creates a new mpc key service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// MPCKeyService provides APIs for participating in cryptographic operations through
// multi-party computation (MPC). It should be be used in conjunction with the client-side
// WaaS SDK. The cryptographic Keys are created using an underlying hierarchically deterministic
// (HD) Tree, following the conventions of BIP-32 and BIP-44.
//
// The general flow is as follows:
//
// Call RegisterDevice to enroll the mobile Device.
//
// Call CreateDeviceGroup with the registered Device as its sole member and at least
// one HardenedChild set on the Seed.
//
// Poll for the pending DeviceGroup with ListMPCOperations and compute the MPCOperation
// using the WaaS SDK.
//
// Call CreateMPCKey, specifying the created DeviceGroup and desired derivation path.
//
// Call CreateSignature, specifying the created MPCKey and payload.
//
// Poll for the pending Signature with ListMPCOperations and compute the MPCOperation
// using the SDK.
func NewMPCKeyClient(ctx context.Context, opts ...option.ClientOption) (*MPCKeyClient, error) {
	clientOpts := defaultMPCKeyGRPCClientOptions()
	if newMPCKeyClientHook != nil {
		hookOpts, err := newMPCKeyClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := MPCKeyClient{CallOptions: defaultMPCKeyCallOptions()}

	c := &mPCKeyGRPCClient{
		connPool:    connPool,
		disableDeadlines: disableDeadlines,
		mPCKeyClient: mpc_keyspb.NewMPCKeyServiceClient(connPool),
		CallOptions: &client.CallOptions,

	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *mPCKeyGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *mPCKeyGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *mPCKeyGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type mPCKeyRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD

	// Points back to the CallOptions field of the containing MPCKeyClient
	CallOptions **MPCKeyCallOptions
}

// NewMPCKeyRESTClient creates a new mpc key service rest client.
//
// MPCKeyService provides APIs for participating in cryptographic operations through
// multi-party computation (MPC). It should be be used in conjunction with the client-side
// WaaS SDK. The cryptographic Keys are created using an underlying hierarchically deterministic
// (HD) Tree, following the conventions of BIP-32 and BIP-44.
//
// The general flow is as follows:
//
// Call RegisterDevice to enroll the mobile Device.
//
// Call CreateDeviceGroup with the registered Device as its sole member and at least
// one HardenedChild set on the Seed.
//
// Poll for the pending DeviceGroup with ListMPCOperations and compute the MPCOperation
// using the WaaS SDK.
//
// Call CreateMPCKey, specifying the created DeviceGroup and desired derivation path.
//
// Call CreateSignature, specifying the created MPCKey and payload.
//
// Poll for the pending Signature with ListMPCOperations and compute the MPCOperation
// using the SDK.
func NewMPCKeyRESTClient(ctx context.Context, opts ...option.ClientOption) (*MPCKeyClient, error) {
	clientOpts := append(defaultMPCKeyRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultMPCKeyRESTCallOptions()
	c := &mPCKeyRESTClient{
		endpoint: endpoint,
		httpClient: httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &MPCKeyClient{internalClient: c, LROClient: opClient, CallOptions: callOpts}, nil
}

func defaultMPCKeyRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://api.developer.coinbase.com/waas/mpc_keys"),
		internaloption.WithDefaultMTLSEndpoint("https://api.developer.coinbase.com/waas/mpc_keys"),
		internaloption.WithDefaultAudience("https://api.developer.coinbase.com/waas/mpc_keys/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}
// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *mPCKeyRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *mPCKeyRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *mPCKeyRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *mPCKeyGRPCClient) RegisterDevice(ctx context.Context, req *mpc_keyspb.RegisterDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error) {
	ctx = insertMetadata(ctx, c.xGoogMetadata)
	opts = append((*c.CallOptions).RegisterDevice[0:len((*c.CallOptions).RegisterDevice):len((*c.CallOptions).RegisterDevice)], opts...)
	var resp *mpc_keyspb.Device
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.RegisterDevice(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCKeyGRPCClient) GetDevice(ctx context.Context, req *mpc_keyspb.GetDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetDevice[0:len((*c.CallOptions).GetDevice):len((*c.CallOptions).GetDevice)], opts...)
	var resp *mpc_keyspb.Device
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.GetDevice(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCKeyGRPCClient) CreateDeviceGroup(ctx context.Context, req *mpc_keyspb.CreateDeviceGroupRequest, opts ...gax.CallOption) (*CreateDeviceGroupOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateDeviceGroup[0:len((*c.CallOptions).CreateDeviceGroup):len((*c.CallOptions).CreateDeviceGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.CreateDeviceGroup(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDeviceGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *mPCKeyGRPCClient) GetDeviceGroup(ctx context.Context, req *mpc_keyspb.GetDeviceGroupRequest, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetDeviceGroup[0:len((*c.CallOptions).GetDeviceGroup):len((*c.CallOptions).GetDeviceGroup)], opts...)
	var resp *mpc_keyspb.DeviceGroup
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.GetDeviceGroup(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCKeyGRPCClient) ListMPCOperations(ctx context.Context, req *mpc_keyspb.ListMPCOperationsRequest, opts ...gax.CallOption) (*mpc_keyspb.ListMPCOperationsResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListMPCOperations[0:len((*c.CallOptions).ListMPCOperations):len((*c.CallOptions).ListMPCOperations)], opts...)
	var resp *mpc_keyspb.ListMPCOperationsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.ListMPCOperations(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCKeyGRPCClient) CreateMPCKey(ctx context.Context, req *mpc_keyspb.CreateMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateMPCKey[0:len((*c.CallOptions).CreateMPCKey):len((*c.CallOptions).CreateMPCKey)], opts...)
	var resp *mpc_keyspb.MPCKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.CreateMPCKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCKeyGRPCClient) GetMPCKey(ctx context.Context, req *mpc_keyspb.GetMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetMPCKey[0:len((*c.CallOptions).GetMPCKey):len((*c.CallOptions).GetMPCKey)], opts...)
	var resp *mpc_keyspb.MPCKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.GetMPCKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCKeyGRPCClient) CreateSignature(ctx context.Context, req *mpc_keyspb.CreateSignatureRequest, opts ...gax.CallOption) (*CreateSignatureOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateSignature[0:len((*c.CallOptions).CreateSignature):len((*c.CallOptions).CreateSignature)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.CreateSignature(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateSignatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *mPCKeyGRPCClient) PrepareDeviceArchive(ctx context.Context, req *mpc_keyspb.PrepareDeviceArchiveRequest, opts ...gax.CallOption) (*PrepareDeviceArchiveOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "device_group", url.QueryEscape(req.GetDeviceGroup())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).PrepareDeviceArchive[0:len((*c.CallOptions).PrepareDeviceArchive):len((*c.CallOptions).PrepareDeviceArchive)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.PrepareDeviceArchive(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &PrepareDeviceArchiveOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *mPCKeyGRPCClient) PrepareDeviceBackup(ctx context.Context, req *mpc_keyspb.PrepareDeviceBackupRequest, opts ...gax.CallOption) (*PrepareDeviceBackupOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "device_group", url.QueryEscape(req.GetDeviceGroup())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).PrepareDeviceBackup[0:len((*c.CallOptions).PrepareDeviceBackup):len((*c.CallOptions).PrepareDeviceBackup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.PrepareDeviceBackup(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &PrepareDeviceBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *mPCKeyGRPCClient) AddDevice(ctx context.Context, req *mpc_keyspb.AddDeviceRequest, opts ...gax.CallOption) (*AddDeviceOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "device_group", url.QueryEscape(req.GetDeviceGroup())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).AddDevice[0:len((*c.CallOptions).AddDevice):len((*c.CallOptions).AddDevice)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCKeyClient.AddDevice(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AddDeviceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *mPCKeyGRPCClient) RevokeDevice(ctx context.Context, req *mpc_keyspb.RevokeDeviceRequest, opts ...gax.CallOption) error {
	ctx = insertMetadata(ctx, c.xGoogMetadata)
	opts = append((*c.CallOptions).RevokeDevice[0:len((*c.CallOptions).RevokeDevice):len((*c.CallOptions).RevokeDevice)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.mPCKeyClient.RevokeDevice(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// RegisterDevice registers a new Device. A Device must be registered before it can be added to a DeviceGroup.
func (c *mPCKeyRESTClient) RegisterDevice(ctx context.Context, req *mpc_keyspb.RegisterDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/device:register")

	// Build HTTP headers from client and context metadata.
	headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).RegisterDevice[0:len((*c.CallOptions).RegisterDevice):len((*c.CallOptions).RegisterDevice)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_keyspb.Device{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// GetDevice retrieves a Device by resource name.
func (c *mPCKeyRESTClient) GetDevice(ctx context.Context, req *mpc_keyspb.GetDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetDevice[0:len((*c.CallOptions).GetDevice):len((*c.CallOptions).GetDevice)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_keyspb.Device{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// CreateDeviceGroup creates a DeviceGroup. The DeviceGroup must contain exactly one registered Device, and
// the Seed in the DeviceGroup must have at least one HardenedChild. After calling this,
// use ListMPCOperations to poll for the pending CreateDeviceGroup operation, and use the WaaS SDK’s
// ComputeMPCOperation to complete the operation.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *mPCKeyRESTClient) CreateDeviceGroup(ctx context.Context, req *mpc_keyspb.CreateDeviceGroupRequest, opts ...gax.CallOption) (*CreateDeviceGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeviceGroup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/deviceGroups", req.GetParent())

	params := url.Values{}
	if req.GetDeviceGroupId() != "" {
		params.Add("deviceGroupId", fmt.Sprintf("%v", req.GetDeviceGroupId()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateDeviceGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetDeviceGroup retrieves a DeviceGroup by resource name.
func (c *mPCKeyRESTClient) GetDeviceGroup(ctx context.Context, req *mpc_keyspb.GetDeviceGroupRequest, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetDeviceGroup[0:len((*c.CallOptions).GetDeviceGroup):len((*c.CallOptions).GetDeviceGroup)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_keyspb.DeviceGroup{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// ListMPCOperations lists the pending MPCOperations awaiting computation associated with the given
// parent DeviceGroup. Use this API in combination with the WaaS SDK’s computeMPCOperation
// method to complete the operation.
func (c *mPCKeyRESTClient) ListMPCOperations(ctx context.Context, req *mpc_keyspb.ListMPCOperationsRequest, opts ...gax.CallOption) (*mpc_keyspb.ListMPCOperationsResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/mpcOperations", req.GetParent())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).ListMPCOperations[0:len((*c.CallOptions).ListMPCOperations):len((*c.CallOptions).ListMPCOperations)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_keyspb.ListMPCOperationsResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// CreateMPCKey creates an MPCKey. There must be a HardenedChild in the Seed of the parent
// DeviceGroup which is a prefix of the derivation path provided in the MPCKey.
func (c *mPCKeyRESTClient) CreateMPCKey(ctx context.Context, req *mpc_keyspb.CreateMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMpcKey()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/mpcKeys", req.GetParent())

	params := url.Values{}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).CreateMPCKey[0:len((*c.CallOptions).CreateMPCKey):len((*c.CallOptions).CreateMPCKey)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_keyspb.MPCKey{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// GetMPCKey retrieves an MPCKey by resource name.
func (c *mPCKeyRESTClient) GetMPCKey(ctx context.Context, req *mpc_keyspb.GetMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetMPCKey[0:len((*c.CallOptions).GetMPCKey):len((*c.CallOptions).GetMPCKey)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_keyspb.MPCKey{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// CreateSignature creates a Signature using an MPCKey. After calling this, use ListMPCOperations
// to poll for the pending CreateSignature operation, and use the WaaS SDK’s
// computeMPCOperation to complete the operation.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *mPCKeyRESTClient) CreateSignature(ctx context.Context, req *mpc_keyspb.CreateSignatureRequest, opts ...gax.CallOption) (*CreateSignatureOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSignature()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/signatures", req.GetParent())

	params := url.Values{}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateSignatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// PrepareDeviceArchive prepares an archive in the local storage of the given Device. The archive contains cryptographic materials
// that can be used to export MPCKeys, which have the given DeviceGroup as their parent.
// The Device specified in the request must be a member of this DeviceGroup and must participate
// in the associated MPC operation for the archive to be prepared. After calling this,
// use ListMPCOperations to poll for the pending PrepareDeviceArchive operation, and use the WaaS SDK’s
// ComputeMPCOperation to complete the operation. Once the operation completes, the Device can utilize the
// WaaS SDK to export the private keys corresponding to each of the MPCKeys under this DeviceGroup.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *mPCKeyRESTClient) PrepareDeviceArchive(ctx context.Context, req *mpc_keyspb.PrepareDeviceArchiveRequest, opts ...gax.CallOption) (*PrepareDeviceArchiveOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:prepareDeviceArchive", req.GetDeviceGroup())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "device_group", url.QueryEscape(req.GetDeviceGroup())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &PrepareDeviceArchiveOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// PrepareDeviceBackup prepares a backup in the given Device. The backup contains certain cryptographic materials
// that can be used to restore MPCKeys, which have the given DeviceGroup as their parent, on a new Device.
// The Device specified in the request must be a member of this DeviceGroup and must participate in the associated
// MPC operation for the backup to be prepared.
// After calling this RPC, use ListMPCOperations to poll for the pending PrepareDeviceBackup operation,
// and use the WaaS SDK’s ComputeMPCOperation to complete the operation. Once the operation completes,
// the Device can utilize WaaS SDK to download the backup bundle. We recommend storing this backup bundle securely
// in a storage provider of your choice. If the user loses access to their existing Device and wants to recover
// MPCKeys in the given DeviceGroup on a new Device, use AddDevice RPC on the MPCKeyService.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *mPCKeyRESTClient) PrepareDeviceBackup(ctx context.Context, req *mpc_keyspb.PrepareDeviceBackupRequest, opts ...gax.CallOption) (*PrepareDeviceBackupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:prepareDeviceBackup", req.GetDeviceGroup())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "device_group", url.QueryEscape(req.GetDeviceGroup())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &PrepareDeviceBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// AddDevice adds a Device to an existing DeviceGroup. Prior to this API being called, the Device must be registered using
// RegisterDevice RPC. The Device must have access to the backup created with PrepareDeviceBackup RPC to compute this
// operation. After calling this RPC, use ListMPCOperations to poll for the pending AddDevice operation,
// and use the WaaS SDK’s ComputeAddDeviceMPCOperation to complete the operation.
// After the operation is computed on WaaS SDK, the Device will have access to cryptographic materials
// required to process MPCOperations for this DeviceGroup.
// Once the operation completes on MPCKeyService, the Device will be added to the given DeviceGroup as a new member
// and all existing Devices in the DeviceGroup will stay functional.
// Use the RevokeDevice RPC to remove any of the existing Devices from the DeviceGroup.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *mPCKeyRESTClient) AddDevice(ctx context.Context, req *mpc_keyspb.AddDeviceRequest, opts ...gax.CallOption) (*AddDeviceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:addDevice", req.GetDeviceGroup())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "device_group", url.QueryEscape(req.GetDeviceGroup())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &AddDeviceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RevokeDevice revokes a registered Device. This operation removes the registered Device from all the DeviceGroups that it is a
// part of. Once the Device is revoked, cryptographic materials in your physical Device are invalidated,
// and the Device can no longer participate in any MPCOperations of the DeviceGroups it was a part of.
// Use this API in scenarios such as losing the existing Device, switching to a new physical Device, etc.
// Ensure that a new Device is successfully added to your DeviceGroups using the AddDevice RPC before invoking
// the RevokeDevice RPC.
func (c *mPCKeyRESTClient) RevokeDevice(ctx context.Context, req *mpc_keyspb.RevokeDeviceRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/device:revoke")

	// Build HTTP headers from client and context metadata.
	headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}
// AddDeviceOperation manages a long-running operation from AddDevice.
type AddDeviceOperation struct {
	lro *longrunning.Operation
	pollPath string
}

// AddDeviceOperation returns a new AddDeviceOperation from a given name.
// The name must be that of a previously created AddDeviceOperation, possibly from a different process.
func (c *mPCKeyGRPCClient) AddDeviceOperation(name string) *AddDeviceOperation {
	return &AddDeviceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AddDeviceOperation returns a new AddDeviceOperation from a given name.
// The name must be that of a previously created AddDeviceOperation, possibly from a different process.
func (c *mPCKeyRESTClient) AddDeviceOperation(name string) *AddDeviceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &AddDeviceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *AddDeviceOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *AddDeviceOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *AddDeviceOperation) Metadata() (*mpc_keyspb.AddDeviceMetadata, error) {
	var meta mpc_keyspb.AddDeviceMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *AddDeviceOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *AddDeviceOperation) Name() string {
	return op.lro.Name()
}

// CreateDeviceGroupOperation manages a long-running operation from CreateDeviceGroup.
type CreateDeviceGroupOperation struct {
	lro *longrunning.Operation
	pollPath string
}

// CreateDeviceGroupOperation returns a new CreateDeviceGroupOperation from a given name.
// The name must be that of a previously created CreateDeviceGroupOperation, possibly from a different process.
func (c *mPCKeyGRPCClient) CreateDeviceGroupOperation(name string) *CreateDeviceGroupOperation {
	return &CreateDeviceGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateDeviceGroupOperation returns a new CreateDeviceGroupOperation from a given name.
// The name must be that of a previously created CreateDeviceGroupOperation, possibly from a different process.
func (c *mPCKeyRESTClient) CreateDeviceGroupOperation(name string) *CreateDeviceGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateDeviceGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateDeviceGroupOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateDeviceGroupOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateDeviceGroupOperation) Metadata() (*mpc_keyspb.CreateDeviceGroupMetadata, error) {
	var meta mpc_keyspb.CreateDeviceGroupMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateDeviceGroupOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateDeviceGroupOperation) Name() string {
	return op.lro.Name()
}

// CreateSignatureOperation manages a long-running operation from CreateSignature.
type CreateSignatureOperation struct {
	lro *longrunning.Operation
	pollPath string
}

// CreateSignatureOperation returns a new CreateSignatureOperation from a given name.
// The name must be that of a previously created CreateSignatureOperation, possibly from a different process.
func (c *mPCKeyGRPCClient) CreateSignatureOperation(name string) *CreateSignatureOperation {
	return &CreateSignatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateSignatureOperation returns a new CreateSignatureOperation from a given name.
// The name must be that of a previously created CreateSignatureOperation, possibly from a different process.
func (c *mPCKeyRESTClient) CreateSignatureOperation(name string) *CreateSignatureOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateSignatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateSignatureOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.Signature, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.Signature
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateSignatureOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.Signature, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.Signature
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateSignatureOperation) Metadata() (*mpc_keyspb.CreateSignatureMetadata, error) {
	var meta mpc_keyspb.CreateSignatureMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateSignatureOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateSignatureOperation) Name() string {
	return op.lro.Name()
}

// PrepareDeviceArchiveOperation manages a long-running operation from PrepareDeviceArchive.
type PrepareDeviceArchiveOperation struct {
	lro *longrunning.Operation
	pollPath string
}

// PrepareDeviceArchiveOperation returns a new PrepareDeviceArchiveOperation from a given name.
// The name must be that of a previously created PrepareDeviceArchiveOperation, possibly from a different process.
func (c *mPCKeyGRPCClient) PrepareDeviceArchiveOperation(name string) *PrepareDeviceArchiveOperation {
	return &PrepareDeviceArchiveOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// PrepareDeviceArchiveOperation returns a new PrepareDeviceArchiveOperation from a given name.
// The name must be that of a previously created PrepareDeviceArchiveOperation, possibly from a different process.
func (c *mPCKeyRESTClient) PrepareDeviceArchiveOperation(name string) *PrepareDeviceArchiveOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &PrepareDeviceArchiveOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *PrepareDeviceArchiveOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *PrepareDeviceArchiveOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *PrepareDeviceArchiveOperation) Metadata() (*mpc_keyspb.PrepareDeviceArchiveMetadata, error) {
	var meta mpc_keyspb.PrepareDeviceArchiveMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *PrepareDeviceArchiveOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *PrepareDeviceArchiveOperation) Name() string {
	return op.lro.Name()
}

// PrepareDeviceBackupOperation manages a long-running operation from PrepareDeviceBackup.
type PrepareDeviceBackupOperation struct {
	lro *longrunning.Operation
	pollPath string
}

// PrepareDeviceBackupOperation returns a new PrepareDeviceBackupOperation from a given name.
// The name must be that of a previously created PrepareDeviceBackupOperation, possibly from a different process.
func (c *mPCKeyGRPCClient) PrepareDeviceBackupOperation(name string) *PrepareDeviceBackupOperation {
	return &PrepareDeviceBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// PrepareDeviceBackupOperation returns a new PrepareDeviceBackupOperation from a given name.
// The name must be that of a previously created PrepareDeviceBackupOperation, possibly from a different process.
func (c *mPCKeyRESTClient) PrepareDeviceBackupOperation(name string) *PrepareDeviceBackupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &PrepareDeviceBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *PrepareDeviceBackupOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *PrepareDeviceBackupOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_keyspb.DeviceGroup
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *PrepareDeviceBackupOperation) Metadata() (*mpc_keyspb.PrepareDeviceBackupMetadata, error) {
	var meta mpc_keyspb.PrepareDeviceBackupMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *PrepareDeviceBackupOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *PrepareDeviceBackupOperation) Name() string {
	return op.lro.Name()
}
