// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package v1

import (
	context "context"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MPCTransactionServiceClient is the client API for MPCTransactionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MPCTransactionServiceClient interface {
	// Creates an MPCTransaction. The long-running operation returned from this API contains
	// information about the state of the MPCTransaction that can be used to complete the operation.
	// The LRO is considered Done once the MPCTransaction reaches a state of `CONFIRMING`` (i.e.,
	// broadcast on-chain). See the MPCTransaction documentation for its lifecycle.
	// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
	// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
	// ListMPCOperations even after it returns a NOT_FOUND error.
	CreateMPCTransaction(ctx context.Context, in *CreateMPCTransactionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an MPCTransaction. There can be a delay between when CreateMPCTransaction is called
	// and when this API returns an MPCTransaction in the CREATED state.
	GetMPCTransaction(ctx context.Context, in *GetMPCTransactionRequest, opts ...grpc.CallOption) (*MPCTransaction, error)
	// Returns a list of MPCTransactions in an MPCWallet.
	ListMPCTransactions(ctx context.Context, in *ListMPCTransactionsRequest, opts ...grpc.CallOption) (*ListMPCTransactionsResponse, error)
}

type mPCTransactionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMPCTransactionServiceClient(cc grpc.ClientConnInterface) MPCTransactionServiceClient {
	return &mPCTransactionServiceClient{cc}
}

func (c *mPCTransactionServiceClient) CreateMPCTransaction(ctx context.Context, in *CreateMPCTransactionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/coinbase.cloud.mpc_transactions.v1.MPCTransactionService/CreateMPCTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mPCTransactionServiceClient) GetMPCTransaction(ctx context.Context, in *GetMPCTransactionRequest, opts ...grpc.CallOption) (*MPCTransaction, error) {
	out := new(MPCTransaction)
	err := c.cc.Invoke(ctx, "/coinbase.cloud.mpc_transactions.v1.MPCTransactionService/GetMPCTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mPCTransactionServiceClient) ListMPCTransactions(ctx context.Context, in *ListMPCTransactionsRequest, opts ...grpc.CallOption) (*ListMPCTransactionsResponse, error) {
	out := new(ListMPCTransactionsResponse)
	err := c.cc.Invoke(ctx, "/coinbase.cloud.mpc_transactions.v1.MPCTransactionService/ListMPCTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MPCTransactionServiceServer is the server API for MPCTransactionService service.
// All implementations must embed UnimplementedMPCTransactionServiceServer
// for forward compatibility
type MPCTransactionServiceServer interface {
	// Creates an MPCTransaction. The long-running operation returned from this API contains
	// information about the state of the MPCTransaction that can be used to complete the operation.
	// The LRO is considered Done once the MPCTransaction reaches a state of `CONFIRMING`` (i.e.,
	// broadcast on-chain). See the MPCTransaction documentation for its lifecycle.
	// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
	// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
	// ListMPCOperations even after it returns a NOT_FOUND error.
	CreateMPCTransaction(context.Context, *CreateMPCTransactionRequest) (*longrunning.Operation, error)
	// Gets an MPCTransaction. There can be a delay between when CreateMPCTransaction is called
	// and when this API returns an MPCTransaction in the CREATED state.
	GetMPCTransaction(context.Context, *GetMPCTransactionRequest) (*MPCTransaction, error)
	// Returns a list of MPCTransactions in an MPCWallet.
	ListMPCTransactions(context.Context, *ListMPCTransactionsRequest) (*ListMPCTransactionsResponse, error)
	mustEmbedUnimplementedMPCTransactionServiceServer()
}

// UnimplementedMPCTransactionServiceServer must be embedded to have forward compatible implementations.
type UnimplementedMPCTransactionServiceServer struct {
}

func (UnimplementedMPCTransactionServiceServer) CreateMPCTransaction(context.Context, *CreateMPCTransactionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMPCTransaction not implemented")
}
func (UnimplementedMPCTransactionServiceServer) GetMPCTransaction(context.Context, *GetMPCTransactionRequest) (*MPCTransaction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMPCTransaction not implemented")
}
func (UnimplementedMPCTransactionServiceServer) ListMPCTransactions(context.Context, *ListMPCTransactionsRequest) (*ListMPCTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMPCTransactions not implemented")
}
func (UnimplementedMPCTransactionServiceServer) mustEmbedUnimplementedMPCTransactionServiceServer() {}

// UnsafeMPCTransactionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MPCTransactionServiceServer will
// result in compilation errors.
type UnsafeMPCTransactionServiceServer interface {
	mustEmbedUnimplementedMPCTransactionServiceServer()
}

func RegisterMPCTransactionServiceServer(s grpc.ServiceRegistrar, srv MPCTransactionServiceServer) {
	s.RegisterService(&MPCTransactionService_ServiceDesc, srv)
}

func _MPCTransactionService_CreateMPCTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMPCTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MPCTransactionServiceServer).CreateMPCTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coinbase.cloud.mpc_transactions.v1.MPCTransactionService/CreateMPCTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MPCTransactionServiceServer).CreateMPCTransaction(ctx, req.(*CreateMPCTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MPCTransactionService_GetMPCTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMPCTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MPCTransactionServiceServer).GetMPCTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coinbase.cloud.mpc_transactions.v1.MPCTransactionService/GetMPCTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MPCTransactionServiceServer).GetMPCTransaction(ctx, req.(*GetMPCTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MPCTransactionService_ListMPCTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMPCTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MPCTransactionServiceServer).ListMPCTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coinbase.cloud.mpc_transactions.v1.MPCTransactionService/ListMPCTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MPCTransactionServiceServer).ListMPCTransactions(ctx, req.(*ListMPCTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MPCTransactionService_ServiceDesc is the grpc.ServiceDesc for MPCTransactionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MPCTransactionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "coinbase.cloud.mpc_transactions.v1.MPCTransactionService",
	HandlerType: (*MPCTransactionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMPCTransaction",
			Handler:    _MPCTransactionService_CreateMPCTransaction_Handler,
		},
		{
			MethodName: "GetMPCTransaction",
			Handler:    _MPCTransactionService_GetMPCTransaction_Handler,
		},
		{
			MethodName: "ListMPCTransactions",
			Handler:    _MPCTransactionService_ListMPCTransactions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "coinbase/cloud/mpc_transactions/v1/mpc_transactions.proto",
}
