// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's effective_tld_names.dat, hg revision f2c25ddbd1cf (2014-09-02)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 819

// Text is the combined text of all labels.
const text = "bievatmpanamabifukagawatch-and-clockashiharabihorologyoutubeppub" +
	"olognagatorockartuzyukiinetargiitatebayashichinohelparachutingje" +
	"sdalipetskashiwarabikedavvenjargalsacehimejiiyamanobeeldengeluid" +
	"urhamburgjovikashiwazakiyosatokamachildrensgardenavigationavuotn" +
	"akatsugawabilbaogakievenassisibenikihokumakogengerdalaskanitteda" +
	"lvdalivornobirabillustrationavyatkananporoceanographics3-website" +
	"-ap-southeast-1bioceanographiquembroideryukuhashimogosenayorohta" +
	"waramotoineppulmemerckasukabeerbirdartdecoalondonetskasumigauraw" +
	"a-mazowszexchangetmyipirangausdaloppadovald-aostarostwodzislaweg" +
	"rowestfalenfshostre-totenkawabirkenesoddtangenoamishirasatodayur" +
	"ihonjoyoitakarazukamikoaniihamatamakawajimarylhurstockholmestran" +
	"dvrdnsdojogaszkolahppiacenzakopanewyorkshireggiocalabriabirthpla" +
	"cemergencyberlevagangaviikarugaulardalorenskoglassassinationalhe" +
	"ritagematsubarakawachinaganoharaogashimadachicagobodoesntexistan" +
	"bullensakerbjarkoyusuharabjerkreimmobilienvironmentalconservatio" +
	"nhs3-website-ap-southeast-2bjugniizabloombergbauernikkoebenhavni" +
	"kolaevenes3-website-eu-west-1bluenoharabmwfarsundyndns-blogdns3-" +
	"website-sa-east-1bnpparibaselburgliwicemrbomloabaths3-website-us" +
	"-east-1bondyndns-freemasonryokamikawanehonbetsuruokamakurazakira" +
	"bonninohelsinkitakyushuaiabostonakijinsekikogenovarabotanicalgar" +
	"deninomiyakonojosoyromurabotanicgardenirasakindianapolis-a-blogg" +
	"erbotanycargodolls3-website-us-gov-west-1boutiquebecarrierbozent" +
	"sujiiepilepsyzranzanishiawakurabrandywinevalleyusuisservebbs3-we" +
	"bsite-us-west-1brasiljan-mayenishiazaindianmarketinglobalatinabe" +
	"auxartsandcrafts3-website-us-west-2bremangerbresciabrindisicilia" +
	"bristolgamvikasuyameiwamashikeventsakuhokksundyndns-homeftpacces" +
	"sakuragawabritishcolumbialowiezachpomorskienishigomutashinaindus" +
	"triesteamlierneustargardyndns-ip6boneat-urlezajsk-uralsk12000bro" +
	"adcastleasinglesakurainfinitinfoggiabroke-itarnobrzegloboknowsit" +
	"allfinanz-2brokerbronnoysundyndns-mailosangelesakyotanabellevued" +
	"atinglogowhalingloppenzaokinawashirosatobamagnitkafjordyndns-off" +
	"ice-on-the-webcambridgeorgiabrumunddaloteneinsurepbodynathomebui" +
	"ltarumizusawabrunelblagdenesnaaseralingenkainanaejrietiendaburya" +
	"tiabrusselsalangenishiharabruxellesjamalborkdalottokigawabryansk" +
	"jervoyageometre-experts-comptablesalatrobellunordkappgmailouvrev" +
	"iewsaltdalowiczest-a-la-masionishiizunazukintelligenceverbankasz" +
	"ubyuulsangoslombardyndns-at-workinggroupowiatatarstanishikatakat" +
	"orinternationalfirearmsalvadordalikescandyndns-at-homednsalzburg" +
	"minakamichigangwonishikatsuraginuyamanouchikuhokuryugasakitcheni" +
	"shikawazukanazawabrynewhampshirecreationishimerabuyshousesamegaw" +
	"abuzenishinomiyashironostrodabuzzgorabvalle-daostavernishinoomot" +
	"egostrolekaneyamazoevje-og-hornnesamnangerbwhoswholdingsmolangev" +
	"agrarboretumbriabzhitomirkutsklepparaglidingmodellingmxjeonnamer" +
	"ikawauexhibitionishinoshimacivilisationcivilizationcivilwarmiami" +
	"buildingrongaclaimsantacruzhgorodoyuzhno-sakhalinskautokeinostro" +
	"wwlkparochesterclickazimierz-dolnyclinicasertaishinomakikugawacl" +
	"intonoshoesantafederationclothingrossetouchijiwadellogliastrader" +
	"cloudcontrolledogawarabikomaezakirunore-og-uvdalukowilliamhillur" +
	"oycloudfrontariodejaneiromskoguchikuzencntgorycollectioncolleger" +
	"sundcolognewportlligatewaycolonialwilliamsburgroundhandlingrozny" +
	"coloradoplateaudnedalncolumbusantiquesanukis-a-conservativefsnil" +
	"lfjordcommunitydalustercomobaracompanycompute-1computerhistoryof" +
	"science-fictioncondoshibuyachtsaotomelbourneconferenceconstructi" +
	"onconsuladoomdnsaliascolipicenord-aurdalutskazoconsultanthropolo" +
	"gyconsultingvolluxembourgrpartis-a-cpaderborncontemporaryartgall" +
	"eryazanconagawakuyachimatainaikawababia-goracleaningruecontracto" +
	"rskenconventureshinodesashibetsuikinkobayashijonawatelevisioncoo" +
	"kinguitarsapporocoolbia-tempio-olbiatempioolbialystokkecoopoczno" +
	"rfolkebibleborkazunocopenhagencyclopedicasinordre-landyndns-pics" +
	"amsungqhachijorpelandyndns-remotegildeskalmykiacorporationcorvet" +
	"temasekchristiansburgujolstercosenzagannakadomari-elasticbeansta" +
	"lkgulencostumedio-campidano-mediocampidanomediocounciluxurycqldc" +
	"ranbrookuwanamizuhobby-sitexasiacreditcardsaratovalleaostavropol" +
	"icecremonashorokanaiecrewindmilluzerncrimeacrotonewspapercrsarde" +
	"gnaklodzkodairacruisesardiniacuisinellaakesvuemielecceculturalce" +
	"ntertainmentjeldsundcuneocupcakecxn--1qqw23afhskhabarovskhakassi" +
	"afhvalerfieldfiguerestaurantjomelhusgardenfilateliafilmemorialvi" +
	"valled-aostakazakis-a-democratoyonakagyokutomskharkivguernseyfin" +
	"ancefineartsarlfinlandfinnoyfirebaseappspotenzamamicrolightinguo" +
	"vdageaidnulvikharkovhachinohekinannestadfirenzefirmdalebtimnetzg" +
	"radfishingorgets-itoyonezawafitjarchitecturecipesaro-urbino-pesa" +
	"rourbinopesaromaizurubtsovskjaknoluoktaikicks-assedicateringebui" +
	"ldersanjournalismolenskatowicexpressexyzgorzeleccoldwarszawafitn" +
	"essettlementoyonofjalerdalflekkefjordflesbergushikamifuranoshiro" +
	"oflightsarpsborganicheltenham-radio-operaunitelekommunikationish" +
	"itosashimizunaminamibosohuissier-justiceflogisticsarufutsunomiya" +
	"wakasaikaitakoelnfloraflorencefloridafloristanohataiwanairforceo" +
	"flororoskoleclerchelyabinskodjeffersonidyndns-webhoparisor-froni" +
	"shiwakinvestmentsannanissanfranciscotlandyndns-wikirkenesannohem" +
	"bygdsforbundyndns-workshoparliamentateyamaflsmidthruhereggioemil" +
	"iaromagnakanotoddenflynnhubalsanagochihayaakasakawagoe164fndfoll" +
	"dalfoooshikamaishikshacknetoyookanzakiyokawarafor-better-thanawa" +
	"for-ourfor-somedizinhistorischesasayamafor-thedmarkhangelskherso" +
	"nforgotdnsaseboltoyosatonsbergwangjuifminamiechizenforli-cesena-" +
	"forlicesenaforlikes-piedmontblancashirehabikinokawairguardforsal" +
	"egnicagliaridagawawithgoogleapisa-hockeynutoyotaris-a-designerfo" +
	"rsandasuolocalhistoryfortmissoulan-udefenseljejuegoshikiminokamo" +
	"enaircraftoyotomiyazakis-a-doctorfortworthachiojiyaitakamatsukaw" +
	"aforuminamifuranofosnesaskatchewanfotoyotsukaidofredrikstadaokag" +
	"akiryuoharussiafreiburgxn--30rr7yfreightoyourafribourgzipartners" +
	"assaris-a-financialadvisor-aurdalfriuli-v-giuliafriuli-ve-giulia" +
	"friuli-vegiuliafriuli-venezia-giuliafriuli-veneziagiuliafriuli-v" +
	"giuliafriuliv-giuliafriulive-giuliafriulivegiuliafriulivenezia-g" +
	"iuliafriuliveneziagiuliafriulivgiuliafrlfrogansatxn--3bst00minam" +
	"iiserniafrognfrolandfrom-akuneuesquarezzoologyeongnamegawakkanai" +
	"betsubamericanartanddesignieznodawaraholtalendoftheinternetcmwlo" +
	"clawekhmelnitskiyamashikokuchuofrom-alfrom-arqponfrom-azjetztoys" +
	"tre-slidrettozawafrom-cahcesuoloansnasaarlandfrom-coffeedbackhme" +
	"lnytskyivalledaostaketomisatomaritimekeepingfrom-ctozsdefrom-dch" +
	"erkasydneyuzawafrom-degreefrom-flakstadtrainingfrom-gafrom-higas" +
	"hiagatsumagoizumizakisarazure-mobileikangerfrom-iafrom-idfrom-il" +
	"from-in-the-bandaiwafunefrom-ksaudafrom-kyotobetsumidatlanticher" +
	"nigovernmentatsunostrowiecartierfrom-lajollanbibaidarfrom-maniwa" +
	"kuratextileirfjordfrom-mdfrom-meeresauheradfrom-midoris-a-geekhv" +
	"allee-aosteroyfrom-mnfrom-modalenfrom-msavannahgafrom-mtranarash" +
	"inofrom-nchernihivanovosibirskydivingretajimakanegasakitahiroshi" +
	"marburgrimstadyroyrviknakaniikawatanagurafrom-ndfrom-nefrom-nhkl" +
	"abusheyfrom-njevnakerfrom-nminamiizukamisunagawafrom-nvalleeaost" +
	"eigenfrom-nyfrom-ohdafrom-oketohmannosegawafrom-orfrom-pacifiche" +
	"rnivtsicilyngenissedalucaniafrom-praxis-a-anarchistoireisenfrom-" +
	"ris-a-greenfrom-schlesischesaves-the-whalessandria-trani-barlett" +
	"a-andriatranibarlettaandriafrom-sdfrom-tnfrom-txn--3ds443gfrom-u" +
	"tazunjargafrom-vacationsavonamsosnowiechernovtsykkylvenetoeiheij" +
	"is-a-candidatefrom-vtranbyfrom-wafrom-wielunnerfrom-wvanylvenice" +
	"from-wyfrosinonefrostalowa-wolawafroyahikobearalvahkikuchikumaga" +
	"yagawallonieruchomoscienceandindustrynfsteinkjerusalembetsukuis-" +
	"a-gurunsaitokuyamafujiiderafujikawaguchikonefujiminohkurafujinom" +
	"iyadafujiokayamansionsayokkaichirurgiens-dentisteschmidtre-gauld" +
	"alfujisatoshonairlinedre-eikerotikadenagaivuotnagaokakyotambadaj" +
	"ozorakkestadultrani-andria-barletta-trani-andriafujisawafujishir" +
	"oishidakabiratoridell-ogliastrakhanamigawafujiyoshidafukayabeard" +
	"udinkakamigaharafukuchiyamadafukudominichiryukyuragifudaigokasej" +
	"nynysabaerobaticartoonarteducationalchikugojomediafukuis-a-hard-" +
	"workerfukumitsukefukuokazakishiwadafukuroishigakisofukushimantov" +
	"adsoftwarendalenvikingatlantajimidsundfukusakisosakitagatajiris-" +
	"a-hunterfukuyamagatakahamanxn--3e0b707efunabashiriuchinadafunaga" +
	"takaharunzenfunahashikamiamakusatsumasendaisenfundaciofuoiskujit" +
	"awarafuosskoczoworse-thandafurniturepair-traffic-controlleyfurub" +
	"iraquarelleangaviikagaminogiessenglandfurudonostiafurukawaharafu" +
	"sogndalfussafetysneschoenbrunnfutabayamaguchinomigawafutboldlygo" +
	"ingnowhere-for-moregontrailroadfuttsurugashimaoris-a-knightrania" +
	"ndriabarlettatraniandriafvgfylkesbiblackfridayfyresdalhaldenhals" +
	"agamiharahammarfeastafricamerakershuscountryestateshinanomachipp" +
	"ubetsubetsugaruhrhamurakamigoris-a-liberalhandsondriohanggliding" +
	"hannanmokuizumodernhannoverhallanschweizminamiminowahanyuzenhapm" +
	"irumarnardalhappoutsystemscloudappasadenakhodkamogawahareidsberg" +
	"enharstadharvestcelebrationhasamarahasaminami-alpsiellakasamatsu" +
	"doosandnessjoenhasudahasvikmsciencecentersciencehistoryhatogayai" +
	"zuwakamatsubushikusakadogawahatoyamazakitakatakanezawahatsukaich" +
	"iharahattfjelldalhawaiijimarugame-hostinghayashimamotobungotakad" +
	"avvesiidazaifuchukotkakegawatchandclockokonoehazuminobusenetwork" +
	"angerhemnescientistordalhemsedalherokusslattuminamiogunionheroyh" +
	"igashichichibunkyonanaoshimabariaketrzynhigashihiroshimanehigash" +
	"iizumozakitamifunehigashikagawahigashikagurasoedahigashikawakita" +
	"aikitamotosumitakaginowaniigatakahashimamakitagawahigashikurumee" +
	"tranoyhigashimatsushimarumorimachidahigashimatsuyamakitaakitadai" +
	"toigawahigashimurayamalatvuopmihamadahigashinarusells-for-lesscr" +
	"apper-sitehigashinehigashiomihachimanagementransportrapaniiminam" +
	"iawajikis-a-libertarianhigashiosakasayamamotorcyclescrappinghiga" +
	"shishirakawamatakaokamikitayamatotakadahigashisumiyoshikawaminam" +
	"iaikitanakagusukumoduminamisanrikubetsupportravellinohigashitsun" +
	"otteroyhigashiurausukitashiobarahigashiyamatokoriyamanakakogawah" +
	"igashiyodogawahigashiyoshinogaris-a-linux-useranishiaritabashiib" +
	"ahccavuotnagasakikonaioirasebastopologyeonggiehtavuoatnagahamaro" +
	"ygardenebakkeshibechambagriculturennebudapest-a-la-maisondre-lan" +
	"dhiraizumisatohnoshoohirakatashinagawahiranairtraffichitachinaka" +
	"gawahirarahiratsukagawahirayakagehistorichouseserveftpassenger-a" +
	"ssociationhitachiomiyaginozawaonsenhitachiotagotembaixadahitoyos" +
	"himiharuslivinghistoryhitradinghjartdalhjelmelandholeckobierzyce" +
	"holidayhomelinuxn--45brj9chitosetogakushimotoganewmexicodynalias" +
	"coli-picenonoichikawamisatobishimallorcabbottattoolsztynsettlers" +
	"antabarbarahomessinashikitaurayasudahomeunixn--45q11chocolatelem" +
	"arkatsushikabeiarnrtaxis-a-catererhonefosservegame-servercellill" +
	"ehammerfest-le-patrondheiminamitanehongotsukitahatakahatakaishim" +
	"ofusagaeroclubindallaspeziahonjyoichiropractichofunatorissadonna" +
	"harimangonohejis-a-celticsfanisshingugehornindalhorsells-for-ust" +
	"karasjokolobrzegyptianpachigasakidservicesettsurgeonshalloffamel" +
	"dalhortendofinternetrdhoteledatabaseballangenhoyangerhoylandetro" +
	"itreehumanitiesevastopolevangerhurdalhurumajis-a-llamarylandhyog" +
	"oris-a-musicianhyugawaraiwatsukiyonoiwchoseikakudamatsuejgorajpn" +
	"jurkouhokutamakis-a-republicancerresearchaeologicaliforniakounos" +
	"unndalkouyamassa-carrara-massacarraramassabuskerudinewjerseykouz" +
	"ushimasudakozagawakozakis-a-rockstarachowicekrageroticampobassoc" +
	"iateshimojis-a-socialistmeincheonkrakowroclawtchoshibukawakrasno" +
	"yarskommunekredkristiansandefjordkristiansundkrodsheradkrokstade" +
	"lval-daostavalleykryminamiuonumatsumotofukekumatorinokumejimatsu" +
	"maebashikaois-a-soxfankumenanyokaichibaikaliszczytnord-odalkunis" +
	"akis-a-studentalkunitachiaraisaijoshkar-olapyatigorskomonokunito" +
	"migusukukis-a-teacherkassykunneppugliakunstsammlungkunstunddesig" +
	"nkureportrentino-sud-tirolkurgankurobelaudiokurogiminamiashigara" +
	"kuroisognekuromatsunaishobaraumagazinemurorankoshigayabukibichuo" +
	"zuwajimakurotakikawasakis-a-techietis-a-nursells-itrentino-a-adi" +
	"gekurskomorotsukamishihoronobeokaminokawanishiaizubangekushiroga" +
	"wakustanais-a-therapistoiakusupplieshimokawakutchannelkutnokuzba" +
	"ssnoasaikis-an-accountantsewritesthisblogspotrentino-aadigekuzum" +
	"akis-an-actorkvafjordkvalsundkvamsterdamberkeleykvanangenkvinesd" +
	"alkvinnheradkviteseidskogkvitsoykwtfastlykyowariasahikawamisconf" +
	"usedmishimatsusakahogithubusercontentrentino-sudtirolmissileirvi" +
	"konantanangermisugitokonamegatakasugais-an-artistjohnmitakeharam" +
	"itourisminamiyamashirokawanabelgorodeomitoyoakemiuramiyazurewebs" +
	"iteshikagamiishikarikaturindalmiyotamanomjondalenmonmouthadanota" +
	"ireschokoladenmonticellombardiamondshimokitayamamontrealestateof" +
	"delawaremarkermonza-brianzamonza-e-della-brianzamonzabrianzamonz" +
	"aebrianzamonzaedellabrianzamordoviajessheiminanomoriyamatsushige" +
	"moriyoshiokamitondabayashiogamagoriziamormoneymoroyamatsuuramort" +
	"gagemoscowwwmoseushistorymosjoenmoskeneshimonitayanagis-an-engin" +
	"eeringerikemosreggio-calabriamosshimonosekikawamosvikongsbergmov" +
	"aomoriguchiharambulancertificationmuenstermugivestbyklebesbyglan" +
	"dmuikamitsuemukochikushinonsennanbusinessebydgoszczecincinnative" +
	"americanantiqueshimosuwalkis-an-entertainermulhousembokumamotoya" +
	"materamolisellsyourhomeipharmacienshimotsukemunakatanemuncieszyn" +
	"muosattemurmanskongsvingermurotorcraftrentino-sued-tirolmusashim" +
	"urayamatsuzakis-bytomakomaibaramusashinoharamuseetrentino-suedti" +
	"rolmuseumverenigingmutsuzawamyphotoshibajddarchaeologymytis-a-bo" +
	"okkeepermincommbankomvuxn--4gbriminingphiladelphiaareadmyblogsit" +
	"ephilatelyphoenixn--54b7fta0cchoyodontexisteingeekatsuyamashikiy" +
	"osemitephotographysiopictetrentinoa-adigepictureshimotsumapiemon" +
	"tepilotshinichinanpinkoninjavaksdalpippupiszpharmacymruovattorne" +
	"yagawalesundpittsburghofauskedsmokorsetagayaseljordpizzapkonskow" +
	"olaquilarvikomitamamuraplanetariuminnesotaketakashimatsunoplanta" +
	"tionplantshinjournalistjordalshalsenplazaplchristmasakimobetsuwa" +
	"nouchikuseihichisobetsuldaluccapebretonamiastarnbergripescaravan" +
	"taaplomzaporizhzhiaplumbingpmnpodhaleitungsenpodlasiedlcepodzone" +
	"pohlpokerpolkowicepoltavaldaostathelleksvikonyvelodingenpomorzes" +
	"zowpordenoneporsangerporsanguidelmenhorstalbanswedenporsgrunnanp" +
	"osts-and-telecommunicationshinjukumanopoznanprdpreservationpresi" +
	"dioprincipeprivneprochowiceproductionshinkamigotoyohashimotokyot" +
	"angoprofcastresistancexposeducatorahimeshimageandsoundandvisioni" +
	"shiokoppegardyndns-serverbaniaprojectrentinoaadigepropertieshins" +
	"hinotsurgerypropertyumenpruszkowprzeworskogptzwpvtrentinoalto-ad" +
	"igepzqsldshisuifuelverumisakis-an-actresshakotankomaganeshitaram" +
	"ashizukuishimodateshizuokanonjis-into-animegurovnoshowashriramur" +
	"skiptveterinairebungoonomichinomiyakembuchikujobshinshirosienams" +
	"skoganeis-into-carsharis-a-painteractivegarsheis-a-nascarfansigd" +
	"alsimbirskooris-a-patsfansimple-urlsirdalslgbtrentinoaltoadigesl" +
	"upskopervikommunalforbundsnzsolarssonsolognesolundsolutionshinto" +
	"kushimasomasomnapleshintomikasaharasoosopotrentinos-tirolsor-oda" +
	"lsor-varangersorfoldsorreisahayakawakamiichikaiseiyokoshibahikar" +
	"iwanumatakayamasortlandsorumisasaguris-an-anarchistoricalsociety" +
	"svardosouthcarolinazawasouthwesterniikappulawysowaspace-to-renta" +
	"lshinyoshitomiokaniepcespbaltimore-og-romsdalimomasvuotnakatombe" +
	"tsupplyomitanobanazawaustraliagroks-theaternopilawakeisenbahnatu" +
	"ralhistorymuseumcenterhcloudcontrolappalace-burg12spiegelspjelka" +
	"vikoryolasitespydebergsrvareseminestorenburgstorfjordstpetersbur" +
	"gstuff-4-salewismillerstuttgartrentinostirolsurreysusakis-into-c" +
	"artoonsharpaviasusonosuzakanrasuzukanumazurysuzukis-into-gameshe" +
	"llaskoyabenord-fronsvalbardurbannefrankfurtrentinosud-tirolsveio" +
	"svelvikosaigawasvizzeraswidnicapetownswiebodzinderoyswinoujscien" +
	"ceandhistorysxn--55qw42gtromsokndaltrusteetrysilkosakaerodromede" +
	"cinemailtuis-lostfoldtulavagisketurystykarasjohkaminoyamatsuris-" +
	"not-certifiedtuscanytuvalle-aostationtverdalvaroyvbambleasecn-no" +
	"rth-1vchromedicalucernevdonskoseis-a-personaltrainervegaskvollve" +
	"nneslaskerveronaritakurashikis-savedverranversailleshiojirishiri" +
	"fujiedaversicherungvestfoldvestneshioyanagawavestre-slidreamhost" +
	"ershirahamatonbetsurgutsiracusaintlouis-a-bruinsfanvestre-totenr" +
	"is-slickomakizunokunimimatakasakiyosumypetsherbrookegawavestvago" +
	"yvevelstadvibo-valentiavibovalentiavideovillasmatartcenterprises" +
	"akijoburgvinnicapitalvinnytsiavirginiavirtualvirtuelviterbolzano" +
	"rdlandvladikavkazanvladimirvladivostokaizukarasuyamasfjordenvlog" +
	"voldavolgogradvolkenkunderseaportrentinosued-tirolvologdanskoshi" +
	"mizumakis-a-photographermesaverdevolyngdalvoronezhytomyrvossevan" +
	"genvotevotingvotottoris-uberleetrentino-altoadigevrnxn--80adxhks" +
	"hirakoenigxn--80ao21axn--80asehdbarcelonagasukesennumalvikarpacz" +
	"eladz-1xn--80aswgxn--80augustowadaejeonbukoshunantokashikis-a-pl" +
	"ayerxn--90a3academykolaivano-frankivskiervaapsteiermarkostromaha" +
	"borovigorlicexn--90azhadselfipartscholarshipschoolkuszlgxn--9dbh" +
	"blg6dielddanuorrittogitsuliguriaxn--9et52uxn--andy-iraxn--aropor" +
	"t-byanaizuxn--asky-iraxn--aurskog-hland-jnbargainstitutechnology" +
	"onabarudmurtiaustrheimatunduhrennesoyokosukareliaquariumbone12xn" +
	"--avery-yuasakakinokis-very-badaddjamisongdalenxn--b-5gaxn--b4w6" +
	"05ferdxn--bdddj-mrabdxn--bearalvhki-y4axn--berlevg-jxaxn--bhcavu" +
	"otna-s4axn--bhccavuotna-k7axn--bidr-5nachikatsuuraxn--bievt-0qax" +
	"n--bjarky-fyandexeterxn--bjddar-ptakkofuefukihabmerxn--blt-elabo" +
	"rxn--bmlo-grajewolominamatakinouexn--bod-2naroyxn--brnny-wuaccid" +
	"ent-investigationjukudoyamaceratabuseat-band-campaniamallamadrid" +
	"vagsoyerimo-i-ranaamesjevuemielnoboribetsuitachikawakayamagadanc" +
	"echirealtorlandxn--brnnysund-m8accident-preventionlinebraskaunbi" +
	"eidsvollxn--brum-voagatrentinosuedtirolxn--btsfjord-9zaxn--c1avg" +
	"xn--cg4bkis-very-evillagentshimoichinosekigaharaxn--ciqpnxn--clc" +
	"hc0ea0b2g2a9gcdxn--comunicaes-v6a2oxn--correios-e-telecomunicaes" +
	"-ghc29axn--czr694barreauctionatuurwetenschappenaumburgjerdrumelo" +
	"yalistor-elvdalindaskimitsubatamiasakuchinotsuchiurakawalbrzycha" +
	"mpionshiphopenair-surveillancebinorilskaruizawauthordalandroidir" +
	"ectorybnikahokutogoppdalimanowarudastronomyokohamamatsudaeguball" +
	"ooningdyniaeroportalaheadjudygarlandgcadaques3-ap-northeast-1xn-" +
	"-czrs0trentoshimaxn--czru2dxn--czrw28barrel-of-knowledgemologica" +
	"ltanissettaipeigersundnipropetrovskarumaintenancebizenakanojohan" +
	"amakinoharautomotivelandiscountysfjordiscoveryggeelvinckariyalta" +
	"ijibestadivtasvuodnakamagayahabaghdadivttasvuotnakamurataitogura" +
	"ukraanghkemerovodkagoshimalopolskanlandiethnologyekaterinburggfa" +
	"rmerseinexusdecorativearts3-ap-southeast-1xn--d1acj3barrell-of-k" +
	"nowledgeologyonagoyautoscanadagestangeiseiroumuencheniwaizumiots" +
	"ukumiyamazonaws3-eu-west-1xn--d1atrevisokanoyakutiaxn--davvenjrg" +
	"a-y4axn--dnna-grandrapidshiranukanmakiwienxn--drbak-wuaxn--dyry-" +
	"iraxn--efvy88haebaruminamimakis-a-landscaperugiaxn--eveni-0qa01g" +
	"axn--finny-yuaxn--fiq228c5hshiraois-certifiedunetnedalxn--fiq64b" +
	"ashkiriavocatanzaroweddingjemnes3-fips-us-gov-west-1xn--fiqs8shi" +
	"raokannamilanoxn--fiqz9shiratakahagis-foundationxn--fjord-lraxn-" +
	"-fjq720axn--fl-ziaxn--flor-jraxn--flw351exn--fpcrj9c3dxn--frde-g" +
	"ranexn--frna-woarais-very-gooddaxn--frya-hraxn--fzc2c9e2chtraeum" +
	"tgeradeatnurembergroks-thisayamanashichikashukujukuriyamarcheapa" +
	"rmaxn--gecrj9chungbukaufenrwildlifedjelenia-goraxn--ggaviika-8ya" +
	"47hagaxn--gildeskl-g0axn--givuotna-8yaotsurnadalxn--gjvik-wuaxn-" +
	"-gls-elacaixaxn--gmq050is-very-nicexn--gmqw5axn--h-2familyxn--h1" +
	"aeghagebostadxn--h2brj9chungnamdalseidfjordxn--hbmer-xqaxn--hces" +
	"uolo-7ya35basilicataniavouest-mon-blogueurovisionaturbruksgymnat" +
	"urhistorisches3-sa-east-1xn--hery-iraxn--hgebostad-g3axn--hmmrfe" +
	"asta-s4achurcharterxn--hnefoss-q1axn--hobl-iraxn--holtlen-hxaxn-" +
	"-hpmir-xqaxn--hxt814exn--hyanger-q1axn--hylandet-54axn--i1b6b1a6" +
	"a2exn--indery-fyaroslavlaanderenxn--io0a7is-very-sweetrentino-s-" +
	"tirollagrigentomologyeongbukomatsushimasoyxn--j1amhaibarakitakam" +
	"iizumisanoksneschulelxn--j6w193gxn--jlster-byasakaiminatoyakokam" +
	"isatohokkaidovre-eikerxn--jrpeland-54axn--karmy-yuaxn--kfjord-iu" +
	"axn--klbu-woaxn--koluokta-7ya57hakatanotogawaxn--kprw13dxn--kpry" +
	"57dxn--kput3is-with-thebandoxn--krager-gyasugisleofmanchesterxn-" +
	"-kranghke-b0axn--krdsherad-m8axn--krehamn-dxaxn--krjohka-hwab49j" +
	"ewelryxn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-fyasuokaratexn--kvn" +
	"angen-k0axn--l-1fareastcoastaldefencexn--l1accentureklamusementr" +
	"oandinosaurexn--laheadju-7yatominamidaitomandalxn--langevg-jxaxn" +
	"--lcvr32dxn--ldingen-q1axn--leagaviika-52batochigifts3-us-gov-we" +
	"st-1xn--lesund-huaxn--lgbbat1ad8jewishartrentino-stirolxn--lgrd-" +
	"poachuvashiaxn--lhppi-xqaxn--linds-pratoyokawaxn--lns-qlavangenx" +
	"n--loabt-0qaxn--lrdal-sraxn--lrenskog-54axn--lt-liacimperiaxn--l" +
	"ten-granvindafjordxn--lury-iraxn--mely-iraxn--merker-kuaxn--mgb2" +
	"ddeshishikuis-gonexn--mgb9awbfermochizukirovogradoyxn--mgba3a4f1" +
	"6axn--mgba3a4franarusawaxn--mgbaam7a8hakodatexn--mgbab2bdxn--mgb" +
	"ayh7gpaduaxn--mgbbh1a71exn--mgbc0a9azcgxn--mgberp4a5d4a87gxn--mg" +
	"berp4a5d4arxn--mgbqly7c0a67fbcngxn--mgbqly7cvafranziskanerimarin" +
	"exn--mgbtf8flandershisojaworznoxn--mgbx4cd0abogadoes-itrogstadxn" +
	"--mjndalen-64axn--mk0axisshikiwakunigamihoboleslawiechonangoogle" +
	"codespotaruis-a-chefashioniyodogawaxn--mlatvuopmi-s4axn--mli-tla" +
	"zioxn--mlselv-iuaxn--moreke-juaxn--mori-qsakatakatsukissmarterth" +
	"anyouthachirogatakamoriokamchatkameokameyamashinatsukigatakanabe" +
	"dzin-addrammenuernbergxn--mosjen-eyatsukaratsuginamikatagamilita" +
	"ryxn--mot-tlaxn--mre-og-romsdal-qqbatsfjordnpalanakayamatta-varj" +
	"jatarantomobeneventochiokinoshimamurogawashingtondcarbonia-igles" +
	"ias-carboniaiglesiascarboniaxaurskog-holandebudejjuedischesapeak" +
	"ebayerndigitalillesandiegovtambovalle-d-aostavangerxn--msy-ula0h" +
	"akonexn--mtta-vrjjat-k7aferraraxn--muost-0qaxn--mxtq1misawaxn--n" +
	"gbc5azdxn--nmesjevuemie-tcbalestrandabergamoarekepnorddalxn--nnx" +
	"388axn--nodessakegawaxn--nqv7fs00emaxn--nry-yla5gxn--nttery-byae" +
	"seoullensvangxn--nvuotna-hwaxn--o1achattanooganordreisa-geekosug" +
	"exn--o3cw4hakubanxn--od0algxn--od0aq3bauhaustevollindesnes3-us-w" +
	"est-1xn--ogbpf8flatangerxn--oppegrd-ixaxn--ostery-fyatsushiroxn-" +
	"-osyro-wuaxn--p1acfailxn--p1aiwatarailwayxn--pgbs0dhakuis-a-lawy" +
	"erxn--porsgu-sta26fetsundxn--q9jyb4circuscultureggio-emilia-roma" +
	"gnakaiwamizawaxn--qcka1pmciticasadelamonedaxn--rady-iraxn--rdal-" +
	"poaxn--rde-ulaxn--rdy-0nabariwatexn--rennesy-v1axn--rhkkervju-01" +
	"afgunmaritimodenakasatsunairportland-4-salernogatagajobojis-a-cu" +
	"bicle-slaveroykenxn--rholt-mragoworldxn--rhqv96gxn--risa-5naruto" +
	"korozawaxn--risr-iraxn--rland-uuaxn--rlingen-mxaxn--rmskog-byawa" +
	"raxn--rros-gratangenxn--rskog-uuaxn--rst-0narviikanagawaxn--rsta" +
	"-francaiseharaxn--ryken-vuaxn--ryrvik-byawatahamaxn--s-1farmequi" +
	"pmentromsaitamatsukuris-leetrentino-alto-adigexn--s9brj9citychyl" +
	"lestadxn--sandnessjen-ogbizhevskotohiradomainsurancexn--sandy-yu" +
	"axn--seral-lraxn--ses554gxn--sgne-gratis-a-bulls-fanxn--skierv-u" +
	"tazasnesoddenmarketplacexn--skjervy-v1axn--skjk-soaxn--sknit-yqa" +
	"xn--sknland-fxaxn--slat-5narvikotouraxn--slt-elabourxn--smla-hra" +
	"xn--smna-grazxn--snase-nraxn--sndre-land-0cbnlxn--snes-poaxn--sn" +
	"sa-roaxn--sr-aurdal-l8axn--sr-fron-q1axn--sr-odal-q1axn--sr-vara" +
	"nger-ggberlincolnaustdalinkasaokamiokamiminers3-us-west-2xn--srf" +
	"old-byaxn--srreisa-q1axn--srum-graxn--stfold-9xaxn--stjrdal-s1ax" +
	"n--stjrdalshalsen-sqbernuorokunohealthcareersvpaleobihirosakikam" +
	"ijimaxn--stre-toten-zcbeskidyn-o-saurlandes3-website-ap-northeas" +
	"t-1xn--tjme-hraxn--tn0agrinetbankzxn--tnsberg-q1axn--trany-yuaxn" +
	"--trgstad-r1axn--trna-woaxn--troms-zuaxn--tysvr-vraxn--uc0atvede" +
	"strandxn--uc0ay4axn--unjrga-rtamayufuettertdasnetzxn--unup4yxn--" +
	"vads-jraxn--vard-jraxn--vegrshei-c0axn--vermgensberater-ctbetain" +
	"aboxfordealstahaugesundpalermombetsurfarmsteadrangedalinzaibigaw" +
	"axn--vermgensberatung-pwbhartipscbgjerstadotsuruginankokubunjibm" +
	"drobakrehamnaval-d-aosta-valleyonaguniversityoriikashibatakasago" +
	"uvicenzaporizhzheguriheyakumoldepotherokuappalmspringsakerxn--ve" +
	"stvgy-ixa6oxn--vg-yiabruzzoologicalabamagasakishimabarahkkeravju" +
	"daicaarborteaches-yogasawaragusartsaritsynxn--vgan-qoaxn--vgsy-q" +
	"oa0jfkomforbalsfjordlugolekaluganskarlsoyokotebetsukubahcavuotna" +
	"garavennagareyamalselvendrellimitednepropetrovskarmoyokozebinagi" +
	"sodegauraustinnaturalsciencesnaturelles3-ap-southeast-2xn--vhquv" +
	"arggatrentinosudtirolxn--vler-qoaxn--vre-eiker-k8axn--vrggt-xqad" +
	"xn--vry-yla5gxn--wcvs22dxn--wgbh1civilaviationxn--wgbl6axn--xhq5" +
	"21bielawassamukawatarikuzentakatairaxn--xkc2al3hye2axn--xkc2dl3a" +
	"5ee0hakusandoyxn--yer-znasushiobaraxn--yfro4i67oxn--ygarden-p1ax" +
	"n--ygbi2ammxn--55qx5dxn--ystre-slidre-ujbiella-speziaxn--zf0ao64" +
	"axn--zf0avxn--6frz82gxn--zfr164bieszczadygeyachiyodatsunanjoetsu" +
	"rutaharaxxxn--6qq986b3xlxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x002a09c6, // n0x0000 c0x0000 (---------------)  + I abbott
	0x0033eac7, // n0x0001 c0x0000 (---------------)  + I abogado
	0x01a01d82, // n0x0002 c0x0006 (n0x0333-n0x0339)  + I ac
	0x002fe307, // n0x0003 c0x0000 (---------------)  + I academy
	0x00333ac9, // n0x0004 c0x0000 (---------------)  + I accenture
	0x002b83cb, // n0x0005 c0x0000 (---------------)  + I accountants
	0x002df886, // n0x0006 c0x0000 (---------------)  + I active
	0x00237f05, // n0x0007 c0x0000 (---------------)  + I actor
	0x01e08902, // n0x0008 c0x0007 (n0x0339-n0x033a)  + I ad
	0x022100c2, // n0x0009 c0x0008 (n0x033a-n0x0341)  + I ae
	0x0267a1c4, // n0x000a c0x0009 (n0x0341-n0x039a)  + I aero
	0x02a18302, // n0x000b c0x000a (n0x039a-n0x039f)  + I af
	0x00284506, // n0x000c c0x0000 (---------------)  + I africa
	0x02e00482, // n0x000d c0x000b (n0x039f-n0x03a4)  + I ag
	0x0023a686, // n0x000e c0x0000 (---------------)  + I agency
	0x032135c2, // n0x000f c0x000c (n0x03a4-n0x03a8)  + I ai
	0x0024cdc8, // n0x0010 c0x0000 (---------------)  + I airforce
	0x03602082, // n0x0011 c0x000d (n0x03a8-n0x03ae)  + I al
	0x0021d009, // n0x0012 c0x0000 (---------------)  + I allfinanz
	0x00202806, // n0x0013 c0x0000 (---------------)  + I alsace
	0x00200282, // n0x0014 c0x0000 (---------------)  + I am
	0x002b97c9, // n0x0015 c0x0000 (---------------)  + I amsterdam
	0x03a00202, // n0x0016 c0x000e (n0x03ae-n0x03b2)  + I an
	0x00310dc7, // n0x0017 c0x0000 (---------------)  + I android
	0x03e04382, // n0x0018 c0x000f (n0x03b2-n0x03b8)  + I ao
	0x00280082, // n0x0019 c0x0000 (---------------)  + I aq
	0x00280089, // n0x001a c0x0000 (---------------)  + I aquarelle
	0x04200a42, // n0x001b c0x0010 (n0x03b8-n0x03c1)  + I ar
	0x00246805, // n0x001c c0x0000 (---------------)  + I archi
	0x0032eac4, // n0x001d c0x0000 (---------------)  + I army
	0x04aeb204, // n0x001e c0x0012 (n0x03c2-n0x03c8)  + I arpa
	0x04e00902, // n0x001f c0x0013 (n0x03c8-n0x03c9)  + I as
	0x0023e704, // n0x0020 c0x0000 (---------------)  + I asia
	0x002aceca, // n0x0021 c0x0000 (---------------)  + I associates
	0x05200102, // n0x0022 c0x0014 (n0x03c9-n0x03d0)  + I at
	0x002cfe48, // n0x0023 c0x0000 (---------------)  + I attorney
	0x05a07ec2, // n0x0024 c0x0016 (n0x03d1-n0x03e3)  + I au
	0x0030e587, // n0x0025 c0x0000 (---------------)  + I auction
	0x002b39c5, // n0x0026 c0x0000 (---------------)  + I audio
	0x003194c5, // n0x0027 c0x0000 (---------------)  + I autos
	0x06a00502, // n0x0028 c0x001a (n0x03f1-n0x03f2)  + I aw
	0x0026d8c2, // n0x0029 c0x0000 (---------------)  + I ax
	0x003466c3, // n0x002a c0x0000 (---------------)  + I axa
	0x06e034c2, // n0x002b c0x001b (n0x03f2-n0x03fe)  + I az
	0x07201902, // n0x002c c0x001c (n0x03fe-n0x0408)  + I ba
	0x00265304, // n0x002d c0x0000 (---------------)  + I band
	0x0020d2c3, // n0x002e c0x0000 (---------------)  + I bar
	0x002fc809, // n0x002f c0x0000 (---------------)  + I barcelona
	0x00301a88, // n0x0030 c0x0000 (---------------)  + I bargains
	0x0034c947, // n0x0031 c0x0000 (---------------)  + I bauhaus
	0x00347046, // n0x0032 c0x0000 (---------------)  + I bayern
	0x07616e42, // n0x0033 c0x001d (n0x0408-n0x0412)  + I bb
	0x0033d703, // n0x0034 c0x0000 (---------------)  + I bcn
	0x01704282, // n0x0035 c0x0005 (---------------)* o I bd
	0x07a00e82, // n0x0036 c0x001e (n0x0412-n0x0414)  + I be
	0x002076c4, // n0x0037 c0x0000 (---------------)  + I beer
	0x0035e1c6, // n0x0038 c0x0000 (---------------)  + I berlin
	0x003160c4, // n0x0039 c0x0000 (---------------)  + I best
	0x07f3a702, // n0x003a c0x001f (n0x0414-n0x0415)  + I bf
	0x08367842, // n0x003b c0x0020 (n0x0415-n0x0439)  + I bg
	0x0864dc02, // n0x003c c0x0021 (n0x0439-n0x043e)  + I bh
	0x00367606, // n0x003d c0x0000 (---------------)  + I bharti
	0x08a00002, // n0x003e c0x0022 (n0x043e-n0x0443)  + I bi
	0x0023a185, // n0x003f c0x0000 (---------------)  + I bible
	0x003057c3, // n0x0040 c0x0000 (---------------)  + I bid
	0x00202484, // n0x0041 c0x0000 (---------------)  + I bike
	0x002063c3, // n0x0042 c0x0000 (---------------)  + I bio
	0x08f14c43, // n0x0043 c0x0023 (n0x0443-n0x044a)  + I biz
	0x0920e2c2, // n0x0044 c0x0024 (n0x044a-n0x044e)  + I bj
	0x002838c5, // n0x0045 c0x0000 (---------------)  + I black
	0x002838cb, // n0x0046 c0x0000 (---------------)  + I blackfriday
	0x0020f909, // n0x0047 c0x0000 (---------------)  + I bloomberg
	0x00210744, // n0x0048 c0x0000 (---------------)  + I blue
	0x096109c2, // n0x0049 c0x0025 (n0x044e-n0x0453)  + I bm
	0x002109c3, // n0x004a c0x0000 (---------------)  + I bmw
	0x01611442, // n0x004b c0x0005 (---------------)* o I bn
	0x0035cac3, // n0x004c c0x0000 (---------------)  + I bnl
	0x0021144a, // n0x004d c0x0000 (---------------)  + I bnpparibas
	0x09a00fc2, // n0x004e c0x0026 (n0x0453-n0x045c)  + I bo
	0x002121c4, // n0x004f c0x0000 (---------------)  + I bond
	0x002cbf83, // n0x0050 c0x0000 (---------------)  + I boo
	0x00215a48, // n0x0051 c0x0000 (---------------)  + I boutique
	0x09e06842, // n0x0052 c0x0027 (n0x045c-n0x04a2)  + I br
	0x002210c8, // n0x0053 c0x0000 (---------------)  + I brussels
	0x0a605ec2, // n0x0054 c0x0029 (n0x04a3-n0x04a8)  + I bs
	0x0aa45dc2, // n0x0055 c0x002a (n0x04a8-n0x04ad)  + I bt
	0x0029a948, // n0x0056 c0x0000 (---------------)  + I budapest
	0x0022c005, // n0x0057 c0x0000 (---------------)  + I build
	0x00247f48, // n0x0058 c0x0000 (---------------)  + I builders
	0x002c6848, // n0x0059 c0x0000 (---------------)  + I business
	0x00228744, // n0x005a c0x0000 (---------------)  + I buzz
	0x00228942, // n0x005b c0x0000 (---------------)  + I bv
	0x0ae29a82, // n0x005c c0x002b (n0x04ad-n0x04af)  + I bw
	0x0b224042, // n0x005d c0x002c (n0x04af-n0x04b3)  + I by
	0x0b62a402, // n0x005e c0x002d (n0x04b3-n0x04b9)  + I bz
	0x0022a403, // n0x005f c0x0000 (---------------)  + I bzh
	0x0ba0bc02, // n0x0060 c0x002e (n0x04b9-n0x04ca)  + I ca
	0x002a0983, // n0x0061 c0x0000 (---------------)  + I cab
	0x0020bc03, // n0x0062 c0x0000 (---------------)  + I cal
	0x00284606, // n0x0063 c0x0000 (---------------)  + I camera
	0x0023d484, // n0x0064 c0x0000 (---------------)  + I camp
	0x002aa6ce, // n0x0065 c0x0000 (---------------)  + I cancerresearch
	0x002ed748, // n0x0066 c0x0000 (---------------)  + I capetown
	0x002f7387, // n0x0067 c0x0000 (---------------)  + I capital
	0x002d3e47, // n0x0068 c0x0000 (---------------)  + I caravan
	0x0023e985, // n0x0069 c0x0000 (---------------)  + I cards
	0x00360984, // n0x006a c0x0000 (---------------)  + I care
	0x00360986, // n0x006b c0x0000 (---------------)  + I career
	0x00360987, // n0x006c c0x0000 (---------------)  + I careers
	0x00266647, // n0x006d c0x0000 (---------------)  + I cartier
	0x00350744, // n0x006e c0x0000 (---------------)  + I casa
	0x00254804, // n0x006f c0x0000 (---------------)  + I cash
	0x00247d03, // n0x0070 c0x0000 (---------------)  + I cat
	0x00247d08, // n0x0071 c0x0000 (---------------)  + I catering
	0x00349643, // n0x0072 c0x0000 (---------------)  + I cba
	0x0035ca83, // n0x0073 c0x0000 (---------------)  + I cbn
	0x0be19f02, // n0x0074 c0x002f (n0x04ca-n0x04ce)  + I cc
	0x0c30d342, // n0x0075 c0x0030 (n0x04ce-n0x04cf)  + I cd
	0x00240f86, // n0x0076 c0x0000 (---------------)  + I center
	0x0024cf43, // n0x0077 c0x0000 (---------------)  + I ceo
	0x002f1484, // n0x0078 c0x0000 (---------------)  + I cern
	0x0c74e442, // n0x0079 c0x0031 (n0x04cf-n0x04d0)  + I cf
	0x0034e443, // n0x007a c0x0000 (---------------)  + I cfa
	0x002147c2, // n0x007b c0x0000 (---------------)  + I cg
	0x0ca00602, // n0x007c c0x0032 (n0x04d0-n0x04d1)  + I ch
	0x002b7bc7, // n0x007d c0x0000 (---------------)  + I channel
	0x00322e85, // n0x007e c0x0000 (---------------)  + I cheap
	0x002d2ac9, // n0x007f c0x0000 (---------------)  + I christmas
	0x002f1186, // n0x0080 c0x0000 (---------------)  + I chrome
	0x00329206, // n0x0081 c0x0000 (---------------)  + I church
	0x0ce18c02, // n0x0082 c0x0033 (n0x04d1-n0x04e0)  + I ci
	0x00350645, // n0x0083 c0x0000 (---------------)  + I citic
	0x00357e04, // n0x0084 c0x0000 (---------------)  + I city
	0x0d200882, // n0x0085 c0x0034 (n0x04e0-n0x04e1)* o I ck
	0x0d6007c2, // n0x0086 c0x0035 (n0x04e1-n0x04e5)  + I cl
	0x0022c346, // n0x0087 c0x0000 (---------------)  + I claims
	0x00237b08, // n0x0088 c0x0000 (---------------)  + I cleaning
	0x0022d3c5, // n0x0089 c0x0000 (---------------)  + I click
	0x0022d886, // n0x008a c0x0000 (---------------)  + I clinic
	0x0022e648, // n0x008b c0x0000 (---------------)  + I clothing
	0x002a4284, // n0x008c c0x0000 (---------------)  + I club
	0x0da5fec2, // n0x008d c0x0036 (n0x04e5-n0x04e9)  + I cm
	0x0de309c2, // n0x008e c0x0037 (n0x04e9-n0x0516)  + I cn
	0x0ea07a02, // n0x008f c0x003a (n0x0518-n0x0525)  + I co
	0x00340005, // n0x0090 c0x0000 (---------------)  + I codes
	0x00261c86, // n0x0091 c0x0000 (---------------)  + I coffee
	0x00230e07, // n0x0092 c0x0000 (---------------)  + I college
	0x00231107, // n0x0093 c0x0000 (---------------)  + I cologne
	0x0ee22603, // n0x0094 c0x003b (n0x0525-n0x05e8)  + I com
	0x002cc2c8, // n0x0095 c0x0000 (---------------)  + I commbank
	0x00233189, // n0x0096 c0x0000 (---------------)  + I community
	0x002337c7, // n0x0097 c0x0000 (---------------)  + I company
	0x00233bc8, // n0x0098 c0x0000 (---------------)  + I computer
	0x002343c6, // n0x0099 c0x0000 (---------------)  + I condos
	0x00234d8c, // n0x009a c0x0000 (---------------)  + I construction
	0x0023608a, // n0x009b c0x0000 (---------------)  + I consulting
	0x00237dcb, // n0x009c c0x0000 (---------------)  + I contractors
	0x00238f47, // n0x009d c0x0000 (---------------)  + I cooking
	0x00239404, // n0x009e c0x0000 (---------------)  + I cool
	0x00239dc4, // n0x009f c0x0000 (---------------)  + I coop
	0x00284947, // n0x00a0 c0x0000 (---------------)  + I country
	0x0fe18282, // n0x00a1 c0x003f (n0x0609-n0x0610)  + I cr
	0x0023e806, // n0x00a2 c0x0000 (---------------)  + I credit
	0x0023e80a, // n0x00a3 c0x0000 (---------------)  + I creditcard
	0x0023fe43, // n0x00a4 c0x0000 (---------------)  + I crs
	0x002403c7, // n0x00a5 c0x0000 (---------------)  + I cruises
	0x10240742, // n0x00a6 c0x0040 (n0x0610-n0x0616)  + I cu
	0x0024074a, // n0x00a7 c0x0000 (---------------)  + I cuisinella
	0x107350c2, // n0x00a8 c0x0041 (n0x0616-n0x0617)  + I cv
	0x10b4c1c2, // n0x00a9 c0x0042 (n0x0617-n0x061b)  + I cw
	0x10e41802, // n0x00aa c0x0043 (n0x061b-n0x061d)  + I cx
	0x0160c202, // n0x00ab c0x0005 (---------------)* o I cy
	0x002cfc85, // n0x00ac c0x0000 (---------------)  + I cymru
	0x11223342, // n0x00ad c0x0044 (n0x061d-n0x061e)  + I cz
	0x00220e45, // n0x00ae c0x0000 (---------------)  + I dabur
	0x00303783, // n0x00af c0x0000 (---------------)  + I dad
	0x00309f05, // n0x00b0 c0x0000 (---------------)  + I dance
	0x0021dfc6, // n0x00b1 c0x0000 (---------------)  + I dating
	0x00374c86, // n0x00b2 c0x0000 (---------------)  + I datsun
	0x00209ec3, // n0x00b3 c0x0000 (---------------)  + I day
	0x11602dc2, // n0x00b4 c0x0045 (n0x061e-n0x0626)  + I de
	0x003661c5, // n0x00b5 c0x0000 (---------------)  + I deals
	0x00263506, // n0x00b6 c0x0000 (---------------)  + I degree
	0x00243588, // n0x00b7 c0x0000 (---------------)  + I democrat
	0x002b1286, // n0x00b8 c0x0000 (---------------)  + I dental
	0x00275a47, // n0x00b9 c0x0000 (---------------)  + I dentist
	0x00255d84, // n0x00ba c0x0000 (---------------)  + I desi
	0x002bf708, // n0x00bb c0x0000 (---------------)  + I diamonds
	0x00317984, // n0x00bc c0x0000 (---------------)  + I diet
	0x003471c7, // n0x00bd c0x0000 (---------------)  + I digital
	0x00310f46, // n0x00be c0x0000 (---------------)  + I direct
	0x00310f49, // n0x00bf c0x0000 (---------------)  + I directory
	0x003155c8, // n0x00c0 c0x0000 (---------------)  + I discount
	0x0024d702, // n0x00c1 c0x0000 (---------------)  + I dj
	0x11a22c02, // n0x00c2 c0x0046 (n0x0626-n0x0627)  + I dk
	0x11e3f6c2, // n0x00c3 c0x0047 (n0x0627-n0x062c)  + I dm
	0x00344a83, // n0x00c4 c0x0000 (---------------)  + I dnp
	0x12207b82, // n0x00c5 c0x0048 (n0x062c-n0x0636)  + I do
	0x003589c7, // n0x00c6 c0x0000 (---------------)  + I domains
	0x00289006, // n0x00c7 c0x0000 (---------------)  + I doosan
	0x002ec686, // n0x00c8 c0x0000 (---------------)  + I durban
	0x00308fc4, // n0x00c9 c0x0000 (---------------)  + I dvag
	0x12608dc2, // n0x00ca c0x0049 (n0x0636-n0x063e)  + I dz
	0x0021b903, // n0x00cb c0x0000 (---------------)  + I eat
	0x12a079c2, // n0x00cc c0x004a (n0x063e-n0x064a)  + I ec
	0x0027a643, // n0x00cd c0x0000 (---------------)  + I edu
	0x0027a649, // n0x00ce c0x0000 (---------------)  + I education
	0x12e02d02, // n0x00cf c0x004b (n0x064a-n0x0654)  + I ee
	0x13208f82, // n0x00d0 c0x004c (n0x0654-n0x065d)  + I eg
	0x002ef0c5, // n0x00d1 c0x0000 (---------------)  + I email
	0x00207406, // n0x00d2 c0x0000 (---------------)  + I emerck
	0x002c3ec8, // n0x00d3 c0x0000 (---------------)  + I engineer
	0x002c3ecb, // n0x00d4 c0x0000 (---------------)  + I engineering
	0x002f6d4b, // n0x00d5 c0x0000 (---------------)  + I enterprises
	0x00356f09, // n0x00d6 c0x0000 (---------------)  + I equipment
	0x01604c02, // n0x00d7 c0x0005 (---------------)* o I er
	0x0020fc04, // n0x00d8 c0x0000 (---------------)  + I erni
	0x13601fc2, // n0x00d9 c0x004d (n0x065d-n0x0662)  + I es
	0x0025e7c3, // n0x00da c0x0000 (---------------)  + I esq
	0x00284b06, // n0x00db c0x0000 (---------------)  + I estate
	0x13e01642, // n0x00dc c0x004f (n0x0663-n0x066a)  + I et
	0x00210502, // n0x00dd c0x0000 (---------------)  + I eu
	0x003279ca, // n0x00de c0x0000 (---------------)  + I eurovision
	0x0021b383, // n0x00df c0x0000 (---------------)  + I eus
	0x00219746, // n0x00e0 c0x0000 (---------------)  + I events
	0x00223d48, // n0x00e1 c0x0000 (---------------)  + I everbank
	0x00208248, // n0x00e2 c0x0000 (---------------)  + I exchange
	0x00222406, // n0x00e3 c0x0000 (---------------)  + I expert
	0x002d9547, // n0x00e4 c0x0000 (---------------)  + I exposed
	0x0034e484, // n0x00e5 c0x0000 (---------------)  + I fail
	0x002a5683, // n0x00e6 c0x0000 (---------------)  + I fan
	0x00317f84, // n0x00e7 c0x0000 (---------------)  + I farm
	0x003404c7, // n0x00e8 c0x0000 (---------------)  + I fashion
	0x00261d48, // n0x00e9 c0x0000 (---------------)  + I feedback
	0x1421c5c2, // n0x00ea c0x0050 (n0x066a-n0x066d)  + I fi
	0x00243f47, // n0x00eb c0x0000 (---------------)  + I finance
	0x0025a289, // n0x00ec c0x0000 (---------------)  + I financial
	0x00245bc8, // n0x00ed c0x0000 (---------------)  + I firmdale
	0x002460c4, // n0x00ee c0x0000 (---------------)  + I fish
	0x002460c7, // n0x00ef c0x0000 (---------------)  + I fishing
	0x00248f07, // n0x00f0 c0x0000 (---------------)  + I fitness
	0x0161ec82, // n0x00f1 c0x0005 (---------------)* o I fj
	0x0176c102, // n0x00f2 c0x0005 (---------------)* o I fk
	0x0024a047, // n0x00f3 c0x0000 (---------------)  + I flights
	0x0024c947, // n0x00f4 c0x0000 (---------------)  + I florist
	0x0024fa88, // n0x00f5 c0x0000 (---------------)  + I flsmidth
	0x002504c3, // n0x00f6 c0x0000 (---------------)  + I fly
	0x00253942, // n0x00f7 c0x0000 (---------------)  + I fm
	0x0021c782, // n0x00f8 c0x0000 (---------------)  + I fo
	0x002510c3, // n0x00f9 c0x0000 (---------------)  + I foo
	0x00254e87, // n0x00fa c0x0000 (---------------)  + I forsale
	0x0031f98a, // n0x00fb c0x0000 (---------------)  + I foundation
	0x14612442, // n0x00fc c0x0051 (n0x066d-n0x0685)  + I fr
	0x0025d943, // n0x00fd c0x0000 (---------------)  + I frl
	0x0025da07, // n0x00fe c0x0000 (---------------)  + I frogans
	0x0027eb84, // n0x00ff c0x0000 (---------------)  + I fund
	0x0027f6c9, // n0x0100 c0x0000 (---------------)  + I furniture
	0x00281d46, // n0x0101 c0x0000 (---------------)  + I futbol
	0x002004c2, // n0x0102 c0x0000 (---------------)  + I ga
	0x002027c3, // n0x0103 c0x0000 (---------------)  + I gal
	0x00236f07, // n0x0104 c0x0000 (---------------)  + I gallery
	0x00203ac6, // n0x0105 c0x0000 (---------------)  + I garden
	0x0020fb02, // n0x0106 c0x0000 (---------------)  + I gb
	0x003585c4, // n0x0107 c0x0000 (---------------)  + I gbiz
	0x00210e82, // n0x0108 c0x0000 (---------------)  + I gd
	0x00210e83, // n0x0109 c0x0000 (---------------)  + I gdn
	0x14a02e82, // n0x010a c0x0052 (n0x0685-n0x068c)  + I ge
	0x0030c5c4, // n0x010b c0x0000 (---------------)  + I gent
	0x00262ac2, // n0x010c c0x0000 (---------------)  + I gf
	0x14e0bb02, // n0x010d c0x0053 (n0x068c-n0x068f)  + I gg
	0x00315b84, // n0x010e c0x0000 (---------------)  + I ggee
	0x15244e02, // n0x010f c0x0054 (n0x068f-n0x0694)  + I gh
	0x15601742, // n0x0110 c0x0055 (n0x0694-n0x069a)  + I gi
	0x00335c04, // n0x0111 c0x0000 (---------------)  + I gift
	0x00335c05, // n0x0112 c0x0000 (---------------)  + I gifts
	0x002c5b05, // n0x0113 c0x0000 (---------------)  + I gives
	0x0020cb42, // n0x0114 c0x0000 (---------------)  + I gl
	0x0020cb45, // n0x0115 c0x0000 (---------------)  + I glass
	0x0021c303, // n0x0116 c0x0000 (---------------)  + I gle
	0x00217cc6, // n0x0117 c0x0000 (---------------)  + I global
	0x0021cd05, // n0x0118 c0x0000 (---------------)  + I globo
	0x00222d42, // n0x0119 c0x0000 (---------------)  + I gm
	0x00222d45, // n0x011a c0x0000 (---------------)  + I gmail
	0x0022aac3, // n0x011b c0x0000 (---------------)  + I gmo
	0x0022ad03, // n0x011c c0x0000 (---------------)  + I gmx
	0x15a010c2, // n0x011d c0x0056 (n0x069a-n0x06a0)  + I gn
	0x00255586, // n0x011e c0x0000 (---------------)  + I google
	0x002d9083, // n0x011f c0x0000 (---------------)  + I gop
	0x002157c3, // n0x0120 c0x0000 (---------------)  + I gov
	0x15ecc942, // n0x0121 c0x0057 (n0x06a0-n0x06a6)  + I gp
	0x0023b142, // n0x0122 c0x0000 (---------------)  + I gq
	0x16205bc2, // n0x0123 c0x0058 (n0x06a6-n0x06ac)  + I gr
	0x00205bc8, // n0x0124 c0x0000 (---------------)  + I graphics
	0x00359886, // n0x0125 c0x0000 (---------------)  + I gratis
	0x0026e185, // n0x0126 c0x0000 (---------------)  + I green
	0x002d3cc5, // n0x0127 c0x0000 (---------------)  + I gripe
	0x002248c5, // n0x0128 c0x0000 (---------------)  + I group
	0x00229d82, // n0x0129 c0x0000 (---------------)  + I gs
	0x166ee5c2, // n0x012a c0x0059 (n0x06ac-n0x06b3)  + I gt
	0x01630742, // n0x012b c0x0005 (---------------)* o I gu
	0x002a58c4, // n0x012c c0x0000 (---------------)  + I guge
	0x002d66c5, // n0x012d c0x0000 (---------------)  + I guide
	0x002390c7, // n0x012e c0x0000 (---------------)  + I guitars
	0x00274084, // n0x012f c0x0000 (---------------)  + I guru
	0x00226382, // n0x0130 c0x0000 (---------------)  + I gw
	0x16a00d02, // n0x0131 c0x005a (n0x06b3-n0x06b6)  + I gy
	0x00203087, // n0x0132 c0x0000 (---------------)  + I hamburg
	0x0034ca04, // n0x0133 c0x0000 (---------------)  + I haus
	0x0036080a, // n0x0134 c0x0000 (---------------)  + I healthcare
	0x00201c04, // n0x0135 c0x0000 (---------------)  + I help
	0x0024fd04, // n0x0136 c0x0000 (---------------)  + I here
	0x002fa546, // n0x0137 c0x0000 (---------------)  + I hermes
	0x00310186, // n0x0138 c0x0000 (---------------)  + I hiphop
	0x002693c3, // n0x0139 c0x0000 (---------------)  + I hiv
	0x16e6af42, // n0x013a c0x005b (n0x06b6-n0x06cc)  + I hk
	0x00260182, // n0x013b c0x0000 (---------------)  + I hm
	0x1722c942, // n0x013c c0x005c (n0x06cc-n0x06d2)  + I hn
	0x00229c08, // n0x013d c0x0000 (---------------)  + I holdings
	0x0029f007, // n0x013e c0x0000 (---------------)  + I holiday
	0x002a12c5, // n0x013f c0x0000 (---------------)  + I homes
	0x002a5c05, // n0x0140 c0x0000 (---------------)  + I horse
	0x00209344, // n0x0141 c0x0000 (---------------)  + I host
	0x0028b887, // n0x0142 c0x0000 (---------------)  + I hosting
	0x00227d05, // n0x0143 c0x0000 (---------------)  + I house
	0x002ac983, // n0x0144 c0x0000 (---------------)  + I how
	0x17635e42, // n0x0145 c0x005d (n0x06d2-n0x06d6)  + I hr
	0x17a06f42, // n0x0146 c0x005e (n0x06d6-n0x06e7)  + I ht
	0x17e01e02, // n0x0147 c0x005f (n0x06e7-n0x0707)  + I hu
	0x00367f43, // n0x0148 c0x0000 (---------------)  + I ibm
	0x18202f82, // n0x0149 c0x0060 (n0x0707-n0x0712)  + I id
	0x18600042, // n0x014a c0x0061 (n0x0712-n0x0714)  + I ie
	0x00253903, // n0x014b c0x0000 (---------------)  + I ifm
	0x00201585, // n0x014c c0x0000 (---------------)  + I iinet
	0x18a03902, // n0x014d c0x0062 (n0x0714-n0x0715)* o I il
	0x192029c2, // n0x014e c0x0064 (n0x0716-n0x071d)  + I im
	0x0020e804, // n0x014f c0x0000 (---------------)  + I immo
	0x0020e80a, // n0x0150 c0x0000 (---------------)  + I immobilien
	0x19a015c2, // n0x0151 c0x0066 (n0x071f-n0x072c)  + I in
	0x0021aeca, // n0x0152 c0x0000 (---------------)  + I industries
	0x0021c548, // n0x0153 c0x0000 (---------------)  + I infiniti
	0x19e1c704, // n0x0154 c0x0067 (n0x072c-n0x0736)  + I info
	0x00201ec3, // n0x0155 c0x0000 (---------------)  + I ing
	0x002132c3, // n0x0156 c0x0000 (---------------)  + I ink
	0x00301bc9, // n0x0157 c0x0000 (---------------)  + I institute
	0x0021fac6, // n0x0158 c0x0000 (---------------)  + I insure
	0x1a223a83, // n0x0159 c0x0068 (n0x0736-n0x0737)  + I int
	0x0022508d, // n0x015a c0x0000 (---------------)  + I international
	0x0024e18b, // n0x015b c0x0000 (---------------)  + I investments
	0x1a603dc2, // n0x015c c0x0069 (n0x0737-n0x073a)  + I io
	0x00208508, // n0x015d c0x0000 (---------------)  + I ipiranga
	0x1aa06702, // n0x015e c0x006a (n0x073a-n0x0740)  + I iq
	0x1ae05302, // n0x015f c0x006b (n0x0740-n0x0749)  + I ir
	0x002f2e05, // n0x0160 c0x0000 (---------------)  + I irish
	0x1b2046c2, // n0x0161 c0x006c (n0x0749-n0x0750)  + I is
	0x0020dec3, // n0x0162 c0x0000 (---------------)  + I ist
	0x0020dec8, // n0x0163 c0x0000 (---------------)  + I istanbul
	0x1b6017c2, // n0x0164 c0x006d (n0x0750-n0x08c1)  + I it
	0x002a9903, // n0x0165 c0x0000 (---------------)  + I iwc
	0x002cf684, // n0x0166 c0x0000 (---------------)  + I java
	0x1ba01f82, // n0x0167 c0x006e (n0x08c1-n0x08c4)  + I je
	0x00260e05, // n0x0168 c0x0000 (---------------)  + I jetzt
	0x01762202, // n0x0169 c0x0005 (---------------)* o I jm
	0x1be03242, // n0x016a c0x006f (n0x08c4-n0x08cc)  + I jo
	0x002deb44, // n0x016b c0x0000 (---------------)  + I jobs
	0x002f70c6, // n0x016c c0x0000 (---------------)  + I joburg
	0x1c2a9f42, // n0x016d c0x0070 (n0x08cc-n0x090c)  + I jp
	0x00256b86, // n0x016e c0x0000 (---------------)  + I juegos
	0x00323506, // n0x016f c0x0000 (---------------)  + I kaufen
	0x01602502, // n0x0170 c0x0005 (---------------)* o I ke
	0x29e3d042, // n0x0171 c0x00a7 (n0x0fa0-n0x0fa6)  + I kg
	0x0160ad42, // n0x0172 c0x0005 (---------------)* o I kh
	0x2a201542, // n0x0173 c0x00a8 (n0x0fa6-n0x0fad)  + I ki
	0x00256d83, // n0x0174 c0x0000 (---------------)  + I kim
	0x00226e07, // n0x0175 c0x0000 (---------------)  + I kitchen
	0x0031b904, // n0x0176 c0x0000 (---------------)  + I kiwi
	0x2a689682, // n0x0177 c0x00a9 (n0x0fad-n0x0fbe)  + I km
	0x2aa1ce42, // n0x0178 c0x00aa (n0x0fbe-n0x0fc2)  + I kn
	0x0024c305, // n0x0179 c0x0000 (---------------)  + I koeln
	0x2ae2d0c2, // n0x017a c0x00ab (n0x0fc2-n0x0fc8)  + I kp
	0x2b20e742, // n0x017b c0x00ac (n0x0fc8-n0x0fe6)  + I kr
	0x00331443, // n0x017c c0x0000 (---------------)  + I krd
	0x002ae2c4, // n0x017d c0x0000 (---------------)  + I kred
	0x016ba802, // n0x017e c0x0005 (---------------)* o I kw
	0x2b613442, // n0x017f c0x00ad (n0x0fe6-n0x0feb)  + I ky
	0x2bb62802, // n0x0180 c0x00ae (n0x0feb-n0x0ff1)  + I kz
	0x2be04d02, // n0x0181 c0x00af (n0x0ff1-n0x0ffa)  + I la
	0x00325187, // n0x0182 c0x0000 (---------------)  + I lacaixa
	0x0023ac84, // n0x0183 c0x0000 (---------------)  + I land
	0x002228c7, // n0x0184 c0x0000 (---------------)  + I latrobe
	0x0034ef06, // n0x0185 c0x0000 (---------------)  + I lawyer
	0x2c204302, // n0x0186 c0x00b0 (n0x0ffa-n0x0fff)  + I lb
	0x2c60ed02, // n0x0187 c0x00b1 (n0x0fff-n0x1005)  + I lc
	0x00241383, // n0x0188 c0x0000 (---------------)  + I lds
	0x002f0d85, // n0x0189 c0x0000 (---------------)  + I lease
	0x0024d287, // n0x018a c0x0000 (---------------)  + I leclerc
	0x002e0a84, // n0x018b c0x0000 (---------------)  + I lgbt
	0x002020c2, // n0x018c c0x0000 (---------------)  + I li
	0x003237c4, // n0x018d c0x0000 (---------------)  + I life
	0x00244d88, // n0x018e c0x0000 (---------------)  + I lighting
	0x0036d707, // n0x018f c0x0000 (---------------)  + I limited
	0x002e6b04, // n0x0190 c0x0000 (---------------)  + I limo
	0x0035e5c4, // n0x0191 c0x0000 (---------------)  + I link
	0x2ca2d082, // n0x0192 c0x00b2 (n0x1005-n0x1013)  + I lk
	0x00261785, // n0x0193 c0x0000 (---------------)  + I loans
	0x00207ac6, // n0x0194 c0x0000 (---------------)  + I london
	0x00221b85, // n0x0195 c0x0000 (---------------)  + I lotto
	0x2ce82682, // n0x0196 c0x00b3 (n0x1013-n0x1018)  + I lr
	0x2d202842, // n0x0197 c0x00b4 (n0x1018-n0x101a)  + I ls
	0x2d620002, // n0x0198 c0x00b5 (n0x101a-n0x101b)  + I lt
	0x00223144, // n0x0199 c0x0000 (---------------)  + I ltda
	0x00202f02, // n0x019a c0x0000 (---------------)  + I lu
	0x002363c4, // n0x019b c0x0000 (---------------)  + I luxe
	0x0023dd46, // n0x019c c0x0000 (---------------)  + I luxury
	0x2da05002, // n0x019d c0x00b6 (n0x101b-n0x1024)  + I lv
	0x2de39bc2, // n0x019e c0x00b7 (n0x1024-n0x102d)  + I ly
	0x2e2002c2, // n0x019f c0x00b8 (n0x102d-n0x1033)  + I ma
	0x00308e86, // n0x01a0 c0x0000 (---------------)  + I madrid
	0x0029acc6, // n0x01a1 c0x0000 (---------------)  + I maison
	0x0029388a, // n0x01a2 c0x0000 (---------------)  + I management
	0x002a5105, // n0x01a3 c0x0000 (---------------)  + I mango
	0x00217ac6, // n0x01a4 c0x0000 (---------------)  + I market
	0x00217ac9, // n0x01a5 c0x0000 (---------------)  + I marketing
	0x2e6e83c2, // n0x01a6 c0x00b9 (n0x1033-n0x1035)  + I mc
	0x00235302, // n0x01a7 c0x0000 (---------------)  + I md
	0x2ea02a02, // n0x01a8 c0x00ba (n0x1035-n0x103d)  + I me
	0x0027ab45, // n0x01a9 c0x0000 (---------------)  + I media
	0x00290f44, // n0x01aa c0x0000 (---------------)  + I meet
	0x002348c9, // n0x01ab c0x0000 (---------------)  + I melbourne
	0x002073c4, // n0x01ac c0x0000 (---------------)  + I meme
	0x003432c4, // n0x01ad c0x0000 (---------------)  + I menu
	0x2ef39f02, // n0x01ae c0x00bb (n0x103d-n0x1045)  + I mg
	0x0022fe42, // n0x01af c0x0000 (---------------)  + I mh
	0x0022bec5, // n0x01b0 c0x0000 (---------------)  + I miami
	0x0023f703, // n0x01b1 c0x0000 (---------------)  + I mil
	0x002798c4, // n0x01b2 c0x0000 (---------------)  + I mini
	0x2f33f482, // n0x01b3 c0x00bc (n0x1045-n0x104c)  + I mk
	0x2f611ac2, // n0x01b4 c0x00bd (n0x104c-n0x1053)  + I ml
	0x0160e842, // n0x01b5 c0x0005 (---------------)* o I mm
	0x2fa298c2, // n0x01b6 c0x00be (n0x1053-n0x1057)  + I mn
	0x2fe06c42, // n0x01b7 c0x00bf (n0x1057-n0x105c)  + I mo
	0x0020e884, // n0x01b8 c0x0000 (---------------)  + I mobi
	0x00268684, // n0x01b9 c0x0000 (---------------)  + I moda
	0x00256f83, // n0x01ba c0x0000 (---------------)  + I moe
	0x0023f186, // n0x01bb c0x0000 (---------------)  + I monash
	0x00254609, // n0x01bc c0x0000 (---------------)  + I montblanc
	0x002c2986, // n0x01bd c0x0000 (---------------)  + I mormon
	0x002c2f08, // n0x01be c0x0000 (---------------)  + I mortgage
	0x002c3106, // n0x01bf c0x0000 (---------------)  + I moscow
	0x00294a4b, // n0x01c0 c0x0000 (---------------)  + I motorcycles
	0x002c4f43, // n0x01c1 c0x0000 (---------------)  + I mov
	0x00200182, // n0x01c2 c0x0000 (---------------)  + I mp
	0x00325482, // n0x01c3 c0x0000 (---------------)  + I mq
	0x302119c2, // n0x01c4 c0x00c0 (n0x105c-n0x105e)  + I mr
	0x30625542, // n0x01c5 c0x00c1 (n0x105e-n0x1063)  + I ms
	0x30a68d82, // n0x01c6 c0x00c2 (n0x1063-n0x1067)  + I mt
	0x30e14542, // n0x01c7 c0x00c3 (n0x1067-n0x106e)  + I mu
	0x312cb0c6, // n0x01c8 c0x00c4 (n0x106e-n0x1292)  + I museum
	0x31619242, // n0x01c9 c0x00c5 (n0x1292-n0x12a0)  + I mv
	0x31a10a02, // n0x01ca c0x00c6 (n0x12a0-n0x12ab)  + I mw
	0x31e2ad42, // n0x01cb c0x00c7 (n0x12ab-n0x12b1)  + I mx
	0x32208482, // n0x01cc c0x00c8 (n0x12b1-n0x12b8)  + I my
	0x326d4182, // n0x01cd c0x00c9 (n0x12b8-n0x12b9)* o I mz
	0x32a00242, // n0x01ce c0x00ca (n0x12b9-n0x12ca)  + I na
	0x00319386, // n0x01cf c0x0000 (---------------)  + I nagoya
	0x32e2aec4, // n0x01d0 c0x00cb (n0x12ca-n0x12cc)  + I name
	0x002056c4, // n0x01d1 c0x0000 (---------------)  + I navy
	0x33a0c1c2, // n0x01d2 c0x00ce (n0x12ce-n0x12cf)  + I nc
	0x00201602, // n0x01d3 c0x0000 (---------------)  + I ne
	0x33e01603, // n0x01d4 c0x00cf (n0x12cf-n0x12fe)  + I net
	0x00362687, // n0x01d5 c0x0000 (---------------)  + I netbank
	0x0028ce47, // n0x01d6 c0x0000 (---------------)  + I network
	0x0021b347, // n0x01d7 c0x0000 (---------------)  + I neustar
	0x0020b803, // n0x01d8 c0x0000 (---------------)  + I new
	0x003181c5, // n0x01d9 c0x0000 (---------------)  + I nexus
	0x34e09282, // n0x01da c0x00d3 (n0x1305-n0x130f)  + I nf
	0x35201f02, // n0x01db c0x00d4 (n0x130f-n0x1318)  + I ng
	0x00224203, // n0x01dc c0x0000 (---------------)  + I ngo
	0x0026af03, // n0x01dd c0x0000 (---------------)  + I nhk
	0x01604802, // n0x01de c0x0005 (---------------)* o I ni
	0x002cf5c5, // n0x01df c0x0000 (---------------)  + I ninja
	0x0024e546, // n0x01e0 c0x0000 (---------------)  + I nissan
	0x35644442, // n0x01e1 c0x00d5 (n0x1318-n0x131b)  + I nl
	0x35a01b82, // n0x01e2 c0x00d6 (n0x131b-n0x15f1)  + I no
	0x01605942, // n0x01e3 c0x0005 (---------------)* o I np
	0x3de12642, // n0x01e4 c0x00f7 (n0x1619-n0x1620)  + I nr
	0x002eb6c3, // n0x01e5 c0x0000 (---------------)  + I nra
	0x00323643, // n0x01e6 c0x0000 (---------------)  + I nrw
	0x3e2267c2, // n0x01e7 c0x00f8 (n0x1620-n0x1623)  + I nu
	0x00215183, // n0x01e8 c0x0000 (---------------)  + I nyc
	0x3e60b642, // n0x01e9 c0x00f9 (n0x1623-n0x1633)  + I nz
	0x0021e607, // n0x01ea c0x0000 (---------------)  + I okinawa
	0x3ee0f9c2, // n0x01eb c0x00fb (n0x1634-n0x163d)  + I om
	0x0022c243, // n0x01ec c0x0000 (---------------)  + I ong
	0x0030ac03, // n0x01ed c0x0000 (---------------)  + I onl
	0x00251103, // n0x01ee c0x0000 (---------------)  + I ooo
	0x00237a46, // n0x01ef c0x0000 (---------------)  + I oracle
	0x3f21f5c3, // n0x01f0 c0x00fc (n0x163d-n0x1672)  + I org
	0x0024a347, // n0x01f1 c0x0000 (---------------)  + I organic
	0x002589c6, // n0x01f2 c0x0000 (---------------)  + I otsuka
	0x00245483, // n0x01f3 c0x0000 (---------------)  + I ovh
	0x3fa001c2, // n0x01f4 c0x00fe (n0x1674-n0x167f)  + I pa
	0x0024dcc5, // n0x01f5 c0x0000 (---------------)  + I paris
	0x00259e08, // n0x01f6 c0x0000 (---------------)  + I partners
	0x002ff745, // n0x01f7 c0x0000 (---------------)  + I parts
	0x3fe02142, // n0x01f8 c0x00ff (n0x167f-n0x1686)  + I pe
	0x4034d302, // n0x01f9 c0x0100 (n0x1686-n0x1689)  + I pf
	0x01622d02, // n0x01fa c0x0005 (---------------)* o I pg
	0x40605c82, // n0x01fb c0x0101 (n0x1689-n0x1691)  + I ph
	0x002cfb08, // n0x01fc c0x0000 (---------------)  + I pharmacy
	0x002cb785, // n0x01fd c0x0000 (---------------)  + I photo
	0x002ce1cb, // n0x01fe c0x0000 (---------------)  + I photography
	0x002cb786, // n0x01ff c0x0000 (---------------)  + I photos
	0x002ce3c6, // n0x0200 c0x0000 (---------------)  + I physio
	0x0023af04, // n0x0201 c0x0000 (---------------)  + I pics
	0x002ce546, // n0x0202 c0x0000 (---------------)  + I pictet
	0x002cea48, // n0x0203 c0x0000 (---------------)  + I pictures
	0x002cf484, // n0x0204 c0x0000 (---------------)  + I pink
	0x002d0cc5, // n0x0205 c0x0000 (---------------)  + I pizza
	0x40ad0e02, // n0x0206 c0x0102 (n0x1691-n0x169f)  + I pk
	0x40e0bf42, // n0x0207 c0x0103 (n0x169f-n0x174a)  + I pl
	0x0020bf45, // n0x0208 c0x0000 (---------------)  + I place
	0x002d44c8, // n0x0209 c0x0000 (---------------)  + I plumbing
	0x00286f82, // n0x020a c0x0000 (---------------)  + I pm
	0x416a9f82, // n0x020b c0x0105 (n0x1753-n0x1758)  + I pn
	0x002d5004, // n0x020c c0x0000 (---------------)  + I pohl
	0x002d5105, // n0x020d c0x0000 (---------------)  + I poker
	0x002d6fc4, // n0x020e c0x0000 (---------------)  + I post
	0x41a487c2, // n0x020f c0x0106 (n0x1758-n0x1765)  + I pr
	0x0026d845, // n0x0210 c0x0000 (---------------)  + I praxi
	0x002487c5, // n0x0211 c0x0000 (---------------)  + I press
	0x41ed8443, // n0x0212 c0x0107 (n0x1765-n0x176c)  + I pro
	0x002d86c4, // n0x0213 c0x0000 (---------------)  + I prod
	0x002d86cb, // n0x0214 c0x0000 (---------------)  + I productions
	0x002d9104, // n0x0215 c0x0000 (---------------)  + I prof
	0x002dac8a, // n0x0216 c0x0000 (---------------)  + I properties
	0x002db308, // n0x0217 c0x0000 (---------------)  + I property
	0x42216282, // n0x0218 c0x0108 (n0x176c-n0x1773)  + I ps
	0x426226c2, // n0x0219 c0x0109 (n0x1773-n0x177c)  + I pt
	0x00200f43, // n0x021a c0x0000 (---------------)  + I pub
	0x42b67582, // n0x021b c0x010a (n0x177c-n0x1782)  + I pw
	0x42eb1ac2, // n0x021c c0x010b (n0x1782-n0x1789)  + I py
	0x43305f42, // n0x021d c0x010c (n0x1789-n0x1791)  + I qa
	0x00260b44, // n0x021e c0x0000 (---------------)  + I qpon
	0x00215b86, // n0x021f c0x0000 (---------------)  + I quebec
	0x436039c2, // n0x0220 c0x010d (n0x1791-n0x1795)  + I re
	0x0030a107, // n0x0221 c0x0000 (---------------)  + I realtor
	0x00246a87, // n0x0222 c0x0000 (---------------)  + I recipes
	0x0023e843, // n0x0223 c0x0000 (---------------)  + I red
	0x00254945, // n0x0224 c0x0000 (---------------)  + I rehab
	0x0026dd45, // n0x0225 c0x0000 (---------------)  + I reise
	0x0026dd46, // n0x0226 c0x0000 (---------------)  + I reisen
	0x002039c3, // n0x0227 c0x0000 (---------------)  + I ren
	0x002e5ec7, // n0x0228 c0x0000 (---------------)  + I rentals
	0x0027f886, // n0x0229 c0x0000 (---------------)  + I repair
	0x002b30c6, // n0x022a c0x0000 (---------------)  + I report
	0x002aa50a, // n0x022b c0x0000 (---------------)  + I republican
	0x00242484, // n0x022c c0x0000 (---------------)  + I rest
	0x0024248a, // n0x022d c0x0000 (---------------)  + I restaurant
	0x00222f47, // n0x022e c0x0000 (---------------)  + I reviews
	0x0029c984, // n0x022f c0x0000 (---------------)  + I rich
	0x00230343, // n0x0230 c0x0000 (---------------)  + I rio
	0x002d3d03, // n0x0231 c0x0000 (---------------)  + I rip
	0x43a00c02, // n0x0232 c0x010e (n0x1795-n0x17a1)  + I ro
	0x002ac705, // n0x0233 c0x0000 (---------------)  + I rocks
	0x002bd845, // n0x0234 c0x0000 (---------------)  + I rodeo
	0x43e0ac02, // n0x0235 c0x010f (n0x17a1-n0x17a7)  + I rs
	0x00360ac4, // n0x0236 c0x0000 (---------------)  + I rsvp
	0x4420c6c2, // n0x0237 c0x0110 (n0x17a7-n0x182b)  + I ru
	0x00285344, // n0x0238 c0x0000 (---------------)  + I ruhr
	0x4470e842, // n0x0239 c0x0111 (n0x182b-n0x1834)  + I rw
	0x00279a86, // n0x023a c0x0000 (---------------)  + I ryukyu
	0x44a02882, // n0x023b c0x0112 (n0x1834-n0x183c)  + I sa
	0x00261948, // n0x023c c0x0000 (---------------)  + I saarland
	0x0023afc7, // n0x023d c0x0000 (---------------)  + I samsung
	0x00239243, // n0x023e c0x0000 (---------------)  + I sap
	0x002442c4, // n0x023f c0x0000 (---------------)  + I sarl
	0x44e31a42, // n0x0240 c0x0113 (n0x183c-n0x1841)  + I sb
	0x45218bc2, // n0x0241 c0x0114 (n0x1841-n0x1846)  + I sc
	0x00225903, // n0x0242 c0x0000 (---------------)  + I sca
	0x003677c3, // n0x0243 c0x0000 (---------------)  + I scb
	0x00275c47, // n0x0244 c0x0000 (---------------)  + I schmidt
	0x002ff84c, // n0x0245 c0x0000 (---------------)  + I scholarships
	0x0032d386, // n0x0246 c0x0000 (---------------)  + I schule
	0x0024e844, // n0x0247 c0x0000 (---------------)  + I scot
	0x45602002, // n0x0248 c0x0115 (n0x1846-n0x184e)  + I sd
	0x45a06d42, // n0x0249 c0x0116 (n0x184e-n0x1877)  + I se
	0x003088c4, // n0x024a c0x0000 (---------------)  + I seat
	0x002a6888, // n0x024b c0x0000 (---------------)  + I services
	0x002b8643, // n0x024c c0x0000 (---------------)  + I sew
	0x002488c4, // n0x024d c0x0000 (---------------)  + I sexy
	0x45e03a82, // n0x024e c0x0117 (n0x1877-n0x187e)  + I sg
	0x46200942, // n0x024f c0x0118 (n0x187e-n0x1883)  + I sh
	0x002eb185, // n0x0250 c0x0000 (---------------)  + I sharp
	0x002513c7, // n0x0251 c0x0000 (---------------)  + I shiksha
	0x0022e185, // n0x0252 c0x0000 (---------------)  + I shoes
	0x002dddc7, // n0x0253 c0x0000 (---------------)  + I shriram
	0x00204682, // n0x0254 c0x0000 (---------------)  + I si
	0x0021c247, // n0x0255 c0x0000 (---------------)  + I singles
	0x00221882, // n0x0256 c0x0000 (---------------)  + I sj
	0x46602202, // n0x0257 c0x0119 (n0x1883-n0x1884)  + I sk
	0x00262103, // n0x0258 c0x0000 (---------------)  + I sky
	0x46a08e82, // n0x0259 c0x011a (n0x1884-n0x1889)  + I sl
	0x00229dc2, // n0x025a c0x0000 (---------------)  + I sm
	0x46e0dd82, // n0x025b c0x011b (n0x1889-n0x1890)  + I sn
	0x47206102, // n0x025c c0x011c (n0x1890-n0x1893)  + I so
	0x002ad3c6, // n0x025d c0x0000 (---------------)  + I social
	0x0027c088, // n0x025e c0x0000 (---------------)  + I software
	0x0024b584, // n0x025f c0x0000 (---------------)  + I sohu
	0x002e1705, // n0x0260 c0x0000 (---------------)  + I solar
	0x002e1c89, // n0x0261 c0x0000 (---------------)  + I solutions
	0x00214403, // n0x0262 c0x0000 (---------------)  + I soy
	0x002e5c85, // n0x0263 c0x0000 (---------------)  + I space
	0x002e8c87, // n0x0264 c0x0000 (---------------)  + I spiegel
	0x002c4342, // n0x0265 c0x0000 (---------------)  + I sr
	0x47605502, // n0x0266 c0x011d (n0x1893-n0x189f)  + I st
	0x00204102, // n0x0267 c0x0000 (---------------)  + I su
	0x002b7708, // n0x0268 c0x0000 (---------------)  + I supplies
	0x002e7046, // n0x0269 c0x0000 (---------------)  + I supply
	0x00296947, // n0x026a c0x0000 (---------------)  + I support
	0x00366884, // n0x026b c0x0000 (---------------)  + I surf
	0x002db147, // n0x026c c0x0000 (---------------)  + I surgery
	0x002ebb06, // n0x026d c0x0000 (---------------)  + I suzuki
	0x47a40a82, // n0x026e c0x011e (n0x189f-n0x18a4)  + I sv
	0x47eee302, // n0x026f c0x011f (n0x18a4-n0x18a5)  + I sx
	0x482162c2, // n0x0270 c0x0120 (n0x18a5-n0x18ab)  + I sy
	0x002874c7, // n0x0271 c0x0000 (---------------)  + I systems
	0x486081c2, // n0x0272 c0x0121 (n0x18ab-n0x18ae)  + I sz
	0x00314246, // n0x0273 c0x0000 (---------------)  + I taipei
	0x00224b05, // n0x0274 c0x0000 (---------------)  + I tatar
	0x002a0b06, // n0x0275 c0x0000 (---------------)  + I tattoo
	0x002a24c3, // n0x0276 c0x0000 (---------------)  + I tax
	0x002005c2, // n0x0277 c0x0000 (---------------)  + I tc
	0x48a07942, // n0x0278 c0x0122 (n0x18ae-n0x18af)  + I td
	0x00301d8a, // n0x0279 c0x0000 (---------------)  + I technology
	0x00223b03, // n0x027a c0x0000 (---------------)  + I tel
	0x0023c007, // n0x027b c0x0000 (---------------)  + I temasek
	0x00209142, // n0x027c c0x0000 (---------------)  + I tf
	0x00230a42, // n0x027d c0x0000 (---------------)  + I tg
	0x48e061c2, // n0x027e c0x0123 (n0x18af-n0x18b6)  + I th
	0x00220d46, // n0x027f c0x0000 (---------------)  + I tienda
	0x00367704, // n0x0280 c0x0000 (---------------)  + I tips
	0x002b3545, // n0x0281 c0x0000 (---------------)  + I tirol
	0x492412c2, // n0x0282 c0x0124 (n0x18b6-n0x18c5)  + I tj
	0x00205802, // n0x0283 c0x0000 (---------------)  + I tk
	0x4961c142, // n0x0284 c0x0125 (n0x18c5-n0x18c6)  + I tl
	0x49a00142, // n0x0285 c0x0126 (n0x18c6-n0x18ce)  + I tm
	0x49e03f82, // n0x0286 c0x0127 (n0x18ce-n0x18e2)  + I tn
	0x4a201202, // n0x0287 c0x0128 (n0x18e2-n0x18e8)  + I to
	0x00209e45, // n0x0288 c0x0000 (---------------)  + I today
	0x002d8e85, // n0x0289 c0x0000 (---------------)  + I tokyo
	0x002a0bc5, // n0x028a c0x0000 (---------------)  + I tools
	0x002997c3, // n0x028b c0x0000 (---------------)  + I top
	0x002cb847, // n0x028c c0x0000 (---------------)  + I toshiba
	0x002ed844, // n0x028d c0x0000 (---------------)  + I town
	0x00260f04, // n0x028e c0x0000 (---------------)  + I toys
	0x00219e42, // n0x028f c0x0000 (---------------)  + I tp
	0x4a605542, // n0x0290 c0x0129 (n0x18e8-n0x18fd)  + I tr
	0x0022ee85, // n0x0291 c0x0000 (---------------)  + I trade
	0x002639c8, // n0x0292 c0x0000 (---------------)  + I training
	0x00296ac6, // n0x0293 c0x0000 (---------------)  + I travel
	0x4ae04ec2, // n0x0294 c0x012b (n0x18fe-n0x190f)  + I tt
	0x002ef203, // n0x0295 c0x0000 (---------------)  + I tui
	0x4b292602, // n0x0296 c0x012c (n0x190f-n0x1913)  + I tv
	0x4b608d02, // n0x0297 c0x012d (n0x1913-n0x1921)  + I tw
	0x4ba45f42, // n0x0298 c0x012e (n0x1921-n0x192d)  + I tz
	0x4be13582, // n0x0299 c0x012f (n0x192d-n0x197b)  + I ua
	0x4c204142, // n0x029a c0x0130 (n0x197b-n0x1983)  + I ug
	0x4c600402, // n0x029b c0x0131 (n0x1983-n0x198e)  + I uk
	0x003688ca, // n0x029c c0x0000 (---------------)  + I university
	0x00222b03, // n0x029d c0x0000 (---------------)  + I uno
	0x002561c3, // n0x029e c0x0000 (---------------)  + I uol
	0x4d2054c2, // n0x029f c0x0134 (n0x1990-n0x19cf)  + I us
	0x5b6193c2, // n0x02a0 c0x016d (n0x1a72-n0x1a78)  + I uy
	0x5ba01442, // n0x02a1 c0x016e (n0x1a78-n0x1a7c)  + I uz
	0x002000c2, // n0x02a2 c0x0000 (---------------)  + I va
	0x002703c9, // n0x02a3 c0x0000 (---------------)  + I vacations
	0x5bef1142, // n0x02a4 c0x016f (n0x1a7c-n0x1a82)  + I vc
	0x5c202642, // n0x02a5 c0x0170 (n0x1a82-n0x1a93)  + I ve
	0x002f1d05, // n0x02a6 c0x0000 (---------------)  + I vegas
	0x00238208, // n0x02a7 c0x0000 (---------------)  + I ventures
	0x002f31cc, // n0x02a8 c0x0000 (---------------)  + I versicherung
	0x0023bf43, // n0x02a9 c0x0000 (---------------)  + I vet
	0x00243d02, // n0x02aa c0x0000 (---------------)  + I vg
	0x5c6032c2, // n0x02ab c0x0171 (n0x1a93-n0x1a98)  + I vi
	0x002c1806, // n0x02ac c0x0000 (---------------)  + I viajes
	0x002f6a06, // n0x02ad c0x0000 (---------------)  + I villas
	0x00238dc6, // n0x02ae c0x0000 (---------------)  + I vision
	0x0032b58a, // n0x02af c0x0000 (---------------)  + I vlaanderen
	0x5ca0ff42, // n0x02b0 c0x0172 (n0x1a98-n0x1aa4)  + I vn
	0x00317385, // n0x02b1 c0x0000 (---------------)  + I vodka
	0x002fb0c4, // n0x02b2 c0x0000 (---------------)  + I vote
	0x002fb1c6, // n0x02b3 c0x0000 (---------------)  + I voting
	0x002fb344, // n0x02b4 c0x0000 (---------------)  + I voto
	0x002220c6, // n0x02b5 c0x0000 (---------------)  + I voyage
	0x5ce03ec2, // n0x02b6 c0x0173 (n0x1aa4-n0x1aa8)  + I vu
	0x002d0105, // n0x02b7 c0x0000 (---------------)  + I wales
	0x00253784, // n0x02b8 c0x0000 (---------------)  + I wang
	0x00200545, // n0x02b9 c0x0000 (---------------)  + I watch
	0x0021f2c6, // n0x02ba c0x0000 (---------------)  + I webcam
	0x00205e47, // n0x02bb c0x0000 (---------------)  + I website
	0x002d6bc3, // n0x02bc c0x0000 (---------------)  + I wed
	0x0031e4c7, // n0x02bd c0x0000 (---------------)  + I wedding
	0x00210a42, // n0x02be c0x0000 (---------------)  + I wf
	0x00229ac7, // n0x02bf c0x0000 (---------------)  + I whoswho
	0x0031b984, // n0x02c0 c0x0000 (---------------)  + I wien
	0x0024ebc4, // n0x02c1 c0x0000 (---------------)  + I wiki
	0x0022fccb, // n0x02c2 c0x0000 (---------------)  + I williamhill
	0x0029fc43, // n0x02c3 c0x0000 (---------------)  + I wme
	0x00224704, // n0x02c4 c0x0000 (---------------)  + I work
	0x0024f485, // n0x02c5 c0x0000 (---------------)  + I works
	0x00353805, // n0x02c6 c0x0000 (---------------)  + I world
	0x5d208182, // n0x02c7 c0x0174 (n0x1aa8-n0x1aaf)  + I ws
	0x002adb03, // n0x02c8 c0x0000 (---------------)  + I wtc
	0x002ba843, // n0x02c9 c0x0000 (---------------)  + I wtf
	0x0024184b, // n0x02ca c0x0000 (---------------)  + I xn--1qqw23a
	0x002595ca, // n0x02cb c0x0000 (---------------)  + I xn--30rr7y
	0x0025dc4b, // n0x02cc c0x0000 (---------------)  + I xn--3bst00m
	0x0026fbcb, // n0x02cd c0x0000 (---------------)  + I xn--3ds443g
	0x0027d6cc, // n0x02ce c0x0000 (---------------)  + I xn--3e0b707e
	0x0029f3cb, // n0x02cf c0x0000 (---------------)  + I xn--45brj9c
	0x002a1aca, // n0x02d0 c0x0000 (---------------)  + I xn--45q11c
	0x002cc5ca, // n0x02d1 c0x0000 (---------------)  + I xn--4gbrim
	0x002cd40e, // n0x02d2 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x002ee34b, // n0x02d3 c0x0000 (---------------)  + I xn--55qw42g
	0x003732ca, // n0x02d4 c0x0000 (---------------)  + I xn--55qx5d
	0x0037428b, // n0x02d5 c0x0000 (---------------)  + I xn--6frz82g
	0x0037528e, // n0x02d6 c0x0000 (---------------)  + I xn--6qq986b3xl
	0x002fbd0c, // n0x02d7 c0x0000 (---------------)  + I xn--80adxhks
	0x002fc28b, // n0x02d8 c0x0000 (---------------)  + I xn--80ao21a
	0x002fc54c, // n0x02d9 c0x0000 (---------------)  + I xn--80asehdb
	0x002fd1ca, // n0x02da c0x0000 (---------------)  + I xn--80aswg
	0x5d6fe10a, // n0x02db c0x0175 (n0x1aaf-n0x1ab5)  + I xn--90a3ac
	0x0030080a, // n0x02dc c0x0000 (---------------)  + I xn--9et52u
	0x00303e0e, // n0x02dd c0x0000 (---------------)  + I xn--b4w605ferd
	0x0030bdc9, // n0x02de c0x0000 (---------------)  + I xn--c1avg
	0x0030c00a, // n0x02df c0x0000 (---------------)  + I xn--cg4bki
	0x0030ce56, // n0x02e0 c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x0030e1cb, // n0x02e1 c0x0000 (---------------)  + I xn--czr694b
	0x00312f4a, // n0x02e2 c0x0000 (---------------)  + I xn--czrs0t
	0x0031344a, // n0x02e3 c0x0000 (---------------)  + I xn--czru2d
	0x00318a8b, // n0x02e4 c0x0000 (---------------)  + I xn--d1acj3b
	0x0031c0cb, // n0x02e5 c0x0000 (---------------)  + I xn--efvy88h
	0x0031d38e, // n0x02e6 c0x0000 (---------------)  + I xn--fiq228c5hs
	0x0031dd8a, // n0x02e7 c0x0000 (---------------)  + I xn--fiq64b
	0x0031ed0a, // n0x02e8 c0x0000 (---------------)  + I xn--fiqs8s
	0x0031f38a, // n0x02e9 c0x0000 (---------------)  + I xn--fiqz9s
	0x0031ff4b, // n0x02ea c0x0000 (---------------)  + I xn--fjq720a
	0x0032078b, // n0x02eb c0x0000 (---------------)  + I xn--flw351e
	0x00320a4d, // n0x02ec c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x00321b0d, // n0x02ed c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x003230cb, // n0x02ee c0x0000 (---------------)  + I xn--gecrj9c
	0x0032634b, // n0x02ef c0x0000 (---------------)  + I xn--h2brj9c
	0x0032a28b, // n0x02f0 c0x0000 (---------------)  + I xn--hxt814e
	0x0032ad0f, // n0x02f1 c0x0000 (---------------)  + I xn--i1b6b1a6a2e
	0x0032b80a, // n0x02f2 c0x0000 (---------------)  + I xn--io0a7i
	0x0032ca89, // n0x02f3 c0x0000 (---------------)  + I xn--j1amh
	0x0032d54b, // n0x02f4 c0x0000 (---------------)  + I xn--j6w193g
	0x0032fb4b, // n0x02f5 c0x0000 (---------------)  + I xn--kprw13d
	0x0032fe0b, // n0x02f6 c0x0000 (---------------)  + I xn--kpry57d
	0x003300ca, // n0x02f7 c0x0000 (---------------)  + I xn--kput3i
	0x00333949, // n0x02f8 c0x0000 (---------------)  + I xn--l1acc
	0x0033648f, // n0x02f9 c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x00339e0c, // n0x02fa c0x0000 (---------------)  + I xn--mgb2ddes
	0x0033a48c, // n0x02fb c0x0000 (---------------)  + I xn--mgb9awbf
	0x0033accf, // n0x02fc c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0033b08e, // n0x02fd c0x0000 (---------------)  + I xn--mgba3a4fra
	0x0033b60e, // n0x02fe c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x0033bb4c, // n0x02ff c0x0000 (---------------)  + I xn--mgbab2bd
	0x0033be4e, // n0x0300 c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x0033c28e, // n0x0301 c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0033c60f, // n0x0302 c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x0033c9d3, // n0x0303 c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x0033ce91, // n0x0304 c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x0033d2d3, // n0x0305 c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x0033d810, // n0x0306 c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x0033e04c, // n0x0307 c0x0000 (---------------)  + I xn--mgbtf8fl
	0x0033e7ce, // n0x0308 c0x0000 (---------------)  + I xn--mgbx4cd0ab
	0x00348b0a, // n0x0309 c0x0000 (---------------)  + I xn--mxtq1m
	0x00348ecc, // n0x030a c0x0000 (---------------)  + I xn--ngbc5azd
	0x00349e4b, // n0x030b c0x0000 (---------------)  + I xn--nnx388a
	0x0034a108, // n0x030c c0x0000 (---------------)  + I xn--node
	0x0034a549, // n0x030d c0x0000 (---------------)  + I xn--nqv7f
	0x0034a54f, // n0x030e c0x0000 (---------------)  + I xn--nqv7fs00ema
	0x0034c04a, // n0x030f c0x0000 (---------------)  + I xn--o3cw4h
	0x0034d14c, // n0x0310 c0x0000 (---------------)  + I xn--ogbpf8fl
	0x0034e289, // n0x0311 c0x0000 (---------------)  + I xn--p1acf
	0x0034e588, // n0x0312 c0x0000 (---------------)  + I xn--p1ai
	0x0034ea4b, // n0x0313 c0x0000 (---------------)  + I xn--pgbs0dh
	0x0034f64b, // n0x0314 c0x0000 (---------------)  + I xn--q9jyb4c
	0x0035038c, // n0x0315 c0x0000 (---------------)  + I xn--qcka1pmc
	0x0035394b, // n0x0316 c0x0000 (---------------)  + I xn--rhqv96g
	0x00357b8b, // n0x0317 c0x0000 (---------------)  + I xn--s9brj9c
	0x0035938b, // n0x0318 c0x0000 (---------------)  + I xn--ses554g
	0x00364c8a, // n0x0319 c0x0000 (---------------)  + I xn--unup4y
	0x00365917, // n0x031a c0x0000 (---------------)  + I xn--vermgensberater-ctb
	0x00367058, // n0x031b c0x0000 (---------------)  + I xn--vermgensberatung-pwb
	0x0036edc9, // n0x031c c0x0000 (---------------)  + I xn--vhquv
	0x0037060a, // n0x031d c0x0000 (---------------)  + I xn--wgbh1c
	0x00370b8a, // n0x031e c0x0000 (---------------)  + I xn--wgbl6a
	0x00370e0b, // n0x031f c0x0000 (---------------)  + I xn--xhq521b
	0x00371910, // n0x0320 c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x00371d11, // n0x0321 c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x003728cd, // n0x0322 c0x0000 (---------------)  + I xn--yfro4i67o
	0x00372fcd, // n0x0323 c0x0000 (---------------)  + I xn--ygbi2ammx
	0x0037454b, // n0x0324 c0x0000 (---------------)  + I xn--zfr164b
	0x00375203, // n0x0325 c0x0000 (---------------)  + I xxx
	0x00248943, // n0x0326 c0x0000 (---------------)  + I xyz
	0x00234646, // n0x0327 c0x0000 (---------------)  + I yachts
	0x003062c6, // n0x0328 c0x0000 (---------------)  + I yandex
	0x016176c2, // n0x0329 c0x0005 (---------------)* o I ye
	0x0036b484, // n0x032a c0x0000 (---------------)  + I yoga
	0x00311a88, // n0x032b c0x0000 (---------------)  + I yokohama
	0x00200d47, // n0x032c c0x0000 (---------------)  + I youtube
	0x00262082, // n0x032d c0x0000 (---------------)  + I yt
	0x01603502, // n0x032e c0x0005 (---------------)* o I za
	0x00259d83, // n0x032f c0x0000 (---------------)  + I zip
	0x016869c2, // n0x0330 c0x0005 (---------------)* o I zm
	0x002d4f04, // n0x0331 c0x0000 (---------------)  + I zone
	0x016dbb42, // n0x0332 c0x0005 (---------------)* o I zw
	0x00222603, // n0x0333 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0334 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0335 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0336 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0337 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0338 c0x0000 (---------------)  + I org
	0x00214103, // n0x0339 c0x0000 (---------------)  + I nom
	0x00201d82, // n0x033a c0x0000 (---------------)  + I ac
	0x00207a02, // n0x033b c0x0000 (---------------)  + I co
	0x002157c3, // n0x033c c0x0000 (---------------)  + I gov
	0x0023f703, // n0x033d c0x0000 (---------------)  + I mil
	0x00201603, // n0x033e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x033f c0x0000 (---------------)  + I org
	0x002526c3, // n0x0340 c0x0000 (---------------)  + I sch
	0x00307ed6, // n0x0341 c0x0000 (---------------)  + I accident-investigation
	0x0030a7d3, // n0x0342 c0x0000 (---------------)  + I accident-prevention
	0x0027a1c9, // n0x0343 c0x0000 (---------------)  + I aerobatic
	0x002a4188, // n0x0344 c0x0000 (---------------)  + I aeroclub
	0x002eed49, // n0x0345 c0x0000 (---------------)  + I aerodrome
	0x0030c586, // n0x0346 c0x0000 (---------------)  + I agents
	0x00310390, // n0x0347 c0x0000 (---------------)  + I air-surveillance
	0x0027f953, // n0x0348 c0x0000 (---------------)  + I air-traffic-control
	0x00257088, // n0x0349 c0x0000 (---------------)  + I aircraft
	0x00276387, // n0x034a c0x0000 (---------------)  + I airline
	0x00352647, // n0x034b c0x0000 (---------------)  + I airport
	0x0029baca, // n0x034c c0x0000 (---------------)  + I airtraffic
	0x002c5389, // n0x034d c0x0000 (---------------)  + I ambulance
	0x00333d89, // n0x034e c0x0000 (---------------)  + I amusement
	0x0029cfcb, // n0x034f c0x0000 (---------------)  + I association
	0x00310b86, // n0x0350 c0x0000 (---------------)  + I author
	0x00311f0a, // n0x0351 c0x0000 (---------------)  + I ballooning
	0x0021d2c6, // n0x0352 c0x0000 (---------------)  + I broker
	0x0036b0c3, // n0x0353 c0x0000 (---------------)  + I caa
	0x00215205, // n0x0354 c0x0000 (---------------)  + I cargo
	0x00247d08, // n0x0355 c0x0000 (---------------)  + I catering
	0x002c554d, // n0x0356 c0x0000 (---------------)  + I certification
	0x0030ff4c, // n0x0357 c0x0000 (---------------)  + I championship
	0x00329307, // n0x0358 c0x0000 (---------------)  + I charter
	0x0037084d, // n0x0359 c0x0000 (---------------)  + I civilaviation
	0x002a4284, // n0x035a c0x0000 (---------------)  + I club
	0x00234b0a, // n0x035b c0x0000 (---------------)  + I conference
	0x00235bca, // n0x035c c0x0000 (---------------)  + I consultant
	0x0023608a, // n0x035d c0x0000 (---------------)  + I consulting
	0x0022f147, // n0x035e c0x0000 (---------------)  + I control
	0x0023dbc7, // n0x035f c0x0000 (---------------)  + I council
	0x0023f544, // n0x0360 c0x0000 (---------------)  + I crew
	0x00255d86, // n0x0361 c0x0000 (---------------)  + I design
	0x003128c4, // n0x0362 c0x0000 (---------------)  + I dgca
	0x002d9688, // n0x0363 c0x0000 (---------------)  + I educator
	0x0020c049, // n0x0364 c0x0000 (---------------)  + I emergency
	0x002c3ec6, // n0x0365 c0x0000 (---------------)  + I engine
	0x002c3ec8, // n0x0366 c0x0000 (---------------)  + I engineer
	0x00240fcd, // n0x0367 c0x0000 (---------------)  + I entertainment
	0x00356f09, // n0x0368 c0x0000 (---------------)  + I equipment
	0x00208248, // n0x0369 c0x0000 (---------------)  + I exchange
	0x00248747, // n0x036a c0x0000 (---------------)  + I express
	0x0022e3ca, // n0x036b c0x0000 (---------------)  + I federation
	0x0024a046, // n0x036c c0x0000 (---------------)  + I flight
	0x00259847, // n0x036d c0x0000 (---------------)  + I freight
	0x002dc3c4, // n0x036e c0x0000 (---------------)  + I fuel
	0x0022a947, // n0x036f c0x0000 (---------------)  + I gliding
	0x0026608a, // n0x0370 c0x0000 (---------------)  + I government
	0x00231b4e, // n0x0371 c0x0000 (---------------)  + I groundhandling
	0x002248c5, // n0x0372 c0x0000 (---------------)  + I group
	0x00285d4b, // n0x0373 c0x0000 (---------------)  + I hanggliding
	0x0021fe49, // n0x0374 c0x0000 (---------------)  + I homebuilt
	0x00358ac9, // n0x0375 c0x0000 (---------------)  + I insurance
	0x002481c7, // n0x0376 c0x0000 (---------------)  + I journal
	0x002d234a, // n0x0377 c0x0000 (---------------)  + I journalist
	0x0021c187, // n0x0378 c0x0000 (---------------)  + I leasing
	0x0024ba49, // n0x0379 c0x0000 (---------------)  + I logistics
	0x002b4788, // n0x037a c0x0000 (---------------)  + I magazine
	0x0031498b, // n0x037b c0x0000 (---------------)  + I maintenance
	0x0035a34b, // n0x037c c0x0000 (---------------)  + I marketplace
	0x0027ab45, // n0x037d c0x0000 (---------------)  + I media
	0x00244c4a, // n0x037e c0x0000 (---------------)  + I microlight
	0x0022ab09, // n0x037f c0x0000 (---------------)  + I modelling
	0x00203c0a, // n0x0380 c0x0000 (---------------)  + I navigation
	0x00201ccb, // n0x0381 c0x0000 (---------------)  + I parachuting
	0x0022a84b, // n0x0382 c0x0000 (---------------)  + I paragliding
	0x0029cd55, // n0x0383 c0x0000 (---------------)  + I passenger-association
	0x002cf085, // n0x0384 c0x0000 (---------------)  + I pilot
	0x002487c5, // n0x0385 c0x0000 (---------------)  + I press
	0x002d86ca, // n0x0386 c0x0000 (---------------)  + I production
	0x0022778a, // n0x0387 c0x0000 (---------------)  + I recreation
	0x0021fbc7, // n0x0388 c0x0000 (---------------)  + I repbody
	0x00218b43, // n0x0389 c0x0000 (---------------)  + I res
	0x002aa848, // n0x038a c0x0000 (---------------)  + I research
	0x002c970a, // n0x038b c0x0000 (---------------)  + I rotorcraft
	0x00281286, // n0x038c c0x0000 (---------------)  + I safety
	0x0028d289, // n0x038d c0x0000 (---------------)  + I scientist
	0x002a6888, // n0x038e c0x0000 (---------------)  + I services
	0x002ddc84, // n0x038f c0x0000 (---------------)  + I show
	0x00269709, // n0x0390 c0x0000 (---------------)  + I skydiving
	0x0027c088, // n0x0391 c0x0000 (---------------)  + I software
	0x002b11c7, // n0x0392 c0x0000 (---------------)  + I student
	0x002a24c4, // n0x0393 c0x0000 (---------------)  + I taxi
	0x0022ee86, // n0x0394 c0x0000 (---------------)  + I trader
	0x0029e607, // n0x0395 c0x0000 (---------------)  + I trading
	0x002f1b47, // n0x0396 c0x0000 (---------------)  + I trainer
	0x0028dd45, // n0x0397 c0x0000 (---------------)  + I union
	0x0022470c, // n0x0398 c0x0000 (---------------)  + I workinggroup
	0x0024f485, // n0x0399 c0x0000 (---------------)  + I works
	0x00222603, // n0x039a c0x0000 (---------------)  + I com
	0x0027a643, // n0x039b c0x0000 (---------------)  + I edu
	0x002157c3, // n0x039c c0x0000 (---------------)  + I gov
	0x00201603, // n0x039d c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x039e c0x0000 (---------------)  + I org
	0x00207a02, // n0x039f c0x0000 (---------------)  + I co
	0x00222603, // n0x03a0 c0x0000 (---------------)  + I com
	0x00201603, // n0x03a1 c0x0000 (---------------)  + I net
	0x00214103, // n0x03a2 c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x03a3 c0x0000 (---------------)  + I org
	0x00222603, // n0x03a4 c0x0000 (---------------)  + I com
	0x00201603, // n0x03a5 c0x0000 (---------------)  + I net
	0x0021ef43, // n0x03a6 c0x0000 (---------------)  + I off
	0x0021f5c3, // n0x03a7 c0x0000 (---------------)  + I org
	0x00222603, // n0x03a8 c0x0000 (---------------)  + I com
	0x0027a643, // n0x03a9 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x03aa c0x0000 (---------------)  + I gov
	0x0023f703, // n0x03ab c0x0000 (---------------)  + I mil
	0x00201603, // n0x03ac c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x03ad c0x0000 (---------------)  + I org
	0x00222603, // n0x03ae c0x0000 (---------------)  + I com
	0x0027a643, // n0x03af c0x0000 (---------------)  + I edu
	0x00201603, // n0x03b0 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x03b1 c0x0000 (---------------)  + I org
	0x00207a02, // n0x03b2 c0x0000 (---------------)  + I co
	0x00202542, // n0x03b3 c0x0000 (---------------)  + I ed
	0x002362c2, // n0x03b4 c0x0000 (---------------)  + I gv
	0x002017c2, // n0x03b5 c0x0000 (---------------)  + I it
	0x00200cc2, // n0x03b6 c0x0000 (---------------)  + I og
	0x0021fc42, // n0x03b7 c0x0000 (---------------)  + I pb
	0x04622603, // n0x03b8 c0x0011 (n0x03c1-n0x03c2)  + I com
	0x0027a643, // n0x03b9 c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x03ba c0x0000 (---------------)  + I gob
	0x002157c3, // n0x03bb c0x0000 (---------------)  + I gov
	0x00223a83, // n0x03bc c0x0000 (---------------)  + I int
	0x0023f703, // n0x03bd c0x0000 (---------------)  + I mil
	0x00201603, // n0x03be c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x03bf c0x0000 (---------------)  + I org
	0x002382c3, // n0x03c0 c0x0000 (---------------)  + I tur
	0x000b8948, // n0x03c1 c0x0000 (---------------)  +   blogspot
	0x00250d44, // n0x03c2 c0x0000 (---------------)  + I e164
	0x00343087, // n0x03c3 c0x0000 (---------------)  + I in-addr
	0x0021b783, // n0x03c4 c0x0000 (---------------)  + I ip6
	0x0027cec4, // n0x03c5 c0x0000 (---------------)  + I iris
	0x00209f83, // n0x03c6 c0x0000 (---------------)  + I uri
	0x00234a03, // n0x03c7 c0x0000 (---------------)  + I urn
	0x002157c3, // n0x03c8 c0x0000 (---------------)  + I gov
	0x00201d82, // n0x03c9 c0x0000 (---------------)  + I ac
	0x00114c43, // n0x03ca c0x0000 (---------------)  +   biz
	0x05607a02, // n0x03cb c0x0015 (n0x03d0-n0x03d1)  + I co
	0x002362c2, // n0x03cc c0x0000 (---------------)  + I gv
	0x0001c704, // n0x03cd c0x0000 (---------------)  +   info
	0x00200bc2, // n0x03ce c0x0000 (---------------)  + I or
	0x000d82c4, // n0x03cf c0x0000 (---------------)  +   priv
	0x000b8948, // n0x03d0 c0x0000 (---------------)  +   blogspot
	0x00237f03, // n0x03d1 c0x0000 (---------------)  + I act
	0x002adf03, // n0x03d2 c0x0000 (---------------)  + I asn
	0x05e22603, // n0x03d3 c0x0017 (n0x03e3-n0x03e4)  + I com
	0x00234b04, // n0x03d4 c0x0000 (---------------)  + I conf
	0x0627a643, // n0x03d5 c0x0018 (n0x03e4-n0x03ec)  + I edu
	0x066157c3, // n0x03d6 c0x0019 (n0x03ec-n0x03f1)  + I gov
	0x00202f82, // n0x03d7 c0x0000 (---------------)  + I id
	0x0021c704, // n0x03d8 c0x0000 (---------------)  + I info
	0x00201603, // n0x03d9 c0x0000 (---------------)  + I net
	0x002d6b43, // n0x03da c0x0000 (---------------)  + I nsw
	0x0020ddc2, // n0x03db c0x0000 (---------------)  + I nt
	0x0021f5c3, // n0x03dc c0x0000 (---------------)  + I org
	0x00215ec2, // n0x03dd c0x0000 (---------------)  + I oz
	0x0023df03, // n0x03de c0x0000 (---------------)  + I qld
	0x00202882, // n0x03df c0x0000 (---------------)  + I sa
	0x0021ad03, // n0x03e0 c0x0000 (---------------)  + I tas
	0x002a6943, // n0x03e1 c0x0000 (---------------)  + I vic
	0x00200542, // n0x03e2 c0x0000 (---------------)  + I wa
	0x000b8948, // n0x03e3 c0x0000 (---------------)  +   blogspot
	0x00237f03, // n0x03e4 c0x0000 (---------------)  + I act
	0x002d6b43, // n0x03e5 c0x0000 (---------------)  + I nsw
	0x0020ddc2, // n0x03e6 c0x0000 (---------------)  + I nt
	0x0023df03, // n0x03e7 c0x0000 (---------------)  + I qld
	0x00202882, // n0x03e8 c0x0000 (---------------)  + I sa
	0x0021ad03, // n0x03e9 c0x0000 (---------------)  + I tas
	0x002a6943, // n0x03ea c0x0000 (---------------)  + I vic
	0x00200542, // n0x03eb c0x0000 (---------------)  + I wa
	0x0023df03, // n0x03ec c0x0000 (---------------)  + I qld
	0x00202882, // n0x03ed c0x0000 (---------------)  + I sa
	0x0021ad03, // n0x03ee c0x0000 (---------------)  + I tas
	0x002a6943, // n0x03ef c0x0000 (---------------)  + I vic
	0x00200542, // n0x03f0 c0x0000 (---------------)  + I wa
	0x00222603, // n0x03f1 c0x0000 (---------------)  + I com
	0x00314c43, // n0x03f2 c0x0000 (---------------)  + I biz
	0x00222603, // n0x03f3 c0x0000 (---------------)  + I com
	0x0027a643, // n0x03f4 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x03f5 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x03f6 c0x0000 (---------------)  + I info
	0x00223a83, // n0x03f7 c0x0000 (---------------)  + I int
	0x0023f703, // n0x03f8 c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x03f9 c0x0000 (---------------)  + I name
	0x00201603, // n0x03fa c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x03fb c0x0000 (---------------)  + I org
	0x00200f02, // n0x03fc c0x0000 (---------------)  + I pp
	0x002d8443, // n0x03fd c0x0000 (---------------)  + I pro
	0x00207a02, // n0x03fe c0x0000 (---------------)  + I co
	0x00222603, // n0x03ff c0x0000 (---------------)  + I com
	0x0027a643, // n0x0400 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0401 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0402 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0403 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0404 c0x0000 (---------------)  + I org
	0x0020ac02, // n0x0405 c0x0000 (---------------)  + I rs
	0x0030af04, // n0x0406 c0x0000 (---------------)  + I unbi
	0x00274144, // n0x0407 c0x0000 (---------------)  + I unsa
	0x00314c43, // n0x0408 c0x0000 (---------------)  + I biz
	0x00207a02, // n0x0409 c0x0000 (---------------)  + I co
	0x00222603, // n0x040a c0x0000 (---------------)  + I com
	0x0027a643, // n0x040b c0x0000 (---------------)  + I edu
	0x002157c3, // n0x040c c0x0000 (---------------)  + I gov
	0x0021c704, // n0x040d c0x0000 (---------------)  + I info
	0x00201603, // n0x040e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x040f c0x0000 (---------------)  + I org
	0x002e9885, // n0x0410 c0x0000 (---------------)  + I store
	0x00292602, // n0x0411 c0x0000 (---------------)  + I tv
	0x00201d82, // n0x0412 c0x0000 (---------------)  + I ac
	0x000b8948, // n0x0413 c0x0000 (---------------)  +   blogspot
	0x002157c3, // n0x0414 c0x0000 (---------------)  + I gov
	0x0021be81, // n0x0415 c0x0000 (---------------)  + I 0
	0x00206381, // n0x0416 c0x0000 (---------------)  + I 1
	0x0020f681, // n0x0417 c0x0000 (---------------)  + I 2
	0x00205dc1, // n0x0418 c0x0000 (---------------)  + I 3
	0x00250e01, // n0x0419 c0x0000 (---------------)  + I 4
	0x0029f501, // n0x041a c0x0000 (---------------)  + I 5
	0x0021b801, // n0x041b c0x0000 (---------------)  + I 6
	0x002597c1, // n0x041c c0x0000 (---------------)  + I 7
	0x002fbe01, // n0x041d c0x0000 (---------------)  + I 8
	0x0029f601, // n0x041e c0x0000 (---------------)  + I 9
	0x00200101, // n0x041f c0x0000 (---------------)  + I a
	0x00200001, // n0x0420 c0x0000 (---------------)  + I b
	0x00200601, // n0x0421 c0x0000 (---------------)  + I c
	0x00200741, // n0x0422 c0x0000 (---------------)  + I d
	0x00200081, // n0x0423 c0x0000 (---------------)  + I e
	0x002003c1, // n0x0424 c0x0000 (---------------)  + I f
	0x002004c1, // n0x0425 c0x0000 (---------------)  + I g
	0x00200641, // n0x0426 c0x0000 (---------------)  + I h
	0x00200041, // n0x0427 c0x0000 (---------------)  + I i
	0x00201f81, // n0x0428 c0x0000 (---------------)  + I j
	0x00200441, // n0x0429 c0x0000 (---------------)  + I k
	0x00200801, // n0x042a c0x0000 (---------------)  + I l
	0x00200181, // n0x042b c0x0000 (---------------)  + I m
	0x00200241, // n0x042c c0x0000 (---------------)  + I n
	0x00200841, // n0x042d c0x0000 (---------------)  + I o
	0x002001c1, // n0x042e c0x0000 (---------------)  + I p
	0x00206741, // n0x042f c0x0000 (---------------)  + I q
	0x00200a81, // n0x0430 c0x0000 (---------------)  + I r
	0x00200941, // n0x0431 c0x0000 (---------------)  + I s
	0x00200141, // n0x0432 c0x0000 (---------------)  + I t
	0x00200401, // n0x0433 c0x0000 (---------------)  + I u
	0x002000c1, // n0x0434 c0x0000 (---------------)  + I v
	0x00200541, // n0x0435 c0x0000 (---------------)  + I w
	0x00208281, // n0x0436 c0x0000 (---------------)  + I x
	0x00200d41, // n0x0437 c0x0000 (---------------)  + I y
	0x00201481, // n0x0438 c0x0000 (---------------)  + I z
	0x00222603, // n0x0439 c0x0000 (---------------)  + I com
	0x0027a643, // n0x043a c0x0000 (---------------)  + I edu
	0x002157c3, // n0x043b c0x0000 (---------------)  + I gov
	0x00201603, // n0x043c c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x043d c0x0000 (---------------)  + I org
	0x00207a02, // n0x043e c0x0000 (---------------)  + I co
	0x00222603, // n0x043f c0x0000 (---------------)  + I com
	0x0027a643, // n0x0440 c0x0000 (---------------)  + I edu
	0x00200bc2, // n0x0441 c0x0000 (---------------)  + I or
	0x0021f5c3, // n0x0442 c0x0000 (---------------)  + I org
	0x00010c06, // n0x0443 c0x0000 (---------------)  +   dyndns
	0x00051b8a, // n0x0444 c0x0000 (---------------)  +   for-better
	0x000822c8, // n0x0445 c0x0000 (---------------)  +   for-more
	0x000521c8, // n0x0446 c0x0000 (---------------)  +   for-some
	0x000529c7, // n0x0447 c0x0000 (---------------)  +   for-the
	0x000ff606, // n0x0448 c0x0000 (---------------)  +   selfip
	0x0004db86, // n0x0449 c0x0000 (---------------)  +   webhop
	0x0029cfc4, // n0x044a c0x0000 (---------------)  + I asso
	0x0030e447, // n0x044b c0x0000 (---------------)  + I barreau
	0x000b8948, // n0x044c c0x0000 (---------------)  +   blogspot
	0x00368f84, // n0x044d c0x0000 (---------------)  + I gouv
	0x00222603, // n0x044e c0x0000 (---------------)  + I com
	0x0027a643, // n0x044f c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0450 c0x0000 (---------------)  + I gov
	0x00201603, // n0x0451 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0452 c0x0000 (---------------)  + I org
	0x00222603, // n0x0453 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0454 c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x0455 c0x0000 (---------------)  + I gob
	0x002157c3, // n0x0456 c0x0000 (---------------)  + I gov
	0x00223a83, // n0x0457 c0x0000 (---------------)  + I int
	0x0023f703, // n0x0458 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0459 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x045a c0x0000 (---------------)  + I org
	0x00292602, // n0x045b c0x0000 (---------------)  + I tv
	0x002ccd43, // n0x045c c0x0000 (---------------)  + I adm
	0x0025a4c3, // n0x045d c0x0000 (---------------)  + I adv
	0x0022a003, // n0x045e c0x0000 (---------------)  + I agr
	0x00200282, // n0x045f c0x0000 (---------------)  + I am
	0x00260ac3, // n0x0460 c0x0000 (---------------)  + I arq
	0x00201383, // n0x0461 c0x0000 (---------------)  + I art
	0x002011c3, // n0x0462 c0x0000 (---------------)  + I ato
	0x00200001, // n0x0463 c0x0000 (---------------)  + I b
	0x002063c3, // n0x0464 c0x0000 (---------------)  + I bio
	0x00210dc4, // n0x0465 c0x0000 (---------------)  + I blog
	0x00367f83, // n0x0466 c0x0000 (---------------)  + I bmd
	0x00338cc3, // n0x0467 c0x0000 (---------------)  + I cim
	0x0033d743, // n0x0468 c0x0000 (---------------)  + I cng
	0x002309c3, // n0x0469 c0x0000 (---------------)  + I cnt
	0x0a222603, // n0x046a c0x0028 (n0x04a2-n0x04a3)  + I com
	0x00239dc4, // n0x046b c0x0000 (---------------)  + I coop
	0x002f0e83, // n0x046c c0x0000 (---------------)  + I ecn
	0x002079c3, // n0x046d c0x0000 (---------------)  + I eco
	0x0027a643, // n0x046e c0x0000 (---------------)  + I edu
	0x00236c43, // n0x046f c0x0000 (---------------)  + I emp
	0x00202e03, // n0x0470 c0x0000 (---------------)  + I eng
	0x002e6583, // n0x0471 c0x0000 (---------------)  + I esp
	0x0025fe43, // n0x0472 c0x0000 (---------------)  + I etc
	0x00217bc3, // n0x0473 c0x0000 (---------------)  + I eti
	0x00210a83, // n0x0474 c0x0000 (---------------)  + I far
	0x0024ba04, // n0x0475 c0x0000 (---------------)  + I flog
	0x00253942, // n0x0476 c0x0000 (---------------)  + I fm
	0x00250e43, // n0x0477 c0x0000 (---------------)  + I fnd
	0x00258883, // n0x0478 c0x0000 (---------------)  + I fot
	0x00273983, // n0x0479 c0x0000 (---------------)  + I fst
	0x002e8bc3, // n0x047a c0x0000 (---------------)  + I g12
	0x00317f03, // n0x047b c0x0000 (---------------)  + I ggf
	0x002157c3, // n0x047c c0x0000 (---------------)  + I gov
	0x002e00c3, // n0x047d c0x0000 (---------------)  + I imb
	0x00214b03, // n0x047e c0x0000 (---------------)  + I ind
	0x0021c543, // n0x047f c0x0000 (---------------)  + I inf
	0x0021ecc3, // n0x0480 c0x0000 (---------------)  + I jor
	0x0024b843, // n0x0481 c0x0000 (---------------)  + I jus
	0x00230ec3, // n0x0482 c0x0000 (---------------)  + I leg
	0x0032d483, // n0x0483 c0x0000 (---------------)  + I lel
	0x0020a743, // n0x0484 c0x0000 (---------------)  + I mat
	0x00225d03, // n0x0485 c0x0000 (---------------)  + I med
	0x0023f703, // n0x0486 c0x0000 (---------------)  + I mil
	0x00200182, // n0x0487 c0x0000 (---------------)  + I mp
	0x002a91c3, // n0x0488 c0x0000 (---------------)  + I mus
	0x00201603, // n0x0489 c0x0000 (---------------)  + I net
	0x01614103, // n0x048a c0x0005 (---------------)* o I nom
	0x002502c3, // n0x048b c0x0000 (---------------)  + I not
	0x0022f1c3, // n0x048c c0x0000 (---------------)  + I ntr
	0x0020dc83, // n0x048d c0x0000 (---------------)  + I odo
	0x0021f5c3, // n0x048e c0x0000 (---------------)  + I org
	0x00222cc3, // n0x048f c0x0000 (---------------)  + I ppg
	0x002d8443, // n0x0490 c0x0000 (---------------)  + I pro
	0x002ffac3, // n0x0491 c0x0000 (---------------)  + I psc
	0x00288c03, // n0x0492 c0x0000 (---------------)  + I psi
	0x002dc143, // n0x0493 c0x0000 (---------------)  + I qsl
	0x0024a785, // n0x0494 c0x0000 (---------------)  + I radio
	0x00227783, // n0x0495 c0x0000 (---------------)  + I rec
	0x002e0a43, // n0x0496 c0x0000 (---------------)  + I slg
	0x002e9583, // n0x0497 c0x0000 (---------------)  + I srv
	0x002a24c4, // n0x0498 c0x0000 (---------------)  + I taxi
	0x002bff03, // n0x0499 c0x0000 (---------------)  + I teo
	0x00200143, // n0x049a c0x0000 (---------------)  + I tmp
	0x002a74c3, // n0x049b c0x0000 (---------------)  + I trd
	0x002382c3, // n0x049c c0x0000 (---------------)  + I tur
	0x00292602, // n0x049d c0x0000 (---------------)  + I tv
	0x0023bf43, // n0x049e c0x0000 (---------------)  + I vet
	0x002f8f04, // n0x049f c0x0000 (---------------)  + I vlog
	0x0024ebc4, // n0x04a0 c0x0000 (---------------)  + I wiki
	0x002ffd43, // n0x04a1 c0x0000 (---------------)  + I zlg
	0x000b8948, // n0x04a2 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x04a3 c0x0000 (---------------)  + I com
	0x0027a643, // n0x04a4 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x04a5 c0x0000 (---------------)  + I gov
	0x00201603, // n0x04a6 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x04a7 c0x0000 (---------------)  + I org
	0x00222603, // n0x04a8 c0x0000 (---------------)  + I com
	0x0027a643, // n0x04a9 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x04aa c0x0000 (---------------)  + I gov
	0x00201603, // n0x04ab c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x04ac c0x0000 (---------------)  + I org
	0x00207a02, // n0x04ad c0x0000 (---------------)  + I co
	0x0021f5c3, // n0x04ae c0x0000 (---------------)  + I org
	0x00222603, // n0x04af c0x0000 (---------------)  + I com
	0x002157c3, // n0x04b0 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x04b1 c0x0000 (---------------)  + I mil
	0x0021ef42, // n0x04b2 c0x0000 (---------------)  + I of
	0x00222603, // n0x04b3 c0x0000 (---------------)  + I com
	0x0027a643, // n0x04b4 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x04b5 c0x0000 (---------------)  + I gov
	0x00201603, // n0x04b6 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x04b7 c0x0000 (---------------)  + I org
	0x00003502, // n0x04b8 c0x0000 (---------------)  +   za
	0x00200302, // n0x04b9 c0x0000 (---------------)  + I ab
	0x0021f342, // n0x04ba c0x0000 (---------------)  + I bc
	0x000b8948, // n0x04bb c0x0000 (---------------)  +   blogspot
	0x00007a02, // n0x04bc c0x0000 (---------------)  +   co
	0x0030d302, // n0x04bd c0x0000 (---------------)  + I gc
	0x00203102, // n0x04be c0x0000 (---------------)  + I mb
	0x0020dfc2, // n0x04bf c0x0000 (---------------)  + I nb
	0x00209282, // n0x04c0 c0x0000 (---------------)  + I nf
	0x00244442, // n0x04c1 c0x0000 (---------------)  + I nl
	0x00203a42, // n0x04c2 c0x0000 (---------------)  + I ns
	0x0020ddc2, // n0x04c3 c0x0000 (---------------)  + I nt
	0x002267c2, // n0x04c4 c0x0000 (---------------)  + I nu
	0x00203e02, // n0x04c5 c0x0000 (---------------)  + I on
	0x00202142, // n0x04c6 c0x0000 (---------------)  + I pe
	0x00350482, // n0x04c7 c0x0000 (---------------)  + I qc
	0x00202202, // n0x04c8 c0x0000 (---------------)  + I sk
	0x0023bac2, // n0x04c9 c0x0000 (---------------)  + I yk
	0x00019e09, // n0x04ca c0x0000 (---------------)  +   ftpaccess
	0x000a2b8b, // n0x04cb c0x0000 (---------------)  +   game-server
	0x000cb708, // n0x04cc c0x0000 (---------------)  +   myphotos
	0x00094cc9, // n0x04cd c0x0000 (---------------)  +   scrapping
	0x002157c3, // n0x04ce c0x0000 (---------------)  + I gov
	0x000b8948, // n0x04cf c0x0000 (---------------)  +   blogspot
	0x000b8948, // n0x04d0 c0x0000 (---------------)  +   blogspot
	0x00201d82, // n0x04d1 c0x0000 (---------------)  + I ac
	0x0029cfc4, // n0x04d2 c0x0000 (---------------)  + I asso
	0x00207a02, // n0x04d3 c0x0000 (---------------)  + I co
	0x00222603, // n0x04d4 c0x0000 (---------------)  + I com
	0x00202542, // n0x04d5 c0x0000 (---------------)  + I ed
	0x0027a643, // n0x04d6 c0x0000 (---------------)  + I edu
	0x00206cc2, // n0x04d7 c0x0000 (---------------)  + I go
	0x00368f84, // n0x04d8 c0x0000 (---------------)  + I gouv
	0x00223a83, // n0x04d9 c0x0000 (---------------)  + I int
	0x00235302, // n0x04da c0x0000 (---------------)  + I md
	0x00201603, // n0x04db c0x0000 (---------------)  + I net
	0x00200bc2, // n0x04dc c0x0000 (---------------)  + I or
	0x0021f5c3, // n0x04dd c0x0000 (---------------)  + I org
	0x002487c6, // n0x04de c0x0000 (---------------)  + I presse
	0x00300d8f, // n0x04df c0x0000 (---------------)  + I xn--aroport-bya
	0x006c3243, // n0x04e0 c0x0001 (---------------)  ! I www
	0x00207a02, // n0x04e1 c0x0000 (---------------)  + I co
	0x0020dbc3, // n0x04e2 c0x0000 (---------------)  + I gob
	0x002157c3, // n0x04e3 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x04e4 c0x0000 (---------------)  + I mil
	0x00207a02, // n0x04e5 c0x0000 (---------------)  + I co
	0x00222603, // n0x04e6 c0x0000 (---------------)  + I com
	0x002157c3, // n0x04e7 c0x0000 (---------------)  + I gov
	0x00201603, // n0x04e8 c0x0000 (---------------)  + I net
	0x00201d82, // n0x04e9 c0x0000 (---------------)  + I ac
	0x0020b442, // n0x04ea c0x0000 (---------------)  + I ah
	0x0e31a189, // n0x04eb c0x0038 (n0x0516-n0x0517)  o I amazonaws
	0x0020e2c2, // n0x04ec c0x0000 (---------------)  + I bj
	0x00222603, // n0x04ed c0x0000 (---------------)  + I com
	0x0023dec2, // n0x04ee c0x0000 (---------------)  + I cq
	0x0027a643, // n0x04ef c0x0000 (---------------)  + I edu
	0x0021ec82, // n0x04f0 c0x0000 (---------------)  + I fj
	0x00210e82, // n0x04f1 c0x0000 (---------------)  + I gd
	0x002157c3, // n0x04f2 c0x0000 (---------------)  + I gov
	0x00229d82, // n0x04f3 c0x0000 (---------------)  + I gs
	0x00259582, // n0x04f4 c0x0000 (---------------)  + I gx
	0x00259d42, // n0x04f5 c0x0000 (---------------)  + I gz
	0x00200a02, // n0x04f6 c0x0000 (---------------)  + I ha
	0x002fffc2, // n0x04f7 c0x0000 (---------------)  + I hb
	0x00201c02, // n0x04f8 c0x0000 (---------------)  + I he
	0x00200982, // n0x04f9 c0x0000 (---------------)  + I hi
	0x0026af42, // n0x04fa c0x0000 (---------------)  + I hk
	0x0026e482, // n0x04fb c0x0000 (---------------)  + I hl
	0x0022c942, // n0x04fc c0x0000 (---------------)  + I hn
	0x0032d902, // n0x04fd c0x0000 (---------------)  + I jl
	0x0021bb82, // n0x04fe c0x0000 (---------------)  + I js
	0x00304cc2, // n0x04ff c0x0000 (---------------)  + I jx
	0x0022d7c2, // n0x0500 c0x0000 (---------------)  + I ln
	0x0023f703, // n0x0501 c0x0000 (---------------)  + I mil
	0x00206c42, // n0x0502 c0x0000 (---------------)  + I mo
	0x00201603, // n0x0503 c0x0000 (---------------)  + I net
	0x0020eb82, // n0x0504 c0x0000 (---------------)  + I nm
	0x0027d682, // n0x0505 c0x0000 (---------------)  + I nx
	0x0021f5c3, // n0x0506 c0x0000 (---------------)  + I org
	0x0023b182, // n0x0507 c0x0000 (---------------)  + I qh
	0x00218bc2, // n0x0508 c0x0000 (---------------)  + I sc
	0x00202002, // n0x0509 c0x0000 (---------------)  + I sd
	0x00200942, // n0x050a c0x0000 (---------------)  + I sh
	0x0020dd82, // n0x050b c0x0000 (---------------)  + I sn
	0x002ee302, // n0x050c c0x0000 (---------------)  + I sx
	0x002412c2, // n0x050d c0x0000 (---------------)  + I tj
	0x00208d02, // n0x050e c0x0000 (---------------)  + I tw
	0x0022ad82, // n0x050f c0x0000 (---------------)  + I xj
	0x003732ca, // n0x0510 c0x0000 (---------------)  + I xn--55qx5d
	0x0032b80a, // n0x0511 c0x0000 (---------------)  + I xn--io0a7i
	0x0034c44a, // n0x0512 c0x0000 (---------------)  + I xn--od0alg
	0x00375602, // n0x0513 c0x0000 (---------------)  + I xz
	0x00210c42, // n0x0514 c0x0000 (---------------)  + I yn
	0x00260dc2, // n0x0515 c0x0000 (---------------)  + I zj
	0x0e433987, // n0x0516 c0x0039 (n0x0517-n0x0518)  +   compute
	0x000f0eca, // n0x0517 c0x0000 (---------------)  +   cn-north-1
	0x002180c4, // n0x0518 c0x0000 (---------------)  + I arts
	0x00222603, // n0x0519 c0x0000 (---------------)  + I com
	0x0027a643, // n0x051a c0x0000 (---------------)  + I edu
	0x00245bc4, // n0x051b c0x0000 (---------------)  + I firm
	0x002157c3, // n0x051c c0x0000 (---------------)  + I gov
	0x0021c704, // n0x051d c0x0000 (---------------)  + I info
	0x00223a83, // n0x051e c0x0000 (---------------)  + I int
	0x0023f703, // n0x051f c0x0000 (---------------)  + I mil
	0x00201603, // n0x0520 c0x0000 (---------------)  + I net
	0x00214103, // n0x0521 c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x0522 c0x0000 (---------------)  + I org
	0x00227783, // n0x0523 c0x0000 (---------------)  + I rec
	0x00205e43, // n0x0524 c0x0000 (---------------)  + I web
	0x00084506, // n0x0525 c0x0000 (---------------)  +   africa
	0x0f31a189, // n0x0526 c0x003c (n0x05e8-n0x05ff)  o I amazonaws
	0x00044907, // n0x0527 c0x0000 (---------------)  +   appspot
	0x00000a42, // n0x0528 c0x0000 (---------------)  +   ar
	0x00165e8a, // n0x0529 c0x0000 (---------------)  +   betainabox
	0x00010dc7, // n0x052a c0x0000 (---------------)  +   blogdns
	0x000b8948, // n0x052b c0x0000 (---------------)  +   blogspot
	0x00006842, // n0x052c c0x0000 (---------------)  +   br
	0x00109fc7, // n0x052d c0x0000 (---------------)  +   cechire
	0x000e85cf, // n0x052e c0x0000 (---------------)  +   cloudcontrolapp
	0x0002f00f, // n0x052f c0x0000 (---------------)  +   cloudcontrolled
	0x000309c2, // n0x0530 c0x0000 (---------------)  +   cn
	0x00007a02, // n0x0531 c0x0000 (---------------)  +   co
	0x00140008, // n0x0532 c0x0000 (---------------)  +   codespot
	0x00002dc2, // n0x0533 c0x0000 (---------------)  +   de
	0x00035348, // n0x0534 c0x0000 (---------------)  +   dnsalias
	0x0000b0c7, // n0x0535 c0x0000 (---------------)  +   dnsdojo
	0x0000dccb, // n0x0536 c0x0000 (---------------)  +   doesntexist
	0x000cd889, // n0x0537 c0x0000 (---------------)  +   dontexist
	0x00035247, // n0x0538 c0x0000 (---------------)  +   doomdns
	0x000f3dcc, // n0x0539 c0x0000 (---------------)  +   dreamhosters
	0x001616ca, // n0x053a c0x0000 (---------------)  +   dyn-o-saur
	0x0009fe08, // n0x053b c0x0000 (---------------)  +   dynalias
	0x00025a0e, // n0x053c c0x0000 (---------------)  +   dyndns-at-home
	0x0002448e, // n0x053d c0x0000 (---------------)  +   dyndns-at-work
	0x00010c0b, // n0x053e c0x0000 (---------------)  +   dyndns-blog
	0x0001228b, // n0x053f c0x0000 (---------------)  +   dyndns-free
	0x00019b4b, // n0x0540 c0x0000 (---------------)  +   dyndns-home
	0x0001b5c9, // n0x0541 c0x0000 (---------------)  +   dyndns-ip
	0x0001d6cb, // n0x0542 c0x0000 (---------------)  +   dyndns-mail
	0x0001ed8d, // n0x0543 c0x0000 (---------------)  +   dyndns-office
	0x0003ad4b, // n0x0544 c0x0000 (---------------)  +   dyndns-pics
	0x0003b50d, // n0x0545 c0x0000 (---------------)  +   dyndns-remote
	0x000da30d, // n0x0546 c0x0000 (---------------)  +   dyndns-server
	0x0004d9ca, // n0x0547 c0x0000 (---------------)  +   dyndns-web
	0x0004ea0b, // n0x0548 c0x0000 (---------------)  +   dyndns-wiki
	0x0004f2cb, // n0x0549 c0x0000 (---------------)  +   dyndns-work
	0x0003cc90, // n0x054a c0x0000 (---------------)  +   elasticbeanstalk
	0x0009aa8f, // n0x054b c0x0000 (---------------)  +   est-a-la-maison
	0x000233cf, // n0x054c c0x0000 (---------------)  +   est-a-la-masion
	0x000a320d, // n0x054d c0x0000 (---------------)  +   est-le-patron
	0x00127690, // n0x054e c0x0000 (---------------)  +   est-mon-blogueur
	0x00010502, // n0x054f c0x0000 (---------------)  +   eu
	0x0004470b, // n0x0550 c0x0000 (---------------)  +   firebaseapp
	0x000504c8, // n0x0551 c0x0000 (---------------)  +   flynnhub
	0x0005e507, // n0x0552 c0x0000 (---------------)  +   from-ak
	0x000607c7, // n0x0553 c0x0000 (---------------)  +   from-al
	0x00060987, // n0x0554 c0x0000 (---------------)  +   from-ar
	0x00061447, // n0x0555 c0x0000 (---------------)  +   from-ca
	0x00062b07, // n0x0556 c0x0000 (---------------)  +   from-ct
	0x00062e07, // n0x0557 c0x0000 (---------------)  +   from-dc
	0x000633c7, // n0x0558 c0x0000 (---------------)  +   from-de
	0x00063687, // n0x0559 c0x0000 (---------------)  +   from-fl
	0x00063bc7, // n0x055a c0x0000 (---------------)  +   from-ga
	0x00063d87, // n0x055b c0x0000 (---------------)  +   from-hi
	0x00064ac7, // n0x055c c0x0000 (---------------)  +   from-ia
	0x00064c87, // n0x055d c0x0000 (---------------)  +   from-id
	0x00064e47, // n0x055e c0x0000 (---------------)  +   from-il
	0x00065007, // n0x055f c0x0000 (---------------)  +   from-in
	0x00065607, // n0x0560 c0x0000 (---------------)  +   from-ks
	0x000658c7, // n0x0561 c0x0000 (---------------)  +   from-ky
	0x00066d47, // n0x0562 c0x0000 (---------------)  +   from-ma
	0x00067487, // n0x0563 c0x0000 (---------------)  +   from-md
	0x00067ac7, // n0x0564 c0x0000 (---------------)  +   from-mi
	0x00068387, // n0x0565 c0x0000 (---------------)  +   from-mn
	0x00068547, // n0x0566 c0x0000 (---------------)  +   from-mo
	0x00068847, // n0x0567 c0x0000 (---------------)  +   from-ms
	0x00068c47, // n0x0568 c0x0000 (---------------)  +   from-mt
	0x000690c7, // n0x0569 c0x0000 (---------------)  +   from-nc
	0x0006aa47, // n0x056a c0x0000 (---------------)  +   from-nd
	0x0006ac07, // n0x056b c0x0000 (---------------)  +   from-ne
	0x0006adc7, // n0x056c c0x0000 (---------------)  +   from-nh
	0x0006b1c7, // n0x056d c0x0000 (---------------)  +   from-nj
	0x0006b547, // n0x056e c0x0000 (---------------)  +   from-nm
	0x0006bc07, // n0x056f c0x0000 (---------------)  +   from-nv
	0x0006c307, // n0x0570 c0x0000 (---------------)  +   from-oh
	0x0006c547, // n0x0571 c0x0000 (---------------)  +   from-ok
	0x0006cac7, // n0x0572 c0x0000 (---------------)  +   from-or
	0x0006cc87, // n0x0573 c0x0000 (---------------)  +   from-pa
	0x0006d707, // n0x0574 c0x0000 (---------------)  +   from-pr
	0x0006dec7, // n0x0575 c0x0000 (---------------)  +   from-ri
	0x0006e2c7, // n0x0576 c0x0000 (---------------)  +   from-sc
	0x0006f6c7, // n0x0577 c0x0000 (---------------)  +   from-sd
	0x0006f887, // n0x0578 c0x0000 (---------------)  +   from-tn
	0x0006fa47, // n0x0579 c0x0000 (---------------)  +   from-tx
	0x0006fe87, // n0x057a c0x0000 (---------------)  +   from-ut
	0x00070287, // n0x057b c0x0000 (---------------)  +   from-va
	0x00071387, // n0x057c c0x0000 (---------------)  +   from-vt
	0x00071687, // n0x057d c0x0000 (---------------)  +   from-wa
	0x00071847, // n0x057e c0x0000 (---------------)  +   from-wi
	0x00071bc7, // n0x057f c0x0000 (---------------)  +   from-wv
	0x00072007, // n0x0580 c0x0000 (---------------)  +   from-wy
	0x0000fb02, // n0x0581 c0x0000 (---------------)  +   gb
	0x000083c7, // n0x0582 c0x0000 (---------------)  +   getmyip
	0x000bb511, // n0x0583 c0x0000 (---------------)  +   githubusercontent
	0x0005558a, // n0x0584 c0x0000 (---------------)  +   googleapis
	0x0013fe8a, // n0x0585 c0x0000 (---------------)  +   googlecode
	0x00053106, // n0x0586 c0x0000 (---------------)  +   gotdns
	0x00005bc2, // n0x0587 c0x0000 (---------------)  +   gr
	0x001698c9, // n0x0588 c0x0000 (---------------)  +   herokuapp
	0x0008d809, // n0x0589 c0x0000 (---------------)  +   herokussl
	0x0003e44a, // n0x058a c0x0000 (---------------)  +   hobby-site
	0x0009f1c9, // n0x058b c0x0000 (---------------)  +   homelinux
	0x000a1908, // n0x058c c0x0000 (---------------)  +   homeunix
	0x00001e02, // n0x058d c0x0000 (---------------)  +   hu
	0x00108cc9, // n0x058e c0x0000 (---------------)  +   iamallama
	0x0006d94e, // n0x058f c0x0000 (---------------)  +   is-a-anarchist
	0x00014d8c, // n0x0590 c0x0000 (---------------)  +   is-a-blogger
	0x000cbe4f, // n0x0591 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0015998e, // n0x0592 c0x0000 (---------------)  +   is-a-bulls-fan
	0x000a258c, // n0x0593 c0x0000 (---------------)  +   is-a-caterer
	0x001402c9, // n0x0594 c0x0000 (---------------)  +   is-a-chef
	0x00032a91, // n0x0595 c0x0000 (---------------)  +   is-a-conservative
	0x00036788, // n0x0596 c0x0000 (---------------)  +   is-a-cpa
	0x00152e52, // n0x0597 c0x0000 (---------------)  +   is-a-cubicle-slave
	0x0004344d, // n0x0598 c0x0000 (---------------)  +   is-a-democrat
	0x00055c4d, // n0x0599 c0x0000 (---------------)  +   is-a-designer
	0x0005758b, // n0x059a c0x0000 (---------------)  +   is-a-doctor
	0x0005a155, // n0x059b c0x0000 (---------------)  +   is-a-financialadvisor
	0x00067d49, // n0x059c c0x0000 (---------------)  +   is-a-geek
	0x0006e04a, // n0x059d c0x0000 (---------------)  +   is-a-green
	0x00073f49, // n0x059e c0x0000 (---------------)  +   is-a-guru
	0x0007ad90, // n0x059f c0x0000 (---------------)  +   is-a-hard-worker
	0x0007cf4b, // n0x05a0 c0x0000 (---------------)  +   is-a-hunter
	0x0011c74f, // n0x05a1 c0x0000 (---------------)  +   is-a-landscaper
	0x0014edcb, // n0x05a2 c0x0000 (---------------)  +   is-a-lawyer
	0x0008578c, // n0x05a3 c0x0000 (---------------)  +   is-a-liberal
	0x000941d0, // n0x05a4 c0x0000 (---------------)  +   is-a-libertarian
	0x000a8b0a, // n0x05a5 c0x0000 (---------------)  +   is-a-llama
	0x000a908d, // n0x05a6 c0x0000 (---------------)  +   is-a-musician
	0x000dfb8e, // n0x05a7 c0x0000 (---------------)  +   is-a-nascarfan
	0x000b58ca, // n0x05a8 c0x0000 (---------------)  +   is-a-nurse
	0x000df58c, // n0x05a9 c0x0000 (---------------)  +   is-a-painter
	0x000f1814, // n0x05aa c0x0000 (---------------)  +   is-a-personaltrainer
	0x000fa1d1, // n0x05ab c0x0000 (---------------)  +   is-a-photographer
	0x000fde4b, // n0x05ac c0x0000 (---------------)  +   is-a-player
	0x000aa3cf, // n0x05ad c0x0000 (---------------)  +   is-a-republican
	0x000ac5cd, // n0x05ae c0x0000 (---------------)  +   is-a-rockstar
	0x000ad28e, // n0x05af c0x0000 (---------------)  +   is-a-socialist
	0x000b108c, // n0x05b0 c0x0000 (---------------)  +   is-a-student
	0x000b224c, // n0x05b1 c0x0000 (---------------)  +   is-a-teacher
	0x000b55cb, // n0x05b2 c0x0000 (---------------)  +   is-a-techie
	0x000b724e, // n0x05b3 c0x0000 (---------------)  +   is-a-therapist
	0x000b8250, // n0x05b4 c0x0000 (---------------)  +   is-an-accountant
	0x000b908b, // n0x05b5 c0x0000 (---------------)  +   is-an-actor
	0x000dc70d, // n0x05b6 c0x0000 (---------------)  +   is-an-actress
	0x000e490f, // n0x05b7 c0x0000 (---------------)  +   is-an-anarchist
	0x000bc94c, // n0x05b8 c0x0000 (---------------)  +   is-an-artist
	0x000c3d4e, // n0x05b9 c0x0000 (---------------)  +   is-an-engineer
	0x000c7691, // n0x05ba c0x0000 (---------------)  +   is-an-entertainer
	0x0011d84c, // n0x05bb c0x0000 (---------------)  +   is-certified
	0x0013a2c7, // n0x05bc c0x0000 (---------------)  +   is-gone
	0x000dd78d, // n0x05bd c0x0000 (---------------)  +   is-into-anime
	0x000df1cc, // n0x05be c0x0000 (---------------)  +   is-into-cars
	0x000eadd0, // n0x05bf c0x0000 (---------------)  +   is-into-cartoons
	0x000ebc4d, // n0x05c0 c0x0000 (---------------)  +   is-into-games
	0x00157547, // n0x05c1 c0x0000 (---------------)  +   is-leet
	0x000eff50, // n0x05c2 c0x0000 (---------------)  +   is-not-certified
	0x000f5008, // n0x05c3 c0x0000 (---------------)  +   is-slick
	0x000fb54b, // n0x05c4 c0x0000 (---------------)  +   is-uberleet
	0x0013030f, // n0x05c5 c0x0000 (---------------)  +   is-with-theband
	0x0014bd08, // n0x05c6 c0x0000 (---------------)  +   isa-geek
	0x0005578d, // n0x05c7 c0x0000 (---------------)  +   isa-hockeynut
	0x00141d50, // n0x05c8 c0x0000 (---------------)  +   issmarterthanyou
	0x000a9f43, // n0x05c9 c0x0000 (---------------)  +   jpn
	0x0000e742, // n0x05ca c0x0000 (---------------)  +   kr
	0x00054389, // n0x05cb c0x0000 (---------------)  +   likes-pie
	0x0002580a, // n0x05cc c0x0000 (---------------)  +   likescandy
	0x0009fc83, // n0x05cd c0x0000 (---------------)  +   mex
	0x0001b8c8, // n0x05ce c0x0000 (---------------)  +   neat-url
	0x00009287, // n0x05cf c0x0000 (---------------)  +   nfshost
	0x00001b82, // n0x05d0 c0x0000 (---------------)  +   no
	0x0004a90a, // n0x05d1 c0x0000 (---------------)  +   operaunite
	0x0008740f, // n0x05d2 c0x0000 (---------------)  +   outsystemscloud
	0x00150482, // n0x05d3 c0x0000 (---------------)  +   qc
	0x000e8547, // n0x05d4 c0x0000 (---------------)  +   rhcloud
	0x00000c02, // n0x05d5 c0x0000 (---------------)  +   ro
	0x0000c6c2, // n0x05d6 c0x0000 (---------------)  +   ru
	0x00002882, // n0x05d7 c0x0000 (---------------)  +   sa
	0x0006e6d0, // n0x05d8 c0x0000 (---------------)  +   saves-the-whales
	0x00006d42, // n0x05d9 c0x0000 (---------------)  +   se
	0x000ff606, // n0x05da c0x0000 (---------------)  +   selfip
	0x00092c0e, // n0x05db c0x0000 (---------------)  +   sells-for-less
	0x000a5ccb, // n0x05dc c0x0000 (---------------)  +   sells-for-u
	0x00016d08, // n0x05dd c0x0000 (---------------)  +   servebbs
	0x000e064a, // n0x05de c0x0000 (---------------)  +   simple-url
	0x000e5c8d, // n0x05df c0x0000 (---------------)  +   space-to-rent
	0x0016b28c, // n0x05e0 c0x0000 (---------------)  +   teaches-yoga
	0x00000402, // n0x05e1 c0x0000 (---------------)  +   uk
	0x000054c2, // n0x05e2 c0x0000 (---------------)  +   us
	0x000193c2, // n0x05e3 c0x0000 (---------------)  +   uy
	0x0005548a, // n0x05e4 c0x0000 (---------------)  +   withgoogle
	0x000b86ce, // n0x05e5 c0x0000 (---------------)  +   writesthisblog
	0x000e9148, // n0x05e6 c0x0000 (---------------)  +   yolasite
	0x00003502, // n0x05e7 c0x0000 (---------------)  +   za
	0x0f433987, // n0x05e8 c0x003d (n0x05ff-n0x0607)  +   compute
	0x0f833989, // n0x05e9 c0x003e (n0x0607-n0x0609)  +   compute-1
	0x000116c3, // n0x05ea c0x0000 (---------------)  +   elb
	0x00005d82, // n0x05eb c0x0000 (---------------)  +   s3
	0x00112b11, // n0x05ec c0x0000 (---------------)  +   s3-ap-northeast-1
	0x00118651, // n0x05ed c0x0000 (---------------)  +   s3-ap-southeast-1
	0x0016e991, // n0x05ee c0x0000 (---------------)  +   s3-ap-southeast-2
	0x0011a38c, // n0x05ef c0x0000 (---------------)  +   s3-eu-west-1
	0x0011e7d5, // n0x05f0 c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x0012834c, // n0x05f1 c0x0000 (---------------)  +   s3-sa-east-1
	0x00135d10, // n0x05f2 c0x0000 (---------------)  +   s3-us-gov-west-1
	0x0014ce4c, // n0x05f3 c0x0000 (---------------)  +   s3-us-west-1
	0x0015eb4c, // n0x05f4 c0x0000 (---------------)  +   s3-us-west-2
	0x00161a99, // n0x05f5 c0x0000 (---------------)  +   s3-website-ap-northeast-1
	0x00005d99, // n0x05f6 c0x0000 (---------------)  +   s3-website-ap-southeast-1
	0x0000f099, // n0x05f7 c0x0000 (---------------)  +   s3-website-ap-southeast-2
	0x00010254, // n0x05f8 c0x0000 (---------------)  +   s3-website-eu-west-1
	0x00010f54, // n0x05f9 c0x0000 (---------------)  +   s3-website-sa-east-1
	0x00011cd4, // n0x05fa c0x0000 (---------------)  +   s3-website-us-east-1
	0x00015458, // n0x05fb c0x0000 (---------------)  +   s3-website-us-gov-west-1
	0x00016ed4, // n0x05fc c0x0000 (---------------)  +   s3-website-us-west-1
	0x000183d4, // n0x05fd c0x0000 (---------------)  +   s3-website-us-west-2
	0x00011f89, // n0x05fe c0x0000 (---------------)  +   us-east-1
	0x00112bce, // n0x05ff c0x0000 (---------------)  +   ap-northeast-1
	0x0000604e, // n0x0600 c0x0000 (---------------)  +   ap-southeast-1
	0x0000f34e, // n0x0601 c0x0000 (---------------)  +   ap-southeast-2
	0x00010509, // n0x0602 c0x0000 (---------------)  +   eu-west-1
	0x00011209, // n0x0603 c0x0000 (---------------)  +   sa-east-1
	0x0001570d, // n0x0604 c0x0000 (---------------)  +   us-gov-west-1
	0x00017189, // n0x0605 c0x0000 (---------------)  +   us-west-1
	0x00018689, // n0x0606 c0x0000 (---------------)  +   us-west-2
	0x000fd103, // n0x0607 c0x0000 (---------------)  +   z-1
	0x0001d203, // n0x0608 c0x0000 (---------------)  +   z-2
	0x00201d82, // n0x0609 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x060a c0x0000 (---------------)  + I co
	0x00202542, // n0x060b c0x0000 (---------------)  + I ed
	0x0021c5c2, // n0x060c c0x0000 (---------------)  + I fi
	0x00206cc2, // n0x060d c0x0000 (---------------)  + I go
	0x00200bc2, // n0x060e c0x0000 (---------------)  + I or
	0x00202882, // n0x060f c0x0000 (---------------)  + I sa
	0x00222603, // n0x0610 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0611 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0612 c0x0000 (---------------)  + I gov
	0x0021c543, // n0x0613 c0x0000 (---------------)  + I inf
	0x00201603, // n0x0614 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0615 c0x0000 (---------------)  + I org
	0x000b8948, // n0x0616 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x0617 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0618 c0x0000 (---------------)  + I edu
	0x00201603, // n0x0619 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x061a c0x0000 (---------------)  + I org
	0x00011c03, // n0x061b c0x0000 (---------------)  +   ath
	0x002157c3, // n0x061c c0x0000 (---------------)  + I gov
	0x000b8948, // n0x061d c0x0000 (---------------)  +   blogspot
	0x000b8948, // n0x061e c0x0000 (---------------)  +   blogspot
	0x00022603, // n0x061f c0x0000 (---------------)  +   com
	0x001648cf, // n0x0620 c0x0000 (---------------)  +   fuettertdasnetz
	0x000cda0a, // n0x0621 c0x0000 (---------------)  +   isteingeek
	0x000ad547, // n0x0622 c0x0000 (---------------)  +   istmein
	0x00045d4a, // n0x0623 c0x0000 (---------------)  +   lebtimnetz
	0x000d48ca, // n0x0624 c0x0000 (---------------)  +   leitungsen
	0x00121e8d, // n0x0625 c0x0000 (---------------)  +   traeumtgerade
	0x000b8948, // n0x0626 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x0627 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0628 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0629 c0x0000 (---------------)  + I gov
	0x00201603, // n0x062a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x062b c0x0000 (---------------)  + I org
	0x00201383, // n0x062c c0x0000 (---------------)  + I art
	0x00222603, // n0x062d c0x0000 (---------------)  + I com
	0x0027a643, // n0x062e c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x062f c0x0000 (---------------)  + I gob
	0x002157c3, // n0x0630 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0631 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0632 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0633 c0x0000 (---------------)  + I org
	0x002dc183, // n0x0634 c0x0000 (---------------)  + I sld
	0x00205e43, // n0x0635 c0x0000 (---------------)  + I web
	0x00201383, // n0x0636 c0x0000 (---------------)  + I art
	0x0029cfc4, // n0x0637 c0x0000 (---------------)  + I asso
	0x00222603, // n0x0638 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0639 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x063a c0x0000 (---------------)  + I gov
	0x00201603, // n0x063b c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x063c c0x0000 (---------------)  + I org
	0x00214cc3, // n0x063d c0x0000 (---------------)  + I pol
	0x00222603, // n0x063e c0x0000 (---------------)  + I com
	0x0027a643, // n0x063f c0x0000 (---------------)  + I edu
	0x0021c5c3, // n0x0640 c0x0000 (---------------)  + I fin
	0x0020dbc3, // n0x0641 c0x0000 (---------------)  + I gob
	0x002157c3, // n0x0642 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x0643 c0x0000 (---------------)  + I info
	0x0021bdc3, // n0x0644 c0x0000 (---------------)  + I k12
	0x00225d03, // n0x0645 c0x0000 (---------------)  + I med
	0x0023f703, // n0x0646 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0647 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0648 c0x0000 (---------------)  + I org
	0x002d8443, // n0x0649 c0x0000 (---------------)  + I pro
	0x00314283, // n0x064a c0x0000 (---------------)  + I aip
	0x00222603, // n0x064b c0x0000 (---------------)  + I com
	0x0027a643, // n0x064c c0x0000 (---------------)  + I edu
	0x00242203, // n0x064d c0x0000 (---------------)  + I fie
	0x002157c3, // n0x064e c0x0000 (---------------)  + I gov
	0x002858c3, // n0x064f c0x0000 (---------------)  + I lib
	0x00225d03, // n0x0650 c0x0000 (---------------)  + I med
	0x0021f5c3, // n0x0651 c0x0000 (---------------)  + I org
	0x002d80c3, // n0x0652 c0x0000 (---------------)  + I pri
	0x00368b84, // n0x0653 c0x0000 (---------------)  + I riik
	0x00222603, // n0x0654 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0655 c0x0000 (---------------)  + I edu
	0x002a19c3, // n0x0656 c0x0000 (---------------)  + I eun
	0x002157c3, // n0x0657 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0658 c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x0659 c0x0000 (---------------)  + I name
	0x00201603, // n0x065a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x065b c0x0000 (---------------)  + I org
	0x00218bc3, // n0x065c c0x0000 (---------------)  + I sci
	0x13a22603, // n0x065d c0x004e (n0x0662-n0x0663)  + I com
	0x0027a643, // n0x065e c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x065f c0x0000 (---------------)  + I gob
	0x00214103, // n0x0660 c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x0661 c0x0000 (---------------)  + I org
	0x000b8948, // n0x0662 c0x0000 (---------------)  +   blogspot
	0x00314c43, // n0x0663 c0x0000 (---------------)  + I biz
	0x00222603, // n0x0664 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0665 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0666 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x0667 c0x0000 (---------------)  + I info
	0x0022aec4, // n0x0668 c0x0000 (---------------)  + I name
	0x0021f5c3, // n0x0669 c0x0000 (---------------)  + I org
	0x00310d45, // n0x066a c0x0000 (---------------)  + I aland
	0x000b8948, // n0x066b c0x0000 (---------------)  +   blogspot
	0x00004843, // n0x066c c0x0000 (---------------)  +   iki
	0x00312288, // n0x066d c0x0000 (---------------)  + I aeroport
	0x00247b87, // n0x066e c0x0000 (---------------)  + I assedic
	0x0029cfc4, // n0x066f c0x0000 (---------------)  + I asso
	0x0031e1c6, // n0x0670 c0x0000 (---------------)  + I avocat
	0x00327586, // n0x0671 c0x0000 (---------------)  + I avoues
	0x000b8948, // n0x0672 c0x0000 (---------------)  +   blogspot
	0x00307f03, // n0x0673 c0x0000 (---------------)  + I cci
	0x0029a489, // n0x0674 c0x0000 (---------------)  + I chambagri
	0x00275755, // n0x0675 c0x0000 (---------------)  + I chirurgiens-dentistes
	0x00222603, // n0x0676 c0x0000 (---------------)  + I com
	0x00222412, // n0x0677 c0x0000 (---------------)  + I experts-comptables
	0x002221cf, // n0x0678 c0x0000 (---------------)  + I geometre-expert
	0x00368f84, // n0x0679 c0x0000 (---------------)  + I gouv
	0x00269905, // n0x067a c0x0000 (---------------)  + I greta
	0x0024b610, // n0x067b c0x0000 (---------------)  + I huissier-justice
	0x002eef07, // n0x067c c0x0000 (---------------)  + I medecin
	0x00214103, // n0x067d c0x0000 (---------------)  + I nom
	0x002bef08, // n0x067e c0x0000 (---------------)  + I notaires
	0x002c860a, // n0x067f c0x0000 (---------------)  + I pharmacien
	0x00231304, // n0x0680 c0x0000 (---------------)  + I port
	0x002d7b03, // n0x0681 c0x0000 (---------------)  + I prd
	0x002487c6, // n0x0682 c0x0000 (---------------)  + I presse
	0x00200142, // n0x0683 c0x0000 (---------------)  + I tm
	0x002de14b, // n0x0684 c0x0000 (---------------)  + I veterinaire
	0x00222603, // n0x0685 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0686 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0687 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0688 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0689 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x068a c0x0000 (---------------)  + I org
	0x002dbbc3, // n0x068b c0x0000 (---------------)  + I pvt
	0x00207a02, // n0x068c c0x0000 (---------------)  + I co
	0x00201603, // n0x068d c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x068e c0x0000 (---------------)  + I org
	0x00222603, // n0x068f c0x0000 (---------------)  + I com
	0x0027a643, // n0x0690 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0691 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0692 c0x0000 (---------------)  + I mil
	0x0021f5c3, // n0x0693 c0x0000 (---------------)  + I org
	0x00222603, // n0x0694 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0695 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0696 c0x0000 (---------------)  + I gov
	0x00223143, // n0x0697 c0x0000 (---------------)  + I ltd
	0x0022ab03, // n0x0698 c0x0000 (---------------)  + I mod
	0x0021f5c3, // n0x0699 c0x0000 (---------------)  + I org
	0x00201d82, // n0x069a c0x0000 (---------------)  + I ac
	0x00222603, // n0x069b c0x0000 (---------------)  + I com
	0x0027a643, // n0x069c c0x0000 (---------------)  + I edu
	0x002157c3, // n0x069d c0x0000 (---------------)  + I gov
	0x00201603, // n0x069e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x069f c0x0000 (---------------)  + I org
	0x0029cfc4, // n0x06a0 c0x0000 (---------------)  + I asso
	0x00222603, // n0x06a1 c0x0000 (---------------)  + I com
	0x0027a643, // n0x06a2 c0x0000 (---------------)  + I edu
	0x0020e884, // n0x06a3 c0x0000 (---------------)  + I mobi
	0x00201603, // n0x06a4 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x06a5 c0x0000 (---------------)  + I org
	0x000b8948, // n0x06a6 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x06a7 c0x0000 (---------------)  + I com
	0x0027a643, // n0x06a8 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x06a9 c0x0000 (---------------)  + I gov
	0x00201603, // n0x06aa c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x06ab c0x0000 (---------------)  + I org
	0x00222603, // n0x06ac c0x0000 (---------------)  + I com
	0x0027a643, // n0x06ad c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x06ae c0x0000 (---------------)  + I gob
	0x00214b03, // n0x06af c0x0000 (---------------)  + I ind
	0x0023f703, // n0x06b0 c0x0000 (---------------)  + I mil
	0x00201603, // n0x06b1 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x06b2 c0x0000 (---------------)  + I org
	0x00207a02, // n0x06b3 c0x0000 (---------------)  + I co
	0x00222603, // n0x06b4 c0x0000 (---------------)  + I com
	0x00201603, // n0x06b5 c0x0000 (---------------)  + I net
	0x000b8948, // n0x06b6 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x06b7 c0x0000 (---------------)  + I com
	0x0027a643, // n0x06b8 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x06b9 c0x0000 (---------------)  + I gov
	0x00308f83, // n0x06ba c0x0000 (---------------)  + I idv
	0x00201603, // n0x06bb c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x06bc c0x0000 (---------------)  + I org
	0x003732ca, // n0x06bd c0x0000 (---------------)  + I xn--55qx5d
	0x0030cc09, // n0x06be c0x0000 (---------------)  + I xn--ciqpn
	0x0032534b, // n0x06bf c0x0000 (---------------)  + I xn--gmq050i
	0x003258ca, // n0x06c0 c0x0000 (---------------)  + I xn--gmqw5a
	0x0032b80a, // n0x06c1 c0x0000 (---------------)  + I xn--io0a7i
	0x00334f8b, // n0x06c2 c0x0000 (---------------)  + I xn--lcvr32d
	0x0033f38a, // n0x06c3 c0x0000 (---------------)  + I xn--mk0axi
	0x00348b0a, // n0x06c4 c0x0000 (---------------)  + I xn--mxtq1m
	0x0034c44a, // n0x06c5 c0x0000 (---------------)  + I xn--od0alg
	0x0034c6cb, // n0x06c6 c0x0000 (---------------)  + I xn--od0aq3b
	0x003623c9, // n0x06c7 c0x0000 (---------------)  + I xn--tn0ag
	0x00363cca, // n0x06c8 c0x0000 (---------------)  + I xn--uc0atv
	0x0036418b, // n0x06c9 c0x0000 (---------------)  + I xn--uc0ay4a
	0x0037034b, // n0x06ca c0x0000 (---------------)  + I xn--wcvs22d
	0x0037404a, // n0x06cb c0x0000 (---------------)  + I xn--zf0avx
	0x00222603, // n0x06cc c0x0000 (---------------)  + I com
	0x0027a643, // n0x06cd c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x06ce c0x0000 (---------------)  + I gob
	0x0023f703, // n0x06cf c0x0000 (---------------)  + I mil
	0x00201603, // n0x06d0 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x06d1 c0x0000 (---------------)  + I org
	0x00222603, // n0x06d2 c0x0000 (---------------)  + I com
	0x0025e504, // n0x06d3 c0x0000 (---------------)  + I from
	0x0020f842, // n0x06d4 c0x0000 (---------------)  + I iz
	0x0022aec4, // n0x06d5 c0x0000 (---------------)  + I name
	0x00277285, // n0x06d6 c0x0000 (---------------)  + I adult
	0x00201383, // n0x06d7 c0x0000 (---------------)  + I art
	0x0029cfc4, // n0x06d8 c0x0000 (---------------)  + I asso
	0x00222603, // n0x06d9 c0x0000 (---------------)  + I com
	0x00239dc4, // n0x06da c0x0000 (---------------)  + I coop
	0x0027a643, // n0x06db c0x0000 (---------------)  + I edu
	0x00245bc4, // n0x06dc c0x0000 (---------------)  + I firm
	0x00368f84, // n0x06dd c0x0000 (---------------)  + I gouv
	0x0021c704, // n0x06de c0x0000 (---------------)  + I info
	0x00225d03, // n0x06df c0x0000 (---------------)  + I med
	0x00201603, // n0x06e0 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x06e1 c0x0000 (---------------)  + I org
	0x002f1945, // n0x06e2 c0x0000 (---------------)  + I perso
	0x00214cc3, // n0x06e3 c0x0000 (---------------)  + I pol
	0x002d8443, // n0x06e4 c0x0000 (---------------)  + I pro
	0x00280183, // n0x06e5 c0x0000 (---------------)  + I rel
	0x0024f584, // n0x06e6 c0x0000 (---------------)  + I shop
	0x0021be44, // n0x06e7 c0x0000 (---------------)  + I 2000
	0x0022a005, // n0x06e8 c0x0000 (---------------)  + I agrar
	0x000b8948, // n0x06e9 c0x0000 (---------------)  +   blogspot
	0x00253344, // n0x06ea c0x0000 (---------------)  + I bolt
	0x0023a9c6, // n0x06eb c0x0000 (---------------)  + I casino
	0x00357e04, // n0x06ec c0x0000 (---------------)  + I city
	0x00207a02, // n0x06ed c0x0000 (---------------)  + I co
	0x002acc07, // n0x06ee c0x0000 (---------------)  + I erotica
	0x00276707, // n0x06ef c0x0000 (---------------)  + I erotika
	0x00242cc4, // n0x06f0 c0x0000 (---------------)  + I film
	0x00258045, // n0x06f1 c0x0000 (---------------)  + I forum
	0x002ebe45, // n0x06f2 c0x0000 (---------------)  + I games
	0x002a7585, // n0x06f3 c0x0000 (---------------)  + I hotel
	0x0021c704, // n0x06f4 c0x0000 (---------------)  + I info
	0x0027c4c8, // n0x06f5 c0x0000 (---------------)  + I ingatlan
	0x0020b206, // n0x06f6 c0x0000 (---------------)  + I jogasz
	0x002d5a88, // n0x06f7 c0x0000 (---------------)  + I konyvelo
	0x00288d45, // n0x06f8 c0x0000 (---------------)  + I lakas
	0x0027ab45, // n0x06f9 c0x0000 (---------------)  + I media
	0x0023fc04, // n0x06fa c0x0000 (---------------)  + I news
	0x0021f5c3, // n0x06fb c0x0000 (---------------)  + I org
	0x002d82c4, // n0x06fc c0x0000 (---------------)  + I priv
	0x00333c86, // n0x06fd c0x0000 (---------------)  + I reklam
	0x002488c3, // n0x06fe c0x0000 (---------------)  + I sex
	0x0024f584, // n0x06ff c0x0000 (---------------)  + I shop
	0x00293bc5, // n0x0700 c0x0000 (---------------)  + I sport
	0x003005c4, // n0x0701 c0x0000 (---------------)  + I suli
	0x002081c4, // n0x0702 c0x0000 (---------------)  + I szex
	0x00200142, // n0x0703 c0x0000 (---------------)  + I tm
	0x00262c86, // n0x0704 c0x0000 (---------------)  + I tozsde
	0x00359fc6, // n0x0705 c0x0000 (---------------)  + I utazas
	0x002f68c5, // n0x0706 c0x0000 (---------------)  + I video
	0x00201d82, // n0x0707 c0x0000 (---------------)  + I ac
	0x00314c43, // n0x0708 c0x0000 (---------------)  + I biz
	0x00207a02, // n0x0709 c0x0000 (---------------)  + I co
	0x00238504, // n0x070a c0x0000 (---------------)  + I desa
	0x00206cc2, // n0x070b c0x0000 (---------------)  + I go
	0x0023f703, // n0x070c c0x0000 (---------------)  + I mil
	0x00208482, // n0x070d c0x0000 (---------------)  + I my
	0x00201603, // n0x070e c0x0000 (---------------)  + I net
	0x00200bc2, // n0x070f c0x0000 (---------------)  + I or
	0x002526c3, // n0x0710 c0x0000 (---------------)  + I sch
	0x00205e43, // n0x0711 c0x0000 (---------------)  + I web
	0x000b8948, // n0x0712 c0x0000 (---------------)  +   blogspot
	0x002157c3, // n0x0713 c0x0000 (---------------)  + I gov
	0x18e07a02, // n0x0714 c0x0063 (n0x0715-n0x0716)  o I co
	0x000b8948, // n0x0715 c0x0000 (---------------)  +   blogspot
	0x00201d82, // n0x0716 c0x0000 (---------------)  + I ac
	0x19607a02, // n0x0717 c0x0065 (n0x071d-n0x071f)  + I co
	0x00222603, // n0x0718 c0x0000 (---------------)  + I com
	0x00201603, // n0x0719 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x071a c0x0000 (---------------)  + I org
	0x00204ec2, // n0x071b c0x0000 (---------------)  + I tt
	0x00292602, // n0x071c c0x0000 (---------------)  + I tv
	0x00223143, // n0x071d c0x0000 (---------------)  + I ltd
	0x002d2a43, // n0x071e c0x0000 (---------------)  + I plc
	0x00201d82, // n0x071f c0x0000 (---------------)  + I ac
	0x000b8948, // n0x0720 c0x0000 (---------------)  +   blogspot
	0x00207a02, // n0x0721 c0x0000 (---------------)  + I co
	0x0027a643, // n0x0722 c0x0000 (---------------)  + I edu
	0x00245bc4, // n0x0723 c0x0000 (---------------)  + I firm
	0x00204b03, // n0x0724 c0x0000 (---------------)  + I gen
	0x002157c3, // n0x0725 c0x0000 (---------------)  + I gov
	0x00214b03, // n0x0726 c0x0000 (---------------)  + I ind
	0x0023f703, // n0x0727 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0728 c0x0000 (---------------)  + I net
	0x00213e03, // n0x0729 c0x0000 (---------------)  + I nic
	0x0021f5c3, // n0x072a c0x0000 (---------------)  + I org
	0x00218b43, // n0x072b c0x0000 (---------------)  + I res
	0x00113953, // n0x072c c0x0000 (---------------)  +   barrel-of-knowledge
	0x00118d14, // n0x072d c0x0000 (---------------)  +   barrell-of-knowledge
	0x00010c06, // n0x072e c0x0000 (---------------)  +   dyndns
	0x00052007, // n0x072f c0x0000 (---------------)  +   for-our
	0x000e7789, // n0x0730 c0x0000 (---------------)  +   groks-the
	0x0012244a, // n0x0731 c0x0000 (---------------)  +   groks-this
	0x0008218d, // n0x0732 c0x0000 (---------------)  +   here-for-more
	0x0001ce4a, // n0x0733 c0x0000 (---------------)  +   knowsitall
	0x000ff606, // n0x0734 c0x0000 (---------------)  +   selfip
	0x0004db86, // n0x0735 c0x0000 (---------------)  +   webhop
	0x00210502, // n0x0736 c0x0000 (---------------)  + I eu
	0x00222603, // n0x0737 c0x0000 (---------------)  + I com
	0x000bb506, // n0x0738 c0x0000 (---------------)  +   github
	0x0004d943, // n0x0739 c0x0000 (---------------)  +   nid
	0x00222603, // n0x073a c0x0000 (---------------)  + I com
	0x0027a643, // n0x073b c0x0000 (---------------)  + I edu
	0x002157c3, // n0x073c c0x0000 (---------------)  + I gov
	0x0023f703, // n0x073d c0x0000 (---------------)  + I mil
	0x00201603, // n0x073e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x073f c0x0000 (---------------)  + I org
	0x00201d82, // n0x0740 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x0741 c0x0000 (---------------)  + I co
	0x002157c3, // n0x0742 c0x0000 (---------------)  + I gov
	0x00202f82, // n0x0743 c0x0000 (---------------)  + I id
	0x00201603, // n0x0744 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0745 c0x0000 (---------------)  + I org
	0x002526c3, // n0x0746 c0x0000 (---------------)  + I sch
	0x0033accf, // n0x0747 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0033b08e, // n0x0748 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x00222603, // n0x0749 c0x0000 (---------------)  + I com
	0x00041647, // n0x074a c0x0000 (---------------)  +   cupcake
	0x0027a643, // n0x074b c0x0000 (---------------)  + I edu
	0x002157c3, // n0x074c c0x0000 (---------------)  + I gov
	0x00223a83, // n0x074d c0x0000 (---------------)  + I int
	0x00201603, // n0x074e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x074f c0x0000 (---------------)  + I org
	0x0020bcc3, // n0x0750 c0x0000 (---------------)  + I abr
	0x0036a507, // n0x0751 c0x0000 (---------------)  + I abruzzo
	0x00200482, // n0x0752 c0x0000 (---------------)  + I ag
	0x0032c189, // n0x0753 c0x0000 (---------------)  + I agrigento
	0x00202082, // n0x0754 c0x0000 (---------------)  + I al
	0x0026e9cb, // n0x0755 c0x0000 (---------------)  + I alessandria
	0x002dbe4a, // n0x0756 c0x0000 (---------------)  + I alto-adige
	0x002e0d49, // n0x0757 c0x0000 (---------------)  + I altoadige
	0x00200202, // n0x0758 c0x0000 (---------------)  + I an
	0x00237146, // n0x0759 c0x0000 (---------------)  + I ancona
	0x00277515, // n0x075a c0x0000 (---------------)  + I andria-barletta-trani
	0x0026eb15, // n0x075b c0x0000 (---------------)  + I andria-trani-barletta
	0x00282fd3, // n0x075c c0x0000 (---------------)  + I andriabarlettatrani
	0x0026f093, // n0x075d c0x0000 (---------------)  + I andriatranibarletta
	0x00204382, // n0x075e c0x0000 (---------------)  + I ao
	0x00208b05, // n0x075f c0x0000 (---------------)  + I aosta
	0x003684cc, // n0x0760 c0x0000 (---------------)  + I aosta-valley
	0x002af18b, // n0x0761 c0x0000 (---------------)  + I aostavalley
	0x00268185, // n0x0762 c0x0000 (---------------)  + I aoste
	0x00205c42, // n0x0763 c0x0000 (---------------)  + I ap
	0x00280082, // n0x0764 c0x0000 (---------------)  + I aq
	0x002d1086, // n0x0765 c0x0000 (---------------)  + I aquila
	0x00200a42, // n0x0766 c0x0000 (---------------)  + I ar
	0x0025e8c6, // n0x0767 c0x0000 (---------------)  + I arezzo
	0x0029ff8d, // n0x0768 c0x0000 (---------------)  + I ascoli-piceno
	0x002354cc, // n0x0769 c0x0000 (---------------)  + I ascolipiceno
	0x0023cd04, // n0x076a c0x0000 (---------------)  + I asti
	0x00200102, // n0x076b c0x0000 (---------------)  + I at
	0x002025c2, // n0x076c c0x0000 (---------------)  + I av
	0x00296b48, // n0x076d c0x0000 (---------------)  + I avellino
	0x00201902, // n0x076e c0x0000 (---------------)  + I ba
	0x00250686, // n0x076f c0x0000 (---------------)  + I balsan
	0x0028e704, // n0x0770 c0x0000 (---------------)  + I bari
	0x002776d5, // n0x0771 c0x0000 (---------------)  + I barletta-trani-andria
	0x00283153, // n0x0772 c0x0000 (---------------)  + I barlettatraniandria
	0x00211603, // n0x0773 c0x0000 (---------------)  + I bas
	0x0032728a, // n0x0774 c0x0000 (---------------)  + I basilicata
	0x00222a07, // n0x0775 c0x0000 (---------------)  + I belluno
	0x003452c9, // n0x0776 c0x0000 (---------------)  + I benevento
	0x00349947, // n0x0777 c0x0000 (---------------)  + I bergamo
	0x00367842, // n0x0778 c0x0000 (---------------)  + I bg
	0x00200002, // n0x0779 c0x0000 (---------------)  + I bi
	0x00373a06, // n0x077a c0x0000 (---------------)  + I biella
	0x0020f902, // n0x077b c0x0000 (---------------)  + I bl
	0x000b8948, // n0x077c c0x0000 (---------------)  +   blogspot
	0x00211442, // n0x077d c0x0000 (---------------)  + I bn
	0x00200fc2, // n0x077e c0x0000 (---------------)  + I bo
	0x00200fc7, // n0x077f c0x0000 (---------------)  + I bologna
	0x002f7e47, // n0x0780 c0x0000 (---------------)  + I bolzano
	0x00215e85, // n0x0781 c0x0000 (---------------)  + I bozen
	0x00206842, // n0x0782 c0x0000 (---------------)  + I br
	0x00218b07, // n0x0783 c0x0000 (---------------)  + I brescia
	0x00218cc8, // n0x0784 c0x0000 (---------------)  + I brindisi
	0x00205ec2, // n0x0785 c0x0000 (---------------)  + I bs
	0x00245dc2, // n0x0786 c0x0000 (---------------)  + I bt
	0x0022a402, // n0x0787 c0x0000 (---------------)  + I bz
	0x0020bc02, // n0x0788 c0x0000 (---------------)  + I ca
	0x00255108, // n0x0789 c0x0000 (---------------)  + I cagliari
	0x0020bc03, // n0x078a c0x0000 (---------------)  + I cal
	0x0020bc08, // n0x078b c0x0000 (---------------)  + I calabria
	0x00313f8d, // n0x078c c0x0000 (---------------)  + I caltanissetta
	0x0021f383, // n0x078d c0x0000 (---------------)  + I cam
	0x00308b48, // n0x078e c0x0000 (---------------)  + I campania
	0x0023d48f, // n0x078f c0x0000 (---------------)  + I campidano-medio
	0x0023d84e, // n0x0790 c0x0000 (---------------)  + I campidanomedio
	0x002acd4a, // n0x0791 c0x0000 (---------------)  + I campobasso
	0x00345c91, // n0x0792 c0x0000 (---------------)  + I carbonia-iglesias
	0x00346110, // n0x0793 c0x0000 (---------------)  + I carboniaiglesias
	0x002ab44d, // n0x0794 c0x0000 (---------------)  + I carrara-massa
	0x002ab78c, // n0x0795 c0x0000 (---------------)  + I carraramassa
	0x0022d9c7, // n0x0796 c0x0000 (---------------)  + I caserta
	0x00327407, // n0x0797 c0x0000 (---------------)  + I catania
	0x0031e289, // n0x0798 c0x0000 (---------------)  + I catanzaro
	0x0023ce02, // n0x0799 c0x0000 (---------------)  + I cb
	0x00202902, // n0x079a c0x0000 (---------------)  + I ce
	0x00253e4c, // n0x079b c0x0000 (---------------)  + I cesena-forli
	0x0025414b, // n0x079c c0x0000 (---------------)  + I cesenaforli
	0x00200602, // n0x079d c0x0000 (---------------)  + I ch
	0x002b5786, // n0x079e c0x0000 (---------------)  + I chieti
	0x00218c02, // n0x079f c0x0000 (---------------)  + I ci
	0x002007c2, // n0x07a0 c0x0000 (---------------)  + I cl
	0x002309c2, // n0x07a1 c0x0000 (---------------)  + I cn
	0x00207a02, // n0x07a2 c0x0000 (---------------)  + I co
	0x002335c4, // n0x07a3 c0x0000 (---------------)  + I como
	0x0023c747, // n0x07a4 c0x0000 (---------------)  + I cosenza
	0x00218282, // n0x07a5 c0x0000 (---------------)  + I cr
	0x0023f0c7, // n0x07a6 c0x0000 (---------------)  + I cremona
	0x0023fac7, // n0x07a7 c0x0000 (---------------)  + I crotone
	0x00205d42, // n0x07a8 c0x0000 (---------------)  + I cs
	0x00230cc2, // n0x07a9 c0x0000 (---------------)  + I ct
	0x00241505, // n0x07aa c0x0000 (---------------)  + I cuneo
	0x00223342, // n0x07ab c0x0000 (---------------)  + I cz
	0x0027844e, // n0x07ac c0x0000 (---------------)  + I dell-ogliastra
	0x0022ec0d, // n0x07ad c0x0000 (---------------)  + I dellogliastra
	0x0027a643, // n0x07ae c0x0000 (---------------)  + I edu
	0x0034fd4e, // n0x07af c0x0000 (---------------)  + I emilia-romagna
	0x0024ff0d, // n0x07b0 c0x0000 (---------------)  + I emiliaromagna
	0x00211983, // n0x07b1 c0x0000 (---------------)  + I emr
	0x00202682, // n0x07b2 c0x0000 (---------------)  + I en
	0x002c6704, // n0x07b3 c0x0000 (---------------)  + I enna
	0x002d91c2, // n0x07b4 c0x0000 (---------------)  + I fc
	0x0022e3c2, // n0x07b5 c0x0000 (---------------)  + I fe
	0x0033a745, // n0x07b6 c0x0000 (---------------)  + I fermo
	0x00348607, // n0x07b7 c0x0000 (---------------)  + I ferrara
	0x00352042, // n0x07b8 c0x0000 (---------------)  + I fg
	0x0021c5c2, // n0x07b9 c0x0000 (---------------)  + I fi
	0x00245a07, // n0x07ba c0x0000 (---------------)  + I firenze
	0x0024c588, // n0x07bb c0x0000 (---------------)  + I florence
	0x00253942, // n0x07bc c0x0000 (---------------)  + I fm
	0x0021c786, // n0x07bd c0x0000 (---------------)  + I foggia
	0x00253ccc, // n0x07be c0x0000 (---------------)  + I forli-cesena
	0x0025400b, // n0x07bf c0x0000 (---------------)  + I forlicesena
	0x00212442, // n0x07c0 c0x0000 (---------------)  + I fr
	0x0025a84f, // n0x07c1 c0x0000 (---------------)  + I friuli-v-giulia
	0x0025ac10, // n0x07c2 c0x0000 (---------------)  + I friuli-ve-giulia
	0x0025b00f, // n0x07c3 c0x0000 (---------------)  + I friuli-vegiulia
	0x0025b3d5, // n0x07c4 c0x0000 (---------------)  + I friuli-venezia-giulia
	0x0025b914, // n0x07c5 c0x0000 (---------------)  + I friuli-veneziagiulia
	0x0025be0e, // n0x07c6 c0x0000 (---------------)  + I friuli-vgiulia
	0x0025c18e, // n0x07c7 c0x0000 (---------------)  + I friuliv-giulia
	0x0025c50f, // n0x07c8 c0x0000 (---------------)  + I friulive-giulia
	0x0025c8ce, // n0x07c9 c0x0000 (---------------)  + I friulivegiulia
	0x0025cc54, // n0x07ca c0x0000 (---------------)  + I friulivenezia-giulia
	0x0025d153, // n0x07cb c0x0000 (---------------)  + I friuliveneziagiulia
	0x0025d60d, // n0x07cc c0x0000 (---------------)  + I friulivgiulia
	0x002721c9, // n0x07cd c0x0000 (---------------)  + I frosinone
	0x00283603, // n0x07ce c0x0000 (---------------)  + I fvg
	0x00202e82, // n0x07cf c0x0000 (---------------)  + I ge
	0x00209ac5, // n0x07d0 c0x0000 (---------------)  + I genoa
	0x00213b06, // n0x07d1 c0x0000 (---------------)  + I genova
	0x00206cc2, // n0x07d2 c0x0000 (---------------)  + I go
	0x002c27c7, // n0x07d3 c0x0000 (---------------)  + I gorizia
	0x002157c3, // n0x07d4 c0x0000 (---------------)  + I gov
	0x00205bc2, // n0x07d5 c0x0000 (---------------)  + I gr
	0x0022e808, // n0x07d6 c0x0000 (---------------)  + I grosseto
	0x00345ed1, // n0x07d7 c0x0000 (---------------)  + I iglesias-carbonia
	0x00346310, // n0x07d8 c0x0000 (---------------)  + I iglesiascarbonia
	0x002029c2, // n0x07d9 c0x0000 (---------------)  + I im
	0x00338d07, // n0x07da c0x0000 (---------------)  + I imperia
	0x002046c2, // n0x07db c0x0000 (---------------)  + I is
	0x0025e047, // n0x07dc c0x0000 (---------------)  + I isernia
	0x0020e742, // n0x07dd c0x0000 (---------------)  + I kr
	0x00373b09, // n0x07de c0x0000 (---------------)  + I la-spezia
	0x002d1047, // n0x07df c0x0000 (---------------)  + I laquila
	0x002a44c8, // n0x07e0 c0x0000 (---------------)  + I laspezia
	0x00217e06, // n0x07e1 c0x0000 (---------------)  + I latina
	0x002d2943, // n0x07e2 c0x0000 (---------------)  + I laz
	0x00340f85, // n0x07e3 c0x0000 (---------------)  + I lazio
	0x0020ed02, // n0x07e4 c0x0000 (---------------)  + I lc
	0x00209202, // n0x07e5 c0x0000 (---------------)  + I le
	0x00240c45, // n0x07e6 c0x0000 (---------------)  + I lecce
	0x00248b45, // n0x07e7 c0x0000 (---------------)  + I lecco
	0x002020c2, // n0x07e8 c0x0000 (---------------)  + I li
	0x00223bc3, // n0x07e9 c0x0000 (---------------)  + I lig
	0x00300647, // n0x07ea c0x0000 (---------------)  + I liguria
	0x00205107, // n0x07eb c0x0000 (---------------)  + I livorno
	0x00200802, // n0x07ec c0x0000 (---------------)  + I lo
	0x002d5c04, // n0x07ed c0x0000 (---------------)  + I lodi
	0x00224303, // n0x07ee c0x0000 (---------------)  + I lom
	0x002bf589, // n0x07ef c0x0000 (---------------)  + I lombardia
	0x00224308, // n0x07f0 c0x0000 (---------------)  + I lombardy
	0x00220002, // n0x07f1 c0x0000 (---------------)  + I lt
	0x00202f02, // n0x07f2 c0x0000 (---------------)  + I lu
	0x0026d547, // n0x07f3 c0x0000 (---------------)  + I lucania
	0x002d3685, // n0x07f4 c0x0000 (---------------)  + I lucca
	0x00308648, // n0x07f5 c0x0000 (---------------)  + I macerata
	0x0027be87, // n0x07f6 c0x0000 (---------------)  + I mantova
	0x0020aa43, // n0x07f7 c0x0000 (---------------)  + I mar
	0x00322dc6, // n0x07f8 c0x0000 (---------------)  + I marche
	0x002ab2cd, // n0x07f9 c0x0000 (---------------)  + I massa-carrara
	0x002ab64c, // n0x07fa c0x0000 (---------------)  + I massacarrara
	0x002c8006, // n0x07fb c0x0000 (---------------)  + I matera
	0x00203102, // n0x07fc c0x0000 (---------------)  + I mb
	0x002e83c2, // n0x07fd c0x0000 (---------------)  + I mc
	0x00202a02, // n0x07fe c0x0000 (---------------)  + I me
	0x0023d30f, // n0x07ff c0x0000 (---------------)  + I medio-campidano
	0x0023d70e, // n0x0800 c0x0000 (---------------)  + I mediocampidano
	0x002a1347, // n0x0801 c0x0000 (---------------)  + I messina
	0x00207e02, // n0x0802 c0x0000 (---------------)  + I mi
	0x0031f205, // n0x0803 c0x0000 (---------------)  + I milan
	0x0031f206, // n0x0804 c0x0000 (---------------)  + I milano
	0x002298c2, // n0x0805 c0x0000 (---------------)  + I mn
	0x00206c42, // n0x0806 c0x0000 (---------------)  + I mo
	0x003522c6, // n0x0807 c0x0000 (---------------)  + I modena
	0x00229e03, // n0x0808 c0x0000 (---------------)  + I mol
	0x002c8186, // n0x0809 c0x0000 (---------------)  + I molise
	0x002c0385, // n0x080a c0x0000 (---------------)  + I monza
	0x002c038d, // n0x080b c0x0000 (---------------)  + I monza-brianza
	0x002c06d5, // n0x080c c0x0000 (---------------)  + I monza-e-della-brianza
	0x002c0c0c, // n0x080d c0x0000 (---------------)  + I monzabrianza
	0x002c0f0d, // n0x080e c0x0000 (---------------)  + I monzaebrianza
	0x002c1252, // n0x080f c0x0000 (---------------)  + I monzaedellabrianza
	0x00225542, // n0x0810 c0x0000 (---------------)  + I ms
	0x00268d82, // n0x0811 c0x0000 (---------------)  + I mt
	0x00200242, // n0x0812 c0x0000 (---------------)  + I na
	0x002e2386, // n0x0813 c0x0000 (---------------)  + I naples
	0x00214c46, // n0x0814 c0x0000 (---------------)  + I napoli
	0x00201b82, // n0x0815 c0x0000 (---------------)  + I no
	0x00213b86, // n0x0816 c0x0000 (---------------)  + I novara
	0x002267c2, // n0x0817 c0x0000 (---------------)  + I nu
	0x003605c5, // n0x0818 c0x0000 (---------------)  + I nuoro
	0x00200cc2, // n0x0819 c0x0000 (---------------)  + I og
	0x0022ed09, // n0x081a c0x0000 (---------------)  + I ogliastra
	0x0023948c, // n0x081b c0x0000 (---------------)  + I olbia-tempio
	0x002397cb, // n0x081c c0x0000 (---------------)  + I olbiatempio
	0x00200bc2, // n0x081d c0x0000 (---------------)  + I or
	0x0024c9c8, // n0x081e c0x0000 (---------------)  + I oristano
	0x00203f42, // n0x081f c0x0000 (---------------)  + I ot
	0x002001c2, // n0x0820 c0x0000 (---------------)  + I pa
	0x002088c6, // n0x0821 c0x0000 (---------------)  + I padova
	0x0033c145, // n0x0822 c0x0000 (---------------)  + I padua
	0x003665c7, // n0x0823 c0x0000 (---------------)  + I palermo
	0x00322f85, // n0x0824 c0x0000 (---------------)  + I parma
	0x002eb285, // n0x0825 c0x0000 (---------------)  + I pavia
	0x002416c2, // n0x0826 c0x0000 (---------------)  + I pc
	0x00311502, // n0x0827 c0x0000 (---------------)  + I pd
	0x00202142, // n0x0828 c0x0000 (---------------)  + I pe
	0x0031ca47, // n0x0829 c0x0000 (---------------)  + I perugia
	0x00246b8d, // n0x082a c0x0000 (---------------)  + I pesaro-urbino
	0x00246f0c, // n0x082b c0x0000 (---------------)  + I pesarourbino
	0x002d3d87, // n0x082c c0x0000 (---------------)  + I pescara
	0x00222d02, // n0x082d c0x0000 (---------------)  + I pg
	0x00208542, // n0x082e c0x0000 (---------------)  + I pi
	0x0020b508, // n0x082f c0x0000 (---------------)  + I piacenza
	0x00254508, // n0x0830 c0x0000 (---------------)  + I piedmont
	0x002cee88, // n0x0831 c0x0000 (---------------)  + I piemonte
	0x00255744, // n0x0832 c0x0000 (---------------)  + I pisa
	0x002b74c7, // n0x0833 c0x0000 (---------------)  + I pistoia
	0x002d46c3, // n0x0834 c0x0000 (---------------)  + I pmn
	0x002a9f82, // n0x0835 c0x0000 (---------------)  + I pn
	0x00205982, // n0x0836 c0x0000 (---------------)  + I po
	0x002d60c9, // n0x0837 c0x0000 (---------------)  + I pordenone
	0x00244a07, // n0x0838 c0x0000 (---------------)  + I potenza
	0x002487c2, // n0x0839 c0x0000 (---------------)  + I pr
	0x003378c5, // n0x083a c0x0000 (---------------)  + I prato
	0x002226c2, // n0x083b c0x0000 (---------------)  + I pt
	0x00200f42, // n0x083c c0x0000 (---------------)  + I pu
	0x002b2803, // n0x083d c0x0000 (---------------)  + I pug
	0x002b2806, // n0x083e c0x0000 (---------------)  + I puglia
	0x002dbbc2, // n0x083f c0x0000 (---------------)  + I pv
	0x002dc0c2, // n0x0840 c0x0000 (---------------)  + I pz
	0x00200a82, // n0x0841 c0x0000 (---------------)  + I ra
	0x0036b686, // n0x0842 c0x0000 (---------------)  + I ragusa
	0x0036d087, // n0x0843 c0x0000 (---------------)  + I ravenna
	0x002074c2, // n0x0844 c0x0000 (---------------)  + I rc
	0x002039c2, // n0x0845 c0x0000 (---------------)  + I re
	0x002c438f, // n0x0846 c0x0000 (---------------)  + I reggio-calabria
	0x0034fb8d, // n0x0847 c0x0000 (---------------)  + I reggio-emilia
	0x0020ba8e, // n0x0848 c0x0000 (---------------)  + I reggiocalabria
	0x0024fd8c, // n0x0849 c0x0000 (---------------)  + I reggioemilia
	0x00201702, // n0x084a c0x0000 (---------------)  + I rg
	0x00209fc2, // n0x084b c0x0000 (---------------)  + I ri
	0x00220c85, // n0x084c c0x0000 (---------------)  + I rieti
	0x002cc786, // n0x084d c0x0000 (---------------)  + I rimini
	0x00225502, // n0x084e c0x0000 (---------------)  + I rm
	0x00205202, // n0x084f c0x0000 (---------------)  + I rn
	0x00200c02, // n0x0850 c0x0000 (---------------)  + I ro
	0x00247304, // n0x0851 c0x0000 (---------------)  + I roma
	0x002eee84, // n0x0852 c0x0000 (---------------)  + I rome
	0x002ff086, // n0x0853 c0x0000 (---------------)  + I rovigo
	0x00202882, // n0x0854 c0x0000 (---------------)  + I sa
	0x003529c7, // n0x0855 c0x0000 (---------------)  + I salerno
	0x0023ea83, // n0x0856 c0x0000 (---------------)  + I sar
	0x0023fec8, // n0x0857 c0x0000 (---------------)  + I sardegna
	0x00240548, // n0x0858 c0x0000 (---------------)  + I sardinia
	0x00259fc7, // n0x0859 c0x0000 (---------------)  + I sassari
	0x002705c6, // n0x085a c0x0000 (---------------)  + I savona
	0x00204682, // n0x085b c0x0000 (---------------)  + I si
	0x00218e43, // n0x085c c0x0000 (---------------)  + I sic
	0x00218e47, // n0x085d c0x0000 (---------------)  + I sicilia
	0x0026d146, // n0x085e c0x0000 (---------------)  + I sicily
	0x002dee45, // n0x085f c0x0000 (---------------)  + I siena
	0x002f45c8, // n0x0860 c0x0000 (---------------)  + I siracusa
	0x00206102, // n0x0861 c0x0000 (---------------)  + I so
	0x00285b87, // n0x0862 c0x0000 (---------------)  + I sondrio
	0x0023fcc2, // n0x0863 c0x0000 (---------------)  + I sp
	0x002c4342, // n0x0864 c0x0000 (---------------)  + I sr
	0x00204642, // n0x0865 c0x0000 (---------------)  + I ss
	0x002cae89, // n0x0866 c0x0000 (---------------)  + I suedtirol
	0x00240a82, // n0x0867 c0x0000 (---------------)  + I sv
	0x00201682, // n0x0868 c0x0000 (---------------)  + I ta
	0x0026f4c3, // n0x0869 c0x0000 (---------------)  + I taa
	0x00345087, // n0x086a c0x0000 (---------------)  + I taranto
	0x00201882, // n0x086b c0x0000 (---------------)  + I te
	0x0023960c, // n0x086c c0x0000 (---------------)  + I tempio-olbia
	0x0023990b, // n0x086d c0x0000 (---------------)  + I tempioolbia
	0x002c8086, // n0x086e c0x0000 (---------------)  + I teramo
	0x002e57c5, // n0x086f c0x0000 (---------------)  + I terni
	0x00203f82, // n0x0870 c0x0000 (---------------)  + I tn
	0x00201202, // n0x0871 c0x0000 (---------------)  + I to
	0x002afbc6, // n0x0872 c0x0000 (---------------)  + I torino
	0x0024b043, // n0x0873 c0x0000 (---------------)  + I tos
	0x00319547, // n0x0874 c0x0000 (---------------)  + I toscana
	0x00219e42, // n0x0875 c0x0000 (---------------)  + I tp
	0x00205542, // n0x0876 c0x0000 (---------------)  + I tr
	0x00277395, // n0x0877 c0x0000 (---------------)  + I trani-andria-barletta
	0x0026ecd5, // n0x0878 c0x0000 (---------------)  + I trani-barletta-andria
	0x00282e93, // n0x0879 c0x0000 (---------------)  + I traniandriabarletta
	0x0026f213, // n0x087a c0x0000 (---------------)  + I tranibarlettaandria
	0x00293cc7, // n0x087b c0x0000 (---------------)  + I trapani
	0x002b3208, // n0x087c c0x0000 (---------------)  + I trentino
	0x002b5c90, // n0x087d c0x0000 (---------------)  + I trentino-a-adige
	0x002b8b0f, // n0x087e c0x0000 (---------------)  + I trentino-aadige
	0x003576d3, // n0x087f c0x0000 (---------------)  + I trentino-alto-adige
	0x002fb7d2, // n0x0880 c0x0000 (---------------)  + I trentino-altoadige
	0x0032bd50, // n0x0881 c0x0000 (---------------)  + I trentino-s-tirol
	0x00336a0f, // n0x0882 c0x0000 (---------------)  + I trentino-stirol
	0x002b3212, // n0x0883 c0x0000 (---------------)  + I trentino-sud-tirol
	0x002bb911, // n0x0884 c0x0000 (---------------)  + I trentino-sudtirol
	0x002c9953, // n0x0885 c0x0000 (---------------)  + I trentino-sued-tirol
	0x002cac52, // n0x0886 c0x0000 (---------------)  + I trentino-suedtirol
	0x002ce68f, // n0x0887 c0x0000 (---------------)  + I trentinoa-adige
	0x002da90e, // n0x0888 c0x0000 (---------------)  + I trentinoaadige
	0x002dbc52, // n0x0889 c0x0000 (---------------)  + I trentinoalto-adige
	0x002e0b51, // n0x088a c0x0000 (---------------)  + I trentinoaltoadige
	0x002e2a8f, // n0x088b c0x0000 (---------------)  + I trentinos-tirol
	0x002ea78e, // n0x088c c0x0000 (---------------)  + I trentinostirol
	0x002eca91, // n0x088d c0x0000 (---------------)  + I trentinosud-tirol
	0x0036f150, // n0x088e c0x0000 (---------------)  + I trentinosudtirol
	0x002f9812, // n0x088f c0x0000 (---------------)  + I trentinosued-tirol
	0x0030b591, // n0x0890 c0x0000 (---------------)  + I trentinosuedtirol
	0x00313186, // n0x0891 c0x0000 (---------------)  + I trento
	0x0031a847, // n0x0892 c0x0000 (---------------)  + I treviso
	0x0021b007, // n0x0893 c0x0000 (---------------)  + I trieste
	0x002021c2, // n0x0894 c0x0000 (---------------)  + I ts
	0x002be585, // n0x0895 c0x0000 (---------------)  + I turin
	0x002f0347, // n0x0896 c0x0000 (---------------)  + I tuscany
	0x00292602, // n0x0897 c0x0000 (---------------)  + I tv
	0x0022f0c2, // n0x0898 c0x0000 (---------------)  + I ud
	0x002abc05, // n0x0899 c0x0000 (---------------)  + I udine
	0x0021a503, // n0x089a c0x0000 (---------------)  + I umb
	0x0022a286, // n0x089b c0x0000 (---------------)  + I umbria
	0x00246d4d, // n0x089c c0x0000 (---------------)  + I urbino-pesaro
	0x0024708c, // n0x089d c0x0000 (---------------)  + I urbinopesaro
	0x002000c2, // n0x089e c0x0000 (---------------)  + I va
	0x0036834b, // n0x089f c0x0000 (---------------)  + I val-d-aosta
	0x002af04a, // n0x08a0 c0x0000 (---------------)  + I val-daosta
	0x002089ca, // n0x08a1 c0x0000 (---------------)  + I vald-aosta
	0x002d55c9, // n0x08a2 c0x0000 (---------------)  + I valdaosta
	0x002f058b, // n0x08a3 c0x0000 (---------------)  + I valle-aosta
	0x0034780d, // n0x08a4 c0x0000 (---------------)  + I valle-d-aosta
	0x0022898c, // n0x08a5 c0x0000 (---------------)  + I valle-daosta
	0x0023ec0a, // n0x08a6 c0x0000 (---------------)  + I valleaosta
	0x0024300c, // n0x08a7 c0x0000 (---------------)  + I valled-aosta
	0x0026220b, // n0x08a8 c0x0000 (---------------)  + I valledaosta
	0x00267fcc, // n0x08a9 c0x0000 (---------------)  + I vallee-aoste
	0x0026bd8b, // n0x08aa c0x0000 (---------------)  + I valleeaoste
	0x002c4fc3, // n0x08ab c0x0000 (---------------)  + I vao
	0x002e9606, // n0x08ac c0x0000 (---------------)  + I varese
	0x002f0c42, // n0x08ad c0x0000 (---------------)  + I vb
	0x002f1142, // n0x08ae c0x0000 (---------------)  + I vc
	0x00205043, // n0x08af c0x0000 (---------------)  + I vda
	0x00202642, // n0x08b0 c0x0000 (---------------)  + I ve
	0x00202643, // n0x08b1 c0x0000 (---------------)  + I ven
	0x00270d06, // n0x08b2 c0x0000 (---------------)  + I veneto
	0x0025b587, // n0x08b3 c0x0000 (---------------)  + I venezia
	0x00271e86, // n0x08b4 c0x0000 (---------------)  + I venice
	0x002da588, // n0x08b5 c0x0000 (---------------)  + I verbania
	0x002a2d88, // n0x08b6 c0x0000 (---------------)  + I vercelli
	0x002f2286, // n0x08b7 c0x0000 (---------------)  + I verona
	0x002032c2, // n0x08b8 c0x0000 (---------------)  + I vi
	0x002f628d, // n0x08b9 c0x0000 (---------------)  + I vibo-valentia
	0x002f65cc, // n0x08ba c0x0000 (---------------)  + I vibovalentia
	0x00369047, // n0x08bb c0x0000 (---------------)  + I vicenza
	0x002f7d07, // n0x08bc c0x0000 (---------------)  + I viterbo
	0x0020b042, // n0x08bd c0x0000 (---------------)  + I vr
	0x00241d82, // n0x08be c0x0000 (---------------)  + I vs
	0x0026d0c2, // n0x08bf c0x0000 (---------------)  + I vt
	0x00202602, // n0x08c0 c0x0000 (---------------)  + I vv
	0x00207a02, // n0x08c1 c0x0000 (---------------)  + I co
	0x00201603, // n0x08c2 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x08c3 c0x0000 (---------------)  + I org
	0x00222603, // n0x08c4 c0x0000 (---------------)  + I com
	0x0027a643, // n0x08c5 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x08c6 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x08c7 c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x08c8 c0x0000 (---------------)  + I name
	0x00201603, // n0x08c9 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x08ca c0x0000 (---------------)  + I org
	0x002526c3, // n0x08cb c0x0000 (---------------)  + I sch
	0x00201d82, // n0x08cc c0x0000 (---------------)  + I ac
	0x00208902, // n0x08cd c0x0000 (---------------)  + I ad
	0x1c6756c5, // n0x08ce c0x0071 (n0x090c-n0x0940)  + I aichi
	0x1ca69d05, // n0x08cf c0x0072 (n0x0940-n0x095c)  + I akita
	0x1cec5006, // n0x08d0 c0x0073 (n0x095c-n0x0972)  + I aomori
	0x000b8948, // n0x08d1 c0x0000 (---------------)  +   blogspot
	0x1d2b0885, // n0x08d2 c0x0074 (n0x0972-n0x09ac)  + I chiba
	0x00207a02, // n0x08d3 c0x0000 (---------------)  + I co
	0x00202542, // n0x08d4 c0x0000 (---------------)  + I ed
	0x1d602945, // n0x08d5 c0x0075 (n0x09ac-n0x09c2)  + I ehime
	0x1da7ac85, // n0x08d6 c0x0076 (n0x09c2-n0x09d1)  + I fukui
	0x1de7b447, // n0x08d7 c0x0077 (n0x09d1-n0x0a10)  + I fukuoka
	0x1e27bcc9, // n0x08d8 c0x0078 (n0x0a10-n0x0a43)  + I fukushima
	0x1e679c84, // n0x08d9 c0x0079 (n0x0a43-n0x0a69)  + I gifu
	0x00206cc2, // n0x08da c0x0000 (---------------)  + I go
	0x00205bc2, // n0x08db c0x0000 (---------------)  + I gr
	0x1eb52085, // n0x08dc c0x007a (n0x0a69-n0x0a8d)  + I gunma
	0x1ee69e49, // n0x08dd c0x007b (n0x0a8d-n0x0aa6)  + I hiroshima
	0x1f32e148, // n0x08de c0x007c (n0x0aa6-n0x0b34)  + I hokkaido
	0x1f6a8f05, // n0x08df c0x007d (n0x0b34-n0x0b62)  + I hyogo
	0x1fb2cd07, // n0x08e0 c0x007e (n0x0b62-n0x0b95)  + I ibaraki
	0x1fe26fc8, // n0x08e1 c0x007f (n0x0b95-n0x0ba8)  + I ishikawa
	0x20351705, // n0x08e2 c0x0080 (n0x0ba8-n0x0bca)  + I iwate
	0x20600446, // n0x08e3 c0x0081 (n0x0bca-n0x0bd9)  + I kagawa
	0x20b17449, // n0x08e4 c0x0082 (n0x0bd9-n0x0bed)  + I kagoshima
	0x20f55c08, // n0x08e5 c0x0083 (n0x0bed-n0x0c0b)  + I kanagawa
	0x212b5408, // n0x08e6 c0x0084 (n0x0c0b-n0x0c0c)* o I kawasaki
	0x2161334a, // n0x08e7 c0x0085 (n0x0c0c-n0x0c0d)* o I kitakyushu
	0x21a72a04, // n0x08e8 c0x0086 (n0x0c0d-n0x0c0e)* o I kobe
	0x21ec6385, // n0x08e9 c0x0087 (n0x0c0e-n0x0c2d)  + I kochi
	0x222c7d88, // n0x08ea c0x0088 (n0x0c2d-n0x0c47)  + I kumamoto
	0x22665a05, // n0x08eb c0x0089 (n0x0c47-n0x0c66)  + I kyoto
	0x00213f02, // n0x08ec c0x0000 (---------------)  + I lg
	0x22a2d5c3, // n0x08ed c0x008a (n0x0c66-n0x0c84)  + I mie
	0x22e9d486, // n0x08ee c0x008b (n0x0c84-n0x0ca5)  + I miyagi
	0x232573c8, // n0x08ef c0x008c (n0x0ca5-n0x0cc0)  + I miyazaki
	0x2360d586, // n0x08f0 c0x008d (n0x0cc0-n0x0d0b)  + I nagano
	0x23a99248, // n0x08f1 c0x008e (n0x0d0b-n0x0d21)  + I nagasaki
	0x23f19386, // n0x08f2 c0x008f (n0x0d21-n0x0d22)* o I nagoya
	0x24268e84, // n0x08f3 c0x0090 (n0x0d22-n0x0d48)  + I nara
	0x00201602, // n0x08f4 c0x0000 (---------------)  + I ne
	0x24690607, // n0x08f5 c0x0091 (n0x0d48-n0x0d6a)  + I niigata
	0x24a0a1c4, // n0x08f6 c0x0092 (n0x0d6a-n0x0d7d)  + I oita
	0x24e75247, // n0x08f7 c0x0093 (n0x0d7d-n0x0d97)  + I okayama
	0x2521e607, // n0x08f8 c0x0094 (n0x0d97-n0x0dc1)  + I okinawa
	0x00200bc2, // n0x08f9 c0x0000 (---------------)  + I or
	0x25694785, // n0x08fa c0x0095 (n0x0dc1-n0x0df3)  + I osaka
	0x25a83fc4, // n0x08fb c0x0096 (n0x0df3-n0x0e0d)  + I saga
	0x25f57207, // n0x08fc c0x0097 (n0x0e0d-n0x0e52)  + I saitama
	0x26239247, // n0x08fd c0x0098 (n0x0e52-n0x0e53)* o I sapporo
	0x2667e946, // n0x08fe c0x0099 (n0x0e53-n0x0e54)* o I sendai
	0x26a7ba85, // n0x08ff c0x009a (n0x0e54-n0x0e6b)  + I shiga
	0x26e8ecc7, // n0x0900 c0x009b (n0x0e6b-n0x0e82)  + I shimane
	0x272dd488, // n0x0901 c0x009c (n0x0e82-n0x0ea6)  + I shizuoka
	0x27735ac7, // n0x0902 c0x009d (n0x0ea6-n0x0ec5)  + I tochigi
	0x27ae1f89, // n0x0903 c0x009e (n0x0ec5-n0x0ed6)  + I tokushima
	0x27ed8e85, // n0x0904 c0x009f (n0x0ed6-n0x0f0f)  + I tokyo
	0x282fb3c7, // n0x0905 c0x00a0 (n0x0f0f-n0x0f1c)  + I tottori
	0x2868a786, // n0x0906 c0x00a1 (n0x0f1c-n0x0f34)  + I toyama
	0x28b09c88, // n0x0907 c0x00a2 (n0x0f34-n0x0f51)  + I wakayama
	0x28e7d308, // n0x0908 c0x00a3 (n0x0f51-n0x0f73)  + I yamagata
	0x29281909, // n0x0909 c0x00a4 (n0x0f73-n0x0f83)  + I yamaguchi
	0x29722709, // n0x090a c0x00a5 (n0x0f83-n0x0f9f)  + I yamanashi
	0x29b11a88, // n0x090b c0x00a6 (n0x0f9f-n0x0fa0)* o I yokohama
	0x002b16c5, // n0x090c c0x0000 (---------------)  + I aisai
	0x00200283, // n0x090d c0x0000 (---------------)  + I ama
	0x00248144, // n0x090e c0x0000 (---------------)  + I anjo
	0x002fca85, // n0x090f c0x0000 (---------------)  + I asuke
	0x002799c6, // n0x0910 c0x0000 (---------------)  + I chiryu
	0x0029bd05, // n0x0911 c0x0000 (---------------)  + I chita
	0x00280f84, // n0x0912 c0x0000 (---------------)  + I fuso
	0x002c26c8, // n0x0913 c0x0000 (---------------)  + I gamagori
	0x0027f585, // n0x0914 c0x0000 (---------------)  + I handa
	0x0028cb44, // n0x0915 c0x0000 (---------------)  + I hazu
	0x002456c7, // n0x0916 c0x0000 (---------------)  + I hekinan
	0x002971ca, // n0x0917 c0x0000 (---------------)  + I higashiura
	0x002de64a, // n0x0918 c0x0000 (---------------)  + I ichinomiya
	0x002e5407, // n0x0919 c0x0000 (---------------)  + I inazawa
	0x00226787, // n0x091a c0x0000 (---------------)  + I inuyama
	0x0033f5c7, // n0x091b c0x0000 (---------------)  + I isshiki
	0x00266f47, // n0x091c c0x0000 (---------------)  + I iwakura
	0x002e63c5, // n0x091d c0x0000 (---------------)  + I kanie
	0x00315dc6, // n0x091e c0x0000 (---------------)  + I kariya
	0x002bc7c7, // n0x091f c0x0000 (---------------)  + I kasugai
	0x00212f04, // n0x0920 c0x0000 (---------------)  + I kira
	0x002f57c6, // n0x0921 c0x0000 (---------------)  + I kiyosu
	0x002f51c6, // n0x0922 c0x0000 (---------------)  + I komaki
	0x002bc005, // n0x0923 c0x0000 (---------------)  + I konan
	0x002dcac4, // n0x0924 c0x0000 (---------------)  + I kota
	0x00292746, // n0x0925 c0x0000 (---------------)  + I mihama
	0x00295c07, // n0x0926 c0x0000 (---------------)  + I miyoshi
	0x002d9f86, // n0x0927 c0x0000 (---------------)  + I nishio
	0x002a5707, // n0x0928 c0x0000 (---------------)  + I nisshin
	0x0028bd43, // n0x0929 c0x0000 (---------------)  + I obu
	0x00230706, // n0x092a c0x0000 (---------------)  + I oguchi
	0x00259185, // n0x092b c0x0000 (---------------)  + I oharu
	0x0027b547, // n0x092c c0x0000 (---------------)  + I okazaki
	0x002baaca, // n0x092d c0x0000 (---------------)  + I owariasahi
	0x0022e904, // n0x092e c0x0000 (---------------)  + I seto
	0x002264c8, // n0x092f c0x0000 (---------------)  + I shikatsu
	0x002dec09, // n0x0930 c0x0000 (---------------)  + I shinshiro
	0x002dce07, // n0x0931 c0x0000 (---------------)  + I shitara
	0x00375086, // n0x0932 c0x0000 (---------------)  + I tahara
	0x0027d488, // n0x0933 c0x0000 (---------------)  + I takahama
	0x002a0649, // n0x0934 c0x0000 (---------------)  + I tobishima
	0x00270e04, // n0x0935 c0x0000 (---------------)  + I toei
	0x003113c4, // n0x0936 c0x0000 (---------------)  + I togo
	0x002f88c5, // n0x0937 c0x0000 (---------------)  + I tokai
	0x002bc4c8, // n0x0938 c0x0000 (---------------)  + I tokoname
	0x002bda07, // n0x0939 c0x0000 (---------------)  + I toyoake
	0x002d8bc9, // n0x093a c0x0000 (---------------)  + I toyohashi
	0x00337988, // n0x093b c0x0000 (---------------)  + I toyokawa
	0x00246486, // n0x093c c0x0000 (---------------)  + I toyone
	0x00255a86, // n0x093d c0x0000 (---------------)  + I toyota
	0x002913c8, // n0x093e c0x0000 (---------------)  + I tsushima
	0x00334686, // n0x093f c0x0000 (---------------)  + I yatomi
	0x00269d05, // n0x0940 c0x0000 (---------------)  + I akita
	0x0027ea06, // n0x0941 c0x0000 (---------------)  + I daisen
	0x00276088, // n0x0942 c0x0000 (---------------)  + I fujisato
	0x0027aa46, // n0x0943 c0x0000 (---------------)  + I gojome
	0x0034218b, // n0x0944 c0x0000 (---------------)  + I hachirogata
	0x00287306, // n0x0945 c0x0000 (---------------)  + I happou
	0x0029294d, // n0x0946 c0x0000 (---------------)  + I higashinaruse
	0x0020a045, // n0x0947 c0x0000 (---------------)  + I honjo
	0x002a46c6, // n0x0948 c0x0000 (---------------)  + I honjyo
	0x00212805, // n0x0949 c0x0000 (---------------)  + I ikawa
	0x0020a449, // n0x094a c0x0000 (---------------)  + I kamikoani
	0x0035e7c7, // n0x094b c0x0000 (---------------)  + I kamioka
	0x00343d08, // n0x094c c0x0000 (---------------)  + I katagami
	0x0023a386, // n0x094d c0x0000 (---------------)  + I kazuno
	0x00291d09, // n0x094e c0x0000 (---------------)  + I kitaakita
	0x002eec06, // n0x094f c0x0000 (---------------)  + I kosaka
	0x002baa45, // n0x0950 c0x0000 (---------------)  + I kyowa
	0x002625c6, // n0x0951 c0x0000 (---------------)  + I misato
	0x002a3746, // n0x0952 c0x0000 (---------------)  + I mitane
	0x002c2009, // n0x0953 c0x0000 (---------------)  + I moriyoshi
	0x003111c6, // n0x0954 c0x0000 (---------------)  + I nikaho
	0x00249e47, // n0x0955 c0x0000 (---------------)  + I noshiro
	0x002dd345, // n0x0956 c0x0000 (---------------)  + I odate
	0x002043c3, // n0x0957 c0x0000 (---------------)  + I oga
	0x00342305, // n0x0958 c0x0000 (---------------)  + I ogata
	0x002c7c47, // n0x0959 c0x0000 (---------------)  + I semboku
	0x0036ca06, // n0x095a c0x0000 (---------------)  + I yokote
	0x00209f49, // n0x095b c0x0000 (---------------)  + I yurihonjo
	0x002c5006, // n0x095c c0x0000 (---------------)  + I aomori
	0x002a51c6, // n0x095d c0x0000 (---------------)  + I gonohe
	0x00245509, // n0x095e c0x0000 (---------------)  + I hachinohe
	0x0027e409, // n0x095f c0x0000 (---------------)  + I hashikami
	0x0029b987, // n0x0960 c0x0000 (---------------)  + I hiranai
	0x00360d48, // n0x0961 c0x0000 (---------------)  + I hirosaki
	0x002c3b49, // n0x0962 c0x0000 (---------------)  + I itayanagi
	0x0027b948, // n0x0963 c0x0000 (---------------)  + I kuroishi
	0x00348d46, // n0x0964 c0x0000 (---------------)  + I misawa
	0x002cb4c5, // n0x0965 c0x0000 (---------------)  + I mutsu
	0x0023c9ca, // n0x0966 c0x0000 (---------------)  + I nakadomari
	0x002a5246, // n0x0967 c0x0000 (---------------)  + I noheji
	0x00299586, // n0x0968 c0x0000 (---------------)  + I oirase
	0x00290545, // n0x0969 c0x0000 (---------------)  + I owani
	0x00360688, // n0x096a c0x0000 (---------------)  + I rokunohe
	0x0024ee07, // n0x096b c0x0000 (---------------)  + I sannohe
	0x00201a0a, // n0x096c c0x0000 (---------------)  + I shichinohe
	0x00246146, // n0x096d c0x0000 (---------------)  + I shingo
	0x00306845, // n0x096e c0x0000 (---------------)  + I takko
	0x002fd706, // n0x096f c0x0000 (---------------)  + I towada
	0x00285207, // n0x0970 c0x0000 (---------------)  + I tsugaru
	0x00374f47, // n0x0971 c0x0000 (---------------)  + I tsuruta
	0x0022f545, // n0x0972 c0x0000 (---------------)  + I abiko
	0x002bac05, // n0x0973 c0x0000 (---------------)  + I asahi
	0x0033fd06, // n0x0974 c0x0000 (---------------)  + I chonan
	0x002a9986, // n0x0975 c0x0000 (---------------)  + I chosei
	0x002adb86, // n0x0976 c0x0000 (---------------)  + I choshi
	0x002606c4, // n0x0977 c0x0000 (---------------)  + I chuo
	0x0027d9c9, // n0x0978 c0x0000 (---------------)  + I funabashi
	0x002827c6, // n0x0979 c0x0000 (---------------)  + I futtsu
	0x0027880a, // n0x097a c0x0000 (---------------)  + I hanamigawa
	0x0028af48, // n0x097b c0x0000 (---------------)  + I ichihara
	0x002a0348, // n0x097c c0x0000 (---------------)  + I ichikawa
	0x002de64a, // n0x097d c0x0000 (---------------)  + I ichinomiya
	0x00366d85, // n0x097e c0x0000 (---------------)  + I inzai
	0x00295b45, // n0x097f c0x0000 (---------------)  + I isumi
	0x00316508, // n0x0980 c0x0000 (---------------)  + I kamagaya
	0x00287b48, // n0x0981 c0x0000 (---------------)  + I kamogawa
	0x00202247, // n0x0982 c0x0000 (---------------)  + I kashiwa
	0x00224f46, // n0x0983 c0x0000 (---------------)  + I katori
	0x00305a88, // n0x0984 c0x0000 (---------------)  + I katsuura
	0x0030f507, // n0x0985 c0x0000 (---------------)  + I kimitsu
	0x002644c8, // n0x0986 c0x0000 (---------------)  + I kisarazu
	0x002ac486, // n0x0987 c0x0000 (---------------)  + I kozaki
	0x00322b48, // n0x0988 c0x0000 (---------------)  + I kujukuri
	0x0028e3c6, // n0x0989 c0x0000 (---------------)  + I kyonan
	0x00288ec7, // n0x098a c0x0000 (---------------)  + I matsudo
	0x00267c06, // n0x098b c0x0000 (---------------)  + I midori
	0x00292746, // n0x098c c0x0000 (---------------)  + I mihama
	0x0024b38a, // n0x098d c0x0000 (---------------)  + I minamiboso
	0x00233646, // n0x098e c0x0000 (---------------)  + I mobara
	0x002cb4c9, // n0x098f c0x0000 (---------------)  + I mutsuzawa
	0x0036cf86, // n0x0990 c0x0000 (---------------)  + I nagara
	0x0036d1ca, // n0x0991 c0x0000 (---------------)  + I nagareyama
	0x00268e89, // n0x0992 c0x0000 (---------------)  + I narashino
	0x002f2386, // n0x0993 c0x0000 (---------------)  + I narita
	0x0025f744, // n0x0994 c0x0000 (---------------)  + I noda
	0x00209b8d, // n0x0995 c0x0000 (---------------)  + I oamishirasato
	0x00281b87, // n0x0996 c0x0000 (---------------)  + I omigawa
	0x003083c6, // n0x0997 c0x0000 (---------------)  + I onjuku
	0x002b52c5, // n0x0998 c0x0000 (---------------)  + I otaki
	0x002eec85, // n0x0999 c0x0000 (---------------)  + I sakae
	0x0021a006, // n0x099a c0x0000 (---------------)  + I sakura
	0x002a3f09, // n0x099b c0x0000 (---------------)  + I shimofusa
	0x002fbfc7, // n0x099c c0x0000 (---------------)  + I shirako
	0x00277f06, // n0x099d c0x0000 (---------------)  + I shiroi
	0x002dc246, // n0x099e c0x0000 (---------------)  + I shisui
	0x0036e009, // n0x099f c0x0000 (---------------)  + I sodegaura
	0x0027cb84, // n0x09a0 c0x0000 (---------------)  + I sosa
	0x0024c284, // n0x09a1 c0x0000 (---------------)  + I tako
	0x0024f888, // n0x09a2 c0x0000 (---------------)  + I tateyama
	0x0029fac6, // n0x09a3 c0x0000 (---------------)  + I togane
	0x0029b308, // n0x09a4 c0x0000 (---------------)  + I tohnosho
	0x00262548, // n0x09a5 c0x0000 (---------------)  + I tomisato
	0x002a16c7, // n0x09a6 c0x0000 (---------------)  + I urayasu
	0x00237449, // n0x09a7 c0x0000 (---------------)  + I yachimata
	0x00374ac7, // n0x09a8 c0x0000 (---------------)  + I yachiyo
	0x002b074a, // n0x09a9 c0x0000 (---------------)  + I yokaichiba
	0x002e3c8f, // n0x09aa c0x0000 (---------------)  + I yokoshibahikari
	0x0025898a, // n0x09ab c0x0000 (---------------)  + I yotsukaido
	0x00220a85, // n0x09ac c0x0000 (---------------)  + I ainan
	0x002762c5, // n0x09ad c0x0000 (---------------)  + I honai
	0x00224e05, // n0x09ae c0x0000 (---------------)  + I ikata
	0x0028e647, // n0x09af c0x0000 (---------------)  + I imabari
	0x002035c3, // n0x09b0 c0x0000 (---------------)  + I iyo
	0x00360f48, // n0x09b1 c0x0000 (---------------)  + I kamijima
	0x00204886, // n0x09b2 c0x0000 (---------------)  + I kihoku
	0x00204989, // n0x09b3 c0x0000 (---------------)  + I kumakogen
	0x002d2c46, // n0x09b4 c0x0000 (---------------)  + I masaki
	0x002d1cc7, // n0x09b5 c0x0000 (---------------)  + I matsuno
	0x00291ac9, // n0x09b6 c0x0000 (---------------)  + I matsuyama
	0x00343c08, // n0x09b7 c0x0000 (---------------)  + I namikata
	0x0020a607, // n0x09b8 c0x0000 (---------------)  + I niihama
	0x002b4fc3, // n0x09b9 c0x0000 (---------------)  + I ozu
	0x002b1745, // n0x09ba c0x0000 (---------------)  + I saijo
	0x002e3bc5, // n0x09bb c0x0000 (---------------)  + I seiyo
	0x0026050b, // n0x09bc c0x0000 (---------------)  + I shikokuchuo
	0x00265ac4, // n0x09bd c0x0000 (---------------)  + I tobe
	0x0027a484, // n0x09be c0x0000 (---------------)  + I toon
	0x00274906, // n0x09bf c0x0000 (---------------)  + I uchiko
	0x002b5047, // n0x09c0 c0x0000 (---------------)  + I uwajima
	0x003569ca, // n0x09c1 c0x0000 (---------------)  + I yawatahama
	0x00253b07, // n0x09c2 c0x0000 (---------------)  + I echizen
	0x00270e87, // n0x09c3 c0x0000 (---------------)  + I eiheiji
	0x0027ac85, // n0x09c4 c0x0000 (---------------)  + I fukui
	0x002024c5, // n0x09c5 c0x0000 (---------------)  + I ikeda
	0x002cdc49, // n0x09c6 c0x0000 (---------------)  + I katsuyama
	0x00292746, // n0x09c7 c0x0000 (---------------)  + I mihama
	0x0025398d, // n0x09c8 c0x0000 (---------------)  + I minamiechizen
	0x0021e9c5, // n0x09c9 c0x0000 (---------------)  + I obama
	0x00296d03, // n0x09ca c0x0000 (---------------)  + I ohi
	0x002142c3, // n0x09cb c0x0000 (---------------)  + I ono
	0x0027a105, // n0x09cc c0x0000 (---------------)  + I sabae
	0x0032db85, // n0x09cd c0x0000 (---------------)  + I sakai
	0x0027d488, // n0x09ce c0x0000 (---------------)  + I takahama
	0x00282887, // n0x09cf c0x0000 (---------------)  + I tsuruga
	0x0024c006, // n0x09d0 c0x0000 (---------------)  + I wakasa
	0x002978c6, // n0x09d1 c0x0000 (---------------)  + I ashiya
	0x00228045, // n0x09d2 c0x0000 (---------------)  + I buzen
	0x0027a907, // n0x09d3 c0x0000 (---------------)  + I chikugo
	0x00226a07, // n0x09d4 c0x0000 (---------------)  + I chikuho
	0x002dea07, // n0x09d5 c0x0000 (---------------)  + I chikujo
	0x002c640a, // n0x09d6 c0x0000 (---------------)  + I chikushino
	0x002307c8, // n0x09d7 c0x0000 (---------------)  + I chikuzen
	0x002606c4, // n0x09d8 c0x0000 (---------------)  + I chuo
	0x0028c1c7, // n0x09d9 c0x0000 (---------------)  + I dazaifu
	0x00279407, // n0x09da c0x0000 (---------------)  + I fukuchi
	0x0032f7c6, // n0x09db c0x0000 (---------------)  + I hakata
	0x00263ec7, // n0x09dc c0x0000 (---------------)  + I higashi
	0x002bd488, // n0x09dd c0x0000 (---------------)  + I hirokawa
	0x00322608, // n0x09de c0x0000 (---------------)  + I hisayama
	0x0026b806, // n0x09df c0x0000 (---------------)  + I iizuka
	0x00342b88, // n0x09e0 c0x0000 (---------------)  + I inatsuki
	0x002bb404, // n0x09e1 c0x0000 (---------------)  + I kaho
	0x002bc7c6, // n0x09e2 c0x0000 (---------------)  + I kasuga
	0x00219306, // n0x09e3 c0x0000 (---------------)  + I kasuya
	0x00251a06, // n0x09e4 c0x0000 (---------------)  + I kawara
	0x002e7cc6, // n0x09e5 c0x0000 (---------------)  + I keisen
	0x00297e44, // n0x09e6 c0x0000 (---------------)  + I koga
	0x00267006, // n0x09e7 c0x0000 (---------------)  + I kurate
	0x002b3b06, // n0x09e8 c0x0000 (---------------)  + I kurogi
	0x00290e46, // n0x09e9 c0x0000 (---------------)  + I kurume
	0x0024b386, // n0x09ea c0x0000 (---------------)  + I minami
	0x00214186, // n0x09eb c0x0000 (---------------)  + I miyako
	0x002bd2c6, // n0x09ec c0x0000 (---------------)  + I miyama
	0x0024bf08, // n0x09ed c0x0000 (---------------)  + I miyawaka
	0x002fa008, // n0x09ee c0x0000 (---------------)  + I mizumaki
	0x002c8b08, // n0x09ef c0x0000 (---------------)  + I munakata
	0x0029bf08, // n0x09f0 c0x0000 (---------------)  + I nakagawa
	0x00316486, // n0x09f1 c0x0000 (---------------)  + I nakama
	0x002164c5, // n0x09f2 c0x0000 (---------------)  + I nishi
	0x00352b06, // n0x09f3 c0x0000 (---------------)  + I nogata
	0x002a8f85, // n0x09f4 c0x0000 (---------------)  + I ogori
	0x00258f07, // n0x09f5 c0x0000 (---------------)  + I okagaki
	0x002519c5, // n0x09f6 c0x0000 (---------------)  + I okawa
	0x0021e603, // n0x09f7 c0x0000 (---------------)  + I oki
	0x0021ac45, // n0x09f8 c0x0000 (---------------)  + I omuta
	0x0022c244, // n0x09f9 c0x0000 (---------------)  + I onga
	0x002142c5, // n0x09fa c0x0000 (---------------)  + I onojo
	0x00207143, // n0x09fb c0x0000 (---------------)  + I oto
	0x002ed207, // n0x09fc c0x0000 (---------------)  + I saigawa
	0x002e4748, // n0x09fd c0x0000 (---------------)  + I sasaguri
	0x002a57c6, // n0x09fe c0x0000 (---------------)  + I shingu
	0x002e604d, // n0x09ff c0x0000 (---------------)  + I shinyoshitomi
	0x00276286, // n0x0a00 c0x0000 (---------------)  + I shonai
	0x0028fb05, // n0x0a01 c0x0000 (---------------)  + I soeda
	0x002a9d43, // n0x0a02 c0x0000 (---------------)  + I sue
	0x002b1509, // n0x0a03 c0x0000 (---------------)  + I tachiarai
	0x00290b06, // n0x0a04 c0x0000 (---------------)  + I tagawa
	0x0028aa06, // n0x0a05 c0x0000 (---------------)  + I takata
	0x0032e0c4, // n0x0a06 c0x0000 (---------------)  + I toho
	0x00258907, // n0x0a07 c0x0000 (---------------)  + I toyotsu
	0x00238746, // n0x0a08 c0x0000 (---------------)  + I tsuiki
	0x00306a85, // n0x0a09 c0x0000 (---------------)  + I ukiha
	0x00207dc3, // n0x0a0a c0x0000 (---------------)  + I umi
	0x00216bc4, // n0x0a0b c0x0000 (---------------)  + I usui
	0x002795c6, // n0x0a0c c0x0000 (---------------)  + I yamada
	0x00219404, // n0x0a0d c0x0000 (---------------)  + I yame
	0x002f3948, // n0x0a0e c0x0000 (---------------)  + I yanagawa
	0x00206a09, // n0x0a0f c0x0000 (---------------)  + I yukuhashi
	0x002b6b89, // n0x0a10 c0x0000 (---------------)  + I aizubange
	0x0029b10a, // n0x0a11 c0x0000 (---------------)  + I aizumisato
	0x00289f8d, // n0x0a12 c0x0000 (---------------)  + I aizuwakamatsu
	0x00250b07, // n0x0a13 c0x0000 (---------------)  + I asakawa
	0x00265306, // n0x0a14 c0x0000 (---------------)  + I bandai
	0x00271284, // n0x0a15 c0x0000 (---------------)  + I date
	0x0027bcc9, // n0x0a16 c0x0000 (---------------)  + I fukushima
	0x00280988, // n0x0a17 c0x0000 (---------------)  + I furudono
	0x00281786, // n0x0a18 c0x0000 (---------------)  + I futaba
	0x00251e86, // n0x0a19 c0x0000 (---------------)  + I hanawa
	0x00263ec7, // n0x0a1a c0x0000 (---------------)  + I higashi
	0x0031f606, // n0x0a1b c0x0000 (---------------)  + I hirata
	0x00228446, // n0x0a1c c0x0000 (---------------)  + I hirono
	0x00201786, // n0x0a1d c0x0000 (---------------)  + I iitate
	0x0021e68a, // n0x0a1e c0x0000 (---------------)  + I inawashiro
	0x00226fc8, // n0x0a1f c0x0000 (---------------)  + I ishikawa
	0x0024e085, // n0x0a20 c0x0000 (---------------)  + I iwaki
	0x00264309, // n0x0a21 c0x0000 (---------------)  + I izumizaki
	0x002be18a, // n0x0a22 c0x0000 (---------------)  + I kagamiishi
	0x00229248, // n0x0a23 c0x0000 (---------------)  + I kaneyama
	0x00295208, // n0x0a24 c0x0000 (---------------)  + I kawamata
	0x0028a988, // n0x0a25 c0x0000 (---------------)  + I kitakata
	0x0029750c, // n0x0a26 c0x0000 (---------------)  + I kitashiobara
	0x002e0245, // n0x0a27 c0x0000 (---------------)  + I koori
	0x00297b48, // n0x0a28 c0x0000 (---------------)  + I koriyama
	0x002f5446, // n0x0a29 c0x0000 (---------------)  + I kunimi
	0x0029e086, // n0x0a2a c0x0000 (---------------)  + I miharu
	0x002bb107, // n0x0a2b c0x0000 (---------------)  + I mishima
	0x00253a05, // n0x0a2c c0x0000 (---------------)  + I namie
	0x0033fdc5, // n0x0a2d c0x0000 (---------------)  + I nango
	0x002b6a49, // n0x0a2e c0x0000 (---------------)  + I nishiaizu
	0x0021aac7, // n0x0a2f c0x0000 (---------------)  + I nishigo
	0x00204945, // n0x0a30 c0x0000 (---------------)  + I okuma
	0x00228f07, // n0x0a31 c0x0000 (---------------)  + I omotego
	0x002142c3, // n0x0a32 c0x0000 (---------------)  + I ono
	0x002be845, // n0x0a33 c0x0000 (---------------)  + I otama
	0x00227e48, // n0x0a34 c0x0000 (---------------)  + I samegawa
	0x00206b87, // n0x0a35 c0x0000 (---------------)  + I shimogo
	0x002950c9, // n0x0a36 c0x0000 (---------------)  + I shirakawa
	0x002ddc85, // n0x0a37 c0x0000 (---------------)  + I showa
	0x002e21c4, // n0x0a38 c0x0000 (---------------)  + I soma
	0x0029c3c8, // n0x0a39 c0x0000 (---------------)  + I sukagawa
	0x0022db07, // n0x0a3a c0x0000 (---------------)  + I taishin
	0x0020a7c8, // n0x0a3b c0x0000 (---------------)  + I tamakawa
	0x0026a848, // n0x0a3c c0x0000 (---------------)  + I tanagura
	0x0021f9c5, // n0x0a3d c0x0000 (---------------)  + I tenei
	0x002b4d06, // n0x0a3e c0x0000 (---------------)  + I yabuki
	0x002956c6, // n0x0a3f c0x0000 (---------------)  + I yamato
	0x002efd49, // n0x0a40 c0x0000 (---------------)  + I yamatsuri
	0x003010c7, // n0x0a41 c0x0000 (---------------)  + I yanaizu
	0x002a9406, // n0x0a42 c0x0000 (---------------)  + I yugawa
	0x002a6507, // n0x0a43 c0x0000 (---------------)  + I anpachi
	0x00203bc3, // n0x0a44 c0x0000 (---------------)  + I ena
	0x00279c84, // n0x0a45 c0x0000 (---------------)  + I gifu
	0x00367c05, // n0x0a46 c0x0000 (---------------)  + I ginan
	0x002152c4, // n0x0a47 c0x0000 (---------------)  + I godo
	0x0023c504, // n0x0a48 c0x0000 (---------------)  + I gujo
	0x00290847, // n0x0a49 c0x0000 (---------------)  + I hashima
	0x002d32c7, // n0x0a4a c0x0000 (---------------)  + I hichiso
	0x002780c4, // n0x0a4b c0x0000 (---------------)  + I hida
	0x00294f10, // n0x0a4c c0x0000 (---------------)  + I higashishirakawa
	0x00366e87, // n0x0a4d c0x0000 (---------------)  + I ibigawa
	0x002024c5, // n0x0a4e c0x0000 (---------------)  + I ikeda
	0x0027910c, // n0x0a4f c0x0000 (---------------)  + I kakamigahara
	0x00204dc4, // n0x0a50 c0x0000 (---------------)  + I kani
	0x002e26c8, // n0x0a51 c0x0000 (---------------)  + I kasahara
	0x00288dc9, // n0x0a52 c0x0000 (---------------)  + I kasamatsu
	0x0022b046, // n0x0a53 c0x0000 (---------------)  + I kawaue
	0x0027cc88, // n0x0a54 c0x0000 (---------------)  + I kitagata
	0x00256e04, // n0x0a55 c0x0000 (---------------)  + I mino
	0x00256e08, // n0x0a56 c0x0000 (---------------)  + I minokamo
	0x002bcd46, // n0x0a57 c0x0000 (---------------)  + I mitake
	0x0024b208, // n0x0a58 c0x0000 (---------------)  + I mizunami
	0x00290186, // n0x0a59 c0x0000 (---------------)  + I motosu
	0x00203fcb, // n0x0a5a c0x0000 (---------------)  + I nakatsugawa
	0x002043c5, // n0x0a5b c0x0000 (---------------)  + I ogaki
	0x002bb388, // n0x0a5c c0x0000 (---------------)  + I sakahogi
	0x00213984, // n0x0a5d c0x0000 (---------------)  + I seki
	0x0030c98a, // n0x0a5e c0x0000 (---------------)  + I sekigahara
	0x002950c9, // n0x0a5f c0x0000 (---------------)  + I shirakawa
	0x0027c6c6, // n0x0a60 c0x0000 (---------------)  + I tajimi
	0x002e41c8, // n0x0a61 c0x0000 (---------------)  + I takayama
	0x003401c5, // n0x0a62 c0x0000 (---------------)  + I tarui
	0x00221c44, // n0x0a63 c0x0000 (---------------)  + I toki
	0x002e25c6, // n0x0a64 c0x0000 (---------------)  + I tomika
	0x002d2f88, // n0x0a65 c0x0000 (---------------)  + I wanouchi
	0x0027d308, // n0x0a66 c0x0000 (---------------)  + I yamagata
	0x00324906, // n0x0a67 c0x0000 (---------------)  + I yaotsu
	0x00206e44, // n0x0a68 c0x0000 (---------------)  + I yoro
	0x0023c946, // n0x0a69 c0x0000 (---------------)  + I annaka
	0x00374b47, // n0x0a6a c0x0000 (---------------)  + I chiyoda
	0x00275147, // n0x0a6b c0x0000 (---------------)  + I fujioka
	0x00263ecf, // n0x0a6c c0x0000 (---------------)  + I higashiagatsuma
	0x002f6f07, // n0x0a6d c0x0000 (---------------)  + I isesaki
	0x002f2447, // n0x0a6e c0x0000 (---------------)  + I itakura
	0x0031f0c5, // n0x0a6f c0x0000 (---------------)  + I kanna
	0x002eb645, // n0x0a70 c0x0000 (---------------)  + I kanra
	0x0029b649, // n0x0a71 c0x0000 (---------------)  + I katashina
	0x00237786, // n0x0a72 c0x0000 (---------------)  + I kawaba
	0x00259045, // n0x0a73 c0x0000 (---------------)  + I kiryu
	0x0027e707, // n0x0a74 c0x0000 (---------------)  + I kusatsu
	0x002b0008, // n0x0a75 c0x0000 (---------------)  + I maebashi
	0x00219485, // n0x0a76 c0x0000 (---------------)  + I meiwa
	0x00267c06, // n0x0a77 c0x0000 (---------------)  + I midori
	0x00226008, // n0x0a78 c0x0000 (---------------)  + I minakami
	0x0020d58a, // n0x0a79 c0x0000 (---------------)  + I naganohara
	0x00314d48, // n0x0a7a c0x0000 (---------------)  + I nakanojo
	0x002860c7, // n0x0a7b c0x0000 (---------------)  + I nanmoku
	0x002e40c6, // n0x0a7c c0x0000 (---------------)  + I numata
	0x002642c6, // n0x0a7d c0x0000 (---------------)  + I oizumi
	0x00228883, // n0x0a7e c0x0000 (---------------)  + I ora
	0x00213d43, // n0x0a7f c0x0000 (---------------)  + I ota
	0x002adc49, // n0x0a80 c0x0000 (---------------)  + I shibukawa
	0x002c39c9, // n0x0a81 c0x0000 (---------------)  + I shimonita
	0x002e1e86, // n0x0a82 c0x0000 (---------------)  + I shinto
	0x002ddc85, // n0x0a83 c0x0000 (---------------)  + I showa
	0x002f5648, // n0x0a84 c0x0000 (---------------)  + I takasaki
	0x002e41c8, // n0x0a85 c0x0000 (---------------)  + I takayama
	0x002d13c8, // n0x0a86 c0x0000 (---------------)  + I tamamura
	0x0020180b, // n0x0a87 c0x0000 (---------------)  + I tatebayashi
	0x002e6287, // n0x0a88 c0x0000 (---------------)  + I tomioka
	0x002a96c9, // n0x0a89 c0x0000 (---------------)  + I tsukiyono
	0x00264148, // n0x0a8a c0x0000 (---------------)  + I tsumagoi
	0x002107c4, // n0x0a8b c0x0000 (---------------)  + I ueno
	0x002c2108, // n0x0a8c c0x0000 (---------------)  + I yoshioka
	0x00288909, // n0x0a8d c0x0000 (---------------)  + I asaminami
	0x002653c5, // n0x0a8e c0x0000 (---------------)  + I daiwa
	0x00269987, // n0x0a8f c0x0000 (---------------)  + I etajima
	0x0028c305, // n0x0a90 c0x0000 (---------------)  + I fuchu
	0x0027d208, // n0x0a91 c0x0000 (---------------)  + I fukuyama
	0x0028ad8b, // n0x0a92 c0x0000 (---------------)  + I hatsukaichi
	0x0028ea10, // n0x0a93 c0x0000 (---------------)  + I higashihiroshima
	0x002a38c5, // n0x0a94 c0x0000 (---------------)  + I hongo
	0x002138cc, // n0x0a95 c0x0000 (---------------)  + I jinsekikogen
	0x0024c1c5, // n0x0a96 c0x0000 (---------------)  + I kaita
	0x00273ec3, // n0x0a97 c0x0000 (---------------)  + I kui
	0x002d7806, // n0x0a98 c0x0000 (---------------)  + I kumano
	0x002b3044, // n0x0a99 c0x0000 (---------------)  + I kure
	0x002840c6, // n0x0a9a c0x0000 (---------------)  + I mihara
	0x00295c07, // n0x0a9b c0x0000 (---------------)  + I miyoshi
	0x00203fc4, // n0x0a9c c0x0000 (---------------)  + I naka
	0x002de548, // n0x0a9d c0x0000 (---------------)  + I onomichi
	0x00360e0d, // n0x0a9e c0x0000 (---------------)  + I osakikamijima
	0x002d19c5, // n0x0a9f c0x0000 (---------------)  + I otake
	0x00250b44, // n0x0aa0 c0x0000 (---------------)  + I saka
	0x002207c4, // n0x0aa1 c0x0000 (---------------)  + I sera
	0x00298ac9, // n0x0aa2 c0x0000 (---------------)  + I seranishi
	0x002cf1c8, // n0x0aa3 c0x0000 (---------------)  + I shinichi
	0x002b4587, // n0x0aa4 c0x0000 (---------------)  + I shobara
	0x002bcdc8, // n0x0aa5 c0x0000 (---------------)  + I takehara
	0x0027da88, // n0x0aa6 c0x0000 (---------------)  + I abashiri
	0x00278205, // n0x0aa7 c0x0000 (---------------)  + I abira
	0x0025ef87, // n0x0aa8 c0x0000 (---------------)  + I aibetsu
	0x00278187, // n0x0aa9 c0x0000 (---------------)  + I akabira
	0x0029a247, // n0x0aaa c0x0000 (---------------)  + I akkeshi
	0x002bac09, // n0x0aab c0x0000 (---------------)  + I asahikawa
	0x002385c9, // n0x0aac c0x0000 (---------------)  + I ashibetsu
	0x0023f246, // n0x0aad c0x0000 (---------------)  + I ashoro
	0x002ab986, // n0x0aae c0x0000 (---------------)  + I assabu
	0x00264106, // n0x0aaf c0x0000 (---------------)  + I atsuma
	0x00266b45, // n0x0ab0 c0x0000 (---------------)  + I bibai
	0x0030af84, // n0x0ab1 c0x0000 (---------------)  + I biei
	0x00200346, // n0x0ab2 c0x0000 (---------------)  + I bifuka
	0x00200b06, // n0x0ab3 c0x0000 (---------------)  + I bihoro
	0x00278248, // n0x0ab4 c0x0000 (---------------)  + I biratori
	0x00284ecb, // n0x0ab5 c0x0000 (---------------)  + I chippubetsu
	0x0029f647, // n0x0ab6 c0x0000 (---------------)  + I chitose
	0x00271284, // n0x0ab7 c0x0000 (---------------)  + I date
	0x0036cb46, // n0x0ab8 c0x0000 (---------------)  + I ebetsu
	0x00273d07, // n0x0ab9 c0x0000 (---------------)  + I embetsu
	0x00319cc5, // n0x0aba c0x0000 (---------------)  + I eniwa
	0x00309185, // n0x0abb c0x0000 (---------------)  + I erimo
	0x0022e244, // n0x0abc c0x0000 (---------------)  + I esan
	0x00238546, // n0x0abd c0x0000 (---------------)  + I esashi
	0x002003c8, // n0x0abe c0x0000 (---------------)  + I fukagawa
	0x0027bcc9, // n0x0abf c0x0000 (---------------)  + I fukushima
	0x00249d46, // n0x0ac0 c0x0000 (---------------)  + I furano
	0x0027fec8, // n0x0ac1 c0x0000 (---------------)  + I furubira
	0x002fef86, // n0x0ac2 c0x0000 (---------------)  + I haboro
	0x0033b948, // n0x0ac3 c0x0000 (---------------)  + I hakodate
	0x002f41cc, // n0x0ac4 c0x0000 (---------------)  + I hamatonbetsu
	0x002780c6, // n0x0ac5 c0x0000 (---------------)  + I hidaka
	0x0028f7cd, // n0x0ac6 c0x0000 (---------------)  + I higashikagura
	0x0028fc4b, // n0x0ac7 c0x0000 (---------------)  + I higashikawa
	0x00249f05, // n0x0ac8 c0x0000 (---------------)  + I hiroo
	0x00226b47, // n0x0ac9 c0x0000 (---------------)  + I hokuryu
	0x003112c6, // n0x0aca c0x0000 (---------------)  + I hokuto
	0x002129c8, // n0x0acb c0x0000 (---------------)  + I honbetsu
	0x0023f2c9, // n0x0acc c0x0000 (---------------)  + I horokanai
	0x002b6588, // n0x0acd c0x0000 (---------------)  + I horonobe
	0x002024c5, // n0x0ace c0x0000 (---------------)  + I ikeda
	0x00269a87, // n0x0acf c0x0000 (---------------)  + I imakane
	0x002be308, // n0x0ad0 c0x0000 (---------------)  + I ishikari
	0x00350149, // n0x0ad1 c0x0000 (---------------)  + I iwamizawa
	0x0024ccc6, // n0x0ad2 c0x0000 (---------------)  + I iwanai
	0x00249c4a, // n0x0ad3 c0x0000 (---------------)  + I kamifurano
	0x00212748, // n0x0ad4 c0x0000 (---------------)  + I kamikawa
	0x002b63cb, // n0x0ad5 c0x0000 (---------------)  + I kamishihoro
	0x0026b90c, // n0x0ad6 c0x0000 (---------------)  + I kamisunagawa
	0x00256f08, // n0x0ad7 c0x0000 (---------------)  + I kamoenai
	0x00278dc6, // n0x0ad8 c0x0000 (---------------)  + I kayabe
	0x002de8c8, // n0x0ad9 c0x0000 (---------------)  + I kembuchi
	0x002993c7, // n0x0ada c0x0000 (---------------)  + I kikonai
	0x002d2d49, // n0x0adb c0x0000 (---------------)  + I kimobetsu
	0x00269d4d, // n0x0adc c0x0000 (---------------)  + I kitahiroshima
	0x0028f206, // n0x0add c0x0000 (---------------)  + I kitami
	0x00203588, // n0x0ade c0x0000 (---------------)  + I kiyosato
	0x002f9ec9, // n0x0adf c0x0000 (---------------)  + I koshimizu
	0x002b2688, // n0x0ae0 c0x0000 (---------------)  + I kunneppu
	0x00322c48, // n0x0ae1 c0x0000 (---------------)  + I kuriyama
	0x002b428c, // n0x0ae2 c0x0000 (---------------)  + I kuromatsunai
	0x002b6dc7, // n0x0ae3 c0x0000 (---------------)  + I kushiro
	0x002b7b07, // n0x0ae4 c0x0000 (---------------)  + I kutchan
	0x002baa45, // n0x0ae5 c0x0000 (---------------)  + I kyowa
	0x002195c7, // n0x0ae6 c0x0000 (---------------)  + I mashike
	0x002afec8, // n0x0ae7 c0x0000 (---------------)  + I matsumae
	0x002e2646, // n0x0ae8 c0x0000 (---------------)  + I mikasa
	0x0025814c, // n0x0ae9 c0x0000 (---------------)  + I minamifurano
	0x00366708, // n0x0aea c0x0000 (---------------)  + I mombetsu
	0x002c3308, // n0x0aeb c0x0000 (---------------)  + I moseushi
	0x00371306, // n0x0aec c0x0000 (---------------)  + I mukawa
	0x002b4987, // n0x0aed c0x0000 (---------------)  + I muroran
	0x0023f444, // n0x0aee c0x0000 (---------------)  + I naie
	0x0029bf08, // n0x0aef c0x0000 (---------------)  + I nakagawa
	0x003523cc, // n0x0af0 c0x0000 (---------------)  + I nakasatsunai
	0x002e6dcc, // n0x0af1 c0x0000 (---------------)  + I nakatombetsu
	0x00220b05, // n0x0af2 c0x0000 (---------------)  + I nanae
	0x002058c7, // n0x0af3 c0x0000 (---------------)  + I nanporo
	0x00206dc6, // n0x0af4 c0x0000 (---------------)  + I nayoro
	0x002b4906, // n0x0af5 c0x0000 (---------------)  + I nemuro
	0x002e5888, // n0x0af6 c0x0000 (---------------)  + I niikappu
	0x00204804, // n0x0af7 c0x0000 (---------------)  + I niki
	0x002d9f8b, // n0x0af8 c0x0000 (---------------)  + I nishiokoppe
	0x003097cb, // n0x0af9 c0x0000 (---------------)  + I noboribetsu
	0x002e40c6, // n0x0afa c0x0000 (---------------)  + I numata
	0x00360c87, // n0x0afb c0x0000 (---------------)  + I obihiro
	0x00205285, // n0x0afc c0x0000 (---------------)  + I obira
	0x0026c685, // n0x0afd c0x0000 (---------------)  + I oketo
	0x002da0c6, // n0x0afe c0x0000 (---------------)  + I okoppe
	0x00340185, // n0x0aff c0x0000 (---------------)  + I otaru
	0x00265a85, // n0x0b00 c0x0000 (---------------)  + I otobe
	0x002af907, // n0x0b01 c0x0000 (---------------)  + I otofuke
	0x00207149, // n0x0b02 c0x0000 (---------------)  + I otoineppu
	0x00319ac4, // n0x0b03 c0x0000 (---------------)  + I oumu
	0x00277005, // n0x0b04 c0x0000 (---------------)  + I ozora
	0x002cf8c5, // n0x0b05 c0x0000 (---------------)  + I pippu
	0x002b4a88, // n0x0b06 c0x0000 (---------------)  + I rankoshi
	0x002de385, // n0x0b07 c0x0000 (---------------)  + I rebun
	0x00296789, // n0x0b08 c0x0000 (---------------)  + I rikubetsu
	0x002f2e47, // n0x0b09 c0x0000 (---------------)  + I rishiri
	0x002f2e4b, // n0x0b0a c0x0000 (---------------)  + I rishirifuji
	0x00247286, // n0x0b0b c0x0000 (---------------)  + I saroma
	0x0024bc49, // n0x0b0c c0x0000 (---------------)  + I sarufutsu
	0x002dca08, // n0x0b0d c0x0000 (---------------)  + I shakotan
	0x002df485, // n0x0b0e c0x0000 (---------------)  + I shari
	0x0029a348, // n0x0b0f c0x0000 (---------------)  + I shibecha
	0x00238608, // n0x0b10 c0x0000 (---------------)  + I shibetsu
	0x002a21c7, // n0x0b11 c0x0000 (---------------)  + I shikabe
	0x002b0147, // n0x0b12 c0x0000 (---------------)  + I shikaoi
	0x002908c9, // n0x0b13 c0x0000 (---------------)  + I shimamaki
	0x0024b147, // n0x0b14 c0x0000 (---------------)  + I shimizu
	0x002b78c9, // n0x0b15 c0x0000 (---------------)  + I shimokawa
	0x002daecc, // n0x0b16 c0x0000 (---------------)  + I shinshinotsu
	0x002e1e88, // n0x0b17 c0x0000 (---------------)  + I shintoku
	0x0031b609, // n0x0b18 c0x0000 (---------------)  + I shiranuka
	0x0031d6c7, // n0x0b19 c0x0000 (---------------)  + I shiraoi
	0x0027db49, // n0x0b1a c0x0000 (---------------)  + I shiriuchi
	0x002d3407, // n0x0b1b c0x0000 (---------------)  + I sobetsu
	0x0026ba08, // n0x0b1c c0x0000 (---------------)  + I sunagawa
	0x00247945, // n0x0b1d c0x0000 (---------------)  + I taiki
	0x002bc746, // n0x0b1e c0x0000 (---------------)  + I takasu
	0x002b5308, // n0x0b1f c0x0000 (---------------)  + I takikawa
	0x00307648, // n0x0b20 c0x0000 (---------------)  + I takinoue
	0x002be049, // n0x0b21 c0x0000 (---------------)  + I teshikaga
	0x00265ac7, // n0x0b22 c0x0000 (---------------)  + I tobetsu
	0x0026c745, // n0x0b23 c0x0000 (---------------)  + I tohma
	0x002ca489, // n0x0b24 c0x0000 (---------------)  + I tomakomai
	0x002626c6, // n0x0b25 c0x0000 (---------------)  + I tomari
	0x0028a784, // n0x0b26 c0x0000 (---------------)  + I toya
	0x0032ddc6, // n0x0b27 c0x0000 (---------------)  + I toyako
	0x00257248, // n0x0b28 c0x0000 (---------------)  + I toyotomi
	0x002599c7, // n0x0b29 c0x0000 (---------------)  + I toyoura
	0x002850c8, // n0x0b2a c0x0000 (---------------)  + I tsubetsu
	0x00342c49, // n0x0b2b c0x0000 (---------------)  + I tsukigata
	0x0030fc47, // n0x0b2c c0x0000 (---------------)  + I urakawa
	0x00297386, // n0x0b2d c0x0000 (---------------)  + I urausu
	0x00226c04, // n0x0b2e c0x0000 (---------------)  + I uryu
	0x0021acc9, // n0x0b2f c0x0000 (---------------)  + I utashinai
	0x0025ee08, // n0x0b30 c0x0000 (---------------)  + I wakkanai
	0x003711c7, // n0x0b31 c0x0000 (---------------)  + I wassamu
	0x003695c6, // n0x0b32 c0x0000 (---------------)  + I yakumo
	0x002a47c6, // n0x0b33 c0x0000 (---------------)  + I yoichi
	0x00299504, // n0x0b34 c0x0000 (---------------)  + I aioi
	0x002d1b46, // n0x0b35 c0x0000 (---------------)  + I akashi
	0x00204a43, // n0x0b36 c0x0000 (---------------)  + I ako
	0x0036a949, // n0x0b37 c0x0000 (---------------)  + I amagasaki
	0x00204386, // n0x0b38 c0x0000 (---------------)  + I aogaki
	0x00368ec5, // n0x0b39 c0x0000 (---------------)  + I asago
	0x002978c6, // n0x0b3a c0x0000 (---------------)  + I ashiya
	0x0020a905, // n0x0b3b c0x0000 (---------------)  + I awaji
	0x0027c988, // n0x0b3c c0x0000 (---------------)  + I fukusaki
	0x00256c47, // n0x0b3d c0x0000 (---------------)  + I goshiki
	0x002a5006, // n0x0b3e c0x0000 (---------------)  + I harima
	0x00202986, // n0x0b3f c0x0000 (---------------)  + I himeji
	0x002a0348, // n0x0b40 c0x0000 (---------------)  + I ichikawa
	0x0029b7c7, // n0x0b41 c0x0000 (---------------)  + I inagawa
	0x0028f245, // n0x0b42 c0x0000 (---------------)  + I itami
	0x00297dc8, // n0x0b43 c0x0000 (---------------)  + I kakogawa
	0x002855c8, // n0x0b44 c0x0000 (---------------)  + I kamigori
	0x00212748, // n0x0b45 c0x0000 (---------------)  + I kamikawa
	0x0024c085, // n0x0b46 c0x0000 (---------------)  + I kasai
	0x002bc7c6, // n0x0b47 c0x0000 (---------------)  + I kasuga
	0x002b6949, // n0x0b48 c0x0000 (---------------)  + I kawanishi
	0x00295544, // n0x0b49 c0x0000 (---------------)  + I miki
	0x00293ecb, // n0x0b4a c0x0000 (---------------)  + I minamiawaji
	0x0022814b, // n0x0b4b c0x0000 (---------------)  + I nishinomiya
	0x0024df89, // n0x0b4c c0x0000 (---------------)  + I nishiwaki
	0x002142c3, // n0x0b4d c0x0000 (---------------)  + I ono
	0x00256045, // n0x0b4e c0x0000 (---------------)  + I sanda
	0x0024e406, // n0x0b4f c0x0000 (---------------)  + I sannan
	0x002527c8, // n0x0b50 c0x0000 (---------------)  + I sasayama
	0x00275544, // n0x0b51 c0x0000 (---------------)  + I sayo
	0x002a57c6, // n0x0b52 c0x0000 (---------------)  + I shingu
	0x002c6549, // n0x0b53 c0x0000 (---------------)  + I shinonsen
	0x0033e485, // n0x0b54 c0x0000 (---------------)  + I shiso
	0x002af846, // n0x0b55 c0x0000 (---------------)  + I sumoto
	0x0022db06, // n0x0b56 c0x0000 (---------------)  + I taishi
	0x0020a244, // n0x0b57 c0x0000 (---------------)  + I taka
	0x0020a24a, // n0x0b58 c0x0000 (---------------)  + I takarazuka
	0x00368e08, // n0x0b59 c0x0000 (---------------)  + I takasago
	0x00307646, // n0x0b5a c0x0000 (---------------)  + I takino
	0x00276e05, // n0x0b5b c0x0000 (---------------)  + I tamba
	0x002662c7, // n0x0b5c c0x0000 (---------------)  + I tatsuno
	0x00251687, // n0x0b5d c0x0000 (---------------)  + I toyooka
	0x002b4d04, // n0x0b5e c0x0000 (---------------)  + I yabu
	0x00228387, // n0x0b5f c0x0000 (---------------)  + I yashiro
	0x002126c4, // n0x0b60 c0x0000 (---------------)  + I yoka
	0x00251986, // n0x0b61 c0x0000 (---------------)  + I yokawa
	0x00209bc3, // n0x0b62 c0x0000 (---------------)  + I ami
	0x002bac05, // n0x0b63 c0x0000 (---------------)  + I asahi
	0x003305c5, // n0x0b64 c0x0000 (---------------)  + I bando
	0x002d30c8, // n0x0b65 c0x0000 (---------------)  + I chikusei
	0x00279d85, // n0x0b66 c0x0000 (---------------)  + I daigo
	0x00277e09, // n0x0b67 c0x0000 (---------------)  + I fujishiro
	0x0029bd47, // n0x0b68 c0x0000 (---------------)  + I hitachi
	0x0029bd4b, // n0x0b69 c0x0000 (---------------)  + I hitachinaka
	0x0029d28c, // n0x0b6a c0x0000 (---------------)  + I hitachiomiya
	0x0029d8ca, // n0x0b6b c0x0000 (---------------)  + I hitachiota
	0x0032cd07, // n0x0b6c c0x0000 (---------------)  + I ibaraki
	0x0020cd43, // n0x0b6d c0x0000 (---------------)  + I ina
	0x002a1448, // n0x0b6e c0x0000 (---------------)  + I inashiki
	0x0024c245, // n0x0b6f c0x0000 (---------------)  + I itako
	0x00219505, // n0x0b70 c0x0000 (---------------)  + I iwama
	0x00214384, // n0x0b71 c0x0000 (---------------)  + I joso
	0x0026b906, // n0x0b72 c0x0000 (---------------)  + I kamisu
	0x00288dc6, // n0x0b73 c0x0000 (---------------)  + I kasama
	0x002d1b87, // n0x0b74 c0x0000 (---------------)  + I kashima
	0x00207d0b, // n0x0b75 c0x0000 (---------------)  + I kasumigaura
	0x00297e44, // n0x0b76 c0x0000 (---------------)  + I koga
	0x0033f984, // n0x0b77 c0x0000 (---------------)  + I miho
	0x002bcfc4, // n0x0b78 c0x0000 (---------------)  + I mito
	0x002c1c06, // n0x0b79 c0x0000 (---------------)  + I moriya
	0x00203fc4, // n0x0b7a c0x0000 (---------------)  + I naka
	0x002bc5c8, // n0x0b7b c0x0000 (---------------)  + I namegata
	0x00321385, // n0x0b7c c0x0000 (---------------)  + I oarai
	0x0022f3c5, // n0x0b7d c0x0000 (---------------)  + I ogawa
	0x002d1307, // n0x0b7e c0x0000 (---------------)  + I omitama
	0x00226c49, // n0x0b7f c0x0000 (---------------)  + I ryugasaki
	0x0032db85, // n0x0b80 c0x0000 (---------------)  + I sakai
	0x0021a00a, // n0x0b81 c0x0000 (---------------)  + I sakuragawa
	0x002dd249, // n0x0b82 c0x0000 (---------------)  + I shimodate
	0x002cec0a, // n0x0b83 c0x0000 (---------------)  + I shimotsuma
	0x0021e7c9, // n0x0b84 c0x0000 (---------------)  + I shirosato
	0x002e5b84, // n0x0b85 c0x0000 (---------------)  + I sowa
	0x002dc305, // n0x0b86 c0x0000 (---------------)  + I suifu
	0x0031f708, // n0x0b87 c0x0000 (---------------)  + I takahagi
	0x003572cb, // n0x0b88 c0x0000 (---------------)  + I tamatsukuri
	0x002f88c5, // n0x0b89 c0x0000 (---------------)  + I tokai
	0x003451c6, // n0x0b8a c0x0000 (---------------)  + I tomobe
	0x0023fb84, // n0x0b8b c0x0000 (---------------)  + I tone
	0x00278346, // n0x0b8c c0x0000 (---------------)  + I toride
	0x0030fac9, // n0x0b8d c0x0000 (---------------)  + I tsuchiura
	0x0036cc07, // n0x0b8e c0x0000 (---------------)  + I tsukuba
	0x002c51c8, // n0x0b8f c0x0000 (---------------)  + I uchihara
	0x0028a306, // n0x0b90 c0x0000 (---------------)  + I ushiku
	0x00374ac7, // n0x0b91 c0x0000 (---------------)  + I yachiyo
	0x0027d308, // n0x0b92 c0x0000 (---------------)  + I yamagata
	0x00354f06, // n0x0b93 c0x0000 (---------------)  + I yawara
	0x002014c4, // n0x0b94 c0x0000 (---------------)  + I yuki
	0x0023e287, // n0x0b95 c0x0000 (---------------)  + I anamizu
	0x0034ecc5, // n0x0b96 c0x0000 (---------------)  + I hakui
	0x00372107, // n0x0b97 c0x0000 (---------------)  + I hakusan
	0x00200444, // n0x0b98 c0x0000 (---------------)  + I kaga
	0x00311246, // n0x0b99 c0x0000 (---------------)  + I kahoku
	0x00227248, // n0x0b9a c0x0000 (---------------)  + I kanazawa
	0x0028fe08, // n0x0b9b c0x0000 (---------------)  + I kawakita
	0x0032c6c7, // n0x0b9c c0x0000 (---------------)  + I komatsu
	0x002501c8, // n0x0b9d c0x0000 (---------------)  + I nakanoto
	0x0028e485, // n0x0b9e c0x0000 (---------------)  + I nanao
	0x00214104, // n0x0b9f c0x0000 (---------------)  + I nomi
	0x002a0248, // n0x0ba0 c0x0000 (---------------)  + I nonoichi
	0x002502c4, // n0x0ba1 c0x0000 (---------------)  + I noto
	0x00224d85, // n0x0ba2 c0x0000 (---------------)  + I shika
	0x002eb784, // n0x0ba3 c0x0000 (---------------)  + I suzu
	0x0030f607, // n0x0ba4 c0x0000 (---------------)  + I tsubata
	0x00367ac7, // n0x0ba5 c0x0000 (---------------)  + I tsurugi
	0x0027dc88, // n0x0ba6 c0x0000 (---------------)  + I uchinada
	0x0020a946, // n0x0ba7 c0x0000 (---------------)  + I wajima
	0x00279d05, // n0x0ba8 c0x0000 (---------------)  + I fudai
	0x00277c08, // n0x0ba9 c0x0000 (---------------)  + I fujisawa
	0x00314f48, // n0x0baa c0x0000 (---------------)  + I hanamaki
	0x0029b049, // n0x0bab c0x0000 (---------------)  + I hiraizumi
	0x00228446, // n0x0bac c0x0000 (---------------)  + I hirono
	0x00201a88, // n0x0bad c0x0000 (---------------)  + I ichinohe
	0x0030c80a, // n0x0bae c0x0000 (---------------)  + I ichinoseki
	0x00319d48, // n0x0baf c0x0000 (---------------)  + I iwaizumi
	0x00351705, // n0x0bb0 c0x0000 (---------------)  + I iwate
	0x00352d06, // n0x0bb1 c0x0000 (---------------)  + I joboji
	0x00251288, // n0x0bb2 c0x0000 (---------------)  + I kamaishi
	0x00269b4a, // n0x0bb3 c0x0000 (---------------)  + I kanegasaki
	0x00314887, // n0x0bb4 c0x0000 (---------------)  + I karumai
	0x00254bc5, // n0x0bb5 c0x0000 (---------------)  + I kawai
	0x0032ce48, // n0x0bb6 c0x0000 (---------------)  + I kitakami
	0x0027eec4, // n0x0bb7 c0x0000 (---------------)  + I kuji
	0x00360706, // n0x0bb8 c0x0000 (---------------)  + I kunohe
	0x002b8ec8, // n0x0bb9 c0x0000 (---------------)  + I kuzumaki
	0x00214186, // n0x0bba c0x0000 (---------------)  + I miyako
	0x00220148, // n0x0bbb c0x0000 (---------------)  + I mizusawa
	0x003424c7, // n0x0bbc c0x0000 (---------------)  + I morioka
	0x002130c6, // n0x0bbd c0x0000 (---------------)  + I ninohe
	0x0025f744, // n0x0bbe c0x0000 (---------------)  + I noda
	0x002a4bc7, // n0x0bbf c0x0000 (---------------)  + I ofunato
	0x002fda84, // n0x0bc0 c0x0000 (---------------)  + I oshu
	0x0030fa87, // n0x0bc1 c0x0000 (---------------)  + I otsuchi
	0x0037150d, // n0x0bc2 c0x0000 (---------------)  + I rikuzentakata
	0x002022c5, // n0x0bc3 c0x0000 (---------------)  + I shiwa
	0x002dd04b, // n0x0bc4 c0x0000 (---------------)  + I shizukuishi
	0x00290286, // n0x0bc5 c0x0000 (---------------)  + I sumita
	0x0024cac8, // n0x0bc6 c0x0000 (---------------)  + I tanohata
	0x0022e084, // n0x0bc7 c0x0000 (---------------)  + I tono
	0x00316686, // n0x0bc8 c0x0000 (---------------)  + I yahaba
	0x002795c6, // n0x0bc9 c0x0000 (---------------)  + I yamada
	0x00272fc7, // n0x0bca c0x0000 (---------------)  + I ayagawa
	0x0028f48d, // n0x0bcb c0x0000 (---------------)  + I higashikagawa
	0x002dd607, // n0x0bcc c0x0000 (---------------)  + I kanonji
	0x003587c8, // n0x0bcd c0x0000 (---------------)  + I kotohira
	0x0026c805, // n0x0bce c0x0000 (---------------)  + I manno
	0x0028b648, // n0x0bcf c0x0000 (---------------)  + I marugame
	0x002bd986, // n0x0bd0 c0x0000 (---------------)  + I mitoyo
	0x0028e508, // n0x0bd1 c0x0000 (---------------)  + I naoshima
	0x00232946, // n0x0bd2 c0x0000 (---------------)  + I sanuki
	0x003679c7, // n0x0bd3 c0x0000 (---------------)  + I tadotsu
	0x00257d09, // n0x0bd4 c0x0000 (---------------)  + I takamatsu
	0x0022e087, // n0x0bd5 c0x0000 (---------------)  + I tonosho
	0x00281a48, // n0x0bd6 c0x0000 (---------------)  + I uchinomi
	0x0026ffc5, // n0x0bd7 c0x0000 (---------------)  + I utazu
	0x00215f08, // n0x0bd8 c0x0000 (---------------)  + I zentsuji
	0x0025e645, // n0x0bd9 c0x0000 (---------------)  + I akune
	0x00244b85, // n0x0bda c0x0000 (---------------)  + I amami
	0x00345545, // n0x0bdb c0x0000 (---------------)  + I hioki
	0x0022b803, // n0x0bdc c0x0000 (---------------)  + I isa
	0x0026ddc4, // n0x0bdd c0x0000 (---------------)  + I isen
	0x00264305, // n0x0bde c0x0000 (---------------)  + I izumi
	0x00317449, // n0x0bdf c0x0000 (---------------)  + I kagoshima
	0x0031aa06, // n0x0be0 c0x0000 (---------------)  + I kanoya
	0x002bd588, // n0x0be1 c0x0000 (---------------)  + I kawanabe
	0x00238845, // n0x0be2 c0x0000 (---------------)  + I kinko
	0x002ab187, // n0x0be3 c0x0000 (---------------)  + I kouyama
	0x00212d0a, // n0x0be4 c0x0000 (---------------)  + I makurazaki
	0x002af789, // n0x0be5 c0x0000 (---------------)  + I matsumoto
	0x002a364a, // n0x0be6 c0x0000 (---------------)  + I minamitane
	0x002c8b88, // n0x0be7 c0x0000 (---------------)  + I nakatane
	0x00228d4c, // n0x0be8 c0x0000 (---------------)  + I nishinoomote
	0x0027e78d, // n0x0be9 c0x0000 (---------------)  + I satsumasendai
	0x002e28c3, // n0x0bea c0x0000 (---------------)  + I soo
	0x00220048, // n0x0beb c0x0000 (---------------)  + I tarumizu
	0x00216b85, // n0x0bec c0x0000 (---------------)  + I yusui
	0x00237706, // n0x0bed c0x0000 (---------------)  + I aikawa
	0x00343a86, // n0x0bee c0x0000 (---------------)  + I atsugi
	0x002d0a45, // n0x0bef c0x0000 (---------------)  + I ayase
	0x002a6609, // n0x0bf0 c0x0000 (---------------)  + I chigasaki
	0x0036de45, // n0x0bf1 c0x0000 (---------------)  + I ebina
	0x00277c08, // n0x0bf2 c0x0000 (---------------)  + I fujisawa
	0x002bee06, // n0x0bf3 c0x0000 (---------------)  + I hadano
	0x00347fc6, // n0x0bf4 c0x0000 (---------------)  + I hakone
	0x0029c289, // n0x0bf5 c0x0000 (---------------)  + I hiratsuka
	0x003561c7, // n0x0bf6 c0x0000 (---------------)  + I isehara
	0x002e3b06, // n0x0bf7 c0x0000 (---------------)  + I kaisei
	0x00212c88, // n0x0bf8 c0x0000 (---------------)  + I kamakura
	0x00251908, // n0x0bf9 c0x0000 (---------------)  + I kiyokawa
	0x00311c87, // n0x0bfa c0x0000 (---------------)  + I matsuda
	0x002b3c8e, // n0x0bfb c0x0000 (---------------)  + I minamiashigara
	0x002bdbc5, // n0x0bfc c0x0000 (---------------)  + I miura
	0x00350045, // n0x0bfd c0x0000 (---------------)  + I nakai
	0x00214088, // n0x0bfe c0x0000 (---------------)  + I ninomiya
	0x0025f787, // n0x0bff c0x0000 (---------------)  + I odawara
	0x002068c2, // n0x0c00 c0x0000 (---------------)  + I oi
	0x002b40c4, // n0x0c01 c0x0000 (---------------)  + I oiso
	0x00283fca, // n0x0c02 c0x0000 (---------------)  + I sagamihara
	0x00371288, // n0x0c03 c0x0000 (---------------)  + I samukawa
	0x00273e06, // n0x0c04 c0x0000 (---------------)  + I tsukui
	0x00291c08, // n0x0c05 c0x0000 (---------------)  + I yamakita
	0x002956c6, // n0x0c06 c0x0000 (---------------)  + I yamato
	0x00302908, // n0x0c07 c0x0000 (---------------)  + I yokosuka
	0x002a9408, // n0x0c08 c0x0000 (---------------)  + I yugawara
	0x00244b44, // n0x0c09 c0x0000 (---------------)  + I zama
	0x002abfc5, // n0x0c0a c0x0000 (---------------)  + I zushi
	0x00757e04, // n0x0c0b c0x0001 (---------------)  ! I city
	0x00757e04, // n0x0c0c c0x0001 (---------------)  ! I city
	0x00757e04, // n0x0c0d c0x0001 (---------------)  ! I city
	0x00203543, // n0x0c0e c0x0000 (---------------)  + I aki
	0x00319906, // n0x0c0f c0x0000 (---------------)  + I geisei
	0x002780c6, // n0x0c10 c0x0000 (---------------)  + I hidaka
	0x00296d4c, // n0x0c11 c0x0000 (---------------)  + I higashitsuno
	0x00201b43, // n0x0c12 c0x0000 (---------------)  + I ino
	0x00280486, // n0x0c13 c0x0000 (---------------)  + I kagami
	0x0020a444, // n0x0c14 c0x0000 (---------------)  + I kami
	0x00290a88, // n0x0c15 c0x0000 (---------------)  + I kitagawa
	0x002c6385, // n0x0c16 c0x0000 (---------------)  + I kochi
	0x002840c6, // n0x0c17 c0x0000 (---------------)  + I mihara
	0x002c7e88, // n0x0c18 c0x0000 (---------------)  + I motoyama
	0x002c9686, // n0x0c19 c0x0000 (---------------)  + I muroto
	0x002a4f86, // n0x0c1a c0x0000 (---------------)  + I nahari
	0x00316bc8, // n0x0c1b c0x0000 (---------------)  + I nakamura
	0x00367c87, // n0x0c1c c0x0000 (---------------)  + I nankoku
	0x0024af09, // n0x0c1d c0x0000 (---------------)  + I nishitosa
	0x0034064a, // n0x0c1e c0x0000 (---------------)  + I niyodogawa
	0x00250884, // n0x0c1f c0x0000 (---------------)  + I ochi
	0x002519c5, // n0x0c20 c0x0000 (---------------)  + I okawa
	0x002588c5, // n0x0c21 c0x0000 (---------------)  + I otoyo
	0x002a39c6, // n0x0c22 c0x0000 (---------------)  + I otsuki
	0x00250b46, // n0x0c23 c0x0000 (---------------)  + I sakawa
	0x00296346, // n0x0c24 c0x0000 (---------------)  + I sukumo
	0x002eac86, // n0x0c25 c0x0000 (---------------)  + I susaki
	0x0024b044, // n0x0c26 c0x0000 (---------------)  + I tosa
	0x0024b04b, // n0x0c27 c0x0000 (---------------)  + I tosashimizu
	0x00243744, // n0x0c28 c0x0000 (---------------)  + I toyo
	0x0024bdc5, // n0x0c29 c0x0000 (---------------)  + I tsuno
	0x002a8a05, // n0x0c2a c0x0000 (---------------)  + I umaji
	0x002a1786, // n0x0c2b c0x0000 (---------------)  + I yasuda
	0x0020e448, // n0x0c2c c0x0000 (---------------)  + I yusuhara
	0x0027e647, // n0x0c2d c0x0000 (---------------)  + I amakusa
	0x0020d744, // n0x0c2e c0x0000 (---------------)  + I arao
	0x00212583, // n0x0c2f c0x0000 (---------------)  + I aso
	0x002cd745, // n0x0c30 c0x0000 (---------------)  + I choyo
	0x00243947, // n0x0c31 c0x0000 (---------------)  + I gyokuto
	0x0029de49, // n0x0c32 c0x0000 (---------------)  + I hitoyoshi
	0x0027e54b, // n0x0c33 c0x0000 (---------------)  + I kamiamakusa
	0x002d1b87, // n0x0c34 c0x0000 (---------------)  + I kashima
	0x00272cc7, // n0x0c35 c0x0000 (---------------)  + I kikuchi
	0x002ed184, // n0x0c36 c0x0000 (---------------)  + I kosa
	0x002c7d88, // n0x0c37 c0x0000 (---------------)  + I kumamoto
	0x002cde07, // n0x0c38 c0x0000 (---------------)  + I mashiki
	0x0028f306, // n0x0c39 c0x0000 (---------------)  + I mifune
	0x003074c8, // n0x0c3a c0x0000 (---------------)  + I minamata
	0x0028db4b, // n0x0c3b c0x0000 (---------------)  + I minamioguni
	0x002fc9c6, // n0x0c3c c0x0000 (---------------)  + I nagasu
	0x00221449, // n0x0c3d c0x0000 (---------------)  + I nishihara
	0x0028dcc5, // n0x0c3e c0x0000 (---------------)  + I oguni
	0x002b4fc3, // n0x0c3f c0x0000 (---------------)  + I ozu
	0x002af846, // n0x0c40 c0x0000 (---------------)  + I sumoto
	0x003423c8, // n0x0c41 c0x0000 (---------------)  + I takamori
	0x00201503, // n0x0c42 c0x0000 (---------------)  + I uki
	0x0022cd03, // n0x0c43 c0x0000 (---------------)  + I uto
	0x0027d306, // n0x0c44 c0x0000 (---------------)  + I yamaga
	0x002956c6, // n0x0c45 c0x0000 (---------------)  + I yamato
	0x0034dcca, // n0x0c46 c0x0000 (---------------)  + I yatsushiro
	0x00278e05, // n0x0c47 c0x0000 (---------------)  + I ayabe
	0x0027940b, // n0x0c48 c0x0000 (---------------)  + I fukuchiyama
	0x0029780b, // n0x0c49 c0x0000 (---------------)  + I higashiyama
	0x00206903, // n0x0c4a c0x0000 (---------------)  + I ide
	0x002015c3, // n0x0c4b c0x0000 (---------------)  + I ine
	0x0020a104, // n0x0c4c c0x0000 (---------------)  + I joyo
	0x003427c7, // n0x0c4d c0x0000 (---------------)  + I kameoka
	0x00256f04, // n0x0c4e c0x0000 (---------------)  + I kamo
	0x00213344, // n0x0c4f c0x0000 (---------------)  + I kita
	0x002f52c4, // n0x0c50 c0x0000 (---------------)  + I kizu
	0x0031a048, // n0x0c51 c0x0000 (---------------)  + I kumiyama
	0x00276d48, // n0x0c52 c0x0000 (---------------)  + I kyotamba
	0x0021dc09, // n0x0c53 c0x0000 (---------------)  + I kyotanabe
	0x002d8f08, // n0x0c54 c0x0000 (---------------)  + I kyotango
	0x00247387, // n0x0c55 c0x0000 (---------------)  + I maizuru
	0x0024b386, // n0x0c56 c0x0000 (---------------)  + I minami
	0x002bd1cf, // n0x0c57 c0x0000 (---------------)  + I minamiyamashiro
	0x002bdd06, // n0x0c58 c0x0000 (---------------)  + I miyazu
	0x002c6304, // n0x0c59 c0x0000 (---------------)  + I muko
	0x00276b8a, // n0x0c5a c0x0000 (---------------)  + I nagaokakyo
	0x00243847, // n0x0c5b c0x0000 (---------------)  + I nakagyo
	0x002bc086, // n0x0c5c c0x0000 (---------------)  + I nantan
	0x0028a7c9, // n0x0c5d c0x0000 (---------------)  + I oyamazaki
	0x0021db85, // n0x0c5e c0x0000 (---------------)  + I sakyo
	0x002a9a45, // n0x0c5f c0x0000 (---------------)  + I seika
	0x0021dcc6, // n0x0c60 c0x0000 (---------------)  + I tanabe
	0x00216043, // n0x0c61 c0x0000 (---------------)  + I uji
	0x0027ef09, // n0x0c62 c0x0000 (---------------)  + I ujitawara
	0x00227146, // n0x0c63 c0x0000 (---------------)  + I wazuka
	0x00342a09, // n0x0c64 c0x0000 (---------------)  + I yamashina
	0x003569c6, // n0x0c65 c0x0000 (---------------)  + I yawata
	0x002bac05, // n0x0c66 c0x0000 (---------------)  + I asahi
	0x00217ec5, // n0x0c67 c0x0000 (---------------)  + I inabe
	0x00240483, // n0x0c68 c0x0000 (---------------)  + I ise
	0x00342908, // n0x0c69 c0x0000 (---------------)  + I kameyama
	0x00250bc7, // n0x0c6a c0x0000 (---------------)  + I kawagoe
	0x00204884, // n0x0c6b c0x0000 (---------------)  + I kiho
	0x0027cb08, // n0x0c6c c0x0000 (---------------)  + I kisosaki
	0x0033f704, // n0x0c6d c0x0000 (---------------)  + I kiwa
	0x002b1d06, // n0x0c6e c0x0000 (---------------)  + I komono
	0x002d7806, // n0x0c6f c0x0000 (---------------)  + I kumano
	0x0023e1c6, // n0x0c70 c0x0000 (---------------)  + I kuwana
	0x002bb249, // n0x0c71 c0x0000 (---------------)  + I matsusaka
	0x00219485, // n0x0c72 c0x0000 (---------------)  + I meiwa
	0x00292746, // n0x0c73 c0x0000 (---------------)  + I mihama
	0x0025dec9, // n0x0c74 c0x0000 (---------------)  + I minamiise
	0x002bc346, // n0x0c75 c0x0000 (---------------)  + I misugi
	0x002bd2c6, // n0x0c76 c0x0000 (---------------)  + I miyama
	0x003515c6, // n0x0c77 c0x0000 (---------------)  + I nabari
	0x0020d8c5, // n0x0c78 c0x0000 (---------------)  + I shima
	0x002eb786, // n0x0c79 c0x0000 (---------------)  + I suzuka
	0x003679c4, // n0x0c7a c0x0000 (---------------)  + I tado
	0x00247945, // n0x0c7b c0x0000 (---------------)  + I taiki
	0x002b5304, // n0x0c7c c0x0000 (---------------)  + I taki
	0x002aa286, // n0x0c7d c0x0000 (---------------)  + I tamaki
	0x0021e984, // n0x0c7e c0x0000 (---------------)  + I toba
	0x002040c3, // n0x0c7f c0x0000 (---------------)  + I tsu
	0x00280a45, // n0x0c80 c0x0000 (---------------)  + I udono
	0x00238308, // n0x0c81 c0x0000 (---------------)  + I ureshino
	0x0034e787, // n0x0c82 c0x0000 (---------------)  + I watarai
	0x002755c9, // n0x0c83 c0x0000 (---------------)  + I yokkaichi
	0x00280c88, // n0x0c84 c0x0000 (---------------)  + I furukawa
	0x00291191, // n0x0c85 c0x0000 (---------------)  + I higashimatsushima
	0x0022db8a, // n0x0c86 c0x0000 (---------------)  + I ishinomaki
	0x002e4007, // n0x0c87 c0x0000 (---------------)  + I iwanuma
	0x002a9b06, // n0x0c88 c0x0000 (---------------)  + I kakuda
	0x0020a444, // n0x0c89 c0x0000 (---------------)  + I kami
	0x002b5408, // n0x0c8a c0x0000 (---------------)  + I kawasaki
	0x002fcb49, // n0x0c8b c0x0000 (---------------)  + I kesennuma
	0x00291548, // n0x0c8c c0x0000 (---------------)  + I marumori
	0x0029134a, // n0x0c8d c0x0000 (---------------)  + I matsushima
	0x0029654d, // n0x0c8e c0x0000 (---------------)  + I minamisanriku
	0x002625c6, // n0x0c8f c0x0000 (---------------)  + I misato
	0x00316cc6, // n0x0c90 c0x0000 (---------------)  + I murata
	0x002a4c86, // n0x0c91 c0x0000 (---------------)  + I natori
	0x0022f3c7, // n0x0c92 c0x0000 (---------------)  + I ogawara
	0x0029b505, // n0x0c93 c0x0000 (---------------)  + I ohira
	0x00237207, // n0x0c94 c0x0000 (---------------)  + I onagawa
	0x0027cbc5, // n0x0c95 c0x0000 (---------------)  + I osaki
	0x002f2f84, // n0x0c96 c0x0000 (---------------)  + I rifu
	0x002e9706, // n0x0c97 c0x0000 (---------------)  + I semine
	0x00368cc7, // n0x0c98 c0x0000 (---------------)  + I shibata
	0x0032288d, // n0x0c99 c0x0000 (---------------)  + I shichikashuku
	0x002511c7, // n0x0c9a c0x0000 (---------------)  + I shikama
	0x002c25c8, // n0x0c9b c0x0000 (---------------)  + I shiogama
	0x00277f09, // n0x0c9c c0x0000 (---------------)  + I shiroishi
	0x00352c06, // n0x0c9d c0x0000 (---------------)  + I tagajo
	0x0024cc45, // n0x0c9e c0x0000 (---------------)  + I taiwa
	0x00234844, // n0x0c9f c0x0000 (---------------)  + I tome
	0x00257346, // n0x0ca0 c0x0000 (---------------)  + I tomiya
	0x00237346, // n0x0ca1 c0x0000 (---------------)  + I wakuya
	0x00371406, // n0x0ca2 c0x0000 (---------------)  + I watari
	0x00294948, // n0x0ca3 c0x0000 (---------------)  + I yamamoto
	0x0021e583, // n0x0ca4 c0x0000 (---------------)  + I zao
	0x00201943, // n0x0ca5 c0x0000 (---------------)  + I aya
	0x00310745, // n0x0ca6 c0x0000 (---------------)  + I ebino
	0x00279e46, // n0x0ca7 c0x0000 (---------------)  + I gokase
	0x002a93c5, // n0x0ca8 c0x0000 (---------------)  + I hyuga
	0x0028a508, // n0x0ca9 c0x0000 (---------------)  + I kadogawa
	0x00295dca, // n0x0caa c0x0000 (---------------)  + I kawaminami
	0x002f7044, // n0x0cab c0x0000 (---------------)  + I kijo
	0x00290a88, // n0x0cac c0x0000 (---------------)  + I kitagawa
	0x0028a988, // n0x0cad c0x0000 (---------------)  + I kitakata
	0x002a15c7, // n0x0cae c0x0000 (---------------)  + I kitaura
	0x00238909, // n0x0caf c0x0000 (---------------)  + I kobayashi
	0x002b1e88, // n0x0cb0 c0x0000 (---------------)  + I kunitomi
	0x0027bd47, // n0x0cb1 c0x0000 (---------------)  + I kushima
	0x002f5546, // n0x0cb2 c0x0000 (---------------)  + I mimata
	0x0021418a, // n0x0cb3 c0x0000 (---------------)  + I miyakonojo
	0x002573c8, // n0x0cb4 c0x0000 (---------------)  + I miyazaki
	0x002b6209, // n0x0cb5 c0x0000 (---------------)  + I morotsuka
	0x002cf288, // n0x0cb6 c0x0000 (---------------)  + I nichinan
	0x002279c9, // n0x0cb7 c0x0000 (---------------)  + I nishimera
	0x002b6687, // n0x0cb8 c0x0000 (---------------)  + I nobeoka
	0x002741c5, // n0x0cb9 c0x0000 (---------------)  + I saito
	0x00298ec6, // n0x0cba c0x0000 (---------------)  + I shiiba
	0x002e24c8, // n0x0cbb c0x0000 (---------------)  + I shintomi
	0x0027e008, // n0x0cbc c0x0000 (---------------)  + I takaharu
	0x00342e08, // n0x0cbd c0x0000 (---------------)  + I takanabe
	0x00243288, // n0x0cbe c0x0000 (---------------)  + I takazaki
	0x0024bdc5, // n0x0cbf c0x0000 (---------------)  + I tsuno
	0x00203844, // n0x0cc0 c0x0000 (---------------)  + I achi
	0x0020d0c8, // n0x0cc1 c0x0000 (---------------)  + I agematsu
	0x00205884, // n0x0cc2 c0x0000 (---------------)  + I anan
	0x0021e5c4, // n0x0cc3 c0x0000 (---------------)  + I aoki
	0x002bac05, // n0x0cc4 c0x0000 (---------------)  + I asahi
	0x0028cb87, // n0x0cc5 c0x0000 (---------------)  + I azumino
	0x00226a09, // n0x0cc6 c0x0000 (---------------)  + I chikuhoku
	0x00272dc7, // n0x0cc7 c0x0000 (---------------)  + I chikuma
	0x00201ac5, // n0x0cc8 c0x0000 (---------------)  + I chino
	0x00274b06, // n0x0cc9 c0x0000 (---------------)  + I fujimi
	0x0034c286, // n0x0cca c0x0000 (---------------)  + I hakuba
	0x00200a04, // n0x0ccb c0x0000 (---------------)  + I hara
	0x0029c5c6, // n0x0ccc c0x0000 (---------------)  + I hiraya
	0x0028c144, // n0x0ccd c0x0000 (---------------)  + I iida
	0x0028b546, // n0x0cce c0x0000 (---------------)  + I iijima
	0x00202ac6, // n0x0ccf c0x0000 (---------------)  + I iiyama
	0x00223846, // n0x0cd0 c0x0000 (---------------)  + I iizuna
	0x002024c5, // n0x0cd1 c0x0000 (---------------)  + I ikeda
	0x0028a3c7, // n0x0cd2 c0x0000 (---------------)  + I ikusaka
	0x0020cd43, // n0x0cd3 c0x0000 (---------------)  + I ina
	0x00310989, // n0x0cd4 c0x0000 (---------------)  + I karuizawa
	0x002e3808, // n0x0cd5 c0x0000 (---------------)  + I kawakami
	0x0027bbc4, // n0x0cd6 c0x0000 (---------------)  + I kiso
	0x0027bbcd, // n0x0cd7 c0x0000 (---------------)  + I kisofukushima
	0x0028ff08, // n0x0cd8 c0x0000 (---------------)  + I kitaaiki
	0x002dcc08, // n0x0cd9 c0x0000 (---------------)  + I komagane
	0x002b6186, // n0x0cda c0x0000 (---------------)  + I komoro
	0x00257e09, // n0x0cdb c0x0000 (---------------)  + I matsukawa
	0x002af789, // n0x0cdc c0x0000 (---------------)  + I matsumoto
	0x0030f7c5, // n0x0cdd c0x0000 (---------------)  + I miasa
	0x00295eca, // n0x0cde c0x0000 (---------------)  + I minamiaiki
	0x0031c50a, // n0x0cdf c0x0000 (---------------)  + I minamimaki
	0x00286a0c, // n0x0ce0 c0x0000 (---------------)  + I minamiminowa
	0x00286b86, // n0x0ce1 c0x0000 (---------------)  + I minowa
	0x00274fc6, // n0x0ce2 c0x0000 (---------------)  + I miyada
	0x002be786, // n0x0ce3 c0x0000 (---------------)  + I miyota
	0x0033a809, // n0x0ce4 c0x0000 (---------------)  + I mochizuki
	0x0020d586, // n0x0ce5 c0x0000 (---------------)  + I nagano
	0x00237246, // n0x0ce6 c0x0000 (---------------)  + I nagawa
	0x0036df06, // n0x0ce7 c0x0000 (---------------)  + I nagiso
	0x0029bf08, // n0x0ce8 c0x0000 (---------------)  + I nakagawa
	0x002501c6, // n0x0ce9 c0x0000 (---------------)  + I nakano
	0x0029d60b, // n0x0cea c0x0000 (---------------)  + I nozawaonsen
	0x0028cd05, // n0x0ceb c0x0000 (---------------)  + I obuse
	0x0022f3c5, // n0x0cec c0x0000 (---------------)  + I ogawa
	0x00275245, // n0x0ced c0x0000 (---------------)  + I okaya
	0x00284e06, // n0x0cee c0x0000 (---------------)  + I omachi
	0x00214143, // n0x0cef c0x0000 (---------------)  + I omi
	0x0023e146, // n0x0cf0 c0x0000 (---------------)  + I ookuwa
	0x00251147, // n0x0cf1 c0x0000 (---------------)  + I ooshika
	0x002b52c5, // n0x0cf2 c0x0000 (---------------)  + I otaki
	0x00255b45, // n0x0cf3 c0x0000 (---------------)  + I otari
	0x002eec85, // n0x0cf4 c0x0000 (---------------)  + I sakae
	0x003032c6, // n0x0cf5 c0x0000 (---------------)  + I sakaki
	0x00219884, // n0x0cf6 c0x0000 (---------------)  + I saku
	0x00219886, // n0x0cf7 c0x0000 (---------------)  + I sakuho
	0x002c73c9, // n0x0cf8 c0x0000 (---------------)  + I shimosuwa
	0x00284c8c, // n0x0cf9 c0x0000 (---------------)  + I shinanomachi
	0x002f2cc8, // n0x0cfa c0x0000 (---------------)  + I shiojiri
	0x002c7504, // n0x0cfb c0x0000 (---------------)  + I suwa
	0x002eb546, // n0x0cfc c0x0000 (---------------)  + I suzaka
	0x00290386, // n0x0cfd c0x0000 (---------------)  + I takagi
	0x003423c8, // n0x0cfe c0x0000 (---------------)  + I takamori
	0x002e41c8, // n0x0cff c0x0000 (---------------)  + I takayama
	0x00284b89, // n0x0d00 c0x0000 (---------------)  + I tateshina
	0x002662c7, // n0x0d01 c0x0000 (---------------)  + I tatsuno
	0x0029f809, // n0x0d02 c0x0000 (---------------)  + I togakushi
	0x00316e86, // n0x0d03 c0x0000 (---------------)  + I togura
	0x0022a504, // n0x0d04 c0x0000 (---------------)  + I tomi
	0x0021df44, // n0x0d05 c0x0000 (---------------)  + I ueda
	0x0027b7c4, // n0x0d06 c0x0000 (---------------)  + I wada
	0x0027d308, // n0x0d07 c0x0000 (---------------)  + I yamagata
	0x0022684a, // n0x0d08 c0x0000 (---------------)  + I yamanouchi
	0x0032db06, // n0x0d09 c0x0000 (---------------)  + I yasaka
	0x00332b87, // n0x0d0a c0x0000 (---------------)  + I yasuoka
	0x0022ea47, // n0x0d0b c0x0000 (---------------)  + I chijiwa
	0x0024bd45, // n0x0d0c c0x0000 (---------------)  + I futsu
	0x002d8b44, // n0x0d0d c0x0000 (---------------)  + I goto
	0x002888c6, // n0x0d0e c0x0000 (---------------)  + I hasami
	0x003588c6, // n0x0d0f c0x0000 (---------------)  + I hirado
	0x00204843, // n0x0d10 c0x0000 (---------------)  + I iki
	0x002e3647, // n0x0d11 c0x0000 (---------------)  + I isahaya
	0x0026a748, // n0x0d12 c0x0000 (---------------)  + I kawatana
	0x0030f90a, // n0x0d13 c0x0000 (---------------)  + I kuchinotsu
	0x002c2d08, // n0x0d14 c0x0000 (---------------)  + I matsuura
	0x00299248, // n0x0d15 c0x0000 (---------------)  + I nagasaki
	0x0021e9c5, // n0x0d16 c0x0000 (---------------)  + I obama
	0x00214505, // n0x0d17 c0x0000 (---------------)  + I omura
	0x0029f745, // n0x0d18 c0x0000 (---------------)  + I oseto
	0x0024c106, // n0x0d19 c0x0000 (---------------)  + I saikai
	0x00253246, // n0x0d1a c0x0000 (---------------)  + I sasebo
	0x002d3205, // n0x0d1b c0x0000 (---------------)  + I seihi
	0x0036ab89, // n0x0d1c c0x0000 (---------------)  + I shimabara
	0x002d894c, // n0x0d1d c0x0000 (---------------)  + I shinkamigoto
	0x00300487, // n0x0d1e c0x0000 (---------------)  + I togitsu
	0x002913c8, // n0x0d1f c0x0000 (---------------)  + I tsushima
	0x0027e1c5, // n0x0d20 c0x0000 (---------------)  + I unzen
	0x00757e04, // n0x0d21 c0x0001 (---------------)  ! I city
	0x00330604, // n0x0d22 c0x0000 (---------------)  + I ando
	0x00206cc4, // n0x0d23 c0x0000 (---------------)  + I gose
	0x003693c6, // n0x0d24 c0x0000 (---------------)  + I heguri
	0x0029838e, // n0x0d25 c0x0000 (---------------)  + I higashiyoshino
	0x0020c607, // n0x0d26 c0x0000 (---------------)  + I ikaruga
	0x0022f5c5, // n0x0d27 c0x0000 (---------------)  + I ikoma
	0x002954cc, // n0x0d28 c0x0000 (---------------)  + I kamikitayama
	0x0031b7c7, // n0x0d29 c0x0000 (---------------)  + I kanmaki
	0x00368c47, // n0x0d2a c0x0000 (---------------)  + I kashiba
	0x002008c9, // n0x0d2b c0x0000 (---------------)  + I kashihara
	0x00226589, // n0x0d2c c0x0000 (---------------)  + I katsuragi
	0x00254bc5, // n0x0d2d c0x0000 (---------------)  + I kawai
	0x002e3808, // n0x0d2e c0x0000 (---------------)  + I kawakami
	0x002b6949, // n0x0d2f c0x0000 (---------------)  + I kawanishi
	0x002e9085, // n0x0d30 c0x0000 (---------------)  + I koryo
	0x002b5208, // n0x0d31 c0x0000 (---------------)  + I kurotaki
	0x002c6186, // n0x0d32 c0x0000 (---------------)  + I mitsue
	0x002de7c6, // n0x0d33 c0x0000 (---------------)  + I miyake
	0x00268e84, // n0x0d34 c0x0000 (---------------)  + I nara
	0x0026c8c8, // n0x0d35 c0x0000 (---------------)  + I nosegawa
	0x00257b83, // n0x0d36 c0x0000 (---------------)  + I oji
	0x00287704, // n0x0d37 c0x0000 (---------------)  + I ouda
	0x002cd7c5, // n0x0d38 c0x0000 (---------------)  + I oyodo
	0x0021c3c7, // n0x0d39 c0x0000 (---------------)  + I sakurai
	0x00224185, // n0x0d3a c0x0000 (---------------)  + I sango
	0x0030c6c9, // n0x0d3b c0x0000 (---------------)  + I shimoichi
	0x002bf8cd, // n0x0d3c c0x0000 (---------------)  + I shimokitayama
	0x002d2246, // n0x0d3d c0x0000 (---------------)  + I shinjo
	0x0024d8c4, // n0x0d3e c0x0000 (---------------)  + I soni
	0x00224ec8, // n0x0d3f c0x0000 (---------------)  + I takatori
	0x00206f8a, // n0x0d40 c0x0000 (---------------)  + I tawaramoto
	0x00209587, // n0x0d41 c0x0000 (---------------)  + I tenkawa
	0x002f4f05, // n0x0d42 c0x0000 (---------------)  + I tenri
	0x00265803, // n0x0d43 c0x0000 (---------------)  + I uda
	0x002979ce, // n0x0d44 c0x0000 (---------------)  + I yamatokoriyama
	0x002956cc, // n0x0d45 c0x0000 (---------------)  + I yamatotakada
	0x00229347, // n0x0d46 c0x0000 (---------------)  + I yamazoe
	0x00298547, // n0x0d47 c0x0000 (---------------)  + I yoshino
	0x00200483, // n0x0d48 c0x0000 (---------------)  + I aga
	0x0020d5c5, // n0x0d49 c0x0000 (---------------)  + I agano
	0x00206cc5, // n0x0d4a c0x0000 (---------------)  + I gosen
	0x00291fc8, // n0x0d4b c0x0000 (---------------)  + I itoigawa
	0x0028f049, // n0x0d4c c0x0000 (---------------)  + I izumozaki
	0x00374e86, // n0x0d4d c0x0000 (---------------)  + I joetsu
	0x00256f04, // n0x0d4e c0x0000 (---------------)  + I kamo
	0x002e3f46, // n0x0d4f c0x0000 (---------------)  + I kariwa
	0x0020334b, // n0x0d50 c0x0000 (---------------)  + I kashiwazaki
	0x002af50c, // n0x0d51 c0x0000 (---------------)  + I minamiuonuma
	0x0027b287, // n0x0d52 c0x0000 (---------------)  + I mitsuke
	0x002c6045, // n0x0d53 c0x0000 (---------------)  + I muika
	0x002854c8, // n0x0d54 c0x0000 (---------------)  + I murakami
	0x00311a45, // n0x0d55 c0x0000 (---------------)  + I myoko
	0x00276b87, // n0x0d56 c0x0000 (---------------)  + I nagaoka
	0x00290607, // n0x0d57 c0x0000 (---------------)  + I niigata
	0x00257b85, // n0x0d58 c0x0000 (---------------)  + I ojiya
	0x00214143, // n0x0d59 c0x0000 (---------------)  + I omi
	0x002a4e44, // n0x0d5a c0x0000 (---------------)  + I sado
	0x00248105, // n0x0d5b c0x0000 (---------------)  + I sanjo
	0x003199c5, // n0x0d5c c0x0000 (---------------)  + I seiro
	0x003199c6, // n0x0d5d c0x0000 (---------------)  + I seirou
	0x002c49c8, // n0x0d5e c0x0000 (---------------)  + I sekikawa
	0x00368cc7, // n0x0d5f c0x0000 (---------------)  + I shibata
	0x00343d86, // n0x0d60 c0x0000 (---------------)  + I tagami
	0x00237606, // n0x0d61 c0x0000 (---------------)  + I tainai
	0x00345486, // n0x0d62 c0x0000 (---------------)  + I tochio
	0x00203709, // n0x0d63 c0x0000 (---------------)  + I tokamachi
	0x0025f087, // n0x0d64 c0x0000 (---------------)  + I tsubame
	0x00374d06, // n0x0d65 c0x0000 (---------------)  + I tsunan
	0x002af686, // n0x0d66 c0x0000 (---------------)  + I uonuma
	0x00272906, // n0x0d67 c0x0000 (---------------)  + I yahiko
	0x0020a185, // n0x0d68 c0x0000 (---------------)  + I yoita
	0x00263246, // n0x0d69 c0x0000 (---------------)  + I yuzawa
	0x00200e85, // n0x0d6a c0x0000 (---------------)  + I beppu
	0x002de408, // n0x0d6b c0x0000 (---------------)  + I bungoono
	0x0028bd8b, // n0x0d6c c0x0000 (---------------)  + I bungotakada
	0x002886c6, // n0x0d6d c0x0000 (---------------)  + I hasama
	0x0022ea84, // n0x0d6e c0x0000 (---------------)  + I hiji
	0x002d98c9, // n0x0d6f c0x0000 (---------------)  + I himeshima
	0x0029bd44, // n0x0d70 c0x0000 (---------------)  + I hita
	0x002c6108, // n0x0d71 c0x0000 (---------------)  + I kamitsue
	0x0028c987, // n0x0d72 c0x0000 (---------------)  + I kokonoe
	0x00322b44, // n0x0d73 c0x0000 (---------------)  + I kuju
	0x002b0ec8, // n0x0d74 c0x0000 (---------------)  + I kunisaki
	0x002b7684, // n0x0d75 c0x0000 (---------------)  + I kusu
	0x0020a1c4, // n0x0d76 c0x0000 (---------------)  + I oita
	0x002b8145, // n0x0d77 c0x0000 (---------------)  + I saiki
	0x002d1a06, // n0x0d78 c0x0000 (---------------)  + I taketa
	0x00319f87, // n0x0d79 c0x0000 (---------------)  + I tsukumi
	0x00220203, // n0x0d7a c0x0000 (---------------)  + I usa
	0x00297445, // n0x0d7b c0x0000 (---------------)  + I usuki
	0x00364844, // n0x0d7c c0x0000 (---------------)  + I yufu
	0x00350086, // n0x0d7d c0x0000 (---------------)  + I akaiwa
	0x0030f848, // n0x0d7e c0x0000 (---------------)  + I asakuchi
	0x00314c45, // n0x0d7f c0x0000 (---------------)  + I bizen
	0x0028ba49, // n0x0d80 c0x0000 (---------------)  + I hayashima
	0x002ca685, // n0x0d81 c0x0000 (---------------)  + I ibara
	0x00280488, // n0x0d82 c0x0000 (---------------)  + I kagamino
	0x0035e687, // n0x0d83 c0x0000 (---------------)  + I kasaoka
	0x002b4e08, // n0x0d84 c0x0000 (---------------)  + I kibichuo
	0x002b0587, // n0x0d85 c0x0000 (---------------)  + I kumenan
	0x002f2509, // n0x0d86 c0x0000 (---------------)  + I kurashiki
	0x00266e86, // n0x0d87 c0x0000 (---------------)  + I maniwa
	0x002dc5c6, // n0x0d88 c0x0000 (---------------)  + I misaki
	0x002c3c84, // n0x0d89 c0x0000 (---------------)  + I nagi
	0x00293e05, // n0x0d8a c0x0000 (---------------)  + I niimi
	0x002164cc, // n0x0d8b c0x0000 (---------------)  + I nishiawakura
	0x00275247, // n0x0d8c c0x0000 (---------------)  + I okayama
	0x00276187, // n0x0d8d c0x0000 (---------------)  + I satosho
	0x0022e908, // n0x0d8e c0x0000 (---------------)  + I setouchi
	0x002d2246, // n0x0d8f c0x0000 (---------------)  + I shinjo
	0x0029b444, // n0x0d90 c0x0000 (---------------)  + I shoo
	0x0033e544, // n0x0d91 c0x0000 (---------------)  + I soja
	0x00290749, // n0x0d92 c0x0000 (---------------)  + I takahashi
	0x002be886, // n0x0d93 c0x0000 (---------------)  + I tamano
	0x00291b47, // n0x0d94 c0x0000 (---------------)  + I tsuyama
	0x002e7c44, // n0x0d95 c0x0000 (---------------)  + I wake
	0x0029c6c6, // n0x0d96 c0x0000 (---------------)  + I yakage
	0x00368845, // n0x0d97 c0x0000 (---------------)  + I aguni
	0x00290487, // n0x0d98 c0x0000 (---------------)  + I ginowan
	0x0029d586, // n0x0d99 c0x0000 (---------------)  + I ginoza
	0x00249b09, // n0x0d9a c0x0000 (---------------)  + I gushikami
	0x0031c347, // n0x0d9b c0x0000 (---------------)  + I haebaru
	0x00263ec7, // n0x0d9c c0x0000 (---------------)  + I higashi
	0x0029c106, // n0x0d9d c0x0000 (---------------)  + I hirara
	0x00369505, // n0x0d9e c0x0000 (---------------)  + I iheya
	0x0027ba48, // n0x0d9f c0x0000 (---------------)  + I ishigaki
	0x00226fc8, // n0x0da0 c0x0000 (---------------)  + I ishikawa
	0x00334986, // n0x0da1 c0x0000 (---------------)  + I itoman
	0x00314c85, // n0x0da2 c0x0000 (---------------)  + I izena
	0x00276846, // n0x0da3 c0x0000 (---------------)  + I kadena
	0x00214ac3, // n0x0da4 c0x0000 (---------------)  + I kin
	0x00291e49, // n0x0da5 c0x0000 (---------------)  + I kitadaito
	0x002960ce, // n0x0da6 c0x0000 (---------------)  + I kitanakagusuku
	0x002afd48, // n0x0da7 c0x0000 (---------------)  + I kumejima
	0x0033f808, // n0x0da8 c0x0000 (---------------)  + I kunigami
	0x0033478b, // n0x0da9 c0x0000 (---------------)  + I minamidaito
	0x0028bc86, // n0x0daa c0x0000 (---------------)  + I motobu
	0x002507c4, // n0x0dab c0x0000 (---------------)  + I nago
	0x0027e384, // n0x0dac c0x0000 (---------------)  + I naha
	0x002961ca, // n0x0dad c0x0000 (---------------)  + I nakagusuku
	0x002137c7, // n0x0dae c0x0000 (---------------)  + I nakijin
	0x00374dc5, // n0x0daf c0x0000 (---------------)  + I nanjo
	0x00221449, // n0x0db0 c0x0000 (---------------)  + I nishihara
	0x002b3bc5, // n0x0db1 c0x0000 (---------------)  + I ogimi
	0x0021e607, // n0x0db2 c0x0000 (---------------)  + I okinawa
	0x0022ae44, // n0x0db3 c0x0000 (---------------)  + I onna
	0x002ad107, // n0x0db4 c0x0000 (---------------)  + I shimoji
	0x00262448, // n0x0db5 c0x0000 (---------------)  + I taketomi
	0x002dcec6, // n0x0db6 c0x0000 (---------------)  + I tarama
	0x002fdc49, // n0x0db7 c0x0000 (---------------)  + I tokashiki
	0x002b1f8a, // n0x0db8 c0x0000 (---------------)  + I tomigusuku
	0x00213746, // n0x0db9 c0x0000 (---------------)  + I tonaki
	0x0028fa46, // n0x0dba c0x0000 (---------------)  + I urasoe
	0x002a8985, // n0x0dbb c0x0000 (---------------)  + I uruma
	0x0034af45, // n0x0dbc c0x0000 (---------------)  + I yaese
	0x002e7187, // n0x0dbd c0x0000 (---------------)  + I yomitan
	0x00301fc8, // n0x0dbe c0x0000 (---------------)  + I yonabaru
	0x00368788, // n0x0dbf c0x0000 (---------------)  + I yonaguni
	0x00244b46, // n0x0dc0 c0x0000 (---------------)  + I zamami
	0x002ec1c5, // n0x0dc1 c0x0000 (---------------)  + I abeno
	0x002508ce, // n0x0dc2 c0x0000 (---------------)  + I chihayaakasaka
	0x002606c4, // n0x0dc3 c0x0000 (---------------)  + I chuo
	0x00291f45, // n0x0dc4 c0x0000 (---------------)  + I daito
	0x00274489, // n0x0dc5 c0x0000 (---------------)  + I fujiidera
	0x002549c8, // n0x0dc6 c0x0000 (---------------)  + I habikino
	0x00286006, // n0x0dc7 c0x0000 (---------------)  + I hannan
	0x002945cc, // n0x0dc8 c0x0000 (---------------)  + I higashiosaka
	0x002959d0, // n0x0dc9 c0x0000 (---------------)  + I higashisumiyoshi
	0x00297fcf, // n0x0dca c0x0000 (---------------)  + I higashiyodogawa
	0x0029b548, // n0x0dcb c0x0000 (---------------)  + I hirakata
	0x0032cd07, // n0x0dcc c0x0000 (---------------)  + I ibaraki
	0x002024c5, // n0x0dcd c0x0000 (---------------)  + I ikeda
	0x00264305, // n0x0dce c0x0000 (---------------)  + I izumi
	0x00319e09, // n0x0dcf c0x0000 (---------------)  + I izumiotsu
	0x0032d049, // n0x0dd0 c0x0000 (---------------)  + I izumisano
	0x0023ca46, // n0x0dd1 c0x0000 (---------------)  + I kadoma
	0x002f8947, // n0x0dd2 c0x0000 (---------------)  + I kaizuka
	0x00205845, // n0x0dd3 c0x0000 (---------------)  + I kanan
	0x00202249, // n0x0dd4 c0x0000 (---------------)  + I kashiwara
	0x0032f846, // n0x0dd5 c0x0000 (---------------)  + I katano
	0x0020d3cd, // n0x0dd6 c0x0000 (---------------)  + I kawachinagano
	0x0027b689, // n0x0dd7 c0x0000 (---------------)  + I kishiwada
	0x00213344, // n0x0dd8 c0x0000 (---------------)  + I kita
	0x002afac8, // n0x0dd9 c0x0000 (---------------)  + I kumatori
	0x0020d189, // n0x0dda c0x0000 (---------------)  + I matsubara
	0x0032dcc6, // n0x0ddb c0x0000 (---------------)  + I minato
	0x00274c05, // n0x0ddc c0x0000 (---------------)  + I minoh
	0x002dc5c6, // n0x0ddd c0x0000 (---------------)  + I misaki
	0x002c5089, // n0x0dde c0x0000 (---------------)  + I moriguchi
	0x002cff88, // n0x0ddf c0x0000 (---------------)  + I neyagawa
	0x002164c5, // n0x0de0 c0x0000 (---------------)  + I nishi
	0x0026c8c4, // n0x0de1 c0x0000 (---------------)  + I nose
	0x0029478b, // n0x0de2 c0x0000 (---------------)  + I osakasayama
	0x0032db85, // n0x0de3 c0x0000 (---------------)  + I sakai
	0x00252846, // n0x0de4 c0x0000 (---------------)  + I sayama
	0x002c66c6, // n0x0de5 c0x0000 (---------------)  + I sennan
	0x002a6a46, // n0x0de6 c0x0000 (---------------)  + I settsu
	0x00238a8b, // n0x0de7 c0x0000 (---------------)  + I shijonawate
	0x0028bb49, // n0x0de8 c0x0000 (---------------)  + I shimamoto
	0x00309a05, // n0x0de9 c0x0000 (---------------)  + I suita
	0x00258e07, // n0x0dea c0x0000 (---------------)  + I tadaoka
	0x0022db06, // n0x0deb c0x0000 (---------------)  + I taishi
	0x0027ce06, // n0x0dec c0x0000 (---------------)  + I tajiri
	0x002a3dc8, // n0x0ded c0x0000 (---------------)  + I takaishi
	0x00341b49, // n0x0dee c0x0000 (---------------)  + I takatsuki
	0x002c238c, // n0x0def c0x0000 (---------------)  + I tondabayashi
	0x00243748, // n0x0df0 c0x0000 (---------------)  + I toyonaka
	0x002492c6, // n0x0df1 c0x0000 (---------------)  + I toyono
	0x00324903, // n0x0df2 c0x0000 (---------------)  + I yao
	0x0028e746, // n0x0df3 c0x0000 (---------------)  + I ariake
	0x00298d05, // n0x0df4 c0x0000 (---------------)  + I arita
	0x00279748, // n0x0df5 c0x0000 (---------------)  + I fukudomi
	0x00220986, // n0x0df6 c0x0000 (---------------)  + I genkai
	0x0020a6c8, // n0x0df7 c0x0000 (---------------)  + I hamatama
	0x00253b85, // n0x0df8 c0x0000 (---------------)  + I hizen
	0x0033de85, // n0x0df9 c0x0000 (---------------)  + I imari
	0x0035e908, // n0x0dfa c0x0000 (---------------)  + I kamimine
	0x002517c7, // n0x0dfb c0x0000 (---------------)  + I kanzaki
	0x003439c7, // n0x0dfc c0x0000 (---------------)  + I karatsu
	0x002d1b87, // n0x0dfd c0x0000 (---------------)  + I kashima
	0x0027cc88, // n0x0dfe c0x0000 (---------------)  + I kitagata
	0x002a3ac8, // n0x0dff c0x0000 (---------------)  + I kitahata
	0x00260386, // n0x0e00 c0x0000 (---------------)  + I kiyama
	0x002aa0c7, // n0x0e01 c0x0000 (---------------)  + I kouhoku
	0x00279b47, // n0x0e02 c0x0000 (---------------)  + I kyuragi
	0x00298bca, // n0x0e03 c0x0000 (---------------)  + I nishiarita
	0x0024ba83, // n0x0e04 c0x0000 (---------------)  + I ogi
	0x00284e06, // n0x0e05 c0x0000 (---------------)  + I omachi
	0x00226985, // n0x0e06 c0x0000 (---------------)  + I ouchi
	0x00283fc4, // n0x0e07 c0x0000 (---------------)  + I saga
	0x00277f09, // n0x0e08 c0x0000 (---------------)  + I shiroishi
	0x002f2484, // n0x0e09 c0x0000 (---------------)  + I taku
	0x002ac844, // n0x0e0a c0x0000 (---------------)  + I tara
	0x00290204, // n0x0e0b c0x0000 (---------------)  + I tosu
	0x0029854b, // n0x0e0c c0x0000 (---------------)  + I yoshinogari
	0x0020d307, // n0x0e0d c0x0000 (---------------)  + I arakawa
	0x00250b05, // n0x0e0e c0x0000 (---------------)  + I asaka
	0x0028e188, // n0x0e0f c0x0000 (---------------)  + I chichibu
	0x00274b06, // n0x0e10 c0x0000 (---------------)  + I fujimi
	0x00274b08, // n0x0e11 c0x0000 (---------------)  + I fujimino
	0x00278d46, // n0x0e12 c0x0000 (---------------)  + I fukaya
	0x002864c5, // n0x0e13 c0x0000 (---------------)  + I hanno
	0x00286d05, // n0x0e14 c0x0000 (---------------)  + I hanyu
	0x002893c6, // n0x0e15 c0x0000 (---------------)  + I hasuda
	0x00289dc8, // n0x0e16 c0x0000 (---------------)  + I hatogaya
	0x0028a708, // n0x0e17 c0x0000 (---------------)  + I hatoyama
	0x002780c6, // n0x0e18 c0x0000 (---------------)  + I hidaka
	0x0028dfcf, // n0x0e19 c0x0000 (---------------)  + I higashichichibu
	0x00291910, // n0x0e1a c0x0000 (---------------)  + I higashimatsuyama
	0x0020a045, // n0x0e1b c0x0000 (---------------)  + I honjo
	0x0020cd43, // n0x0e1c c0x0000 (---------------)  + I ina
	0x00287005, // n0x0e1d c0x0000 (---------------)  + I iruma
	0x002a9608, // n0x0e1e c0x0000 (---------------)  + I iwatsuki
	0x0032cf49, // n0x0e1f c0x0000 (---------------)  + I kamiizumi
	0x00212748, // n0x0e20 c0x0000 (---------------)  + I kamikawa
	0x0032df48, // n0x0e21 c0x0000 (---------------)  + I kamisato
	0x00207548, // n0x0e22 c0x0000 (---------------)  + I kasukabe
	0x00250bc7, // n0x0e23 c0x0000 (---------------)  + I kawagoe
	0x002747c9, // n0x0e24 c0x0000 (---------------)  + I kawaguchi
	0x0020a8c8, // n0x0e25 c0x0000 (---------------)  + I kawajima
	0x00235ac4, // n0x0e26 c0x0000 (---------------)  + I kazo
	0x00290088, // n0x0e27 c0x0000 (---------------)  + I kitamoto
	0x002b4b49, // n0x0e28 c0x0000 (---------------)  + I koshigaya
	0x002aae87, // n0x0e29 c0x0000 (---------------)  + I kounosu
	0x002b2184, // n0x0e2a c0x0000 (---------------)  + I kuki
	0x00272e88, // n0x0e2b c0x0000 (---------------)  + I kumagaya
	0x0028a18a, // n0x0e2c c0x0000 (---------------)  + I matsubushi
	0x002c1a86, // n0x0e2d c0x0000 (---------------)  + I minano
	0x002625c6, // n0x0e2e c0x0000 (---------------)  + I misato
	0x00228309, // n0x0e2f c0x0000 (---------------)  + I miyashiro
	0x00295c07, // n0x0e30 c0x0000 (---------------)  + I miyoshi
	0x002c2b88, // n0x0e31 c0x0000 (---------------)  + I moroyama
	0x00201108, // n0x0e32 c0x0000 (---------------)  + I nagatoro
	0x0025ec88, // n0x0e33 c0x0000 (---------------)  + I namegawa
	0x0020f7c5, // n0x0e34 c0x0000 (---------------)  + I niiza
	0x0034bac5, // n0x0e35 c0x0000 (---------------)  + I ogano
	0x0022f3c5, // n0x0e36 c0x0000 (---------------)  + I ogawa
	0x00206c85, // n0x0e37 c0x0000 (---------------)  + I ogose
	0x002f5c47, // n0x0e38 c0x0000 (---------------)  + I okegawa
	0x00214145, // n0x0e39 c0x0000 (---------------)  + I omiya
	0x002b52c5, // n0x0e3a c0x0000 (---------------)  + I otaki
	0x00216386, // n0x0e3b c0x0000 (---------------)  + I ranzan
	0x00212687, // n0x0e3c c0x0000 (---------------)  + I ryokami
	0x00357207, // n0x0e3d c0x0000 (---------------)  + I saitama
	0x0028a486, // n0x0e3e c0x0000 (---------------)  + I sakado
	0x002c90c5, // n0x0e3f c0x0000 (---------------)  + I satte
	0x00252846, // n0x0e40 c0x0000 (---------------)  + I sayama
	0x00256cc5, // n0x0e41 c0x0000 (---------------)  + I shiki
	0x0031ef48, // n0x0e42 c0x0000 (---------------)  + I shiraoka
	0x0031a984, // n0x0e43 c0x0000 (---------------)  + I soka
	0x002bc3c6, // n0x0e44 c0x0000 (---------------)  + I sugito
	0x00209e44, // n0x0e45 c0x0000 (---------------)  + I toda
	0x00221c48, // n0x0e46 c0x0000 (---------------)  + I tokigawa
	0x00353f8a, // n0x0e47 c0x0000 (---------------)  + I tokorozawa
	0x0028288c, // n0x0e48 c0x0000 (---------------)  + I tsurugashima
	0x00207f05, // n0x0e49 c0x0000 (---------------)  + I urawa
	0x00202386, // n0x0e4a c0x0000 (---------------)  + I warabi
	0x002c2546, // n0x0e4b c0x0000 (---------------)  + I yashio
	0x0036dd06, // n0x0e4c c0x0000 (---------------)  + I yokoze
	0x00249344, // n0x0e4d c0x0000 (---------------)  + I yono
	0x00368b05, // n0x0e4e c0x0000 (---------------)  + I yorii
	0x00278b87, // n0x0e4f c0x0000 (---------------)  + I yoshida
	0x00295c89, // n0x0e50 c0x0000 (---------------)  + I yoshikawa
	0x0029df47, // n0x0e51 c0x0000 (---------------)  + I yoshimi
	0x00757e04, // n0x0e52 c0x0001 (---------------)  ! I city
	0x00757e04, // n0x0e53 c0x0001 (---------------)  ! I city
	0x002b4505, // n0x0e54 c0x0000 (---------------)  + I aisho
	0x00349a04, // n0x0e55 c0x0000 (---------------)  + I gamo
	0x002934ca, // n0x0e56 c0x0000 (---------------)  + I higashiomi
	0x00274986, // n0x0e57 c0x0000 (---------------)  + I hikone
	0x0032dec4, // n0x0e58 c0x0000 (---------------)  + I koka
	0x002bc005, // n0x0e59 c0x0000 (---------------)  + I konan
	0x002f1705, // n0x0e5a c0x0000 (---------------)  + I kosei
	0x003587c4, // n0x0e5b c0x0000 (---------------)  + I koto
	0x0027e707, // n0x0e5c c0x0000 (---------------)  + I kusatsu
	0x002ca607, // n0x0e5d c0x0000 (---------------)  + I maibara
	0x002c1c08, // n0x0e5e c0x0000 (---------------)  + I moriyama
	0x00299d88, // n0x0e5f c0x0000 (---------------)  + I nagahama
	0x00217749, // n0x0e60 c0x0000 (---------------)  + I nishiazai
	0x0032f948, // n0x0e61 c0x0000 (---------------)  + I notogawa
	0x0029368b, // n0x0e62 c0x0000 (---------------)  + I omihachiman
	0x002589c4, // n0x0e63 c0x0000 (---------------)  + I otsu
	0x003003c5, // n0x0e64 c0x0000 (---------------)  + I ritto
	0x002590c5, // n0x0e65 c0x0000 (---------------)  + I ryuoh
	0x002d1b09, // n0x0e66 c0x0000 (---------------)  + I takashima
	0x00341b49, // n0x0e67 c0x0000 (---------------)  + I takatsuki
	0x002d97c8, // n0x0e68 c0x0000 (---------------)  + I torahime
	0x00253408, // n0x0e69 c0x0000 (---------------)  + I toyosato
	0x002a1784, // n0x0e6a c0x0000 (---------------)  + I yasu
	0x002903c5, // n0x0e6b c0x0000 (---------------)  + I akagi
	0x00200283, // n0x0e6c c0x0000 (---------------)  + I ama
	0x002a3985, // n0x0e6d c0x0000 (---------------)  + I gotsu
	0x002927c6, // n0x0e6e c0x0000 (---------------)  + I hamada
	0x0028ee8c, // n0x0e6f c0x0000 (---------------)  + I higashiizumo
	0x00227046, // n0x0e70 c0x0000 (---------------)  + I hikawa
	0x00256d06, // n0x0e71 c0x0000 (---------------)  + I hikimi
	0x00286285, // n0x0e72 c0x0000 (---------------)  + I izumo
	0x00303348, // n0x0e73 c0x0000 (---------------)  + I kakinoki
	0x002ac106, // n0x0e74 c0x0000 (---------------)  + I masuda
	0x002a9c86, // n0x0e75 c0x0000 (---------------)  + I matsue
	0x002625c6, // n0x0e76 c0x0000 (---------------)  + I misato
	0x0022b3cc, // n0x0e77 c0x0000 (---------------)  + I nishinoshima
	0x0026c444, // n0x0e78 c0x0000 (---------------)  + I ohda
	0x003455ca, // n0x0e79 c0x0000 (---------------)  + I okinoshima
	0x002861c8, // n0x0e7a c0x0000 (---------------)  + I okuizumo
	0x0028ecc7, // n0x0e7b c0x0000 (---------------)  + I shimane
	0x00364746, // n0x0e7c c0x0000 (---------------)  + I tamayu
	0x002d2ec7, // n0x0e7d c0x0000 (---------------)  + I tsuwano
	0x002d6e85, // n0x0e7e c0x0000 (---------------)  + I unnan
	0x003695c6, // n0x0e7f c0x0000 (---------------)  + I yakumo
	0x00330a06, // n0x0e80 c0x0000 (---------------)  + I yasugi
	0x00343887, // n0x0e81 c0x0000 (---------------)  + I yatsuka
	0x002a9544, // n0x0e82 c0x0000 (---------------)  + I arai
	0x0030f705, // n0x0e83 c0x0000 (---------------)  + I atami
	0x00274484, // n0x0e84 c0x0000 (---------------)  + I fuji
	0x002f3007, // n0x0e85 c0x0000 (---------------)  + I fujieda
	0x002746c8, // n0x0e86 c0x0000 (---------------)  + I fujikawa
	0x00274e4a, // n0x0e87 c0x0000 (---------------)  + I fujinomiya
	0x0027b8c7, // n0x0e88 c0x0000 (---------------)  + I fukuroi
	0x0029db47, // n0x0e89 c0x0000 (---------------)  + I gotemba
	0x0032cc87, // n0x0e8a c0x0000 (---------------)  + I haibara
	0x00311b89, // n0x0e8b c0x0000 (---------------)  + I hamamatsu
	0x0028ee8a, // n0x0e8c c0x0000 (---------------)  + I higashiizu
	0x0022a4c3, // n0x0e8d c0x0000 (---------------)  + I ito
	0x0034e745, // n0x0e8e c0x0000 (---------------)  + I iwata
	0x00220183, // n0x0e8f c0x0000 (---------------)  + I izu
	0x002f5309, // n0x0e90 c0x0000 (---------------)  + I izunokuni
	0x0028c508, // n0x0e91 c0x0000 (---------------)  + I kakegawa
	0x0031f0c7, // n0x0e92 c0x0000 (---------------)  + I kannami
	0x00212849, // n0x0e93 c0x0000 (---------------)  + I kawanehon
	0x002270c6, // n0x0e94 c0x0000 (---------------)  + I kawazu
	0x0022dd88, // n0x0e95 c0x0000 (---------------)  + I kikugawa
	0x002ed185, // n0x0e96 c0x0000 (---------------)  + I kosai
	0x0031504a, // n0x0e97 c0x0000 (---------------)  + I makinohara
	0x002ca149, // n0x0e98 c0x0000 (---------------)  + I matsuzaki
	0x0026b6c9, // n0x0e99 c0x0000 (---------------)  + I minamiizu
	0x002bb107, // n0x0e9a c0x0000 (---------------)  + I mishima
	0x00291649, // n0x0e9b c0x0000 (---------------)  + I morimachi
	0x00223748, // n0x0e9c c0x0000 (---------------)  + I nishiizu
	0x002eb906, // n0x0e9d c0x0000 (---------------)  + I numazu
	0x0022f648, // n0x0e9e c0x0000 (---------------)  + I omaezaki
	0x0020d8c7, // n0x0e9f c0x0000 (---------------)  + I shimada
	0x0024b147, // n0x0ea0 c0x0000 (---------------)  + I shimizu
	0x002dd247, // n0x0ea1 c0x0000 (---------------)  + I shimoda
	0x002dd488, // n0x0ea2 c0x0000 (---------------)  + I shizuoka
	0x002eb3c6, // n0x0ea3 c0x0000 (---------------)  + I susono
	0x00289f45, // n0x0ea4 c0x0000 (---------------)  + I yaizu
	0x00278b87, // n0x0ea5 c0x0000 (---------------)  + I yoshida
	0x0028f548, // n0x0ea6 c0x0000 (---------------)  + I ashikaga
	0x00335a44, // n0x0ea7 c0x0000 (---------------)  + I bato
	0x00324084, // n0x0ea8 c0x0000 (---------------)  + I haga
	0x002e3a07, // n0x0ea9 c0x0000 (---------------)  + I ichikai
	0x00265447, // n0x0eaa c0x0000 (---------------)  + I iwafune
	0x002b67ca, // n0x0eab c0x0000 (---------------)  + I kaminokawa
	0x002eb886, // n0x0eac c0x0000 (---------------)  + I kanuma
	0x002f8a8a, // n0x0ead c0x0000 (---------------)  + I karasuyama
	0x002b4007, // n0x0eae c0x0000 (---------------)  + I kuroiso
	0x00260487, // n0x0eaf c0x0000 (---------------)  + I mashiko
	0x0022bf84, // n0x0eb0 c0x0000 (---------------)  + I mibu
	0x002b7984, // n0x0eb1 c0x0000 (---------------)  + I moka
	0x0023b746, // n0x0eb2 c0x0000 (---------------)  + I motegi
	0x003725c4, // n0x0eb3 c0x0000 (---------------)  + I nasu
	0x003725cc, // n0x0eb4 c0x0000 (---------------)  + I nasushiobara
	0x0020fc85, // n0x0eb5 c0x0000 (---------------)  + I nikko
	0x00224d09, // n0x0eb6 c0x0000 (---------------)  + I nishikata
	0x00280604, // n0x0eb7 c0x0000 (---------------)  + I nogi
	0x0029b505, // n0x0eb8 c0x0000 (---------------)  + I ohira
	0x00206f08, // n0x0eb9 c0x0000 (---------------)  + I ohtawara
	0x0028a7c5, // n0x0eba c0x0000 (---------------)  + I oyama
	0x0021a006, // n0x0ebb c0x0000 (---------------)  + I sakura
	0x0032d184, // n0x0ebc c0x0000 (---------------)  + I sano
	0x002c888a, // n0x0ebd c0x0000 (---------------)  + I shimotsuke
	0x002f3846, // n0x0ebe c0x0000 (---------------)  + I shioya
	0x0028ab0a, // n0x0ebf c0x0000 (---------------)  + I takanezawa
	0x00335ac7, // n0x0ec0 c0x0000 (---------------)  + I tochigi
	0x002040c5, // n0x0ec1 c0x0000 (---------------)  + I tsuga
	0x00216045, // n0x0ec2 c0x0000 (---------------)  + I ujiie
	0x0024bd8a, // n0x0ec3 c0x0000 (---------------)  + I utsunomiya
	0x00257c45, // n0x0ec4 c0x0000 (---------------)  + I yaita
	0x0029b106, // n0x0ec5 c0x0000 (---------------)  + I aizumi
	0x00205884, // n0x0ec6 c0x0000 (---------------)  + I anan
	0x002b0846, // n0x0ec7 c0x0000 (---------------)  + I ichiba
	0x002e7245, // n0x0ec8 c0x0000 (---------------)  + I itano
	0x00220a46, // n0x0ec9 c0x0000 (---------------)  + I kainan
	0x0032c6cc, // n0x0eca c0x0000 (---------------)  + I komatsushima
	0x002c1d8a, // n0x0ecb c0x0000 (---------------)  + I matsushige
	0x002f5544, // n0x0ecc c0x0000 (---------------)  + I mima
	0x0024b386, // n0x0ecd c0x0000 (---------------)  + I minami
	0x00295c07, // n0x0ece c0x0000 (---------------)  + I miyoshi
	0x002c5a84, // n0x0ecf c0x0000 (---------------)  + I mugi
	0x0029bf08, // n0x0ed0 c0x0000 (---------------)  + I nakagawa
	0x00353e86, // n0x0ed1 c0x0000 (---------------)  + I naruto
	0x00250749, // n0x0ed2 c0x0000 (---------------)  + I sanagochi
	0x0033a0c9, // n0x0ed3 c0x0000 (---------------)  + I shishikui
	0x002e1f89, // n0x0ed4 c0x0000 (---------------)  + I tokushima
	0x00294086, // n0x0ed5 c0x0000 (---------------)  + I wajiki
	0x0020d9c6, // n0x0ed6 c0x0000 (---------------)  + I adachi
	0x0022f787, // n0x0ed7 c0x0000 (---------------)  + I akiruno
	0x0036aac8, // n0x0ed8 c0x0000 (---------------)  + I akishima
	0x0020d7c9, // n0x0ed9 c0x0000 (---------------)  + I aogashima
	0x0020d307, // n0x0eda c0x0000 (---------------)  + I arakawa
	0x0028e306, // n0x0edb c0x0000 (---------------)  + I bunkyo
	0x00374b47, // n0x0edc c0x0000 (---------------)  + I chiyoda
	0x002a4b45, // n0x0edd c0x0000 (---------------)  + I chofu
	0x002606c4, // n0x0ede c0x0000 (---------------)  + I chuo
	0x0022f347, // n0x0edf c0x0000 (---------------)  + I edogawa
	0x0028c305, // n0x0ee0 c0x0000 (---------------)  + I fuchu
	0x002811c5, // n0x0ee1 c0x0000 (---------------)  + I fussa
	0x0023b1c7, // n0x0ee2 c0x0000 (---------------)  + I hachijo
	0x00257a48, // n0x0ee3 c0x0000 (---------------)  + I hachioji
	0x00285446, // n0x0ee4 c0x0000 (---------------)  + I hamura
	0x00290c8d, // n0x0ee5 c0x0000 (---------------)  + I higashikurume
	0x002921cf, // n0x0ee6 c0x0000 (---------------)  + I higashimurayama
	0x0029780d, // n0x0ee7 c0x0000 (---------------)  + I higashiyamato
	0x00201b04, // n0x0ee8 c0x0000 (---------------)  + I hino
	0x00238406, // n0x0ee9 c0x0000 (---------------)  + I hinode
	0x002ca908, // n0x0eea c0x0000 (---------------)  + I hinohara
	0x0036dec5, // n0x0eeb c0x0000 (---------------)  + I inagi
	0x00298d88, // n0x0eec c0x0000 (---------------)  + I itabashi
	0x002a208a, // n0x0eed c0x0000 (---------------)  + I katsushika
	0x00213344, // n0x0eee c0x0000 (---------------)  + I kita
	0x002cdf46, // n0x0eef c0x0000 (---------------)  + I kiyose
	0x00240207, // n0x0ef0 c0x0000 (---------------)  + I kodaira
	0x002df047, // n0x0ef1 c0x0000 (---------------)  + I koganei
	0x00367d49, // n0x0ef2 c0x0000 (---------------)  + I kokubunji
	0x0022f605, // n0x0ef3 c0x0000 (---------------)  + I komae
	0x003587c4, // n0x0ef4 c0x0000 (---------------)  + I koto
	0x002abf0a, // n0x0ef5 c0x0000 (---------------)  + I kouzushima
	0x002b1409, // n0x0ef6 c0x0000 (---------------)  + I kunitachi
	0x00291747, // n0x0ef7 c0x0000 (---------------)  + I machida
	0x002dda46, // n0x0ef8 c0x0000 (---------------)  + I meguro
	0x0032dcc6, // n0x0ef9 c0x0000 (---------------)  + I minato
	0x00290306, // n0x0efa c0x0000 (---------------)  + I mitaka
	0x0023e346, // n0x0efb c0x0000 (---------------)  + I mizuho
	0x002c9e0f, // n0x0efc c0x0000 (---------------)  + I musashimurayama
	0x002ca7c9, // n0x0efd c0x0000 (---------------)  + I musashino
	0x002501c6, // n0x0efe c0x0000 (---------------)  + I nakano
	0x0033ddc6, // n0x0eff c0x0000 (---------------)  + I nerima
	0x0036b4c9, // n0x0f00 c0x0000 (---------------)  + I ogasawara
	0x002aa1c7, // n0x0f01 c0x0000 (---------------)  + I okutama
	0x00219d43, // n0x0f02 c0x0000 (---------------)  + I ome
	0x0022b546, // n0x0f03 c0x0000 (---------------)  + I oshima
	0x00213d43, // n0x0f04 c0x0000 (---------------)  + I ota
	0x002d0908, // n0x0f05 c0x0000 (---------------)  + I setagaya
	0x00234507, // n0x0f06 c0x0000 (---------------)  + I shibuya
	0x0029b749, // n0x0f07 c0x0000 (---------------)  + I shinagawa
	0x002d7688, // n0x0f08 c0x0000 (---------------)  + I shinjuku
	0x00343b08, // n0x0f09 c0x0000 (---------------)  + I suginami
	0x00265c06, // n0x0f0a c0x0000 (---------------)  + I sumida
	0x00309ac9, // n0x0f0b c0x0000 (---------------)  + I tachikawa
	0x00316dc5, // n0x0f0c c0x0000 (---------------)  + I taito
	0x0020a7c4, // n0x0f0d c0x0000 (---------------)  + I tama
	0x00313287, // n0x0f0e c0x0000 (---------------)  + I toshima
	0x0033a885, // n0x0f0f c0x0000 (---------------)  + I chizu
	0x00201b04, // n0x0f10 c0x0000 (---------------)  + I hino
	0x00280d88, // n0x0f11 c0x0000 (---------------)  + I kawahara
	0x00204a84, // n0x0f12 c0x0000 (---------------)  + I koge
	0x0035b787, // n0x0f13 c0x0000 (---------------)  + I kotoura
	0x002e46c6, // n0x0f14 c0x0000 (---------------)  + I misasa
	0x002c6785, // n0x0f15 c0x0000 (---------------)  + I nanbu
	0x002cf288, // n0x0f16 c0x0000 (---------------)  + I nichinan
	0x0032db8b, // n0x0f17 c0x0000 (---------------)  + I sakaiminato
	0x002fb3c7, // n0x0f18 c0x0000 (---------------)  + I tottori
	0x0024c006, // n0x0f19 c0x0000 (---------------)  + I wakasa
	0x002bdd84, // n0x0f1a c0x0000 (---------------)  + I yazu
	0x00319306, // n0x0f1b c0x0000 (---------------)  + I yonago
	0x002bac05, // n0x0f1c c0x0000 (---------------)  + I asahi
	0x0028c305, // n0x0f1d c0x0000 (---------------)  + I fuchu
	0x0027b189, // n0x0f1e c0x0000 (---------------)  + I fukumitsu
	0x0027e309, // n0x0f1f c0x0000 (---------------)  + I funahashi
	0x0024b184, // n0x0f20 c0x0000 (---------------)  + I himi
	0x0024b1c5, // n0x0f21 c0x0000 (---------------)  + I imizu
	0x0024b3c5, // n0x0f22 c0x0000 (---------------)  + I inami
	0x00314ec6, // n0x0f23 c0x0000 (---------------)  + I johana
	0x002e3908, // n0x0f24 c0x0000 (---------------)  + I kamiichi
	0x002b3806, // n0x0f25 c0x0000 (---------------)  + I kurobe
	0x0026a58b, // n0x0f26 c0x0000 (---------------)  + I nakaniikawa
	0x0022aeca, // n0x0f27 c0x0000 (---------------)  + I namerikawa
	0x002fdb85, // n0x0f28 c0x0000 (---------------)  + I nanto
	0x00286d86, // n0x0f29 c0x0000 (---------------)  + I nyuzen
	0x002ec145, // n0x0f2a c0x0000 (---------------)  + I oyabe
	0x003717c5, // n0x0f2b c0x0000 (---------------)  + I taira
	0x00295387, // n0x0f2c c0x0000 (---------------)  + I takaoka
	0x0024f888, // n0x0f2d c0x0000 (---------------)  + I tateyama
	0x00289e44, // n0x0f2e c0x0000 (---------------)  + I toga
	0x002d3906, // n0x0f2f c0x0000 (---------------)  + I tonami
	0x0028a786, // n0x0f30 c0x0000 (---------------)  + I toyama
	0x00223907, // n0x0f31 c0x0000 (---------------)  + I unazuki
	0x002b4f84, // n0x0f32 c0x0000 (---------------)  + I uozu
	0x002795c6, // n0x0f33 c0x0000 (---------------)  + I yamada
	0x00255245, // n0x0f34 c0x0000 (---------------)  + I arida
	0x00255249, // n0x0f35 c0x0000 (---------------)  + I aridagawa
	0x0020dbc4, // n0x0f36 c0x0000 (---------------)  + I gobo
	0x002d8cc9, // n0x0f37 c0x0000 (---------------)  + I hashimoto
	0x002780c6, // n0x0f38 c0x0000 (---------------)  + I hidaka
	0x002b6e88, // n0x0f39 c0x0000 (---------------)  + I hirogawa
	0x0024b3c5, // n0x0f3a c0x0000 (---------------)  + I inami
	0x0022eb45, // n0x0f3b c0x0000 (---------------)  + I iwade
	0x00220a46, // n0x0f3c c0x0000 (---------------)  + I kainan
	0x002c2289, // n0x0f3d c0x0000 (---------------)  + I kamitonda
	0x00226589, // n0x0f3e c0x0000 (---------------)  + I katsuragi
	0x00256d86, // n0x0f3f c0x0000 (---------------)  + I kimino
	0x00254ac8, // n0x0f40 c0x0000 (---------------)  + I kinokawa
	0x002955c8, // n0x0f41 c0x0000 (---------------)  + I kitayama
	0x002ec104, // n0x0f42 c0x0000 (---------------)  + I koya
	0x002ac284, // n0x0f43 c0x0000 (---------------)  + I koza
	0x002ac288, // n0x0f44 c0x0000 (---------------)  + I kozagawa
	0x003084c8, // n0x0f45 c0x0000 (---------------)  + I kudoyama
	0x0029f909, // n0x0f46 c0x0000 (---------------)  + I kushimoto
	0x00292746, // n0x0f47 c0x0000 (---------------)  + I mihama
	0x002625c6, // n0x0f48 c0x0000 (---------------)  + I misato
	0x0030594d, // n0x0f49 c0x0000 (---------------)  + I nachikatsuura
	0x002a57c6, // n0x0f4a c0x0000 (---------------)  + I shingu
	0x002f4089, // n0x0f4b c0x0000 (---------------)  + I shirahama
	0x00315f85, // n0x0f4c c0x0000 (---------------)  + I taiji
	0x0021dcc6, // n0x0f4d c0x0000 (---------------)  + I tanabe
	0x00309c88, // n0x0f4e c0x0000 (---------------)  + I wakayama
	0x00303205, // n0x0f4f c0x0000 (---------------)  + I yuasa
	0x00279b84, // n0x0f50 c0x0000 (---------------)  + I yura
	0x002bac05, // n0x0f51 c0x0000 (---------------)  + I asahi
	0x0027de88, // n0x0f52 c0x0000 (---------------)  + I funagata
	0x00293289, // n0x0f53 c0x0000 (---------------)  + I higashine
	0x00274544, // n0x0f54 c0x0000 (---------------)  + I iide
	0x00311246, // n0x0f55 c0x0000 (---------------)  + I kahoku
	0x002efbca, // n0x0f56 c0x0000 (---------------)  + I kaminoyama
	0x00229248, // n0x0f57 c0x0000 (---------------)  + I kaneyama
	0x002b6949, // n0x0f58 c0x0000 (---------------)  + I kawanishi
	0x003457ca, // n0x0f59 c0x0000 (---------------)  + I mamurogawa
	0x002127c6, // n0x0f5a c0x0000 (---------------)  + I mikawa
	0x00292388, // n0x0f5b c0x0000 (---------------)  + I murayama
	0x00276945, // n0x0f5c c0x0000 (---------------)  + I nagai
	0x00344c08, // n0x0f5d c0x0000 (---------------)  + I nakayama
	0x002b0685, // n0x0f5e c0x0000 (---------------)  + I nanyo
	0x00226f89, // n0x0f5f c0x0000 (---------------)  + I nishikawa
	0x002e7349, // n0x0f60 c0x0000 (---------------)  + I obanazawa
	0x0020dd02, // n0x0f61 c0x0000 (---------------)  + I oe
	0x0028dcc5, // n0x0f62 c0x0000 (---------------)  + I oguni
	0x00274cc6, // n0x0f63 c0x0000 (---------------)  + I ohkura
	0x00278007, // n0x0f64 c0x0000 (---------------)  + I oishida
	0x002a40c5, // n0x0f65 c0x0000 (---------------)  + I sagae
	0x00341a46, // n0x0f66 c0x0000 (---------------)  + I sakata
	0x0034a348, // n0x0f67 c0x0000 (---------------)  + I sakegawa
	0x002d2246, // n0x0f68 c0x0000 (---------------)  + I shinjo
	0x0031f5c9, // n0x0f69 c0x0000 (---------------)  + I shirataka
	0x00276286, // n0x0f6a c0x0000 (---------------)  + I shonai
	0x002a3c48, // n0x0f6b c0x0000 (---------------)  + I takahata
	0x002a7185, // n0x0f6c c0x0000 (---------------)  + I tendo
	0x002612c6, // n0x0f6d c0x0000 (---------------)  + I tozawa
	0x00212b08, // n0x0f6e c0x0000 (---------------)  + I tsuruoka
	0x0027d308, // n0x0f6f c0x0000 (---------------)  + I yamagata
	0x00202b48, // n0x0f70 c0x0000 (---------------)  + I yamanobe
	0x00246508, // n0x0f71 c0x0000 (---------------)  + I yonezawa
	0x00263244, // n0x0f72 c0x0000 (---------------)  + I yuza
	0x00220e83, // n0x0f73 c0x0000 (---------------)  + I abu
	0x0031f804, // n0x0f74 c0x0000 (---------------)  + I hagi
	0x002be386, // n0x0f75 c0x0000 (---------------)  + I hikari
	0x002a4b84, // n0x0f76 c0x0000 (---------------)  + I hofu
	0x0033f747, // n0x0f77 c0x0000 (---------------)  + I iwakuni
	0x002a9b89, // n0x0f78 c0x0000 (---------------)  + I kudamatsu
	0x002bcfc5, // n0x0f79 c0x0000 (---------------)  + I mitou
	0x00201106, // n0x0f7a c0x0000 (---------------)  + I nagato
	0x0022b546, // n0x0f7b c0x0000 (---------------)  + I oshima
	0x002c480b, // n0x0f7c c0x0000 (---------------)  + I shimonoseki
	0x002fdac6, // n0x0f7d c0x0000 (---------------)  + I shunan
	0x003087c6, // n0x0f7e c0x0000 (---------------)  + I tabuse
	0x00274288, // n0x0f7f c0x0000 (---------------)  + I tokuyama
	0x00255a86, // n0x0f80 c0x0000 (---------------)  + I toyota
	0x00200e43, // n0x0f81 c0x0000 (---------------)  + I ube
	0x00224083, // n0x0f82 c0x0000 (---------------)  + I yuu
	0x002606c4, // n0x0f83 c0x0000 (---------------)  + I chuo
	0x00234485, // n0x0f84 c0x0000 (---------------)  + I doshi
	0x00306987, // n0x0f85 c0x0000 (---------------)  + I fuefuki
	0x002746c8, // n0x0f86 c0x0000 (---------------)  + I fujikawa
	0x002746cf, // n0x0f87 c0x0000 (---------------)  + I fujikawaguchiko
	0x00278a8b, // n0x0f88 c0x0000 (---------------)  + I fujiyoshida
	0x002e3708, // n0x0f89 c0x0000 (---------------)  + I hayakawa
	0x003112c6, // n0x0f8a c0x0000 (---------------)  + I hokuto
	0x002a034e, // n0x0f8b c0x0000 (---------------)  + I ichikawamisato
	0x00220a43, // n0x0f8c c0x0000 (---------------)  + I kai
	0x00306904, // n0x0f8d c0x0000 (---------------)  + I kofu
	0x002fda45, // n0x0f8e c0x0000 (---------------)  + I koshu
	0x0034bec6, // n0x0f8f c0x0000 (---------------)  + I kosuge
	0x002889cb, // n0x0f90 c0x0000 (---------------)  + I minami-alps
	0x0028cc46, // n0x0f91 c0x0000 (---------------)  + I minobu
	0x00226089, // n0x0f92 c0x0000 (---------------)  + I nakamichi
	0x002c6785, // n0x0f93 c0x0000 (---------------)  + I nanbu
	0x0033b408, // n0x0f94 c0x0000 (---------------)  + I narusawa
	0x00214948, // n0x0f95 c0x0000 (---------------)  + I nirasaki
	0x0022644c, // n0x0f96 c0x0000 (---------------)  + I nishikatsura
	0x00298586, // n0x0f97 c0x0000 (---------------)  + I oshino
	0x002a39c6, // n0x0f98 c0x0000 (---------------)  + I otsuki
	0x002ddc85, // n0x0f99 c0x0000 (---------------)  + I showa
	0x00281808, // n0x0f9a c0x0000 (---------------)  + I tabayama
	0x00212b05, // n0x0f9b c0x0000 (---------------)  + I tsuru
	0x002107c8, // n0x0f9c c0x0000 (---------------)  + I uenohara
	0x00297c4a, // n0x0f9d c0x0000 (---------------)  + I yamanakako
	0x00322709, // n0x0f9e c0x0000 (---------------)  + I yamanashi
	0x00757e04, // n0x0f9f c0x0001 (---------------)  ! I city
	0x00222603, // n0x0fa0 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0fa1 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0fa2 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0fa3 c0x0000 (---------------)  + I mil
	0x00201603, // n0x0fa4 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0fa5 c0x0000 (---------------)  + I org
	0x00314c43, // n0x0fa6 c0x0000 (---------------)  + I biz
	0x00222603, // n0x0fa7 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0fa8 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0fa9 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x0faa c0x0000 (---------------)  + I info
	0x00201603, // n0x0fab c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0fac c0x0000 (---------------)  + I org
	0x00204603, // n0x0fad c0x0000 (---------------)  + I ass
	0x0029cfc4, // n0x0fae c0x0000 (---------------)  + I asso
	0x00222603, // n0x0faf c0x0000 (---------------)  + I com
	0x00239dc4, // n0x0fb0 c0x0000 (---------------)  + I coop
	0x0027a643, // n0x0fb1 c0x0000 (---------------)  + I edu
	0x00368f84, // n0x0fb2 c0x0000 (---------------)  + I gouv
	0x002157c3, // n0x0fb3 c0x0000 (---------------)  + I gov
	0x002eef07, // n0x0fb4 c0x0000 (---------------)  + I medecin
	0x0023f703, // n0x0fb5 c0x0000 (---------------)  + I mil
	0x00214103, // n0x0fb6 c0x0000 (---------------)  + I nom
	0x002bef08, // n0x0fb7 c0x0000 (---------------)  + I notaires
	0x0021f5c3, // n0x0fb8 c0x0000 (---------------)  + I org
	0x002c860b, // n0x0fb9 c0x0000 (---------------)  + I pharmaciens
	0x002d7b03, // n0x0fba c0x0000 (---------------)  + I prd
	0x002487c6, // n0x0fbb c0x0000 (---------------)  + I presse
	0x00200142, // n0x0fbc c0x0000 (---------------)  + I tm
	0x002de14b, // n0x0fbd c0x0000 (---------------)  + I veterinaire
	0x0027a643, // n0x0fbe c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0fbf c0x0000 (---------------)  + I gov
	0x00201603, // n0x0fc0 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0fc1 c0x0000 (---------------)  + I org
	0x00222603, // n0x0fc2 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0fc3 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0fc4 c0x0000 (---------------)  + I gov
	0x0021f5c3, // n0x0fc5 c0x0000 (---------------)  + I org
	0x0021fbc3, // n0x0fc6 c0x0000 (---------------)  + I rep
	0x00205543, // n0x0fc7 c0x0000 (---------------)  + I tra
	0x00201d82, // n0x0fc8 c0x0000 (---------------)  + I ac
	0x000b8948, // n0x0fc9 c0x0000 (---------------)  +   blogspot
	0x002326c5, // n0x0fca c0x0000 (---------------)  + I busan
	0x00323348, // n0x0fcb c0x0000 (---------------)  + I chungbuk
	0x003265c8, // n0x0fcc c0x0000 (---------------)  + I chungnam
	0x00207a02, // n0x0fcd c0x0000 (---------------)  + I co
	0x00311dc5, // n0x0fce c0x0000 (---------------)  + I daegu
	0x002fd807, // n0x0fcf c0x0000 (---------------)  + I daejeon
	0x00201fc2, // n0x0fd0 c0x0000 (---------------)  + I es
	0x002262c7, // n0x0fd1 c0x0000 (---------------)  + I gangwon
	0x00206cc2, // n0x0fd2 c0x0000 (---------------)  + I go
	0x00253747, // n0x0fd3 c0x0000 (---------------)  + I gwangju
	0x0032c4c9, // n0x0fd4 c0x0000 (---------------)  + I gyeongbuk
	0x00299948, // n0x0fd5 c0x0000 (---------------)  + I gyeonggi
	0x0025eb09, // n0x0fd6 c0x0000 (---------------)  + I gyeongnam
	0x0020f042, // n0x0fd7 c0x0000 (---------------)  + I hs
	0x002ad687, // n0x0fd8 c0x0000 (---------------)  + I incheon
	0x00256b04, // n0x0fd9 c0x0000 (---------------)  + I jeju
	0x002fd8c7, // n0x0fda c0x0000 (---------------)  + I jeonbuk
	0x0022adc7, // n0x0fdb c0x0000 (---------------)  + I jeonnam
	0x0023d042, // n0x0fdc c0x0000 (---------------)  + I kg
	0x0023f703, // n0x0fdd c0x0000 (---------------)  + I mil
	0x00225542, // n0x0fde c0x0000 (---------------)  + I ms
	0x00201602, // n0x0fdf c0x0000 (---------------)  + I ne
	0x00200bc2, // n0x0fe0 c0x0000 (---------------)  + I or
	0x00202142, // n0x0fe1 c0x0000 (---------------)  + I pe
	0x002039c2, // n0x0fe2 c0x0000 (---------------)  + I re
	0x00218bc2, // n0x0fe3 c0x0000 (---------------)  + I sc
	0x0034b005, // n0x0fe4 c0x0000 (---------------)  + I seoul
	0x00224105, // n0x0fe5 c0x0000 (---------------)  + I ulsan
	0x00222603, // n0x0fe6 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0fe7 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0fe8 c0x0000 (---------------)  + I gov
	0x00201603, // n0x0fe9 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0fea c0x0000 (---------------)  + I org
	0x00222603, // n0x0feb c0x0000 (---------------)  + I com
	0x0027a643, // n0x0fec c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0fed c0x0000 (---------------)  + I gov
	0x0023f703, // n0x0fee c0x0000 (---------------)  + I mil
	0x00201603, // n0x0fef c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0ff0 c0x0000 (---------------)  + I org
	0x00000601, // n0x0ff1 c0x0000 (---------------)  +   c
	0x00222603, // n0x0ff2 c0x0000 (---------------)  + I com
	0x0027a643, // n0x0ff3 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0ff4 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x0ff5 c0x0000 (---------------)  + I info
	0x00223a83, // n0x0ff6 c0x0000 (---------------)  + I int
	0x00201603, // n0x0ff7 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0ff8 c0x0000 (---------------)  + I org
	0x00222483, // n0x0ff9 c0x0000 (---------------)  + I per
	0x00222603, // n0x0ffa c0x0000 (---------------)  + I com
	0x0027a643, // n0x0ffb c0x0000 (---------------)  + I edu
	0x002157c3, // n0x0ffc c0x0000 (---------------)  + I gov
	0x00201603, // n0x0ffd c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x0ffe c0x0000 (---------------)  + I org
	0x00207a02, // n0x0fff c0x0000 (---------------)  + I co
	0x00222603, // n0x1000 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1001 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1002 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1003 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1004 c0x0000 (---------------)  + I org
	0x002b7fc4, // n0x1005 c0x0000 (---------------)  + I assn
	0x00222603, // n0x1006 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1007 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1008 c0x0000 (---------------)  + I gov
	0x00236603, // n0x1009 c0x0000 (---------------)  + I grp
	0x002a7585, // n0x100a c0x0000 (---------------)  + I hotel
	0x00223a83, // n0x100b c0x0000 (---------------)  + I int
	0x00223143, // n0x100c c0x0000 (---------------)  + I ltd
	0x00201603, // n0x100d c0x0000 (---------------)  + I net
	0x00224203, // n0x100e c0x0000 (---------------)  + I ngo
	0x0021f5c3, // n0x100f c0x0000 (---------------)  + I org
	0x002526c3, // n0x1010 c0x0000 (---------------)  + I sch
	0x0029d043, // n0x1011 c0x0000 (---------------)  + I soc
	0x00205e43, // n0x1012 c0x0000 (---------------)  + I web
	0x00222603, // n0x1013 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1014 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1015 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1016 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1017 c0x0000 (---------------)  + I org
	0x00207a02, // n0x1018 c0x0000 (---------------)  + I co
	0x0021f5c3, // n0x1019 c0x0000 (---------------)  + I org
	0x002157c3, // n0x101a c0x0000 (---------------)  + I gov
	0x002adf03, // n0x101b c0x0000 (---------------)  + I asn
	0x00222603, // n0x101c c0x0000 (---------------)  + I com
	0x00234b04, // n0x101d c0x0000 (---------------)  + I conf
	0x0027a643, // n0x101e c0x0000 (---------------)  + I edu
	0x002157c3, // n0x101f c0x0000 (---------------)  + I gov
	0x00202f82, // n0x1020 c0x0000 (---------------)  + I id
	0x0023f703, // n0x1021 c0x0000 (---------------)  + I mil
	0x00201603, // n0x1022 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1023 c0x0000 (---------------)  + I org
	0x00222603, // n0x1024 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1025 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1026 c0x0000 (---------------)  + I gov
	0x00202f82, // n0x1027 c0x0000 (---------------)  + I id
	0x00225d03, // n0x1028 c0x0000 (---------------)  + I med
	0x00201603, // n0x1029 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x102a c0x0000 (---------------)  + I org
	0x002d2a43, // n0x102b c0x0000 (---------------)  + I plc
	0x002526c3, // n0x102c c0x0000 (---------------)  + I sch
	0x00201d82, // n0x102d c0x0000 (---------------)  + I ac
	0x00207a02, // n0x102e c0x0000 (---------------)  + I co
	0x002157c3, // n0x102f c0x0000 (---------------)  + I gov
	0x00201603, // n0x1030 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1031 c0x0000 (---------------)  + I org
	0x002487c5, // n0x1032 c0x0000 (---------------)  + I press
	0x0029cfc4, // n0x1033 c0x0000 (---------------)  + I asso
	0x00200142, // n0x1034 c0x0000 (---------------)  + I tm
	0x00201d82, // n0x1035 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x1036 c0x0000 (---------------)  + I co
	0x0027a643, // n0x1037 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1038 c0x0000 (---------------)  + I gov
	0x002602c3, // n0x1039 c0x0000 (---------------)  + I its
	0x00201603, // n0x103a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x103b c0x0000 (---------------)  + I org
	0x002d82c4, // n0x103c c0x0000 (---------------)  + I priv
	0x00222603, // n0x103d c0x0000 (---------------)  + I com
	0x0027a643, // n0x103e c0x0000 (---------------)  + I edu
	0x002157c3, // n0x103f c0x0000 (---------------)  + I gov
	0x0023f703, // n0x1040 c0x0000 (---------------)  + I mil
	0x00214103, // n0x1041 c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x1042 c0x0000 (---------------)  + I org
	0x002d7b03, // n0x1043 c0x0000 (---------------)  + I prd
	0x00200142, // n0x1044 c0x0000 (---------------)  + I tm
	0x00222603, // n0x1045 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1046 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1047 c0x0000 (---------------)  + I gov
	0x0021c543, // n0x1048 c0x0000 (---------------)  + I inf
	0x0022aec4, // n0x1049 c0x0000 (---------------)  + I name
	0x00201603, // n0x104a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x104b c0x0000 (---------------)  + I org
	0x00222603, // n0x104c c0x0000 (---------------)  + I com
	0x0027a643, // n0x104d c0x0000 (---------------)  + I edu
	0x00368f84, // n0x104e c0x0000 (---------------)  + I gouv
	0x002157c3, // n0x104f c0x0000 (---------------)  + I gov
	0x00201603, // n0x1050 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1051 c0x0000 (---------------)  + I org
	0x002487c6, // n0x1052 c0x0000 (---------------)  + I presse
	0x0027a643, // n0x1053 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1054 c0x0000 (---------------)  + I gov
	0x00015183, // n0x1055 c0x0000 (---------------)  +   nyc
	0x0021f5c3, // n0x1056 c0x0000 (---------------)  + I org
	0x00222603, // n0x1057 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1058 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1059 c0x0000 (---------------)  + I gov
	0x00201603, // n0x105a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x105b c0x0000 (---------------)  + I org
	0x000b8948, // n0x105c c0x0000 (---------------)  +   blogspot
	0x002157c3, // n0x105d c0x0000 (---------------)  + I gov
	0x00222603, // n0x105e c0x0000 (---------------)  + I com
	0x0027a643, // n0x105f c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1060 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1061 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1062 c0x0000 (---------------)  + I org
	0x00222603, // n0x1063 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1064 c0x0000 (---------------)  + I edu
	0x00201603, // n0x1065 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1066 c0x0000 (---------------)  + I org
	0x00201d82, // n0x1067 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x1068 c0x0000 (---------------)  + I co
	0x00222603, // n0x1069 c0x0000 (---------------)  + I com
	0x002157c3, // n0x106a c0x0000 (---------------)  + I gov
	0x00201603, // n0x106b c0x0000 (---------------)  + I net
	0x00200bc2, // n0x106c c0x0000 (---------------)  + I or
	0x0021f5c3, // n0x106d c0x0000 (---------------)  + I org
	0x002fe307, // n0x106e c0x0000 (---------------)  + I academy
	0x0029a5cb, // n0x106f c0x0000 (---------------)  + I agriculture
	0x002402c3, // n0x1070 c0x0000 (---------------)  + I air
	0x00254c88, // n0x1071 c0x0000 (---------------)  + I airguard
	0x0036a847, // n0x1072 c0x0000 (---------------)  + I alabama
	0x00204cc6, // n0x1073 c0x0000 (---------------)  + I alaska
	0x002b9985, // n0x1074 c0x0000 (---------------)  + I amber
	0x002c5389, // n0x1075 c0x0000 (---------------)  + I ambulance
	0x0025f188, // n0x1076 c0x0000 (---------------)  + I american
	0x0025f189, // n0x1077 c0x0000 (---------------)  + I americana
	0x002c7010, // n0x1078 c0x0000 (---------------)  + I americanantiques
	0x0025f18b, // n0x1079 c0x0000 (---------------)  + I americanart
	0x002b97c9, // n0x107a c0x0000 (---------------)  + I amsterdam
	0x002006c3, // n0x107b c0x0000 (---------------)  + I and
	0x002ec789, // n0x107c c0x0000 (---------------)  + I annefrank
	0x00235d86, // n0x107d c0x0000 (---------------)  + I anthro
	0x00235d8c, // n0x107e c0x0000 (---------------)  + I anthropology
	0x00232788, // n0x107f c0x0000 (---------------)  + I antiques
	0x00302c08, // n0x1080 c0x0000 (---------------)  + I aquarium
	0x0022a0c9, // n0x1081 c0x0000 (---------------)  + I arboretum
	0x002aa94e, // n0x1082 c0x0000 (---------------)  + I archaeological
	0x002cbacb, // n0x1083 c0x0000 (---------------)  + I archaeology
	0x0024680c, // n0x1084 c0x0000 (---------------)  + I architecture
	0x00201383, // n0x1085 c0x0000 (---------------)  + I art
	0x0025f38c, // n0x1086 c0x0000 (---------------)  + I artanddesign
	0x002f6c49, // n0x1087 c0x0000 (---------------)  + I artcenter
	0x002078c7, // n0x1088 c0x0000 (---------------)  + I artdeco
	0x0027a58c, // n0x1089 c0x0000 (---------------)  + I arteducation
	0x00236e4a, // n0x108a c0x0000 (---------------)  + I artgallery
	0x002180c4, // n0x108b c0x0000 (---------------)  + I arts
	0x002180cd, // n0x108c c0x0000 (---------------)  + I artsandcrafts
	0x002f6b08, // n0x108d c0x0000 (---------------)  + I asmatart
	0x0020cbcd, // n0x108e c0x0000 (---------------)  + I assassination
	0x00204606, // n0x108f c0x0000 (---------------)  + I assisi
	0x0029cfcb, // n0x1090 c0x0000 (---------------)  + I association
	0x00311889, // n0x1091 c0x0000 (---------------)  + I astronomy
	0x0027c587, // n0x1092 c0x0000 (---------------)  + I atlanta
	0x0036e206, // n0x1093 c0x0000 (---------------)  + I austin
	0x002e7549, // n0x1094 c0x0000 (---------------)  + I australia
	0x0031528a, // n0x1095 c0x0000 (---------------)  + I automotive
	0x00370988, // n0x1096 c0x0000 (---------------)  + I aviation
	0x0026d8c4, // n0x1097 c0x0000 (---------------)  + I axis
	0x00276ec7, // n0x1098 c0x0000 (---------------)  + I badajoz
	0x00316787, // n0x1099 c0x0000 (---------------)  + I baghdad
	0x002e7e44, // n0x109a c0x0000 (---------------)  + I bahn
	0x00349684, // n0x109b c0x0000 (---------------)  + I bale
	0x002e6649, // n0x109c c0x0000 (---------------)  + I baltimore
	0x002fc809, // n0x109d c0x0000 (---------------)  + I barcelona
	0x002a7808, // n0x109e c0x0000 (---------------)  + I baseball
	0x00211605, // n0x109f c0x0000 (---------------)  + I basel
	0x00211bc5, // n0x10a0 c0x0000 (---------------)  + I baths
	0x0020fb46, // n0x10a1 c0x0000 (---------------)  + I bauern
	0x00217f89, // n0x10a2 c0x0000 (---------------)  + I beauxarts
	0x00202ccd, // n0x10a3 c0x0000 (---------------)  + I beeldengeluid
	0x0021ddc8, // n0x10a4 c0x0000 (---------------)  + I bellevue
	0x0020fa47, // n0x10a5 c0x0000 (---------------)  + I bergbau
	0x002b9a08, // n0x10a6 c0x0000 (---------------)  + I berkeley
	0x0035e1c6, // n0x10a7 c0x0000 (---------------)  + I berlin
	0x00360504, // n0x10a8 c0x0000 (---------------)  + I bern
	0x0023a185, // n0x10a9 c0x0000 (---------------)  + I bible
	0x00204286, // n0x10aa c0x0000 (---------------)  + I bilbao
	0x002053c4, // n0x10ab c0x0000 (---------------)  + I bill
	0x002077c7, // n0x10ac c0x0000 (---------------)  + I birdart
	0x0020be0a, // n0x10ad c0x0000 (---------------)  + I birthplace
	0x00213004, // n0x10ae c0x0000 (---------------)  + I bonn
	0x00213686, // n0x10af c0x0000 (---------------)  + I boston
	0x00213d09, // n0x10b0 c0x0000 (---------------)  + I botanical
	0x00213d0f, // n0x10b1 c0x0000 (---------------)  + I botanicalgarden
	0x0021464d, // n0x10b2 c0x0000 (---------------)  + I botanicgarden
	0x00215086, // n0x10b3 c0x0000 (---------------)  + I botany
	0x002167d0, // n0x10b4 c0x0000 (---------------)  + I brandywinevalley
	0x002173c6, // n0x10b5 c0x0000 (---------------)  + I brasil
	0x00219007, // n0x10b6 c0x0000 (---------------)  + I bristol
	0x0021a287, // n0x10b7 c0x0000 (---------------)  + I british
	0x0021a28f, // n0x10b8 c0x0000 (---------------)  + I britishcolumbia
	0x0021bf49, // n0x10b9 c0x0000 (---------------)  + I broadcast
	0x00220346, // n0x10ba c0x0000 (---------------)  + I brunel
	0x002210c7, // n0x10bb c0x0000 (---------------)  + I brussel
	0x002210c8, // n0x10bc c0x0000 (---------------)  + I brussels
	0x00221689, // n0x10bd c0x0000 (---------------)  + I bruxelles
	0x0022c008, // n0x10be c0x0000 (---------------)  + I building
	0x002d0447, // n0x10bf c0x0000 (---------------)  + I burghof
	0x002326c3, // n0x10c0 c0x0000 (---------------)  + I bus
	0x0026b046, // n0x10c1 c0x0000 (---------------)  + I bushey
	0x00312948, // n0x10c2 c0x0000 (---------------)  + I cadaques
	0x002aac0a, // n0x10c3 c0x0000 (---------------)  + I california
	0x0021f389, // n0x10c4 c0x0000 (---------------)  + I cambridge
	0x00225943, // n0x10c5 c0x0000 (---------------)  + I can
	0x00319606, // n0x10c6 c0x0000 (---------------)  + I canada
	0x002d374a, // n0x10c7 c0x0000 (---------------)  + I capebreton
	0x00215cc7, // n0x10c8 c0x0000 (---------------)  + I carrier
	0x0027a3ca, // n0x10c9 c0x0000 (---------------)  + I cartoonart
	0x0035074e, // n0x10ca c0x0000 (---------------)  + I casadelamoneda
	0x0021c086, // n0x10cb c0x0000 (---------------)  + I castle
	0x002d9207, // n0x10cc c0x0000 (---------------)  + I castres
	0x002a54c6, // n0x10cd c0x0000 (---------------)  + I celtic
	0x00240f86, // n0x10ce c0x0000 (---------------)  + I center
	0x0034b8cb, // n0x10cf c0x0000 (---------------)  + I chattanooga
	0x0024a4ca, // n0x10d0 c0x0000 (---------------)  + I cheltenham
	0x00346dcd, // n0x10d1 c0x0000 (---------------)  + I chesapeakebay
	0x0020da87, // n0x10d2 c0x0000 (---------------)  + I chicago
	0x00203888, // n0x10d3 c0x0000 (---------------)  + I children
	0x00203889, // n0x10d4 c0x0000 (---------------)  + I childrens
	0x0020388f, // n0x10d5 c0x0000 (---------------)  + I childrensgarden
	0x002a488c, // n0x10d6 c0x0000 (---------------)  + I chiropractic
	0x002a1d09, // n0x10d7 c0x0000 (---------------)  + I chocolate
	0x0023c1ce, // n0x10d8 c0x0000 (---------------)  + I christiansburg
	0x002c6d0a, // n0x10d9 c0x0000 (---------------)  + I cincinnati
	0x002ef006, // n0x10da c0x0000 (---------------)  + I cinema
	0x0034f8c6, // n0x10db c0x0000 (---------------)  + I circus
	0x0022b6cc, // n0x10dc c0x0000 (---------------)  + I civilisation
	0x0022b9cc, // n0x10dd c0x0000 (---------------)  + I civilization
	0x0022bcc8, // n0x10de c0x0000 (---------------)  + I civilwar
	0x0022df87, // n0x10df c0x0000 (---------------)  + I clinton
	0x002007c5, // n0x10e0 c0x0000 (---------------)  + I clock
	0x00207a04, // n0x10e1 c0x0000 (---------------)  + I coal
	0x003335ce, // n0x10e2 c0x0000 (---------------)  + I coastaldefence
	0x0029fd84, // n0x10e3 c0x0000 (---------------)  + I cody
	0x00248c07, // n0x10e4 c0x0000 (---------------)  + I coldwar
	0x00230b8a, // n0x10e5 c0x0000 (---------------)  + I collection
	0x00231694, // n0x10e6 c0x0000 (---------------)  + I colonialwilliamsburg
	0x0023200f, // n0x10e7 c0x0000 (---------------)  + I coloradoplateau
	0x0021a448, // n0x10e8 c0x0000 (---------------)  + I columbia
	0x00232588, // n0x10e9 c0x0000 (---------------)  + I columbus
	0x002d734d, // n0x10ea c0x0000 (---------------)  + I communication
	0x002d734e, // n0x10eb c0x0000 (---------------)  + I communications
	0x00233189, // n0x10ec c0x0000 (---------------)  + I community
	0x00233bc8, // n0x10ed c0x0000 (---------------)  + I computer
	0x00233bcf, // n0x10ee c0x0000 (---------------)  + I computerhistory
	0x00236b4c, // n0x10ef c0x0000 (---------------)  + I contemporary
	0x00236b4f, // n0x10f0 c0x0000 (---------------)  + I contemporaryart
	0x00238147, // n0x10f1 c0x0000 (---------------)  + I convent
	0x0023a50a, // n0x10f2 c0x0000 (---------------)  + I copenhagen
	0x0023bbcb, // n0x10f3 c0x0000 (---------------)  + I corporation
	0x0023be88, // n0x10f4 c0x0000 (---------------)  + I corvette
	0x0023d1c7, // n0x10f5 c0x0000 (---------------)  + I costume
	0x0028494d, // n0x10f6 c0x0000 (---------------)  + I countryestate
	0x00315686, // n0x10f7 c0x0000 (---------------)  + I county
	0x00218286, // n0x10f8 c0x0000 (---------------)  + I crafts
	0x0023dfc9, // n0x10f9 c0x0000 (---------------)  + I cranbrook
	0x00227808, // n0x10fa c0x0000 (---------------)  + I creation
	0x00240d88, // n0x10fb c0x0000 (---------------)  + I cultural
	0x00240d8e, // n0x10fc c0x0000 (---------------)  + I culturalcenter
	0x0029a6c7, // n0x10fd c0x0000 (---------------)  + I culture
	0x0020c205, // n0x10fe c0x0000 (---------------)  + I cyber
	0x002cfc85, // n0x10ff c0x0000 (---------------)  + I cymru
	0x00202044, // n0x1100 c0x0000 (---------------)  + I dali
	0x002a4406, // n0x1101 c0x0000 (---------------)  + I dallas
	0x002a7708, // n0x1102 c0x0000 (---------------)  + I database
	0x00343183, // n0x1103 c0x0000 (---------------)  + I ddr
	0x0031830e, // n0x1104 c0x0000 (---------------)  + I decorativearts
	0x002c0008, // n0x1105 c0x0000 (---------------)  + I delaware
	0x002d678b, // n0x1106 c0x0000 (---------------)  + I delmenhorst
	0x0035a287, // n0x1107 c0x0000 (---------------)  + I denmark
	0x00369785, // n0x1108 c0x0000 (---------------)  + I depot
	0x00255d86, // n0x1109 c0x0000 (---------------)  + I design
	0x002a7ec7, // n0x110a c0x0000 (---------------)  + I detroit
	0x003340c8, // n0x110b c0x0000 (---------------)  + I dinosaur
	0x00315949, // n0x110c c0x0000 (---------------)  + I discovery
	0x00215345, // n0x110d c0x0000 (---------------)  + I dolls
	0x00280a88, // n0x110e c0x0000 (---------------)  + I donostia
	0x00202fc6, // n0x110f c0x0000 (---------------)  + I durham
	0x0028440a, // n0x1110 c0x0000 (---------------)  + I eastafrica
	0x003334c9, // n0x1111 c0x0000 (---------------)  + I eastcoast
	0x0027a649, // n0x1112 c0x0000 (---------------)  + I education
	0x0027a64b, // n0x1113 c0x0000 (---------------)  + I educational
	0x002a6388, // n0x1114 c0x0000 (---------------)  + I egyptian
	0x002e7d09, // n0x1115 c0x0000 (---------------)  + I eisenbahn
	0x002116c6, // n0x1116 c0x0000 (---------------)  + I elburg
	0x0036d4ca, // n0x1117 c0x0000 (---------------)  + I elvendrell
	0x002067ca, // n0x1118 c0x0000 (---------------)  + I embroidery
	0x0023a70c, // n0x1119 c0x0000 (---------------)  + I encyclopedic
	0x002807c7, // n0x111a c0x0000 (---------------)  + I england
	0x0032c2ca, // n0x111b c0x0000 (---------------)  + I entomology
	0x0020ea0b, // n0x111c c0x0000 (---------------)  + I environment
	0x0020ea19, // n0x111d c0x0000 (---------------)  + I environmentalconservation
	0x00216148, // n0x111e c0x0000 (---------------)  + I epilepsy
	0x00248845, // n0x111f c0x0000 (---------------)  + I essex
	0x00284b06, // n0x1120 c0x0000 (---------------)  + I estate
	0x00317a09, // n0x1121 c0x0000 (---------------)  + I ethnology
	0x003063c6, // n0x1122 c0x0000 (---------------)  + I exeter
	0x0022b18a, // n0x1123 c0x0000 (---------------)  + I exhibition
	0x00325d06, // n0x1124 c0x0000 (---------------)  + I family
	0x00317f84, // n0x1125 c0x0000 (---------------)  + I farm
	0x00356e0d, // n0x1126 c0x0000 (---------------)  + I farmequipment
	0x00317f87, // n0x1127 c0x0000 (---------------)  + I farmers
	0x00366949, // n0x1128 c0x0000 (---------------)  + I farmstead
	0x00242205, // n0x1129 c0x0000 (---------------)  + I field
	0x00242348, // n0x112a c0x0000 (---------------)  + I figueres
	0x00242a89, // n0x112b c0x0000 (---------------)  + I filatelia
	0x00242cc4, // n0x112c c0x0000 (---------------)  + I film
	0x00244107, // n0x112d c0x0000 (---------------)  + I fineart
	0x00244108, // n0x112e c0x0000 (---------------)  + I finearts
	0x002443c7, // n0x112f c0x0000 (---------------)  + I finland
	0x0033e2c8, // n0x1130 c0x0000 (---------------)  + I flanders
	0x0024c787, // n0x1131 c0x0000 (---------------)  + I florida
	0x0024ce85, // n0x1132 c0x0000 (---------------)  + I force
	0x0025654c, // n0x1133 c0x0000 (---------------)  + I fortmissoula
	0x00257849, // n0x1134 c0x0000 (---------------)  + I fortworth
	0x0031f98a, // n0x1135 c0x0000 (---------------)  + I foundation
	0x00356049, // n0x1136 c0x0000 (---------------)  + I francaise
	0x002ec889, // n0x1137 c0x0000 (---------------)  + I frankfurt
	0x0033db8c, // n0x1138 c0x0000 (---------------)  + I franziskaner
	0x0021244b, // n0x1139 c0x0000 (---------------)  + I freemasonry
	0x002593c8, // n0x113a c0x0000 (---------------)  + I freiburg
	0x00259b88, // n0x113b c0x0000 (---------------)  + I fribourg
	0x0025da04, // n0x113c c0x0000 (---------------)  + I frog
	0x0027eb88, // n0x113d c0x0000 (---------------)  + I fundacio
	0x0027f6c9, // n0x113e c0x0000 (---------------)  + I furniture
	0x00236f07, // n0x113f c0x0000 (---------------)  + I gallery
	0x00203ac6, // n0x1140 c0x0000 (---------------)  + I garden
	0x002314c7, // n0x1141 c0x0000 (---------------)  + I gateway
	0x00315bc9, // n0x1142 c0x0000 (---------------)  + I geelvinck
	0x00313d8b, // n0x1143 c0x0000 (---------------)  + I gemological
	0x00319187, // n0x1144 c0x0000 (---------------)  + I geology
	0x0021f547, // n0x1145 c0x0000 (---------------)  + I georgia
	0x00280687, // n0x1146 c0x0000 (---------------)  + I giessen
	0x0020cb44, // n0x1147 c0x0000 (---------------)  + I glas
	0x0020cb45, // n0x1148 c0x0000 (---------------)  + I glass
	0x00246245, // n0x1149 c0x0000 (---------------)  + I gorge
	0x0031b38b, // n0x114a c0x0000 (---------------)  + I grandrapids
	0x0035c244, // n0x114b c0x0000 (---------------)  + I graz
	0x00243d48, // n0x114c c0x0000 (---------------)  + I guernsey
	0x002a6d4a, // n0x114d c0x0000 (---------------)  + I halloffame
	0x00203087, // n0x114e c0x0000 (---------------)  + I hamburg
	0x00285a87, // n0x114f c0x0000 (---------------)  + I handson
	0x00288252, // n0x1150 c0x0000 (---------------)  + I harvestcelebration
	0x0028b446, // n0x1151 c0x0000 (---------------)  + I hawaii
	0x00360806, // n0x1152 c0x0000 (---------------)  + I health
	0x0030248e, // n0x1153 c0x0000 (---------------)  + I heimatunduhren
	0x002ebf86, // n0x1154 c0x0000 (---------------)  + I hellas
	0x002131c8, // n0x1155 c0x0000 (---------------)  + I helsinki
	0x0024ef4f, // n0x1156 c0x0000 (---------------)  + I hembygdsforbund
	0x0020cf88, // n0x1157 c0x0000 (---------------)  + I heritage
	0x0026dbc8, // n0x1158 c0x0000 (---------------)  + I histoire
	0x002e4bca, // n0x1159 c0x0000 (---------------)  + I historical
	0x002e4bd1, // n0x115a c0x0000 (---------------)  + I historicalsociety
	0x0029c84e, // n0x115b c0x0000 (---------------)  + I historichouses
	0x0025250a, // n0x115c c0x0000 (---------------)  + I historisch
	0x0025250c, // n0x115d c0x0000 (---------------)  + I historisches
	0x00233dc7, // n0x115e c0x0000 (---------------)  + I history
	0x00233dd0, // n0x115f c0x0000 (---------------)  + I historyofscience
	0x00200b88, // n0x1160 c0x0000 (---------------)  + I horology
	0x00227d05, // n0x1161 c0x0000 (---------------)  + I house
	0x002a814a, // n0x1162 c0x0000 (---------------)  + I humanities
	0x0020540c, // n0x1163 c0x0000 (---------------)  + I illustration
	0x002d9a4d, // n0x1164 c0x0000 (---------------)  + I imageandsound
	0x00214b06, // n0x1165 c0x0000 (---------------)  + I indian
	0x00214b07, // n0x1166 c0x0000 (---------------)  + I indiana
	0x00214b0c, // n0x1167 c0x0000 (---------------)  + I indianapolis
	0x0021794c, // n0x1168 c0x0000 (---------------)  + I indianmarket
	0x00223a8c, // n0x1169 c0x0000 (---------------)  + I intelligence
	0x002df74b, // n0x116a c0x0000 (---------------)  + I interactive
	0x00280004, // n0x116b c0x0000 (---------------)  + I iraq
	0x0020eac4, // n0x116c c0x0000 (---------------)  + I iron
	0x00330b49, // n0x116d c0x0000 (---------------)  + I isleofman
	0x00303887, // n0x116e c0x0000 (---------------)  + I jamison
	0x0024d749, // n0x116f c0x0000 (---------------)  + I jefferson
	0x00273b49, // n0x1170 c0x0000 (---------------)  + I jerusalem
	0x00331fc7, // n0x1171 c0x0000 (---------------)  + I jewelry
	0x00336806, // n0x1172 c0x0000 (---------------)  + I jewish
	0x00336809, // n0x1173 c0x0000 (---------------)  + I jewishart
	0x0036c0c3, // n0x1174 c0x0000 (---------------)  + I jfk
	0x002481ca, // n0x1175 c0x0000 (---------------)  + I journalism
	0x0036af87, // n0x1176 c0x0000 (---------------)  + I judaica
	0x0031264b, // n0x1177 c0x0000 (---------------)  + I judygarland
	0x00346c4a, // n0x1178 c0x0000 (---------------)  + I juedisches
	0x00253884, // n0x1179 c0x0000 (---------------)  + I juif
	0x00332cc6, // n0x117a c0x0000 (---------------)  + I karate
	0x002be409, // n0x117b c0x0000 (---------------)  + I karikatur
	0x002a67c4, // n0x117c c0x0000 (---------------)  + I kids
	0x0020fd4a, // n0x117d c0x0000 (---------------)  + I koebenhavn
	0x0024c305, // n0x117e c0x0000 (---------------)  + I koeln
	0x002b2985, // n0x117f c0x0000 (---------------)  + I kunst
	0x002b298d, // n0x1180 c0x0000 (---------------)  + I kunstsammlung
	0x002b2cce, // n0x1181 c0x0000 (---------------)  + I kunstunddesign
	0x00306f05, // n0x1182 c0x0000 (---------------)  + I labor
	0x0035bb86, // n0x1183 c0x0000 (---------------)  + I labour
	0x00266947, // n0x1184 c0x0000 (---------------)  + I lajolla
	0x0025474a, // n0x1185 c0x0000 (---------------)  + I lancashire
	0x00361946, // n0x1186 c0x0000 (---------------)  + I landes
	0x00286784, // n0x1187 c0x0000 (---------------)  + I lans
	0x002e1787, // n0x1188 c0x0000 (---------------)  + I larsson
	0x002ea2cb, // n0x1189 c0x0000 (---------------)  + I lewismiller
	0x0035e287, // n0x118a c0x0000 (---------------)  + I lincoln
	0x00366d44, // n0x118b c0x0000 (---------------)  + I linz
	0x0029e246, // n0x118c c0x0000 (---------------)  + I living
	0x0029e24d, // n0x118d c0x0000 (---------------)  + I livinghistory
	0x0025624c, // n0x118e c0x0000 (---------------)  + I localhistory
	0x00207ac6, // n0x118f c0x0000 (---------------)  + I london
	0x0021d94a, // n0x1190 c0x0000 (---------------)  + I losangeles
	0x00222e46, // n0x1191 c0x0000 (---------------)  + I louvre
	0x0030ef88, // n0x1192 c0x0000 (---------------)  + I loyalist
	0x002f1407, // n0x1193 c0x0000 (---------------)  + I lucerne
	0x002363ca, // n0x1194 c0x0000 (---------------)  + I luxembourg
	0x0023f7c6, // n0x1195 c0x0000 (---------------)  + I luzern
	0x0020d983, // n0x1196 c0x0000 (---------------)  + I mad
	0x00308e86, // n0x1197 c0x0000 (---------------)  + I madrid
	0x002a0808, // n0x1198 c0x0000 (---------------)  + I mallorca
	0x00330cca, // n0x1199 c0x0000 (---------------)  + I manchester
	0x00275387, // n0x119a c0x0000 (---------------)  + I mansion
	0x00275388, // n0x119b c0x0000 (---------------)  + I mansions
	0x0027d604, // n0x119c c0x0000 (---------------)  + I manx
	0x0026a007, // n0x119d c0x0000 (---------------)  + I marburg
	0x00262748, // n0x119e c0x0000 (---------------)  + I maritime
	0x00352148, // n0x119f c0x0000 (---------------)  + I maritimo
	0x002a8d08, // n0x11a0 c0x0000 (---------------)  + I maryland
	0x0020aa4a, // n0x11a1 c0x0000 (---------------)  + I marylhurst
	0x0027ab45, // n0x11a2 c0x0000 (---------------)  + I media
	0x002f1287, // n0x11a3 c0x0000 (---------------)  + I medical
	0x00252353, // n0x11a4 c0x0000 (---------------)  + I medizinhistorisches
	0x00267786, // n0x11a5 c0x0000 (---------------)  + I meeres
	0x00242d88, // n0x11a6 c0x0000 (---------------)  + I memorial
	0x002fa609, // n0x11a7 c0x0000 (---------------)  + I mesaverde
	0x00226188, // n0x11a8 c0x0000 (---------------)  + I michigan
	0x00265c8b, // n0x11a9 c0x0000 (---------------)  + I midatlantic
	0x00343e88, // n0x11aa c0x0000 (---------------)  + I military
	0x0023f704, // n0x11ab c0x0000 (---------------)  + I mill
	0x0035ea06, // n0x11ac c0x0000 (---------------)  + I miners
	0x002cc806, // n0x11ad c0x0000 (---------------)  + I mining
	0x002d1849, // n0x11ae c0x0000 (---------------)  + I minnesota
	0x002bbd47, // n0x11af c0x0000 (---------------)  + I missile
	0x00256648, // n0x11b0 c0x0000 (---------------)  + I missoula
	0x00286346, // n0x11b1 c0x0000 (---------------)  + I modern
	0x002e6b84, // n0x11b2 c0x0000 (---------------)  + I moma
	0x002c2a45, // n0x11b3 c0x0000 (---------------)  + I money
	0x002bec48, // n0x11b4 c0x0000 (---------------)  + I monmouth
	0x002bf38a, // n0x11b5 c0x0000 (---------------)  + I monticello
	0x002bfc08, // n0x11b6 c0x0000 (---------------)  + I montreal
	0x002c3106, // n0x11b7 c0x0000 (---------------)  + I moscow
	0x00294a4a, // n0x11b8 c0x0000 (---------------)  + I motorcycle
	0x00319b48, // n0x11b9 c0x0000 (---------------)  + I muenchen
	0x002c5888, // n0x11ba c0x0000 (---------------)  + I muenster
	0x002c7ac8, // n0x11bb c0x0000 (---------------)  + I mulhouse
	0x002c8d86, // n0x11bc c0x0000 (---------------)  + I muncie
	0x002cab06, // n0x11bd c0x0000 (---------------)  + I museet
	0x002e828c, // n0x11be c0x0000 (---------------)  + I museumcenter
	0x002cb0d0, // n0x11bf c0x0000 (---------------)  + I museumvereniging
	0x002a91c5, // n0x11c0 c0x0000 (---------------)  + I music
	0x0020cd88, // n0x11c1 c0x0000 (---------------)  + I national
	0x002251d0, // n0x11c2 c0x0000 (---------------)  + I nationalfirearms
	0x0020cd90, // n0x11c3 c0x0000 (---------------)  + I nationalheritage
	0x002c6e8e, // n0x11c4 c0x0000 (---------------)  + I nativeamerican
	0x002e7f0e, // n0x11c5 c0x0000 (---------------)  + I naturalhistory
	0x002e7f14, // n0x11c6 c0x0000 (---------------)  + I naturalhistorymuseum
	0x0036e38f, // n0x11c7 c0x0000 (---------------)  + I naturalsciences
	0x0036e746, // n0x11c8 c0x0000 (---------------)  + I nature
	0x00327f51, // n0x11c9 c0x0000 (---------------)  + I naturhistorisches
	0x0030e713, // n0x11ca c0x0000 (---------------)  + I natuurwetenschappen
	0x0030eb88, // n0x11cb c0x0000 (---------------)  + I naumburg
	0x003682c5, // n0x11cc c0x0000 (---------------)  + I naval
	0x0030ad08, // n0x11cd c0x0000 (---------------)  + I nebraska
	0x0025e705, // n0x11ce c0x0000 (---------------)  + I neues
	0x0022750c, // n0x11cf c0x0000 (---------------)  + I newhampshire
	0x002abcc9, // n0x11d0 c0x0000 (---------------)  + I newjersey
	0x0029fbc9, // n0x11d1 c0x0000 (---------------)  + I newmexico
	0x00231247, // n0x11d2 c0x0000 (---------------)  + I newport
	0x0023fc09, // n0x11d3 c0x0000 (---------------)  + I newspaper
	0x0020b807, // n0x11d4 c0x0000 (---------------)  + I newyork
	0x002e6446, // n0x11d5 c0x0000 (---------------)  + I niepce
	0x00239f87, // n0x11d6 c0x0000 (---------------)  + I norfolk
	0x002f0f85, // n0x11d7 c0x0000 (---------------)  + I north
	0x00323643, // n0x11d8 c0x0000 (---------------)  + I nrw
	0x00343349, // n0x11d9 c0x0000 (---------------)  + I nuernberg
	0x00322249, // n0x11da c0x0000 (---------------)  + I nuremberg
	0x00215183, // n0x11db c0x0000 (---------------)  + I nyc
	0x0027a004, // n0x11dc c0x0000 (---------------)  + I nyny
	0x00205a4d, // n0x11dd c0x0000 (---------------)  + I oceanographic
	0x0020644f, // n0x11de c0x0000 (---------------)  + I oceanographique
	0x002feec5, // n0x11df c0x0000 (---------------)  + I omaha
	0x0030ac06, // n0x11e0 c0x0000 (---------------)  + I online
	0x00230247, // n0x11e1 c0x0000 (---------------)  + I ontario
	0x00310287, // n0x11e2 c0x0000 (---------------)  + I openair
	0x00282406, // n0x11e3 c0x0000 (---------------)  + I oregon
	0x0028240b, // n0x11e4 c0x0000 (---------------)  + I oregontrail
	0x0029da85, // n0x11e5 c0x0000 (---------------)  + I otago
	0x00366086, // n0x11e6 c0x0000 (---------------)  + I oxford
	0x0026cdc7, // n0x11e7 c0x0000 (---------------)  + I pacific
	0x00236909, // n0x11e8 c0x0000 (---------------)  + I paderborn
	0x002e8946, // n0x11e9 c0x0000 (---------------)  + I palace
	0x00360b85, // n0x11ea c0x0000 (---------------)  + I paleo
	0x00369acb, // n0x11eb c0x0000 (---------------)  + I palmsprings
	0x002001c6, // n0x11ec c0x0000 (---------------)  + I panama
	0x0024dcc5, // n0x11ed c0x0000 (---------------)  + I paris
	0x00287848, // n0x11ee c0x0000 (---------------)  + I pasadena
	0x002cfb08, // n0x11ef c0x0000 (---------------)  + I pharmacy
	0x002cc98c, // n0x11f0 c0x0000 (---------------)  + I philadelphia
	0x002cc990, // n0x11f1 c0x0000 (---------------)  + I philadelphiaarea
	0x002cd049, // n0x11f2 c0x0000 (---------------)  + I philately
	0x002cd287, // n0x11f3 c0x0000 (---------------)  + I phoenix
	0x002ce1cb, // n0x11f4 c0x0000 (---------------)  + I photography
	0x002cf086, // n0x11f5 c0x0000 (---------------)  + I pilots
	0x002d030a, // n0x11f6 c0x0000 (---------------)  + I pittsburgh
	0x002d15cb, // n0x11f7 c0x0000 (---------------)  + I planetarium
	0x002d1e8a, // n0x11f8 c0x0000 (---------------)  + I plantation
	0x002d2106, // n0x11f9 c0x0000 (---------------)  + I plants
	0x002d2905, // n0x11fa c0x0000 (---------------)  + I plaza
	0x00312386, // n0x11fb c0x0000 (---------------)  + I portal
	0x00352708, // n0x11fc c0x0000 (---------------)  + I portland
	0x0023130a, // n0x11fd c0x0000 (---------------)  + I portlligat
	0x002d6fdc, // n0x11fe c0x0000 (---------------)  + I posts-and-telecommunications
	0x002d7bcc, // n0x11ff c0x0000 (---------------)  + I preservation
	0x002d7ec8, // n0x1200 c0x0000 (---------------)  + I presidio
	0x002487c5, // n0x1201 c0x0000 (---------------)  + I press
	0x002da787, // n0x1202 c0x0000 (---------------)  + I project
	0x002aa586, // n0x1203 c0x0000 (---------------)  + I public
	0x00200f45, // n0x1204 c0x0000 (---------------)  + I pubol
	0x00215b86, // n0x1205 c0x0000 (---------------)  + I quebec
	0x002825c8, // n0x1206 c0x0000 (---------------)  + I railroad
	0x0034e887, // n0x1207 c0x0000 (---------------)  + I railway
	0x002aa848, // n0x1208 c0x0000 (---------------)  + I research
	0x002d930a, // n0x1209 c0x0000 (---------------)  + I resistance
	0x0023034c, // n0x120a c0x0000 (---------------)  + I riodejaneiro
	0x0022d189, // n0x120b c0x0000 (---------------)  + I rochester
	0x00201287, // n0x120c c0x0000 (---------------)  + I rockart
	0x00247304, // n0x120d c0x0000 (---------------)  + I roma
	0x00259246, // n0x120e c0x0000 (---------------)  + I russia
	0x002f474a, // n0x120f c0x0000 (---------------)  + I saintlouis
	0x00273c45, // n0x1210 c0x0000 (---------------)  + I salem
	0x0022558c, // n0x1211 c0x0000 (---------------)  + I salvadordali
	0x00225e08, // n0x1212 c0x0000 (---------------)  + I salzburg
	0x00347488, // n0x1213 c0x0000 (---------------)  + I sandiego
	0x0024e60c, // n0x1214 c0x0000 (---------------)  + I sanfrancisco
	0x002a0fcc, // n0x1215 c0x0000 (---------------)  + I santabarbara
	0x0022c489, // n0x1216 c0x0000 (---------------)  + I santacruz
	0x0022e287, // n0x1217 c0x0000 (---------------)  + I santafe
	0x0025858c, // n0x1218 c0x0000 (---------------)  + I saskatchewan
	0x0025db84, // n0x1219 c0x0000 (---------------)  + I satx
	0x002689ca, // n0x121a c0x0000 (---------------)  + I savannahga
	0x0026e40c, // n0x121b c0x0000 (---------------)  + I schlesisches
	0x002814cb, // n0x121c c0x0000 (---------------)  + I schoenbrunn
	0x002bf0cb, // n0x121d c0x0000 (---------------)  + I schokoladen
	0x002ffb06, // n0x121e c0x0000 (---------------)  + I school
	0x00286847, // n0x121f c0x0000 (---------------)  + I schweiz
	0x00234007, // n0x1220 c0x0000 (---------------)  + I science
	0x0023400f, // n0x1221 c0x0000 (---------------)  + I science-fiction
	0x002eded1, // n0x1222 c0x0000 (---------------)  + I scienceandhistory
	0x002734d2, // n0x1223 c0x0000 (---------------)  + I scienceandindustry
	0x0028970d, // n0x1224 c0x0000 (---------------)  + I sciencecenter
	0x0028970e, // n0x1225 c0x0000 (---------------)  + I sciencecenters
	0x00289a4e, // n0x1226 c0x0000 (---------------)  + I sciencehistory
	0x0036e548, // n0x1227 c0x0000 (---------------)  + I sciences
	0x0036e552, // n0x1228 c0x0000 (---------------)  + I sciencesnaturelles
	0x0024e848, // n0x1229 c0x0000 (---------------)  + I scotland
	0x002f9687, // n0x122a c0x0000 (---------------)  + I seaport
	0x0024908a, // n0x122b c0x0000 (---------------)  + I settlement
	0x002a0e08, // n0x122c c0x0000 (---------------)  + I settlers
	0x002ebf45, // n0x122d c0x0000 (---------------)  + I shell
	0x002f5a8a, // n0x122e c0x0000 (---------------)  + I sherbrooke
	0x00204707, // n0x122f c0x0000 (---------------)  + I sibenik
	0x002eeb44, // n0x1230 c0x0000 (---------------)  + I silk
	0x0021a9c3, // n0x1231 c0x0000 (---------------)  + I ski
	0x0024d1c5, // n0x1232 c0x0000 (---------------)  + I skole
	0x002e4e47, // n0x1233 c0x0000 (---------------)  + I society
	0x002e1947, // n0x1234 c0x0000 (---------------)  + I sologne
	0x002d9c4e, // n0x1235 c0x0000 (---------------)  + I soundandvision
	0x002e518d, // n0x1236 c0x0000 (---------------)  + I southcarolina
	0x002e55c9, // n0x1237 c0x0000 (---------------)  + I southwest
	0x002e5c85, // n0x1238 c0x0000 (---------------)  + I space
	0x002e9343, // n0x1239 c0x0000 (---------------)  + I spy
	0x0025e806, // n0x123a c0x0000 (---------------)  + I square
	0x002638c5, // n0x123b c0x0000 (---------------)  + I stadt
	0x002d69c8, // n0x123c c0x0000 (---------------)  + I stalbans
	0x002d3ac9, // n0x123d c0x0000 (---------------)  + I starnberg
	0x00284b45, // n0x123e c0x0000 (---------------)  + I state
	0x002bfe4f, // n0x123f c0x0000 (---------------)  + I stateofdelaware
	0x002f0787, // n0x1240 c0x0000 (---------------)  + I station
	0x0021b105, // n0x1241 c0x0000 (---------------)  + I steam
	0x002feb4a, // n0x1242 c0x0000 (---------------)  + I steiermark
	0x002bcbc6, // n0x1243 c0x0000 (---------------)  + I stjohn
	0x0020ac49, // n0x1244 c0x0000 (---------------)  + I stockholm
	0x002e9d4c, // n0x1245 c0x0000 (---------------)  + I stpetersburg
	0x002ea589, // n0x1246 c0x0000 (---------------)  + I stuttgart
	0x00216c06, // n0x1247 c0x0000 (---------------)  + I suisse
	0x002a6b4c, // n0x1248 c0x0000 (---------------)  + I surgeonshall
	0x002eab06, // n0x1249 c0x0000 (---------------)  + I surrey
	0x002ed3c8, // n0x124a c0x0000 (---------------)  + I svizzera
	0x002d6b86, // n0x124b c0x0000 (---------------)  + I sweden
	0x00263106, // n0x124c c0x0000 (---------------)  + I sydney
	0x002dcb44, // n0x124d c0x0000 (---------------)  + I tank
	0x0025fe83, // n0x124e c0x0000 (---------------)  + I tcm
	0x00301d8a, // n0x124f c0x0000 (---------------)  + I technology
	0x0024ab11, // n0x1250 c0x0000 (---------------)  + I telekommunikation
	0x00238cca, // n0x1251 c0x0000 (---------------)  + I television
	0x0023e645, // n0x1252 c0x0000 (---------------)  + I texas
	0x00267107, // n0x1253 c0x0000 (---------------)  + I textile
	0x002e7907, // n0x1254 c0x0000 (---------------)  + I theater
	0x00262844, // n0x1255 c0x0000 (---------------)  + I time
	0x0026284b, // n0x1256 c0x0000 (---------------)  + I timekeeping
	0x002997c8, // n0x1257 c0x0000 (---------------)  + I topology
	0x002afbc6, // n0x1258 c0x0000 (---------------)  + I torino
	0x0022e985, // n0x1259 c0x0000 (---------------)  + I touch
	0x002ed844, // n0x125a c0x0000 (---------------)  + I town
	0x00293ac9, // n0x125b c0x0000 (---------------)  + I transport
	0x002a8044, // n0x125c c0x0000 (---------------)  + I tree
	0x0027fd07, // n0x125d c0x0000 (---------------)  + I trolley
	0x002ee8c5, // n0x125e c0x0000 (---------------)  + I trust
	0x002ee8c7, // n0x125f c0x0000 (---------------)  + I trustee
	0x003026c5, // n0x1260 c0x0000 (---------------)  + I uhren
	0x00207343, // n0x1261 c0x0000 (---------------)  + I ulm
	0x002f9548, // n0x1262 c0x0000 (---------------)  + I undersea
	0x003688ca, // n0x1263 c0x0000 (---------------)  + I university
	0x00220203, // n0x1264 c0x0000 (---------------)  + I usa
	0x0023270a, // n0x1265 c0x0000 (---------------)  + I usantiques
	0x0036b746, // n0x1266 c0x0000 (---------------)  + I usarts
	0x002848cf, // n0x1267 c0x0000 (---------------)  + I uscountryestate
	0x0034f9c9, // n0x1268 c0x0000 (---------------)  + I usculture
	0x00318290, // n0x1269 c0x0000 (---------------)  + I usdecorativearts
	0x00242888, // n0x126a c0x0000 (---------------)  + I usgarden
	0x002c3409, // n0x126b c0x0000 (---------------)  + I ushistory
	0x002134c7, // n0x126c c0x0000 (---------------)  + I ushuaia
	0x0029e1cf, // n0x126d c0x0000 (---------------)  + I uslivinghistory
	0x00375044, // n0x126e c0x0000 (---------------)  + I utah
	0x00369004, // n0x126f c0x0000 (---------------)  + I uvic
	0x00216a46, // n0x1270 c0x0000 (---------------)  + I valley
	0x002d3f46, // n0x1271 c0x0000 (---------------)  + I vantaa
	0x002f2a8a, // n0x1272 c0x0000 (---------------)  + I versailles
	0x0027c406, // n0x1273 c0x0000 (---------------)  + I viking
	0x0030c487, // n0x1274 c0x0000 (---------------)  + I village
	0x002f7788, // n0x1275 c0x0000 (---------------)  + I virginia
	0x002f7987, // n0x1276 c0x0000 (---------------)  + I virtual
	0x002f7b47, // n0x1277 c0x0000 (---------------)  + I virtuel
	0x0032b58a, // n0x1278 c0x0000 (---------------)  + I vlaanderen
	0x002f938b, // n0x1279 c0x0000 (---------------)  + I volkenkunde
	0x002d0105, // n0x127a c0x0000 (---------------)  + I wales
	0x00273108, // n0x127b c0x0000 (---------------)  + I wallonie
	0x00202383, // n0x127c c0x0000 (---------------)  + I war
	0x003459cc, // n0x127d c0x0000 (---------------)  + I washingtondc
	0x0020054f, // n0x127e c0x0000 (---------------)  + I watch-and-clock
	0x0028c68d, // n0x127f c0x0000 (---------------)  + I watchandclock
	0x002e5707, // n0x1280 c0x0000 (---------------)  + I western
	0x00209089, // n0x1281 c0x0000 (---------------)  + I westfalen
	0x0021e247, // n0x1282 c0x0000 (---------------)  + I whaling
	0x003236c8, // n0x1283 c0x0000 (---------------)  + I wildlife
	0x0023188c, // n0x1284 c0x0000 (---------------)  + I williamsburg
	0x0023f608, // n0x1285 c0x0000 (---------------)  + I windmill
	0x0024f488, // n0x1286 c0x0000 (---------------)  + I workshop
	0x002ffe0e, // n0x1287 c0x0000 (---------------)  + I xn--9dbhblg6di
	0x0030d3d4, // n0x1288 c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x0030d8e4, // n0x1289 c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x00325e8a, // n0x128a c0x0000 (---------------)  + I xn--h1aegh
	0x00337b8b, // n0x128b c0x0000 (---------------)  + I xn--lns-qla
	0x0020b8c4, // n0x128c c0x0000 (---------------)  + I york
	0x0020b8c9, // n0x128d c0x0000 (---------------)  + I yorkshire
	0x002cdfc8, // n0x128e c0x0000 (---------------)  + I yosemite
	0x00342085, // n0x128f c0x0000 (---------------)  + I youth
	0x0036a64a, // n0x1290 c0x0000 (---------------)  + I zoological
	0x0025e9c7, // n0x1291 c0x0000 (---------------)  + I zoology
	0x0027a1c4, // n0x1292 c0x0000 (---------------)  + I aero
	0x00314c43, // n0x1293 c0x0000 (---------------)  + I biz
	0x00222603, // n0x1294 c0x0000 (---------------)  + I com
	0x00239dc4, // n0x1295 c0x0000 (---------------)  + I coop
	0x0027a643, // n0x1296 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1297 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x1298 c0x0000 (---------------)  + I info
	0x00223a83, // n0x1299 c0x0000 (---------------)  + I int
	0x0023f703, // n0x129a c0x0000 (---------------)  + I mil
	0x002cb0c6, // n0x129b c0x0000 (---------------)  + I museum
	0x0022aec4, // n0x129c c0x0000 (---------------)  + I name
	0x00201603, // n0x129d c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x129e c0x0000 (---------------)  + I org
	0x002d8443, // n0x129f c0x0000 (---------------)  + I pro
	0x00201d82, // n0x12a0 c0x0000 (---------------)  + I ac
	0x00314c43, // n0x12a1 c0x0000 (---------------)  + I biz
	0x00207a02, // n0x12a2 c0x0000 (---------------)  + I co
	0x00222603, // n0x12a3 c0x0000 (---------------)  + I com
	0x00239dc4, // n0x12a4 c0x0000 (---------------)  + I coop
	0x0027a643, // n0x12a5 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x12a6 c0x0000 (---------------)  + I gov
	0x00223a83, // n0x12a7 c0x0000 (---------------)  + I int
	0x002cb0c6, // n0x12a8 c0x0000 (---------------)  + I museum
	0x00201603, // n0x12a9 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x12aa c0x0000 (---------------)  + I org
	0x000b8948, // n0x12ab c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x12ac c0x0000 (---------------)  + I com
	0x0027a643, // n0x12ad c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x12ae c0x0000 (---------------)  + I gob
	0x00201603, // n0x12af c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x12b0 c0x0000 (---------------)  + I org
	0x00222603, // n0x12b1 c0x0000 (---------------)  + I com
	0x0027a643, // n0x12b2 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x12b3 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x12b4 c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x12b5 c0x0000 (---------------)  + I name
	0x00201603, // n0x12b6 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x12b7 c0x0000 (---------------)  + I org
	0x006a7608, // n0x12b8 c0x0001 (---------------)  ! I teledata
	0x0020bc02, // n0x12b9 c0x0000 (---------------)  + I ca
	0x00219f02, // n0x12ba c0x0000 (---------------)  + I cc
	0x00207a02, // n0x12bb c0x0000 (---------------)  + I co
	0x00222603, // n0x12bc c0x0000 (---------------)  + I com
	0x00203982, // n0x12bd c0x0000 (---------------)  + I dr
	0x002015c2, // n0x12be c0x0000 (---------------)  + I in
	0x0021c704, // n0x12bf c0x0000 (---------------)  + I info
	0x0020e884, // n0x12c0 c0x0000 (---------------)  + I mobi
	0x0022ad42, // n0x12c1 c0x0000 (---------------)  + I mx
	0x0022aec4, // n0x12c2 c0x0000 (---------------)  + I name
	0x00200bc2, // n0x12c3 c0x0000 (---------------)  + I or
	0x0021f5c3, // n0x12c4 c0x0000 (---------------)  + I org
	0x002d8443, // n0x12c5 c0x0000 (---------------)  + I pro
	0x002ffb06, // n0x12c6 c0x0000 (---------------)  + I school
	0x00292602, // n0x12c7 c0x0000 (---------------)  + I tv
	0x002054c2, // n0x12c8 c0x0000 (---------------)  + I us
	0x00208182, // n0x12c9 c0x0000 (---------------)  + I ws
	0x3320cf83, // n0x12ca c0x00cc (n0x12cc-n0x12cd)  o I her
	0x33633dc3, // n0x12cb c0x00cd (n0x12cd-n0x12ce)  o I his
	0x00053046, // n0x12cc c0x0000 (---------------)  +   forgot
	0x00053046, // n0x12cd c0x0000 (---------------)  +   forgot
	0x0029cfc4, // n0x12ce c0x0000 (---------------)  + I asso
	0x0010894c, // n0x12cf c0x0000 (---------------)  +   at-band-camp
	0x0006460c, // n0x12d0 c0x0000 (---------------)  +   azure-mobile
	0x000bddcd, // n0x12d1 c0x0000 (---------------)  +   azurewebsites
	0x00010dc7, // n0x12d2 c0x0000 (---------------)  +   blogdns
	0x0001c908, // n0x12d3 c0x0000 (---------------)  +   broke-it
	0x00027c0a, // n0x12d4 c0x0000 (---------------)  +   buyshouses
	0x00087688, // n0x12d5 c0x0000 (---------------)  +   cloudapp
	0x0003008a, // n0x12d6 c0x0000 (---------------)  +   cloudfront
	0x00035348, // n0x12d7 c0x0000 (---------------)  +   dnsalias
	0x0000b0c7, // n0x12d8 c0x0000 (---------------)  +   dnsdojo
	0x0013ec07, // n0x12d9 c0x0000 (---------------)  +   does-it
	0x000cd889, // n0x12da c0x0000 (---------------)  +   dontexist
	0x0009fe08, // n0x12db c0x0000 (---------------)  +   dynalias
	0x0001fd09, // n0x12dc c0x0000 (---------------)  +   dynathome
	0x000a71cd, // n0x12dd c0x0000 (---------------)  +   endofinternet
	0x342ba8c6, // n0x12de c0x00d0 (n0x12fe-n0x1300)  o I fastly
	0x00060c47, // n0x12df c0x0000 (---------------)  +   from-az
	0x00061b47, // n0x12e0 c0x0000 (---------------)  +   from-co
	0x00066807, // n0x12e1 c0x0000 (---------------)  +   from-la
	0x0006c147, // n0x12e2 c0x0000 (---------------)  +   from-ny
	0x0000fb02, // n0x12e3 c0x0000 (---------------)  +   gb
	0x00046307, // n0x12e4 c0x0000 (---------------)  +   gets-it
	0x0004a68c, // n0x12e5 c0x0000 (---------------)  +   ham-radio-op
	0x00019d07, // n0x12e6 c0x0000 (---------------)  +   homeftp
	0x000c84c6, // n0x12e7 c0x0000 (---------------)  +   homeip
	0x0009f1c9, // n0x12e8 c0x0000 (---------------)  +   homelinux
	0x000a1908, // n0x12e9 c0x0000 (---------------)  +   homeunix
	0x00001e02, // n0x12ea c0x0000 (---------------)  +   hu
	0x000015c2, // n0x12eb c0x0000 (---------------)  +   in
	0x0006514b, // n0x12ec c0x0000 (---------------)  +   in-the-band
	0x001402c9, // n0x12ed c0x0000 (---------------)  +   is-a-chef
	0x00067d49, // n0x12ee c0x0000 (---------------)  +   is-a-geek
	0x0014bd08, // n0x12ef c0x0000 (---------------)  +   isa-geek
	0x000a9f42, // n0x12f0 c0x0000 (---------------)  +   jp
	0x00047a09, // n0x12f1 c0x0000 (---------------)  +   kicks-ass
	0x0001ef4d, // n0x12f2 c0x0000 (---------------)  +   office-on-the
	0x000d4e47, // n0x12f3 c0x0000 (---------------)  +   podzone
	0x00092f4d, // n0x12f4 c0x0000 (---------------)  +   scrapper-site
	0x00006d42, // n0x12f5 c0x0000 (---------------)  +   se
	0x000ff606, // n0x12f6 c0x0000 (---------------)  +   selfip
	0x000b5ac8, // n0x12f7 c0x0000 (---------------)  +   sells-it
	0x00016d08, // n0x12f8 c0x0000 (---------------)  +   servebbs
	0x0009cb88, // n0x12f9 c0x0000 (---------------)  +   serveftp
	0x0004fc08, // n0x12fa c0x0000 (---------------)  +   thruhere
	0x00000402, // n0x12fb c0x0000 (---------------)  +   uk
	0x0004db86, // n0x12fc c0x0000 (---------------)  +   webhop
	0x00003502, // n0x12fd c0x0000 (---------------)  +   za
	0x346d86c4, // n0x12fe c0x00d1 (n0x1300-n0x1302)  o I prod
	0x34a8d983, // n0x12ff c0x00d2 (n0x1302-n0x1305)  o I ssl
	0x00000101, // n0x1300 c0x0000 (---------------)  +   a
	0x00017cc6, // n0x1301 c0x0000 (---------------)  +   global
	0x00000101, // n0x1302 c0x0000 (---------------)  +   a
	0x00000001, // n0x1303 c0x0000 (---------------)  +   b
	0x00017cc6, // n0x1304 c0x0000 (---------------)  +   global
	0x002180c4, // n0x1305 c0x0000 (---------------)  + I arts
	0x00222603, // n0x1306 c0x0000 (---------------)  + I com
	0x00245bc4, // n0x1307 c0x0000 (---------------)  + I firm
	0x0021c704, // n0x1308 c0x0000 (---------------)  + I info
	0x00201603, // n0x1309 c0x0000 (---------------)  + I net
	0x00369845, // n0x130a c0x0000 (---------------)  + I other
	0x00222483, // n0x130b c0x0000 (---------------)  + I per
	0x00227783, // n0x130c c0x0000 (---------------)  + I rec
	0x002e9885, // n0x130d c0x0000 (---------------)  + I store
	0x00205e43, // n0x130e c0x0000 (---------------)  + I web
	0x00222603, // n0x130f c0x0000 (---------------)  + I com
	0x0027a643, // n0x1310 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1311 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x1312 c0x0000 (---------------)  + I mil
	0x0020e884, // n0x1313 c0x0000 (---------------)  + I mobi
	0x0022aec4, // n0x1314 c0x0000 (---------------)  + I name
	0x00201603, // n0x1315 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1316 c0x0000 (---------------)  + I org
	0x002526c3, // n0x1317 c0x0000 (---------------)  + I sch
	0x000b8948, // n0x1318 c0x0000 (---------------)  +   blogspot
	0x00228942, // n0x1319 c0x0000 (---------------)  + I bv
	0x00007a02, // n0x131a c0x0000 (---------------)  +   co
	0x35e20742, // n0x131b c0x00d7 (n0x15f1-n0x15f2)  + I aa
	0x0036b108, // n0x131c c0x0000 (---------------)  + I aarborte
	0x00220bc6, // n0x131d c0x0000 (---------------)  + I aejrie
	0x0021ec46, // n0x131e c0x0000 (---------------)  + I afjord
	0x00220547, // n0x131f c0x0000 (---------------)  + I agdenes
	0x3620b442, // n0x1320 c0x00d8 (n0x15f2-n0x15f3)  + I ah
	0x36684748, // n0x1321 c0x00d9 (n0x15f3-n0x15f4)  o I akershus
	0x0024774a, // n0x1322 c0x0000 (---------------)  + I aknoluokta
	0x00368108, // n0x1323 c0x0000 (---------------)  + I akrehamn
	0x00202082, // n0x1324 c0x0000 (---------------)  + I al
	0x00312489, // n0x1325 c0x0000 (---------------)  + I alaheadju
	0x002d0147, // n0x1326 c0x0000 (---------------)  + I alesund
	0x00213ec6, // n0x1327 c0x0000 (---------------)  + I algard
	0x00366249, // n0x1328 c0x0000 (---------------)  + I alstahaug
	0x00313fc4, // n0x1329 c0x0000 (---------------)  + I alta
	0x00204fc6, // n0x132a c0x0000 (---------------)  + I alvdal
	0x0021b1c4, // n0x132b c0x0000 (---------------)  + I amli
	0x002070c4, // n0x132c c0x0000 (---------------)  + I amot
	0x00256089, // n0x132d c0x0000 (---------------)  + I andasuolo
	0x00346a06, // n0x132e c0x0000 (---------------)  + I andebu
	0x00372245, // n0x132f c0x0000 (---------------)  + I andoy
	0x0020c845, // n0x1330 c0x0000 (---------------)  + I ardal
	0x002c0147, // n0x1331 c0x0000 (---------------)  + I aremark
	0x0027c1c7, // n0x1332 c0x0000 (---------------)  + I arendal
	0x00287104, // n0x1333 c0x0000 (---------------)  + I arna
	0x00220786, // n0x1334 c0x0000 (---------------)  + I aseral
	0x002f2145, // n0x1335 c0x0000 (---------------)  + I asker
	0x0030f485, // n0x1336 c0x0000 (---------------)  + I askim
	0x002ec085, // n0x1337 c0x0000 (---------------)  + I askoy
	0x002f1dc7, // n0x1338 c0x0000 (---------------)  + I askvoll
	0x0035a0c5, // n0x1339 c0x0000 (---------------)  + I asnes
	0x00232349, // n0x133a c0x0000 (---------------)  + I audnedaln
	0x00316fc5, // n0x133b c0x0000 (---------------)  + I aukra
	0x00334204, // n0x133c c0x0000 (---------------)  + I aure
	0x00361887, // n0x133d c0x0000 (---------------)  + I aurland
	0x0034674e, // n0x133e c0x0000 (---------------)  + I aurskog-holand
	0x0034ca49, // n0x133f c0x0000 (---------------)  + I austevoll
	0x00302349, // n0x1340 c0x0000 (---------------)  + I austrheim
	0x00353206, // n0x1341 c0x0000 (---------------)  + I averoy
	0x00303708, // n0x1342 c0x0000 (---------------)  + I badaddja
	0x0036cd4b, // n0x1343 c0x0000 (---------------)  + I bahcavuotna
	0x00298fcc, // n0x1344 c0x0000 (---------------)  + I bahccavuotna
	0x00266bc6, // n0x1345 c0x0000 (---------------)  + I baidar
	0x002cb987, // n0x1346 c0x0000 (---------------)  + I bajddar
	0x00217d85, // n0x1347 c0x0000 (---------------)  + I balat
	0x0034968a, // n0x1348 c0x0000 (---------------)  + I balestrand
	0x002a7909, // n0x1349 c0x0000 (---------------)  + I ballangen
	0x0036c2c9, // n0x134a c0x0000 (---------------)  + I balsfjord
	0x002f0c86, // n0x134b c0x0000 (---------------)  + I bamble
	0x002ec5c5, // n0x134c c0x0000 (---------------)  + I bardu
	0x0031c405, // n0x134d c0x0000 (---------------)  + I barum
	0x00344889, // n0x134e c0x0000 (---------------)  + I batsfjord
	0x00272a8b, // n0x134f c0x0000 (---------------)  + I bearalvahki
	0x00278ec6, // n0x1350 c0x0000 (---------------)  + I beardu
	0x002a2306, // n0x1351 c0x0000 (---------------)  + I beiarn
	0x0020fa44, // n0x1352 c0x0000 (---------------)  + I berg
	0x00287f06, // n0x1353 c0x0000 (---------------)  + I bergen
	0x0020c288, // n0x1354 c0x0000 (---------------)  + I berlevag
	0x00200006, // n0x1355 c0x0000 (---------------)  + I bievat
	0x002a4346, // n0x1356 c0x0000 (---------------)  + I bindal
	0x00209748, // n0x1357 c0x0000 (---------------)  + I birkenes
	0x0020e2c7, // n0x1358 c0x0000 (---------------)  + I bjarkoy
	0x0020e649, // n0x1359 c0x0000 (---------------)  + I bjerkreim
	0x0020f6c5, // n0x135a c0x0000 (---------------)  + I bjugn
	0x000b8948, // n0x135b c0x0000 (---------------)  +   blogspot
	0x0020dc44, // n0x135c c0x0000 (---------------)  + I bodo
	0x0021cdc4, // n0x135d c0x0000 (---------------)  + I bokn
	0x00211a45, // n0x135e c0x0000 (---------------)  + I bomlo
	0x002188c9, // n0x135f c0x0000 (---------------)  + I bremanger
	0x0021d447, // n0x1360 c0x0000 (---------------)  + I bronnoy
	0x0021d44b, // n0x1361 c0x0000 (---------------)  + I bronnoysund
	0x0021f70a, // n0x1362 c0x0000 (---------------)  + I brumunddal
	0x00227445, // n0x1363 c0x0000 (---------------)  + I bryne
	0x36a03142, // n0x1364 c0x00da (n0x15f4-n0x15f5)  + I bu
	0x00346b07, // n0x1365 c0x0000 (---------------)  + I budejju
	0x36eaba88, // n0x1366 c0x00db (n0x15f5-n0x15f6)  o I buskerud
	0x002c5e87, // n0x1367 c0x0000 (---------------)  + I bygland
	0x002c5c85, // n0x1368 c0x0000 (---------------)  + I bykle
	0x0026158a, // n0x1369 c0x0000 (---------------)  + I cahcesuolo
	0x00007a02, // n0x136a c0x0000 (---------------)  +   co
	0x0020258b, // n0x136b c0x0000 (---------------)  + I davvenjarga
	0x0028bfca, // n0x136c c0x0000 (---------------)  + I davvesiida
	0x00322146, // n0x136d c0x0000 (---------------)  + I deatnu
	0x00369783, // n0x136e c0x0000 (---------------)  + I dep
	0x0030010d, // n0x136f c0x0000 (---------------)  + I dielddanuorri
	0x0031620c, // n0x1370 c0x0000 (---------------)  + I divtasvuodna
	0x0031690d, // n0x1371 c0x0000 (---------------)  + I divttasvuotna
	0x002a4ec5, // n0x1372 c0x0000 (---------------)  + I donna
	0x0032e2c5, // n0x1373 c0x0000 (---------------)  + I dovre
	0x003431c7, // n0x1374 c0x0000 (---------------)  + I drammen
	0x00366b49, // n0x1375 c0x0000 (---------------)  + I drangedal
	0x00368006, // n0x1376 c0x0000 (---------------)  + I drobak
	0x0026a345, // n0x1377 c0x0000 (---------------)  + I dyroy
	0x00230f08, // n0x1378 c0x0000 (---------------)  + I egersund
	0x00287e03, // n0x1379 c0x0000 (---------------)  + I eid
	0x003268c8, // n0x137a c0x0000 (---------------)  + I eidfjord
	0x00287e08, // n0x137b c0x0000 (---------------)  + I eidsberg
	0x002ba487, // n0x137c c0x0000 (---------------)  + I eidskog
	0x0030b008, // n0x137d c0x0000 (---------------)  + I eidsvoll
	0x00314349, // n0x137e c0x0000 (---------------)  + I eigersund
	0x002dc447, // n0x137f c0x0000 (---------------)  + I elverum
	0x0029a147, // n0x1380 c0x0000 (---------------)  + I enebakk
	0x00204b48, // n0x1381 c0x0000 (---------------)  + I engerdal
	0x0031dbc4, // n0x1382 c0x0000 (---------------)  + I etne
	0x0031dbc7, // n0x1383 c0x0000 (---------------)  + I etnedal
	0x00204508, // n0x1384 c0x0000 (---------------)  + I evenassi
	0x00210106, // n0x1385 c0x0000 (---------------)  + I evenes
	0x002294cf, // n0x1386 c0x0000 (---------------)  + I evje-og-hornnes
	0x00210a87, // n0x1387 c0x0000 (---------------)  + I farsund
	0x002d05c6, // n0x1388 c0x0000 (---------------)  + I fauske
	0x00323845, // n0x1389 c0x0000 (---------------)  + I fedje
	0x00281303, // n0x138a c0x0000 (---------------)  + I fet
	0x0034f487, // n0x138b c0x0000 (---------------)  + I fetsund
	0x00241b03, // n0x138c c0x0000 (---------------)  + I fhs
	0x00244586, // n0x138d c0x0000 (---------------)  + I finnoy
	0x00246706, // n0x138e c0x0000 (---------------)  + I fitjar
	0x00249446, // n0x138f c0x0000 (---------------)  + I fjaler
	0x0028b245, // n0x1390 c0x0000 (---------------)  + I fjell
	0x002637c3, // n0x1391 c0x0000 (---------------)  + I fla
	0x002637c8, // n0x1392 c0x0000 (---------------)  + I flakstad
	0x0034d3c9, // n0x1393 c0x0000 (---------------)  + I flatanger
	0x0024968b, // n0x1394 c0x0000 (---------------)  + I flekkefjord
	0x00249948, // n0x1395 c0x0000 (---------------)  + I flesberg
	0x0024c445, // n0x1396 c0x0000 (---------------)  + I flora
	0x0024d005, // n0x1397 c0x0000 (---------------)  + I floro
	0x37253942, // n0x1398 c0x00dc (n0x15f6-n0x15f7)  + I fm
	0x0023a049, // n0x1399 c0x0000 (---------------)  + I folkebibl
	0x00250f07, // n0x139a c0x0000 (---------------)  + I folldal
	0x00366105, // n0x139b c0x0000 (---------------)  + I forde
	0x00255f87, // n0x139c c0x0000 (---------------)  + I forsand
	0x00258446, // n0x139d c0x0000 (---------------)  + I fosnes
	0x0033b345, // n0x139e c0x0000 (---------------)  + I frana
	0x00258c0b, // n0x139f c0x0000 (---------------)  + I fredrikstad
	0x002593c4, // n0x13a0 c0x0000 (---------------)  + I frei
	0x0025e205, // n0x13a1 c0x0000 (---------------)  + I frogn
	0x0025e347, // n0x13a2 c0x0000 (---------------)  + I froland
	0x00272406, // n0x13a3 c0x0000 (---------------)  + I frosta
	0x00272845, // n0x13a4 c0x0000 (---------------)  + I froya
	0x0027ed87, // n0x13a5 c0x0000 (---------------)  + I fuoisku
	0x0027f147, // n0x13a6 c0x0000 (---------------)  + I fuossko
	0x002a4044, // n0x13a7 c0x0000 (---------------)  + I fusa
	0x002836ca, // n0x13a8 c0x0000 (---------------)  + I fylkesbibl
	0x00283b88, // n0x13a9 c0x0000 (---------------)  + I fyresdal
	0x002769c9, // n0x13aa c0x0000 (---------------)  + I gaivuotna
	0x002027c5, // n0x13ab c0x0000 (---------------)  + I galsa
	0x002191c6, // n0x13ac c0x0000 (---------------)  + I gamvik
	0x0020c44a, // n0x13ad c0x0000 (---------------)  + I gangaviika
	0x0020c746, // n0x13ae c0x0000 (---------------)  + I gaular
	0x00208687, // n0x13af c0x0000 (---------------)  + I gausdal
	0x00299acd, // n0x13b0 c0x0000 (---------------)  + I giehtavuoatna
	0x0023b849, // n0x13b1 c0x0000 (---------------)  + I gildeskal
	0x002ef6c5, // n0x13b2 c0x0000 (---------------)  + I giske
	0x0031e647, // n0x13b3 c0x0000 (---------------)  + I gjemnes
	0x0030ed48, // n0x13b4 c0x0000 (---------------)  + I gjerdrum
	0x00367888, // n0x13b5 c0x0000 (---------------)  + I gjerstad
	0x00201f47, // n0x13b6 c0x0000 (---------------)  + I gjesdal
	0x00203206, // n0x13b7 c0x0000 (---------------)  + I gjovik
	0x0021e3c7, // n0x13b8 c0x0000 (---------------)  + I gloppen
	0x0036c583, // n0x13b9 c0x0000 (---------------)  + I gol
	0x0031b384, // n0x13ba c0x0000 (---------------)  + I gran
	0x00320fc5, // n0x13bb c0x0000 (---------------)  + I grane
	0x00339107, // n0x13bc c0x0000 (---------------)  + I granvin
	0x003552c9, // n0x13bd c0x0000 (---------------)  + I gratangen
	0x0026a188, // n0x13be c0x0000 (---------------)  + I grimstad
	0x0022c1c5, // n0x13bf c0x0000 (---------------)  + I grong
	0x00237cc4, // n0x13c0 c0x0000 (---------------)  + I grue
	0x0023d085, // n0x13c1 c0x0000 (---------------)  + I gulen
	0x00244f4d, // n0x13c2 c0x0000 (---------------)  + I guovdageaidnu
	0x00200a02, // n0x13c3 c0x0000 (---------------)  + I ha
	0x00306b46, // n0x13c4 c0x0000 (---------------)  + I habmer
	0x002ff546, // n0x13c5 c0x0000 (---------------)  + I hadsel
	0x003260ca, // n0x13c6 c0x0000 (---------------)  + I hagebostad
	0x00283d86, // n0x13c7 c0x0000 (---------------)  + I halden
	0x00283f05, // n0x13c8 c0x0000 (---------------)  + I halsa
	0x00299e85, // n0x13c9 c0x0000 (---------------)  + I hamar
	0x00299e87, // n0x13ca c0x0000 (---------------)  + I hamaroy
	0x0028424c, // n0x13cb c0x0000 (---------------)  + I hammarfeasta
	0x002a304a, // n0x13cc c0x0000 (---------------)  + I hammerfest
	0x00286f06, // n0x13cd c0x0000 (---------------)  + I hapmir
	0x002bcec5, // n0x13ce c0x0000 (---------------)  + I haram
	0x00287d46, // n0x13cf c0x0000 (---------------)  + I hareid
	0x00288087, // n0x13d0 c0x0000 (---------------)  + I harstad
	0x00289546, // n0x13d1 c0x0000 (---------------)  + I hasvik
	0x0028b14c, // n0x13d2 c0x0000 (---------------)  + I hattfjelldal
	0x00366389, // n0x13d3 c0x0000 (---------------)  + I haugesund
	0x37652b07, // n0x13d4 c0x00dd (n0x15f7-n0x15fa)  o I hedmark
	0x0028d145, // n0x13d5 c0x0000 (---------------)  + I hemne
	0x0028d146, // n0x13d6 c0x0000 (---------------)  + I hemnes
	0x0028d608, // n0x13d7 c0x0000 (---------------)  + I hemsedal
	0x00267985, // n0x13d8 c0x0000 (---------------)  + I herad
	0x0029e585, // n0x13d9 c0x0000 (---------------)  + I hitra
	0x0029e7c8, // n0x13da c0x0000 (---------------)  + I hjartdal
	0x0029e9ca, // n0x13db c0x0000 (---------------)  + I hjelmeland
	0x37a6e482, // n0x13dc c0x00de (n0x15fa-n0x15fb)  + I hl
	0x37e60182, // n0x13dd c0x00df (n0x15fb-n0x15fc)  + I hm
	0x0033fa05, // n0x13de c0x0000 (---------------)  + I hobol
	0x002a4b83, // n0x13df c0x0000 (---------------)  + I hof
	0x00219988, // n0x13e0 c0x0000 (---------------)  + I hokksund
	0x0020ad83, // n0x13e1 c0x0000 (---------------)  + I hol
	0x0029ec44, // n0x13e2 c0x0000 (---------------)  + I hole
	0x0020ad8b, // n0x13e3 c0x0000 (---------------)  + I holmestrand
	0x0025f948, // n0x13e4 c0x0000 (---------------)  + I holtalen
	0x002a2888, // n0x13e5 c0x0000 (---------------)  + I honefoss
	0x38310c49, // n0x13e6 c0x00e0 (n0x15fc-n0x15fd)  o I hordaland
	0x002a59c9, // n0x13e7 c0x0000 (---------------)  + I hornindal
	0x002a70c6, // n0x13e8 c0x0000 (---------------)  + I horten
	0x002a7b48, // n0x13e9 c0x0000 (---------------)  + I hoyanger
	0x002a7d49, // n0x13ea c0x0000 (---------------)  + I hoylandet
	0x002a87c6, // n0x13eb c0x0000 (---------------)  + I hurdal
	0x002a8945, // n0x13ec c0x0000 (---------------)  + I hurum
	0x00242086, // n0x13ed c0x0000 (---------------)  + I hvaler
	0x00357f49, // n0x13ee c0x0000 (---------------)  + I hyllestad
	0x00316087, // n0x13ef c0x0000 (---------------)  + I ibestad
	0x00261186, // n0x13f0 c0x0000 (---------------)  + I idrett
	0x002edb47, // n0x13f1 c0x0000 (---------------)  + I inderoy
	0x00315447, // n0x13f2 c0x0000 (---------------)  + I iveland
	0x00243cc4, // n0x13f3 c0x0000 (---------------)  + I ivgu
	0x38617549, // n0x13f4 c0x00e1 (n0x15fd-n0x15fe)  + I jan-mayen
	0x002c18c8, // n0x13f5 c0x0000 (---------------)  + I jessheim
	0x0026b348, // n0x13f6 c0x0000 (---------------)  + I jevnaker
	0x0023c587, // n0x13f7 c0x0000 (---------------)  + I jolster
	0x002bea46, // n0x13f8 c0x0000 (---------------)  + I jondal
	0x0023b309, // n0x13f9 c0x0000 (---------------)  + I jorpeland
	0x0021ec07, // n0x13fa c0x0000 (---------------)  + I kafjord
	0x002ef9ca, // n0x13fb c0x0000 (---------------)  + I karasjohka
	0x002a6008, // n0x13fc c0x0000 (---------------)  + I karasjok
	0x0036c887, // n0x13fd c0x0000 (---------------)  + I karlsoy
	0x0036dbc6, // n0x13fe c0x0000 (---------------)  + I karmoy
	0x0022cc8a, // n0x13ff c0x0000 (---------------)  + I kautokeino
	0x0024ec48, // n0x1400 c0x0000 (---------------)  + I kirkenes
	0x0026af85, // n0x1401 c0x0000 (---------------)  + I klabu
	0x0022a745, // n0x1402 c0x0000 (---------------)  + I klepp
	0x002ae107, // n0x1403 c0x0000 (---------------)  + I kommune
	0x002c4d09, // n0x1404 c0x0000 (---------------)  + I kongsberg
	0x002c93cb, // n0x1405 c0x0000 (---------------)  + I kongsvinger
	0x002e10c8, // n0x1406 c0x0000 (---------------)  + I kopervik
	0x00317049, // n0x1407 c0x0000 (---------------)  + I kraanghke
	0x002acb07, // n0x1408 c0x0000 (---------------)  + I kragero
	0x002ae3cc, // n0x1409 c0x0000 (---------------)  + I kristiansand
	0x002ae84c, // n0x140a c0x0000 (---------------)  + I kristiansund
	0x002aeb4a, // n0x140b c0x0000 (---------------)  + I krodsherad
	0x002aedcc, // n0x140c c0x0000 (---------------)  + I krokstadelva
	0x002b9348, // n0x140d c0x0000 (---------------)  + I kvafjord
	0x002b9548, // n0x140e c0x0000 (---------------)  + I kvalsund
	0x002b9744, // n0x140f c0x0000 (---------------)  + I kvam
	0x002b9c09, // n0x1410 c0x0000 (---------------)  + I kvanangen
	0x002b9e49, // n0x1411 c0x0000 (---------------)  + I kvinesdal
	0x002ba08a, // n0x1412 c0x0000 (---------------)  + I kvinnherad
	0x002ba309, // n0x1413 c0x0000 (---------------)  + I kviteseid
	0x002ba647, // n0x1414 c0x0000 (---------------)  + I kvitsoy
	0x0024094c, // n0x1415 c0x0000 (---------------)  + I laakesvuemie
	0x0020b406, // n0x1416 c0x0000 (---------------)  + I lahppi
	0x00229e88, // n0x1417 c0x0000 (---------------)  + I langevag
	0x0020c806, // n0x1418 c0x0000 (---------------)  + I lardal
	0x002d1186, // n0x1419 c0x0000 (---------------)  + I larvik
	0x002ef5c7, // n0x141a c0x0000 (---------------)  + I lavagis
	0x00337dc8, // n0x141b c0x0000 (---------------)  + I lavangen
	0x0028024b, // n0x141c c0x0000 (---------------)  + I leangaviika
	0x002c5d47, // n0x141d c0x0000 (---------------)  + I lebesby
	0x00264889, // n0x141e c0x0000 (---------------)  + I leikanger
	0x00267249, // n0x141f c0x0000 (---------------)  + I leirfjord
	0x002bbe87, // n0x1420 c0x0000 (---------------)  + I leirvik
	0x002291c4, // n0x1421 c0x0000 (---------------)  + I leka
	0x002d5907, // n0x1422 c0x0000 (---------------)  + I leksvik
	0x0027c346, // n0x1423 c0x0000 (---------------)  + I lenvik
	0x00249506, // n0x1424 c0x0000 (---------------)  + I lerdal
	0x00221805, // n0x1425 c0x0000 (---------------)  + I lesja
	0x002a85c8, // n0x1426 c0x0000 (---------------)  + I levanger
	0x0021b244, // n0x1427 c0x0000 (---------------)  + I lier
	0x0021b246, // n0x1428 c0x0000 (---------------)  + I lierne
	0x002a2f0b, // n0x1429 c0x0000 (---------------)  + I lillehammer
	0x00347349, // n0x142a c0x0000 (---------------)  + I lillesand
	0x0030f386, // n0x142b c0x0000 (---------------)  + I lindas
	0x0034cc49, // n0x142c c0x0000 (---------------)  + I lindesnes
	0x00211b06, // n0x142d c0x0000 (---------------)  + I loabat
	0x002d5c08, // n0x142e c0x0000 (---------------)  + I lodingen
	0x00224303, // n0x142f c0x0000 (---------------)  + I lom
	0x00208805, // n0x1430 c0x0000 (---------------)  + I loppa
	0x0020c949, // n0x1431 c0x0000 (---------------)  + I lorenskog
	0x0021f945, // n0x1432 c0x0000 (---------------)  + I loten
	0x002e1b84, // n0x1433 c0x0000 (---------------)  + I lund
	0x00271a46, // n0x1434 c0x0000 (---------------)  + I lunner
	0x0022ff45, // n0x1435 c0x0000 (---------------)  + I luroy
	0x00233446, // n0x1436 c0x0000 (---------------)  + I luster
	0x002fa8c7, // n0x1437 c0x0000 (---------------)  + I lyngdal
	0x0026d246, // n0x1438 c0x0000 (---------------)  + I lyngen
	0x0029250b, // n0x1439 c0x0000 (---------------)  + I malatvuopmi
	0x0036d3c7, // n0x143a c0x0000 (---------------)  + I malselv
	0x002fcd06, // n0x143b c0x0000 (---------------)  + I malvik
	0x00334a46, // n0x143c c0x0000 (---------------)  + I mandal
	0x002c0206, // n0x143d c0x0000 (---------------)  + I marker
	0x002870c9, // n0x143e c0x0000 (---------------)  + I marnardal
	0x002f8c8a, // n0x143f c0x0000 (---------------)  + I masfjorden
	0x0032c945, // n0x1440 c0x0000 (---------------)  + I masoy
	0x00344d8d, // n0x1441 c0x0000 (---------------)  + I matta-varjjat
	0x0029eac6, // n0x1442 c0x0000 (---------------)  + I meland
	0x002a6f46, // n0x1443 c0x0000 (---------------)  + I meldal
	0x00242786, // n0x1444 c0x0000 (---------------)  + I melhus
	0x0030ef05, // n0x1445 c0x0000 (---------------)  + I meloy
	0x00284687, // n0x1446 c0x0000 (---------------)  + I meraker
	0x0027c7c7, // n0x1447 c0x0000 (---------------)  + I midsund
	0x00275d0e, // n0x1448 c0x0000 (---------------)  + I midtre-gauldal
	0x0023f703, // n0x1449 c0x0000 (---------------)  + I mil
	0x002bea09, // n0x144a c0x0000 (---------------)  + I mjondalen
	0x00309249, // n0x144b c0x0000 (---------------)  + I mo-i-rana
	0x00349a87, // n0x144c c0x0000 (---------------)  + I moareke
	0x00268687, // n0x144d c0x0000 (---------------)  + I modalen
	0x00296445, // n0x144e c0x0000 (---------------)  + I modum
	0x003696c5, // n0x144f c0x0000 (---------------)  + I molde
	0x38ae678f, // n0x1450 c0x00e2 (n0x15fe-n0x1600)  o I more-og-romsdal
	0x002c3647, // n0x1451 c0x0000 (---------------)  + I mosjoen
	0x002c3808, // n0x1452 c0x0000 (---------------)  + I moskenes
	0x002c4744, // n0x1453 c0x0000 (---------------)  + I moss
	0x002c4bc6, // n0x1454 c0x0000 (---------------)  + I mosvik
	0x38e119c2, // n0x1455 c0x00e3 (n0x1600-n0x1601)  + I mr
	0x002c9006, // n0x1456 c0x0000 (---------------)  + I muosat
	0x002cb0c6, // n0x1457 c0x0000 (---------------)  + I museum
	0x0030940e, // n0x1458 c0x0000 (---------------)  + I naamesjevuemie
	0x0032670a, // n0x1459 c0x0000 (---------------)  + I namdalseid
	0x002706c6, // n0x145a c0x0000 (---------------)  + I namsos
	0x002def0a, // n0x145b c0x0000 (---------------)  + I namsskogan
	0x002457c9, // n0x145c c0x0000 (---------------)  + I nannestad
	0x00307a85, // n0x145d c0x0000 (---------------)  + I naroy
	0x00355a88, // n0x145e c0x0000 (---------------)  + I narviika
	0x0035b646, // n0x145f c0x0000 (---------------)  + I narvik
	0x0035e408, // n0x1460 c0x0000 (---------------)  + I naustdal
	0x00203e48, // n0x1461 c0x0000 (---------------)  + I navuotna
	0x002764cb, // n0x1462 c0x0000 (---------------)  + I nedre-eiker
	0x00220645, // n0x1463 c0x0000 (---------------)  + I nesna
	0x0035a148, // n0x1464 c0x0000 (---------------)  + I nesodden
	0x0020988c, // n0x1465 c0x0000 (---------------)  + I nesoddtangen
	0x002c6947, // n0x1466 c0x0000 (---------------)  + I nesseby
	0x00248fc6, // n0x1467 c0x0000 (---------------)  + I nesset
	0x0026d388, // n0x1468 c0x0000 (---------------)  + I nissedal
	0x00204e48, // n0x1469 c0x0000 (---------------)  + I nittedal
	0x39244442, // n0x146a c0x00e4 (n0x1601-n0x1602)  + I nl
	0x0023574b, // n0x146b c0x0000 (---------------)  + I nord-aurdal
	0x002ec289, // n0x146c c0x0000 (---------------)  + I nord-fron
	0x002b0c89, // n0x146d c0x0000 (---------------)  + I nord-odal
	0x00349c87, // n0x146e c0x0000 (---------------)  + I norddal
	0x00222b48, // n0x146f c0x0000 (---------------)  + I nordkapp
	0x396f7f88, // n0x1470 c0x00e5 (n0x1602-n0x1606)  o I nordland
	0x0023aacb, // n0x1471 c0x0000 (---------------)  + I nordre-land
	0x0034bb89, // n0x1472 c0x0000 (---------------)  + I nordreisa
	0x0022f8cd, // n0x1473 c0x0000 (---------------)  + I nore-og-uvdal
	0x002502c8, // n0x1474 c0x0000 (---------------)  + I notodden
	0x00296fc8, // n0x1475 c0x0000 (---------------)  + I notteroy
	0x39a0ddc2, // n0x1476 c0x00e6 (n0x1606-n0x1607)  + I nt
	0x00321704, // n0x1477 c0x0000 (---------------)  + I odda
	0x39e1ef42, // n0x1478 c0x00e7 (n0x1607-n0x1608)  + I of
	0x0032d246, // n0x1479 c0x0000 (---------------)  + I oksnes
	0x3a200c42, // n0x147a c0x00e8 (n0x1608-n0x1609)  + I ol
	0x002e6bca, // n0x147b c0x0000 (---------------)  + I omasvuotna
	0x00311486, // n0x147c c0x0000 (---------------)  + I oppdal
	0x002da148, // n0x147d c0x0000 (---------------)  + I oppegard
	0x0028cf48, // n0x147e c0x0000 (---------------)  + I orkanger
	0x00221a46, // n0x147f c0x0000 (---------------)  + I orkdal
	0x0030a246, // n0x1480 c0x0000 (---------------)  + I orland
	0x002db946, // n0x1481 c0x0000 (---------------)  + I orskog
	0x002d6945, // n0x1482 c0x0000 (---------------)  + I orsta
	0x00206d04, // n0x1483 c0x0000 (---------------)  + I osen
	0x3a624284, // n0x1484 c0x00e9 (n0x1609-n0x160a)  + I oslo
	0x002143c6, // n0x1485 c0x0000 (---------------)  + I osoyro
	0x002681c7, // n0x1486 c0x0000 (---------------)  + I osteroy
	0x3aaef387, // n0x1487 c0x00ea (n0x160a-n0x160b)  o I ostfold
	0x0020938b, // n0x1488 c0x0000 (---------------)  + I ostre-toten
	0x002865c9, // n0x1489 c0x0000 (---------------)  + I overhalla
	0x0032e30a, // n0x148a c0x0000 (---------------)  + I ovre-eiker
	0x00309104, // n0x148b c0x0000 (---------------)  + I oyer
	0x00299fc8, // n0x148c c0x0000 (---------------)  + I oygarden
	0x00260f4d, // n0x148d c0x0000 (---------------)  + I oystre-slidre
	0x002d6309, // n0x148e c0x0000 (---------------)  + I porsanger
	0x002d6548, // n0x148f c0x0000 (---------------)  + I porsangu
	0x002d6d09, // n0x1490 c0x0000 (---------------)  + I porsgrunn
	0x002d82c4, // n0x1491 c0x0000 (---------------)  + I priv
	0x0022eec4, // n0x1492 c0x0000 (---------------)  + I rade
	0x0033ab85, // n0x1493 c0x0000 (---------------)  + I radoy
	0x0036ad4b, // n0x1494 c0x0000 (---------------)  + I rahkkeravju
	0x0025f8c6, // n0x1495 c0x0000 (---------------)  + I raholt
	0x002b1685, // n0x1496 c0x0000 (---------------)  + I raisa
	0x002770c9, // n0x1497 c0x0000 (---------------)  + I rakkestad
	0x00220848, // n0x1498 c0x0000 (---------------)  + I ralingen
	0x00268e04, // n0x1499 c0x0000 (---------------)  + I rana
	0x00349809, // n0x149a c0x0000 (---------------)  + I randaberg
	0x002b46c5, // n0x149b c0x0000 (---------------)  + I rauma
	0x0027c208, // n0x149c c0x0000 (---------------)  + I rendalen
	0x0029a807, // n0x149d c0x0000 (---------------)  + I rennebu
	0x00302748, // n0x149e c0x0000 (---------------)  + I rennesoy
	0x002be606, // n0x149f c0x0000 (---------------)  + I rindal
	0x00247e07, // n0x14a0 c0x0000 (---------------)  + I ringebu
	0x002c4089, // n0x14a1 c0x0000 (---------------)  + I ringerike
	0x00369c49, // n0x14a2 c0x0000 (---------------)  + I ringsaker
	0x0024dd45, // n0x14a3 c0x0000 (---------------)  + I risor
	0x002a4d85, // n0x14a4 c0x0000 (---------------)  + I rissa
	0x3ae0c302, // n0x14a5 c0x00eb (n0x160b-n0x160c)  + I rl
	0x00333fc4, // n0x14a6 c0x0000 (---------------)  + I roan
	0x0022c785, // n0x14a7 c0x0000 (---------------)  + I rodoy
	0x0032c086, // n0x14a8 c0x0000 (---------------)  + I rollag
	0x00357145, // n0x14a9 c0x0000 (---------------)  + I romsa
	0x002305c7, // n0x14aa c0x0000 (---------------)  + I romskog
	0x0024d0c5, // n0x14ab c0x0000 (---------------)  + I roros
	0x00208c44, // n0x14ac c0x0000 (---------------)  + I rost
	0x003532c6, // n0x14ad c0x0000 (---------------)  + I royken
	0x0026a3c7, // n0x14ae c0x0000 (---------------)  + I royrvik
	0x002cfd46, // n0x14af c0x0000 (---------------)  + I ruovat
	0x00315b05, // n0x14b0 c0x0000 (---------------)  + I rygge
	0x00221288, // n0x14b1 c0x0000 (---------------)  + I salangen
	0x00222845, // n0x14b2 c0x0000 (---------------)  + I salat
	0x002230c7, // n0x14b3 c0x0000 (---------------)  + I saltdal
	0x00229849, // n0x14b4 c0x0000 (---------------)  + I samnanger
	0x002ae5ca, // n0x14b5 c0x0000 (---------------)  + I sandefjord
	0x002890c7, // n0x14b6 c0x0000 (---------------)  + I sandnes
	0x002890cc, // n0x14b7 c0x0000 (---------------)  + I sandnessjoen
	0x00372206, // n0x14b8 c0x0000 (---------------)  + I sandoy
	0x0024a1c9, // n0x14b9 c0x0000 (---------------)  + I sarpsborg
	0x00265785, // n0x14ba c0x0000 (---------------)  + I sauda
	0x002678c8, // n0x14bb c0x0000 (---------------)  + I sauherad
	0x00211683, // n0x14bc c0x0000 (---------------)  + I sel
	0x00211685, // n0x14bd c0x0000 (---------------)  + I selbu
	0x00256a45, // n0x14be c0x0000 (---------------)  + I selje
	0x002d0b07, // n0x14bf c0x0000 (---------------)  + I seljord
	0x3b24f102, // n0x14c0 c0x00ec (n0x160c-n0x160d)  + I sf
	0x00288c47, // n0x14c1 c0x0000 (---------------)  + I siellak
	0x002dff06, // n0x14c2 c0x0000 (---------------)  + I sigdal
	0x00217486, // n0x14c3 c0x0000 (---------------)  + I siljan
	0x002e08c6, // n0x14c4 c0x0000 (---------------)  + I sirdal
	0x00204d86, // n0x14c5 c0x0000 (---------------)  + I skanit
	0x003177c8, // n0x14c6 c0x0000 (---------------)  + I skanland
	0x0030ae45, // n0x14c7 c0x0000 (---------------)  + I skaun
	0x002d0687, // n0x14c8 c0x0000 (---------------)  + I skedsmo
	0x002d068d, // n0x14c9 c0x0000 (---------------)  + I skedsmokorset
	0x0021a9c3, // n0x14ca c0x0000 (---------------)  + I ski
	0x0021a9c5, // n0x14cb c0x0000 (---------------)  + I skien
	0x002fe907, // n0x14cc c0x0000 (---------------)  + I skierva
	0x002de008, // n0x14cd c0x0000 (---------------)  + I skiptvet
	0x00247685, // n0x14ce c0x0000 (---------------)  + I skjak
	0x00221f88, // n0x14cf c0x0000 (---------------)  + I skjervoy
	0x0024d646, // n0x14d0 c0x0000 (---------------)  + I skodje
	0x0028d9c7, // n0x14d1 c0x0000 (---------------)  + I slattum
	0x00229dc5, // n0x14d2 c0x0000 (---------------)  + I smola
	0x002206c6, // n0x14d3 c0x0000 (---------------)  + I snaase
	0x00261885, // n0x14d4 c0x0000 (---------------)  + I snasa
	0x00232f0a, // n0x14d5 c0x0000 (---------------)  + I snillfjord
	0x002b8046, // n0x14d6 c0x0000 (---------------)  + I snoasa
	0x00281007, // n0x14d7 c0x0000 (---------------)  + I sogndal
	0x002b4145, // n0x14d8 c0x0000 (---------------)  + I sogne
	0x002ee707, // n0x14d9 c0x0000 (---------------)  + I sokndal
	0x002e1704, // n0x14da c0x0000 (---------------)  + I sola
	0x002e1b06, // n0x14db c0x0000 (---------------)  + I solund
	0x002e22c5, // n0x14dc c0x0000 (---------------)  + I somna
	0x0029ad8b, // n0x14dd c0x0000 (---------------)  + I sondre-land
	0x00303989, // n0x14de c0x0000 (---------------)  + I songdalen
	0x0025a5ca, // n0x14df c0x0000 (---------------)  + I sor-aurdal
	0x0024ddc8, // n0x14e0 c0x0000 (---------------)  + I sor-fron
	0x002e2e48, // n0x14e1 c0x0000 (---------------)  + I sor-odal
	0x002e304c, // n0x14e2 c0x0000 (---------------)  + I sor-varanger
	0x002e3347, // n0x14e3 c0x0000 (---------------)  + I sorfold
	0x002e3508, // n0x14e4 c0x0000 (---------------)  + I sorreisa
	0x002e43c8, // n0x14e5 c0x0000 (---------------)  + I sortland
	0x002e45c5, // n0x14e6 c0x0000 (---------------)  + I sorum
	0x002e8e4a, // n0x14e7 c0x0000 (---------------)  + I spjelkavik
	0x002e9349, // n0x14e8 c0x0000 (---------------)  + I spydeberg
	0x3b605502, // n0x14e9 c0x00ed (n0x160d-n0x160e)  + I st
	0x00319806, // n0x14ea c0x0000 (---------------)  + I stange
	0x00284b44, // n0x14eb c0x0000 (---------------)  + I stat
	0x002d5749, // n0x14ec c0x0000 (---------------)  + I stathelle
	0x00347a89, // n0x14ed c0x0000 (---------------)  + I stavanger
	0x00228bc7, // n0x14ee c0x0000 (---------------)  + I stavern
	0x0026bf87, // n0x14ef c0x0000 (---------------)  + I steigen
	0x002739c9, // n0x14f0 c0x0000 (---------------)  + I steinkjer
	0x002d2548, // n0x14f1 c0x0000 (---------------)  + I stjordal
	0x002d254f, // n0x14f2 c0x0000 (---------------)  + I stjordalshalsen
	0x00239c46, // n0x14f3 c0x0000 (---------------)  + I stokke
	0x0030f10b, // n0x14f4 c0x0000 (---------------)  + I stor-elvdal
	0x0028d445, // n0x14f5 c0x0000 (---------------)  + I stord
	0x0028d447, // n0x14f6 c0x0000 (---------------)  + I stordal
	0x002e9b09, // n0x14f7 c0x0000 (---------------)  + I storfjord
	0x0020aec6, // n0x14f8 c0x0000 (---------------)  + I strand
	0x00349787, // n0x14f9 c0x0000 (---------------)  + I stranda
	0x00273845, // n0x14fa c0x0000 (---------------)  + I stryn
	0x00235144, // n0x14fb c0x0000 (---------------)  + I sula
	0x002d3546, // n0x14fc c0x0000 (---------------)  + I suldal
	0x00210b44, // n0x14fd c0x0000 (---------------)  + I sund
	0x002aafc7, // n0x14fe c0x0000 (---------------)  + I sunndal
	0x00324a08, // n0x14ff c0x0000 (---------------)  + I surnadal
	0x3baec4c8, // n0x1500 c0x00ee (n0x160e-n0x160f)  + I svalbard
	0x002ecec5, // n0x1501 c0x0000 (---------------)  + I sveio
	0x002ed007, // n0x1502 c0x0000 (---------------)  + I svelvik
	0x00270b89, // n0x1503 c0x0000 (---------------)  + I sykkylven
	0x0021dcc4, // n0x1504 c0x0000 (---------------)  + I tana
	0x002bc148, // n0x1505 c0x0000 (---------------)  + I tananger
	0x3bea1ec8, // n0x1506 c0x00ef (n0x160f-n0x1611)  o I telemark
	0x00262844, // n0x1507 c0x0000 (---------------)  + I time
	0x00236208, // n0x1508 c0x0000 (---------------)  + I tingvoll
	0x0036e2c4, // n0x1509 c0x0000 (---------------)  + I tinn
	0x002412c9, // n0x150a c0x0000 (---------------)  + I tjeldsund
	0x002426c5, // n0x150b c0x0000 (---------------)  + I tjome
	0x3c200142, // n0x150c c0x00f0 (n0x1611-n0x1612)  + I tm
	0x00239c85, // n0x150d c0x0000 (---------------)  + I tokke
	0x00219105, // n0x150e c0x0000 (---------------)  + I tolga
	0x00253588, // n0x150f c0x0000 (---------------)  + I tonsberg
	0x00237f87, // n0x1510 c0x0000 (---------------)  + I torsken
	0x3c605542, // n0x1511 c0x00f1 (n0x1612-n0x1613)  + I tr
	0x00268dc5, // n0x1512 c0x0000 (---------------)  + I trana
	0x00271506, // n0x1513 c0x0000 (---------------)  + I tranby
	0x00291006, // n0x1514 c0x0000 (---------------)  + I tranoy
	0x00333f88, // n0x1515 c0x0000 (---------------)  + I troandin
	0x0033ed88, // n0x1516 c0x0000 (---------------)  + I trogstad
	0x00357106, // n0x1517 c0x0000 (---------------)  + I tromsa
	0x002ee606, // n0x1518 c0x0000 (---------------)  + I tromso
	0x002a3449, // n0x1519 c0x0000 (---------------)  + I trondheim
	0x002eea86, // n0x151a c0x0000 (---------------)  + I trysil
	0x00363ecb, // n0x151b c0x0000 (---------------)  + I tvedestrand
	0x00233345, // n0x151c c0x0000 (---------------)  + I tydal
	0x002a0d46, // n0x151d c0x0000 (---------------)  + I tynset
	0x00315788, // n0x151e c0x0000 (---------------)  + I tysfjord
	0x00281386, // n0x151f c0x0000 (---------------)  + I tysnes
	0x002e4f86, // n0x1520 c0x0000 (---------------)  + I tysvar
	0x0020e04a, // n0x1521 c0x0000 (---------------)  + I ullensaker
	0x0034b0ca, // n0x1522 c0x0000 (---------------)  + I ullensvang
	0x00245245, // n0x1523 c0x0000 (---------------)  + I ulvik
	0x002700c7, // n0x1524 c0x0000 (---------------)  + I unjarga
	0x002f4546, // n0x1525 c0x0000 (---------------)  + I utsira
	0x3ca000c2, // n0x1526 c0x00f2 (n0x1613-n0x1614)  + I va
	0x002fea47, // n0x1527 c0x0000 (---------------)  + I vaapste
	0x0027bfc5, // n0x1528 c0x0000 (---------------)  + I vadso
	0x0020c3c4, // n0x1529 c0x0000 (---------------)  + I vaga
	0x0020c3c5, // n0x152a c0x0000 (---------------)  + I vagan
	0x00309006, // n0x152b c0x0000 (---------------)  + I vagsoy
	0x002cf707, // n0x152c c0x0000 (---------------)  + I vaksdal
	0x00216a45, // n0x152d c0x0000 (---------------)  + I valle
	0x002a8644, // n0x152e c0x0000 (---------------)  + I vang
	0x00271d48, // n0x152f c0x0000 (---------------)  + I vanylven
	0x002e5045, // n0x1530 c0x0000 (---------------)  + I vardo
	0x0036efc7, // n0x1531 c0x0000 (---------------)  + I varggat
	0x002f0b05, // n0x1532 c0x0000 (---------------)  + I varoy
	0x00232e45, // n0x1533 c0x0000 (---------------)  + I vefsn
	0x002a2b04, // n0x1534 c0x0000 (---------------)  + I vega
	0x002df989, // n0x1535 c0x0000 (---------------)  + I vegarshei
	0x002f1f88, // n0x1536 c0x0000 (---------------)  + I vennesla
	0x002f0986, // n0x1537 c0x0000 (---------------)  + I verdal
	0x002f2906, // n0x1538 c0x0000 (---------------)  + I verran
	0x002c5b86, // n0x1539 c0x0000 (---------------)  + I vestby
	0x3cef34c8, // n0x153a c0x00f3 (n0x1614-n0x1615)  o I vestfold
	0x002f36c7, // n0x153b c0x0000 (---------------)  + I vestnes
	0x002f3b4d, // n0x153c c0x0000 (---------------)  + I vestre-slidre
	0x002f4ccc, // n0x153d c0x0000 (---------------)  + I vestre-toten
	0x002f5e09, // n0x153e c0x0000 (---------------)  + I vestvagoy
	0x002f6049, // n0x153f c0x0000 (---------------)  + I vevelstad
	0x3d332602, // n0x1540 c0x00f4 (n0x1615-n0x1616)  + I vf
	0x0036be83, // n0x1541 c0x0000 (---------------)  + I vgs
	0x002032c3, // n0x1542 c0x0000 (---------------)  + I vik
	0x0026a4c5, // n0x1543 c0x0000 (---------------)  + I vikna
	0x0033920a, // n0x1544 c0x0000 (---------------)  + I vindafjord
	0x0030b446, // n0x1545 c0x0000 (---------------)  + I voagat
	0x002f9005, // n0x1546 c0x0000 (---------------)  + I volda
	0x002fae04, // n0x1547 c0x0000 (---------------)  + I voss
	0x002fae0b, // n0x1548 c0x0000 (---------------)  + I vossevangen
	0x00300a8c, // n0x1549 c0x0000 (---------------)  + I xn--andy-ira
	0x0030128c, // n0x154a c0x0000 (---------------)  + I xn--asky-ira
	0x00301595, // n0x154b c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x00302f8d, // n0x154c c0x0000 (---------------)  + I xn--avery-yua
	0x0030418f, // n0x154d c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x00304552, // n0x154e c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x003049cf, // n0x154f c0x0000 (---------------)  + I xn--berlevg-jxa
	0x00304d92, // n0x1550 c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x00305213, // n0x1551 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x003056cd, // n0x1552 c0x0000 (---------------)  + I xn--bidr-5nac
	0x00305c8d, // n0x1553 c0x0000 (---------------)  + I xn--bievt-0qa
	0x00305fce, // n0x1554 c0x0000 (---------------)  + I xn--bjarky-fya
	0x0030654e, // n0x1555 c0x0000 (---------------)  + I xn--bjddar-pta
	0x00306ccc, // n0x1556 c0x0000 (---------------)  + I xn--blt-elab
	0x0030704c, // n0x1557 c0x0000 (---------------)  + I xn--bmlo-gra
	0x0030784b, // n0x1558 c0x0000 (---------------)  + I xn--bod-2na
	0x00307bce, // n0x1559 c0x0000 (---------------)  + I xn--brnny-wuac
	0x0030a3d2, // n0x155a c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x0030b20c, // n0x155b c0x0000 (---------------)  + I xn--brum-voa
	0x0030b9d0, // n0x155c c0x0000 (---------------)  + I xn--btsfjord-9za
	0x0031acd2, // n0x155d c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x0031b14c, // n0x155e c0x0000 (---------------)  + I xn--dnna-gra
	0x0031ba8d, // n0x155f c0x0000 (---------------)  + I xn--drbak-wua
	0x0031bdcc, // n0x1560 c0x0000 (---------------)  + I xn--dyry-ira
	0x0031cc11, // n0x1561 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x0031d04d, // n0x1562 c0x0000 (---------------)  + I xn--finny-yua
	0x0031fc0d, // n0x1563 c0x0000 (---------------)  + I xn--fjord-lra
	0x0032020a, // n0x1564 c0x0000 (---------------)  + I xn--fl-zia
	0x0032048c, // n0x1565 c0x0000 (---------------)  + I xn--flor-jra
	0x00320d8c, // n0x1566 c0x0000 (---------------)  + I xn--frde-gra
	0x0032110c, // n0x1567 c0x0000 (---------------)  + I xn--frna-woa
	0x0032180c, // n0x1568 c0x0000 (---------------)  + I xn--frya-hra
	0x00323c13, // n0x1569 c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x00324190, // n0x156a c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x00324590, // n0x156b c0x0000 (---------------)  + I xn--givuotna-8ya
	0x00324c0d, // n0x156c c0x0000 (---------------)  + I xn--gjvik-wua
	0x00324f4c, // n0x156d c0x0000 (---------------)  + I xn--gls-elac
	0x00325b49, // n0x156e c0x0000 (---------------)  + I xn--h-2fa
	0x00326acd, // n0x156f c0x0000 (---------------)  + I xn--hbmer-xqa
	0x00326e13, // n0x1570 c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x00328951, // n0x1571 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x00328d93, // n0x1572 c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x003294cf, // n0x1573 c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0032988c, // n0x1574 c0x0000 (---------------)  + I xn--hobl-ira
	0x00329b8f, // n0x1575 c0x0000 (---------------)  + I xn--holtlen-hxa
	0x00329f4d, // n0x1576 c0x0000 (---------------)  + I xn--hpmir-xqa
	0x0032a54f, // n0x1577 c0x0000 (---------------)  + I xn--hyanger-q1a
	0x0032a910, // n0x1578 c0x0000 (---------------)  + I xn--hylandet-54a
	0x0032b0ce, // n0x1579 c0x0000 (---------------)  + I xn--indery-fya
	0x0032d80e, // n0x157a c0x0000 (---------------)  + I xn--jlster-bya
	0x0032e590, // n0x157b c0x0000 (---------------)  + I xn--jrpeland-54a
	0x0032e98d, // n0x157c c0x0000 (---------------)  + I xn--karmy-yua
	0x0032ecce, // n0x157d c0x0000 (---------------)  + I xn--kfjord-iua
	0x0032f04c, // n0x157e c0x0000 (---------------)  + I xn--klbu-woa
	0x0032f353, // n0x157f c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x0033070e, // n0x1580 c0x0000 (---------------)  + I xn--krager-gya
	0x00330f50, // n0x1581 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x00331351, // n0x1582 c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0033178f, // n0x1583 c0x0000 (---------------)  + I xn--krehamn-dxa
	0x00331b53, // n0x1584 c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0033218d, // n0x1585 c0x0000 (---------------)  + I xn--ksnes-uua
	0x003324cf, // n0x1586 c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0033288e, // n0x1587 c0x0000 (---------------)  + I xn--kvitsy-fya
	0x00332e50, // n0x1588 c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x00333249, // n0x1589 c0x0000 (---------------)  + I xn--l-1fa
	0x00334310, // n0x158a c0x0000 (---------------)  + I xn--laheadju-7ya
	0x00334bcf, // n0x158b c0x0000 (---------------)  + I xn--langevg-jxa
	0x0033524f, // n0x158c c0x0000 (---------------)  + I xn--ldingen-q1a
	0x00335612, // n0x158d c0x0000 (---------------)  + I xn--leagaviika-52b
	0x0033610e, // n0x158e c0x0000 (---------------)  + I xn--lesund-hua
	0x00336dcd, // n0x158f c0x0000 (---------------)  + I xn--lgrd-poac
	0x0033730d, // n0x1590 c0x0000 (---------------)  + I xn--lhppi-xqa
	0x0033764d, // n0x1591 c0x0000 (---------------)  + I xn--linds-pra
	0x00337fcd, // n0x1592 c0x0000 (---------------)  + I xn--loabt-0qa
	0x0033830d, // n0x1593 c0x0000 (---------------)  + I xn--lrdal-sra
	0x00338650, // n0x1594 c0x0000 (---------------)  + I xn--lrenskog-54a
	0x00338a4b, // n0x1595 c0x0000 (---------------)  + I xn--lt-liac
	0x00338ecc, // n0x1596 c0x0000 (---------------)  + I xn--lten-gra
	0x0033948c, // n0x1597 c0x0000 (---------------)  + I xn--lury-ira
	0x0033978c, // n0x1598 c0x0000 (---------------)  + I xn--mely-ira
	0x00339a8e, // n0x1599 c0x0000 (---------------)  + I xn--merker-kua
	0x0033ef90, // n0x159a c0x0000 (---------------)  + I xn--mjndalen-64a
	0x003408d2, // n0x159b c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x00340d4b, // n0x159c c0x0000 (---------------)  + I xn--mli-tla
	0x003410ce, // n0x159d c0x0000 (---------------)  + I xn--mlselv-iua
	0x0034144e, // n0x159e c0x0000 (---------------)  + I xn--moreke-jua
	0x0034358e, // n0x159f c0x0000 (---------------)  + I xn--mosjen-eya
	0x0034408b, // n0x15a0 c0x0000 (---------------)  + I xn--mot-tla
	0x3d744356, // n0x15a1 c0x00f5 (n0x1616-n0x1618)  o I xn--mre-og-romsdal-qqb
	0x00347ccd, // n0x15a2 c0x0000 (---------------)  + I xn--msy-ula0h
	0x00348154, // n0x15a3 c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x003487cd, // n0x15a4 c0x0000 (---------------)  + I xn--muost-0qa
	0x003491d5, // n0x15a5 c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0034a90d, // n0x15a6 c0x0000 (---------------)  + I xn--nry-yla5g
	0x0034ac4f, // n0x15a7 c0x0000 (---------------)  + I xn--nttery-byae
	0x0034b34f, // n0x15a8 c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0034d60f, // n0x15a9 c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0034d9ce, // n0x15aa c0x0000 (---------------)  + I xn--ostery-fya
	0x0034df4d, // n0x15ab c0x0000 (---------------)  + I xn--osyro-wua
	0x0034f091, // n0x15ac c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x00350acc, // n0x15ad c0x0000 (---------------)  + I xn--rady-ira
	0x00350dcc, // n0x15ae c0x0000 (---------------)  + I xn--rdal-poa
	0x003510cb, // n0x15af c0x0000 (---------------)  + I xn--rde-ula
	0x0035138c, // n0x15b0 c0x0000 (---------------)  + I xn--rdy-0nab
	0x0035184f, // n0x15b1 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00351c12, // n0x15b2 c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x0035344d, // n0x15b3 c0x0000 (---------------)  + I xn--rholt-mra
	0x00353c0c, // n0x15b4 c0x0000 (---------------)  + I xn--risa-5na
	0x0035420c, // n0x15b5 c0x0000 (---------------)  + I xn--risr-ira
	0x0035450d, // n0x15b6 c0x0000 (---------------)  + I xn--rland-uua
	0x0035484f, // n0x15b7 c0x0000 (---------------)  + I xn--rlingen-mxa
	0x00354c0e, // n0x15b8 c0x0000 (---------------)  + I xn--rmskog-bya
	0x0035508c, // n0x15b9 c0x0000 (---------------)  + I xn--rros-gra
	0x0035550d, // n0x15ba c0x0000 (---------------)  + I xn--rskog-uua
	0x0035584b, // n0x15bb c0x0000 (---------------)  + I xn--rst-0na
	0x00355e0c, // n0x15bc c0x0000 (---------------)  + I xn--rsta-fra
	0x0035638d, // n0x15bd c0x0000 (---------------)  + I xn--ryken-vua
	0x003566ce, // n0x15be c0x0000 (---------------)  + I xn--ryrvik-bya
	0x00356c49, // n0x15bf c0x0000 (---------------)  + I xn--s-1fa
	0x00358193, // n0x15c0 c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x00358d0d, // n0x15c1 c0x0000 (---------------)  + I xn--sandy-yua
	0x0035904d, // n0x15c2 c0x0000 (---------------)  + I xn--seral-lra
	0x0035964c, // n0x15c3 c0x0000 (---------------)  + I xn--sgne-gra
	0x00359d0e, // n0x15c4 c0x0000 (---------------)  + I xn--skierv-uta
	0x0035a60f, // n0x15c5 c0x0000 (---------------)  + I xn--skjervy-v1a
	0x0035a9cc, // n0x15c6 c0x0000 (---------------)  + I xn--skjk-soa
	0x0035accd, // n0x15c7 c0x0000 (---------------)  + I xn--sknit-yqa
	0x0035b00f, // n0x15c8 c0x0000 (---------------)  + I xn--sknland-fxa
	0x0035b3cc, // n0x15c9 c0x0000 (---------------)  + I xn--slat-5na
	0x0035b94c, // n0x15ca c0x0000 (---------------)  + I xn--slt-elab
	0x0035bd0c, // n0x15cb c0x0000 (---------------)  + I xn--smla-hra
	0x0035c00c, // n0x15cc c0x0000 (---------------)  + I xn--smna-gra
	0x0035c34d, // n0x15cd c0x0000 (---------------)  + I xn--snase-nra
	0x0035c692, // n0x15ce c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0035cb8c, // n0x15cf c0x0000 (---------------)  + I xn--snes-poa
	0x0035ce8c, // n0x15d0 c0x0000 (---------------)  + I xn--snsa-roa
	0x0035d191, // n0x15d1 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0035d5cf, // n0x15d2 c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0035d98f, // n0x15d3 c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x0035dd53, // n0x15d4 c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x0035ee4e, // n0x15d5 c0x0000 (---------------)  + I xn--srfold-bya
	0x0035f1cf, // n0x15d6 c0x0000 (---------------)  + I xn--srreisa-q1a
	0x0035f58c, // n0x15d7 c0x0000 (---------------)  + I xn--srum-gra
	0x3db5f88e, // n0x15d8 c0x00f6 (n0x1618-n0x1619)  o I xn--stfold-9xa
	0x0035fc0f, // n0x15d9 c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x0035ffd6, // n0x15da c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x00361152, // n0x15db c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x003620cc, // n0x15dc c0x0000 (---------------)  + I xn--tjme-hra
	0x0036288f, // n0x15dd c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x00362c4d, // n0x15de c0x0000 (---------------)  + I xn--trany-yua
	0x00362f8f, // n0x15df c0x0000 (---------------)  + I xn--trgstad-r1a
	0x0036334c, // n0x15e0 c0x0000 (---------------)  + I xn--trna-woa
	0x0036364d, // n0x15e1 c0x0000 (---------------)  + I xn--troms-zua
	0x0036398d, // n0x15e2 c0x0000 (---------------)  + I xn--tysvr-vra
	0x0036444e, // n0x15e3 c0x0000 (---------------)  + I xn--unjrga-rta
	0x00364f0c, // n0x15e4 c0x0000 (---------------)  + I xn--vads-jra
	0x0036520c, // n0x15e5 c0x0000 (---------------)  + I xn--vard-jra
	0x00365510, // n0x15e6 c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x00369e91, // n0x15e7 c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x0036a2cb, // n0x15e8 c0x0000 (---------------)  + I xn--vg-yiab
	0x0036ba8c, // n0x15e9 c0x0000 (---------------)  + I xn--vgan-qoa
	0x0036bd8e, // n0x15ea c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x0036f851, // n0x15eb c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0036fc8e, // n0x15ec c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0037000d, // n0x15ed c0x0000 (---------------)  + I xn--vry-yla5g
	0x0037238b, // n0x15ee c0x0000 (---------------)  + I xn--yer-zna
	0x00372c0f, // n0x15ef c0x0000 (---------------)  + I xn--ygarden-p1a
	0x00373554, // n0x15f0 c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x00229d82, // n0x15f1 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x15f2 c0x0000 (---------------)  + I gs
	0x00209883, // n0x15f3 c0x0000 (---------------)  + I nes
	0x00229d82, // n0x15f4 c0x0000 (---------------)  + I gs
	0x00209883, // n0x15f5 c0x0000 (---------------)  + I nes
	0x00229d82, // n0x15f6 c0x0000 (---------------)  + I gs
	0x00203642, // n0x15f7 c0x0000 (---------------)  + I os
	0x002420c5, // n0x15f8 c0x0000 (---------------)  + I valer
	0x0036f54c, // n0x15f9 c0x0000 (---------------)  + I xn--vler-qoa
	0x00229d82, // n0x15fa c0x0000 (---------------)  + I gs
	0x00229d82, // n0x15fb c0x0000 (---------------)  + I gs
	0x00203642, // n0x15fc c0x0000 (---------------)  + I os
	0x00229d82, // n0x15fd c0x0000 (---------------)  + I gs
	0x0028de85, // n0x15fe c0x0000 (---------------)  + I heroy
	0x002ae5c5, // n0x15ff c0x0000 (---------------)  + I sande
	0x00229d82, // n0x1600 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x1601 c0x0000 (---------------)  + I gs
	0x00200fc2, // n0x1602 c0x0000 (---------------)  + I bo
	0x0028de85, // n0x1603 c0x0000 (---------------)  + I heroy
	0x00303bc9, // n0x1604 c0x0000 (---------------)  + I xn--b-5ga
	0x0032864c, // n0x1605 c0x0000 (---------------)  + I xn--hery-ira
	0x00229d82, // n0x1606 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x1607 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x1608 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x1609 c0x0000 (---------------)  + I gs
	0x002420c5, // n0x160a c0x0000 (---------------)  + I valer
	0x00229d82, // n0x160b c0x0000 (---------------)  + I gs
	0x00229d82, // n0x160c c0x0000 (---------------)  + I gs
	0x00229d82, // n0x160d c0x0000 (---------------)  + I gs
	0x00229d82, // n0x160e c0x0000 (---------------)  + I gs
	0x00200fc2, // n0x160f c0x0000 (---------------)  + I bo
	0x00303bc9, // n0x1610 c0x0000 (---------------)  + I xn--b-5ga
	0x00229d82, // n0x1611 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x1612 c0x0000 (---------------)  + I gs
	0x00229d82, // n0x1613 c0x0000 (---------------)  + I gs
	0x002ae5c5, // n0x1614 c0x0000 (---------------)  + I sande
	0x00229d82, // n0x1615 c0x0000 (---------------)  + I gs
	0x002ae5c5, // n0x1616 c0x0000 (---------------)  + I sande
	0x0032864c, // n0x1617 c0x0000 (---------------)  + I xn--hery-ira
	0x0036f54c, // n0x1618 c0x0000 (---------------)  + I xn--vler-qoa
	0x00314c43, // n0x1619 c0x0000 (---------------)  + I biz
	0x00222603, // n0x161a c0x0000 (---------------)  + I com
	0x0027a643, // n0x161b c0x0000 (---------------)  + I edu
	0x002157c3, // n0x161c c0x0000 (---------------)  + I gov
	0x0021c704, // n0x161d c0x0000 (---------------)  + I info
	0x00201603, // n0x161e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x161f c0x0000 (---------------)  + I org
	0x00118048, // n0x1620 c0x0000 (---------------)  +   merseine
	0x000e9784, // n0x1621 c0x0000 (---------------)  +   mine
	0x000514c8, // n0x1622 c0x0000 (---------------)  +   shacknet
	0x00201d82, // n0x1623 c0x0000 (---------------)  + I ac
	0x3ea07a02, // n0x1624 c0x00fa (n0x1633-n0x1634)  + I co
	0x0023f943, // n0x1625 c0x0000 (---------------)  + I cri
	0x00267e84, // n0x1626 c0x0000 (---------------)  + I geek
	0x00204b03, // n0x1627 c0x0000 (---------------)  + I gen
	0x00347604, // n0x1628 c0x0000 (---------------)  + I govt
	0x00360806, // n0x1629 c0x0000 (---------------)  + I health
	0x00211883, // n0x162a c0x0000 (---------------)  + I iwi
	0x0031b904, // n0x162b c0x0000 (---------------)  + I kiwi
	0x00282b05, // n0x162c c0x0000 (---------------)  + I maori
	0x0023f703, // n0x162d c0x0000 (---------------)  + I mil
	0x00201603, // n0x162e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x162f c0x0000 (---------------)  + I org
	0x0024f64a, // n0x1630 c0x0000 (---------------)  + I parliament
	0x002ffb06, // n0x1631 c0x0000 (---------------)  + I school
	0x003417cc, // n0x1632 c0x0000 (---------------)  + I xn--mori-qsa
	0x000b8948, // n0x1633 c0x0000 (---------------)  +   blogspot
	0x00207a02, // n0x1634 c0x0000 (---------------)  + I co
	0x00222603, // n0x1635 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1636 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1637 c0x0000 (---------------)  + I gov
	0x00225d03, // n0x1638 c0x0000 (---------------)  + I med
	0x002cb0c6, // n0x1639 c0x0000 (---------------)  + I museum
	0x00201603, // n0x163a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x163b c0x0000 (---------------)  + I org
	0x002d8443, // n0x163c c0x0000 (---------------)  + I pro
	0x000100c2, // n0x163d c0x0000 (---------------)  +   ae
	0x00010dc7, // n0x163e c0x0000 (---------------)  +   blogdns
	0x000cce48, // n0x163f c0x0000 (---------------)  +   blogsite
	0x00081e12, // n0x1640 c0x0000 (---------------)  +   boldlygoingnowhere
	0x00035348, // n0x1641 c0x0000 (---------------)  +   dnsalias
	0x0000b0c7, // n0x1642 c0x0000 (---------------)  +   dnsdojo
	0x0000dccb, // n0x1643 c0x0000 (---------------)  +   doesntexist
	0x000cd889, // n0x1644 c0x0000 (---------------)  +   dontexist
	0x00035247, // n0x1645 c0x0000 (---------------)  +   doomdns
	0x0000b006, // n0x1646 c0x0000 (---------------)  +   dvrdns
	0x0009fe08, // n0x1647 c0x0000 (---------------)  +   dynalias
	0x3f410c06, // n0x1648 c0x00fd (n0x1672-n0x1674)  +   dyndns
	0x000a71cd, // n0x1649 c0x0000 (---------------)  +   endofinternet
	0x0005fad0, // n0x164a c0x0000 (---------------)  +   endoftheinternet
	0x00067647, // n0x164b c0x0000 (---------------)  +   from-me
	0x0008b749, // n0x164c c0x0000 (---------------)  +   game-host
	0x00053106, // n0x164d c0x0000 (---------------)  +   gotdns
	0x0003e44a, // n0x164e c0x0000 (---------------)  +   hobby-site
	0x00025c87, // n0x164f c0x0000 (---------------)  +   homedns
	0x00019d07, // n0x1650 c0x0000 (---------------)  +   homeftp
	0x0009f1c9, // n0x1651 c0x0000 (---------------)  +   homelinux
	0x000a1908, // n0x1652 c0x0000 (---------------)  +   homeunix
	0x000f494e, // n0x1653 c0x0000 (---------------)  +   is-a-bruinsfan
	0x0007100e, // n0x1654 c0x0000 (---------------)  +   is-a-candidate
	0x000a538f, // n0x1655 c0x0000 (---------------)  +   is-a-celticsfan
	0x001402c9, // n0x1656 c0x0000 (---------------)  +   is-a-chef
	0x00067d49, // n0x1657 c0x0000 (---------------)  +   is-a-geek
	0x00082c0b, // n0x1658 c0x0000 (---------------)  +   is-a-knight
	0x000987cf, // n0x1659 c0x0000 (---------------)  +   is-a-linux-user
	0x000e034c, // n0x165a c0x0000 (---------------)  +   is-a-patsfan
	0x000b02cb, // n0x165b c0x0000 (---------------)  +   is-a-soxfan
	0x0011f8c8, // n0x165c c0x0000 (---------------)  +   is-found
	0x000ef287, // n0x165d c0x0000 (---------------)  +   is-lost
	0x000f2708, // n0x165e c0x0000 (---------------)  +   is-saved
	0x0010350b, // n0x165f c0x0000 (---------------)  +   is-very-bad
	0x0010c24c, // n0x1660 c0x0000 (---------------)  +   is-very-evil
	0x0012148c, // n0x1661 c0x0000 (---------------)  +   is-very-good
	0x001255cc, // n0x1662 c0x0000 (---------------)  +   is-very-nice
	0x0012ba4d, // n0x1663 c0x0000 (---------------)  +   is-very-sweet
	0x0014bd08, // n0x1664 c0x0000 (---------------)  +   isa-geek
	0x00047a09, // n0x1665 c0x0000 (---------------)  +   kicks-ass
	0x000bae4b, // n0x1666 c0x0000 (---------------)  +   misconfused
	0x000d4e47, // n0x1667 c0x0000 (---------------)  +   podzone
	0x000cccca, // n0x1668 c0x0000 (---------------)  +   readmyblog
	0x000ff606, // n0x1669 c0x0000 (---------------)  +   selfip
	0x000c828d, // n0x166a c0x0000 (---------------)  +   sellsyourhome
	0x00016d08, // n0x166b c0x0000 (---------------)  +   servebbs
	0x0009cb88, // n0x166c c0x0000 (---------------)  +   serveftp
	0x000a2a49, // n0x166d c0x0000 (---------------)  +   servegame
	0x000ea04c, // n0x166e c0x0000 (---------------)  +   stuff-4-sale
	0x000054c2, // n0x166f c0x0000 (---------------)  +   us
	0x0004db86, // n0x1670 c0x0000 (---------------)  +   webhop
	0x00003502, // n0x1671 c0x0000 (---------------)  +   za
	0x00006cc2, // n0x1672 c0x0000 (---------------)  +   go
	0x00019d04, // n0x1673 c0x0000 (---------------)  +   home
	0x00212fc3, // n0x1674 c0x0000 (---------------)  + I abo
	0x00201d82, // n0x1675 c0x0000 (---------------)  + I ac
	0x00222603, // n0x1676 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1677 c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x1678 c0x0000 (---------------)  + I gob
	0x00201ec3, // n0x1679 c0x0000 (---------------)  + I ing
	0x00225d03, // n0x167a c0x0000 (---------------)  + I med
	0x00201603, // n0x167b c0x0000 (---------------)  + I net
	0x00214103, // n0x167c c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x167d c0x0000 (---------------)  + I org
	0x002dc183, // n0x167e c0x0000 (---------------)  + I sld
	0x00222603, // n0x167f c0x0000 (---------------)  + I com
	0x0027a643, // n0x1680 c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x1681 c0x0000 (---------------)  + I gob
	0x0023f703, // n0x1682 c0x0000 (---------------)  + I mil
	0x00201603, // n0x1683 c0x0000 (---------------)  + I net
	0x00214103, // n0x1684 c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x1685 c0x0000 (---------------)  + I org
	0x00222603, // n0x1686 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1687 c0x0000 (---------------)  + I edu
	0x0021f5c3, // n0x1688 c0x0000 (---------------)  + I org
	0x00222603, // n0x1689 c0x0000 (---------------)  + I com
	0x0027a643, // n0x168a c0x0000 (---------------)  + I edu
	0x002157c3, // n0x168b c0x0000 (---------------)  + I gov
	0x00200041, // n0x168c c0x0000 (---------------)  + I i
	0x0023f703, // n0x168d c0x0000 (---------------)  + I mil
	0x00201603, // n0x168e c0x0000 (---------------)  + I net
	0x00224203, // n0x168f c0x0000 (---------------)  + I ngo
	0x0021f5c3, // n0x1690 c0x0000 (---------------)  + I org
	0x00314c43, // n0x1691 c0x0000 (---------------)  + I biz
	0x00222603, // n0x1692 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1693 c0x0000 (---------------)  + I edu
	0x002a6ec3, // n0x1694 c0x0000 (---------------)  + I fam
	0x0020dbc3, // n0x1695 c0x0000 (---------------)  + I gob
	0x00279e43, // n0x1696 c0x0000 (---------------)  + I gok
	0x002824c3, // n0x1697 c0x0000 (---------------)  + I gon
	0x002d9083, // n0x1698 c0x0000 (---------------)  + I gop
	0x00206cc3, // n0x1699 c0x0000 (---------------)  + I gos
	0x002157c3, // n0x169a c0x0000 (---------------)  + I gov
	0x0021c704, // n0x169b c0x0000 (---------------)  + I info
	0x00201603, // n0x169c c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x169d c0x0000 (---------------)  + I org
	0x00205e43, // n0x169e c0x0000 (---------------)  + I web
	0x0021b805, // n0x169f c0x0000 (---------------)  + I 6bone
	0x002e7744, // n0x16a0 c0x0000 (---------------)  + I agro
	0x00245143, // n0x16a1 c0x0000 (---------------)  + I aid
	0x00201383, // n0x16a2 c0x0000 (---------------)  + I art
	0x00200103, // n0x16a3 c0x0000 (---------------)  + I atm
	0x002fd5c8, // n0x16a4 c0x0000 (---------------)  + I augustow
	0x0022ccc4, // n0x16a5 c0x0000 (---------------)  + I auto
	0x0023788a, // n0x16a6 c0x0000 (---------------)  + I babia-gora
	0x00342f86, // n0x16a7 c0x0000 (---------------)  + I bedzin
	0x00361587, // n0x16a8 c0x0000 (---------------)  + I beskidy
	0x0021a58a, // n0x16a9 c0x0000 (---------------)  + I bialowieza
	0x00239b09, // n0x16aa c0x0000 (---------------)  + I bialystok
	0x00371087, // n0x16ab c0x0000 (---------------)  + I bielawa
	0x003747ca, // n0x16ac c0x0000 (---------------)  + I bieszczady
	0x00314c43, // n0x16ad c0x0000 (---------------)  + I biz
	0x0033fa8b, // n0x16ae c0x0000 (---------------)  + I boleslawiec
	0x002c6a89, // n0x16af c0x0000 (---------------)  + I bydgoszcz
	0x002ca405, // n0x16b0 c0x0000 (---------------)  + I bytom
	0x002c8e47, // n0x16b1 c0x0000 (---------------)  + I cieszyn
	0x00007a02, // n0x16b2 c0x0000 (---------------)  +   co
	0x00222603, // n0x16b3 c0x0000 (---------------)  + I com
	0x002fcf87, // n0x16b4 c0x0000 (---------------)  + I czeladz
	0x00223345, // n0x16b5 c0x0000 (---------------)  + I czest
	0x0036c4c9, // n0x16b6 c0x0000 (---------------)  + I dlugoleka
	0x0027a643, // n0x16b7 c0x0000 (---------------)  + I edu
	0x00220446, // n0x16b8 c0x0000 (---------------)  + I elblag
	0x002b7d03, // n0x16b9 c0x0000 (---------------)  + I elk
	0x002dff83, // n0x16ba c0x0000 (---------------)  + I gda
	0x002f9d86, // n0x16bb c0x0000 (---------------)  + I gdansk
	0x00312146, // n0x16bc c0x0000 (---------------)  + I gdynia
	0x00211807, // n0x16bd c0x0000 (---------------)  + I gliwice
	0x0021e106, // n0x16be c0x0000 (---------------)  + I glogow
	0x00225fc5, // n0x16bf c0x0000 (---------------)  + I gmina
	0x0025f607, // n0x16c0 c0x0000 (---------------)  + I gniezno
	0x002ff187, // n0x16c1 c0x0000 (---------------)  + I gorlice
	0x412157c3, // n0x16c2 c0x0104 (n0x174a-n0x1753)  + I gov
	0x00307287, // n0x16c3 c0x0000 (---------------)  + I grajewo
	0x00229d83, // n0x16c4 c0x0000 (---------------)  + I gsm
	0x002e7b85, // n0x16c5 c0x0000 (---------------)  + I ilawa
	0x0021c704, // n0x16c6 c0x0000 (---------------)  + I info
	0x002570c3, // n0x16c7 c0x0000 (---------------)  + I irc
	0x0033e5c8, // n0x16c8 c0x0000 (---------------)  + I jaworzno
	0x0032390c, // n0x16c9 c0x0000 (---------------)  + I jelenia-gora
	0x002a9e05, // n0x16ca c0x0000 (---------------)  + I jgora
	0x002b0a06, // n0x16cb c0x0000 (---------------)  + I kalisz
	0x002fce47, // n0x16cc c0x0000 (---------------)  + I karpacz
	0x00201347, // n0x16cd c0x0000 (---------------)  + I kartuzy
	0x00223f07, // n0x16ce c0x0000 (---------------)  + I kaszuby
	0x00248588, // n0x16cf c0x0000 (---------------)  + I katowice
	0x0022d4cf, // n0x16d0 c0x0000 (---------------)  + I kazimierz-dolny
	0x00349bc5, // n0x16d1 c0x0000 (---------------)  + I kepno
	0x0028e847, // n0x16d2 c0x0000 (---------------)  + I ketrzyn
	0x002400c7, // n0x16d3 c0x0000 (---------------)  + I klodzko
	0x0029ed8a, // n0x16d4 c0x0000 (---------------)  + I kobierzyce
	0x002a61c9, // n0x16d5 c0x0000 (---------------)  + I kolobrzeg
	0x002cf545, // n0x16d6 c0x0000 (---------------)  + I konin
	0x002d0e4a, // n0x16d7 c0x0000 (---------------)  + I konskowola
	0x002ad846, // n0x16d8 c0x0000 (---------------)  + I krakow
	0x002b7d85, // n0x16d9 c0x0000 (---------------)  + I kutno
	0x002b1a44, // n0x16da c0x0000 (---------------)  + I lapy
	0x0023a246, // n0x16db c0x0000 (---------------)  + I lebork
	0x00254fc7, // n0x16dc c0x0000 (---------------)  + I legnica
	0x0021ba87, // n0x16dd c0x0000 (---------------)  + I lezajsk
	0x003115c8, // n0x16de c0x0000 (---------------)  + I limanowa
	0x002d4105, // n0x16df c0x0000 (---------------)  + I lomza
	0x00223246, // n0x16e0 c0x0000 (---------------)  + I lowicz
	0x002a42c5, // n0x16e1 c0x0000 (---------------)  + I lubin
	0x0022fbc5, // n0x16e2 c0x0000 (---------------)  + I lukow
	0x0021d884, // n0x16e3 c0x0000 (---------------)  + I mail
	0x00221947, // n0x16e4 c0x0000 (---------------)  + I malbork
	0x0031760a, // n0x16e5 c0x0000 (---------------)  + I malopolska
	0x00208088, // n0x16e6 c0x0000 (---------------)  + I mazowsze
	0x002eb986, // n0x16e7 c0x0000 (---------------)  + I mazury
	0x00302dc5, // n0x16e8 c0x0000 (---------------)  + I mbone
	0x00225d03, // n0x16e9 c0x0000 (---------------)  + I med
	0x0027ab45, // n0x16ea c0x0000 (---------------)  + I media
	0x002d3a06, // n0x16eb c0x0000 (---------------)  + I miasta
	0x00240b86, // n0x16ec c0x0000 (---------------)  + I mielec
	0x003096c6, // n0x16ed c0x0000 (---------------)  + I mielno
	0x0023f703, // n0x16ee c0x0000 (---------------)  + I mil
	0x003536c7, // n0x16ef c0x0000 (---------------)  + I mragowo
	0x00240045, // n0x16f0 c0x0000 (---------------)  + I naklo
	0x00201603, // n0x16f1 c0x0000 (---------------)  + I net
	0x00224203, // n0x16f2 c0x0000 (---------------)  + I ngo
	0x0027324d, // n0x16f3 c0x0000 (---------------)  + I nieruchomosci
	0x00214103, // n0x16f4 c0x0000 (---------------)  + I nom
	0x003116c8, // n0x16f5 c0x0000 (---------------)  + I nowaruda
	0x0027a084, // n0x16f6 c0x0000 (---------------)  + I nysa
	0x00272705, // n0x16f7 c0x0000 (---------------)  + I olawa
	0x0029ec86, // n0x16f8 c0x0000 (---------------)  + I olecko
	0x002ffc06, // n0x16f9 c0x0000 (---------------)  + I olkusz
	0x002a0c47, // n0x16fa c0x0000 (---------------)  + I olsztyn
	0x00239e47, // n0x16fb c0x0000 (---------------)  + I opoczno
	0x002a8505, // n0x16fc c0x0000 (---------------)  + I opole
	0x0021f5c3, // n0x16fd c0x0000 (---------------)  + I org
	0x00228587, // n0x16fe c0x0000 (---------------)  + I ostroda
	0x00229089, // n0x16ff c0x0000 (---------------)  + I ostroleka
	0x00266449, // n0x1700 c0x0000 (---------------)  + I ostrowiec
	0x0022ceca, // n0x1701 c0x0000 (---------------)  + I ostrowwlkp
	0x002416c2, // n0x1702 c0x0000 (---------------)  + I pc
	0x002e7b44, // n0x1703 c0x0000 (---------------)  + I pila
	0x002cfa04, // n0x1704 c0x0000 (---------------)  + I pisz
	0x002d4787, // n0x1705 c0x0000 (---------------)  + I podhale
	0x002d4b48, // n0x1706 c0x0000 (---------------)  + I podlasie
	0x002d5249, // n0x1707 c0x0000 (---------------)  + I polkowice
	0x0021a889, // n0x1708 c0x0000 (---------------)  + I pomorskie
	0x002d5e07, // n0x1709 c0x0000 (---------------)  + I pomorze
	0x002249c6, // n0x170a c0x0000 (---------------)  + I powiat
	0x002d7986, // n0x170b c0x0000 (---------------)  + I poznan
	0x002d82c4, // n0x170c c0x0000 (---------------)  + I priv
	0x002d844a, // n0x170d c0x0000 (---------------)  + I prochowice
	0x002db608, // n0x170e c0x0000 (---------------)  + I pruszkow
	0x002db809, // n0x170f c0x0000 (---------------)  + I przeworsk
	0x002e5a06, // n0x1710 c0x0000 (---------------)  + I pulawy
	0x00358945, // n0x1711 c0x0000 (---------------)  + I radom
	0x00207f48, // n0x1712 c0x0000 (---------------)  + I rawa-maz
	0x002bfd0a, // n0x1713 c0x0000 (---------------)  + I realestate
	0x00280183, // n0x1714 c0x0000 (---------------)  + I rel
	0x00311106, // n0x1715 c0x0000 (---------------)  + I rybnik
	0x002d5f07, // n0x1716 c0x0000 (---------------)  + I rzeszow
	0x0032d185, // n0x1717 c0x0000 (---------------)  + I sanok
	0x00279f45, // n0x1718 c0x0000 (---------------)  + I sejny
	0x002488c3, // n0x1719 c0x0000 (---------------)  + I sex
	0x0024f584, // n0x171a c0x0000 (---------------)  + I shop
	0x002d4c87, // n0x171b c0x0000 (---------------)  + I siedlce
	0x0022a705, // n0x171c c0x0000 (---------------)  + I sklep
	0x0027f247, // n0x171d c0x0000 (---------------)  + I skoczow
	0x002f20c5, // n0x171e c0x0000 (---------------)  + I slask
	0x002e0f86, // n0x171f c0x0000 (---------------)  + I slupsk
	0x002e2985, // n0x1720 c0x0000 (---------------)  + I sopot
	0x00270783, // n0x1721 c0x0000 (---------------)  + I sos
	0x00270789, // n0x1722 c0x0000 (---------------)  + I sosnowiec
	0x002724cc, // n0x1723 c0x0000 (---------------)  + I stalowa-wola
	0x002ac80c, // n0x1724 c0x0000 (---------------)  + I starachowice
	0x0021b408, // n0x1725 c0x0000 (---------------)  + I stargard
	0x002c7507, // n0x1726 c0x0000 (---------------)  + I suwalki
	0x002ed5c8, // n0x1727 c0x0000 (---------------)  + I swidnica
	0x002ed94a, // n0x1728 c0x0000 (---------------)  + I swiebodzin
	0x002edd0b, // n0x1729 c0x0000 (---------------)  + I swinoujscie
	0x002c6bc8, // n0x172a c0x0000 (---------------)  + I szczecin
	0x002b0b08, // n0x172b c0x0000 (---------------)  + I szczytno
	0x0020b306, // n0x172c c0x0000 (---------------)  + I szkola
	0x00201685, // n0x172d c0x0000 (---------------)  + I targi
	0x0021caca, // n0x172e c0x0000 (---------------)  + I tarnobrzeg
	0x00230a45, // n0x172f c0x0000 (---------------)  + I tgory
	0x00200142, // n0x1730 c0x0000 (---------------)  + I tm
	0x002bd047, // n0x1731 c0x0000 (---------------)  + I tourism
	0x00296ac6, // n0x1732 c0x0000 (---------------)  + I travel
	0x00333c05, // n0x1733 c0x0000 (---------------)  + I turek
	0x002ef809, // n0x1734 c0x0000 (---------------)  + I turystyka
	0x00357e85, // n0x1735 c0x0000 (---------------)  + I tychy
	0x0028cd86, // n0x1736 c0x0000 (---------------)  + I usenet
	0x002a5f45, // n0x1737 c0x0000 (---------------)  + I ustka
	0x0030fd89, // n0x1738 c0x0000 (---------------)  + I walbrzych
	0x0022be06, // n0x1739 c0x0000 (---------------)  + I warmia
	0x00248d08, // n0x173a c0x0000 (---------------)  + I warszawa
	0x00255403, // n0x173b c0x0000 (---------------)  + I waw
	0x00208f46, // n0x173c c0x0000 (---------------)  + I wegrow
	0x00271986, // n0x173d c0x0000 (---------------)  + I wielun
	0x0025ff45, // n0x173e c0x0000 (---------------)  + I wlocl
	0x0025ff49, // n0x173f c0x0000 (---------------)  + I wloclawek
	0x00208d49, // n0x1740 c0x0000 (---------------)  + I wodzislaw
	0x003073c7, // n0x1741 c0x0000 (---------------)  + I wolomin
	0x002ad984, // n0x1742 c0x0000 (---------------)  + I wroc
	0x002ad987, // n0x1743 c0x0000 (---------------)  + I wroclaw
	0x0021a789, // n0x1744 c0x0000 (---------------)  + I zachpomor
	0x0023c885, // n0x1745 c0x0000 (---------------)  + I zagan
	0x0020b688, // n0x1746 c0x0000 (---------------)  + I zakopane
	0x0031e3c5, // n0x1747 c0x0000 (---------------)  + I zarow
	0x00228805, // n0x1748 c0x0000 (---------------)  + I zgora
	0x002489c9, // n0x1749 c0x0000 (---------------)  + I zgorzelec
	0x002001c2, // n0x174a c0x0000 (---------------)  + I pa
	0x00205982, // n0x174b c0x0000 (---------------)  + I po
	0x00206102, // n0x174c c0x0000 (---------------)  + I so
	0x002c4342, // n0x174d c0x0000 (---------------)  + I sr
	0x00208b89, // n0x174e c0x0000 (---------------)  + I starostwo
	0x00204142, // n0x174f c0x0000 (---------------)  + I ug
	0x002049c2, // n0x1750 c0x0000 (---------------)  + I um
	0x00224984, // n0x1751 c0x0000 (---------------)  + I upow
	0x0023e202, // n0x1752 c0x0000 (---------------)  + I uw
	0x00207a02, // n0x1753 c0x0000 (---------------)  + I co
	0x0027a643, // n0x1754 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1755 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1756 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1757 c0x0000 (---------------)  + I org
	0x00201d82, // n0x1758 c0x0000 (---------------)  + I ac
	0x00314c43, // n0x1759 c0x0000 (---------------)  + I biz
	0x00222603, // n0x175a c0x0000 (---------------)  + I com
	0x0027a643, // n0x175b c0x0000 (---------------)  + I edu
	0x002090c3, // n0x175c c0x0000 (---------------)  + I est
	0x002157c3, // n0x175d c0x0000 (---------------)  + I gov
	0x0021c704, // n0x175e c0x0000 (---------------)  + I info
	0x00208e44, // n0x175f c0x0000 (---------------)  + I isla
	0x0022aec4, // n0x1760 c0x0000 (---------------)  + I name
	0x00201603, // n0x1761 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1762 c0x0000 (---------------)  + I org
	0x002d8443, // n0x1763 c0x0000 (---------------)  + I pro
	0x002d9104, // n0x1764 c0x0000 (---------------)  + I prof
	0x00270403, // n0x1765 c0x0000 (---------------)  + I aca
	0x0020d2c3, // n0x1766 c0x0000 (---------------)  + I bar
	0x002368c3, // n0x1767 c0x0000 (---------------)  + I cpa
	0x00202e03, // n0x1768 c0x0000 (---------------)  + I eng
	0x002aa003, // n0x1769 c0x0000 (---------------)  + I jur
	0x00208ec3, // n0x176a c0x0000 (---------------)  + I law
	0x00225d03, // n0x176b c0x0000 (---------------)  + I med
	0x00222603, // n0x176c c0x0000 (---------------)  + I com
	0x0027a643, // n0x176d c0x0000 (---------------)  + I edu
	0x002157c3, // n0x176e c0x0000 (---------------)  + I gov
	0x00201603, // n0x176f c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1770 c0x0000 (---------------)  + I org
	0x002d40c3, // n0x1771 c0x0000 (---------------)  + I plo
	0x002f0e43, // n0x1772 c0x0000 (---------------)  + I sec
	0x000b8948, // n0x1773 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x1774 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1775 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1776 c0x0000 (---------------)  + I gov
	0x00223a83, // n0x1777 c0x0000 (---------------)  + I int
	0x00201603, // n0x1778 c0x0000 (---------------)  + I net
	0x0023da04, // n0x1779 c0x0000 (---------------)  + I nome
	0x0021f5c3, // n0x177a c0x0000 (---------------)  + I org
	0x002aa584, // n0x177b c0x0000 (---------------)  + I publ
	0x002b3905, // n0x177c c0x0000 (---------------)  + I belau
	0x00207a02, // n0x177d c0x0000 (---------------)  + I co
	0x00202542, // n0x177e c0x0000 (---------------)  + I ed
	0x00206cc2, // n0x177f c0x0000 (---------------)  + I go
	0x00201602, // n0x1780 c0x0000 (---------------)  + I ne
	0x00200bc2, // n0x1781 c0x0000 (---------------)  + I or
	0x00222603, // n0x1782 c0x0000 (---------------)  + I com
	0x00239dc4, // n0x1783 c0x0000 (---------------)  + I coop
	0x0027a643, // n0x1784 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1785 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x1786 c0x0000 (---------------)  + I mil
	0x00201603, // n0x1787 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1788 c0x0000 (---------------)  + I org
	0x00222603, // n0x1789 c0x0000 (---------------)  + I com
	0x0027a643, // n0x178a c0x0000 (---------------)  + I edu
	0x002157c3, // n0x178b c0x0000 (---------------)  + I gov
	0x0023f703, // n0x178c c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x178d c0x0000 (---------------)  + I name
	0x00201603, // n0x178e c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x178f c0x0000 (---------------)  + I org
	0x002526c3, // n0x1790 c0x0000 (---------------)  + I sch
	0x0029cfc4, // n0x1791 c0x0000 (---------------)  + I asso
	0x000b8948, // n0x1792 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x1793 c0x0000 (---------------)  + I com
	0x00214103, // n0x1794 c0x0000 (---------------)  + I nom
	0x002180c4, // n0x1795 c0x0000 (---------------)  + I arts
	0x000b8948, // n0x1796 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x1797 c0x0000 (---------------)  + I com
	0x00245bc4, // n0x1798 c0x0000 (---------------)  + I firm
	0x0021c704, // n0x1799 c0x0000 (---------------)  + I info
	0x00214103, // n0x179a c0x0000 (---------------)  + I nom
	0x0020ddc2, // n0x179b c0x0000 (---------------)  + I nt
	0x0021f5c3, // n0x179c c0x0000 (---------------)  + I org
	0x00227783, // n0x179d c0x0000 (---------------)  + I rec
	0x002e9885, // n0x179e c0x0000 (---------------)  + I store
	0x00200142, // n0x179f c0x0000 (---------------)  + I tm
	0x002c3243, // n0x17a0 c0x0000 (---------------)  + I www
	0x00201d82, // n0x17a1 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x17a2 c0x0000 (---------------)  + I co
	0x0027a643, // n0x17a3 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x17a4 c0x0000 (---------------)  + I gov
	0x002015c2, // n0x17a5 c0x0000 (---------------)  + I in
	0x0021f5c3, // n0x17a6 c0x0000 (---------------)  + I org
	0x00201d82, // n0x17a7 c0x0000 (---------------)  + I ac
	0x00374987, // n0x17a8 c0x0000 (---------------)  + I adygeya
	0x00315f05, // n0x17a9 c0x0000 (---------------)  + I altai
	0x00285484, // n0x17aa c0x0000 (---------------)  + I amur
	0x002ddf06, // n0x17ab c0x0000 (---------------)  + I amursk
	0x00252c0b, // n0x17ac c0x0000 (---------------)  + I arkhangelsk
	0x00278689, // n0x17ad c0x0000 (---------------)  + I astrakhan
	0x002b0946, // n0x17ae c0x0000 (---------------)  + I baikal
	0x0031dfc9, // n0x17af c0x0000 (---------------)  + I bashkiria
	0x002bd708, // n0x17b0 c0x0000 (---------------)  + I belgorod
	0x002052c3, // n0x17b1 c0x0000 (---------------)  + I bir
	0x00221e47, // n0x17b2 c0x0000 (---------------)  + I bryansk
	0x00220ec8, // n0x17b3 c0x0000 (---------------)  + I buryatia
	0x00367803, // n0x17b4 c0x0000 (---------------)  + I cbg
	0x0024a4c4, // n0x17b5 c0x0000 (---------------)  + I chel
	0x0024d40b, // n0x17b6 c0x0000 (---------------)  + I chelyabinsk
	0x0029bd05, // n0x17b7 c0x0000 (---------------)  + I chita
	0x0028c388, // n0x17b8 c0x0000 (---------------)  + I chukotka
	0x003370c9, // n0x17b9 c0x0000 (---------------)  + I chuvashia
	0x0025fec3, // n0x17ba c0x0000 (---------------)  + I cmw
	0x00222603, // n0x17bb c0x0000 (---------------)  + I com
	0x00319708, // n0x17bc c0x0000 (---------------)  + I dagestan
	0x00278fc7, // n0x17bd c0x0000 (---------------)  + I dudinka
	0x002e8a86, // n0x17be c0x0000 (---------------)  + I e-burg
	0x0027a643, // n0x17bf c0x0000 (---------------)  + I edu
	0x00333407, // n0x17c0 c0x0000 (---------------)  + I fareast
	0x002157c3, // n0x17c1 c0x0000 (---------------)  + I gov
	0x00231e86, // n0x17c2 c0x0000 (---------------)  + I grozny
	0x00223a83, // n0x17c3 c0x0000 (---------------)  + I int
	0x0022a5c7, // n0x17c4 c0x0000 (---------------)  + I irkutsk
	0x00269407, // n0x17c5 c0x0000 (---------------)  + I ivanovo
	0x00358647, // n0x17c6 c0x0000 (---------------)  + I izhevsk
	0x002218c5, // n0x17c7 c0x0000 (---------------)  + I jamal
	0x00202703, // n0x17c8 c0x0000 (---------------)  + I jar
	0x002b180b, // n0x17c9 c0x0000 (---------------)  + I joshkar-ola
	0x0021bc08, // n0x17ca c0x0000 (---------------)  + I k-uralsk
	0x0023b9c8, // n0x17cb c0x0000 (---------------)  + I kalmykia
	0x0036c686, // n0x17cc c0x0000 (---------------)  + I kaluga
	0x00342609, // n0x17cd c0x0000 (---------------)  + I kamchatka
	0x00302a87, // n0x17ce c0x0000 (---------------)  + I karelia
	0x002f8385, // n0x17cf c0x0000 (---------------)  + I kazan
	0x0023c184, // n0x17d0 c0x0000 (---------------)  + I kchr
	0x00317208, // n0x17d1 c0x0000 (---------------)  + I kemerovo
	0x00241bca, // n0x17d2 c0x0000 (---------------)  + I khabarovsk
	0x00241e09, // n0x17d3 c0x0000 (---------------)  + I khakassia
	0x00267f43, // n0x17d4 c0x0000 (---------------)  + I khv
	0x0033a9c5, // n0x17d5 c0x0000 (---------------)  + I kirov
	0x00289683, // n0x17d6 c0x0000 (---------------)  + I kms
	0x002fc106, // n0x17d7 c0x0000 (---------------)  + I koenig
	0x002d12c4, // n0x17d8 c0x0000 (---------------)  + I komi
	0x002fed88, // n0x17d9 c0x0000 (---------------)  + I kostroma
	0x002ade8b, // n0x17da c0x0000 (---------------)  + I krasnoyarsk
	0x0034c305, // n0x17db c0x0000 (---------------)  + I kuban
	0x002b3686, // n0x17dc c0x0000 (---------------)  + I kurgan
	0x002b6085, // n0x17dd c0x0000 (---------------)  + I kursk
	0x002b7088, // n0x17de c0x0000 (---------------)  + I kustanai
	0x002b7ec7, // n0x17df c0x0000 (---------------)  + I kuzbass
	0x002020c7, // n0x17e0 c0x0000 (---------------)  + I lipetsk
	0x00309e07, // n0x17e1 c0x0000 (---------------)  + I magadan
	0x0021ea88, // n0x17e2 c0x0000 (---------------)  + I magnitka
	0x0023cb44, // n0x17e3 c0x0000 (---------------)  + I mari
	0x0023cb47, // n0x17e4 c0x0000 (---------------)  + I mari-el
	0x0033dec6, // n0x17e5 c0x0000 (---------------)  + I marine
	0x0023f703, // n0x17e6 c0x0000 (---------------)  + I mil
	0x002c16c8, // n0x17e7 c0x0000 (---------------)  + I mordovia
	0x002c42c6, // n0x17e8 c0x0000 (---------------)  + I mosreg
	0x00230643, // n0x17e9 c0x0000 (---------------)  + I msk
	0x002c9208, // n0x17ea c0x0000 (---------------)  + I murmansk
	0x002cbd85, // n0x17eb c0x0000 (---------------)  + I mytis
	0x002879c8, // n0x17ec c0x0000 (---------------)  + I nakhodka
	0x0027a847, // n0x17ed c0x0000 (---------------)  + I nalchik
	0x00201603, // n0x17ee c0x0000 (---------------)  + I net
	0x003627c3, // n0x17ef c0x0000 (---------------)  + I nkz
	0x00286544, // n0x17f0 c0x0000 (---------------)  + I nnov
	0x00310807, // n0x17f1 c0x0000 (---------------)  + I norilsk
	0x00213b83, // n0x17f2 c0x0000 (---------------)  + I nov
	0x002694cb, // n0x17f3 c0x0000 (---------------)  + I novosibirsk
	0x0020ca43, // n0x17f4 c0x0000 (---------------)  + I nsk
	0x00230604, // n0x17f5 c0x0000 (---------------)  + I omsk
	0x002e9908, // n0x17f6 c0x0000 (---------------)  + I orenburg
	0x0021f5c3, // n0x17f7 c0x0000 (---------------)  + I org
	0x002e90c5, // n0x17f8 c0x0000 (---------------)  + I oryol
	0x0024d185, // n0x17f9 c0x0000 (---------------)  + I oskol
	0x00344b06, // n0x17fa c0x0000 (---------------)  + I palana
	0x0021e4c5, // n0x17fb c0x0000 (---------------)  + I penza
	0x002cc144, // n0x17fc c0x0000 (---------------)  + I perm
	0x00200f02, // n0x17fd c0x0000 (---------------)  + I pp
	0x002dbac3, // n0x17fe c0x0000 (---------------)  + I ptz
	0x002b1aca, // n0x17ff c0x0000 (---------------)  + I pyatigorsk
	0x00347143, // n0x1800 c0x0000 (---------------)  + I rnd
	0x002474c9, // n0x1801 c0x0000 (---------------)  + I rubtsovsk
	0x00237046, // n0x1802 c0x0000 (---------------)  + I ryazan
	0x0022ca48, // n0x1803 c0x0000 (---------------)  + I sakhalin
	0x00288746, // n0x1804 c0x0000 (---------------)  + I samara
	0x0023ea87, // n0x1805 c0x0000 (---------------)  + I saratov
	0x002e0088, // n0x1806 c0x0000 (---------------)  + I simbirsk
	0x002483c8, // n0x1807 c0x0000 (---------------)  + I smolensk
	0x002e1643, // n0x1808 c0x0000 (---------------)  + I snz
	0x002e65c3, // n0x1809 c0x0000 (---------------)  + I spb
	0x0023edc9, // n0x180a c0x0000 (---------------)  + I stavropol
	0x002f5e83, // n0x180b c0x0000 (---------------)  + I stv
	0x002f4446, // n0x180c c0x0000 (---------------)  + I surgut
	0x002162c6, // n0x180d c0x0000 (---------------)  + I syzran
	0x003476c6, // n0x180e c0x0000 (---------------)  + I tambov
	0x00224b09, // n0x180f c0x0000 (---------------)  + I tatarstan
	0x002b8784, // n0x1810 c0x0000 (---------------)  + I test
	0x0022a503, // n0x1811 c0x0000 (---------------)  + I tom
	0x00243a85, // n0x1812 c0x0000 (---------------)  + I tomsk
	0x0036b849, // n0x1813 c0x0000 (---------------)  + I tsaritsyn
	0x002021c3, // n0x1814 c0x0000 (---------------)  + I tsk
	0x002ef544, // n0x1815 c0x0000 (---------------)  + I tula
	0x002f0504, // n0x1816 c0x0000 (---------------)  + I tuva
	0x002f0944, // n0x1817 c0x0000 (---------------)  + I tver
	0x002db486, // n0x1818 c0x0000 (---------------)  + I tyumen
	0x00302183, // n0x1819 c0x0000 (---------------)  + I udm
	0x00302188, // n0x181a c0x0000 (---------------)  + I udmurtia
	0x00256788, // n0x181b c0x0000 (---------------)  + I ulan-ude
	0x002f15c6, // n0x181c c0x0000 (---------------)  + I vdonsk
	0x002f818b, // n0x181d c0x0000 (---------------)  + I vladikavkaz
	0x002f84c8, // n0x181e c0x0000 (---------------)  + I vladimir
	0x002f86cb, // n0x181f c0x0000 (---------------)  + I vladivostok
	0x002f9149, // n0x1820 c0x0000 (---------------)  + I volgograd
	0x002f9c87, // n0x1821 c0x0000 (---------------)  + I vologda
	0x002faa88, // n0x1822 c0x0000 (---------------)  + I voronezh
	0x002fbc43, // n0x1823 c0x0000 (---------------)  + I vrn
	0x00205746, // n0x1824 c0x0000 (---------------)  + I vyatka
	0x0031ab07, // n0x1825 c0x0000 (---------------)  + I yakutia
	0x00292485, // n0x1826 c0x0000 (---------------)  + I yamal
	0x0032b3c9, // n0x1827 c0x0000 (---------------)  + I yaroslavl
	0x00317c0d, // n0x1828 c0x0000 (---------------)  + I yekaterinburg
	0x0022c891, // n0x1829 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x00245f85, // n0x182a c0x0000 (---------------)  + I zgrad
	0x00201d82, // n0x182b c0x0000 (---------------)  + I ac
	0x00207a02, // n0x182c c0x0000 (---------------)  + I co
	0x00222603, // n0x182d c0x0000 (---------------)  + I com
	0x0027a643, // n0x182e c0x0000 (---------------)  + I edu
	0x00368f84, // n0x182f c0x0000 (---------------)  + I gouv
	0x002157c3, // n0x1830 c0x0000 (---------------)  + I gov
	0x00223a83, // n0x1831 c0x0000 (---------------)  + I int
	0x0023f703, // n0x1832 c0x0000 (---------------)  + I mil
	0x00201603, // n0x1833 c0x0000 (---------------)  + I net
	0x00222603, // n0x1834 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1835 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1836 c0x0000 (---------------)  + I gov
	0x00225d03, // n0x1837 c0x0000 (---------------)  + I med
	0x00201603, // n0x1838 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1839 c0x0000 (---------------)  + I org
	0x00200f43, // n0x183a c0x0000 (---------------)  + I pub
	0x002526c3, // n0x183b c0x0000 (---------------)  + I sch
	0x00222603, // n0x183c c0x0000 (---------------)  + I com
	0x0027a643, // n0x183d c0x0000 (---------------)  + I edu
	0x002157c3, // n0x183e c0x0000 (---------------)  + I gov
	0x00201603, // n0x183f c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1840 c0x0000 (---------------)  + I org
	0x00222603, // n0x1841 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1842 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1843 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1844 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1845 c0x0000 (---------------)  + I org
	0x00222603, // n0x1846 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1847 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1848 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x1849 c0x0000 (---------------)  + I info
	0x00225d03, // n0x184a c0x0000 (---------------)  + I med
	0x00201603, // n0x184b c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x184c c0x0000 (---------------)  + I org
	0x00292602, // n0x184d c0x0000 (---------------)  + I tv
	0x00200101, // n0x184e c0x0000 (---------------)  + I a
	0x00201d82, // n0x184f c0x0000 (---------------)  + I ac
	0x00200001, // n0x1850 c0x0000 (---------------)  + I b
	0x00304282, // n0x1851 c0x0000 (---------------)  + I bd
	0x000b8948, // n0x1852 c0x0000 (---------------)  +   blogspot
	0x002167c5, // n0x1853 c0x0000 (---------------)  + I brand
	0x00200601, // n0x1854 c0x0000 (---------------)  + I c
	0x00022603, // n0x1855 c0x0000 (---------------)  +   com
	0x00200741, // n0x1856 c0x0000 (---------------)  + I d
	0x00200081, // n0x1857 c0x0000 (---------------)  + I e
	0x002003c1, // n0x1858 c0x0000 (---------------)  + I f
	0x00241b02, // n0x1859 c0x0000 (---------------)  + I fh
	0x00241b04, // n0x185a c0x0000 (---------------)  + I fhsk
	0x00242043, // n0x185b c0x0000 (---------------)  + I fhv
	0x002004c1, // n0x185c c0x0000 (---------------)  + I g
	0x00200641, // n0x185d c0x0000 (---------------)  + I h
	0x00200041, // n0x185e c0x0000 (---------------)  + I i
	0x00200441, // n0x185f c0x0000 (---------------)  + I k
	0x0036c147, // n0x1860 c0x0000 (---------------)  + I komforb
	0x002e128f, // n0x1861 c0x0000 (---------------)  + I kommunalforbund
	0x002cc486, // n0x1862 c0x0000 (---------------)  + I komvux
	0x00200801, // n0x1863 c0x0000 (---------------)  + I l
	0x00266a86, // n0x1864 c0x0000 (---------------)  + I lanbib
	0x00200181, // n0x1865 c0x0000 (---------------)  + I m
	0x00200241, // n0x1866 c0x0000 (---------------)  + I n
	0x00327c0e, // n0x1867 c0x0000 (---------------)  + I naturbruksgymn
	0x00200841, // n0x1868 c0x0000 (---------------)  + I o
	0x0021f5c3, // n0x1869 c0x0000 (---------------)  + I org
	0x002001c1, // n0x186a c0x0000 (---------------)  + I p
	0x00236685, // n0x186b c0x0000 (---------------)  + I parti
	0x00200f02, // n0x186c c0x0000 (---------------)  + I pp
	0x002487c5, // n0x186d c0x0000 (---------------)  + I press
	0x00200a81, // n0x186e c0x0000 (---------------)  + I r
	0x00200941, // n0x186f c0x0000 (---------------)  + I s
	0x00200141, // n0x1870 c0x0000 (---------------)  + I t
	0x00200142, // n0x1871 c0x0000 (---------------)  + I tm
	0x00200401, // n0x1872 c0x0000 (---------------)  + I u
	0x00200541, // n0x1873 c0x0000 (---------------)  + I w
	0x00208281, // n0x1874 c0x0000 (---------------)  + I x
	0x00200d41, // n0x1875 c0x0000 (---------------)  + I y
	0x00201481, // n0x1876 c0x0000 (---------------)  + I z
	0x000b8948, // n0x1877 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x1878 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1879 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x187a c0x0000 (---------------)  + I gov
	0x00201603, // n0x187b c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x187c c0x0000 (---------------)  + I org
	0x00222483, // n0x187d c0x0000 (---------------)  + I per
	0x00222603, // n0x187e c0x0000 (---------------)  + I com
	0x002157c3, // n0x187f c0x0000 (---------------)  + I gov
	0x0023f703, // n0x1880 c0x0000 (---------------)  + I mil
	0x00201603, // n0x1881 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1882 c0x0000 (---------------)  + I org
	0x000b8948, // n0x1883 c0x0000 (---------------)  +   blogspot
	0x00222603, // n0x1884 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1885 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1886 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1887 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1888 c0x0000 (---------------)  + I org
	0x00201383, // n0x1889 c0x0000 (---------------)  + I art
	0x00222603, // n0x188a c0x0000 (---------------)  + I com
	0x0027a643, // n0x188b c0x0000 (---------------)  + I edu
	0x00368f84, // n0x188c c0x0000 (---------------)  + I gouv
	0x0021f5c3, // n0x188d c0x0000 (---------------)  + I org
	0x002f1945, // n0x188e c0x0000 (---------------)  + I perso
	0x003688c4, // n0x188f c0x0000 (---------------)  + I univ
	0x00222603, // n0x1890 c0x0000 (---------------)  + I com
	0x00201603, // n0x1891 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1892 c0x0000 (---------------)  + I org
	0x00207a02, // n0x1893 c0x0000 (---------------)  + I co
	0x00222603, // n0x1894 c0x0000 (---------------)  + I com
	0x00235089, // n0x1895 c0x0000 (---------------)  + I consulado
	0x0027a643, // n0x1896 c0x0000 (---------------)  + I edu
	0x0029dc09, // n0x1897 c0x0000 (---------------)  + I embaixada
	0x002157c3, // n0x1898 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x1899 c0x0000 (---------------)  + I mil
	0x00201603, // n0x189a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x189b c0x0000 (---------------)  + I org
	0x002d80c8, // n0x189c c0x0000 (---------------)  + I principe
	0x00234787, // n0x189d c0x0000 (---------------)  + I saotome
	0x002e9885, // n0x189e c0x0000 (---------------)  + I store
	0x00222603, // n0x189f c0x0000 (---------------)  + I com
	0x0027a643, // n0x18a0 c0x0000 (---------------)  + I edu
	0x0020dbc3, // n0x18a1 c0x0000 (---------------)  + I gob
	0x0021f5c3, // n0x18a2 c0x0000 (---------------)  + I org
	0x0023e843, // n0x18a3 c0x0000 (---------------)  + I red
	0x002157c3, // n0x18a4 c0x0000 (---------------)  + I gov
	0x00222603, // n0x18a5 c0x0000 (---------------)  + I com
	0x0027a643, // n0x18a6 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x18a7 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x18a8 c0x0000 (---------------)  + I mil
	0x00201603, // n0x18a9 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x18aa c0x0000 (---------------)  + I org
	0x00201d82, // n0x18ab c0x0000 (---------------)  + I ac
	0x00207a02, // n0x18ac c0x0000 (---------------)  + I co
	0x0021f5c3, // n0x18ad c0x0000 (---------------)  + I org
	0x000b8948, // n0x18ae c0x0000 (---------------)  +   blogspot
	0x00201d82, // n0x18af c0x0000 (---------------)  + I ac
	0x00207a02, // n0x18b0 c0x0000 (---------------)  + I co
	0x00206cc2, // n0x18b1 c0x0000 (---------------)  + I go
	0x002015c2, // n0x18b2 c0x0000 (---------------)  + I in
	0x00207e02, // n0x18b3 c0x0000 (---------------)  + I mi
	0x00201603, // n0x18b4 c0x0000 (---------------)  + I net
	0x00200bc2, // n0x18b5 c0x0000 (---------------)  + I or
	0x00201d82, // n0x18b6 c0x0000 (---------------)  + I ac
	0x00314c43, // n0x18b7 c0x0000 (---------------)  + I biz
	0x00207a02, // n0x18b8 c0x0000 (---------------)  + I co
	0x00222603, // n0x18b9 c0x0000 (---------------)  + I com
	0x0027a643, // n0x18ba c0x0000 (---------------)  + I edu
	0x00206cc2, // n0x18bb c0x0000 (---------------)  + I go
	0x002157c3, // n0x18bc c0x0000 (---------------)  + I gov
	0x00223a83, // n0x18bd c0x0000 (---------------)  + I int
	0x0023f703, // n0x18be c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x18bf c0x0000 (---------------)  + I name
	0x00201603, // n0x18c0 c0x0000 (---------------)  + I net
	0x00213e03, // n0x18c1 c0x0000 (---------------)  + I nic
	0x0021f5c3, // n0x18c2 c0x0000 (---------------)  + I org
	0x002b8784, // n0x18c3 c0x0000 (---------------)  + I test
	0x00205e43, // n0x18c4 c0x0000 (---------------)  + I web
	0x002157c3, // n0x18c5 c0x0000 (---------------)  + I gov
	0x00207a02, // n0x18c6 c0x0000 (---------------)  + I co
	0x00222603, // n0x18c7 c0x0000 (---------------)  + I com
	0x0027a643, // n0x18c8 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x18c9 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x18ca c0x0000 (---------------)  + I mil
	0x00201603, // n0x18cb c0x0000 (---------------)  + I net
	0x00214103, // n0x18cc c0x0000 (---------------)  + I nom
	0x0021f5c3, // n0x18cd c0x0000 (---------------)  + I org
	0x00362587, // n0x18ce c0x0000 (---------------)  + I agrinet
	0x00222603, // n0x18cf c0x0000 (---------------)  + I com
	0x00256907, // n0x18d0 c0x0000 (---------------)  + I defense
	0x0031dac6, // n0x18d1 c0x0000 (---------------)  + I edunet
	0x00203a03, // n0x18d2 c0x0000 (---------------)  + I ens
	0x0021c5c3, // n0x18d3 c0x0000 (---------------)  + I fin
	0x002157c3, // n0x18d4 c0x0000 (---------------)  + I gov
	0x00214b03, // n0x18d5 c0x0000 (---------------)  + I ind
	0x0021c704, // n0x18d6 c0x0000 (---------------)  + I info
	0x002f47c4, // n0x18d7 c0x0000 (---------------)  + I intl
	0x002cc206, // n0x18d8 c0x0000 (---------------)  + I mincom
	0x0020cd83, // n0x18d9 c0x0000 (---------------)  + I nat
	0x00201603, // n0x18da c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x18db c0x0000 (---------------)  + I org
	0x002f1945, // n0x18dc c0x0000 (---------------)  + I perso
	0x002a2404, // n0x18dd c0x0000 (---------------)  + I rnrt
	0x00243e03, // n0x18de c0x0000 (---------------)  + I rns
	0x00360583, // n0x18df c0x0000 (---------------)  + I rnu
	0x002bd047, // n0x18e0 c0x0000 (---------------)  + I tourism
	0x0029a785, // n0x18e1 c0x0000 (---------------)  + I turen
	0x00222603, // n0x18e2 c0x0000 (---------------)  + I com
	0x0027a643, // n0x18e3 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x18e4 c0x0000 (---------------)  + I gov
	0x0023f703, // n0x18e5 c0x0000 (---------------)  + I mil
	0x00201603, // n0x18e6 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x18e7 c0x0000 (---------------)  + I org
	0x002025c2, // n0x18e8 c0x0000 (---------------)  + I av
	0x00216e43, // n0x18e9 c0x0000 (---------------)  + I bbs
	0x0021ddc3, // n0x18ea c0x0000 (---------------)  + I bel
	0x00314c43, // n0x18eb c0x0000 (---------------)  + I biz
	0x00222603, // n0x18ec c0x0000 (---------------)  + I com
	0x00203982, // n0x18ed c0x0000 (---------------)  + I dr
	0x0027a643, // n0x18ee c0x0000 (---------------)  + I edu
	0x00204b03, // n0x18ef c0x0000 (---------------)  + I gen
	0x002157c3, // n0x18f0 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x18f1 c0x0000 (---------------)  + I info
	0x0021bdc3, // n0x18f2 c0x0000 (---------------)  + I k12
	0x00349bc3, // n0x18f3 c0x0000 (---------------)  + I kep
	0x0023f703, // n0x18f4 c0x0000 (---------------)  + I mil
	0x0022aec4, // n0x18f5 c0x0000 (---------------)  + I name
	0x4aa0c1c2, // n0x18f6 c0x012a (n0x18fd-n0x18fe)  + I nc
	0x00201603, // n0x18f7 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x18f8 c0x0000 (---------------)  + I org
	0x00214cc3, // n0x18f9 c0x0000 (---------------)  + I pol
	0x00223b03, // n0x18fa c0x0000 (---------------)  + I tel
	0x00292602, // n0x18fb c0x0000 (---------------)  + I tv
	0x00205e43, // n0x18fc c0x0000 (---------------)  + I web
	0x002157c3, // n0x18fd c0x0000 (---------------)  + I gov
	0x0027a1c4, // n0x18fe c0x0000 (---------------)  + I aero
	0x00314c43, // n0x18ff c0x0000 (---------------)  + I biz
	0x00207a02, // n0x1900 c0x0000 (---------------)  + I co
	0x00222603, // n0x1901 c0x0000 (---------------)  + I com
	0x00239dc4, // n0x1902 c0x0000 (---------------)  + I coop
	0x0027a643, // n0x1903 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1904 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x1905 c0x0000 (---------------)  + I info
	0x00223a83, // n0x1906 c0x0000 (---------------)  + I int
	0x002deb44, // n0x1907 c0x0000 (---------------)  + I jobs
	0x0020e884, // n0x1908 c0x0000 (---------------)  + I mobi
	0x002cb0c6, // n0x1909 c0x0000 (---------------)  + I museum
	0x0022aec4, // n0x190a c0x0000 (---------------)  + I name
	0x00201603, // n0x190b c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x190c c0x0000 (---------------)  + I org
	0x002d8443, // n0x190d c0x0000 (---------------)  + I pro
	0x00296ac6, // n0x190e c0x0000 (---------------)  + I travel
	0x00051c8b, // n0x190f c0x0000 (---------------)  +   better-than
	0x00010c06, // n0x1910 c0x0000 (---------------)  +   dyndns
	0x0001f10a, // n0x1911 c0x0000 (---------------)  +   on-the-web
	0x0007f3ca, // n0x1912 c0x0000 (---------------)  +   worse-than
	0x000b8948, // n0x1913 c0x0000 (---------------)  +   blogspot
	0x002a4284, // n0x1914 c0x0000 (---------------)  + I club
	0x00222603, // n0x1915 c0x0000 (---------------)  + I com
	0x00314c04, // n0x1916 c0x0000 (---------------)  + I ebiz
	0x0027a643, // n0x1917 c0x0000 (---------------)  + I edu
	0x0028b744, // n0x1918 c0x0000 (---------------)  + I game
	0x002157c3, // n0x1919 c0x0000 (---------------)  + I gov
	0x00308f83, // n0x191a c0x0000 (---------------)  + I idv
	0x0023f703, // n0x191b c0x0000 (---------------)  + I mil
	0x00201603, // n0x191c c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x191d c0x0000 (---------------)  + I org
	0x003136cb, // n0x191e c0x0000 (---------------)  + I xn--czrw28b
	0x00363cca, // n0x191f c0x0000 (---------------)  + I xn--uc0atv
	0x00373d4c, // n0x1920 c0x0000 (---------------)  + I xn--zf0ao64a
	0x00201d82, // n0x1921 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x1922 c0x0000 (---------------)  + I co
	0x00206cc2, // n0x1923 c0x0000 (---------------)  + I go
	0x002a7585, // n0x1924 c0x0000 (---------------)  + I hotel
	0x0021c704, // n0x1925 c0x0000 (---------------)  + I info
	0x00202a02, // n0x1926 c0x0000 (---------------)  + I me
	0x0023f703, // n0x1927 c0x0000 (---------------)  + I mil
	0x0020e884, // n0x1928 c0x0000 (---------------)  + I mobi
	0x00201602, // n0x1929 c0x0000 (---------------)  + I ne
	0x00200bc2, // n0x192a c0x0000 (---------------)  + I or
	0x00218bc2, // n0x192b c0x0000 (---------------)  + I sc
	0x00292602, // n0x192c c0x0000 (---------------)  + I tv
	0x002b2449, // n0x192d c0x0000 (---------------)  + I cherkassy
	0x00262f88, // n0x192e c0x0000 (---------------)  + I cherkasy
	0x00265f09, // n0x192f c0x0000 (---------------)  + I chernigov
	0x00269249, // n0x1930 c0x0000 (---------------)  + I chernihiv
	0x0026cf4a, // n0x1931 c0x0000 (---------------)  + I chernivtsi
	0x0027098a, // n0x1932 c0x0000 (---------------)  + I chernovtsy
	0x00200882, // n0x1933 c0x0000 (---------------)  + I ck
	0x002309c2, // n0x1934 c0x0000 (---------------)  + I cn
	0x00207a02, // n0x1935 c0x0000 (---------------)  + I co
	0x00222603, // n0x1936 c0x0000 (---------------)  + I com
	0x00218282, // n0x1937 c0x0000 (---------------)  + I cr
	0x0023f946, // n0x1938 c0x0000 (---------------)  + I crimea
	0x003350c2, // n0x1939 c0x0000 (---------------)  + I cv
	0x0020b0c2, // n0x193a c0x0000 (---------------)  + I dn
	0x0036d88e, // n0x193b c0x0000 (---------------)  + I dnepropetrovsk
	0x0031454e, // n0x193c c0x0000 (---------------)  + I dnipropetrovsk
	0x00279847, // n0x193d c0x0000 (---------------)  + I dominic
	0x00207b87, // n0x193e c0x0000 (---------------)  + I donetsk
	0x002d02c2, // n0x193f c0x0000 (---------------)  + I dp
	0x0027a643, // n0x1940 c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1941 c0x0000 (---------------)  + I gov
	0x00200382, // n0x1942 c0x0000 (---------------)  + I if
	0x002015c2, // n0x1943 c0x0000 (---------------)  + I in
	0x002fe5cf, // n0x1944 c0x0000 (---------------)  + I ivano-frankivsk
	0x0020ad42, // n0x1945 c0x0000 (---------------)  + I kh
	0x00243b87, // n0x1946 c0x0000 (---------------)  + I kharkiv
	0x00245347, // n0x1947 c0x0000 (---------------)  + I kharkov
	0x00252e87, // n0x1948 c0x0000 (---------------)  + I kherson
	0x0026014c, // n0x1949 c0x0000 (---------------)  + I khmelnitskiy
	0x00261f0c, // n0x194a c0x0000 (---------------)  + I khmelnytskyi
	0x00204484, // n0x194b c0x0000 (---------------)  + I kiev
	0x0033a9ca, // n0x194c c0x0000 (---------------)  + I kirovograd
	0x00289682, // n0x194d c0x0000 (---------------)  + I km
	0x0020e742, // n0x194e c0x0000 (---------------)  + I kr
	0x002af444, // n0x194f c0x0000 (---------------)  + I krym
	0x0020b982, // n0x1950 c0x0000 (---------------)  + I ks
	0x002b9342, // n0x1951 c0x0000 (---------------)  + I kv
	0x00262144, // n0x1952 c0x0000 (---------------)  + I kyiv
	0x00213f02, // n0x1953 c0x0000 (---------------)  + I lg
	0x00220002, // n0x1954 c0x0000 (---------------)  + I lt
	0x0036c707, // n0x1955 c0x0000 (---------------)  + I lugansk
	0x002359c5, // n0x1956 c0x0000 (---------------)  + I lutsk
	0x00205002, // n0x1957 c0x0000 (---------------)  + I lv
	0x00242f44, // n0x1958 c0x0000 (---------------)  + I lviv
	0x0033f482, // n0x1959 c0x0000 (---------------)  + I mk
	0x002fe448, // n0x195a c0x0000 (---------------)  + I mykolaiv
	0x00201603, // n0x195b c0x0000 (---------------)  + I net
	0x0020ff88, // n0x195c c0x0000 (---------------)  + I nikolaev
	0x00208d82, // n0x195d c0x0000 (---------------)  + I od
	0x002384c5, // n0x195e c0x0000 (---------------)  + I odesa
	0x0034a246, // n0x195f c0x0000 (---------------)  + I odessa
	0x0021f5c3, // n0x1960 c0x0000 (---------------)  + I org
	0x0020bf42, // n0x1961 c0x0000 (---------------)  + I pl
	0x002d5487, // n0x1962 c0x0000 (---------------)  + I poltava
	0x00200f02, // n0x1963 c0x0000 (---------------)  + I pp
	0x002d8305, // n0x1964 c0x0000 (---------------)  + I rivne
	0x002ddb45, // n0x1965 c0x0000 (---------------)  + I rovno
	0x0020ee82, // n0x1966 c0x0000 (---------------)  + I rv
	0x00231a42, // n0x1967 c0x0000 (---------------)  + I sb
	0x0029968a, // n0x1968 c0x0000 (---------------)  + I sebastopol
	0x002a838a, // n0x1969 c0x0000 (---------------)  + I sevastopol
	0x00229dc2, // n0x196a c0x0000 (---------------)  + I sm
	0x002f58c4, // n0x196b c0x0000 (---------------)  + I sumy
	0x00201882, // n0x196c c0x0000 (---------------)  + I te
	0x002e7a08, // n0x196d c0x0000 (---------------)  + I ternopil
	0x00201442, // n0x196e c0x0000 (---------------)  + I uz
	0x0022c648, // n0x196f c0x0000 (---------------)  + I uzhgorod
	0x002f7247, // n0x1970 c0x0000 (---------------)  + I vinnica
	0x002f7549, // n0x1971 c0x0000 (---------------)  + I vinnytsia
	0x0020ff42, // n0x1972 c0x0000 (---------------)  + I vn
	0x002fa845, // n0x1973 c0x0000 (---------------)  + I volyn
	0x00315ec5, // n0x1974 c0x0000 (---------------)  + I yalta
	0x0036918b, // n0x1975 c0x0000 (---------------)  + I zaporizhzhe
	0x002d41cc, // n0x1976 c0x0000 (---------------)  + I zaporizhzhia
	0x0022a448, // n0x1977 c0x0000 (---------------)  + I zhitomir
	0x002fac08, // n0x1978 c0x0000 (---------------)  + I zhytomyr
	0x002cfac2, // n0x1979 c0x0000 (---------------)  + I zp
	0x00260ec2, // n0x197a c0x0000 (---------------)  + I zt
	0x00201d82, // n0x197b c0x0000 (---------------)  + I ac
	0x00207a02, // n0x197c c0x0000 (---------------)  + I co
	0x00222603, // n0x197d c0x0000 (---------------)  + I com
	0x00206cc2, // n0x197e c0x0000 (---------------)  + I go
	0x00201602, // n0x197f c0x0000 (---------------)  + I ne
	0x00200bc2, // n0x1980 c0x0000 (---------------)  + I or
	0x0021f5c3, // n0x1981 c0x0000 (---------------)  + I org
	0x00218bc2, // n0x1982 c0x0000 (---------------)  + I sc
	0x00201d82, // n0x1983 c0x0000 (---------------)  + I ac
	0x4ca07a02, // n0x1984 c0x0132 (n0x198e-n0x198f)  + I co
	0x4ce157c3, // n0x1985 c0x0133 (n0x198f-n0x1990)  + I gov
	0x00223143, // n0x1986 c0x0000 (---------------)  + I ltd
	0x00202a02, // n0x1987 c0x0000 (---------------)  + I me
	0x00201603, // n0x1988 c0x0000 (---------------)  + I net
	0x0020f003, // n0x1989 c0x0000 (---------------)  + I nhs
	0x0021f5c3, // n0x198a c0x0000 (---------------)  + I org
	0x002d2a43, // n0x198b c0x0000 (---------------)  + I plc
	0x0023ef46, // n0x198c c0x0000 (---------------)  + I police
	0x016526c3, // n0x198d c0x0005 (---------------)* o I sch
	0x000b8948, // n0x198e c0x0000 (---------------)  +   blogspot
	0x000a6887, // n0x198f c0x0000 (---------------)  +   service
	0x4d603542, // n0x1990 c0x0135 (n0x19cf-n0x19d2)  + I ak
	0x4da02082, // n0x1991 c0x0136 (n0x19d2-n0x19d5)  + I al
	0x4de00a42, // n0x1992 c0x0137 (n0x19d5-n0x19d8)  + I ar
	0x4e200902, // n0x1993 c0x0138 (n0x19d8-n0x19db)  + I as
	0x4e6034c2, // n0x1994 c0x0139 (n0x19db-n0x19de)  + I az
	0x4ea0bc02, // n0x1995 c0x013a (n0x19de-n0x19e1)  + I ca
	0x4ee07a02, // n0x1996 c0x013b (n0x19e1-n0x19e4)  + I co
	0x4f230cc2, // n0x1997 c0x013c (n0x19e4-n0x19e7)  + I ct
	0x4f618242, // n0x1998 c0x013d (n0x19e7-n0x19ea)  + I dc
	0x4fa02dc2, // n0x1999 c0x013e (n0x19ea-n0x19ed)  + I de
	0x002ed683, // n0x199a c0x0000 (---------------)  + I dni
	0x0022e3c3, // n0x199b c0x0000 (---------------)  + I fed
	0x4fe49682, // n0x199c c0x013f (n0x19ed-n0x19f0)  + I fl
	0x502004c2, // n0x199d c0x0140 (n0x19f0-n0x19f3)  + I ga
	0x50630742, // n0x199e c0x0141 (n0x19f3-n0x19f6)  + I gu
	0x50a00982, // n0x199f c0x0142 (n0x19f6-n0x19f8)  + I hi
	0x50e0b542, // n0x19a0 c0x0143 (n0x19f8-n0x19fb)  + I ia
	0x51202f82, // n0x19a1 c0x0144 (n0x19fb-n0x19fe)  + I id
	0x51603902, // n0x19a2 c0x0145 (n0x19fe-n0x1a01)  + I il
	0x51a015c2, // n0x19a3 c0x0146 (n0x1a01-n0x1a04)  + I in
	0x000ca345, // n0x19a4 c0x0000 (---------------)  +   is-by
	0x0022b803, // n0x19a5 c0x0000 (---------------)  + I isa
	0x002a67c4, // n0x19a6 c0x0000 (---------------)  + I kids
	0x51e0b982, // n0x19a7 c0x0147 (n0x1a04-n0x1a07)  + I ks
	0x52213442, // n0x19a8 c0x0148 (n0x1a07-n0x1a0a)  + I ky
	0x52604d02, // n0x19a9 c0x0149 (n0x1a0a-n0x1a0d)  + I la
	0x0015280b, // n0x19aa c0x0000 (---------------)  +   land-4-sale
	0x52a002c2, // n0x19ab c0x014a (n0x1a0d-n0x1a10)  + I ma
	0x53235302, // n0x19ac c0x014c (n0x1a13-n0x1a16)  + I md
	0x53602a02, // n0x19ad c0x014d (n0x1a16-n0x1a19)  + I me
	0x53a07e02, // n0x19ae c0x014e (n0x1a19-n0x1a1c)  + I mi
	0x53e298c2, // n0x19af c0x014f (n0x1a1c-n0x1a1f)  + I mn
	0x54206c42, // n0x19b0 c0x0150 (n0x1a1f-n0x1a22)  + I mo
	0x54625542, // n0x19b1 c0x0151 (n0x1a22-n0x1a25)  + I ms
	0x54a68d82, // n0x19b2 c0x0152 (n0x1a25-n0x1a28)  + I mt
	0x54e0c1c2, // n0x19b3 c0x0153 (n0x1a28-n0x1a2b)  + I nc
	0x55200702, // n0x19b4 c0x0154 (n0x1a2b-n0x1a2d)  + I nd
	0x55601602, // n0x19b5 c0x0155 (n0x1a2d-n0x1a30)  + I ne
	0x55a0f002, // n0x19b6 c0x0156 (n0x1a30-n0x1a33)  + I nh
	0x55e026c2, // n0x19b7 c0x0157 (n0x1a33-n0x1a36)  + I nj
	0x5620eb82, // n0x19b8 c0x0158 (n0x1a36-n0x1a39)  + I nm
	0x00261843, // n0x19b9 c0x0000 (---------------)  + I nsn
	0x5660ea42, // n0x19ba c0x0159 (n0x1a39-n0x1a3c)  + I nv
	0x56a15182, // n0x19bb c0x015a (n0x1a3c-n0x1a3f)  + I ny
	0x56e01bc2, // n0x19bc c0x015b (n0x1a3f-n0x1a42)  + I oh
	0x57203742, // n0x19bd c0x015c (n0x1a42-n0x1a45)  + I ok
	0x57600bc2, // n0x19be c0x015d (n0x1a45-n0x1a48)  + I or
	0x57a001c2, // n0x19bf c0x015e (n0x1a48-n0x1a4b)  + I pa
	0x57e487c2, // n0x19c0 c0x015f (n0x1a4b-n0x1a4e)  + I pr
	0x58209fc2, // n0x19c1 c0x0160 (n0x1a4e-n0x1a51)  + I ri
	0x58618bc2, // n0x19c2 c0x0161 (n0x1a51-n0x1a54)  + I sc
	0x58a02002, // n0x19c3 c0x0162 (n0x1a54-n0x1a56)  + I sd
	0x000ea04c, // n0x19c4 c0x0000 (---------------)  +   stuff-4-sale
	0x58e03f82, // n0x19c5 c0x0163 (n0x1a56-n0x1a59)  + I tn
	0x5925dc02, // n0x19c6 c0x0164 (n0x1a59-n0x1a5c)  + I tx
	0x59600dc2, // n0x19c7 c0x0165 (n0x1a5c-n0x1a5f)  + I ut
	0x59a000c2, // n0x19c8 c0x0166 (n0x1a5f-n0x1a62)  + I va
	0x59e032c2, // n0x19c9 c0x0167 (n0x1a62-n0x1a65)  + I vi
	0x5a26d0c2, // n0x19ca c0x0168 (n0x1a65-n0x1a68)  + I vt
	0x5a600542, // n0x19cb c0x0169 (n0x1a68-n0x1a6b)  + I wa
	0x5aa118c2, // n0x19cc c0x016a (n0x1a6b-n0x1a6e)  + I wi
	0x5ae71d02, // n0x19cd c0x016b (n0x1a6e-n0x1a6f)  + I wv
	0x5b20b882, // n0x19ce c0x016c (n0x1a6f-n0x1a72)  + I wy
	0x00219f02, // n0x19cf c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19d0 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19d1 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19d2 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19d3 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19d4 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19d5 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19d6 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19d7 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19d8 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19d9 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19da c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19db c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19dc c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19dd c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19de c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19df c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19e0 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19e1 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19e2 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19e3 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19e4 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19e5 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19e6 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19e7 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19e8 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19e9 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19ea c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19eb c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19ec c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19ed c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19ee c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19ef c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19f0 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19f1 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19f2 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19f3 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19f4 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19f5 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19f6 c0x0000 (---------------)  + I cc
	0x002858c3, // n0x19f7 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19f8 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19f9 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19fa c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19fb c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19fc c0x0000 (---------------)  + I k12
	0x002858c3, // n0x19fd c0x0000 (---------------)  + I lib
	0x00219f02, // n0x19fe c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x19ff c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a00 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a01 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a02 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a03 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a04 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a05 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a06 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a07 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a08 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a09 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a0a c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a0b c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a0c c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a0d c0x0000 (---------------)  + I cc
	0x52e1bdc3, // n0x1a0e c0x014b (n0x1a10-n0x1a13)  + I k12
	0x002858c3, // n0x1a0f c0x0000 (---------------)  + I lib
	0x00321e04, // n0x1a10 c0x0000 (---------------)  + I chtr
	0x0022d106, // n0x1a11 c0x0000 (---------------)  + I paroch
	0x002dbbc3, // n0x1a12 c0x0000 (---------------)  + I pvt
	0x00219f02, // n0x1a13 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a14 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a15 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a16 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a17 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a18 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a19 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a1a c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a1b c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a1c c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a1d c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a1e c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a1f c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a20 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a21 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a22 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a23 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a24 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a25 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a26 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a27 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a28 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a29 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a2a c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a2b c0x0000 (---------------)  + I cc
	0x002858c3, // n0x1a2c c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a2d c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a2e c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a2f c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a30 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a31 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a32 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a33 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a34 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a35 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a36 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a37 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a38 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a39 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a3a c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a3b c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a3c c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a3d c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a3e c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a3f c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a40 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a41 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a42 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a43 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a44 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a45 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a46 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a47 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a48 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a49 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a4a c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a4b c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a4c c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a4d c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a4e c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a4f c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a50 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a51 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a52 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a53 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a54 c0x0000 (---------------)  + I cc
	0x002858c3, // n0x1a55 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a56 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a57 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a58 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a59 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a5a c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a5b c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a5c c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a5d c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a5e c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a5f c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a60 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a61 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a62 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a63 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a64 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a65 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a66 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a67 c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a68 c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a69 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a6a c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a6b c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a6c c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a6d c0x0000 (---------------)  + I lib
	0x00219f02, // n0x1a6e c0x0000 (---------------)  + I cc
	0x00219f02, // n0x1a6f c0x0000 (---------------)  + I cc
	0x0021bdc3, // n0x1a70 c0x0000 (---------------)  + I k12
	0x002858c3, // n0x1a71 c0x0000 (---------------)  + I lib
	0x00222603, // n0x1a72 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1a73 c0x0000 (---------------)  + I edu
	0x00311e83, // n0x1a74 c0x0000 (---------------)  + I gub
	0x0023f703, // n0x1a75 c0x0000 (---------------)  + I mil
	0x00201603, // n0x1a76 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1a77 c0x0000 (---------------)  + I org
	0x00207a02, // n0x1a78 c0x0000 (---------------)  + I co
	0x00222603, // n0x1a79 c0x0000 (---------------)  + I com
	0x00201603, // n0x1a7a c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1a7b c0x0000 (---------------)  + I org
	0x00222603, // n0x1a7c c0x0000 (---------------)  + I com
	0x0027a643, // n0x1a7d c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1a7e c0x0000 (---------------)  + I gov
	0x0023f703, // n0x1a7f c0x0000 (---------------)  + I mil
	0x00201603, // n0x1a80 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1a81 c0x0000 (---------------)  + I org
	0x002180c4, // n0x1a82 c0x0000 (---------------)  + I arts
	0x00207a02, // n0x1a83 c0x0000 (---------------)  + I co
	0x00222603, // n0x1a84 c0x0000 (---------------)  + I com
	0x00302ec3, // n0x1a85 c0x0000 (---------------)  + I e12
	0x0027a643, // n0x1a86 c0x0000 (---------------)  + I edu
	0x00245bc4, // n0x1a87 c0x0000 (---------------)  + I firm
	0x0020dbc3, // n0x1a88 c0x0000 (---------------)  + I gob
	0x002157c3, // n0x1a89 c0x0000 (---------------)  + I gov
	0x0021c704, // n0x1a8a c0x0000 (---------------)  + I info
	0x00223a83, // n0x1a8b c0x0000 (---------------)  + I int
	0x0023f703, // n0x1a8c c0x0000 (---------------)  + I mil
	0x00201603, // n0x1a8d c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1a8e c0x0000 (---------------)  + I org
	0x00227783, // n0x1a8f c0x0000 (---------------)  + I rec
	0x002e9885, // n0x1a90 c0x0000 (---------------)  + I store
	0x00246943, // n0x1a91 c0x0000 (---------------)  + I tec
	0x00205e43, // n0x1a92 c0x0000 (---------------)  + I web
	0x00207a02, // n0x1a93 c0x0000 (---------------)  + I co
	0x00222603, // n0x1a94 c0x0000 (---------------)  + I com
	0x0021bdc3, // n0x1a95 c0x0000 (---------------)  + I k12
	0x00201603, // n0x1a96 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1a97 c0x0000 (---------------)  + I org
	0x00201d82, // n0x1a98 c0x0000 (---------------)  + I ac
	0x00314c43, // n0x1a99 c0x0000 (---------------)  + I biz
	0x00222603, // n0x1a9a c0x0000 (---------------)  + I com
	0x0027a643, // n0x1a9b c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1a9c c0x0000 (---------------)  + I gov
	0x00360806, // n0x1a9d c0x0000 (---------------)  + I health
	0x0021c704, // n0x1a9e c0x0000 (---------------)  + I info
	0x00223a83, // n0x1a9f c0x0000 (---------------)  + I int
	0x0022aec4, // n0x1aa0 c0x0000 (---------------)  + I name
	0x00201603, // n0x1aa1 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1aa2 c0x0000 (---------------)  + I org
	0x002d8443, // n0x1aa3 c0x0000 (---------------)  + I pro
	0x00222603, // n0x1aa4 c0x0000 (---------------)  + I com
	0x0027a643, // n0x1aa5 c0x0000 (---------------)  + I edu
	0x00201603, // n0x1aa6 c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1aa7 c0x0000 (---------------)  + I org
	0x00222603, // n0x1aa8 c0x0000 (---------------)  + I com
	0x00010c06, // n0x1aa9 c0x0000 (---------------)  +   dyndns
	0x0027a643, // n0x1aaa c0x0000 (---------------)  + I edu
	0x002157c3, // n0x1aab c0x0000 (---------------)  + I gov
	0x000f5946, // n0x1aac c0x0000 (---------------)  +   mypets
	0x00201603, // n0x1aad c0x0000 (---------------)  + I net
	0x0021f5c3, // n0x1aae c0x0000 (---------------)  + I org
	0x002fd448, // n0x1aaf c0x0000 (---------------)  + I xn--80au
	0x002ff349, // n0x1ab0 c0x0000 (---------------)  + I xn--90azh
	0x0030bdc9, // n0x1ab1 c0x0000 (---------------)  + I xn--c1avg
	0x0031a688, // n0x1ab2 c0x0000 (---------------)  + I xn--d1at
	0x0034b708, // n0x1ab3 c0x0000 (---------------)  + I xn--o1ac
	0x0034b709, // n0x1ab4 c0x0000 (---------------)  + I xn--o1ach
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x00ce4333, // c0x0006 (n0x0333-n0x0339)  +
	0x00ce8339, // c0x0007 (n0x0339-n0x033a)  +
	0x00d0433a, // c0x0008 (n0x033a-n0x0341)  +
	0x00e68341, // c0x0009 (n0x0341-n0x039a)  +
	0x00e7c39a, // c0x000a (n0x039a-n0x039f)  +
	0x00e9039f, // c0x000b (n0x039f-n0x03a4)  +
	0x00ea03a4, // c0x000c (n0x03a4-n0x03a8)  +
	0x00eb83a8, // c0x000d (n0x03a8-n0x03ae)  +
	0x00ec83ae, // c0x000e (n0x03ae-n0x03b2)  +
	0x00ee03b2, // c0x000f (n0x03b2-n0x03b8)  +
	0x00f043b8, // c0x0010 (n0x03b8-n0x03c1)  +
	0x00f083c1, // c0x0011 (n0x03c1-n0x03c2)  +
	0x00f203c2, // c0x0012 (n0x03c2-n0x03c8)  +
	0x00f243c8, // c0x0013 (n0x03c8-n0x03c9)  +
	0x00f403c9, // c0x0014 (n0x03c9-n0x03d0)  +
	0x00f443d0, // c0x0015 (n0x03d0-n0x03d1)  +
	0x00f8c3d1, // c0x0016 (n0x03d1-n0x03e3)  +
	0x00f903e3, // c0x0017 (n0x03e3-n0x03e4)  +
	0x00fb03e4, // c0x0018 (n0x03e4-n0x03ec)  +
	0x00fc43ec, // c0x0019 (n0x03ec-n0x03f1)  +
	0x00fc83f1, // c0x001a (n0x03f1-n0x03f2)  +
	0x00ff83f2, // c0x001b (n0x03f2-n0x03fe)  +
	0x010203fe, // c0x001c (n0x03fe-n0x0408)  +
	0x01048408, // c0x001d (n0x0408-n0x0412)  +
	0x01050412, // c0x001e (n0x0412-n0x0414)  +
	0x01054414, // c0x001f (n0x0414-n0x0415)  +
	0x010e4415, // c0x0020 (n0x0415-n0x0439)  +
	0x010f8439, // c0x0021 (n0x0439-n0x043e)  +
	0x0110c43e, // c0x0022 (n0x043e-n0x0443)  +
	0x01128443, // c0x0023 (n0x0443-n0x044a)  +
	0x0113844a, // c0x0024 (n0x044a-n0x044e)  +
	0x0114c44e, // c0x0025 (n0x044e-n0x0453)  +
	0x01170453, // c0x0026 (n0x0453-n0x045c)  +
	0x0128845c, // c0x0027 (n0x045c-n0x04a2)  +
	0x0128c4a2, // c0x0028 (n0x04a2-n0x04a3)  +
	0x012a04a3, // c0x0029 (n0x04a3-n0x04a8)  +
	0x012b44a8, // c0x002a (n0x04a8-n0x04ad)  +
	0x012bc4ad, // c0x002b (n0x04ad-n0x04af)  +
	0x012cc4af, // c0x002c (n0x04af-n0x04b3)  +
	0x012e44b3, // c0x002d (n0x04b3-n0x04b9)  +
	0x013284b9, // c0x002e (n0x04b9-n0x04ca)  +
	0x013384ca, // c0x002f (n0x04ca-n0x04ce)  +
	0x0133c4ce, // c0x0030 (n0x04ce-n0x04cf)  +
	0x013404cf, // c0x0031 (n0x04cf-n0x04d0)  +
	0x013444d0, // c0x0032 (n0x04d0-n0x04d1)  +
	0x013804d1, // c0x0033 (n0x04d1-n0x04e0)  +
	0x613844e0, // c0x0034 (n0x04e0-n0x04e1)* o
	0x013944e1, // c0x0035 (n0x04e1-n0x04e5)  +
	0x013a44e5, // c0x0036 (n0x04e5-n0x04e9)  +
	0x014584e9, // c0x0037 (n0x04e9-n0x0516)  +
	0x2145c516, // c0x0038 (n0x0516-n0x0517)  o
	0x01460517, // c0x0039 (n0x0517-n0x0518)  +
	0x01494518, // c0x003a (n0x0518-n0x0525)  +
	0x017a0525, // c0x003b (n0x0525-n0x05e8)  +
	0x217fc5e8, // c0x003c (n0x05e8-n0x05ff)  o
	0x0181c5ff, // c0x003d (n0x05ff-n0x0607)  +
	0x01824607, // c0x003e (n0x0607-n0x0609)  +
	0x01840609, // c0x003f (n0x0609-n0x0610)  +
	0x01858610, // c0x0040 (n0x0610-n0x0616)  +
	0x0185c616, // c0x0041 (n0x0616-n0x0617)  +
	0x0186c617, // c0x0042 (n0x0617-n0x061b)  +
	0x0187461b, // c0x0043 (n0x061b-n0x061d)  +
	0x0187861d, // c0x0044 (n0x061d-n0x061e)  +
	0x0189861e, // c0x0045 (n0x061e-n0x0626)  +
	0x0189c626, // c0x0046 (n0x0626-n0x0627)  +
	0x018b0627, // c0x0047 (n0x0627-n0x062c)  +
	0x018d862c, // c0x0048 (n0x062c-n0x0636)  +
	0x018f8636, // c0x0049 (n0x0636-n0x063e)  +
	0x0192863e, // c0x004a (n0x063e-n0x064a)  +
	0x0195064a, // c0x004b (n0x064a-n0x0654)  +
	0x01974654, // c0x004c (n0x0654-n0x065d)  +
	0x0198865d, // c0x004d (n0x065d-n0x0662)  +
	0x0198c662, // c0x004e (n0x0662-n0x0663)  +
	0x019a8663, // c0x004f (n0x0663-n0x066a)  +
	0x019b466a, // c0x0050 (n0x066a-n0x066d)  +
	0x01a1466d, // c0x0051 (n0x066d-n0x0685)  +
	0x01a30685, // c0x0052 (n0x0685-n0x068c)  +
	0x01a3c68c, // c0x0053 (n0x068c-n0x068f)  +
	0x01a5068f, // c0x0054 (n0x068f-n0x0694)  +
	0x01a68694, // c0x0055 (n0x0694-n0x069a)  +
	0x01a8069a, // c0x0056 (n0x069a-n0x06a0)  +
	0x01a986a0, // c0x0057 (n0x06a0-n0x06a6)  +
	0x01ab06a6, // c0x0058 (n0x06a6-n0x06ac)  +
	0x01acc6ac, // c0x0059 (n0x06ac-n0x06b3)  +
	0x01ad86b3, // c0x005a (n0x06b3-n0x06b6)  +
	0x01b306b6, // c0x005b (n0x06b6-n0x06cc)  +
	0x01b486cc, // c0x005c (n0x06cc-n0x06d2)  +
	0x01b586d2, // c0x005d (n0x06d2-n0x06d6)  +
	0x01b9c6d6, // c0x005e (n0x06d6-n0x06e7)  +
	0x01c1c6e7, // c0x005f (n0x06e7-n0x0707)  +
	0x01c48707, // c0x0060 (n0x0707-n0x0712)  +
	0x01c50712, // c0x0061 (n0x0712-n0x0714)  +
	0x61c54714, // c0x0062 (n0x0714-n0x0715)* o
	0x21c58715, // c0x0063 (n0x0715-n0x0716)  o
	0x01c74716, // c0x0064 (n0x0716-n0x071d)  +
	0x01c7c71d, // c0x0065 (n0x071d-n0x071f)  +
	0x01cb071f, // c0x0066 (n0x071f-n0x072c)  +
	0x01cd872c, // c0x0067 (n0x072c-n0x0736)  +
	0x01cdc736, // c0x0068 (n0x0736-n0x0737)  +
	0x01ce8737, // c0x0069 (n0x0737-n0x073a)  +
	0x01d0073a, // c0x006a (n0x073a-n0x0740)  +
	0x01d24740, // c0x006b (n0x0740-n0x0749)  +
	0x01d40749, // c0x006c (n0x0749-n0x0750)  +
	0x02304750, // c0x006d (n0x0750-n0x08c1)  +
	0x023108c1, // c0x006e (n0x08c1-n0x08c4)  +
	0x023308c4, // c0x006f (n0x08c4-n0x08cc)  +
	0x024308cc, // c0x0070 (n0x08cc-n0x090c)  +
	0x0250090c, // c0x0071 (n0x090c-n0x0940)  +
	0x02570940, // c0x0072 (n0x0940-n0x095c)  +
	0x025c895c, // c0x0073 (n0x095c-n0x0972)  +
	0x026b0972, // c0x0074 (n0x0972-n0x09ac)  +
	0x027089ac, // c0x0075 (n0x09ac-n0x09c2)  +
	0x027449c2, // c0x0076 (n0x09c2-n0x09d1)  +
	0x028409d1, // c0x0077 (n0x09d1-n0x0a10)  +
	0x0290ca10, // c0x0078 (n0x0a10-n0x0a43)  +
	0x029a4a43, // c0x0079 (n0x0a43-n0x0a69)  +
	0x02a34a69, // c0x007a (n0x0a69-n0x0a8d)  +
	0x02a98a8d, // c0x007b (n0x0a8d-n0x0aa6)  +
	0x02cd0aa6, // c0x007c (n0x0aa6-n0x0b34)  +
	0x02d88b34, // c0x007d (n0x0b34-n0x0b62)  +
	0x02e54b62, // c0x007e (n0x0b62-n0x0b95)  +
	0x02ea0b95, // c0x007f (n0x0b95-n0x0ba8)  +
	0x02f28ba8, // c0x0080 (n0x0ba8-n0x0bca)  +
	0x02f64bca, // c0x0081 (n0x0bca-n0x0bd9)  +
	0x02fb4bd9, // c0x0082 (n0x0bd9-n0x0bed)  +
	0x0302cbed, // c0x0083 (n0x0bed-n0x0c0b)  +
	0x63030c0b, // c0x0084 (n0x0c0b-n0x0c0c)* o
	0x63034c0c, // c0x0085 (n0x0c0c-n0x0c0d)* o
	0x63038c0d, // c0x0086 (n0x0c0d-n0x0c0e)* o
	0x030b4c0e, // c0x0087 (n0x0c0e-n0x0c2d)  +
	0x0311cc2d, // c0x0088 (n0x0c2d-n0x0c47)  +
	0x03198c47, // c0x0089 (n0x0c47-n0x0c66)  +
	0x03210c66, // c0x008a (n0x0c66-n0x0c84)  +
	0x03294c84, // c0x008b (n0x0c84-n0x0ca5)  +
	0x03300ca5, // c0x008c (n0x0ca5-n0x0cc0)  +
	0x0342ccc0, // c0x008d (n0x0cc0-n0x0d0b)  +
	0x03484d0b, // c0x008e (n0x0d0b-n0x0d21)  +
	0x63488d21, // c0x008f (n0x0d21-n0x0d22)* o
	0x03520d22, // c0x0090 (n0x0d22-n0x0d48)  +
	0x035a8d48, // c0x0091 (n0x0d48-n0x0d6a)  +
	0x035f4d6a, // c0x0092 (n0x0d6a-n0x0d7d)  +
	0x0365cd7d, // c0x0093 (n0x0d7d-n0x0d97)  +
	0x03704d97, // c0x0094 (n0x0d97-n0x0dc1)  +
	0x037ccdc1, // c0x0095 (n0x0dc1-n0x0df3)  +
	0x03834df3, // c0x0096 (n0x0df3-n0x0e0d)  +
	0x03948e0d, // c0x0097 (n0x0e0d-n0x0e52)  +
	0x6394ce52, // c0x0098 (n0x0e52-n0x0e53)* o
	0x63950e53, // c0x0099 (n0x0e53-n0x0e54)* o
	0x039ace54, // c0x009a (n0x0e54-n0x0e6b)  +
	0x03a08e6b, // c0x009b (n0x0e6b-n0x0e82)  +
	0x03a98e82, // c0x009c (n0x0e82-n0x0ea6)  +
	0x03b14ea6, // c0x009d (n0x0ea6-n0x0ec5)  +
	0x03b58ec5, // c0x009e (n0x0ec5-n0x0ed6)  +
	0x03c3ced6, // c0x009f (n0x0ed6-n0x0f0f)  +
	0x03c70f0f, // c0x00a0 (n0x0f0f-n0x0f1c)  +
	0x03cd0f1c, // c0x00a1 (n0x0f1c-n0x0f34)  +
	0x03d44f34, // c0x00a2 (n0x0f34-n0x0f51)  +
	0x03dccf51, // c0x00a3 (n0x0f51-n0x0f73)  +
	0x03e0cf73, // c0x00a4 (n0x0f73-n0x0f83)  +
	0x03e7cf83, // c0x00a5 (n0x0f83-n0x0f9f)  +
	0x63e80f9f, // c0x00a6 (n0x0f9f-n0x0fa0)* o
	0x03e98fa0, // c0x00a7 (n0x0fa0-n0x0fa6)  +
	0x03eb4fa6, // c0x00a8 (n0x0fa6-n0x0fad)  +
	0x03ef8fad, // c0x00a9 (n0x0fad-n0x0fbe)  +
	0x03f08fbe, // c0x00aa (n0x0fbe-n0x0fc2)  +
	0x03f20fc2, // c0x00ab (n0x0fc2-n0x0fc8)  +
	0x03f98fc8, // c0x00ac (n0x0fc8-n0x0fe6)  +
	0x03facfe6, // c0x00ad (n0x0fe6-n0x0feb)  +
	0x03fc4feb, // c0x00ae (n0x0feb-n0x0ff1)  +
	0x03fe8ff1, // c0x00af (n0x0ff1-n0x0ffa)  +
	0x03ffcffa, // c0x00b0 (n0x0ffa-n0x0fff)  +
	0x04014fff, // c0x00b1 (n0x0fff-n0x1005)  +
	0x0404d005, // c0x00b2 (n0x1005-n0x1013)  +
	0x04061013, // c0x00b3 (n0x1013-n0x1018)  +
	0x04069018, // c0x00b4 (n0x1018-n0x101a)  +
	0x0406d01a, // c0x00b5 (n0x101a-n0x101b)  +
	0x0409101b, // c0x00b6 (n0x101b-n0x1024)  +
	0x040b5024, // c0x00b7 (n0x1024-n0x102d)  +
	0x040cd02d, // c0x00b8 (n0x102d-n0x1033)  +
	0x040d5033, // c0x00b9 (n0x1033-n0x1035)  +
	0x040f5035, // c0x00ba (n0x1035-n0x103d)  +
	0x0411503d, // c0x00bb (n0x103d-n0x1045)  +
	0x04131045, // c0x00bc (n0x1045-n0x104c)  +
	0x0414d04c, // c0x00bd (n0x104c-n0x1053)  +
	0x0415d053, // c0x00be (n0x1053-n0x1057)  +
	0x04171057, // c0x00bf (n0x1057-n0x105c)  +
	0x0417905c, // c0x00c0 (n0x105c-n0x105e)  +
	0x0418d05e, // c0x00c1 (n0x105e-n0x1063)  +
	0x0419d063, // c0x00c2 (n0x1063-n0x1067)  +
	0x041b9067, // c0x00c3 (n0x1067-n0x106e)  +
	0x04a4906e, // c0x00c4 (n0x106e-n0x1292)  +
	0x04a81292, // c0x00c5 (n0x1292-n0x12a0)  +
	0x04aad2a0, // c0x00c6 (n0x12a0-n0x12ab)  +
	0x04ac52ab, // c0x00c7 (n0x12ab-n0x12b1)  +
	0x04ae12b1, // c0x00c8 (n0x12b1-n0x12b8)  +
	0x64ae52b8, // c0x00c9 (n0x12b8-n0x12b9)* o
	0x04b292b9, // c0x00ca (n0x12b9-n0x12ca)  +
	0x04b312ca, // c0x00cb (n0x12ca-n0x12cc)  +
	0x24b352cc, // c0x00cc (n0x12cc-n0x12cd)  o
	0x24b392cd, // c0x00cd (n0x12cd-n0x12ce)  o
	0x04b3d2ce, // c0x00ce (n0x12ce-n0x12cf)  +
	0x04bf92cf, // c0x00cf (n0x12cf-n0x12fe)  +
	0x24c012fe, // c0x00d0 (n0x12fe-n0x1300)  o
	0x24c09300, // c0x00d1 (n0x1300-n0x1302)  o
	0x24c15302, // c0x00d2 (n0x1302-n0x1305)  o
	0x04c3d305, // c0x00d3 (n0x1305-n0x130f)  +
	0x04c6130f, // c0x00d4 (n0x130f-n0x1318)  +
	0x04c6d318, // c0x00d5 (n0x1318-n0x131b)  +
	0x057c531b, // c0x00d6 (n0x131b-n0x15f1)  +
	0x057c95f1, // c0x00d7 (n0x15f1-n0x15f2)  +
	0x057cd5f2, // c0x00d8 (n0x15f2-n0x15f3)  +
	0x257d15f3, // c0x00d9 (n0x15f3-n0x15f4)  o
	0x057d55f4, // c0x00da (n0x15f4-n0x15f5)  +
	0x257d95f5, // c0x00db (n0x15f5-n0x15f6)  o
	0x057dd5f6, // c0x00dc (n0x15f6-n0x15f7)  +
	0x257e95f7, // c0x00dd (n0x15f7-n0x15fa)  o
	0x057ed5fa, // c0x00de (n0x15fa-n0x15fb)  +
	0x057f15fb, // c0x00df (n0x15fb-n0x15fc)  +
	0x257f55fc, // c0x00e0 (n0x15fc-n0x15fd)  o
	0x057f95fd, // c0x00e1 (n0x15fd-n0x15fe)  +
	0x258015fe, // c0x00e2 (n0x15fe-n0x1600)  o
	0x05805600, // c0x00e3 (n0x1600-n0x1601)  +
	0x05809601, // c0x00e4 (n0x1601-n0x1602)  +
	0x25819602, // c0x00e5 (n0x1602-n0x1606)  o
	0x0581d606, // c0x00e6 (n0x1606-n0x1607)  +
	0x05821607, // c0x00e7 (n0x1607-n0x1608)  +
	0x05825608, // c0x00e8 (n0x1608-n0x1609)  +
	0x05829609, // c0x00e9 (n0x1609-n0x160a)  +
	0x2582d60a, // c0x00ea (n0x160a-n0x160b)  o
	0x0583160b, // c0x00eb (n0x160b-n0x160c)  +
	0x0583560c, // c0x00ec (n0x160c-n0x160d)  +
	0x0583960d, // c0x00ed (n0x160d-n0x160e)  +
	0x0583d60e, // c0x00ee (n0x160e-n0x160f)  +
	0x2584560f, // c0x00ef (n0x160f-n0x1611)  o
	0x05849611, // c0x00f0 (n0x1611-n0x1612)  +
	0x0584d612, // c0x00f1 (n0x1612-n0x1613)  +
	0x05851613, // c0x00f2 (n0x1613-n0x1614)  +
	0x25855614, // c0x00f3 (n0x1614-n0x1615)  o
	0x05859615, // c0x00f4 (n0x1615-n0x1616)  +
	0x25861616, // c0x00f5 (n0x1616-n0x1618)  o
	0x25865618, // c0x00f6 (n0x1618-n0x1619)  o
	0x05881619, // c0x00f7 (n0x1619-n0x1620)  +
	0x0588d620, // c0x00f8 (n0x1620-n0x1623)  +
	0x058cd623, // c0x00f9 (n0x1623-n0x1633)  +
	0x058d1633, // c0x00fa (n0x1633-n0x1634)  +
	0x058f5634, // c0x00fb (n0x1634-n0x163d)  +
	0x059c963d, // c0x00fc (n0x163d-n0x1672)  +
	0x059d1672, // c0x00fd (n0x1672-n0x1674)  +
	0x059fd674, // c0x00fe (n0x1674-n0x167f)  +
	0x05a1967f, // c0x00ff (n0x167f-n0x1686)  +
	0x05a25686, // c0x0100 (n0x1686-n0x1689)  +
	0x05a45689, // c0x0101 (n0x1689-n0x1691)  +
	0x05a7d691, // c0x0102 (n0x1691-n0x169f)  +
	0x05d2969f, // c0x0103 (n0x169f-n0x174a)  +
	0x05d4d74a, // c0x0104 (n0x174a-n0x1753)  +
	0x05d61753, // c0x0105 (n0x1753-n0x1758)  +
	0x05d95758, // c0x0106 (n0x1758-n0x1765)  +
	0x05db1765, // c0x0107 (n0x1765-n0x176c)  +
	0x05dcd76c, // c0x0108 (n0x176c-n0x1773)  +
	0x05df1773, // c0x0109 (n0x1773-n0x177c)  +
	0x05e0977c, // c0x010a (n0x177c-n0x1782)  +
	0x05e25782, // c0x010b (n0x1782-n0x1789)  +
	0x05e45789, // c0x010c (n0x1789-n0x1791)  +
	0x05e55791, // c0x010d (n0x1791-n0x1795)  +
	0x05e85795, // c0x010e (n0x1795-n0x17a1)  +
	0x05e9d7a1, // c0x010f (n0x17a1-n0x17a7)  +
	0x060ad7a7, // c0x0110 (n0x17a7-n0x182b)  +
	0x060d182b, // c0x0111 (n0x182b-n0x1834)  +
	0x060f1834, // c0x0112 (n0x1834-n0x183c)  +
	0x0610583c, // c0x0113 (n0x183c-n0x1841)  +
	0x06119841, // c0x0114 (n0x1841-n0x1846)  +
	0x06139846, // c0x0115 (n0x1846-n0x184e)  +
	0x061dd84e, // c0x0116 (n0x184e-n0x1877)  +
	0x061f9877, // c0x0117 (n0x1877-n0x187e)  +
	0x0620d87e, // c0x0118 (n0x187e-n0x1883)  +
	0x06211883, // c0x0119 (n0x1883-n0x1884)  +
	0x06225884, // c0x011a (n0x1884-n0x1889)  +
	0x06241889, // c0x011b (n0x1889-n0x1890)  +
	0x0624d890, // c0x011c (n0x1890-n0x1893)  +
	0x0627d893, // c0x011d (n0x1893-n0x189f)  +
	0x0629189f, // c0x011e (n0x189f-n0x18a4)  +
	0x062958a4, // c0x011f (n0x18a4-n0x18a5)  +
	0x062ad8a5, // c0x0120 (n0x18a5-n0x18ab)  +
	0x062b98ab, // c0x0121 (n0x18ab-n0x18ae)  +
	0x062bd8ae, // c0x0122 (n0x18ae-n0x18af)  +
	0x062d98af, // c0x0123 (n0x18af-n0x18b6)  +
	0x063158b6, // c0x0124 (n0x18b6-n0x18c5)  +
	0x063198c5, // c0x0125 (n0x18c5-n0x18c6)  +
	0x063398c6, // c0x0126 (n0x18c6-n0x18ce)  +
	0x063898ce, // c0x0127 (n0x18ce-n0x18e2)  +
	0x063a18e2, // c0x0128 (n0x18e2-n0x18e8)  +
	0x063f58e8, // c0x0129 (n0x18e8-n0x18fd)  +
	0x063f98fd, // c0x012a (n0x18fd-n0x18fe)  +
	0x0643d8fe, // c0x012b (n0x18fe-n0x190f)  +
	0x0644d90f, // c0x012c (n0x190f-n0x1913)  +
	0x06485913, // c0x012d (n0x1913-n0x1921)  +
	0x064b5921, // c0x012e (n0x1921-n0x192d)  +
	0x065ed92d, // c0x012f (n0x192d-n0x197b)  +
	0x0660d97b, // c0x0130 (n0x197b-n0x1983)  +
	0x06639983, // c0x0131 (n0x1983-n0x198e)  +
	0x0663d98e, // c0x0132 (n0x198e-n0x198f)  +
	0x0664198f, // c0x0133 (n0x198f-n0x1990)  +
	0x0673d990, // c0x0134 (n0x1990-n0x19cf)  +
	0x067499cf, // c0x0135 (n0x19cf-n0x19d2)  +
	0x067559d2, // c0x0136 (n0x19d2-n0x19d5)  +
	0x067619d5, // c0x0137 (n0x19d5-n0x19d8)  +
	0x0676d9d8, // c0x0138 (n0x19d8-n0x19db)  +
	0x067799db, // c0x0139 (n0x19db-n0x19de)  +
	0x067859de, // c0x013a (n0x19de-n0x19e1)  +
	0x067919e1, // c0x013b (n0x19e1-n0x19e4)  +
	0x0679d9e4, // c0x013c (n0x19e4-n0x19e7)  +
	0x067a99e7, // c0x013d (n0x19e7-n0x19ea)  +
	0x067b59ea, // c0x013e (n0x19ea-n0x19ed)  +
	0x067c19ed, // c0x013f (n0x19ed-n0x19f0)  +
	0x067cd9f0, // c0x0140 (n0x19f0-n0x19f3)  +
	0x067d99f3, // c0x0141 (n0x19f3-n0x19f6)  +
	0x067e19f6, // c0x0142 (n0x19f6-n0x19f8)  +
	0x067ed9f8, // c0x0143 (n0x19f8-n0x19fb)  +
	0x067f99fb, // c0x0144 (n0x19fb-n0x19fe)  +
	0x068059fe, // c0x0145 (n0x19fe-n0x1a01)  +
	0x06811a01, // c0x0146 (n0x1a01-n0x1a04)  +
	0x0681da04, // c0x0147 (n0x1a04-n0x1a07)  +
	0x06829a07, // c0x0148 (n0x1a07-n0x1a0a)  +
	0x06835a0a, // c0x0149 (n0x1a0a-n0x1a0d)  +
	0x06841a0d, // c0x014a (n0x1a0d-n0x1a10)  +
	0x0684da10, // c0x014b (n0x1a10-n0x1a13)  +
	0x06859a13, // c0x014c (n0x1a13-n0x1a16)  +
	0x06865a16, // c0x014d (n0x1a16-n0x1a19)  +
	0x06871a19, // c0x014e (n0x1a19-n0x1a1c)  +
	0x0687da1c, // c0x014f (n0x1a1c-n0x1a1f)  +
	0x06889a1f, // c0x0150 (n0x1a1f-n0x1a22)  +
	0x06895a22, // c0x0151 (n0x1a22-n0x1a25)  +
	0x068a1a25, // c0x0152 (n0x1a25-n0x1a28)  +
	0x068ada28, // c0x0153 (n0x1a28-n0x1a2b)  +
	0x068b5a2b, // c0x0154 (n0x1a2b-n0x1a2d)  +
	0x068c1a2d, // c0x0155 (n0x1a2d-n0x1a30)  +
	0x068cda30, // c0x0156 (n0x1a30-n0x1a33)  +
	0x068d9a33, // c0x0157 (n0x1a33-n0x1a36)  +
	0x068e5a36, // c0x0158 (n0x1a36-n0x1a39)  +
	0x068f1a39, // c0x0159 (n0x1a39-n0x1a3c)  +
	0x068fda3c, // c0x015a (n0x1a3c-n0x1a3f)  +
	0x06909a3f, // c0x015b (n0x1a3f-n0x1a42)  +
	0x06915a42, // c0x015c (n0x1a42-n0x1a45)  +
	0x06921a45, // c0x015d (n0x1a45-n0x1a48)  +
	0x0692da48, // c0x015e (n0x1a48-n0x1a4b)  +
	0x06939a4b, // c0x015f (n0x1a4b-n0x1a4e)  +
	0x06945a4e, // c0x0160 (n0x1a4e-n0x1a51)  +
	0x06951a51, // c0x0161 (n0x1a51-n0x1a54)  +
	0x06959a54, // c0x0162 (n0x1a54-n0x1a56)  +
	0x06965a56, // c0x0163 (n0x1a56-n0x1a59)  +
	0x06971a59, // c0x0164 (n0x1a59-n0x1a5c)  +
	0x0697da5c, // c0x0165 (n0x1a5c-n0x1a5f)  +
	0x06989a5f, // c0x0166 (n0x1a5f-n0x1a62)  +
	0x06995a62, // c0x0167 (n0x1a62-n0x1a65)  +
	0x069a1a65, // c0x0168 (n0x1a65-n0x1a68)  +
	0x069ada68, // c0x0169 (n0x1a68-n0x1a6b)  +
	0x069b9a6b, // c0x016a (n0x1a6b-n0x1a6e)  +
	0x069bda6e, // c0x016b (n0x1a6e-n0x1a6f)  +
	0x069c9a6f, // c0x016c (n0x1a6f-n0x1a72)  +
	0x069e1a72, // c0x016d (n0x1a72-n0x1a78)  +
	0x069f1a78, // c0x016e (n0x1a78-n0x1a7c)  +
	0x06a09a7c, // c0x016f (n0x1a7c-n0x1a82)  +
	0x06a4da82, // c0x0170 (n0x1a82-n0x1a93)  +
	0x06a61a93, // c0x0171 (n0x1a93-n0x1a98)  +
	0x06a91a98, // c0x0172 (n0x1a98-n0x1aa4)  +
	0x06aa1aa4, // c0x0173 (n0x1aa4-n0x1aa8)  +
	0x06abdaa8, // c0x0174 (n0x1aa8-n0x1aaf)  +
	0x06ad5aaf, // c0x0175 (n0x1aaf-n0x1ab5)  +
}

// max children 373 (capacity 511)
// max text offset 23896 (capacity 32767)
// max text length 36 (capacity 63)
// max hi 6837 (capacity 16383)
// max lo 6831 (capacity 16383)
