# Code of Conduct

## Overview

The following Code of Conduct was forked from the [HashiCorp Community Guidelines](https://www.hashicorp.com/community-guidelines) and applies to this open source project. Community members of this project play a variety of roles, including mentor, teacher, or connector and this Code of Conduct applies to anyone participating in this project.

Be conscious of the words and phrases that you choose when communicating with others. Be kind. Do not insult or put down others. Sexist, racist, or other prejudicial or exclusionary comments are never welcome. If you think your conversation is making another community member uncomfortable, try to make amends and move forward. Avoid using colloquialisms or words and phrases that may have subjective connotations. Be aware that your first language may not be the first language of who you are communicating with.

As you are working with other members of the community, keep in mind the following guidelines, which apply equally to all participants, or anyone who is seeking help and guidance.

The following list is not exhaustive:

- Be welcoming, inclusive, friendly, and patient at all times.
- Be considerate.
- Be respectful.
- Be professional.

Always keep in mind that:

* Disagreements happen, but are not an excuse for poor behavior and bad manners. When disagreements do happen, work together to solve them effectively in a way that ensures everyone's success. If you find yourself feeling frustrated, take a step back from the keyboard or discussion.
* Not everyone will understand jokes, sarcasm, oblique references, colloquialisms, or euphemisms in the same way you do. Always empathize with the other parties and recognize they may come from a different background and interpret words differently than you.
* Sexist, racist, or other prejudicial or exclusionary comments are never welcome.

## Unacceptable Behavior

Harassment comes in many forms, including but not limited to: offensive verbal or written comments related to sex, gender, sexual orientation, disability, physical appearance, body size, race, religion, and sexual images, inappropriate physical contact or unwelcome sexual attention. Other unacceptable behavior includes: stalking, persistent following, intrusive or otherwise unwanted photography or recording, sustained disruption of talks or other events.

Harassment and other exclusionary or prejudicial behavior are not acceptable and will not be tolerated. This includes, but is not limited to:

- Violent threats or language directed against another person.
- Sexist, racist, or otherwise discriminatory jokes and language.
- Posting sexually explicit or violent material.
- Posting (or threatening to post) other people's personally identifying information ("doxing").
- Persistent misuse of pronouns.
- Personal insults, especially those using racist or sexist terms.
- Unwelcome sexual attention.
- Suggestive language.
- Harassment of others. If someone asks you to stop, then stop.
- Any physical violence or intimidation, threatened or acted on, is a serious offense.
- Advocating for, or encouraging, any of the above behavior.

## Incident Handling

Disagreements happen. When they occur, we seek to resolve disagreements and differing views constructively and with the help of the community and community processes. When disagreements escalate, we ask our community advocates and leaders to step in to moderate, mediate, and help resolve tense situations.

Please reports any incidents to a primary maintainer and try to include the following:

- Identifying information (name, email address, username, etc.) of the person doing the harassing.
- The behavior that was in violation.
- The approximate time of the behavior.
- The circumstances surrounding the incident.
- Other people involved in the incident.
- Screenshots / references if available.
- If you feel your safety is in jeopardy please do not hesitate to contact local law enforcement.

## Pronouns

While most people are well-intentioned in most interactions, making the wrong assumption about someone’s gender identity or expression, and, by extension their pronouns, can be insulting, harmful, and misgendering, if done repeatedly, can constitute harassment and escalation. It is best to utilize gender-neutral greetings when addressing groups of people.

Misgendering occurs when you refer to someone with a pronoun that does not align with their gender identity. It often occurs more frequently in initial verbal interactions than in written communication. Whether it happens intentionally or accidentally, misgendering can create intense moments of distress for those being misgendered.

If you’ve misgendered someone, here are a few critical steps to take:

* Acknowledge your mistake sincerely and calmly. Take accountability for your mistake and avoid defensive behavior.
* Apologize and correct yourself. You may say something along the lines of, “I’m sorry, Tori—I should’ve said she,” or “She mentioned—I’m sorry, they mentioned…”
* Do not draw additional attention to the situation by spending a lot of time on the mistake or making it the focal point of discussion. Furthermore, do not attempt to justify or defend your mistake. This can cause additional harm and discomfort. Instead, apologize and move on.
* If you have been corrected for misgendering someone, thank the individual who has corrected you. Doing so reinforces healthy habits of giving and receiving constructive feedback, taking accountability, and respecting fellow community members.
* Take time to self-reflect after the fact and determine how you can make a concerted effort to do better next time.

## Punitive Actions

Crafting a list of quid-pro-quo punitive actions would be inadequate and incomplete. We will do our best to enumerate the common punitive actions here, but each incident will be dealt with on a case-by-case basis. As patterns emerge, this section may be updated to include some suggested punitive actions.

Our first response is always to ensure the immediate safety and well being of all parties involved. In the ideal case, an attempt to stop and prevent the violation behavior would be made before any punitive action is decided.

When punitive action is warranted, this may include:

- 1st offense — warning and required behavior change.
- 2nd offense — permanent ban from the project.

In severe and highly offensive cases, the maintainers reserve the right to ban immediately without warning or consideration of behavior change.

## Appeals

A user subjected to punitive action may appeal the action by emailing a maintainer with the contents of their appeal. Harrassment of maintainers is not tolerated.

## Influences & Copyright

This Code of Conduct was forked from the [HashiCorp Community Guidelines](https://www.hashicorp.com/community-guidelines), itself forked from the example policy from the Geek Feminism wiki, created by the Ada Initiative and other volunteers, which is under a Creative Commons Zero (CC0) license.

This Code of Conduct is in the public domain. In jurisdictions that do not allow for this, this work is available under CC0. To the extent possible under law, the person who associated CC0 with this work has waived all copyright and related or neighboring rights to this work.

