// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make pluginapi"
// DO NOT EDIT

package plugin

import (
	"io"
	"net/http"
	timePkg "time"

	"github.com/mattermost/mattermost-server/v6/einterfaces"
	"github.com/mattermost/mattermost-server/v6/model"
)

type apiTimerLayer struct {
	pluginID string
	apiImpl  API
	metrics  einterfaces.MetricsInterface
}

func (api *apiTimerLayer) recordTime(startTime timePkg.Time, name string, success bool) {
	if api.metrics != nil {
		elapsedTime := float64(timePkg.Since(startTime)) / float64(timePkg.Second)
		api.metrics.ObservePluginAPIDuration(api.pluginID, name, success, elapsedTime)
	}
}

func (api *apiTimerLayer) LoadPluginConfiguration(dest interface{}) error {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.LoadPluginConfiguration(dest)
	api.recordTime(startTime, "LoadPluginConfiguration", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) RegisterCommand(command *model.Command) error {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RegisterCommand(command)
	api.recordTime(startTime, "RegisterCommand", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) UnregisterCommand(teamID, trigger string) error {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.UnregisterCommand(teamID, trigger)
	api.recordTime(startTime, "UnregisterCommand", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) ExecuteSlashCommand(commandArgs *model.CommandArgs) (*model.CommandResponse, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.ExecuteSlashCommand(commandArgs)
	api.recordTime(startTime, "ExecuteSlashCommand", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetConfig() *model.Config {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetConfig()
	api.recordTime(startTime, "GetConfig", true)
	return _returnsA
}

func (api *apiTimerLayer) GetUnsanitizedConfig() *model.Config {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetUnsanitizedConfig()
	api.recordTime(startTime, "GetUnsanitizedConfig", true)
	return _returnsA
}

func (api *apiTimerLayer) SaveConfig(config *model.Config) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.SaveConfig(config)
	api.recordTime(startTime, "SaveConfig", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetPluginConfig() map[string]interface{} {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetPluginConfig()
	api.recordTime(startTime, "GetPluginConfig", true)
	return _returnsA
}

func (api *apiTimerLayer) SavePluginConfig(config map[string]interface{}) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.SavePluginConfig(config)
	api.recordTime(startTime, "SavePluginConfig", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetBundlePath() (string, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetBundlePath()
	api.recordTime(startTime, "GetBundlePath", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetLicense() *model.License {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetLicense()
	api.recordTime(startTime, "GetLicense", true)
	return _returnsA
}

func (api *apiTimerLayer) IsEnterpriseReady() bool {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.IsEnterpriseReady()
	api.recordTime(startTime, "IsEnterpriseReady", true)
	return _returnsA
}

func (api *apiTimerLayer) GetServerVersion() string {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetServerVersion()
	api.recordTime(startTime, "GetServerVersion", true)
	return _returnsA
}

func (api *apiTimerLayer) GetSystemInstallDate() (int64, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetSystemInstallDate()
	api.recordTime(startTime, "GetSystemInstallDate", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetDiagnosticId() string {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetDiagnosticId()
	api.recordTime(startTime, "GetDiagnosticId", true)
	return _returnsA
}

func (api *apiTimerLayer) GetTelemetryId() string {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.GetTelemetryId()
	api.recordTime(startTime, "GetTelemetryId", true)
	return _returnsA
}

func (api *apiTimerLayer) CreateUser(user *model.User) (*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateUser(user)
	api.recordTime(startTime, "CreateUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteUser(userID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteUser(userID)
	api.recordTime(startTime, "DeleteUser", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUsers(options)
	api.recordTime(startTime, "GetUsers", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUser(userID string) (*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUser(userID)
	api.recordTime(startTime, "GetUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUserByEmail(email string) (*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUserByEmail(email)
	api.recordTime(startTime, "GetUserByEmail", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUserByUsername(name string) (*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUserByUsername(name)
	api.recordTime(startTime, "GetUserByUsername", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUsersByUsernames(usernames []string) ([]*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUsersByUsernames(usernames)
	api.recordTime(startTime, "GetUsersByUsernames", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUsersInTeam(teamID string, page int, perPage int) ([]*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUsersInTeam(teamID, page, perPage)
	api.recordTime(startTime, "GetUsersInTeam", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetPreferencesForUser(userID string) ([]model.Preference, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPreferencesForUser(userID)
	api.recordTime(startTime, "GetPreferencesForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdatePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.UpdatePreferencesForUser(userID, preferences)
	api.recordTime(startTime, "UpdatePreferencesForUser", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) DeletePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeletePreferencesForUser(userID, preferences)
	api.recordTime(startTime, "DeletePreferencesForUser", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetSession(sessionID string) (*model.Session, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetSession(sessionID)
	api.recordTime(startTime, "GetSession", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateSession(session *model.Session) (*model.Session, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateSession(session)
	api.recordTime(startTime, "CreateSession", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) ExtendSessionExpiry(sessionID string, newExpiry int64) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.ExtendSessionExpiry(sessionID, newExpiry)
	api.recordTime(startTime, "ExtendSessionExpiry", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) RevokeSession(sessionID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RevokeSession(sessionID)
	api.recordTime(startTime, "RevokeSession", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateUserAccessToken(token)
	api.recordTime(startTime, "CreateUserAccessToken", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) RevokeUserAccessToken(tokenID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RevokeUserAccessToken(tokenID)
	api.recordTime(startTime, "RevokeUserAccessToken", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetTeamIcon(teamID string) ([]byte, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamIcon(teamID)
	api.recordTime(startTime, "GetTeamIcon", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SetTeamIcon(teamID string, data []byte) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.SetTeamIcon(teamID, data)
	api.recordTime(startTime, "SetTeamIcon", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) RemoveTeamIcon(teamID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RemoveTeamIcon(teamID)
	api.recordTime(startTime, "RemoveTeamIcon", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) UpdateUser(user *model.User) (*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateUser(user)
	api.recordTime(startTime, "UpdateUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUserStatus(userID string) (*model.Status, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUserStatus(userID)
	api.recordTime(startTime, "GetUserStatus", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetUserStatusesByIds(userIds []string) ([]*model.Status, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUserStatusesByIds(userIds)
	api.recordTime(startTime, "GetUserStatusesByIds", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateUserStatus(userID, status string) (*model.Status, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateUserStatus(userID, status)
	api.recordTime(startTime, "UpdateUserStatus", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SetUserStatusTimedDND(userId string, endtime int64) (*model.Status, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.SetUserStatusTimedDND(userId, endtime)
	api.recordTime(startTime, "SetUserStatusTimedDND", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateUserActive(userID string, active bool) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.UpdateUserActive(userID, active)
	api.recordTime(startTime, "UpdateUserActive", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) UpdateUserCustomStatus(userID string, customStatus *model.CustomStatus) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.UpdateUserCustomStatus(userID, customStatus)
	api.recordTime(startTime, "UpdateUserCustomStatus", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) RemoveUserCustomStatus(userID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RemoveUserCustomStatus(userID)
	api.recordTime(startTime, "RemoveUserCustomStatus", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetUsersInChannel(channelID, sortBy string, page, perPage int) ([]*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetUsersInChannel(channelID, sortBy, page, perPage)
	api.recordTime(startTime, "GetUsersInChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetLDAPUserAttributes(userID string, attributes []string) (map[string]string, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetLDAPUserAttributes(userID, attributes)
	api.recordTime(startTime, "GetLDAPUserAttributes", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateTeam(team *model.Team) (*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateTeam(team)
	api.recordTime(startTime, "CreateTeam", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteTeam(teamID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteTeam(teamID)
	api.recordTime(startTime, "DeleteTeam", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetTeams() ([]*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeams()
	api.recordTime(startTime, "GetTeams", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeam(teamID string) (*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeam(teamID)
	api.recordTime(startTime, "GetTeam", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeamByName(name string) (*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamByName(name)
	api.recordTime(startTime, "GetTeamByName", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeamsUnreadForUser(userID string) ([]*model.TeamUnread, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamsUnreadForUser(userID)
	api.recordTime(startTime, "GetTeamsUnreadForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateTeam(team *model.Team) (*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateTeam(team)
	api.recordTime(startTime, "UpdateTeam", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SearchTeams(term string) ([]*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.SearchTeams(term)
	api.recordTime(startTime, "SearchTeams", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeamsForUser(userID string) ([]*model.Team, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamsForUser(userID)
	api.recordTime(startTime, "GetTeamsForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateTeamMember(teamID, userID)
	api.recordTime(startTime, "CreateTeamMember", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateTeamMembers(teamID string, userIds []string, requestorId string) ([]*model.TeamMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateTeamMembers(teamID, userIds, requestorId)
	api.recordTime(startTime, "CreateTeamMembers", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateTeamMembersGracefully(teamID string, userIds []string, requestorId string) ([]*model.TeamMemberWithError, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateTeamMembersGracefully(teamID, userIds, requestorId)
	api.recordTime(startTime, "CreateTeamMembersGracefully", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteTeamMember(teamID, userID, requestorId string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteTeamMember(teamID, userID, requestorId)
	api.recordTime(startTime, "DeleteTeamMember", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetTeamMembers(teamID string, page, perPage int) ([]*model.TeamMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamMembers(teamID, page, perPage)
	api.recordTime(startTime, "GetTeamMembers", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamMember(teamID, userID)
	api.recordTime(startTime, "GetTeamMember", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeamMembersForUser(userID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamMembersForUser(userID, page, perPage)
	api.recordTime(startTime, "GetTeamMembersForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateTeamMemberRoles(teamID, userID, newRoles string) (*model.TeamMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateTeamMemberRoles(teamID, userID, newRoles)
	api.recordTime(startTime, "UpdateTeamMemberRoles", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateChannel(channel)
	api.recordTime(startTime, "CreateChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteChannel(channelId string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteChannel(channelId)
	api.recordTime(startTime, "DeleteChannel", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetPublicChannelsForTeam(teamID string, page, perPage int) ([]*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPublicChannelsForTeam(teamID, page, perPage)
	api.recordTime(startTime, "GetPublicChannelsForTeam", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannel(channelId string) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannel(channelId)
	api.recordTime(startTime, "GetChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelByName(teamID, name string, includeDeleted bool) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelByName(teamID, name, includeDeleted)
	api.recordTime(startTime, "GetChannelByName", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelByNameForTeamName(teamName, channelName string, includeDeleted bool) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelByNameForTeamName(teamName, channelName, includeDeleted)
	api.recordTime(startTime, "GetChannelByNameForTeamName", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelsForTeamForUser(teamID, userID string, includeDeleted bool) ([]*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelsForTeamForUser(teamID, userID, includeDeleted)
	api.recordTime(startTime, "GetChannelsForTeamForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelStats(channelId string) (*model.ChannelStats, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelStats(channelId)
	api.recordTime(startTime, "GetChannelStats", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetDirectChannel(userId1, userId2 string) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetDirectChannel(userId1, userId2)
	api.recordTime(startTime, "GetDirectChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetGroupChannel(userIds []string) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetGroupChannel(userIds)
	api.recordTime(startTime, "GetGroupChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateChannel(channel)
	api.recordTime(startTime, "UpdateChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SearchChannels(teamID string, term string) ([]*model.Channel, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.SearchChannels(teamID, term)
	api.recordTime(startTime, "SearchChannels", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CreateChannelSidebarCategory(userID, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateChannelSidebarCategory(userID, teamID, newCategory)
	api.recordTime(startTime, "CreateChannelSidebarCategory", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelSidebarCategories(userID, teamID string) (*model.OrderedSidebarCategories, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelSidebarCategories(userID, teamID)
	api.recordTime(startTime, "GetChannelSidebarCategories", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateChannelSidebarCategories(userID, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateChannelSidebarCategories(userID, teamID, categories)
	api.recordTime(startTime, "UpdateChannelSidebarCategories", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SearchUsers(search *model.UserSearch) ([]*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.SearchUsers(search)
	api.recordTime(startTime, "SearchUsers", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) ([]*model.Post, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.SearchPostsInTeam(teamID, paramsList)
	api.recordTime(startTime, "SearchPostsInTeam", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SearchPostsInTeamForUser(teamID string, userID string, searchParams model.SearchParameter) (*model.PostSearchResults, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.SearchPostsInTeamForUser(teamID, userID, searchParams)
	api.recordTime(startTime, "SearchPostsInTeamForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) AddChannelMember(channelId, userID string) (*model.ChannelMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.AddChannelMember(channelId, userID)
	api.recordTime(startTime, "AddChannelMember", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) AddUserToChannel(channelId, userID, asUserId string) (*model.ChannelMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.AddUserToChannel(channelId, userID, asUserId)
	api.recordTime(startTime, "AddUserToChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelMember(channelId, userID string) (*model.ChannelMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelMember(channelId, userID)
	api.recordTime(startTime, "GetChannelMember", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelMembers(channelId string, page, perPage int) (model.ChannelMembers, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelMembers(channelId, page, perPage)
	api.recordTime(startTime, "GetChannelMembers", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelMembersByIds(channelId string, userIds []string) (model.ChannelMembers, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelMembersByIds(channelId, userIds)
	api.recordTime(startTime, "GetChannelMembersByIds", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetChannelMembersForUser(teamID, userID string, page, perPage int) ([]*model.ChannelMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetChannelMembersForUser(teamID, userID, page, perPage)
	api.recordTime(startTime, "GetChannelMembersForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateChannelMemberRoles(channelId, userID, newRoles string) (*model.ChannelMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateChannelMemberRoles(channelId, userID, newRoles)
	api.recordTime(startTime, "UpdateChannelMemberRoles", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateChannelMemberNotifications(channelId, userID string, notifications map[string]string) (*model.ChannelMember, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateChannelMemberNotifications(channelId, userID, notifications)
	api.recordTime(startTime, "UpdateChannelMemberNotifications", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetGroup(groupId string) (*model.Group, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetGroup(groupId)
	api.recordTime(startTime, "GetGroup", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetGroupByName(name string) (*model.Group, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetGroupByName(name)
	api.recordTime(startTime, "GetGroupByName", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetGroupMemberUsers(groupID string, page, perPage int) ([]*model.User, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetGroupMemberUsers(groupID, page, perPage)
	api.recordTime(startTime, "GetGroupMemberUsers", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetGroupsBySource(groupSource)
	api.recordTime(startTime, "GetGroupsBySource", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetGroupsForUser(userID string) ([]*model.Group, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetGroupsForUser(userID)
	api.recordTime(startTime, "GetGroupsForUser", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteChannelMember(channelId, userID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteChannelMember(channelId, userID)
	api.recordTime(startTime, "DeleteChannelMember", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) CreatePost(post *model.Post) (*model.Post, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreatePost(post)
	api.recordTime(startTime, "CreatePost", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) AddReaction(reaction *model.Reaction) (*model.Reaction, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.AddReaction(reaction)
	api.recordTime(startTime, "AddReaction", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) RemoveReaction(reaction *model.Reaction) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RemoveReaction(reaction)
	api.recordTime(startTime, "RemoveReaction", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetReactions(postId string) ([]*model.Reaction, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetReactions(postId)
	api.recordTime(startTime, "GetReactions", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SendEphemeralPost(userID string, post *model.Post) *model.Post {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.SendEphemeralPost(userID, post)
	api.recordTime(startTime, "SendEphemeralPost", true)
	return _returnsA
}

func (api *apiTimerLayer) UpdateEphemeralPost(userID string, post *model.Post) *model.Post {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.UpdateEphemeralPost(userID, post)
	api.recordTime(startTime, "UpdateEphemeralPost", true)
	return _returnsA
}

func (api *apiTimerLayer) DeleteEphemeralPost(userID, postId string) {
	startTime := timePkg.Now()
	api.apiImpl.DeleteEphemeralPost(userID, postId)
	api.recordTime(startTime, "DeleteEphemeralPost", true)
}

func (api *apiTimerLayer) DeletePost(postId string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeletePost(postId)
	api.recordTime(startTime, "DeletePost", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetPostThread(postId string) (*model.PostList, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPostThread(postId)
	api.recordTime(startTime, "GetPostThread", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetPost(postId string) (*model.Post, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPost(postId)
	api.recordTime(startTime, "GetPost", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetPostsSince(channelId string, time int64) (*model.PostList, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPostsSince(channelId, time)
	api.recordTime(startTime, "GetPostsSince", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetPostsAfter(channelId, postId string, page, perPage int) (*model.PostList, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPostsAfter(channelId, postId, page, perPage)
	api.recordTime(startTime, "GetPostsAfter", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetPostsBefore(channelId, postId string, page, perPage int) (*model.PostList, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPostsBefore(channelId, postId, page, perPage)
	api.recordTime(startTime, "GetPostsBefore", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetPostsForChannel(channelId string, page, perPage int) (*model.PostList, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPostsForChannel(channelId, page, perPage)
	api.recordTime(startTime, "GetPostsForChannel", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetTeamStats(teamID string) (*model.TeamStats, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetTeamStats(teamID)
	api.recordTime(startTime, "GetTeamStats", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdatePost(post *model.Post) (*model.Post, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdatePost(post)
	api.recordTime(startTime, "UpdatePost", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetProfileImage(userID string) ([]byte, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetProfileImage(userID)
	api.recordTime(startTime, "GetProfileImage", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) SetProfileImage(userID string, data []byte) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.SetProfileImage(userID, data)
	api.recordTime(startTime, "SetProfileImage", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetEmojiList(sortBy string, page, perPage int) ([]*model.Emoji, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetEmojiList(sortBy, page, perPage)
	api.recordTime(startTime, "GetEmojiList", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetEmojiByName(name string) (*model.Emoji, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetEmojiByName(name)
	api.recordTime(startTime, "GetEmojiByName", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetEmoji(emojiId string) (*model.Emoji, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetEmoji(emojiId)
	api.recordTime(startTime, "GetEmoji", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) CopyFileInfos(userID string, fileIds []string) ([]string, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CopyFileInfos(userID, fileIds)
	api.recordTime(startTime, "CopyFileInfos", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetFileInfo(fileId string) (*model.FileInfo, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetFileInfo(fileId)
	api.recordTime(startTime, "GetFileInfo", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetFileInfos(page, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetFileInfos(page, perPage, opt)
	api.recordTime(startTime, "GetFileInfos", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetFile(fileId string) ([]byte, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetFile(fileId)
	api.recordTime(startTime, "GetFile", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetFileLink(fileId string) (string, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetFileLink(fileId)
	api.recordTime(startTime, "GetFileLink", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) ReadFile(path string) ([]byte, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.ReadFile(path)
	api.recordTime(startTime, "ReadFile", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetEmojiImage(emojiId string) ([]byte, string, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB, _returnsC := api.apiImpl.GetEmojiImage(emojiId)
	api.recordTime(startTime, "GetEmojiImage", _returnsC == nil)
	return _returnsA, _returnsB, _returnsC
}

func (api *apiTimerLayer) UploadFile(data []byte, channelId string, filename string) (*model.FileInfo, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UploadFile(data, channelId, filename)
	api.recordTime(startTime, "UploadFile", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) OpenInteractiveDialog(dialog model.OpenDialogRequest) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.OpenInteractiveDialog(dialog)
	api.recordTime(startTime, "OpenInteractiveDialog", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetPlugins() ([]*model.Manifest, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPlugins()
	api.recordTime(startTime, "GetPlugins", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) EnablePlugin(id string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.EnablePlugin(id)
	api.recordTime(startTime, "EnablePlugin", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) DisablePlugin(id string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DisablePlugin(id)
	api.recordTime(startTime, "DisablePlugin", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) RemovePlugin(id string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RemovePlugin(id)
	api.recordTime(startTime, "RemovePlugin", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) GetPluginStatus(id string) (*model.PluginStatus, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetPluginStatus(id)
	api.recordTime(startTime, "GetPluginStatus", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) InstallPlugin(file io.Reader, replace bool) (*model.Manifest, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.InstallPlugin(file, replace)
	api.recordTime(startTime, "InstallPlugin", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) KVSet(key string, value []byte) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.KVSet(key, value)
	api.recordTime(startTime, "KVSet", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) KVCompareAndSet(key string, oldValue, newValue []byte) (bool, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.KVCompareAndSet(key, oldValue, newValue)
	api.recordTime(startTime, "KVCompareAndSet", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) KVCompareAndDelete(key string, oldValue []byte) (bool, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.KVCompareAndDelete(key, oldValue)
	api.recordTime(startTime, "KVCompareAndDelete", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) KVSetWithOptions(key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.KVSetWithOptions(key, value, options)
	api.recordTime(startTime, "KVSetWithOptions", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) KVSetWithExpiry(key string, value []byte, expireInSeconds int64) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.KVSetWithExpiry(key, value, expireInSeconds)
	api.recordTime(startTime, "KVSetWithExpiry", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) KVGet(key string) ([]byte, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.KVGet(key)
	api.recordTime(startTime, "KVGet", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) KVDelete(key string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.KVDelete(key)
	api.recordTime(startTime, "KVDelete", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) KVDeleteAll() *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.KVDeleteAll()
	api.recordTime(startTime, "KVDeleteAll", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) KVList(page, perPage int) ([]string, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.KVList(page, perPage)
	api.recordTime(startTime, "KVList", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) PublishWebSocketEvent(event string, payload map[string]interface{}, broadcast *model.WebsocketBroadcast) {
	startTime := timePkg.Now()
	api.apiImpl.PublishWebSocketEvent(event, payload, broadcast)
	api.recordTime(startTime, "PublishWebSocketEvent", true)
}

func (api *apiTimerLayer) HasPermissionTo(userID string, permission *model.Permission) bool {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.HasPermissionTo(userID, permission)
	api.recordTime(startTime, "HasPermissionTo", true)
	return _returnsA
}

func (api *apiTimerLayer) HasPermissionToTeam(userID, teamID string, permission *model.Permission) bool {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.HasPermissionToTeam(userID, teamID, permission)
	api.recordTime(startTime, "HasPermissionToTeam", true)
	return _returnsA
}

func (api *apiTimerLayer) HasPermissionToChannel(userID, channelId string, permission *model.Permission) bool {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.HasPermissionToChannel(userID, channelId, permission)
	api.recordTime(startTime, "HasPermissionToChannel", true)
	return _returnsA
}

func (api *apiTimerLayer) RolesGrantPermission(roleNames []string, permissionId string) bool {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RolesGrantPermission(roleNames, permissionId)
	api.recordTime(startTime, "RolesGrantPermission", true)
	return _returnsA
}

func (api *apiTimerLayer) LogDebug(msg string, keyValuePairs ...interface{}) {
	startTime := timePkg.Now()
	api.apiImpl.LogDebug(msg, keyValuePairs...)
	api.recordTime(startTime, "LogDebug", true)
}

func (api *apiTimerLayer) LogInfo(msg string, keyValuePairs ...interface{}) {
	startTime := timePkg.Now()
	api.apiImpl.LogInfo(msg, keyValuePairs...)
	api.recordTime(startTime, "LogInfo", true)
}

func (api *apiTimerLayer) LogError(msg string, keyValuePairs ...interface{}) {
	startTime := timePkg.Now()
	api.apiImpl.LogError(msg, keyValuePairs...)
	api.recordTime(startTime, "LogError", true)
}

func (api *apiTimerLayer) LogWarn(msg string, keyValuePairs ...interface{}) {
	startTime := timePkg.Now()
	api.apiImpl.LogWarn(msg, keyValuePairs...)
	api.recordTime(startTime, "LogWarn", true)
}

func (api *apiTimerLayer) SendMail(to, subject, htmlBody string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.SendMail(to, subject, htmlBody)
	api.recordTime(startTime, "SendMail", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) CreateBot(bot *model.Bot) (*model.Bot, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateBot(bot)
	api.recordTime(startTime, "CreateBot", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.PatchBot(botUserId, botPatch)
	api.recordTime(startTime, "PatchBot", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetBot(botUserId, includeDeleted)
	api.recordTime(startTime, "GetBot", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetBots(options *model.BotGetOptions) ([]*model.Bot, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetBots(options)
	api.recordTime(startTime, "GetBots", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateBotActive(botUserId string, active bool) (*model.Bot, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateBotActive(botUserId, active)
	api.recordTime(startTime, "UpdateBotActive", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) PermanentDeleteBot(botUserId string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.PermanentDeleteBot(botUserId)
	api.recordTime(startTime, "PermanentDeleteBot", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) PluginHTTP(request *http.Request) *http.Response {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.PluginHTTP(request)
	api.recordTime(startTime, "PluginHTTP", true)
	return _returnsA
}

func (api *apiTimerLayer) PublishUserTyping(userID, channelId, parentId string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.PublishUserTyping(userID, channelId, parentId)
	api.recordTime(startTime, "PublishUserTyping", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) CreateCommand(cmd *model.Command) (*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateCommand(cmd)
	api.recordTime(startTime, "CreateCommand", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) ListCommands(teamID string) ([]*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.ListCommands(teamID)
	api.recordTime(startTime, "ListCommands", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) ListCustomCommands(teamID string) ([]*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.ListCustomCommands(teamID)
	api.recordTime(startTime, "ListCustomCommands", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) ListPluginCommands(teamID string) ([]*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.ListPluginCommands(teamID)
	api.recordTime(startTime, "ListPluginCommands", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) ListBuiltInCommands() ([]*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.ListBuiltInCommands()
	api.recordTime(startTime, "ListBuiltInCommands", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetCommand(commandID string) (*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetCommand(commandID)
	api.recordTime(startTime, "GetCommand", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateCommand(commandID string, updatedCmd *model.Command) (*model.Command, error) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateCommand(commandID, updatedCmd)
	api.recordTime(startTime, "UpdateCommand", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteCommand(commandID string) error {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteCommand(commandID)
	api.recordTime(startTime, "DeleteCommand", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.CreateOAuthApp(app)
	api.recordTime(startTime, "CreateOAuthApp", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.GetOAuthApp(appID)
	api.recordTime(startTime, "GetOAuthApp", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) UpdateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	startTime := timePkg.Now()
	_returnsA, _returnsB := api.apiImpl.UpdateOAuthApp(app)
	api.recordTime(startTime, "UpdateOAuthApp", _returnsB == nil)
	return _returnsA, _returnsB
}

func (api *apiTimerLayer) DeleteOAuthApp(appID string) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.DeleteOAuthApp(appID)
	api.recordTime(startTime, "DeleteOAuthApp", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) PublishPluginClusterEvent(ev model.PluginClusterEvent, opts model.PluginClusterEventSendOptions) error {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.PublishPluginClusterEvent(ev, opts)
	api.recordTime(startTime, "PublishPluginClusterEvent", _returnsA == nil)
	return _returnsA
}

func (api *apiTimerLayer) RequestTrialLicense(requesterID string, users int, termsAccepted bool, receiveEmailsAccepted bool) *model.AppError {
	startTime := timePkg.Now()
	_returnsA := api.apiImpl.RequestTrialLicense(requesterID, users, termsAccepted, receiveEmailsAccepted)
	api.recordTime(startTime, "RequestTrialLicense", _returnsA == nil)
	return _returnsA
}
