// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make pluginapi"
// DO NOT EDIT

package plugin

import (
	"fmt"
	"log"

	"github.com/mattermost/mattermost-server/v6/model"
	"github.com/mattermost/mattermost-server/v6/shared/mlog"
)

func init() {
	hookNameToId["OnDeactivate"] = OnDeactivateID
}

type Z_OnDeactivateArgs struct {
}

type Z_OnDeactivateReturns struct {
	A error
}

func (g *hooksRPCClient) OnDeactivate() error {
	_args := &Z_OnDeactivateArgs{}
	_returns := &Z_OnDeactivateReturns{}
	if g.implemented[OnDeactivateID] {
		if err := g.client.Call("Plugin.OnDeactivate", _args, _returns); err != nil {
			g.log.Error("RPC call OnDeactivate to plugin failed.", mlog.Err(err))
		}
	}
	return _returns.A
}

func (s *hooksRPCServer) OnDeactivate(args *Z_OnDeactivateArgs, returns *Z_OnDeactivateReturns) error {
	if hook, ok := s.impl.(interface {
		OnDeactivate() error
	}); ok {
		returns.A = hook.OnDeactivate()
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("Hook OnDeactivate called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["OnConfigurationChange"] = OnConfigurationChangeID
}

type Z_OnConfigurationChangeArgs struct {
}

type Z_OnConfigurationChangeReturns struct {
	A error
}

func (g *hooksRPCClient) OnConfigurationChange() error {
	_args := &Z_OnConfigurationChangeArgs{}
	_returns := &Z_OnConfigurationChangeReturns{}
	if g.implemented[OnConfigurationChangeID] {
		if err := g.client.Call("Plugin.OnConfigurationChange", _args, _returns); err != nil {
			g.log.Error("RPC call OnConfigurationChange to plugin failed.", mlog.Err(err))
		}
	}
	return _returns.A
}

func (s *hooksRPCServer) OnConfigurationChange(args *Z_OnConfigurationChangeArgs, returns *Z_OnConfigurationChangeReturns) error {
	if hook, ok := s.impl.(interface {
		OnConfigurationChange() error
	}); ok {
		returns.A = hook.OnConfigurationChange()
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("Hook OnConfigurationChange called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["ExecuteCommand"] = ExecuteCommandID
}

type Z_ExecuteCommandArgs struct {
	A *Context
	B *model.CommandArgs
}

type Z_ExecuteCommandReturns struct {
	A *model.CommandResponse
	B *model.AppError
}

func (g *hooksRPCClient) ExecuteCommand(c *Context, args *model.CommandArgs) (*model.CommandResponse, *model.AppError) {
	_args := &Z_ExecuteCommandArgs{c, args}
	_returns := &Z_ExecuteCommandReturns{}
	if g.implemented[ExecuteCommandID] {
		if err := g.client.Call("Plugin.ExecuteCommand", _args, _returns); err != nil {
			g.log.Error("RPC call ExecuteCommand to plugin failed.", mlog.Err(err))
		}
	}
	return _returns.A, _returns.B
}

func (s *hooksRPCServer) ExecuteCommand(args *Z_ExecuteCommandArgs, returns *Z_ExecuteCommandReturns) error {
	if hook, ok := s.impl.(interface {
		ExecuteCommand(c *Context, args *model.CommandArgs) (*model.CommandResponse, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.ExecuteCommand(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook ExecuteCommand called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserHasBeenCreated"] = UserHasBeenCreatedID
}

type Z_UserHasBeenCreatedArgs struct {
	A *Context
	B *model.User
}

type Z_UserHasBeenCreatedReturns struct {
}

func (g *hooksRPCClient) UserHasBeenCreated(c *Context, user *model.User) {
	_args := &Z_UserHasBeenCreatedArgs{c, user}
	_returns := &Z_UserHasBeenCreatedReturns{}
	if g.implemented[UserHasBeenCreatedID] {
		if err := g.client.Call("Plugin.UserHasBeenCreated", _args, _returns); err != nil {
			g.log.Error("RPC call UserHasBeenCreated to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) UserHasBeenCreated(args *Z_UserHasBeenCreatedArgs, returns *Z_UserHasBeenCreatedReturns) error {
	if hook, ok := s.impl.(interface {
		UserHasBeenCreated(c *Context, user *model.User)
	}); ok {
		hook.UserHasBeenCreated(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook UserHasBeenCreated called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserWillLogIn"] = UserWillLogInID
}

type Z_UserWillLogInArgs struct {
	A *Context
	B *model.User
}

type Z_UserWillLogInReturns struct {
	A string
}

func (g *hooksRPCClient) UserWillLogIn(c *Context, user *model.User) string {
	_args := &Z_UserWillLogInArgs{c, user}
	_returns := &Z_UserWillLogInReturns{}
	if g.implemented[UserWillLogInID] {
		if err := g.client.Call("Plugin.UserWillLogIn", _args, _returns); err != nil {
			g.log.Error("RPC call UserWillLogIn to plugin failed.", mlog.Err(err))
		}
	}
	return _returns.A
}

func (s *hooksRPCServer) UserWillLogIn(args *Z_UserWillLogInArgs, returns *Z_UserWillLogInReturns) error {
	if hook, ok := s.impl.(interface {
		UserWillLogIn(c *Context, user *model.User) string
	}); ok {
		returns.A = hook.UserWillLogIn(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook UserWillLogIn called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserHasLoggedIn"] = UserHasLoggedInID
}

type Z_UserHasLoggedInArgs struct {
	A *Context
	B *model.User
}

type Z_UserHasLoggedInReturns struct {
}

func (g *hooksRPCClient) UserHasLoggedIn(c *Context, user *model.User) {
	_args := &Z_UserHasLoggedInArgs{c, user}
	_returns := &Z_UserHasLoggedInReturns{}
	if g.implemented[UserHasLoggedInID] {
		if err := g.client.Call("Plugin.UserHasLoggedIn", _args, _returns); err != nil {
			g.log.Error("RPC call UserHasLoggedIn to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) UserHasLoggedIn(args *Z_UserHasLoggedInArgs, returns *Z_UserHasLoggedInReturns) error {
	if hook, ok := s.impl.(interface {
		UserHasLoggedIn(c *Context, user *model.User)
	}); ok {
		hook.UserHasLoggedIn(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook UserHasLoggedIn called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["MessageHasBeenPosted"] = MessageHasBeenPostedID
}

type Z_MessageHasBeenPostedArgs struct {
	A *Context
	B *model.Post
}

type Z_MessageHasBeenPostedReturns struct {
}

func (g *hooksRPCClient) MessageHasBeenPosted(c *Context, post *model.Post) {
	_args := &Z_MessageHasBeenPostedArgs{c, post}
	_returns := &Z_MessageHasBeenPostedReturns{}
	if g.implemented[MessageHasBeenPostedID] {
		if err := g.client.Call("Plugin.MessageHasBeenPosted", _args, _returns); err != nil {
			g.log.Error("RPC call MessageHasBeenPosted to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) MessageHasBeenPosted(args *Z_MessageHasBeenPostedArgs, returns *Z_MessageHasBeenPostedReturns) error {
	if hook, ok := s.impl.(interface {
		MessageHasBeenPosted(c *Context, post *model.Post)
	}); ok {
		hook.MessageHasBeenPosted(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook MessageHasBeenPosted called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["MessageHasBeenUpdated"] = MessageHasBeenUpdatedID
}

type Z_MessageHasBeenUpdatedArgs struct {
	A *Context
	B *model.Post
	C *model.Post
}

type Z_MessageHasBeenUpdatedReturns struct {
}

func (g *hooksRPCClient) MessageHasBeenUpdated(c *Context, newPost, oldPost *model.Post) {
	_args := &Z_MessageHasBeenUpdatedArgs{c, newPost, oldPost}
	_returns := &Z_MessageHasBeenUpdatedReturns{}
	if g.implemented[MessageHasBeenUpdatedID] {
		if err := g.client.Call("Plugin.MessageHasBeenUpdated", _args, _returns); err != nil {
			g.log.Error("RPC call MessageHasBeenUpdated to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) MessageHasBeenUpdated(args *Z_MessageHasBeenUpdatedArgs, returns *Z_MessageHasBeenUpdatedReturns) error {
	if hook, ok := s.impl.(interface {
		MessageHasBeenUpdated(c *Context, newPost, oldPost *model.Post)
	}); ok {
		hook.MessageHasBeenUpdated(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("Hook MessageHasBeenUpdated called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["ChannelHasBeenCreated"] = ChannelHasBeenCreatedID
}

type Z_ChannelHasBeenCreatedArgs struct {
	A *Context
	B *model.Channel
}

type Z_ChannelHasBeenCreatedReturns struct {
}

func (g *hooksRPCClient) ChannelHasBeenCreated(c *Context, channel *model.Channel) {
	_args := &Z_ChannelHasBeenCreatedArgs{c, channel}
	_returns := &Z_ChannelHasBeenCreatedReturns{}
	if g.implemented[ChannelHasBeenCreatedID] {
		if err := g.client.Call("Plugin.ChannelHasBeenCreated", _args, _returns); err != nil {
			g.log.Error("RPC call ChannelHasBeenCreated to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) ChannelHasBeenCreated(args *Z_ChannelHasBeenCreatedArgs, returns *Z_ChannelHasBeenCreatedReturns) error {
	if hook, ok := s.impl.(interface {
		ChannelHasBeenCreated(c *Context, channel *model.Channel)
	}); ok {
		hook.ChannelHasBeenCreated(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook ChannelHasBeenCreated called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserHasJoinedChannel"] = UserHasJoinedChannelID
}

type Z_UserHasJoinedChannelArgs struct {
	A *Context
	B *model.ChannelMember
	C *model.User
}

type Z_UserHasJoinedChannelReturns struct {
}

func (g *hooksRPCClient) UserHasJoinedChannel(c *Context, channelMember *model.ChannelMember, actor *model.User) {
	_args := &Z_UserHasJoinedChannelArgs{c, channelMember, actor}
	_returns := &Z_UserHasJoinedChannelReturns{}
	if g.implemented[UserHasJoinedChannelID] {
		if err := g.client.Call("Plugin.UserHasJoinedChannel", _args, _returns); err != nil {
			g.log.Error("RPC call UserHasJoinedChannel to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) UserHasJoinedChannel(args *Z_UserHasJoinedChannelArgs, returns *Z_UserHasJoinedChannelReturns) error {
	if hook, ok := s.impl.(interface {
		UserHasJoinedChannel(c *Context, channelMember *model.ChannelMember, actor *model.User)
	}); ok {
		hook.UserHasJoinedChannel(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("Hook UserHasJoinedChannel called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserHasLeftChannel"] = UserHasLeftChannelID
}

type Z_UserHasLeftChannelArgs struct {
	A *Context
	B *model.ChannelMember
	C *model.User
}

type Z_UserHasLeftChannelReturns struct {
}

func (g *hooksRPCClient) UserHasLeftChannel(c *Context, channelMember *model.ChannelMember, actor *model.User) {
	_args := &Z_UserHasLeftChannelArgs{c, channelMember, actor}
	_returns := &Z_UserHasLeftChannelReturns{}
	if g.implemented[UserHasLeftChannelID] {
		if err := g.client.Call("Plugin.UserHasLeftChannel", _args, _returns); err != nil {
			g.log.Error("RPC call UserHasLeftChannel to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) UserHasLeftChannel(args *Z_UserHasLeftChannelArgs, returns *Z_UserHasLeftChannelReturns) error {
	if hook, ok := s.impl.(interface {
		UserHasLeftChannel(c *Context, channelMember *model.ChannelMember, actor *model.User)
	}); ok {
		hook.UserHasLeftChannel(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("Hook UserHasLeftChannel called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserHasJoinedTeam"] = UserHasJoinedTeamID
}

type Z_UserHasJoinedTeamArgs struct {
	A *Context
	B *model.TeamMember
	C *model.User
}

type Z_UserHasJoinedTeamReturns struct {
}

func (g *hooksRPCClient) UserHasJoinedTeam(c *Context, teamMember *model.TeamMember, actor *model.User) {
	_args := &Z_UserHasJoinedTeamArgs{c, teamMember, actor}
	_returns := &Z_UserHasJoinedTeamReturns{}
	if g.implemented[UserHasJoinedTeamID] {
		if err := g.client.Call("Plugin.UserHasJoinedTeam", _args, _returns); err != nil {
			g.log.Error("RPC call UserHasJoinedTeam to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) UserHasJoinedTeam(args *Z_UserHasJoinedTeamArgs, returns *Z_UserHasJoinedTeamReturns) error {
	if hook, ok := s.impl.(interface {
		UserHasJoinedTeam(c *Context, teamMember *model.TeamMember, actor *model.User)
	}); ok {
		hook.UserHasJoinedTeam(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("Hook UserHasJoinedTeam called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["UserHasLeftTeam"] = UserHasLeftTeamID
}

type Z_UserHasLeftTeamArgs struct {
	A *Context
	B *model.TeamMember
	C *model.User
}

type Z_UserHasLeftTeamReturns struct {
}

func (g *hooksRPCClient) UserHasLeftTeam(c *Context, teamMember *model.TeamMember, actor *model.User) {
	_args := &Z_UserHasLeftTeamArgs{c, teamMember, actor}
	_returns := &Z_UserHasLeftTeamReturns{}
	if g.implemented[UserHasLeftTeamID] {
		if err := g.client.Call("Plugin.UserHasLeftTeam", _args, _returns); err != nil {
			g.log.Error("RPC call UserHasLeftTeam to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) UserHasLeftTeam(args *Z_UserHasLeftTeamArgs, returns *Z_UserHasLeftTeamReturns) error {
	if hook, ok := s.impl.(interface {
		UserHasLeftTeam(c *Context, teamMember *model.TeamMember, actor *model.User)
	}); ok {
		hook.UserHasLeftTeam(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("Hook UserHasLeftTeam called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["ReactionHasBeenAdded"] = ReactionHasBeenAddedID
}

type Z_ReactionHasBeenAddedArgs struct {
	A *Context
	B *model.Reaction
}

type Z_ReactionHasBeenAddedReturns struct {
}

func (g *hooksRPCClient) ReactionHasBeenAdded(c *Context, reaction *model.Reaction) {
	_args := &Z_ReactionHasBeenAddedArgs{c, reaction}
	_returns := &Z_ReactionHasBeenAddedReturns{}
	if g.implemented[ReactionHasBeenAddedID] {
		if err := g.client.Call("Plugin.ReactionHasBeenAdded", _args, _returns); err != nil {
			g.log.Error("RPC call ReactionHasBeenAdded to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) ReactionHasBeenAdded(args *Z_ReactionHasBeenAddedArgs, returns *Z_ReactionHasBeenAddedReturns) error {
	if hook, ok := s.impl.(interface {
		ReactionHasBeenAdded(c *Context, reaction *model.Reaction)
	}); ok {
		hook.ReactionHasBeenAdded(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook ReactionHasBeenAdded called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["ReactionHasBeenRemoved"] = ReactionHasBeenRemovedID
}

type Z_ReactionHasBeenRemovedArgs struct {
	A *Context
	B *model.Reaction
}

type Z_ReactionHasBeenRemovedReturns struct {
}

func (g *hooksRPCClient) ReactionHasBeenRemoved(c *Context, reaction *model.Reaction) {
	_args := &Z_ReactionHasBeenRemovedArgs{c, reaction}
	_returns := &Z_ReactionHasBeenRemovedReturns{}
	if g.implemented[ReactionHasBeenRemovedID] {
		if err := g.client.Call("Plugin.ReactionHasBeenRemoved", _args, _returns); err != nil {
			g.log.Error("RPC call ReactionHasBeenRemoved to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) ReactionHasBeenRemoved(args *Z_ReactionHasBeenRemovedArgs, returns *Z_ReactionHasBeenRemovedReturns) error {
	if hook, ok := s.impl.(interface {
		ReactionHasBeenRemoved(c *Context, reaction *model.Reaction)
	}); ok {
		hook.ReactionHasBeenRemoved(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook ReactionHasBeenRemoved called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["OnPluginClusterEvent"] = OnPluginClusterEventID
}

type Z_OnPluginClusterEventArgs struct {
	A *Context
	B model.PluginClusterEvent
}

type Z_OnPluginClusterEventReturns struct {
}

func (g *hooksRPCClient) OnPluginClusterEvent(c *Context, ev model.PluginClusterEvent) {
	_args := &Z_OnPluginClusterEventArgs{c, ev}
	_returns := &Z_OnPluginClusterEventReturns{}
	if g.implemented[OnPluginClusterEventID] {
		if err := g.client.Call("Plugin.OnPluginClusterEvent", _args, _returns); err != nil {
			g.log.Error("RPC call OnPluginClusterEvent to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) OnPluginClusterEvent(args *Z_OnPluginClusterEventArgs, returns *Z_OnPluginClusterEventReturns) error {
	if hook, ok := s.impl.(interface {
		OnPluginClusterEvent(c *Context, ev model.PluginClusterEvent)
	}); ok {
		hook.OnPluginClusterEvent(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook OnPluginClusterEvent called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["OnWebSocketConnect"] = OnWebSocketConnectID
}

type Z_OnWebSocketConnectArgs struct {
	A string
	B string
}

type Z_OnWebSocketConnectReturns struct {
}

func (g *hooksRPCClient) OnWebSocketConnect(webConnID, userID string) {
	_args := &Z_OnWebSocketConnectArgs{webConnID, userID}
	_returns := &Z_OnWebSocketConnectReturns{}
	if g.implemented[OnWebSocketConnectID] {
		if err := g.client.Call("Plugin.OnWebSocketConnect", _args, _returns); err != nil {
			g.log.Error("RPC call OnWebSocketConnect to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) OnWebSocketConnect(args *Z_OnWebSocketConnectArgs, returns *Z_OnWebSocketConnectReturns) error {
	if hook, ok := s.impl.(interface {
		OnWebSocketConnect(webConnID, userID string)
	}); ok {
		hook.OnWebSocketConnect(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook OnWebSocketConnect called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["OnWebSocketDisconnect"] = OnWebSocketDisconnectID
}

type Z_OnWebSocketDisconnectArgs struct {
	A string
	B string
}

type Z_OnWebSocketDisconnectReturns struct {
}

func (g *hooksRPCClient) OnWebSocketDisconnect(webConnID, userID string) {
	_args := &Z_OnWebSocketDisconnectArgs{webConnID, userID}
	_returns := &Z_OnWebSocketDisconnectReturns{}
	if g.implemented[OnWebSocketDisconnectID] {
		if err := g.client.Call("Plugin.OnWebSocketDisconnect", _args, _returns); err != nil {
			g.log.Error("RPC call OnWebSocketDisconnect to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) OnWebSocketDisconnect(args *Z_OnWebSocketDisconnectArgs, returns *Z_OnWebSocketDisconnectReturns) error {
	if hook, ok := s.impl.(interface {
		OnWebSocketDisconnect(webConnID, userID string)
	}); ok {
		hook.OnWebSocketDisconnect(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("Hook OnWebSocketDisconnect called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["WebSocketMessageHasBeenPosted"] = WebSocketMessageHasBeenPostedID
}

type Z_WebSocketMessageHasBeenPostedArgs struct {
	A string
	B string
	C *model.WebSocketRequest
}

type Z_WebSocketMessageHasBeenPostedReturns struct {
}

func (g *hooksRPCClient) WebSocketMessageHasBeenPosted(webConnID, userID string, req *model.WebSocketRequest) {
	_args := &Z_WebSocketMessageHasBeenPostedArgs{webConnID, userID, req}
	_returns := &Z_WebSocketMessageHasBeenPostedReturns{}
	if g.implemented[WebSocketMessageHasBeenPostedID] {
		if err := g.client.Call("Plugin.WebSocketMessageHasBeenPosted", _args, _returns); err != nil {
			g.log.Error("RPC call WebSocketMessageHasBeenPosted to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) WebSocketMessageHasBeenPosted(args *Z_WebSocketMessageHasBeenPostedArgs, returns *Z_WebSocketMessageHasBeenPostedReturns) error {
	if hook, ok := s.impl.(interface {
		WebSocketMessageHasBeenPosted(webConnID, userID string, req *model.WebSocketRequest)
	}); ok {
		hook.WebSocketMessageHasBeenPosted(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("Hook WebSocketMessageHasBeenPosted called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["RunDataRetention"] = RunDataRetentionID
}

type Z_RunDataRetentionArgs struct {
	A int64
	B int64
}

type Z_RunDataRetentionReturns struct {
	A int64
	B error
}

func (g *hooksRPCClient) RunDataRetention(nowTime, batchSize int64) (int64, error) {
	_args := &Z_RunDataRetentionArgs{nowTime, batchSize}
	_returns := &Z_RunDataRetentionReturns{}
	if g.implemented[RunDataRetentionID] {
		if err := g.client.Call("Plugin.RunDataRetention", _args, _returns); err != nil {
			g.log.Error("RPC call RunDataRetention to plugin failed.", mlog.Err(err))
		}
	}
	return _returns.A, _returns.B
}

func (s *hooksRPCServer) RunDataRetention(args *Z_RunDataRetentionArgs, returns *Z_RunDataRetentionReturns) error {
	if hook, ok := s.impl.(interface {
		RunDataRetention(nowTime, batchSize int64) (int64, error)
	}); ok {
		returns.A, returns.B = hook.RunDataRetention(args.A, args.B)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("Hook RunDataRetention called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["OnInstall"] = OnInstallID
}

type Z_OnInstallArgs struct {
	A *Context
	B model.OnInstallEvent
}

type Z_OnInstallReturns struct {
	A error
}

func (g *hooksRPCClient) OnInstall(c *Context, event model.OnInstallEvent) error {
	_args := &Z_OnInstallArgs{c, event}
	_returns := &Z_OnInstallReturns{}
	if g.implemented[OnInstallID] {
		if err := g.client.Call("Plugin.OnInstall", _args, _returns); err != nil {
			g.log.Error("RPC call OnInstall to plugin failed.", mlog.Err(err))
		}
	}
	return _returns.A
}

func (s *hooksRPCServer) OnInstall(args *Z_OnInstallArgs, returns *Z_OnInstallReturns) error {
	if hook, ok := s.impl.(interface {
		OnInstall(c *Context, event model.OnInstallEvent) error
	}); ok {
		returns.A = hook.OnInstall(args.A, args.B)
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("Hook OnInstall called but not implemented."))
	}
	return nil
}

func init() {
	hookNameToId["OnSendDailyTelemetry"] = OnSendDailyTelemetryID
}

type Z_OnSendDailyTelemetryArgs struct {
}

type Z_OnSendDailyTelemetryReturns struct {
}

func (g *hooksRPCClient) OnSendDailyTelemetry() {
	_args := &Z_OnSendDailyTelemetryArgs{}
	_returns := &Z_OnSendDailyTelemetryReturns{}
	if g.implemented[OnSendDailyTelemetryID] {
		if err := g.client.Call("Plugin.OnSendDailyTelemetry", _args, _returns); err != nil {
			g.log.Error("RPC call OnSendDailyTelemetry to plugin failed.", mlog.Err(err))
		}
	}

}

func (s *hooksRPCServer) OnSendDailyTelemetry(args *Z_OnSendDailyTelemetryArgs, returns *Z_OnSendDailyTelemetryReturns) error {
	if hook, ok := s.impl.(interface {
		OnSendDailyTelemetry()
	}); ok {
		hook.OnSendDailyTelemetry()
	} else {
		return encodableError(fmt.Errorf("Hook OnSendDailyTelemetry called but not implemented."))
	}
	return nil
}

type Z_RegisterCommandArgs struct {
	A *model.Command
}

type Z_RegisterCommandReturns struct {
	A error
}

func (g *apiRPCClient) RegisterCommand(command *model.Command) error {
	_args := &Z_RegisterCommandArgs{command}
	_returns := &Z_RegisterCommandReturns{}
	if err := g.client.Call("Plugin.RegisterCommand", _args, _returns); err != nil {
		log.Printf("RPC call to RegisterCommand API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RegisterCommand(args *Z_RegisterCommandArgs, returns *Z_RegisterCommandReturns) error {
	if hook, ok := s.impl.(interface {
		RegisterCommand(command *model.Command) error
	}); ok {
		returns.A = hook.RegisterCommand(args.A)
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("API RegisterCommand called but not implemented."))
	}
	return nil
}

type Z_UnregisterCommandArgs struct {
	A string
	B string
}

type Z_UnregisterCommandReturns struct {
	A error
}

func (g *apiRPCClient) UnregisterCommand(teamID, trigger string) error {
	_args := &Z_UnregisterCommandArgs{teamID, trigger}
	_returns := &Z_UnregisterCommandReturns{}
	if err := g.client.Call("Plugin.UnregisterCommand", _args, _returns); err != nil {
		log.Printf("RPC call to UnregisterCommand API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) UnregisterCommand(args *Z_UnregisterCommandArgs, returns *Z_UnregisterCommandReturns) error {
	if hook, ok := s.impl.(interface {
		UnregisterCommand(teamID, trigger string) error
	}); ok {
		returns.A = hook.UnregisterCommand(args.A, args.B)
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("API UnregisterCommand called but not implemented."))
	}
	return nil
}

type Z_ExecuteSlashCommandArgs struct {
	A *model.CommandArgs
}

type Z_ExecuteSlashCommandReturns struct {
	A *model.CommandResponse
	B error
}

func (g *apiRPCClient) ExecuteSlashCommand(commandArgs *model.CommandArgs) (*model.CommandResponse, error) {
	_args := &Z_ExecuteSlashCommandArgs{commandArgs}
	_returns := &Z_ExecuteSlashCommandReturns{}
	if err := g.client.Call("Plugin.ExecuteSlashCommand", _args, _returns); err != nil {
		log.Printf("RPC call to ExecuteSlashCommand API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) ExecuteSlashCommand(args *Z_ExecuteSlashCommandArgs, returns *Z_ExecuteSlashCommandReturns) error {
	if hook, ok := s.impl.(interface {
		ExecuteSlashCommand(commandArgs *model.CommandArgs) (*model.CommandResponse, error)
	}); ok {
		returns.A, returns.B = hook.ExecuteSlashCommand(args.A)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API ExecuteSlashCommand called but not implemented."))
	}
	return nil
}

type Z_GetConfigArgs struct {
}

type Z_GetConfigReturns struct {
	A *model.Config
}

func (g *apiRPCClient) GetConfig() *model.Config {
	_args := &Z_GetConfigArgs{}
	_returns := &Z_GetConfigReturns{}
	if err := g.client.Call("Plugin.GetConfig", _args, _returns); err != nil {
		log.Printf("RPC call to GetConfig API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetConfig(args *Z_GetConfigArgs, returns *Z_GetConfigReturns) error {
	if hook, ok := s.impl.(interface {
		GetConfig() *model.Config
	}); ok {
		returns.A = hook.GetConfig()
	} else {
		return encodableError(fmt.Errorf("API GetConfig called but not implemented."))
	}
	return nil
}

type Z_GetUnsanitizedConfigArgs struct {
}

type Z_GetUnsanitizedConfigReturns struct {
	A *model.Config
}

func (g *apiRPCClient) GetUnsanitizedConfig() *model.Config {
	_args := &Z_GetUnsanitizedConfigArgs{}
	_returns := &Z_GetUnsanitizedConfigReturns{}
	if err := g.client.Call("Plugin.GetUnsanitizedConfig", _args, _returns); err != nil {
		log.Printf("RPC call to GetUnsanitizedConfig API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetUnsanitizedConfig(args *Z_GetUnsanitizedConfigArgs, returns *Z_GetUnsanitizedConfigReturns) error {
	if hook, ok := s.impl.(interface {
		GetUnsanitizedConfig() *model.Config
	}); ok {
		returns.A = hook.GetUnsanitizedConfig()
	} else {
		return encodableError(fmt.Errorf("API GetUnsanitizedConfig called but not implemented."))
	}
	return nil
}

type Z_SaveConfigArgs struct {
	A *model.Config
}

type Z_SaveConfigReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) SaveConfig(config *model.Config) *model.AppError {
	_args := &Z_SaveConfigArgs{config}
	_returns := &Z_SaveConfigReturns{}
	if err := g.client.Call("Plugin.SaveConfig", _args, _returns); err != nil {
		log.Printf("RPC call to SaveConfig API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) SaveConfig(args *Z_SaveConfigArgs, returns *Z_SaveConfigReturns) error {
	if hook, ok := s.impl.(interface {
		SaveConfig(config *model.Config) *model.AppError
	}); ok {
		returns.A = hook.SaveConfig(args.A)
	} else {
		return encodableError(fmt.Errorf("API SaveConfig called but not implemented."))
	}
	return nil
}

type Z_GetPluginConfigArgs struct {
}

type Z_GetPluginConfigReturns struct {
	A map[string]interface{}
}

func (g *apiRPCClient) GetPluginConfig() map[string]interface{} {
	_args := &Z_GetPluginConfigArgs{}
	_returns := &Z_GetPluginConfigReturns{}
	if err := g.client.Call("Plugin.GetPluginConfig", _args, _returns); err != nil {
		log.Printf("RPC call to GetPluginConfig API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetPluginConfig(args *Z_GetPluginConfigArgs, returns *Z_GetPluginConfigReturns) error {
	if hook, ok := s.impl.(interface {
		GetPluginConfig() map[string]interface{}
	}); ok {
		returns.A = hook.GetPluginConfig()
	} else {
		return encodableError(fmt.Errorf("API GetPluginConfig called but not implemented."))
	}
	return nil
}

type Z_SavePluginConfigArgs struct {
	A map[string]interface{}
}

type Z_SavePluginConfigReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) SavePluginConfig(config map[string]interface{}) *model.AppError {
	_args := &Z_SavePluginConfigArgs{config}
	_returns := &Z_SavePluginConfigReturns{}
	if err := g.client.Call("Plugin.SavePluginConfig", _args, _returns); err != nil {
		log.Printf("RPC call to SavePluginConfig API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) SavePluginConfig(args *Z_SavePluginConfigArgs, returns *Z_SavePluginConfigReturns) error {
	if hook, ok := s.impl.(interface {
		SavePluginConfig(config map[string]interface{}) *model.AppError
	}); ok {
		returns.A = hook.SavePluginConfig(args.A)
	} else {
		return encodableError(fmt.Errorf("API SavePluginConfig called but not implemented."))
	}
	return nil
}

type Z_GetBundlePathArgs struct {
}

type Z_GetBundlePathReturns struct {
	A string
	B error
}

func (g *apiRPCClient) GetBundlePath() (string, error) {
	_args := &Z_GetBundlePathArgs{}
	_returns := &Z_GetBundlePathReturns{}
	if err := g.client.Call("Plugin.GetBundlePath", _args, _returns); err != nil {
		log.Printf("RPC call to GetBundlePath API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetBundlePath(args *Z_GetBundlePathArgs, returns *Z_GetBundlePathReturns) error {
	if hook, ok := s.impl.(interface {
		GetBundlePath() (string, error)
	}); ok {
		returns.A, returns.B = hook.GetBundlePath()
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API GetBundlePath called but not implemented."))
	}
	return nil
}

type Z_GetLicenseArgs struct {
}

type Z_GetLicenseReturns struct {
	A *model.License
}

func (g *apiRPCClient) GetLicense() *model.License {
	_args := &Z_GetLicenseArgs{}
	_returns := &Z_GetLicenseReturns{}
	if err := g.client.Call("Plugin.GetLicense", _args, _returns); err != nil {
		log.Printf("RPC call to GetLicense API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetLicense(args *Z_GetLicenseArgs, returns *Z_GetLicenseReturns) error {
	if hook, ok := s.impl.(interface {
		GetLicense() *model.License
	}); ok {
		returns.A = hook.GetLicense()
	} else {
		return encodableError(fmt.Errorf("API GetLicense called but not implemented."))
	}
	return nil
}

type Z_IsEnterpriseReadyArgs struct {
}

type Z_IsEnterpriseReadyReturns struct {
	A bool
}

func (g *apiRPCClient) IsEnterpriseReady() bool {
	_args := &Z_IsEnterpriseReadyArgs{}
	_returns := &Z_IsEnterpriseReadyReturns{}
	if err := g.client.Call("Plugin.IsEnterpriseReady", _args, _returns); err != nil {
		log.Printf("RPC call to IsEnterpriseReady API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) IsEnterpriseReady(args *Z_IsEnterpriseReadyArgs, returns *Z_IsEnterpriseReadyReturns) error {
	if hook, ok := s.impl.(interface {
		IsEnterpriseReady() bool
	}); ok {
		returns.A = hook.IsEnterpriseReady()
	} else {
		return encodableError(fmt.Errorf("API IsEnterpriseReady called but not implemented."))
	}
	return nil
}

type Z_GetServerVersionArgs struct {
}

type Z_GetServerVersionReturns struct {
	A string
}

func (g *apiRPCClient) GetServerVersion() string {
	_args := &Z_GetServerVersionArgs{}
	_returns := &Z_GetServerVersionReturns{}
	if err := g.client.Call("Plugin.GetServerVersion", _args, _returns); err != nil {
		log.Printf("RPC call to GetServerVersion API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetServerVersion(args *Z_GetServerVersionArgs, returns *Z_GetServerVersionReturns) error {
	if hook, ok := s.impl.(interface {
		GetServerVersion() string
	}); ok {
		returns.A = hook.GetServerVersion()
	} else {
		return encodableError(fmt.Errorf("API GetServerVersion called but not implemented."))
	}
	return nil
}

type Z_GetSystemInstallDateArgs struct {
}

type Z_GetSystemInstallDateReturns struct {
	A int64
	B *model.AppError
}

func (g *apiRPCClient) GetSystemInstallDate() (int64, *model.AppError) {
	_args := &Z_GetSystemInstallDateArgs{}
	_returns := &Z_GetSystemInstallDateReturns{}
	if err := g.client.Call("Plugin.GetSystemInstallDate", _args, _returns); err != nil {
		log.Printf("RPC call to GetSystemInstallDate API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetSystemInstallDate(args *Z_GetSystemInstallDateArgs, returns *Z_GetSystemInstallDateReturns) error {
	if hook, ok := s.impl.(interface {
		GetSystemInstallDate() (int64, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetSystemInstallDate()
	} else {
		return encodableError(fmt.Errorf("API GetSystemInstallDate called but not implemented."))
	}
	return nil
}

type Z_GetDiagnosticIdArgs struct {
}

type Z_GetDiagnosticIdReturns struct {
	A string
}

func (g *apiRPCClient) GetDiagnosticId() string {
	_args := &Z_GetDiagnosticIdArgs{}
	_returns := &Z_GetDiagnosticIdReturns{}
	if err := g.client.Call("Plugin.GetDiagnosticId", _args, _returns); err != nil {
		log.Printf("RPC call to GetDiagnosticId API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetDiagnosticId(args *Z_GetDiagnosticIdArgs, returns *Z_GetDiagnosticIdReturns) error {
	if hook, ok := s.impl.(interface {
		GetDiagnosticId() string
	}); ok {
		returns.A = hook.GetDiagnosticId()
	} else {
		return encodableError(fmt.Errorf("API GetDiagnosticId called but not implemented."))
	}
	return nil
}

type Z_GetTelemetryIdArgs struct {
}

type Z_GetTelemetryIdReturns struct {
	A string
}

func (g *apiRPCClient) GetTelemetryId() string {
	_args := &Z_GetTelemetryIdArgs{}
	_returns := &Z_GetTelemetryIdReturns{}
	if err := g.client.Call("Plugin.GetTelemetryId", _args, _returns); err != nil {
		log.Printf("RPC call to GetTelemetryId API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) GetTelemetryId(args *Z_GetTelemetryIdArgs, returns *Z_GetTelemetryIdReturns) error {
	if hook, ok := s.impl.(interface {
		GetTelemetryId() string
	}); ok {
		returns.A = hook.GetTelemetryId()
	} else {
		return encodableError(fmt.Errorf("API GetTelemetryId called but not implemented."))
	}
	return nil
}

type Z_CreateUserArgs struct {
	A *model.User
}

type Z_CreateUserReturns struct {
	A *model.User
	B *model.AppError
}

func (g *apiRPCClient) CreateUser(user *model.User) (*model.User, *model.AppError) {
	_args := &Z_CreateUserArgs{user}
	_returns := &Z_CreateUserReturns{}
	if err := g.client.Call("Plugin.CreateUser", _args, _returns); err != nil {
		log.Printf("RPC call to CreateUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateUser(args *Z_CreateUserArgs, returns *Z_CreateUserReturns) error {
	if hook, ok := s.impl.(interface {
		CreateUser(user *model.User) (*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateUser called but not implemented."))
	}
	return nil
}

type Z_DeleteUserArgs struct {
	A string
}

type Z_DeleteUserReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeleteUser(userID string) *model.AppError {
	_args := &Z_DeleteUserArgs{userID}
	_returns := &Z_DeleteUserReturns{}
	if err := g.client.Call("Plugin.DeleteUser", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteUser API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteUser(args *Z_DeleteUserArgs, returns *Z_DeleteUserReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteUser(userID string) *model.AppError
	}); ok {
		returns.A = hook.DeleteUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API DeleteUser called but not implemented."))
	}
	return nil
}

type Z_GetUsersArgs struct {
	A *model.UserGetOptions
}

type Z_GetUsersReturns struct {
	A []*model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	_args := &Z_GetUsersArgs{options}
	_returns := &Z_GetUsersReturns{}
	if err := g.client.Call("Plugin.GetUsers", _args, _returns); err != nil {
		log.Printf("RPC call to GetUsers API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUsers(args *Z_GetUsersArgs, returns *Z_GetUsersReturns) error {
	if hook, ok := s.impl.(interface {
		GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUsers(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUsers called but not implemented."))
	}
	return nil
}

type Z_GetUserArgs struct {
	A string
}

type Z_GetUserReturns struct {
	A *model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUser(userID string) (*model.User, *model.AppError) {
	_args := &Z_GetUserArgs{userID}
	_returns := &Z_GetUserReturns{}
	if err := g.client.Call("Plugin.GetUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUser(args *Z_GetUserArgs, returns *Z_GetUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetUser(userID string) (*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUser called but not implemented."))
	}
	return nil
}

type Z_GetUserByEmailArgs struct {
	A string
}

type Z_GetUserByEmailReturns struct {
	A *model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUserByEmail(email string) (*model.User, *model.AppError) {
	_args := &Z_GetUserByEmailArgs{email}
	_returns := &Z_GetUserByEmailReturns{}
	if err := g.client.Call("Plugin.GetUserByEmail", _args, _returns); err != nil {
		log.Printf("RPC call to GetUserByEmail API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUserByEmail(args *Z_GetUserByEmailArgs, returns *Z_GetUserByEmailReturns) error {
	if hook, ok := s.impl.(interface {
		GetUserByEmail(email string) (*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUserByEmail(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUserByEmail called but not implemented."))
	}
	return nil
}

type Z_GetUserByUsernameArgs struct {
	A string
}

type Z_GetUserByUsernameReturns struct {
	A *model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUserByUsername(name string) (*model.User, *model.AppError) {
	_args := &Z_GetUserByUsernameArgs{name}
	_returns := &Z_GetUserByUsernameReturns{}
	if err := g.client.Call("Plugin.GetUserByUsername", _args, _returns); err != nil {
		log.Printf("RPC call to GetUserByUsername API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUserByUsername(args *Z_GetUserByUsernameArgs, returns *Z_GetUserByUsernameReturns) error {
	if hook, ok := s.impl.(interface {
		GetUserByUsername(name string) (*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUserByUsername(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUserByUsername called but not implemented."))
	}
	return nil
}

type Z_GetUsersByUsernamesArgs struct {
	A []string
}

type Z_GetUsersByUsernamesReturns struct {
	A []*model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUsersByUsernames(usernames []string) ([]*model.User, *model.AppError) {
	_args := &Z_GetUsersByUsernamesArgs{usernames}
	_returns := &Z_GetUsersByUsernamesReturns{}
	if err := g.client.Call("Plugin.GetUsersByUsernames", _args, _returns); err != nil {
		log.Printf("RPC call to GetUsersByUsernames API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUsersByUsernames(args *Z_GetUsersByUsernamesArgs, returns *Z_GetUsersByUsernamesReturns) error {
	if hook, ok := s.impl.(interface {
		GetUsersByUsernames(usernames []string) ([]*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUsersByUsernames(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUsersByUsernames called but not implemented."))
	}
	return nil
}

type Z_GetUsersInTeamArgs struct {
	A string
	B int
	C int
}

type Z_GetUsersInTeamReturns struct {
	A []*model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUsersInTeam(teamID string, page int, perPage int) ([]*model.User, *model.AppError) {
	_args := &Z_GetUsersInTeamArgs{teamID, page, perPage}
	_returns := &Z_GetUsersInTeamReturns{}
	if err := g.client.Call("Plugin.GetUsersInTeam", _args, _returns); err != nil {
		log.Printf("RPC call to GetUsersInTeam API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUsersInTeam(args *Z_GetUsersInTeamArgs, returns *Z_GetUsersInTeamReturns) error {
	if hook, ok := s.impl.(interface {
		GetUsersInTeam(teamID string, page int, perPage int) ([]*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUsersInTeam(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetUsersInTeam called but not implemented."))
	}
	return nil
}

type Z_GetPreferencesForUserArgs struct {
	A string
}

type Z_GetPreferencesForUserReturns struct {
	A []model.Preference
	B *model.AppError
}

func (g *apiRPCClient) GetPreferencesForUser(userID string) ([]model.Preference, *model.AppError) {
	_args := &Z_GetPreferencesForUserArgs{userID}
	_returns := &Z_GetPreferencesForUserReturns{}
	if err := g.client.Call("Plugin.GetPreferencesForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetPreferencesForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPreferencesForUser(args *Z_GetPreferencesForUserArgs, returns *Z_GetPreferencesForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetPreferencesForUser(userID string) ([]model.Preference, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPreferencesForUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetPreferencesForUser called but not implemented."))
	}
	return nil
}

type Z_UpdatePreferencesForUserArgs struct {
	A string
	B []model.Preference
}

type Z_UpdatePreferencesForUserReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) UpdatePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	_args := &Z_UpdatePreferencesForUserArgs{userID, preferences}
	_returns := &Z_UpdatePreferencesForUserReturns{}
	if err := g.client.Call("Plugin.UpdatePreferencesForUser", _args, _returns); err != nil {
		log.Printf("RPC call to UpdatePreferencesForUser API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) UpdatePreferencesForUser(args *Z_UpdatePreferencesForUserArgs, returns *Z_UpdatePreferencesForUserReturns) error {
	if hook, ok := s.impl.(interface {
		UpdatePreferencesForUser(userID string, preferences []model.Preference) *model.AppError
	}); ok {
		returns.A = hook.UpdatePreferencesForUser(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API UpdatePreferencesForUser called but not implemented."))
	}
	return nil
}

type Z_DeletePreferencesForUserArgs struct {
	A string
	B []model.Preference
}

type Z_DeletePreferencesForUserReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeletePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	_args := &Z_DeletePreferencesForUserArgs{userID, preferences}
	_returns := &Z_DeletePreferencesForUserReturns{}
	if err := g.client.Call("Plugin.DeletePreferencesForUser", _args, _returns); err != nil {
		log.Printf("RPC call to DeletePreferencesForUser API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeletePreferencesForUser(args *Z_DeletePreferencesForUserArgs, returns *Z_DeletePreferencesForUserReturns) error {
	if hook, ok := s.impl.(interface {
		DeletePreferencesForUser(userID string, preferences []model.Preference) *model.AppError
	}); ok {
		returns.A = hook.DeletePreferencesForUser(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API DeletePreferencesForUser called but not implemented."))
	}
	return nil
}

type Z_GetSessionArgs struct {
	A string
}

type Z_GetSessionReturns struct {
	A *model.Session
	B *model.AppError
}

func (g *apiRPCClient) GetSession(sessionID string) (*model.Session, *model.AppError) {
	_args := &Z_GetSessionArgs{sessionID}
	_returns := &Z_GetSessionReturns{}
	if err := g.client.Call("Plugin.GetSession", _args, _returns); err != nil {
		log.Printf("RPC call to GetSession API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetSession(args *Z_GetSessionArgs, returns *Z_GetSessionReturns) error {
	if hook, ok := s.impl.(interface {
		GetSession(sessionID string) (*model.Session, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetSession(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetSession called but not implemented."))
	}
	return nil
}

type Z_CreateSessionArgs struct {
	A *model.Session
}

type Z_CreateSessionReturns struct {
	A *model.Session
	B *model.AppError
}

func (g *apiRPCClient) CreateSession(session *model.Session) (*model.Session, *model.AppError) {
	_args := &Z_CreateSessionArgs{session}
	_returns := &Z_CreateSessionReturns{}
	if err := g.client.Call("Plugin.CreateSession", _args, _returns); err != nil {
		log.Printf("RPC call to CreateSession API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateSession(args *Z_CreateSessionArgs, returns *Z_CreateSessionReturns) error {
	if hook, ok := s.impl.(interface {
		CreateSession(session *model.Session) (*model.Session, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateSession(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateSession called but not implemented."))
	}
	return nil
}

type Z_ExtendSessionExpiryArgs struct {
	A string
	B int64
}

type Z_ExtendSessionExpiryReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) ExtendSessionExpiry(sessionID string, newExpiry int64) *model.AppError {
	_args := &Z_ExtendSessionExpiryArgs{sessionID, newExpiry}
	_returns := &Z_ExtendSessionExpiryReturns{}
	if err := g.client.Call("Plugin.ExtendSessionExpiry", _args, _returns); err != nil {
		log.Printf("RPC call to ExtendSessionExpiry API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) ExtendSessionExpiry(args *Z_ExtendSessionExpiryArgs, returns *Z_ExtendSessionExpiryReturns) error {
	if hook, ok := s.impl.(interface {
		ExtendSessionExpiry(sessionID string, newExpiry int64) *model.AppError
	}); ok {
		returns.A = hook.ExtendSessionExpiry(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API ExtendSessionExpiry called but not implemented."))
	}
	return nil
}

type Z_RevokeSessionArgs struct {
	A string
}

type Z_RevokeSessionReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RevokeSession(sessionID string) *model.AppError {
	_args := &Z_RevokeSessionArgs{sessionID}
	_returns := &Z_RevokeSessionReturns{}
	if err := g.client.Call("Plugin.RevokeSession", _args, _returns); err != nil {
		log.Printf("RPC call to RevokeSession API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RevokeSession(args *Z_RevokeSessionArgs, returns *Z_RevokeSessionReturns) error {
	if hook, ok := s.impl.(interface {
		RevokeSession(sessionID string) *model.AppError
	}); ok {
		returns.A = hook.RevokeSession(args.A)
	} else {
		return encodableError(fmt.Errorf("API RevokeSession called but not implemented."))
	}
	return nil
}

type Z_CreateUserAccessTokenArgs struct {
	A *model.UserAccessToken
}

type Z_CreateUserAccessTokenReturns struct {
	A *model.UserAccessToken
	B *model.AppError
}

func (g *apiRPCClient) CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError) {
	_args := &Z_CreateUserAccessTokenArgs{token}
	_returns := &Z_CreateUserAccessTokenReturns{}
	if err := g.client.Call("Plugin.CreateUserAccessToken", _args, _returns); err != nil {
		log.Printf("RPC call to CreateUserAccessToken API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateUserAccessToken(args *Z_CreateUserAccessTokenArgs, returns *Z_CreateUserAccessTokenReturns) error {
	if hook, ok := s.impl.(interface {
		CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateUserAccessToken(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateUserAccessToken called but not implemented."))
	}
	return nil
}

type Z_RevokeUserAccessTokenArgs struct {
	A string
}

type Z_RevokeUserAccessTokenReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RevokeUserAccessToken(tokenID string) *model.AppError {
	_args := &Z_RevokeUserAccessTokenArgs{tokenID}
	_returns := &Z_RevokeUserAccessTokenReturns{}
	if err := g.client.Call("Plugin.RevokeUserAccessToken", _args, _returns); err != nil {
		log.Printf("RPC call to RevokeUserAccessToken API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RevokeUserAccessToken(args *Z_RevokeUserAccessTokenArgs, returns *Z_RevokeUserAccessTokenReturns) error {
	if hook, ok := s.impl.(interface {
		RevokeUserAccessToken(tokenID string) *model.AppError
	}); ok {
		returns.A = hook.RevokeUserAccessToken(args.A)
	} else {
		return encodableError(fmt.Errorf("API RevokeUserAccessToken called but not implemented."))
	}
	return nil
}

type Z_GetTeamIconArgs struct {
	A string
}

type Z_GetTeamIconReturns struct {
	A []byte
	B *model.AppError
}

func (g *apiRPCClient) GetTeamIcon(teamID string) ([]byte, *model.AppError) {
	_args := &Z_GetTeamIconArgs{teamID}
	_returns := &Z_GetTeamIconReturns{}
	if err := g.client.Call("Plugin.GetTeamIcon", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamIcon API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamIcon(args *Z_GetTeamIconArgs, returns *Z_GetTeamIconReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamIcon(teamID string) ([]byte, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamIcon(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetTeamIcon called but not implemented."))
	}
	return nil
}

type Z_SetTeamIconArgs struct {
	A string
	B []byte
}

type Z_SetTeamIconReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) SetTeamIcon(teamID string, data []byte) *model.AppError {
	_args := &Z_SetTeamIconArgs{teamID, data}
	_returns := &Z_SetTeamIconReturns{}
	if err := g.client.Call("Plugin.SetTeamIcon", _args, _returns); err != nil {
		log.Printf("RPC call to SetTeamIcon API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) SetTeamIcon(args *Z_SetTeamIconArgs, returns *Z_SetTeamIconReturns) error {
	if hook, ok := s.impl.(interface {
		SetTeamIcon(teamID string, data []byte) *model.AppError
	}); ok {
		returns.A = hook.SetTeamIcon(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API SetTeamIcon called but not implemented."))
	}
	return nil
}

type Z_RemoveTeamIconArgs struct {
	A string
}

type Z_RemoveTeamIconReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RemoveTeamIcon(teamID string) *model.AppError {
	_args := &Z_RemoveTeamIconArgs{teamID}
	_returns := &Z_RemoveTeamIconReturns{}
	if err := g.client.Call("Plugin.RemoveTeamIcon", _args, _returns); err != nil {
		log.Printf("RPC call to RemoveTeamIcon API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RemoveTeamIcon(args *Z_RemoveTeamIconArgs, returns *Z_RemoveTeamIconReturns) error {
	if hook, ok := s.impl.(interface {
		RemoveTeamIcon(teamID string) *model.AppError
	}); ok {
		returns.A = hook.RemoveTeamIcon(args.A)
	} else {
		return encodableError(fmt.Errorf("API RemoveTeamIcon called but not implemented."))
	}
	return nil
}

type Z_UpdateUserArgs struct {
	A *model.User
}

type Z_UpdateUserReturns struct {
	A *model.User
	B *model.AppError
}

func (g *apiRPCClient) UpdateUser(user *model.User) (*model.User, *model.AppError) {
	_args := &Z_UpdateUserArgs{user}
	_returns := &Z_UpdateUserReturns{}
	if err := g.client.Call("Plugin.UpdateUser", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateUser(args *Z_UpdateUserArgs, returns *Z_UpdateUserReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateUser(user *model.User) (*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API UpdateUser called but not implemented."))
	}
	return nil
}

type Z_GetUserStatusArgs struct {
	A string
}

type Z_GetUserStatusReturns struct {
	A *model.Status
	B *model.AppError
}

func (g *apiRPCClient) GetUserStatus(userID string) (*model.Status, *model.AppError) {
	_args := &Z_GetUserStatusArgs{userID}
	_returns := &Z_GetUserStatusReturns{}
	if err := g.client.Call("Plugin.GetUserStatus", _args, _returns); err != nil {
		log.Printf("RPC call to GetUserStatus API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUserStatus(args *Z_GetUserStatusArgs, returns *Z_GetUserStatusReturns) error {
	if hook, ok := s.impl.(interface {
		GetUserStatus(userID string) (*model.Status, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUserStatus(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUserStatus called but not implemented."))
	}
	return nil
}

type Z_GetUserStatusesByIdsArgs struct {
	A []string
}

type Z_GetUserStatusesByIdsReturns struct {
	A []*model.Status
	B *model.AppError
}

func (g *apiRPCClient) GetUserStatusesByIds(userIds []string) ([]*model.Status, *model.AppError) {
	_args := &Z_GetUserStatusesByIdsArgs{userIds}
	_returns := &Z_GetUserStatusesByIdsReturns{}
	if err := g.client.Call("Plugin.GetUserStatusesByIds", _args, _returns); err != nil {
		log.Printf("RPC call to GetUserStatusesByIds API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUserStatusesByIds(args *Z_GetUserStatusesByIdsArgs, returns *Z_GetUserStatusesByIdsReturns) error {
	if hook, ok := s.impl.(interface {
		GetUserStatusesByIds(userIds []string) ([]*model.Status, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUserStatusesByIds(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetUserStatusesByIds called but not implemented."))
	}
	return nil
}

type Z_UpdateUserStatusArgs struct {
	A string
	B string
}

type Z_UpdateUserStatusReturns struct {
	A *model.Status
	B *model.AppError
}

func (g *apiRPCClient) UpdateUserStatus(userID, status string) (*model.Status, *model.AppError) {
	_args := &Z_UpdateUserStatusArgs{userID, status}
	_returns := &Z_UpdateUserStatusReturns{}
	if err := g.client.Call("Plugin.UpdateUserStatus", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateUserStatus API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateUserStatus(args *Z_UpdateUserStatusArgs, returns *Z_UpdateUserStatusReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateUserStatus(userID, status string) (*model.Status, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateUserStatus(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API UpdateUserStatus called but not implemented."))
	}
	return nil
}

type Z_SetUserStatusTimedDNDArgs struct {
	A string
	B int64
}

type Z_SetUserStatusTimedDNDReturns struct {
	A *model.Status
	B *model.AppError
}

func (g *apiRPCClient) SetUserStatusTimedDND(userId string, endtime int64) (*model.Status, *model.AppError) {
	_args := &Z_SetUserStatusTimedDNDArgs{userId, endtime}
	_returns := &Z_SetUserStatusTimedDNDReturns{}
	if err := g.client.Call("Plugin.SetUserStatusTimedDND", _args, _returns); err != nil {
		log.Printf("RPC call to SetUserStatusTimedDND API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) SetUserStatusTimedDND(args *Z_SetUserStatusTimedDNDArgs, returns *Z_SetUserStatusTimedDNDReturns) error {
	if hook, ok := s.impl.(interface {
		SetUserStatusTimedDND(userId string, endtime int64) (*model.Status, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.SetUserStatusTimedDND(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API SetUserStatusTimedDND called but not implemented."))
	}
	return nil
}

type Z_UpdateUserActiveArgs struct {
	A string
	B bool
}

type Z_UpdateUserActiveReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) UpdateUserActive(userID string, active bool) *model.AppError {
	_args := &Z_UpdateUserActiveArgs{userID, active}
	_returns := &Z_UpdateUserActiveReturns{}
	if err := g.client.Call("Plugin.UpdateUserActive", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateUserActive API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) UpdateUserActive(args *Z_UpdateUserActiveArgs, returns *Z_UpdateUserActiveReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateUserActive(userID string, active bool) *model.AppError
	}); ok {
		returns.A = hook.UpdateUserActive(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API UpdateUserActive called but not implemented."))
	}
	return nil
}

type Z_UpdateUserCustomStatusArgs struct {
	A string
	B *model.CustomStatus
}

type Z_UpdateUserCustomStatusReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) UpdateUserCustomStatus(userID string, customStatus *model.CustomStatus) *model.AppError {
	_args := &Z_UpdateUserCustomStatusArgs{userID, customStatus}
	_returns := &Z_UpdateUserCustomStatusReturns{}
	if err := g.client.Call("Plugin.UpdateUserCustomStatus", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateUserCustomStatus API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) UpdateUserCustomStatus(args *Z_UpdateUserCustomStatusArgs, returns *Z_UpdateUserCustomStatusReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateUserCustomStatus(userID string, customStatus *model.CustomStatus) *model.AppError
	}); ok {
		returns.A = hook.UpdateUserCustomStatus(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API UpdateUserCustomStatus called but not implemented."))
	}
	return nil
}

type Z_RemoveUserCustomStatusArgs struct {
	A string
}

type Z_RemoveUserCustomStatusReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RemoveUserCustomStatus(userID string) *model.AppError {
	_args := &Z_RemoveUserCustomStatusArgs{userID}
	_returns := &Z_RemoveUserCustomStatusReturns{}
	if err := g.client.Call("Plugin.RemoveUserCustomStatus", _args, _returns); err != nil {
		log.Printf("RPC call to RemoveUserCustomStatus API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RemoveUserCustomStatus(args *Z_RemoveUserCustomStatusArgs, returns *Z_RemoveUserCustomStatusReturns) error {
	if hook, ok := s.impl.(interface {
		RemoveUserCustomStatus(userID string) *model.AppError
	}); ok {
		returns.A = hook.RemoveUserCustomStatus(args.A)
	} else {
		return encodableError(fmt.Errorf("API RemoveUserCustomStatus called but not implemented."))
	}
	return nil
}

type Z_GetUsersInChannelArgs struct {
	A string
	B string
	C int
	D int
}

type Z_GetUsersInChannelReturns struct {
	A []*model.User
	B *model.AppError
}

func (g *apiRPCClient) GetUsersInChannel(channelID, sortBy string, page, perPage int) ([]*model.User, *model.AppError) {
	_args := &Z_GetUsersInChannelArgs{channelID, sortBy, page, perPage}
	_returns := &Z_GetUsersInChannelReturns{}
	if err := g.client.Call("Plugin.GetUsersInChannel", _args, _returns); err != nil {
		log.Printf("RPC call to GetUsersInChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetUsersInChannel(args *Z_GetUsersInChannelArgs, returns *Z_GetUsersInChannelReturns) error {
	if hook, ok := s.impl.(interface {
		GetUsersInChannel(channelID, sortBy string, page, perPage int) ([]*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetUsersInChannel(args.A, args.B, args.C, args.D)
	} else {
		return encodableError(fmt.Errorf("API GetUsersInChannel called but not implemented."))
	}
	return nil
}

type Z_GetLDAPUserAttributesArgs struct {
	A string
	B []string
}

type Z_GetLDAPUserAttributesReturns struct {
	A map[string]string
	B *model.AppError
}

func (g *apiRPCClient) GetLDAPUserAttributes(userID string, attributes []string) (map[string]string, *model.AppError) {
	_args := &Z_GetLDAPUserAttributesArgs{userID, attributes}
	_returns := &Z_GetLDAPUserAttributesReturns{}
	if err := g.client.Call("Plugin.GetLDAPUserAttributes", _args, _returns); err != nil {
		log.Printf("RPC call to GetLDAPUserAttributes API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetLDAPUserAttributes(args *Z_GetLDAPUserAttributesArgs, returns *Z_GetLDAPUserAttributesReturns) error {
	if hook, ok := s.impl.(interface {
		GetLDAPUserAttributes(userID string, attributes []string) (map[string]string, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetLDAPUserAttributes(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetLDAPUserAttributes called but not implemented."))
	}
	return nil
}

type Z_CreateTeamArgs struct {
	A *model.Team
}

type Z_CreateTeamReturns struct {
	A *model.Team
	B *model.AppError
}

func (g *apiRPCClient) CreateTeam(team *model.Team) (*model.Team, *model.AppError) {
	_args := &Z_CreateTeamArgs{team}
	_returns := &Z_CreateTeamReturns{}
	if err := g.client.Call("Plugin.CreateTeam", _args, _returns); err != nil {
		log.Printf("RPC call to CreateTeam API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateTeam(args *Z_CreateTeamArgs, returns *Z_CreateTeamReturns) error {
	if hook, ok := s.impl.(interface {
		CreateTeam(team *model.Team) (*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateTeam(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateTeam called but not implemented."))
	}
	return nil
}

type Z_DeleteTeamArgs struct {
	A string
}

type Z_DeleteTeamReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeleteTeam(teamID string) *model.AppError {
	_args := &Z_DeleteTeamArgs{teamID}
	_returns := &Z_DeleteTeamReturns{}
	if err := g.client.Call("Plugin.DeleteTeam", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteTeam API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteTeam(args *Z_DeleteTeamArgs, returns *Z_DeleteTeamReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteTeam(teamID string) *model.AppError
	}); ok {
		returns.A = hook.DeleteTeam(args.A)
	} else {
		return encodableError(fmt.Errorf("API DeleteTeam called but not implemented."))
	}
	return nil
}

type Z_GetTeamsArgs struct {
}

type Z_GetTeamsReturns struct {
	A []*model.Team
	B *model.AppError
}

func (g *apiRPCClient) GetTeams() ([]*model.Team, *model.AppError) {
	_args := &Z_GetTeamsArgs{}
	_returns := &Z_GetTeamsReturns{}
	if err := g.client.Call("Plugin.GetTeams", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeams API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeams(args *Z_GetTeamsArgs, returns *Z_GetTeamsReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeams() ([]*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeams()
	} else {
		return encodableError(fmt.Errorf("API GetTeams called but not implemented."))
	}
	return nil
}

type Z_GetTeamArgs struct {
	A string
}

type Z_GetTeamReturns struct {
	A *model.Team
	B *model.AppError
}

func (g *apiRPCClient) GetTeam(teamID string) (*model.Team, *model.AppError) {
	_args := &Z_GetTeamArgs{teamID}
	_returns := &Z_GetTeamReturns{}
	if err := g.client.Call("Plugin.GetTeam", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeam API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeam(args *Z_GetTeamArgs, returns *Z_GetTeamReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeam(teamID string) (*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeam(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetTeam called but not implemented."))
	}
	return nil
}

type Z_GetTeamByNameArgs struct {
	A string
}

type Z_GetTeamByNameReturns struct {
	A *model.Team
	B *model.AppError
}

func (g *apiRPCClient) GetTeamByName(name string) (*model.Team, *model.AppError) {
	_args := &Z_GetTeamByNameArgs{name}
	_returns := &Z_GetTeamByNameReturns{}
	if err := g.client.Call("Plugin.GetTeamByName", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamByName API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamByName(args *Z_GetTeamByNameArgs, returns *Z_GetTeamByNameReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamByName(name string) (*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamByName(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetTeamByName called but not implemented."))
	}
	return nil
}

type Z_GetTeamsUnreadForUserArgs struct {
	A string
}

type Z_GetTeamsUnreadForUserReturns struct {
	A []*model.TeamUnread
	B *model.AppError
}

func (g *apiRPCClient) GetTeamsUnreadForUser(userID string) ([]*model.TeamUnread, *model.AppError) {
	_args := &Z_GetTeamsUnreadForUserArgs{userID}
	_returns := &Z_GetTeamsUnreadForUserReturns{}
	if err := g.client.Call("Plugin.GetTeamsUnreadForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamsUnreadForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamsUnreadForUser(args *Z_GetTeamsUnreadForUserArgs, returns *Z_GetTeamsUnreadForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamsUnreadForUser(userID string) ([]*model.TeamUnread, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamsUnreadForUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetTeamsUnreadForUser called but not implemented."))
	}
	return nil
}

type Z_UpdateTeamArgs struct {
	A *model.Team
}

type Z_UpdateTeamReturns struct {
	A *model.Team
	B *model.AppError
}

func (g *apiRPCClient) UpdateTeam(team *model.Team) (*model.Team, *model.AppError) {
	_args := &Z_UpdateTeamArgs{team}
	_returns := &Z_UpdateTeamReturns{}
	if err := g.client.Call("Plugin.UpdateTeam", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateTeam API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateTeam(args *Z_UpdateTeamArgs, returns *Z_UpdateTeamReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateTeam(team *model.Team) (*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateTeam(args.A)
	} else {
		return encodableError(fmt.Errorf("API UpdateTeam called but not implemented."))
	}
	return nil
}

type Z_SearchTeamsArgs struct {
	A string
}

type Z_SearchTeamsReturns struct {
	A []*model.Team
	B *model.AppError
}

func (g *apiRPCClient) SearchTeams(term string) ([]*model.Team, *model.AppError) {
	_args := &Z_SearchTeamsArgs{term}
	_returns := &Z_SearchTeamsReturns{}
	if err := g.client.Call("Plugin.SearchTeams", _args, _returns); err != nil {
		log.Printf("RPC call to SearchTeams API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) SearchTeams(args *Z_SearchTeamsArgs, returns *Z_SearchTeamsReturns) error {
	if hook, ok := s.impl.(interface {
		SearchTeams(term string) ([]*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.SearchTeams(args.A)
	} else {
		return encodableError(fmt.Errorf("API SearchTeams called but not implemented."))
	}
	return nil
}

type Z_GetTeamsForUserArgs struct {
	A string
}

type Z_GetTeamsForUserReturns struct {
	A []*model.Team
	B *model.AppError
}

func (g *apiRPCClient) GetTeamsForUser(userID string) ([]*model.Team, *model.AppError) {
	_args := &Z_GetTeamsForUserArgs{userID}
	_returns := &Z_GetTeamsForUserReturns{}
	if err := g.client.Call("Plugin.GetTeamsForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamsForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamsForUser(args *Z_GetTeamsForUserArgs, returns *Z_GetTeamsForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamsForUser(userID string) ([]*model.Team, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamsForUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetTeamsForUser called but not implemented."))
	}
	return nil
}

type Z_CreateTeamMemberArgs struct {
	A string
	B string
}

type Z_CreateTeamMemberReturns struct {
	A *model.TeamMember
	B *model.AppError
}

func (g *apiRPCClient) CreateTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError) {
	_args := &Z_CreateTeamMemberArgs{teamID, userID}
	_returns := &Z_CreateTeamMemberReturns{}
	if err := g.client.Call("Plugin.CreateTeamMember", _args, _returns); err != nil {
		log.Printf("RPC call to CreateTeamMember API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateTeamMember(args *Z_CreateTeamMemberArgs, returns *Z_CreateTeamMemberReturns) error {
	if hook, ok := s.impl.(interface {
		CreateTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateTeamMember(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API CreateTeamMember called but not implemented."))
	}
	return nil
}

type Z_CreateTeamMembersArgs struct {
	A string
	B []string
	C string
}

type Z_CreateTeamMembersReturns struct {
	A []*model.TeamMember
	B *model.AppError
}

func (g *apiRPCClient) CreateTeamMembers(teamID string, userIds []string, requestorId string) ([]*model.TeamMember, *model.AppError) {
	_args := &Z_CreateTeamMembersArgs{teamID, userIds, requestorId}
	_returns := &Z_CreateTeamMembersReturns{}
	if err := g.client.Call("Plugin.CreateTeamMembers", _args, _returns); err != nil {
		log.Printf("RPC call to CreateTeamMembers API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateTeamMembers(args *Z_CreateTeamMembersArgs, returns *Z_CreateTeamMembersReturns) error {
	if hook, ok := s.impl.(interface {
		CreateTeamMembers(teamID string, userIds []string, requestorId string) ([]*model.TeamMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateTeamMembers(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API CreateTeamMembers called but not implemented."))
	}
	return nil
}

type Z_CreateTeamMembersGracefullyArgs struct {
	A string
	B []string
	C string
}

type Z_CreateTeamMembersGracefullyReturns struct {
	A []*model.TeamMemberWithError
	B *model.AppError
}

func (g *apiRPCClient) CreateTeamMembersGracefully(teamID string, userIds []string, requestorId string) ([]*model.TeamMemberWithError, *model.AppError) {
	_args := &Z_CreateTeamMembersGracefullyArgs{teamID, userIds, requestorId}
	_returns := &Z_CreateTeamMembersGracefullyReturns{}
	if err := g.client.Call("Plugin.CreateTeamMembersGracefully", _args, _returns); err != nil {
		log.Printf("RPC call to CreateTeamMembersGracefully API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateTeamMembersGracefully(args *Z_CreateTeamMembersGracefullyArgs, returns *Z_CreateTeamMembersGracefullyReturns) error {
	if hook, ok := s.impl.(interface {
		CreateTeamMembersGracefully(teamID string, userIds []string, requestorId string) ([]*model.TeamMemberWithError, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateTeamMembersGracefully(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API CreateTeamMembersGracefully called but not implemented."))
	}
	return nil
}

type Z_DeleteTeamMemberArgs struct {
	A string
	B string
	C string
}

type Z_DeleteTeamMemberReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeleteTeamMember(teamID, userID, requestorId string) *model.AppError {
	_args := &Z_DeleteTeamMemberArgs{teamID, userID, requestorId}
	_returns := &Z_DeleteTeamMemberReturns{}
	if err := g.client.Call("Plugin.DeleteTeamMember", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteTeamMember API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteTeamMember(args *Z_DeleteTeamMemberArgs, returns *Z_DeleteTeamMemberReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteTeamMember(teamID, userID, requestorId string) *model.AppError
	}); ok {
		returns.A = hook.DeleteTeamMember(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API DeleteTeamMember called but not implemented."))
	}
	return nil
}

type Z_GetTeamMembersArgs struct {
	A string
	B int
	C int
}

type Z_GetTeamMembersReturns struct {
	A []*model.TeamMember
	B *model.AppError
}

func (g *apiRPCClient) GetTeamMembers(teamID string, page, perPage int) ([]*model.TeamMember, *model.AppError) {
	_args := &Z_GetTeamMembersArgs{teamID, page, perPage}
	_returns := &Z_GetTeamMembersReturns{}
	if err := g.client.Call("Plugin.GetTeamMembers", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamMembers API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamMembers(args *Z_GetTeamMembersArgs, returns *Z_GetTeamMembersReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamMembers(teamID string, page, perPage int) ([]*model.TeamMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamMembers(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetTeamMembers called but not implemented."))
	}
	return nil
}

type Z_GetTeamMemberArgs struct {
	A string
	B string
}

type Z_GetTeamMemberReturns struct {
	A *model.TeamMember
	B *model.AppError
}

func (g *apiRPCClient) GetTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError) {
	_args := &Z_GetTeamMemberArgs{teamID, userID}
	_returns := &Z_GetTeamMemberReturns{}
	if err := g.client.Call("Plugin.GetTeamMember", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamMember API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamMember(args *Z_GetTeamMemberArgs, returns *Z_GetTeamMemberReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamMember(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetTeamMember called but not implemented."))
	}
	return nil
}

type Z_GetTeamMembersForUserArgs struct {
	A string
	B int
	C int
}

type Z_GetTeamMembersForUserReturns struct {
	A []*model.TeamMember
	B *model.AppError
}

func (g *apiRPCClient) GetTeamMembersForUser(userID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	_args := &Z_GetTeamMembersForUserArgs{userID, page, perPage}
	_returns := &Z_GetTeamMembersForUserReturns{}
	if err := g.client.Call("Plugin.GetTeamMembersForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamMembersForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamMembersForUser(args *Z_GetTeamMembersForUserArgs, returns *Z_GetTeamMembersForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamMembersForUser(userID string, page int, perPage int) ([]*model.TeamMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamMembersForUser(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetTeamMembersForUser called but not implemented."))
	}
	return nil
}

type Z_UpdateTeamMemberRolesArgs struct {
	A string
	B string
	C string
}

type Z_UpdateTeamMemberRolesReturns struct {
	A *model.TeamMember
	B *model.AppError
}

func (g *apiRPCClient) UpdateTeamMemberRoles(teamID, userID, newRoles string) (*model.TeamMember, *model.AppError) {
	_args := &Z_UpdateTeamMemberRolesArgs{teamID, userID, newRoles}
	_returns := &Z_UpdateTeamMemberRolesReturns{}
	if err := g.client.Call("Plugin.UpdateTeamMemberRoles", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateTeamMemberRoles API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateTeamMemberRoles(args *Z_UpdateTeamMemberRolesArgs, returns *Z_UpdateTeamMemberRolesReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateTeamMemberRoles(teamID, userID, newRoles string) (*model.TeamMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateTeamMemberRoles(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API UpdateTeamMemberRoles called but not implemented."))
	}
	return nil
}

type Z_CreateChannelArgs struct {
	A *model.Channel
}

type Z_CreateChannelReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) CreateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	_args := &Z_CreateChannelArgs{channel}
	_returns := &Z_CreateChannelReturns{}
	if err := g.client.Call("Plugin.CreateChannel", _args, _returns); err != nil {
		log.Printf("RPC call to CreateChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateChannel(args *Z_CreateChannelArgs, returns *Z_CreateChannelReturns) error {
	if hook, ok := s.impl.(interface {
		CreateChannel(channel *model.Channel) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateChannel(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateChannel called but not implemented."))
	}
	return nil
}

type Z_DeleteChannelArgs struct {
	A string
}

type Z_DeleteChannelReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeleteChannel(channelId string) *model.AppError {
	_args := &Z_DeleteChannelArgs{channelId}
	_returns := &Z_DeleteChannelReturns{}
	if err := g.client.Call("Plugin.DeleteChannel", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteChannel API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteChannel(args *Z_DeleteChannelArgs, returns *Z_DeleteChannelReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteChannel(channelId string) *model.AppError
	}); ok {
		returns.A = hook.DeleteChannel(args.A)
	} else {
		return encodableError(fmt.Errorf("API DeleteChannel called but not implemented."))
	}
	return nil
}

type Z_GetPublicChannelsForTeamArgs struct {
	A string
	B int
	C int
}

type Z_GetPublicChannelsForTeamReturns struct {
	A []*model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetPublicChannelsForTeam(teamID string, page, perPage int) ([]*model.Channel, *model.AppError) {
	_args := &Z_GetPublicChannelsForTeamArgs{teamID, page, perPage}
	_returns := &Z_GetPublicChannelsForTeamReturns{}
	if err := g.client.Call("Plugin.GetPublicChannelsForTeam", _args, _returns); err != nil {
		log.Printf("RPC call to GetPublicChannelsForTeam API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPublicChannelsForTeam(args *Z_GetPublicChannelsForTeamArgs, returns *Z_GetPublicChannelsForTeamReturns) error {
	if hook, ok := s.impl.(interface {
		GetPublicChannelsForTeam(teamID string, page, perPage int) ([]*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPublicChannelsForTeam(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetPublicChannelsForTeam called but not implemented."))
	}
	return nil
}

type Z_GetChannelArgs struct {
	A string
}

type Z_GetChannelReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetChannel(channelId string) (*model.Channel, *model.AppError) {
	_args := &Z_GetChannelArgs{channelId}
	_returns := &Z_GetChannelReturns{}
	if err := g.client.Call("Plugin.GetChannel", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannel(args *Z_GetChannelArgs, returns *Z_GetChannelReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannel(channelId string) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannel(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetChannel called but not implemented."))
	}
	return nil
}

type Z_GetChannelByNameArgs struct {
	A string
	B string
	C bool
}

type Z_GetChannelByNameReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetChannelByName(teamID, name string, includeDeleted bool) (*model.Channel, *model.AppError) {
	_args := &Z_GetChannelByNameArgs{teamID, name, includeDeleted}
	_returns := &Z_GetChannelByNameReturns{}
	if err := g.client.Call("Plugin.GetChannelByName", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelByName API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelByName(args *Z_GetChannelByNameArgs, returns *Z_GetChannelByNameReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelByName(teamID, name string, includeDeleted bool) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelByName(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetChannelByName called but not implemented."))
	}
	return nil
}

type Z_GetChannelByNameForTeamNameArgs struct {
	A string
	B string
	C bool
}

type Z_GetChannelByNameForTeamNameReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetChannelByNameForTeamName(teamName, channelName string, includeDeleted bool) (*model.Channel, *model.AppError) {
	_args := &Z_GetChannelByNameForTeamNameArgs{teamName, channelName, includeDeleted}
	_returns := &Z_GetChannelByNameForTeamNameReturns{}
	if err := g.client.Call("Plugin.GetChannelByNameForTeamName", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelByNameForTeamName API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelByNameForTeamName(args *Z_GetChannelByNameForTeamNameArgs, returns *Z_GetChannelByNameForTeamNameReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelByNameForTeamName(teamName, channelName string, includeDeleted bool) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelByNameForTeamName(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetChannelByNameForTeamName called but not implemented."))
	}
	return nil
}

type Z_GetChannelsForTeamForUserArgs struct {
	A string
	B string
	C bool
}

type Z_GetChannelsForTeamForUserReturns struct {
	A []*model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetChannelsForTeamForUser(teamID, userID string, includeDeleted bool) ([]*model.Channel, *model.AppError) {
	_args := &Z_GetChannelsForTeamForUserArgs{teamID, userID, includeDeleted}
	_returns := &Z_GetChannelsForTeamForUserReturns{}
	if err := g.client.Call("Plugin.GetChannelsForTeamForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelsForTeamForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelsForTeamForUser(args *Z_GetChannelsForTeamForUserArgs, returns *Z_GetChannelsForTeamForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelsForTeamForUser(teamID, userID string, includeDeleted bool) ([]*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelsForTeamForUser(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetChannelsForTeamForUser called but not implemented."))
	}
	return nil
}

type Z_GetChannelStatsArgs struct {
	A string
}

type Z_GetChannelStatsReturns struct {
	A *model.ChannelStats
	B *model.AppError
}

func (g *apiRPCClient) GetChannelStats(channelId string) (*model.ChannelStats, *model.AppError) {
	_args := &Z_GetChannelStatsArgs{channelId}
	_returns := &Z_GetChannelStatsReturns{}
	if err := g.client.Call("Plugin.GetChannelStats", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelStats API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelStats(args *Z_GetChannelStatsArgs, returns *Z_GetChannelStatsReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelStats(channelId string) (*model.ChannelStats, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelStats(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetChannelStats called but not implemented."))
	}
	return nil
}

type Z_GetDirectChannelArgs struct {
	A string
	B string
}

type Z_GetDirectChannelReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetDirectChannel(userId1, userId2 string) (*model.Channel, *model.AppError) {
	_args := &Z_GetDirectChannelArgs{userId1, userId2}
	_returns := &Z_GetDirectChannelReturns{}
	if err := g.client.Call("Plugin.GetDirectChannel", _args, _returns); err != nil {
		log.Printf("RPC call to GetDirectChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetDirectChannel(args *Z_GetDirectChannelArgs, returns *Z_GetDirectChannelReturns) error {
	if hook, ok := s.impl.(interface {
		GetDirectChannel(userId1, userId2 string) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetDirectChannel(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetDirectChannel called but not implemented."))
	}
	return nil
}

type Z_GetGroupChannelArgs struct {
	A []string
}

type Z_GetGroupChannelReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) GetGroupChannel(userIds []string) (*model.Channel, *model.AppError) {
	_args := &Z_GetGroupChannelArgs{userIds}
	_returns := &Z_GetGroupChannelReturns{}
	if err := g.client.Call("Plugin.GetGroupChannel", _args, _returns); err != nil {
		log.Printf("RPC call to GetGroupChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetGroupChannel(args *Z_GetGroupChannelArgs, returns *Z_GetGroupChannelReturns) error {
	if hook, ok := s.impl.(interface {
		GetGroupChannel(userIds []string) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetGroupChannel(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetGroupChannel called but not implemented."))
	}
	return nil
}

type Z_UpdateChannelArgs struct {
	A *model.Channel
}

type Z_UpdateChannelReturns struct {
	A *model.Channel
	B *model.AppError
}

func (g *apiRPCClient) UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	_args := &Z_UpdateChannelArgs{channel}
	_returns := &Z_UpdateChannelReturns{}
	if err := g.client.Call("Plugin.UpdateChannel", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateChannel(args *Z_UpdateChannelArgs, returns *Z_UpdateChannelReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateChannel(args.A)
	} else {
		return encodableError(fmt.Errorf("API UpdateChannel called but not implemented."))
	}
	return nil
}

type Z_SearchChannelsArgs struct {
	A string
	B string
}

type Z_SearchChannelsReturns struct {
	A []*model.Channel
	B *model.AppError
}

func (g *apiRPCClient) SearchChannels(teamID string, term string) ([]*model.Channel, *model.AppError) {
	_args := &Z_SearchChannelsArgs{teamID, term}
	_returns := &Z_SearchChannelsReturns{}
	if err := g.client.Call("Plugin.SearchChannels", _args, _returns); err != nil {
		log.Printf("RPC call to SearchChannels API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) SearchChannels(args *Z_SearchChannelsArgs, returns *Z_SearchChannelsReturns) error {
	if hook, ok := s.impl.(interface {
		SearchChannels(teamID string, term string) ([]*model.Channel, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.SearchChannels(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API SearchChannels called but not implemented."))
	}
	return nil
}

type Z_CreateChannelSidebarCategoryArgs struct {
	A string
	B string
	C *model.SidebarCategoryWithChannels
}

type Z_CreateChannelSidebarCategoryReturns struct {
	A *model.SidebarCategoryWithChannels
	B *model.AppError
}

func (g *apiRPCClient) CreateChannelSidebarCategory(userID, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError) {
	_args := &Z_CreateChannelSidebarCategoryArgs{userID, teamID, newCategory}
	_returns := &Z_CreateChannelSidebarCategoryReturns{}
	if err := g.client.Call("Plugin.CreateChannelSidebarCategory", _args, _returns); err != nil {
		log.Printf("RPC call to CreateChannelSidebarCategory API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateChannelSidebarCategory(args *Z_CreateChannelSidebarCategoryArgs, returns *Z_CreateChannelSidebarCategoryReturns) error {
	if hook, ok := s.impl.(interface {
		CreateChannelSidebarCategory(userID, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateChannelSidebarCategory(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API CreateChannelSidebarCategory called but not implemented."))
	}
	return nil
}

type Z_GetChannelSidebarCategoriesArgs struct {
	A string
	B string
}

type Z_GetChannelSidebarCategoriesReturns struct {
	A *model.OrderedSidebarCategories
	B *model.AppError
}

func (g *apiRPCClient) GetChannelSidebarCategories(userID, teamID string) (*model.OrderedSidebarCategories, *model.AppError) {
	_args := &Z_GetChannelSidebarCategoriesArgs{userID, teamID}
	_returns := &Z_GetChannelSidebarCategoriesReturns{}
	if err := g.client.Call("Plugin.GetChannelSidebarCategories", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelSidebarCategories API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelSidebarCategories(args *Z_GetChannelSidebarCategoriesArgs, returns *Z_GetChannelSidebarCategoriesReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelSidebarCategories(userID, teamID string) (*model.OrderedSidebarCategories, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelSidebarCategories(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetChannelSidebarCategories called but not implemented."))
	}
	return nil
}

type Z_UpdateChannelSidebarCategoriesArgs struct {
	A string
	B string
	C []*model.SidebarCategoryWithChannels
}

type Z_UpdateChannelSidebarCategoriesReturns struct {
	A []*model.SidebarCategoryWithChannels
	B *model.AppError
}

func (g *apiRPCClient) UpdateChannelSidebarCategories(userID, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError) {
	_args := &Z_UpdateChannelSidebarCategoriesArgs{userID, teamID, categories}
	_returns := &Z_UpdateChannelSidebarCategoriesReturns{}
	if err := g.client.Call("Plugin.UpdateChannelSidebarCategories", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateChannelSidebarCategories API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateChannelSidebarCategories(args *Z_UpdateChannelSidebarCategoriesArgs, returns *Z_UpdateChannelSidebarCategoriesReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateChannelSidebarCategories(userID, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateChannelSidebarCategories(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API UpdateChannelSidebarCategories called but not implemented."))
	}
	return nil
}

type Z_SearchUsersArgs struct {
	A *model.UserSearch
}

type Z_SearchUsersReturns struct {
	A []*model.User
	B *model.AppError
}

func (g *apiRPCClient) SearchUsers(search *model.UserSearch) ([]*model.User, *model.AppError) {
	_args := &Z_SearchUsersArgs{search}
	_returns := &Z_SearchUsersReturns{}
	if err := g.client.Call("Plugin.SearchUsers", _args, _returns); err != nil {
		log.Printf("RPC call to SearchUsers API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) SearchUsers(args *Z_SearchUsersArgs, returns *Z_SearchUsersReturns) error {
	if hook, ok := s.impl.(interface {
		SearchUsers(search *model.UserSearch) ([]*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.SearchUsers(args.A)
	} else {
		return encodableError(fmt.Errorf("API SearchUsers called but not implemented."))
	}
	return nil
}

type Z_SearchPostsInTeamArgs struct {
	A string
	B []*model.SearchParams
}

type Z_SearchPostsInTeamReturns struct {
	A []*model.Post
	B *model.AppError
}

func (g *apiRPCClient) SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) ([]*model.Post, *model.AppError) {
	_args := &Z_SearchPostsInTeamArgs{teamID, paramsList}
	_returns := &Z_SearchPostsInTeamReturns{}
	if err := g.client.Call("Plugin.SearchPostsInTeam", _args, _returns); err != nil {
		log.Printf("RPC call to SearchPostsInTeam API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) SearchPostsInTeam(args *Z_SearchPostsInTeamArgs, returns *Z_SearchPostsInTeamReturns) error {
	if hook, ok := s.impl.(interface {
		SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) ([]*model.Post, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.SearchPostsInTeam(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API SearchPostsInTeam called but not implemented."))
	}
	return nil
}

type Z_SearchPostsInTeamForUserArgs struct {
	A string
	B string
	C model.SearchParameter
}

type Z_SearchPostsInTeamForUserReturns struct {
	A *model.PostSearchResults
	B *model.AppError
}

func (g *apiRPCClient) SearchPostsInTeamForUser(teamID string, userID string, searchParams model.SearchParameter) (*model.PostSearchResults, *model.AppError) {
	_args := &Z_SearchPostsInTeamForUserArgs{teamID, userID, searchParams}
	_returns := &Z_SearchPostsInTeamForUserReturns{}
	if err := g.client.Call("Plugin.SearchPostsInTeamForUser", _args, _returns); err != nil {
		log.Printf("RPC call to SearchPostsInTeamForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) SearchPostsInTeamForUser(args *Z_SearchPostsInTeamForUserArgs, returns *Z_SearchPostsInTeamForUserReturns) error {
	if hook, ok := s.impl.(interface {
		SearchPostsInTeamForUser(teamID string, userID string, searchParams model.SearchParameter) (*model.PostSearchResults, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.SearchPostsInTeamForUser(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API SearchPostsInTeamForUser called but not implemented."))
	}
	return nil
}

type Z_AddChannelMemberArgs struct {
	A string
	B string
}

type Z_AddChannelMemberReturns struct {
	A *model.ChannelMember
	B *model.AppError
}

func (g *apiRPCClient) AddChannelMember(channelId, userID string) (*model.ChannelMember, *model.AppError) {
	_args := &Z_AddChannelMemberArgs{channelId, userID}
	_returns := &Z_AddChannelMemberReturns{}
	if err := g.client.Call("Plugin.AddChannelMember", _args, _returns); err != nil {
		log.Printf("RPC call to AddChannelMember API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) AddChannelMember(args *Z_AddChannelMemberArgs, returns *Z_AddChannelMemberReturns) error {
	if hook, ok := s.impl.(interface {
		AddChannelMember(channelId, userID string) (*model.ChannelMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.AddChannelMember(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API AddChannelMember called but not implemented."))
	}
	return nil
}

type Z_AddUserToChannelArgs struct {
	A string
	B string
	C string
}

type Z_AddUserToChannelReturns struct {
	A *model.ChannelMember
	B *model.AppError
}

func (g *apiRPCClient) AddUserToChannel(channelId, userID, asUserId string) (*model.ChannelMember, *model.AppError) {
	_args := &Z_AddUserToChannelArgs{channelId, userID, asUserId}
	_returns := &Z_AddUserToChannelReturns{}
	if err := g.client.Call("Plugin.AddUserToChannel", _args, _returns); err != nil {
		log.Printf("RPC call to AddUserToChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) AddUserToChannel(args *Z_AddUserToChannelArgs, returns *Z_AddUserToChannelReturns) error {
	if hook, ok := s.impl.(interface {
		AddUserToChannel(channelId, userID, asUserId string) (*model.ChannelMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.AddUserToChannel(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API AddUserToChannel called but not implemented."))
	}
	return nil
}

type Z_GetChannelMemberArgs struct {
	A string
	B string
}

type Z_GetChannelMemberReturns struct {
	A *model.ChannelMember
	B *model.AppError
}

func (g *apiRPCClient) GetChannelMember(channelId, userID string) (*model.ChannelMember, *model.AppError) {
	_args := &Z_GetChannelMemberArgs{channelId, userID}
	_returns := &Z_GetChannelMemberReturns{}
	if err := g.client.Call("Plugin.GetChannelMember", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelMember API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelMember(args *Z_GetChannelMemberArgs, returns *Z_GetChannelMemberReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelMember(channelId, userID string) (*model.ChannelMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelMember(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetChannelMember called but not implemented."))
	}
	return nil
}

type Z_GetChannelMembersArgs struct {
	A string
	B int
	C int
}

type Z_GetChannelMembersReturns struct {
	A model.ChannelMembers
	B *model.AppError
}

func (g *apiRPCClient) GetChannelMembers(channelId string, page, perPage int) (model.ChannelMembers, *model.AppError) {
	_args := &Z_GetChannelMembersArgs{channelId, page, perPage}
	_returns := &Z_GetChannelMembersReturns{}
	if err := g.client.Call("Plugin.GetChannelMembers", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelMembers API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelMembers(args *Z_GetChannelMembersArgs, returns *Z_GetChannelMembersReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelMembers(channelId string, page, perPage int) (model.ChannelMembers, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelMembers(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetChannelMembers called but not implemented."))
	}
	return nil
}

type Z_GetChannelMembersByIdsArgs struct {
	A string
	B []string
}

type Z_GetChannelMembersByIdsReturns struct {
	A model.ChannelMembers
	B *model.AppError
}

func (g *apiRPCClient) GetChannelMembersByIds(channelId string, userIds []string) (model.ChannelMembers, *model.AppError) {
	_args := &Z_GetChannelMembersByIdsArgs{channelId, userIds}
	_returns := &Z_GetChannelMembersByIdsReturns{}
	if err := g.client.Call("Plugin.GetChannelMembersByIds", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelMembersByIds API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelMembersByIds(args *Z_GetChannelMembersByIdsArgs, returns *Z_GetChannelMembersByIdsReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelMembersByIds(channelId string, userIds []string) (model.ChannelMembers, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelMembersByIds(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetChannelMembersByIds called but not implemented."))
	}
	return nil
}

type Z_GetChannelMembersForUserArgs struct {
	A string
	B string
	C int
	D int
}

type Z_GetChannelMembersForUserReturns struct {
	A []*model.ChannelMember
	B *model.AppError
}

func (g *apiRPCClient) GetChannelMembersForUser(teamID, userID string, page, perPage int) ([]*model.ChannelMember, *model.AppError) {
	_args := &Z_GetChannelMembersForUserArgs{teamID, userID, page, perPage}
	_returns := &Z_GetChannelMembersForUserReturns{}
	if err := g.client.Call("Plugin.GetChannelMembersForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetChannelMembersForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetChannelMembersForUser(args *Z_GetChannelMembersForUserArgs, returns *Z_GetChannelMembersForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetChannelMembersForUser(teamID, userID string, page, perPage int) ([]*model.ChannelMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetChannelMembersForUser(args.A, args.B, args.C, args.D)
	} else {
		return encodableError(fmt.Errorf("API GetChannelMembersForUser called but not implemented."))
	}
	return nil
}

type Z_UpdateChannelMemberRolesArgs struct {
	A string
	B string
	C string
}

type Z_UpdateChannelMemberRolesReturns struct {
	A *model.ChannelMember
	B *model.AppError
}

func (g *apiRPCClient) UpdateChannelMemberRoles(channelId, userID, newRoles string) (*model.ChannelMember, *model.AppError) {
	_args := &Z_UpdateChannelMemberRolesArgs{channelId, userID, newRoles}
	_returns := &Z_UpdateChannelMemberRolesReturns{}
	if err := g.client.Call("Plugin.UpdateChannelMemberRoles", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateChannelMemberRoles API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateChannelMemberRoles(args *Z_UpdateChannelMemberRolesArgs, returns *Z_UpdateChannelMemberRolesReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateChannelMemberRoles(channelId, userID, newRoles string) (*model.ChannelMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateChannelMemberRoles(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API UpdateChannelMemberRoles called but not implemented."))
	}
	return nil
}

type Z_UpdateChannelMemberNotificationsArgs struct {
	A string
	B string
	C map[string]string
}

type Z_UpdateChannelMemberNotificationsReturns struct {
	A *model.ChannelMember
	B *model.AppError
}

func (g *apiRPCClient) UpdateChannelMemberNotifications(channelId, userID string, notifications map[string]string) (*model.ChannelMember, *model.AppError) {
	_args := &Z_UpdateChannelMemberNotificationsArgs{channelId, userID, notifications}
	_returns := &Z_UpdateChannelMemberNotificationsReturns{}
	if err := g.client.Call("Plugin.UpdateChannelMemberNotifications", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateChannelMemberNotifications API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateChannelMemberNotifications(args *Z_UpdateChannelMemberNotificationsArgs, returns *Z_UpdateChannelMemberNotificationsReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateChannelMemberNotifications(channelId, userID string, notifications map[string]string) (*model.ChannelMember, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateChannelMemberNotifications(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API UpdateChannelMemberNotifications called but not implemented."))
	}
	return nil
}

type Z_GetGroupArgs struct {
	A string
}

type Z_GetGroupReturns struct {
	A *model.Group
	B *model.AppError
}

func (g *apiRPCClient) GetGroup(groupId string) (*model.Group, *model.AppError) {
	_args := &Z_GetGroupArgs{groupId}
	_returns := &Z_GetGroupReturns{}
	if err := g.client.Call("Plugin.GetGroup", _args, _returns); err != nil {
		log.Printf("RPC call to GetGroup API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetGroup(args *Z_GetGroupArgs, returns *Z_GetGroupReturns) error {
	if hook, ok := s.impl.(interface {
		GetGroup(groupId string) (*model.Group, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetGroup(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetGroup called but not implemented."))
	}
	return nil
}

type Z_GetGroupByNameArgs struct {
	A string
}

type Z_GetGroupByNameReturns struct {
	A *model.Group
	B *model.AppError
}

func (g *apiRPCClient) GetGroupByName(name string) (*model.Group, *model.AppError) {
	_args := &Z_GetGroupByNameArgs{name}
	_returns := &Z_GetGroupByNameReturns{}
	if err := g.client.Call("Plugin.GetGroupByName", _args, _returns); err != nil {
		log.Printf("RPC call to GetGroupByName API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetGroupByName(args *Z_GetGroupByNameArgs, returns *Z_GetGroupByNameReturns) error {
	if hook, ok := s.impl.(interface {
		GetGroupByName(name string) (*model.Group, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetGroupByName(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetGroupByName called but not implemented."))
	}
	return nil
}

type Z_GetGroupMemberUsersArgs struct {
	A string
	B int
	C int
}

type Z_GetGroupMemberUsersReturns struct {
	A []*model.User
	B *model.AppError
}

func (g *apiRPCClient) GetGroupMemberUsers(groupID string, page, perPage int) ([]*model.User, *model.AppError) {
	_args := &Z_GetGroupMemberUsersArgs{groupID, page, perPage}
	_returns := &Z_GetGroupMemberUsersReturns{}
	if err := g.client.Call("Plugin.GetGroupMemberUsers", _args, _returns); err != nil {
		log.Printf("RPC call to GetGroupMemberUsers API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetGroupMemberUsers(args *Z_GetGroupMemberUsersArgs, returns *Z_GetGroupMemberUsersReturns) error {
	if hook, ok := s.impl.(interface {
		GetGroupMemberUsers(groupID string, page, perPage int) ([]*model.User, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetGroupMemberUsers(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetGroupMemberUsers called but not implemented."))
	}
	return nil
}

type Z_GetGroupsBySourceArgs struct {
	A model.GroupSource
}

type Z_GetGroupsBySourceReturns struct {
	A []*model.Group
	B *model.AppError
}

func (g *apiRPCClient) GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError) {
	_args := &Z_GetGroupsBySourceArgs{groupSource}
	_returns := &Z_GetGroupsBySourceReturns{}
	if err := g.client.Call("Plugin.GetGroupsBySource", _args, _returns); err != nil {
		log.Printf("RPC call to GetGroupsBySource API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetGroupsBySource(args *Z_GetGroupsBySourceArgs, returns *Z_GetGroupsBySourceReturns) error {
	if hook, ok := s.impl.(interface {
		GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetGroupsBySource(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetGroupsBySource called but not implemented."))
	}
	return nil
}

type Z_GetGroupsForUserArgs struct {
	A string
}

type Z_GetGroupsForUserReturns struct {
	A []*model.Group
	B *model.AppError
}

func (g *apiRPCClient) GetGroupsForUser(userID string) ([]*model.Group, *model.AppError) {
	_args := &Z_GetGroupsForUserArgs{userID}
	_returns := &Z_GetGroupsForUserReturns{}
	if err := g.client.Call("Plugin.GetGroupsForUser", _args, _returns); err != nil {
		log.Printf("RPC call to GetGroupsForUser API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetGroupsForUser(args *Z_GetGroupsForUserArgs, returns *Z_GetGroupsForUserReturns) error {
	if hook, ok := s.impl.(interface {
		GetGroupsForUser(userID string) ([]*model.Group, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetGroupsForUser(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetGroupsForUser called but not implemented."))
	}
	return nil
}

type Z_DeleteChannelMemberArgs struct {
	A string
	B string
}

type Z_DeleteChannelMemberReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeleteChannelMember(channelId, userID string) *model.AppError {
	_args := &Z_DeleteChannelMemberArgs{channelId, userID}
	_returns := &Z_DeleteChannelMemberReturns{}
	if err := g.client.Call("Plugin.DeleteChannelMember", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteChannelMember API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteChannelMember(args *Z_DeleteChannelMemberArgs, returns *Z_DeleteChannelMemberReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteChannelMember(channelId, userID string) *model.AppError
	}); ok {
		returns.A = hook.DeleteChannelMember(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API DeleteChannelMember called but not implemented."))
	}
	return nil
}

type Z_CreatePostArgs struct {
	A *model.Post
}

type Z_CreatePostReturns struct {
	A *model.Post
	B *model.AppError
}

func (g *apiRPCClient) CreatePost(post *model.Post) (*model.Post, *model.AppError) {
	_args := &Z_CreatePostArgs{post}
	_returns := &Z_CreatePostReturns{}
	if err := g.client.Call("Plugin.CreatePost", _args, _returns); err != nil {
		log.Printf("RPC call to CreatePost API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreatePost(args *Z_CreatePostArgs, returns *Z_CreatePostReturns) error {
	if hook, ok := s.impl.(interface {
		CreatePost(post *model.Post) (*model.Post, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreatePost(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreatePost called but not implemented."))
	}
	return nil
}

type Z_AddReactionArgs struct {
	A *model.Reaction
}

type Z_AddReactionReturns struct {
	A *model.Reaction
	B *model.AppError
}

func (g *apiRPCClient) AddReaction(reaction *model.Reaction) (*model.Reaction, *model.AppError) {
	_args := &Z_AddReactionArgs{reaction}
	_returns := &Z_AddReactionReturns{}
	if err := g.client.Call("Plugin.AddReaction", _args, _returns); err != nil {
		log.Printf("RPC call to AddReaction API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) AddReaction(args *Z_AddReactionArgs, returns *Z_AddReactionReturns) error {
	if hook, ok := s.impl.(interface {
		AddReaction(reaction *model.Reaction) (*model.Reaction, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.AddReaction(args.A)
	} else {
		return encodableError(fmt.Errorf("API AddReaction called but not implemented."))
	}
	return nil
}

type Z_RemoveReactionArgs struct {
	A *model.Reaction
}

type Z_RemoveReactionReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RemoveReaction(reaction *model.Reaction) *model.AppError {
	_args := &Z_RemoveReactionArgs{reaction}
	_returns := &Z_RemoveReactionReturns{}
	if err := g.client.Call("Plugin.RemoveReaction", _args, _returns); err != nil {
		log.Printf("RPC call to RemoveReaction API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RemoveReaction(args *Z_RemoveReactionArgs, returns *Z_RemoveReactionReturns) error {
	if hook, ok := s.impl.(interface {
		RemoveReaction(reaction *model.Reaction) *model.AppError
	}); ok {
		returns.A = hook.RemoveReaction(args.A)
	} else {
		return encodableError(fmt.Errorf("API RemoveReaction called but not implemented."))
	}
	return nil
}

type Z_GetReactionsArgs struct {
	A string
}

type Z_GetReactionsReturns struct {
	A []*model.Reaction
	B *model.AppError
}

func (g *apiRPCClient) GetReactions(postId string) ([]*model.Reaction, *model.AppError) {
	_args := &Z_GetReactionsArgs{postId}
	_returns := &Z_GetReactionsReturns{}
	if err := g.client.Call("Plugin.GetReactions", _args, _returns); err != nil {
		log.Printf("RPC call to GetReactions API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetReactions(args *Z_GetReactionsArgs, returns *Z_GetReactionsReturns) error {
	if hook, ok := s.impl.(interface {
		GetReactions(postId string) ([]*model.Reaction, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetReactions(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetReactions called but not implemented."))
	}
	return nil
}

type Z_SendEphemeralPostArgs struct {
	A string
	B *model.Post
}

type Z_SendEphemeralPostReturns struct {
	A *model.Post
}

func (g *apiRPCClient) SendEphemeralPost(userID string, post *model.Post) *model.Post {
	_args := &Z_SendEphemeralPostArgs{userID, post}
	_returns := &Z_SendEphemeralPostReturns{}
	if err := g.client.Call("Plugin.SendEphemeralPost", _args, _returns); err != nil {
		log.Printf("RPC call to SendEphemeralPost API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) SendEphemeralPost(args *Z_SendEphemeralPostArgs, returns *Z_SendEphemeralPostReturns) error {
	if hook, ok := s.impl.(interface {
		SendEphemeralPost(userID string, post *model.Post) *model.Post
	}); ok {
		returns.A = hook.SendEphemeralPost(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API SendEphemeralPost called but not implemented."))
	}
	return nil
}

type Z_UpdateEphemeralPostArgs struct {
	A string
	B *model.Post
}

type Z_UpdateEphemeralPostReturns struct {
	A *model.Post
}

func (g *apiRPCClient) UpdateEphemeralPost(userID string, post *model.Post) *model.Post {
	_args := &Z_UpdateEphemeralPostArgs{userID, post}
	_returns := &Z_UpdateEphemeralPostReturns{}
	if err := g.client.Call("Plugin.UpdateEphemeralPost", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateEphemeralPost API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) UpdateEphemeralPost(args *Z_UpdateEphemeralPostArgs, returns *Z_UpdateEphemeralPostReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateEphemeralPost(userID string, post *model.Post) *model.Post
	}); ok {
		returns.A = hook.UpdateEphemeralPost(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API UpdateEphemeralPost called but not implemented."))
	}
	return nil
}

type Z_DeleteEphemeralPostArgs struct {
	A string
	B string
}

type Z_DeleteEphemeralPostReturns struct {
}

func (g *apiRPCClient) DeleteEphemeralPost(userID, postId string) {
	_args := &Z_DeleteEphemeralPostArgs{userID, postId}
	_returns := &Z_DeleteEphemeralPostReturns{}
	if err := g.client.Call("Plugin.DeleteEphemeralPost", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteEphemeralPost API failed: %s", err.Error())
	}

}

func (s *apiRPCServer) DeleteEphemeralPost(args *Z_DeleteEphemeralPostArgs, returns *Z_DeleteEphemeralPostReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteEphemeralPost(userID, postId string)
	}); ok {
		hook.DeleteEphemeralPost(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API DeleteEphemeralPost called but not implemented."))
	}
	return nil
}

type Z_DeletePostArgs struct {
	A string
}

type Z_DeletePostReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeletePost(postId string) *model.AppError {
	_args := &Z_DeletePostArgs{postId}
	_returns := &Z_DeletePostReturns{}
	if err := g.client.Call("Plugin.DeletePost", _args, _returns); err != nil {
		log.Printf("RPC call to DeletePost API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeletePost(args *Z_DeletePostArgs, returns *Z_DeletePostReturns) error {
	if hook, ok := s.impl.(interface {
		DeletePost(postId string) *model.AppError
	}); ok {
		returns.A = hook.DeletePost(args.A)
	} else {
		return encodableError(fmt.Errorf("API DeletePost called but not implemented."))
	}
	return nil
}

type Z_GetPostThreadArgs struct {
	A string
}

type Z_GetPostThreadReturns struct {
	A *model.PostList
	B *model.AppError
}

func (g *apiRPCClient) GetPostThread(postId string) (*model.PostList, *model.AppError) {
	_args := &Z_GetPostThreadArgs{postId}
	_returns := &Z_GetPostThreadReturns{}
	if err := g.client.Call("Plugin.GetPostThread", _args, _returns); err != nil {
		log.Printf("RPC call to GetPostThread API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPostThread(args *Z_GetPostThreadArgs, returns *Z_GetPostThreadReturns) error {
	if hook, ok := s.impl.(interface {
		GetPostThread(postId string) (*model.PostList, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPostThread(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetPostThread called but not implemented."))
	}
	return nil
}

type Z_GetPostArgs struct {
	A string
}

type Z_GetPostReturns struct {
	A *model.Post
	B *model.AppError
}

func (g *apiRPCClient) GetPost(postId string) (*model.Post, *model.AppError) {
	_args := &Z_GetPostArgs{postId}
	_returns := &Z_GetPostReturns{}
	if err := g.client.Call("Plugin.GetPost", _args, _returns); err != nil {
		log.Printf("RPC call to GetPost API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPost(args *Z_GetPostArgs, returns *Z_GetPostReturns) error {
	if hook, ok := s.impl.(interface {
		GetPost(postId string) (*model.Post, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPost(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetPost called but not implemented."))
	}
	return nil
}

type Z_GetPostsSinceArgs struct {
	A string
	B int64
}

type Z_GetPostsSinceReturns struct {
	A *model.PostList
	B *model.AppError
}

func (g *apiRPCClient) GetPostsSince(channelId string, time int64) (*model.PostList, *model.AppError) {
	_args := &Z_GetPostsSinceArgs{channelId, time}
	_returns := &Z_GetPostsSinceReturns{}
	if err := g.client.Call("Plugin.GetPostsSince", _args, _returns); err != nil {
		log.Printf("RPC call to GetPostsSince API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPostsSince(args *Z_GetPostsSinceArgs, returns *Z_GetPostsSinceReturns) error {
	if hook, ok := s.impl.(interface {
		GetPostsSince(channelId string, time int64) (*model.PostList, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPostsSince(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetPostsSince called but not implemented."))
	}
	return nil
}

type Z_GetPostsAfterArgs struct {
	A string
	B string
	C int
	D int
}

type Z_GetPostsAfterReturns struct {
	A *model.PostList
	B *model.AppError
}

func (g *apiRPCClient) GetPostsAfter(channelId, postId string, page, perPage int) (*model.PostList, *model.AppError) {
	_args := &Z_GetPostsAfterArgs{channelId, postId, page, perPage}
	_returns := &Z_GetPostsAfterReturns{}
	if err := g.client.Call("Plugin.GetPostsAfter", _args, _returns); err != nil {
		log.Printf("RPC call to GetPostsAfter API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPostsAfter(args *Z_GetPostsAfterArgs, returns *Z_GetPostsAfterReturns) error {
	if hook, ok := s.impl.(interface {
		GetPostsAfter(channelId, postId string, page, perPage int) (*model.PostList, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPostsAfter(args.A, args.B, args.C, args.D)
	} else {
		return encodableError(fmt.Errorf("API GetPostsAfter called but not implemented."))
	}
	return nil
}

type Z_GetPostsBeforeArgs struct {
	A string
	B string
	C int
	D int
}

type Z_GetPostsBeforeReturns struct {
	A *model.PostList
	B *model.AppError
}

func (g *apiRPCClient) GetPostsBefore(channelId, postId string, page, perPage int) (*model.PostList, *model.AppError) {
	_args := &Z_GetPostsBeforeArgs{channelId, postId, page, perPage}
	_returns := &Z_GetPostsBeforeReturns{}
	if err := g.client.Call("Plugin.GetPostsBefore", _args, _returns); err != nil {
		log.Printf("RPC call to GetPostsBefore API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPostsBefore(args *Z_GetPostsBeforeArgs, returns *Z_GetPostsBeforeReturns) error {
	if hook, ok := s.impl.(interface {
		GetPostsBefore(channelId, postId string, page, perPage int) (*model.PostList, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPostsBefore(args.A, args.B, args.C, args.D)
	} else {
		return encodableError(fmt.Errorf("API GetPostsBefore called but not implemented."))
	}
	return nil
}

type Z_GetPostsForChannelArgs struct {
	A string
	B int
	C int
}

type Z_GetPostsForChannelReturns struct {
	A *model.PostList
	B *model.AppError
}

func (g *apiRPCClient) GetPostsForChannel(channelId string, page, perPage int) (*model.PostList, *model.AppError) {
	_args := &Z_GetPostsForChannelArgs{channelId, page, perPage}
	_returns := &Z_GetPostsForChannelReturns{}
	if err := g.client.Call("Plugin.GetPostsForChannel", _args, _returns); err != nil {
		log.Printf("RPC call to GetPostsForChannel API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPostsForChannel(args *Z_GetPostsForChannelArgs, returns *Z_GetPostsForChannelReturns) error {
	if hook, ok := s.impl.(interface {
		GetPostsForChannel(channelId string, page, perPage int) (*model.PostList, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPostsForChannel(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetPostsForChannel called but not implemented."))
	}
	return nil
}

type Z_GetTeamStatsArgs struct {
	A string
}

type Z_GetTeamStatsReturns struct {
	A *model.TeamStats
	B *model.AppError
}

func (g *apiRPCClient) GetTeamStats(teamID string) (*model.TeamStats, *model.AppError) {
	_args := &Z_GetTeamStatsArgs{teamID}
	_returns := &Z_GetTeamStatsReturns{}
	if err := g.client.Call("Plugin.GetTeamStats", _args, _returns); err != nil {
		log.Printf("RPC call to GetTeamStats API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetTeamStats(args *Z_GetTeamStatsArgs, returns *Z_GetTeamStatsReturns) error {
	if hook, ok := s.impl.(interface {
		GetTeamStats(teamID string) (*model.TeamStats, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetTeamStats(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetTeamStats called but not implemented."))
	}
	return nil
}

type Z_UpdatePostArgs struct {
	A *model.Post
}

type Z_UpdatePostReturns struct {
	A *model.Post
	B *model.AppError
}

func (g *apiRPCClient) UpdatePost(post *model.Post) (*model.Post, *model.AppError) {
	_args := &Z_UpdatePostArgs{post}
	_returns := &Z_UpdatePostReturns{}
	if err := g.client.Call("Plugin.UpdatePost", _args, _returns); err != nil {
		log.Printf("RPC call to UpdatePost API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdatePost(args *Z_UpdatePostArgs, returns *Z_UpdatePostReturns) error {
	if hook, ok := s.impl.(interface {
		UpdatePost(post *model.Post) (*model.Post, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdatePost(args.A)
	} else {
		return encodableError(fmt.Errorf("API UpdatePost called but not implemented."))
	}
	return nil
}

type Z_GetProfileImageArgs struct {
	A string
}

type Z_GetProfileImageReturns struct {
	A []byte
	B *model.AppError
}

func (g *apiRPCClient) GetProfileImage(userID string) ([]byte, *model.AppError) {
	_args := &Z_GetProfileImageArgs{userID}
	_returns := &Z_GetProfileImageReturns{}
	if err := g.client.Call("Plugin.GetProfileImage", _args, _returns); err != nil {
		log.Printf("RPC call to GetProfileImage API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetProfileImage(args *Z_GetProfileImageArgs, returns *Z_GetProfileImageReturns) error {
	if hook, ok := s.impl.(interface {
		GetProfileImage(userID string) ([]byte, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetProfileImage(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetProfileImage called but not implemented."))
	}
	return nil
}

type Z_SetProfileImageArgs struct {
	A string
	B []byte
}

type Z_SetProfileImageReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) SetProfileImage(userID string, data []byte) *model.AppError {
	_args := &Z_SetProfileImageArgs{userID, data}
	_returns := &Z_SetProfileImageReturns{}
	if err := g.client.Call("Plugin.SetProfileImage", _args, _returns); err != nil {
		log.Printf("RPC call to SetProfileImage API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) SetProfileImage(args *Z_SetProfileImageArgs, returns *Z_SetProfileImageReturns) error {
	if hook, ok := s.impl.(interface {
		SetProfileImage(userID string, data []byte) *model.AppError
	}); ok {
		returns.A = hook.SetProfileImage(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API SetProfileImage called but not implemented."))
	}
	return nil
}

type Z_GetEmojiListArgs struct {
	A string
	B int
	C int
}

type Z_GetEmojiListReturns struct {
	A []*model.Emoji
	B *model.AppError
}

func (g *apiRPCClient) GetEmojiList(sortBy string, page, perPage int) ([]*model.Emoji, *model.AppError) {
	_args := &Z_GetEmojiListArgs{sortBy, page, perPage}
	_returns := &Z_GetEmojiListReturns{}
	if err := g.client.Call("Plugin.GetEmojiList", _args, _returns); err != nil {
		log.Printf("RPC call to GetEmojiList API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetEmojiList(args *Z_GetEmojiListArgs, returns *Z_GetEmojiListReturns) error {
	if hook, ok := s.impl.(interface {
		GetEmojiList(sortBy string, page, perPage int) ([]*model.Emoji, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetEmojiList(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetEmojiList called but not implemented."))
	}
	return nil
}

type Z_GetEmojiByNameArgs struct {
	A string
}

type Z_GetEmojiByNameReturns struct {
	A *model.Emoji
	B *model.AppError
}

func (g *apiRPCClient) GetEmojiByName(name string) (*model.Emoji, *model.AppError) {
	_args := &Z_GetEmojiByNameArgs{name}
	_returns := &Z_GetEmojiByNameReturns{}
	if err := g.client.Call("Plugin.GetEmojiByName", _args, _returns); err != nil {
		log.Printf("RPC call to GetEmojiByName API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetEmojiByName(args *Z_GetEmojiByNameArgs, returns *Z_GetEmojiByNameReturns) error {
	if hook, ok := s.impl.(interface {
		GetEmojiByName(name string) (*model.Emoji, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetEmojiByName(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetEmojiByName called but not implemented."))
	}
	return nil
}

type Z_GetEmojiArgs struct {
	A string
}

type Z_GetEmojiReturns struct {
	A *model.Emoji
	B *model.AppError
}

func (g *apiRPCClient) GetEmoji(emojiId string) (*model.Emoji, *model.AppError) {
	_args := &Z_GetEmojiArgs{emojiId}
	_returns := &Z_GetEmojiReturns{}
	if err := g.client.Call("Plugin.GetEmoji", _args, _returns); err != nil {
		log.Printf("RPC call to GetEmoji API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetEmoji(args *Z_GetEmojiArgs, returns *Z_GetEmojiReturns) error {
	if hook, ok := s.impl.(interface {
		GetEmoji(emojiId string) (*model.Emoji, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetEmoji(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetEmoji called but not implemented."))
	}
	return nil
}

type Z_CopyFileInfosArgs struct {
	A string
	B []string
}

type Z_CopyFileInfosReturns struct {
	A []string
	B *model.AppError
}

func (g *apiRPCClient) CopyFileInfos(userID string, fileIds []string) ([]string, *model.AppError) {
	_args := &Z_CopyFileInfosArgs{userID, fileIds}
	_returns := &Z_CopyFileInfosReturns{}
	if err := g.client.Call("Plugin.CopyFileInfos", _args, _returns); err != nil {
		log.Printf("RPC call to CopyFileInfos API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CopyFileInfos(args *Z_CopyFileInfosArgs, returns *Z_CopyFileInfosReturns) error {
	if hook, ok := s.impl.(interface {
		CopyFileInfos(userID string, fileIds []string) ([]string, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CopyFileInfos(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API CopyFileInfos called but not implemented."))
	}
	return nil
}

type Z_GetFileInfoArgs struct {
	A string
}

type Z_GetFileInfoReturns struct {
	A *model.FileInfo
	B *model.AppError
}

func (g *apiRPCClient) GetFileInfo(fileId string) (*model.FileInfo, *model.AppError) {
	_args := &Z_GetFileInfoArgs{fileId}
	_returns := &Z_GetFileInfoReturns{}
	if err := g.client.Call("Plugin.GetFileInfo", _args, _returns); err != nil {
		log.Printf("RPC call to GetFileInfo API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetFileInfo(args *Z_GetFileInfoArgs, returns *Z_GetFileInfoReturns) error {
	if hook, ok := s.impl.(interface {
		GetFileInfo(fileId string) (*model.FileInfo, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetFileInfo(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetFileInfo called but not implemented."))
	}
	return nil
}

type Z_GetFileInfosArgs struct {
	A int
	B int
	C *model.GetFileInfosOptions
}

type Z_GetFileInfosReturns struct {
	A []*model.FileInfo
	B *model.AppError
}

func (g *apiRPCClient) GetFileInfos(page, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError) {
	_args := &Z_GetFileInfosArgs{page, perPage, opt}
	_returns := &Z_GetFileInfosReturns{}
	if err := g.client.Call("Plugin.GetFileInfos", _args, _returns); err != nil {
		log.Printf("RPC call to GetFileInfos API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetFileInfos(args *Z_GetFileInfosArgs, returns *Z_GetFileInfosReturns) error {
	if hook, ok := s.impl.(interface {
		GetFileInfos(page, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetFileInfos(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API GetFileInfos called but not implemented."))
	}
	return nil
}

type Z_GetFileArgs struct {
	A string
}

type Z_GetFileReturns struct {
	A []byte
	B *model.AppError
}

func (g *apiRPCClient) GetFile(fileId string) ([]byte, *model.AppError) {
	_args := &Z_GetFileArgs{fileId}
	_returns := &Z_GetFileReturns{}
	if err := g.client.Call("Plugin.GetFile", _args, _returns); err != nil {
		log.Printf("RPC call to GetFile API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetFile(args *Z_GetFileArgs, returns *Z_GetFileReturns) error {
	if hook, ok := s.impl.(interface {
		GetFile(fileId string) ([]byte, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetFile(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetFile called but not implemented."))
	}
	return nil
}

type Z_GetFileLinkArgs struct {
	A string
}

type Z_GetFileLinkReturns struct {
	A string
	B *model.AppError
}

func (g *apiRPCClient) GetFileLink(fileId string) (string, *model.AppError) {
	_args := &Z_GetFileLinkArgs{fileId}
	_returns := &Z_GetFileLinkReturns{}
	if err := g.client.Call("Plugin.GetFileLink", _args, _returns); err != nil {
		log.Printf("RPC call to GetFileLink API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetFileLink(args *Z_GetFileLinkArgs, returns *Z_GetFileLinkReturns) error {
	if hook, ok := s.impl.(interface {
		GetFileLink(fileId string) (string, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetFileLink(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetFileLink called but not implemented."))
	}
	return nil
}

type Z_ReadFileArgs struct {
	A string
}

type Z_ReadFileReturns struct {
	A []byte
	B *model.AppError
}

func (g *apiRPCClient) ReadFile(path string) ([]byte, *model.AppError) {
	_args := &Z_ReadFileArgs{path}
	_returns := &Z_ReadFileReturns{}
	if err := g.client.Call("Plugin.ReadFile", _args, _returns); err != nil {
		log.Printf("RPC call to ReadFile API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) ReadFile(args *Z_ReadFileArgs, returns *Z_ReadFileReturns) error {
	if hook, ok := s.impl.(interface {
		ReadFile(path string) ([]byte, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.ReadFile(args.A)
	} else {
		return encodableError(fmt.Errorf("API ReadFile called but not implemented."))
	}
	return nil
}

type Z_GetEmojiImageArgs struct {
	A string
}

type Z_GetEmojiImageReturns struct {
	A []byte
	B string
	C *model.AppError
}

func (g *apiRPCClient) GetEmojiImage(emojiId string) ([]byte, string, *model.AppError) {
	_args := &Z_GetEmojiImageArgs{emojiId}
	_returns := &Z_GetEmojiImageReturns{}
	if err := g.client.Call("Plugin.GetEmojiImage", _args, _returns); err != nil {
		log.Printf("RPC call to GetEmojiImage API failed: %s", err.Error())
	}
	return _returns.A, _returns.B, _returns.C
}

func (s *apiRPCServer) GetEmojiImage(args *Z_GetEmojiImageArgs, returns *Z_GetEmojiImageReturns) error {
	if hook, ok := s.impl.(interface {
		GetEmojiImage(emojiId string) ([]byte, string, *model.AppError)
	}); ok {
		returns.A, returns.B, returns.C = hook.GetEmojiImage(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetEmojiImage called but not implemented."))
	}
	return nil
}

type Z_UploadFileArgs struct {
	A []byte
	B string
	C string
}

type Z_UploadFileReturns struct {
	A *model.FileInfo
	B *model.AppError
}

func (g *apiRPCClient) UploadFile(data []byte, channelId string, filename string) (*model.FileInfo, *model.AppError) {
	_args := &Z_UploadFileArgs{data, channelId, filename}
	_returns := &Z_UploadFileReturns{}
	if err := g.client.Call("Plugin.UploadFile", _args, _returns); err != nil {
		log.Printf("RPC call to UploadFile API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UploadFile(args *Z_UploadFileArgs, returns *Z_UploadFileReturns) error {
	if hook, ok := s.impl.(interface {
		UploadFile(data []byte, channelId string, filename string) (*model.FileInfo, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UploadFile(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API UploadFile called but not implemented."))
	}
	return nil
}

type Z_OpenInteractiveDialogArgs struct {
	A model.OpenDialogRequest
}

type Z_OpenInteractiveDialogReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) OpenInteractiveDialog(dialog model.OpenDialogRequest) *model.AppError {
	_args := &Z_OpenInteractiveDialogArgs{dialog}
	_returns := &Z_OpenInteractiveDialogReturns{}
	if err := g.client.Call("Plugin.OpenInteractiveDialog", _args, _returns); err != nil {
		log.Printf("RPC call to OpenInteractiveDialog API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) OpenInteractiveDialog(args *Z_OpenInteractiveDialogArgs, returns *Z_OpenInteractiveDialogReturns) error {
	if hook, ok := s.impl.(interface {
		OpenInteractiveDialog(dialog model.OpenDialogRequest) *model.AppError
	}); ok {
		returns.A = hook.OpenInteractiveDialog(args.A)
	} else {
		return encodableError(fmt.Errorf("API OpenInteractiveDialog called but not implemented."))
	}
	return nil
}

type Z_GetPluginsArgs struct {
}

type Z_GetPluginsReturns struct {
	A []*model.Manifest
	B *model.AppError
}

func (g *apiRPCClient) GetPlugins() ([]*model.Manifest, *model.AppError) {
	_args := &Z_GetPluginsArgs{}
	_returns := &Z_GetPluginsReturns{}
	if err := g.client.Call("Plugin.GetPlugins", _args, _returns); err != nil {
		log.Printf("RPC call to GetPlugins API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPlugins(args *Z_GetPluginsArgs, returns *Z_GetPluginsReturns) error {
	if hook, ok := s.impl.(interface {
		GetPlugins() ([]*model.Manifest, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPlugins()
	} else {
		return encodableError(fmt.Errorf("API GetPlugins called but not implemented."))
	}
	return nil
}

type Z_EnablePluginArgs struct {
	A string
}

type Z_EnablePluginReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) EnablePlugin(id string) *model.AppError {
	_args := &Z_EnablePluginArgs{id}
	_returns := &Z_EnablePluginReturns{}
	if err := g.client.Call("Plugin.EnablePlugin", _args, _returns); err != nil {
		log.Printf("RPC call to EnablePlugin API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) EnablePlugin(args *Z_EnablePluginArgs, returns *Z_EnablePluginReturns) error {
	if hook, ok := s.impl.(interface {
		EnablePlugin(id string) *model.AppError
	}); ok {
		returns.A = hook.EnablePlugin(args.A)
	} else {
		return encodableError(fmt.Errorf("API EnablePlugin called but not implemented."))
	}
	return nil
}

type Z_DisablePluginArgs struct {
	A string
}

type Z_DisablePluginReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DisablePlugin(id string) *model.AppError {
	_args := &Z_DisablePluginArgs{id}
	_returns := &Z_DisablePluginReturns{}
	if err := g.client.Call("Plugin.DisablePlugin", _args, _returns); err != nil {
		log.Printf("RPC call to DisablePlugin API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DisablePlugin(args *Z_DisablePluginArgs, returns *Z_DisablePluginReturns) error {
	if hook, ok := s.impl.(interface {
		DisablePlugin(id string) *model.AppError
	}); ok {
		returns.A = hook.DisablePlugin(args.A)
	} else {
		return encodableError(fmt.Errorf("API DisablePlugin called but not implemented."))
	}
	return nil
}

type Z_RemovePluginArgs struct {
	A string
}

type Z_RemovePluginReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RemovePlugin(id string) *model.AppError {
	_args := &Z_RemovePluginArgs{id}
	_returns := &Z_RemovePluginReturns{}
	if err := g.client.Call("Plugin.RemovePlugin", _args, _returns); err != nil {
		log.Printf("RPC call to RemovePlugin API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RemovePlugin(args *Z_RemovePluginArgs, returns *Z_RemovePluginReturns) error {
	if hook, ok := s.impl.(interface {
		RemovePlugin(id string) *model.AppError
	}); ok {
		returns.A = hook.RemovePlugin(args.A)
	} else {
		return encodableError(fmt.Errorf("API RemovePlugin called but not implemented."))
	}
	return nil
}

type Z_GetPluginStatusArgs struct {
	A string
}

type Z_GetPluginStatusReturns struct {
	A *model.PluginStatus
	B *model.AppError
}

func (g *apiRPCClient) GetPluginStatus(id string) (*model.PluginStatus, *model.AppError) {
	_args := &Z_GetPluginStatusArgs{id}
	_returns := &Z_GetPluginStatusReturns{}
	if err := g.client.Call("Plugin.GetPluginStatus", _args, _returns); err != nil {
		log.Printf("RPC call to GetPluginStatus API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetPluginStatus(args *Z_GetPluginStatusArgs, returns *Z_GetPluginStatusReturns) error {
	if hook, ok := s.impl.(interface {
		GetPluginStatus(id string) (*model.PluginStatus, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetPluginStatus(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetPluginStatus called but not implemented."))
	}
	return nil
}

type Z_KVSetArgs struct {
	A string
	B []byte
}

type Z_KVSetReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) KVSet(key string, value []byte) *model.AppError {
	_args := &Z_KVSetArgs{key, value}
	_returns := &Z_KVSetReturns{}
	if err := g.client.Call("Plugin.KVSet", _args, _returns); err != nil {
		log.Printf("RPC call to KVSet API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) KVSet(args *Z_KVSetArgs, returns *Z_KVSetReturns) error {
	if hook, ok := s.impl.(interface {
		KVSet(key string, value []byte) *model.AppError
	}); ok {
		returns.A = hook.KVSet(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API KVSet called but not implemented."))
	}
	return nil
}

type Z_KVCompareAndSetArgs struct {
	A string
	B []byte
	C []byte
}

type Z_KVCompareAndSetReturns struct {
	A bool
	B *model.AppError
}

func (g *apiRPCClient) KVCompareAndSet(key string, oldValue, newValue []byte) (bool, *model.AppError) {
	_args := &Z_KVCompareAndSetArgs{key, oldValue, newValue}
	_returns := &Z_KVCompareAndSetReturns{}
	if err := g.client.Call("Plugin.KVCompareAndSet", _args, _returns); err != nil {
		log.Printf("RPC call to KVCompareAndSet API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) KVCompareAndSet(args *Z_KVCompareAndSetArgs, returns *Z_KVCompareAndSetReturns) error {
	if hook, ok := s.impl.(interface {
		KVCompareAndSet(key string, oldValue, newValue []byte) (bool, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.KVCompareAndSet(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API KVCompareAndSet called but not implemented."))
	}
	return nil
}

type Z_KVCompareAndDeleteArgs struct {
	A string
	B []byte
}

type Z_KVCompareAndDeleteReturns struct {
	A bool
	B *model.AppError
}

func (g *apiRPCClient) KVCompareAndDelete(key string, oldValue []byte) (bool, *model.AppError) {
	_args := &Z_KVCompareAndDeleteArgs{key, oldValue}
	_returns := &Z_KVCompareAndDeleteReturns{}
	if err := g.client.Call("Plugin.KVCompareAndDelete", _args, _returns); err != nil {
		log.Printf("RPC call to KVCompareAndDelete API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) KVCompareAndDelete(args *Z_KVCompareAndDeleteArgs, returns *Z_KVCompareAndDeleteReturns) error {
	if hook, ok := s.impl.(interface {
		KVCompareAndDelete(key string, oldValue []byte) (bool, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.KVCompareAndDelete(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API KVCompareAndDelete called but not implemented."))
	}
	return nil
}

type Z_KVSetWithOptionsArgs struct {
	A string
	B []byte
	C model.PluginKVSetOptions
}

type Z_KVSetWithOptionsReturns struct {
	A bool
	B *model.AppError
}

func (g *apiRPCClient) KVSetWithOptions(key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError) {
	_args := &Z_KVSetWithOptionsArgs{key, value, options}
	_returns := &Z_KVSetWithOptionsReturns{}
	if err := g.client.Call("Plugin.KVSetWithOptions", _args, _returns); err != nil {
		log.Printf("RPC call to KVSetWithOptions API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) KVSetWithOptions(args *Z_KVSetWithOptionsArgs, returns *Z_KVSetWithOptionsReturns) error {
	if hook, ok := s.impl.(interface {
		KVSetWithOptions(key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.KVSetWithOptions(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API KVSetWithOptions called but not implemented."))
	}
	return nil
}

type Z_KVSetWithExpiryArgs struct {
	A string
	B []byte
	C int64
}

type Z_KVSetWithExpiryReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) KVSetWithExpiry(key string, value []byte, expireInSeconds int64) *model.AppError {
	_args := &Z_KVSetWithExpiryArgs{key, value, expireInSeconds}
	_returns := &Z_KVSetWithExpiryReturns{}
	if err := g.client.Call("Plugin.KVSetWithExpiry", _args, _returns); err != nil {
		log.Printf("RPC call to KVSetWithExpiry API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) KVSetWithExpiry(args *Z_KVSetWithExpiryArgs, returns *Z_KVSetWithExpiryReturns) error {
	if hook, ok := s.impl.(interface {
		KVSetWithExpiry(key string, value []byte, expireInSeconds int64) *model.AppError
	}); ok {
		returns.A = hook.KVSetWithExpiry(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API KVSetWithExpiry called but not implemented."))
	}
	return nil
}

type Z_KVGetArgs struct {
	A string
}

type Z_KVGetReturns struct {
	A []byte
	B *model.AppError
}

func (g *apiRPCClient) KVGet(key string) ([]byte, *model.AppError) {
	_args := &Z_KVGetArgs{key}
	_returns := &Z_KVGetReturns{}
	if err := g.client.Call("Plugin.KVGet", _args, _returns); err != nil {
		log.Printf("RPC call to KVGet API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) KVGet(args *Z_KVGetArgs, returns *Z_KVGetReturns) error {
	if hook, ok := s.impl.(interface {
		KVGet(key string) ([]byte, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.KVGet(args.A)
	} else {
		return encodableError(fmt.Errorf("API KVGet called but not implemented."))
	}
	return nil
}

type Z_KVDeleteArgs struct {
	A string
}

type Z_KVDeleteReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) KVDelete(key string) *model.AppError {
	_args := &Z_KVDeleteArgs{key}
	_returns := &Z_KVDeleteReturns{}
	if err := g.client.Call("Plugin.KVDelete", _args, _returns); err != nil {
		log.Printf("RPC call to KVDelete API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) KVDelete(args *Z_KVDeleteArgs, returns *Z_KVDeleteReturns) error {
	if hook, ok := s.impl.(interface {
		KVDelete(key string) *model.AppError
	}); ok {
		returns.A = hook.KVDelete(args.A)
	} else {
		return encodableError(fmt.Errorf("API KVDelete called but not implemented."))
	}
	return nil
}

type Z_KVDeleteAllArgs struct {
}

type Z_KVDeleteAllReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) KVDeleteAll() *model.AppError {
	_args := &Z_KVDeleteAllArgs{}
	_returns := &Z_KVDeleteAllReturns{}
	if err := g.client.Call("Plugin.KVDeleteAll", _args, _returns); err != nil {
		log.Printf("RPC call to KVDeleteAll API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) KVDeleteAll(args *Z_KVDeleteAllArgs, returns *Z_KVDeleteAllReturns) error {
	if hook, ok := s.impl.(interface {
		KVDeleteAll() *model.AppError
	}); ok {
		returns.A = hook.KVDeleteAll()
	} else {
		return encodableError(fmt.Errorf("API KVDeleteAll called but not implemented."))
	}
	return nil
}

type Z_KVListArgs struct {
	A int
	B int
}

type Z_KVListReturns struct {
	A []string
	B *model.AppError
}

func (g *apiRPCClient) KVList(page, perPage int) ([]string, *model.AppError) {
	_args := &Z_KVListArgs{page, perPage}
	_returns := &Z_KVListReturns{}
	if err := g.client.Call("Plugin.KVList", _args, _returns); err != nil {
		log.Printf("RPC call to KVList API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) KVList(args *Z_KVListArgs, returns *Z_KVListReturns) error {
	if hook, ok := s.impl.(interface {
		KVList(page, perPage int) ([]string, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.KVList(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API KVList called but not implemented."))
	}
	return nil
}

type Z_PublishWebSocketEventArgs struct {
	A string
	B map[string]interface{}
	C *model.WebsocketBroadcast
}

type Z_PublishWebSocketEventReturns struct {
}

func (g *apiRPCClient) PublishWebSocketEvent(event string, payload map[string]interface{}, broadcast *model.WebsocketBroadcast) {
	_args := &Z_PublishWebSocketEventArgs{event, payload, broadcast}
	_returns := &Z_PublishWebSocketEventReturns{}
	if err := g.client.Call("Plugin.PublishWebSocketEvent", _args, _returns); err != nil {
		log.Printf("RPC call to PublishWebSocketEvent API failed: %s", err.Error())
	}

}

func (s *apiRPCServer) PublishWebSocketEvent(args *Z_PublishWebSocketEventArgs, returns *Z_PublishWebSocketEventReturns) error {
	if hook, ok := s.impl.(interface {
		PublishWebSocketEvent(event string, payload map[string]interface{}, broadcast *model.WebsocketBroadcast)
	}); ok {
		hook.PublishWebSocketEvent(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API PublishWebSocketEvent called but not implemented."))
	}
	return nil
}

type Z_HasPermissionToArgs struct {
	A string
	B *model.Permission
}

type Z_HasPermissionToReturns struct {
	A bool
}

func (g *apiRPCClient) HasPermissionTo(userID string, permission *model.Permission) bool {
	_args := &Z_HasPermissionToArgs{userID, permission}
	_returns := &Z_HasPermissionToReturns{}
	if err := g.client.Call("Plugin.HasPermissionTo", _args, _returns); err != nil {
		log.Printf("RPC call to HasPermissionTo API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) HasPermissionTo(args *Z_HasPermissionToArgs, returns *Z_HasPermissionToReturns) error {
	if hook, ok := s.impl.(interface {
		HasPermissionTo(userID string, permission *model.Permission) bool
	}); ok {
		returns.A = hook.HasPermissionTo(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API HasPermissionTo called but not implemented."))
	}
	return nil
}

type Z_HasPermissionToTeamArgs struct {
	A string
	B string
	C *model.Permission
}

type Z_HasPermissionToTeamReturns struct {
	A bool
}

func (g *apiRPCClient) HasPermissionToTeam(userID, teamID string, permission *model.Permission) bool {
	_args := &Z_HasPermissionToTeamArgs{userID, teamID, permission}
	_returns := &Z_HasPermissionToTeamReturns{}
	if err := g.client.Call("Plugin.HasPermissionToTeam", _args, _returns); err != nil {
		log.Printf("RPC call to HasPermissionToTeam API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) HasPermissionToTeam(args *Z_HasPermissionToTeamArgs, returns *Z_HasPermissionToTeamReturns) error {
	if hook, ok := s.impl.(interface {
		HasPermissionToTeam(userID, teamID string, permission *model.Permission) bool
	}); ok {
		returns.A = hook.HasPermissionToTeam(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API HasPermissionToTeam called but not implemented."))
	}
	return nil
}

type Z_HasPermissionToChannelArgs struct {
	A string
	B string
	C *model.Permission
}

type Z_HasPermissionToChannelReturns struct {
	A bool
}

func (g *apiRPCClient) HasPermissionToChannel(userID, channelId string, permission *model.Permission) bool {
	_args := &Z_HasPermissionToChannelArgs{userID, channelId, permission}
	_returns := &Z_HasPermissionToChannelReturns{}
	if err := g.client.Call("Plugin.HasPermissionToChannel", _args, _returns); err != nil {
		log.Printf("RPC call to HasPermissionToChannel API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) HasPermissionToChannel(args *Z_HasPermissionToChannelArgs, returns *Z_HasPermissionToChannelReturns) error {
	if hook, ok := s.impl.(interface {
		HasPermissionToChannel(userID, channelId string, permission *model.Permission) bool
	}); ok {
		returns.A = hook.HasPermissionToChannel(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API HasPermissionToChannel called but not implemented."))
	}
	return nil
}

type Z_RolesGrantPermissionArgs struct {
	A []string
	B string
}

type Z_RolesGrantPermissionReturns struct {
	A bool
}

func (g *apiRPCClient) RolesGrantPermission(roleNames []string, permissionId string) bool {
	_args := &Z_RolesGrantPermissionArgs{roleNames, permissionId}
	_returns := &Z_RolesGrantPermissionReturns{}
	if err := g.client.Call("Plugin.RolesGrantPermission", _args, _returns); err != nil {
		log.Printf("RPC call to RolesGrantPermission API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RolesGrantPermission(args *Z_RolesGrantPermissionArgs, returns *Z_RolesGrantPermissionReturns) error {
	if hook, ok := s.impl.(interface {
		RolesGrantPermission(roleNames []string, permissionId string) bool
	}); ok {
		returns.A = hook.RolesGrantPermission(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API RolesGrantPermission called but not implemented."))
	}
	return nil
}

type Z_SendMailArgs struct {
	A string
	B string
	C string
}

type Z_SendMailReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) SendMail(to, subject, htmlBody string) *model.AppError {
	_args := &Z_SendMailArgs{to, subject, htmlBody}
	_returns := &Z_SendMailReturns{}
	if err := g.client.Call("Plugin.SendMail", _args, _returns); err != nil {
		log.Printf("RPC call to SendMail API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) SendMail(args *Z_SendMailArgs, returns *Z_SendMailReturns) error {
	if hook, ok := s.impl.(interface {
		SendMail(to, subject, htmlBody string) *model.AppError
	}); ok {
		returns.A = hook.SendMail(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API SendMail called but not implemented."))
	}
	return nil
}

type Z_CreateBotArgs struct {
	A *model.Bot
}

type Z_CreateBotReturns struct {
	A *model.Bot
	B *model.AppError
}

func (g *apiRPCClient) CreateBot(bot *model.Bot) (*model.Bot, *model.AppError) {
	_args := &Z_CreateBotArgs{bot}
	_returns := &Z_CreateBotReturns{}
	if err := g.client.Call("Plugin.CreateBot", _args, _returns); err != nil {
		log.Printf("RPC call to CreateBot API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateBot(args *Z_CreateBotArgs, returns *Z_CreateBotReturns) error {
	if hook, ok := s.impl.(interface {
		CreateBot(bot *model.Bot) (*model.Bot, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateBot(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateBot called but not implemented."))
	}
	return nil
}

type Z_PatchBotArgs struct {
	A string
	B *model.BotPatch
}

type Z_PatchBotReturns struct {
	A *model.Bot
	B *model.AppError
}

func (g *apiRPCClient) PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError) {
	_args := &Z_PatchBotArgs{botUserId, botPatch}
	_returns := &Z_PatchBotReturns{}
	if err := g.client.Call("Plugin.PatchBot", _args, _returns); err != nil {
		log.Printf("RPC call to PatchBot API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) PatchBot(args *Z_PatchBotArgs, returns *Z_PatchBotReturns) error {
	if hook, ok := s.impl.(interface {
		PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.PatchBot(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API PatchBot called but not implemented."))
	}
	return nil
}

type Z_GetBotArgs struct {
	A string
	B bool
}

type Z_GetBotReturns struct {
	A *model.Bot
	B *model.AppError
}

func (g *apiRPCClient) GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError) {
	_args := &Z_GetBotArgs{botUserId, includeDeleted}
	_returns := &Z_GetBotReturns{}
	if err := g.client.Call("Plugin.GetBot", _args, _returns); err != nil {
		log.Printf("RPC call to GetBot API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetBot(args *Z_GetBotArgs, returns *Z_GetBotReturns) error {
	if hook, ok := s.impl.(interface {
		GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetBot(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API GetBot called but not implemented."))
	}
	return nil
}

type Z_GetBotsArgs struct {
	A *model.BotGetOptions
}

type Z_GetBotsReturns struct {
	A []*model.Bot
	B *model.AppError
}

func (g *apiRPCClient) GetBots(options *model.BotGetOptions) ([]*model.Bot, *model.AppError) {
	_args := &Z_GetBotsArgs{options}
	_returns := &Z_GetBotsReturns{}
	if err := g.client.Call("Plugin.GetBots", _args, _returns); err != nil {
		log.Printf("RPC call to GetBots API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetBots(args *Z_GetBotsArgs, returns *Z_GetBotsReturns) error {
	if hook, ok := s.impl.(interface {
		GetBots(options *model.BotGetOptions) ([]*model.Bot, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetBots(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetBots called but not implemented."))
	}
	return nil
}

type Z_UpdateBotActiveArgs struct {
	A string
	B bool
}

type Z_UpdateBotActiveReturns struct {
	A *model.Bot
	B *model.AppError
}

func (g *apiRPCClient) UpdateBotActive(botUserId string, active bool) (*model.Bot, *model.AppError) {
	_args := &Z_UpdateBotActiveArgs{botUserId, active}
	_returns := &Z_UpdateBotActiveReturns{}
	if err := g.client.Call("Plugin.UpdateBotActive", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateBotActive API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateBotActive(args *Z_UpdateBotActiveArgs, returns *Z_UpdateBotActiveReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateBotActive(botUserId string, active bool) (*model.Bot, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateBotActive(args.A, args.B)
	} else {
		return encodableError(fmt.Errorf("API UpdateBotActive called but not implemented."))
	}
	return nil
}

type Z_PermanentDeleteBotArgs struct {
	A string
}

type Z_PermanentDeleteBotReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) PermanentDeleteBot(botUserId string) *model.AppError {
	_args := &Z_PermanentDeleteBotArgs{botUserId}
	_returns := &Z_PermanentDeleteBotReturns{}
	if err := g.client.Call("Plugin.PermanentDeleteBot", _args, _returns); err != nil {
		log.Printf("RPC call to PermanentDeleteBot API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) PermanentDeleteBot(args *Z_PermanentDeleteBotArgs, returns *Z_PermanentDeleteBotReturns) error {
	if hook, ok := s.impl.(interface {
		PermanentDeleteBot(botUserId string) *model.AppError
	}); ok {
		returns.A = hook.PermanentDeleteBot(args.A)
	} else {
		return encodableError(fmt.Errorf("API PermanentDeleteBot called but not implemented."))
	}
	return nil
}

type Z_PublishUserTypingArgs struct {
	A string
	B string
	C string
}

type Z_PublishUserTypingReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) PublishUserTyping(userID, channelId, parentId string) *model.AppError {
	_args := &Z_PublishUserTypingArgs{userID, channelId, parentId}
	_returns := &Z_PublishUserTypingReturns{}
	if err := g.client.Call("Plugin.PublishUserTyping", _args, _returns); err != nil {
		log.Printf("RPC call to PublishUserTyping API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) PublishUserTyping(args *Z_PublishUserTypingArgs, returns *Z_PublishUserTypingReturns) error {
	if hook, ok := s.impl.(interface {
		PublishUserTyping(userID, channelId, parentId string) *model.AppError
	}); ok {
		returns.A = hook.PublishUserTyping(args.A, args.B, args.C)
	} else {
		return encodableError(fmt.Errorf("API PublishUserTyping called but not implemented."))
	}
	return nil
}

type Z_CreateCommandArgs struct {
	A *model.Command
}

type Z_CreateCommandReturns struct {
	A *model.Command
	B error
}

func (g *apiRPCClient) CreateCommand(cmd *model.Command) (*model.Command, error) {
	_args := &Z_CreateCommandArgs{cmd}
	_returns := &Z_CreateCommandReturns{}
	if err := g.client.Call("Plugin.CreateCommand", _args, _returns); err != nil {
		log.Printf("RPC call to CreateCommand API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateCommand(args *Z_CreateCommandArgs, returns *Z_CreateCommandReturns) error {
	if hook, ok := s.impl.(interface {
		CreateCommand(cmd *model.Command) (*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.CreateCommand(args.A)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API CreateCommand called but not implemented."))
	}
	return nil
}

type Z_ListCommandsArgs struct {
	A string
}

type Z_ListCommandsReturns struct {
	A []*model.Command
	B error
}

func (g *apiRPCClient) ListCommands(teamID string) ([]*model.Command, error) {
	_args := &Z_ListCommandsArgs{teamID}
	_returns := &Z_ListCommandsReturns{}
	if err := g.client.Call("Plugin.ListCommands", _args, _returns); err != nil {
		log.Printf("RPC call to ListCommands API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) ListCommands(args *Z_ListCommandsArgs, returns *Z_ListCommandsReturns) error {
	if hook, ok := s.impl.(interface {
		ListCommands(teamID string) ([]*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.ListCommands(args.A)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API ListCommands called but not implemented."))
	}
	return nil
}

type Z_ListCustomCommandsArgs struct {
	A string
}

type Z_ListCustomCommandsReturns struct {
	A []*model.Command
	B error
}

func (g *apiRPCClient) ListCustomCommands(teamID string) ([]*model.Command, error) {
	_args := &Z_ListCustomCommandsArgs{teamID}
	_returns := &Z_ListCustomCommandsReturns{}
	if err := g.client.Call("Plugin.ListCustomCommands", _args, _returns); err != nil {
		log.Printf("RPC call to ListCustomCommands API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) ListCustomCommands(args *Z_ListCustomCommandsArgs, returns *Z_ListCustomCommandsReturns) error {
	if hook, ok := s.impl.(interface {
		ListCustomCommands(teamID string) ([]*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.ListCustomCommands(args.A)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API ListCustomCommands called but not implemented."))
	}
	return nil
}

type Z_ListPluginCommandsArgs struct {
	A string
}

type Z_ListPluginCommandsReturns struct {
	A []*model.Command
	B error
}

func (g *apiRPCClient) ListPluginCommands(teamID string) ([]*model.Command, error) {
	_args := &Z_ListPluginCommandsArgs{teamID}
	_returns := &Z_ListPluginCommandsReturns{}
	if err := g.client.Call("Plugin.ListPluginCommands", _args, _returns); err != nil {
		log.Printf("RPC call to ListPluginCommands API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) ListPluginCommands(args *Z_ListPluginCommandsArgs, returns *Z_ListPluginCommandsReturns) error {
	if hook, ok := s.impl.(interface {
		ListPluginCommands(teamID string) ([]*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.ListPluginCommands(args.A)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API ListPluginCommands called but not implemented."))
	}
	return nil
}

type Z_ListBuiltInCommandsArgs struct {
}

type Z_ListBuiltInCommandsReturns struct {
	A []*model.Command
	B error
}

func (g *apiRPCClient) ListBuiltInCommands() ([]*model.Command, error) {
	_args := &Z_ListBuiltInCommandsArgs{}
	_returns := &Z_ListBuiltInCommandsReturns{}
	if err := g.client.Call("Plugin.ListBuiltInCommands", _args, _returns); err != nil {
		log.Printf("RPC call to ListBuiltInCommands API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) ListBuiltInCommands(args *Z_ListBuiltInCommandsArgs, returns *Z_ListBuiltInCommandsReturns) error {
	if hook, ok := s.impl.(interface {
		ListBuiltInCommands() ([]*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.ListBuiltInCommands()
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API ListBuiltInCommands called but not implemented."))
	}
	return nil
}

type Z_GetCommandArgs struct {
	A string
}

type Z_GetCommandReturns struct {
	A *model.Command
	B error
}

func (g *apiRPCClient) GetCommand(commandID string) (*model.Command, error) {
	_args := &Z_GetCommandArgs{commandID}
	_returns := &Z_GetCommandReturns{}
	if err := g.client.Call("Plugin.GetCommand", _args, _returns); err != nil {
		log.Printf("RPC call to GetCommand API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetCommand(args *Z_GetCommandArgs, returns *Z_GetCommandReturns) error {
	if hook, ok := s.impl.(interface {
		GetCommand(commandID string) (*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.GetCommand(args.A)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API GetCommand called but not implemented."))
	}
	return nil
}

type Z_UpdateCommandArgs struct {
	A string
	B *model.Command
}

type Z_UpdateCommandReturns struct {
	A *model.Command
	B error
}

func (g *apiRPCClient) UpdateCommand(commandID string, updatedCmd *model.Command) (*model.Command, error) {
	_args := &Z_UpdateCommandArgs{commandID, updatedCmd}
	_returns := &Z_UpdateCommandReturns{}
	if err := g.client.Call("Plugin.UpdateCommand", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateCommand API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateCommand(args *Z_UpdateCommandArgs, returns *Z_UpdateCommandReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateCommand(commandID string, updatedCmd *model.Command) (*model.Command, error)
	}); ok {
		returns.A, returns.B = hook.UpdateCommand(args.A, args.B)
		returns.B = encodableError(returns.B)
	} else {
		return encodableError(fmt.Errorf("API UpdateCommand called but not implemented."))
	}
	return nil
}

type Z_DeleteCommandArgs struct {
	A string
}

type Z_DeleteCommandReturns struct {
	A error
}

func (g *apiRPCClient) DeleteCommand(commandID string) error {
	_args := &Z_DeleteCommandArgs{commandID}
	_returns := &Z_DeleteCommandReturns{}
	if err := g.client.Call("Plugin.DeleteCommand", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteCommand API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteCommand(args *Z_DeleteCommandArgs, returns *Z_DeleteCommandReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteCommand(commandID string) error
	}); ok {
		returns.A = hook.DeleteCommand(args.A)
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("API DeleteCommand called but not implemented."))
	}
	return nil
}

type Z_CreateOAuthAppArgs struct {
	A *model.OAuthApp
}

type Z_CreateOAuthAppReturns struct {
	A *model.OAuthApp
	B *model.AppError
}

func (g *apiRPCClient) CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	_args := &Z_CreateOAuthAppArgs{app}
	_returns := &Z_CreateOAuthAppReturns{}
	if err := g.client.Call("Plugin.CreateOAuthApp", _args, _returns); err != nil {
		log.Printf("RPC call to CreateOAuthApp API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) CreateOAuthApp(args *Z_CreateOAuthAppArgs, returns *Z_CreateOAuthAppReturns) error {
	if hook, ok := s.impl.(interface {
		CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.CreateOAuthApp(args.A)
	} else {
		return encodableError(fmt.Errorf("API CreateOAuthApp called but not implemented."))
	}
	return nil
}

type Z_GetOAuthAppArgs struct {
	A string
}

type Z_GetOAuthAppReturns struct {
	A *model.OAuthApp
	B *model.AppError
}

func (g *apiRPCClient) GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError) {
	_args := &Z_GetOAuthAppArgs{appID}
	_returns := &Z_GetOAuthAppReturns{}
	if err := g.client.Call("Plugin.GetOAuthApp", _args, _returns); err != nil {
		log.Printf("RPC call to GetOAuthApp API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) GetOAuthApp(args *Z_GetOAuthAppArgs, returns *Z_GetOAuthAppReturns) error {
	if hook, ok := s.impl.(interface {
		GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.GetOAuthApp(args.A)
	} else {
		return encodableError(fmt.Errorf("API GetOAuthApp called but not implemented."))
	}
	return nil
}

type Z_UpdateOAuthAppArgs struct {
	A *model.OAuthApp
}

type Z_UpdateOAuthAppReturns struct {
	A *model.OAuthApp
	B *model.AppError
}

func (g *apiRPCClient) UpdateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	_args := &Z_UpdateOAuthAppArgs{app}
	_returns := &Z_UpdateOAuthAppReturns{}
	if err := g.client.Call("Plugin.UpdateOAuthApp", _args, _returns); err != nil {
		log.Printf("RPC call to UpdateOAuthApp API failed: %s", err.Error())
	}
	return _returns.A, _returns.B
}

func (s *apiRPCServer) UpdateOAuthApp(args *Z_UpdateOAuthAppArgs, returns *Z_UpdateOAuthAppReturns) error {
	if hook, ok := s.impl.(interface {
		UpdateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError)
	}); ok {
		returns.A, returns.B = hook.UpdateOAuthApp(args.A)
	} else {
		return encodableError(fmt.Errorf("API UpdateOAuthApp called but not implemented."))
	}
	return nil
}

type Z_DeleteOAuthAppArgs struct {
	A string
}

type Z_DeleteOAuthAppReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) DeleteOAuthApp(appID string) *model.AppError {
	_args := &Z_DeleteOAuthAppArgs{appID}
	_returns := &Z_DeleteOAuthAppReturns{}
	if err := g.client.Call("Plugin.DeleteOAuthApp", _args, _returns); err != nil {
		log.Printf("RPC call to DeleteOAuthApp API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) DeleteOAuthApp(args *Z_DeleteOAuthAppArgs, returns *Z_DeleteOAuthAppReturns) error {
	if hook, ok := s.impl.(interface {
		DeleteOAuthApp(appID string) *model.AppError
	}); ok {
		returns.A = hook.DeleteOAuthApp(args.A)
	} else {
		return encodableError(fmt.Errorf("API DeleteOAuthApp called but not implemented."))
	}
	return nil
}

type Z_PublishPluginClusterEventArgs struct {
	A model.PluginClusterEvent
	B model.PluginClusterEventSendOptions
}

type Z_PublishPluginClusterEventReturns struct {
	A error
}

func (g *apiRPCClient) PublishPluginClusterEvent(ev model.PluginClusterEvent, opts model.PluginClusterEventSendOptions) error {
	_args := &Z_PublishPluginClusterEventArgs{ev, opts}
	_returns := &Z_PublishPluginClusterEventReturns{}
	if err := g.client.Call("Plugin.PublishPluginClusterEvent", _args, _returns); err != nil {
		log.Printf("RPC call to PublishPluginClusterEvent API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) PublishPluginClusterEvent(args *Z_PublishPluginClusterEventArgs, returns *Z_PublishPluginClusterEventReturns) error {
	if hook, ok := s.impl.(interface {
		PublishPluginClusterEvent(ev model.PluginClusterEvent, opts model.PluginClusterEventSendOptions) error
	}); ok {
		returns.A = hook.PublishPluginClusterEvent(args.A, args.B)
		returns.A = encodableError(returns.A)
	} else {
		return encodableError(fmt.Errorf("API PublishPluginClusterEvent called but not implemented."))
	}
	return nil
}

type Z_RequestTrialLicenseArgs struct {
	A string
	B int
	C bool
	D bool
}

type Z_RequestTrialLicenseReturns struct {
	A *model.AppError
}

func (g *apiRPCClient) RequestTrialLicense(requesterID string, users int, termsAccepted bool, receiveEmailsAccepted bool) *model.AppError {
	_args := &Z_RequestTrialLicenseArgs{requesterID, users, termsAccepted, receiveEmailsAccepted}
	_returns := &Z_RequestTrialLicenseReturns{}
	if err := g.client.Call("Plugin.RequestTrialLicense", _args, _returns); err != nil {
		log.Printf("RPC call to RequestTrialLicense API failed: %s", err.Error())
	}
	return _returns.A
}

func (s *apiRPCServer) RequestTrialLicense(args *Z_RequestTrialLicenseArgs, returns *Z_RequestTrialLicenseReturns) error {
	if hook, ok := s.impl.(interface {
		RequestTrialLicense(requesterID string, users int, termsAccepted bool, receiveEmailsAccepted bool) *model.AppError
	}); ok {
		returns.A = hook.RequestTrialLicense(args.A, args.B, args.C, args.D)
	} else {
		return encodableError(fmt.Errorf("API RequestTrialLicense called but not implemented."))
	}
	return nil
}
