// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebaseapphosting provides access to the Firebase App Hosting API.
//
// For product documentation, see: https://firebase.google.com/docs/app-hosting
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firebaseapphosting/v1beta"
//	...
//	ctx := context.Background()
//	firebaseapphostingService, err := firebaseapphosting.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firebaseapphostingService, err := firebaseapphosting.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firebaseapphostingService, err := firebaseapphosting.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firebaseapphosting // import "google.golang.org/api/firebaseapphosting/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "firebaseapphosting:v1beta"
const apiName = "firebaseapphosting"
const apiVersion = "v1beta"
const basePath = "https://firebaseapphosting.googleapis.com/"
const basePathTemplate = "https://firebaseapphosting.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firebaseapphosting.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Backends = NewProjectsLocationsBackendsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Backends *ProjectsLocationsBackendsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsBackendsService(s *Service) *ProjectsLocationsBackendsService {
	rs := &ProjectsLocationsBackendsService{s: s}
	rs.Builds = NewProjectsLocationsBackendsBuildsService(s)
	rs.Domains = NewProjectsLocationsBackendsDomainsService(s)
	rs.Rollouts = NewProjectsLocationsBackendsRolloutsService(s)
	rs.Traffic = NewProjectsLocationsBackendsTrafficService(s)
	return rs
}

type ProjectsLocationsBackendsService struct {
	s *Service

	Builds *ProjectsLocationsBackendsBuildsService

	Domains *ProjectsLocationsBackendsDomainsService

	Rollouts *ProjectsLocationsBackendsRolloutsService

	Traffic *ProjectsLocationsBackendsTrafficService
}

func NewProjectsLocationsBackendsBuildsService(s *Service) *ProjectsLocationsBackendsBuildsService {
	rs := &ProjectsLocationsBackendsBuildsService{s: s}
	return rs
}

type ProjectsLocationsBackendsBuildsService struct {
	s *Service
}

func NewProjectsLocationsBackendsDomainsService(s *Service) *ProjectsLocationsBackendsDomainsService {
	rs := &ProjectsLocationsBackendsDomainsService{s: s}
	return rs
}

type ProjectsLocationsBackendsDomainsService struct {
	s *Service
}

func NewProjectsLocationsBackendsRolloutsService(s *Service) *ProjectsLocationsBackendsRolloutsService {
	rs := &ProjectsLocationsBackendsRolloutsService{s: s}
	return rs
}

type ProjectsLocationsBackendsRolloutsService struct {
	s *Service
}

func NewProjectsLocationsBackendsTrafficService(s *Service) *ProjectsLocationsBackendsTrafficService {
	rs := &ProjectsLocationsBackendsTrafficService{s: s}
	return rs
}

type ProjectsLocationsBackendsTrafficService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// ArchiveSource: The URI of an storage archive or a signed URL to use as the
// build source.
type ArchiveSource struct {
	// Author: Optional. The author contained in the metadata of a version control
	// change.
	Author *SourceUserMetadata `json:"author,omitempty"`
	// Description: Optional. An optional message that describes the uploaded
	// version of the source code.
	Description string `json:"description,omitempty"`
	// ExternalSignedUri: Signed URL to an archive in a storage bucket.
	ExternalSignedUri string `json:"externalSignedUri,omitempty"`
	// RootDirectory: Optional. Relative path in the archive.
	RootDirectory string `json:"rootDirectory,omitempty"`
	// UserStorageUri: URI to an archive in Cloud Storage. The object must be a
	// zipped (.zip) or gzipped archive file (.tar.gz) containing source to deploy.
	UserStorageUri string `json:"userStorageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Author") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Author") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArchiveSource) MarshalJSON() ([]byte, error) {
	type NoMethod ArchiveSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Backend: A backend is the primary resource of App Hosting.
type Backend struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// AppId: Optional. The ID of a Web App
	// (https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
	// associated with the backend.
	AppId string `json:"appId,omitempty"`
	// Codebase: Optional. If specified, the connection to an external source
	// repository to watch for event-driven updates to the backend.
	Codebase *Codebase `json:"codebase,omitempty"`
	// CreateTime: Output only. Time at which the backend was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. Time at which the backend was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Optional. Human-readable name. 63 character limit.
	DisplayName string `json:"displayName,omitempty"`
	// Environment: Optional. The environment name of the backend, used to load
	// environment variables from environment specific configuration.
	Environment string `json:"environment,omitempty"`
	// Etag: Output only. Server-computed checksum based on other values; may be
	// sent on update or delete to ensure operation is done on expected resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects.
	Labels map[string]string `json:"labels,omitempty"`
	// ManagedResources: Output only. A list of the resources managed by this
	// backend.
	ManagedResources []*ManagedResource `json:"managedResources,omitempty"`
	// Mode: Optional. Deprecated: Use `environment` instead.
	Mode string `json:"mode,omitempty"`
	// Name: Identifier. The resource name of the backend. Format:
	// `projects/{project}/locations/{locationId}/backends/{backendId}`.
	Name string `json:"name,omitempty"`
	// OverrideEnv: Optional. Override environment variables for this Backend.
	OverrideEnv []*EnvironmentVariable `json:"overrideEnv,omitempty"`
	// Reconciling: Output only. A field that, if true, indicates that the system
	// is working to make adjustments to the backend during a LRO.
	Reconciling bool `json:"reconciling,omitempty"`
	// RequestLogsDisabled: Optional. A field that, if true, indicates that
	// incoming request logs are disabled for this backend. Incoming request logs
	// are enabled by default.
	RequestLogsDisabled bool `json:"requestLogsDisabled,omitempty"`
	// ServiceAccount: Required. The name of the service account used for Cloud
	// Build and Cloud Run. Should have the role
	// roles/firebaseapphosting.computeRunner or equivalent permissions.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ServingLocality: Required. Immutable. Specifies how App Hosting will serve
	// the content for this backend. It will either be contained to a single region
	// (REGIONAL_STRICT) or allowed to use App Hosting's global-replicated serving
	// infrastructure (GLOBAL_ACCESS).
	//
	// Possible values:
	//   "SERVING_LOCALITY_UNSPECIFIED" - Unspecified. Will return an error if
	// used.
	//   "REGIONAL_STRICT" - In this mode, App Hosting serves your backend's
	// content from your chosen parent region. App Hosting only maintains data and
	// serving infrastructure in that chosen region and does not replicate your
	// data to other regions.
	//   "GLOBAL_ACCESS" - In this mode, App Hosting serves your backend's content
	// from multiple points-of-presence (POP) across the globe. App Hosting
	// replicates your backend's configuration and cached data to these POPs and
	// uses a global CDN to further decrease response latency. App
	// Hosting-maintained Cloud Resources on your project, such as Cloud Run
	// services, Cloud Build build, and Artifact Registry Images are still confined
	// to your backend's parent region. Responses cached by the CDN may be stored
	// in the POPs for the duration of the cache's TTL.
	ServingLocality string `json:"servingLocality,omitempty"`
	// Uid: Output only. System-assigned, unique identifier.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. Time at which the backend was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Uri: Output only. The primary URI to communicate with the backend.
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Backend) MarshalJSON() ([]byte, error) {
	type NoMethod Backend
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Build: A single build for a backend, at a specific point codebase reference
// tag and point in time. Encapsulates several resources, including an Artifact
// Registry container image, a Cloud Build invocation that built the image, and
// the Cloud Run revision that uses that image.
type Build struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// BuildLogsUri: Output only. The location of the Cloud Build logs
	// (https://cloud.google.com/build/docs/view-build-results) for the build
	// process.
	BuildLogsUri string `json:"buildLogsUri,omitempty"`
	// Config: Optional. Additional configuration of the service.
	Config *Config `json:"config,omitempty"`
	// CreateTime: Output only. Time at which the build was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. Time at which the build was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Optional. Human-readable name. 63 character limit.
	DisplayName string `json:"displayName,omitempty"`
	// Environment: Output only. The environment name of the backend when this
	// build was created.
	Environment string `json:"environment,omitempty"`
	// Error: Output only. A status and (human readable) error message for the
	// build, if in a `FAILED` state. Deprecated. Use `errors` instead.
	Error *Status `json:"error,omitempty"`
	// ErrorSource: Output only. The source of the error for the build, if in a
	// `FAILED` state. Deprecated. Use `errors` instead.
	//
	// Possible values:
	//   "ERROR_SOURCE_UNSPECIFIED" - Indicates that generic error occurred outside
	// of the Cloud Build or Cloud Run processes, such as a pre-empted or
	// user-canceled App Hosting Build.
	//   "CLOUD_BUILD" - Indicates that the build failed during the Cloud Build
	// process, such as a build timeout.
	//   "CLOUD_RUN" - Indicates that the build failed during the Cloud Run
	// process, such as a service creation failure.
	ErrorSource string `json:"errorSource,omitempty"`
	// Errors: Output only. A list of all errors that occurred during an App
	// Hosting build.
	Errors []*Error `json:"errors,omitempty"`
	// Etag: Output only. Server-computed checksum based on other values; may be
	// sent on update or delete to ensure operation is done on expected resource.
	Etag string `json:"etag,omitempty"`
	// Image: Output only. The Artifact Registry container image
	// (https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
	// URI, used by the Cloud Run `revision`
	// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services.revisions)
	// for this build.
	Image string `json:"image,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the build. Format:
	// `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{build
	// Id}`.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. A field that, if true, indicates that the build
	// has an ongoing LRO.
	Reconciling bool `json:"reconciling,omitempty"`
	// Source: Required. Immutable. The source for the build.
	Source *BuildSource `json:"source,omitempty"`
	// State: Output only. The state of the build.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The build is in an unknown state.
	//   "BUILDING" - The build is building.
	//   "BUILT" - The build has completed and is awaiting the next step. This may
	// move to DEPLOYING once App Hosting starts to set up infrastructure.
	//   "DEPLOYING" - The infrastructure for this build is being set up.
	//   "READY" - The infrastructure for this build is ready. The build may or may
	// not be serving traffic - see `Backend.traffic` for the current state, or
	// `Backend.traffic_statuses` for the desired state.
	//   "FAILED" - The build has failed.
	State string `json:"state,omitempty"`
	// Uid: Output only. System-assigned, unique identifier.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. Time at which the build was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Build) MarshalJSON() ([]byte, error) {
	type NoMethod Build
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuildSource: The source for the build.
type BuildSource struct {
	// Archive: An archive source.
	Archive *ArchiveSource `json:"archive,omitempty"`
	// Codebase: A codebase source.
	Codebase *CodebaseSource `json:"codebase,omitempty"`
	// Container: An Artifact Registry container image source.
	Container *ContainerSource `json:"container,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Archive") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Archive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildSource) MarshalJSON() ([]byte, error) {
	type NoMethod BuildSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Codebase: The connection to an external source repository to watch for
// event-driven updates to the backend.
type Codebase struct {
	// Repository: Required. The resource name for the Developer Connect
	// `gitRepositoryLink`
	// (https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections.gitRepositoryLinks)
	// connected to this backend, in the format:
	// `projects/{project}/locations/{location}/connections/{connection}/gitReposito
	// ryLinks/{repositoryLink}` The connection for the `gitRepositoryLink` must
	// made be using the Firebase App Hosting GitHub App via the Firebase Console.
	Repository string `json:"repository,omitempty"`
	// RootDirectory: Optional. If `repository` is provided, the directory relative
	// to the root of the repository to use as the root for the deployed web app.
	RootDirectory string `json:"rootDirectory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Repository") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Repository") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Codebase) MarshalJSON() ([]byte, error) {
	type NoMethod Codebase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CodebaseSource: A codebase source, representing the state of the codebase
// that the build will be created at.
type CodebaseSource struct {
	// Author: Output only. The author contained in the metadata of a version
	// control change.
	Author *UserMetadata `json:"author,omitempty"`
	// Branch: The branch in the codebase to build from, using the latest commit.
	Branch string `json:"branch,omitempty"`
	// Commit: The commit in the codebase to build from.
	Commit string `json:"commit,omitempty"`
	// CommitMessage: Output only. The message of a codebase change.
	CommitMessage string `json:"commitMessage,omitempty"`
	// CommitTime: Output only. The time the change was made.
	CommitTime string `json:"commitTime,omitempty"`
	// DisplayName: Output only. The human-friendly name to use for this Codebase
	// when displaying a build. We use the first eight characters of the SHA-1 hash
	// for GitHub.com.
	DisplayName string `json:"displayName,omitempty"`
	// Hash: Output only. The full SHA-1 hash of a Git commit, if available.
	Hash string `json:"hash,omitempty"`
	// Uri: Output only. A URI linking to the codebase on an hosting provider's
	// website. May not be valid if the commit has been rebased or force-pushed out
	// of existence in the linked repository.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Author") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Author") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CodebaseSource) MarshalJSON() ([]byte, error) {
	type NoMethod CodebaseSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Config: Additional configuration of the backend for this build.
type Config struct {
	// Env: Optional. Environment variables for this build.
	Env []*EnvironmentVariable `json:"env,omitempty"`
	// RunConfig: Optional. Additional configuration of the Cloud Run `service`
	// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service).
	RunConfig *RunConfig `json:"runConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Env") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Env") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Config) MarshalJSON() ([]byte, error) {
	type NoMethod Config
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContainerSource: The URI of an Artifact Registry container image
// (https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
// to use as the build source.
type ContainerSource struct {
	// Image: Required. A URI representing a container for the backend to use.
	Image string `json:"image,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContainerSource) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomDomainOperationMetadata: Additional metadata for operations on custom
// domains.
type CustomDomainOperationMetadata struct {
	// CertState: Output only. The custom domain's `CertState`, which must be
	// `CERT_ACTIVE` for the create operations to complete.
	//
	// Possible values:
	//   "CERT_STATE_UNSPECIFIED" - The certificate's state is unspecified. The
	// message is invalid if this is unspecified.
	//   "CERT_PREPARING" - The initial state of every certificate, represents App
	// Hosting's intent to create a certificate before requests to a Certificate
	// Authority are made.
	//   "CERT_VALIDATING" - App Hosting is validating whether a domain name's DNS
	// records are in a state that allow certificate creation on its behalf.
	//   "CERT_PROPAGATING" - The certificate was recently created, and needs time
	// to propagate in App Hosting's load balancers.
	//   "CERT_ACTIVE" - The certificate is active, providing secure connections
	// for the domain names it represents.
	//   "CERT_EXPIRING_SOON" - The certificate is expiring, all domain names on it
	// will be given new certificates.
	//   "CERT_EXPIRED" - The certificate has expired. App Hosting can no longer
	// serve secure content on your domain name.
	CertState string `json:"certState,omitempty"`
	// HostState: Output only. The custom domain's `HostState`, which must be
	// `HOST_ACTIVE` for Create operations of the domain name this `CustomDomain`
	// refers toto complete.
	//
	// Possible values:
	//   "HOST_STATE_UNSPECIFIED" - Your custom domain's host state is unspecified.
	// The message is invalid if this is unspecified.
	//   "HOST_UNHOSTED" - Your custom domain isn't associated with any IP
	// addresses.
	//   "HOST_UNREACHABLE" - Your custom domain can't be reached. App Hosting
	// services' DNS queries to find your domain's IP addresses resulted in errors.
	// See your `CustomDomainStatus`'s `issues` field for more details.
	//   "HOST_NON_FAH" - Your domain has only IP addresses that don't ultimately
	// resolve to App Hosting.
	//   "HOST_CONFLICT" - Your domain has IP addresses that resolve to both App
	// Hosting and to other services. To ensure consistent results, remove `A` and
	// `AAAA` records related to non-App-Hosting services.
	//   "HOST_WRONG_SHARD" - Your domain has IP addresses that resolve to an
	// incorrect instance of the App Hosting Data Plane. App Hosting has multiple
	// data plane instances to ensure high availability. The SSL certificate that
	// App Hosting creates for your domain is only available on its assigned
	// instance. If your domain's IP addresses resolve to an incorrect instance,
	// App Hosting won't be able to serve secure content on it.
	//   "HOST_ACTIVE" - All requests against your domain are served by App
	// Hosting, via your domain's assigned shard. If the custom domain's
	// `OwnershipState` is also `OWNERSHIP_ACTIVE`, App Hosting serves its
	// backend's content on requests for the domain.
	HostState string `json:"hostState,omitempty"`
	// Issues: Output only. A list of issues that are currently preventing the
	// operation from completing. These are generally DNS-related issues
	// encountered when querying a domain's records or attempting to mint an SSL
	// certificate.
	Issues []*Status `json:"issues,omitempty"`
	// LiveMigrationSteps: Output only. A list of steps that the user must complete
	// to migrate their domain to App Hosting without downtime.
	LiveMigrationSteps []*LiveMigrationStep `json:"liveMigrationSteps,omitempty"`
	// OwnershipState: Output only. The custom domain's `OwnershipState`, which
	// must be `OWNERSHIP_ACTIVE` for the create operations to complete.
	//
	// Possible values:
	//   "OWNERSHIP_STATE_UNSPECIFIED" - Your custom domain's ownership state is
	// unspecified. This should never happen.
	//   "OWNERSHIP_MISSING" - Your custom domain's domain has no
	// App-Hosting-related ownership records; no backend is authorized to serve on
	// the domain in this Origin shard.
	//   "OWNERSHIP_UNREACHABLE" - Your custom domain can't be reached. App Hosting
	// services' DNS queries to find your domain's ownership records resulted in
	// errors. See your `CustomDomainStatus`'s `issues` field for more details.
	//   "OWNERSHIP_MISMATCH" - Your custom domain is owned by another App Hosting
	// custom domain. Remove the conflicting records and replace them with records
	// for your current custom domain.
	//   "OWNERSHIP_CONFLICT" - Your custom domain has conflicting `TXT` records
	// that indicate ownership by both your current custom domain one or more
	// others. Remove the extraneous ownership records to grant the current custom
	// domain ownership.
	//   "OWNERSHIP_PENDING" - Your custom domain's DNS records are configured
	// correctly. App Hosting will transfer ownership of your domain to this custom
	// domain within 24 hours.
	//   "OWNERSHIP_ACTIVE" - Your custom domain owns its domain.
	OwnershipState string `json:"ownershipState,omitempty"`
	// QuickSetupUpdates: Output only. A set of DNS record updates to perform, to
	// allow App Hosting to serve secure content on the domain.
	QuickSetupUpdates []*DnsUpdates `json:"quickSetupUpdates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomDomainOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CustomDomainOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomDomainStatus: The status of a custom domain's linkage to a backend.
type CustomDomainStatus struct {
	// CertState: Output only. Tracks SSL certificate status for the domain.
	//
	// Possible values:
	//   "CERT_STATE_UNSPECIFIED" - The certificate's state is unspecified. The
	// message is invalid if this is unspecified.
	//   "CERT_PREPARING" - The initial state of every certificate, represents App
	// Hosting's intent to create a certificate before requests to a Certificate
	// Authority are made.
	//   "CERT_VALIDATING" - App Hosting is validating whether a domain name's DNS
	// records are in a state that allow certificate creation on its behalf.
	//   "CERT_PROPAGATING" - The certificate was recently created, and needs time
	// to propagate in App Hosting's load balancers.
	//   "CERT_ACTIVE" - The certificate is active, providing secure connections
	// for the domain names it represents.
	//   "CERT_EXPIRING_SOON" - The certificate is expiring, all domain names on it
	// will be given new certificates.
	//   "CERT_EXPIRED" - The certificate has expired. App Hosting can no longer
	// serve secure content on your domain name.
	CertState string `json:"certState,omitempty"`
	// HostState: Output only. Tracks whether a custom domain is detected as
	// appropriately directing traffic to App Hosting.
	//
	// Possible values:
	//   "HOST_STATE_UNSPECIFIED" - Your custom domain's host state is unspecified.
	// The message is invalid if this is unspecified.
	//   "HOST_UNHOSTED" - Your custom domain isn't associated with any IP
	// addresses.
	//   "HOST_UNREACHABLE" - Your custom domain can't be reached. App Hosting
	// services' DNS queries to find your domain's IP addresses resulted in errors.
	// See your `CustomDomainStatus`'s `issues` field for more details.
	//   "HOST_NON_FAH" - Your domain has only IP addresses that don't ultimately
	// resolve to App Hosting.
	//   "HOST_CONFLICT" - Your domain has IP addresses that resolve to both App
	// Hosting and to other services. To ensure consistent results, remove `A` and
	// `AAAA` records related to non-App-Hosting services.
	//   "HOST_WRONG_SHARD" - Your domain has IP addresses that resolve to an
	// incorrect instance of the App Hosting Data Plane. App Hosting has multiple
	// data plane instances to ensure high availability. The SSL certificate that
	// App Hosting creates for your domain is only available on its assigned
	// instance. If your domain's IP addresses resolve to an incorrect instance,
	// App Hosting won't be able to serve secure content on it.
	//   "HOST_ACTIVE" - All requests against your domain are served by App
	// Hosting, via your domain's assigned shard. If the custom domain's
	// `OwnershipState` is also `OWNERSHIP_ACTIVE`, App Hosting serves its
	// backend's content on requests for the domain.
	HostState string `json:"hostState,omitempty"`
	// Issues: Output only. A list of issues with domain configuration. Allows
	// users to self-correct problems with DNS records.
	Issues []*Status `json:"issues,omitempty"`
	// OwnershipState: Output only. Tracks whether the backend is permitted to
	// serve content on the domain, based off the domain's DNS records.
	//
	// Possible values:
	//   "OWNERSHIP_STATE_UNSPECIFIED" - Your custom domain's ownership state is
	// unspecified. This should never happen.
	//   "OWNERSHIP_MISSING" - Your custom domain's domain has no
	// App-Hosting-related ownership records; no backend is authorized to serve on
	// the domain in this Origin shard.
	//   "OWNERSHIP_UNREACHABLE" - Your custom domain can't be reached. App Hosting
	// services' DNS queries to find your domain's ownership records resulted in
	// errors. See your `CustomDomainStatus`'s `issues` field for more details.
	//   "OWNERSHIP_MISMATCH" - Your custom domain is owned by another App Hosting
	// custom domain. Remove the conflicting records and replace them with records
	// for your current custom domain.
	//   "OWNERSHIP_CONFLICT" - Your custom domain has conflicting `TXT` records
	// that indicate ownership by both your current custom domain one or more
	// others. Remove the extraneous ownership records to grant the current custom
	// domain ownership.
	//   "OWNERSHIP_PENDING" - Your custom domain's DNS records are configured
	// correctly. App Hosting will transfer ownership of your domain to this custom
	// domain within 24 hours.
	//   "OWNERSHIP_ACTIVE" - Your custom domain owns its domain.
	OwnershipState string `json:"ownershipState,omitempty"`
	// RequiredDnsUpdates: Output only. Lists the records that must added or
	// removed to a custom domain's DNS in order to finish setup and start serving
	// content. Field is present during onboarding. Also present after onboarding
	// if one or more of the above states is not *_ACTIVE, indicating the domain's
	// DNS records are in a bad state.
	RequiredDnsUpdates []*DnsUpdates `json:"requiredDnsUpdates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomDomainStatus) MarshalJSON() ([]byte, error) {
	type NoMethod CustomDomainStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DnsRecord: A representation of a DNS records for a domain. DNS records are
// resource records that define how systems and services should behave when
// handling requests for a domain. For example, when you add `A` records to
// your domain's DNS records, you're informing other systems (such as your
// users' web browsers) to contact those IPv4 addresses to retrieve resources
// relevant to your domain (such as your App Hosting files).
type DnsRecord struct {
	// DomainName: Output only. The domain the record pertains to, e.g.
	// `foo.bar.com.`.
	DomainName string `json:"domainName,omitempty"`
	// Rdata: Output only. The data of the record. The meaning of the value depends
	// on record type: - A and AAAA: IP addresses for the domain. - CNAME: Another
	// domain to check for records. - TXT: Arbitrary text strings associated with
	// the domain. App Hosting uses TXT records to determine which Firebase
	// projects have permission to act on the domain's behalf. - CAA: The record's
	// flags, tag, and value, e.g. `0 issue "pki.goog".
	Rdata string `json:"rdata,omitempty"`
	// RelevantState: Output only. An enum that indicates which state(s) this DNS
	// record applies to. Populated for all records with an `ADD` or `REMOVE`
	// required action.
	//
	// Possible values:
	//   "CUSTOM_DOMAIN_STATE_UNSPECIFIED" - This message is invalid if this is
	// unspecified.
	//   "HOST_STATE" - The custom domain's host state.
	//   "OWNERSHIP_STATE" - The custom domain's ownership state.
	//   "CERT_STATE" - The custom domain's certificate state.
	RelevantState []string `json:"relevantState,omitempty"`
	// RequiredAction: Output only. An enum that indicates the a required action
	// for this record. Populated when the record is part of a required change in a
	// `DnsUpdates` `discovered` or `desired` record set.
	//
	// Possible values:
	//   "NONE" - No action necessary.
	//   "ADD" - Add this record to your DNS records.
	//   "REMOVE" - Remove this record from your DNS records.
	RequiredAction string `json:"requiredAction,omitempty"`
	// Type: Output only. The record's type, which determines what data the record
	// contains.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The record's type is unspecified. The message is
	// invalid if this is unspecified.
	//   "A" - An `A` record, as defined in [RFC
	// 1035](https://tools.ietf.org/html/rfc1035). A records determine which IPv4
	// addresses a domain directs traffic towards.
	//   "CNAME" - A `CNAME` record, as defined in [RFC
	// 1035](https://tools.ietf.org/html/rfc1035). `CNAME` or Canonical Name
	// records map a domain to a different, canonical domain. If a `CNAME` record
	// is present, it should be the only record on the domain.
	//   "TXT" - A `TXT` record, as defined in [RFC
	// 1035](https://tools.ietf.org/html/rfc1035). `TXT` records hold arbitrary
	// text data on a domain. Hosting uses `TXT` records to establish which
	// Firebase Project has permission to act on a domain.
	//   "AAAA" - An AAAA record, as defined in [RFC
	// 3596](https://tools.ietf.org/html/rfc3596) AAAA records determine which IPv6
	// addresses a domain directs traffic towards.
	//   "CAA" - A CAA record, as defined in [RFC
	// 6844](https://tools.ietf.org/html/rfc6844). CAA, or Certificate Authority
	// Authorization, records determine which Certificate Authorities (SSL
	// certificate minting organizations) are authorized to mint a certificate for
	// the domain. App Hosting uses `pki.goog` as its primary CA. CAA records
	// cascade. A CAA record on `foo.com` also applies to `bar.foo.com` unless
	// `bar.foo.com` has its own set of CAA records. CAA records are optional. If a
	// domain and its parents have no CAA records, all CAs are authorized to mint
	// certificates on its behalf. In general, App Hosting only asks you to modify
	// CAA records when doing so is required to unblock SSL cert creation.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DomainName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DomainName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DnsRecord) MarshalJSON() ([]byte, error) {
	type NoMethod DnsRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DnsRecordSet: A set of DNS records relevant to the setup and maintenance of
// a custom domain in App Hosting.
type DnsRecordSet struct {
	// CheckError: Output only. An error App Hosting services encountered when
	// querying your domain's DNS records. Note: App Hosting ignores `NXDOMAIN`
	// errors, as those generally just mean that a domain name hasn't been set up
	// yet.
	CheckError *Status `json:"checkError,omitempty"`
	// DomainName: Output only. The domain name the record set pertains to.
	DomainName string `json:"domainName,omitempty"`
	// Records: Output only. Records on the domain.
	Records []*DnsRecord `json:"records,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckError") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DnsRecordSet) MarshalJSON() ([]byte, error) {
	type NoMethod DnsRecordSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DnsUpdates: A set of DNS record updates that you should make to allow App
// Hosting to serve secure content in response to requests against your domain.
// These updates present the current state of your domain's and related
// subdomains' DNS records when App Hosting last queried them, and the desired
// set of records that App Hosting needs to see before your custom domain can
// be fully active.
type DnsUpdates struct {
	// CheckTime: Output only. The last time App Hosting checked your custom
	// domain's DNS records.
	CheckTime string `json:"checkTime,omitempty"`
	// Desired: Output only. The set of DNS records App Hosting needs in order to
	// be able to serve secure content on the domain.
	Desired []*DnsRecordSet `json:"desired,omitempty"`
	// Discovered: Output only. The set of DNS records App Hosting discovered when
	// inspecting a domain.
	Discovered []*DnsRecordSet `json:"discovered,omitempty"`
	// DomainName: Output only. The domain name the DNS updates pertain to.
	DomainName string `json:"domainName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DnsUpdates) MarshalJSON() ([]byte, error) {
	type NoMethod DnsUpdates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Domain: A domain name that is associated with a backend.
type Domain struct {
	// Annotations: Optional. Annotations as key value pairs.
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. Time at which the domain was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomDomainStatus: Output only. Represents the state and configuration of a
	// `CUSTOM` type domain. It is only present on Domains of that type.
	CustomDomainStatus *CustomDomainStatus `json:"customDomainStatus,omitempty"`
	// DeleteTime: Output only. Time at which the domain was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Disabled: Optional. Whether the domain is disabled. Defaults to false.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: Optional. Mutable human-readable name for the domain. 63
	// character limit. e.g. `prod domain`.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. Server-computed checksum based on other values; may be
	// sent on update or delete to ensure operation is done on expected resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the domain, e.g.
	// `/projects/p/locations/l/backends/b/domains/foo.com`
	Name string `json:"name,omitempty"`
	// PurgeTime: Output only. Time at which a soft-deleted domain will be purged,
	// rendering in permanently deleted.
	PurgeTime string `json:"purgeTime,omitempty"`
	// Reconciling: Output only. A field that, if true, indicates that the build
	// has an ongoing LRO.
	Reconciling bool `json:"reconciling,omitempty"`
	// Serve: Optional. The serving behavior of the domain. If specified, the
	// domain will serve content other than its backend's live content.
	Serve *ServingBehavior `json:"serve,omitempty"`
	// Type: Output only. The type of the domain.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified (this should not happen).
	//   "DEFAULT" - Default, App Hosting-provided and managed domains. These
	// domains are created automatically with their parent backend and cannot be
	// deleted except by deleting that parent, and cannot be moved to another
	// backend. Default domains can be disabled via the `disabled` field.
	//   "CUSTOM" - Custom, developer-owned domains. Custom Domains allow you to
	// associate a domain you own with your App Hosting backend, and configure that
	// domain to serve your backend's content.
	Type string `json:"type,omitempty"`
	// Uid: Output only. System-assigned, unique identifier.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. Time at which the domain was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Domain) MarshalJSON() ([]byte, error) {
	type NoMethod Domain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainOperationMetadata: Represents the metadata of a long-running operation
// on domains.
type DomainOperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomDomainOperationMetadata: Output only. Additional metadata for
	// operations on custom domains.
	CustomDomainOperationMetadata *CustomDomainOperationMetadata `json:"customDomainOperationMetadata,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DomainOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EnvironmentVariable: Environment variables for this build.
type EnvironmentVariable struct {
	// Availability: Optional. Where this variable should be made available. If
	// left unspecified, will be available in both BUILD and BACKEND.
	//
	// Possible values:
	//   "AVAILABILITY_UNSPECIFIED" - The default value, unspecified, which is
	// unused.
	//   "BUILD" - This value is available when creating a Build from source code.
	//   "RUNTIME" - This value is available at runtime within Cloud Run.
	Availability []string `json:"availability,omitempty"`
	// Secret: A fully qualified secret version. The value of the secret will be
	// accessed once while building the application and once per cold start of the
	// container at runtime. The service account used by Cloud Build and by Cloud
	// Run must each have the `secretmanager.versions.access` permission on the
	// secret.
	Secret string `json:"secret,omitempty"`
	// Value: A plaintext value. This value is encrypted at rest, but all project
	// readers can view the value when reading your backend configuration.
	Value string `json:"value,omitempty"`
	// Variable: Required. The name of the environment variable. - Must be a valid
	// environment variable name (e.g. A-Z or underscores). - May not start with
	// "FIREBASE" or "GOOGLE". - May not be a reserved environment variable for
	// KNative/Cloud Run
	Variable string `json:"variable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Availability") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnvironmentVariable) MarshalJSON() ([]byte, error) {
	type NoMethod EnvironmentVariable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Error: The container for the rpc status and source for any errors found
// during the build process.
type Error struct {
	// CloudResource: Output only. Resource link
	CloudResource string `json:"cloudResource,omitempty"`
	// Error: Output only. A status and (human readable) error message for the
	// build, if in a `FAILED` state.
	Error *Status `json:"error,omitempty"`
	// ErrorSource: Output only. The source of the error for the build, if in a
	// `FAILED` state.
	//
	// Possible values:
	//   "ERROR_SOURCE_UNSPECIFIED" - Indicates that generic error occurred outside
	// of the Cloud Build or Cloud Run processes, such as a pre-empted or
	// user-canceled App Hosting Build.
	//   "CLOUD_BUILD" - Indicates that the build failed during the Cloud Build
	// process, such as a build timeout.
	//   "CLOUD_RUN" - Indicates that the build failed during the Cloud Run
	// process, such as a service creation failure.
	ErrorSource string `json:"errorSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudResource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudResource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Error) MarshalJSON() ([]byte, error) {
	type NoMethod Error
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackendsResponse: Message for response to list backends
type ListBackendsResponse struct {
	// Backends: The list of backends
	Backends []*Backend `json:"backends,omitempty"`
	// NextPageToken: A token identifying the next page of results the server
	// should return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Backends") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backends") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackendsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackendsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBuildsResponse: Message for response to list builds.
type ListBuildsResponse struct {
	// Builds: The list of builds.
	Builds []*Build `json:"builds,omitempty"`
	// NextPageToken: A token identifying the next page of results the server
	// should return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Builds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Builds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBuildsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBuildsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDomainsResponse: Message for response to list domains.
type ListDomainsResponse struct {
	// Domains: Output only. The list of domains.
	Domains []*Domain `json:"domains,omitempty"`
	// NextPageToken: Output only. A token identifying the next page of results the
	// server should return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Output only. Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Domains") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domains") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDomainsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDomainsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections e.g. when attempting to list all resources across all supported
	// locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRolloutsResponse: Message for response to list rollouts.
type ListRolloutsResponse struct {
	// NextPageToken: A token identifying the next page of results the server
	// should return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Rollouts: The list of rollouts.
	Rollouts []*Rollout `json:"rollouts,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRolloutsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRolloutsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LiveMigrationStep: A set of updates including ACME challenges and DNS
// records that allow App Hosting to create an SSL certificate and establish
// project ownership for your domain name before you direct traffic to App
// Hosting servers. Use these updates to facilitate zero downtime migrations to
// App Hosting from other services. After you've made the recommended updates,
// check your custom domain's `ownershipState` and `certState`. To avoid
// downtime, they should be `OWNERSHIP_ACTIVE` and `CERT_ACTIVE`, respectively,
// before you update your `A` and `AAAA` records.
type LiveMigrationStep struct {
	// DnsUpdates: Output only. DNS updates to facilitate your domain's
	// zero-downtime migration to App Hosting.
	DnsUpdates []*DnsUpdates `json:"dnsUpdates,omitempty"`
	// Issues: Output only. Issues that prevent the current step from completing.
	Issues []*Status `json:"issues,omitempty"`
	// RelevantDomainStates: Output only. One or more states from the
	// `CustomDomainStatus` of the migrating domain that this step is attempting to
	// make ACTIVE. For example, if the step is attempting to mint an SSL
	// certificate, this field will include `CERT_STATE`.
	//
	// Possible values:
	//   "CUSTOM_DOMAIN_STATE_UNSPECIFIED" - This message is invalid if this is
	// unspecified.
	//   "HOST_STATE" - The custom domain's host state.
	//   "OWNERSHIP_STATE" - The custom domain's ownership state.
	//   "CERT_STATE" - The custom domain's certificate state.
	RelevantDomainStates []string `json:"relevantDomainStates,omitempty"`
	// StepState: Output only. The state of the live migration step, indicates
	// whether you should work to complete the step now, in the future, or have
	// already completed it.
	//
	// Possible values:
	//   "STEP_STATE_UNSPECIFIED" - The step's state is unspecified. The message is
	// invalid if this is unspecified.
	//   "PREPARING" - App Hosting doesn't have enough information to construct the
	// step yet. Complete any prior steps and/or resolve this step's issue to
	// proceed.
	//   "PENDING" - The step's state is pending. Complete prior steps before
	// working on a `PENDING` step.
	//   "INCOMPLETE" - The step is incomplete. You should complete any
	// `dnsUpdates` changes to complete it.
	//   "PROCESSING" - You've done your part to update records and present
	// challenges as necessary. App Hosting is now completing background processes
	// to complete the step, e.g. minting an SSL cert for your domain.
	//   "COMPLETE" - The step is complete. You've already made the necessary
	// changes to your domain and/or prior hosting service to advance to the next
	// step. Once all steps are complete, App Hosting is ready to serve secure
	// content on your domain.
	StepState string `json:"stepState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DnsUpdates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DnsUpdates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiveMigrationStep) MarshalJSON() ([]byte, error) {
	type NoMethod LiveMigrationStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManagedResource: An external resource managed by App Hosting on the project.
type ManagedResource struct {
	// RunService: A Cloud Run `service`
	// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service),
	// managed by App Hosting.
	RunService *RunService `json:"runService,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RunService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RunService") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedResource) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of a long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Redirect: Specifies redirect behavior for a domain.
type Redirect struct {
	// Status: Optional. The status code to use in a redirect response. Must be a
	// valid HTTP 3XX status code. Defaults to 302 if not present.
	Status int64 `json:"status,omitempty,string"`
	// Uri: Required. The URI of the redirect's intended destination. This URI will
	// be prepended to the original request path. URI without a scheme are assumed
	// to be HTTPS.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Redirect) MarshalJSON() ([]byte, error) {
	type NoMethod Redirect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Rollout: A single rollout of a build for a backend.
type Rollout struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// Build: Required. Immutable. The name of a build that already exists. It
	// doesn't have to be built; a rollout will wait for a build to be ready before
	// updating traffic.
	Build string `json:"build,omitempty"`
	// CreateTime: Output only. Time at which the rollout was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. Time at which the rollout was deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Optional. Human-readable name. 63 character limit.
	DisplayName string `json:"displayName,omitempty"`
	// Error: Output only. A status and (human readable) error message for the
	// rollout, if in a `FAILED` state.
	Error *Status `json:"error,omitempty"`
	// Etag: Output only. Server-computed checksum based on other values; may be
	// sent on update or delete to ensure operation is done on expected resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the rollout. Format:
	// `projects/{project}/locations/{locationId}/backends/{backendId}/rollouts/{rol
	// loutId}`.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. A field that, if true, indicates that the Rollout
	// currently has an LRO.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The state of the rollout.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The rollout is in an unknown state.
	//   "QUEUED" - The rollout is waiting for actuation to begin. This may be
	// because it is waiting on another rollout to complete.
	//   "PENDING_BUILD" - The rollout is waiting for the build process to
	// complete, which builds the code and sets up the underlying infrastructure.
	//   "PROGRESSING" - The rollout has started and is actively modifying traffic.
	//   "PAUSED" - The rollout has been paused due to either being manually paused
	// or a PAUSED stage. This should be set while `paused = true`.
	//   "SUCCEEDED" - The rollout has completed.
	//   "FAILED" - The rollout has failed. See error for more information.
	//   "CANCELLED" - The rollout has been cancelled.
	State string `json:"state,omitempty"`
	// Uid: Output only. System-assigned, unique identifier.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. Time at which the rollout was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Rollout) MarshalJSON() ([]byte, error) {
	type NoMethod Rollout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutPolicy: The policy for how automatic builds and rollouts are
// triggered and rolled out.
type RolloutPolicy struct {
	// CodebaseBranch: If set, specifies a branch that triggers a new build to be
	// started with this policy. Otherwise, no automatic rollouts will happen.
	CodebaseBranch string `json:"codebaseBranch,omitempty"`
	// Disabled: Optional. A flag that, if true, prevents automatic rollouts from
	// being created via this RolloutPolicy.
	Disabled bool `json:"disabled,omitempty"`
	// DisabledTime: Output only. If `disabled` is set, the time at which the
	// automatic rollouts were disabled.
	DisabledTime string `json:"disabledTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodebaseBranch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodebaseBranch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunConfig: Additional configuration to apply to the Cloud Run `service`
// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service).
type RunConfig struct {
	// Concurrency: Optional. Maximum number of requests that each Cloud Run
	// instance can receive. By default, each instance can receive Cloud Run's
	// default of up to 80 requests at the same time. Concurrency can be set to any
	// integer value up to 1000.
	Concurrency int64 `json:"concurrency,omitempty"`
	// Cpu: Optional. Number of CPUs used for each serving instance. By default,
	// cpu defaults to the Cloud Run's default of 1.0. CPU can be set to value 1,
	// 2, 4, 6, or 8 CPUs, and for less than 1 CPU, a value from 0.08 to less than
	// 1.00, in increments of 0.01. If you set a value of less than 1 CPU, you must
	// set concurrency to 1, and CPU will only be allocated during request
	// processing. Increasing CPUs limit may require increase in memory limits: - 4
	// CPUs: at least 2 GiB - 6 CPUs: at least 4 GiB - 8 CPUs: at least 4 GiB
	Cpu float64 `json:"cpu,omitempty"`
	// MaxInstances: Optional. Number of Cloud Run instances to maintain at maximum
	// for each revision. By default, each Cloud Run `service`
	// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service)
	// scales out to Cloud Run's default of a maximum of 100 instances. The maximum
	// max_instances limit is based on your quota. See
	// https://cloud.google.com/run/docs/configuring/max-instances#limits.
	MaxInstances int64 `json:"maxInstances,omitempty"`
	// MemoryMib: Optional. Amount of memory allocated for each serving instance in
	// MiB. By default, memory defaults to the Cloud Run's default where each
	// instance is allocated 512 MiB of memory. Memory can be set to any integer
	// value between 128 to 32768. Increasing memory limit may require increase in
	// CPUs limits: - Over 4 GiB: at least 2 CPUs - Over 8 GiB: at least 4 CPUs -
	// Over 16 GiB: at least 6 CPUs - Over 24 GiB: at least 8 CPUs
	MemoryMib int64 `json:"memoryMib,omitempty"`
	// MinInstances: Optional. Number of Cloud Run instances to maintain at minimum
	// for each Cloud Run Service. By default, there are no minimum. Even if the
	// service splits traffic across multiple revisions, the total number of
	// instances for a service will be capped at this value.
	MinInstances int64 `json:"minInstances,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Concurrency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Concurrency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RunConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RunConfig) UnmarshalJSON(data []byte) error {
	type NoMethod RunConfig
	var s1 struct {
		Cpu gensupport.JSONFloat64 `json:"cpu"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cpu = float64(s1.Cpu)
	return nil
}

// RunService: A managed Cloud Run `service`
// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service).
type RunService struct {
	// Service: Optional. The name of the Cloud Run `service`
	// (https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service),
	// in the format:
	// `projects/{project}/locations/{location}/services/{serviceId}`
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunService) MarshalJSON() ([]byte, error) {
	type NoMethod RunService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServingBehavior: Indicates whether App Hosting will serve content on the
// domain.
type ServingBehavior struct {
	// Redirect: Optional. Redirect behavior for a domain, if provided.
	Redirect *Redirect `json:"redirect,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Redirect") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Redirect") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServingBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod ServingBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SourceUserMetadata: Metadata for the user who started the build.
type SourceUserMetadata struct {
	// DisplayName: Output only. The user-chosen displayname. May be empty.
	DisplayName string `json:"displayName,omitempty"`
	// Email: Output only. The account email linked to the EUC that created the
	// build. May be a service account or other robot account.
	Email string `json:"email,omitempty"`
	// ImageUri: Output only. The URI of a profile photo associated with the user
	// who created the build.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SourceUserMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SourceUserMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Traffic: Controls traffic configuration for the backend.
type Traffic struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. Time at which the backend was created.
	CreateTime string `json:"createTime,omitempty"`
	// Current: Output only. Current state of traffic allocation for the backend.
	// When setting `target`, this field may differ for some time until the desired
	// state is reached.
	Current *TrafficSet `json:"current,omitempty"`
	// Etag: Output only. Server-computed checksum based on other values; may be
	// sent on update or delete to ensure operation is done on expected resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the backend's traffic. Format:
	// `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. A field that, if true, indicates that the system
	// is working to make the backend's `current` match the requested `target`
	// list.
	Reconciling bool `json:"reconciling,omitempty"`
	// RolloutPolicy: A rollout policy specifies how new builds and automatic
	// deployments are created.
	RolloutPolicy *RolloutPolicy `json:"rolloutPolicy,omitempty"`
	// Target: Set to manually control the desired traffic for the backend. This
	// will cause `current` to eventually match this value. The percentages must
	// add up to 100%.
	Target *TrafficSet `json:"target,omitempty"`
	// Uid: Output only. System-assigned, unique identifier.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. Time at which the backend was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Traffic) MarshalJSON() ([]byte, error) {
	type NoMethod Traffic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrafficSet: A list of traffic splits that together represent where traffic
// is being routed.
type TrafficSet struct {
	// Splits: Required. The list of traffic splits.
	Splits []*TrafficSplit `json:"splits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Splits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Splits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrafficSet) MarshalJSON() ([]byte, error) {
	type NoMethod TrafficSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrafficSplit: The traffic allocation for the backend.
type TrafficSplit struct {
	// Build: Required. The build that traffic is being routed to.
	Build string `json:"build,omitempty"`
	// Percent: Required. The percentage of traffic to send to the build. Currently
	// must be 100% or 0%.
	Percent int64 `json:"percent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Build") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Build") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrafficSplit) MarshalJSON() ([]byte, error) {
	type NoMethod TrafficSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserMetadata: Version control metadata for a user associated with a resolved
// codebase. Currently assumes a Git user.
type UserMetadata struct {
	// DisplayName: Output only. The 'name' field in a Git user's git.config.
	// Required by Git.
	DisplayName string `json:"displayName,omitempty"`
	// Email: Output only. The 'email' field in a Git user's git.config, if
	// available.
	Email string `json:"email,omitempty"`
	// ImageUri: Output only. The URI of an image file associated with the user's
	// account in an external source control provider, if available.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UserMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackendsCreateCall struct {
	s          *Service
	parent     string
	backend    *Backend
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new backend in a given project and location.
//
//   - parent: A parent name of the form
//     `projects/{project}/locations/{locationId}`.
func (r *ProjectsLocationsBackendsService) Create(parent string, backend *Backend) *ProjectsLocationsBackendsCreateCall {
	c := &ProjectsLocationsBackendsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backend = backend
	return c
}

// BackendId sets the optional parameter "backendId": Required. Id of the
// backend. Also used as the service ID for Cloud Run, and as part of the
// default domain name.
func (c *ProjectsLocationsBackendsCreateCall) BackendId(backendId string) *ProjectsLocationsBackendsCreateCall {
	c.urlParams_.Set("backendId", backendId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and t he request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsCreateCall) RequestId(requestId string) *ProjectsLocationsBackendsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsBackendsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackendsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backend)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/backends")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single backend.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsService) Delete(name string) *ProjectsLocationsBackendsDeleteCall {
	c := &ProjectsLocationsBackendsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag is out
// of date, delete will be returned FAILED_PRECONDITION error.
func (c *ProjectsLocationsBackendsDeleteCall) Etag(etag string) *ProjectsLocationsBackendsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": If set to true, any resources for
// this backend will also be deleted. Otherwise, any children resources will
// block deletion.
func (c *ProjectsLocationsBackendsDeleteCall) Force(force bool) *ProjectsLocationsBackendsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and t he request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsDeleteCall) RequestId(requestId string) *ProjectsLocationsBackendsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated, without persisting the request or updating any
// resources.
func (c *ProjectsLocationsBackendsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackendsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a backend.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsService) Get(name string) *ProjectsLocationsBackendsGetCall {
	c := &ProjectsLocationsBackendsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsGetCall) Context(ctx context.Context) *ProjectsLocationsBackendsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Backend.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsGetCall) Do(opts ...googleapi.CallOption) (*Backend, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Backend{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists backends in a given project and location.
//
//   - parent: A parent name of the form
//     `projects/{project}/locations/{locationId}`.
func (r *ProjectsLocationsBackendsService) List(parent string) *ProjectsLocationsBackendsListCall {
	c := &ProjectsLocationsBackendsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. Learn more about filtering in Google's AIP 160
// standard (https://google.aip.dev/160).
func (c *ProjectsLocationsBackendsListCall) Filter(filter string) *ProjectsLocationsBackendsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results. Supported fields are `name` and `createTime`. To specify descending
// order, append a `desc` suffix.
func (c *ProjectsLocationsBackendsListCall) OrderBy(orderBy string) *ProjectsLocationsBackendsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsBackendsListCall) PageSize(pageSize int64) *ProjectsLocationsBackendsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the nextPageToken field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsBackendsListCall) PageToken(pageToken string) *ProjectsLocationsBackendsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, the request
// returns soft-deleted resources that haven't been fully-deleted yet.
func (c *ProjectsLocationsBackendsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsBackendsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsListCall) Context(ctx context.Context) *ProjectsLocationsBackendsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/backends")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackendsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBackendsListCall) Do(opts ...googleapi.CallOption) (*ListBackendsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackendsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackendsListCall) Pages(ctx context.Context, f func(*ListBackendsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackendsPatchCall struct {
	s          *Service
	name       string
	backend    *Backend
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the information for a single backend.
//
//   - name: Identifier. The resource name of the backend. Format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsService) Patch(name string, backend *Backend) *ProjectsLocationsBackendsPatchCall {
	c := &ProjectsLocationsBackendsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backend = backend
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// the backend is not found, a new backend will be created.
func (c *ProjectsLocationsBackendsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsBackendsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and t he request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsPatchCall) RequestId(requestId string) *ProjectsLocationsBackendsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the backend resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsBackendsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackendsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated, without persisting the request or updating any
// resources.
func (c *ProjectsLocationsBackendsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsPatchCall) Context(ctx context.Context) *ProjectsLocationsBackendsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backend)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsBuildsCreateCall struct {
	s          *Service
	parent     string
	build      *Build
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new build for a backend.
//
//   - parent: The parent backend in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsBuildsService) Create(parent string, build *Build) *ProjectsLocationsBackendsBuildsCreateCall {
	c := &ProjectsLocationsBackendsBuildsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.build = build
	return c
}

// BuildId sets the optional parameter "buildId": Required. Desired ID of the
// build being created.
func (c *ProjectsLocationsBackendsBuildsCreateCall) BuildId(buildId string) *ProjectsLocationsBackendsBuildsCreateCall {
	c.urlParams_.Set("buildId", buildId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsBuildsCreateCall) RequestId(requestId string) *ProjectsLocationsBackendsBuildsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsBackendsBuildsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsBuildsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsBuildsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsBuildsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsBuildsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackendsBuildsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsBuildsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsBuildsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.build)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/builds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.builds.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsBuildsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsBuildsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single build.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{bui
//     ldId}`.
func (r *ProjectsLocationsBackendsBuildsService) Delete(name string) *ProjectsLocationsBackendsBuildsDeleteCall {
	c := &ProjectsLocationsBackendsBuildsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag is out
// of date, delete will be returned FAILED_PRECONDITION error.
func (c *ProjectsLocationsBackendsBuildsDeleteCall) Etag(etag string) *ProjectsLocationsBackendsBuildsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsBuildsDeleteCall) RequestId(requestId string) *ProjectsLocationsBackendsBuildsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or deleting any resources.
func (c *ProjectsLocationsBackendsBuildsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsBuildsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsBuildsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsBuildsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsBuildsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackendsBuildsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsBuildsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsBuildsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.builds.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsBuildsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsBuildsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a build.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{bui
//     ldId}`.
func (r *ProjectsLocationsBackendsBuildsService) Get(name string) *ProjectsLocationsBackendsBuildsGetCall {
	c := &ProjectsLocationsBackendsBuildsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsBuildsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsBuildsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsBuildsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsBuildsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsBuildsGetCall) Context(ctx context.Context) *ProjectsLocationsBackendsBuildsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsBuildsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsBuildsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.builds.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Build.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsBuildsGetCall) Do(opts ...googleapi.CallOption) (*Build, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Build{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsBuildsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists builds in a given project, location, and backend.
//
//   - parent: The parent backend in the form
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsBuildsService) List(parent string) *ProjectsLocationsBackendsBuildsListCall {
	c := &ProjectsLocationsBackendsBuildsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. Learn more about filtering in Google's AIP 160
// standard (https://google.aip.dev/160).
func (c *ProjectsLocationsBackendsBuildsListCall) Filter(filter string) *ProjectsLocationsBackendsBuildsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results. Supported fields are `name` and `createTime`. To specify descending
// order, append a `desc` suffix.
func (c *ProjectsLocationsBackendsBuildsListCall) OrderBy(orderBy string) *ProjectsLocationsBackendsBuildsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsBackendsBuildsListCall) PageSize(pageSize int64) *ProjectsLocationsBackendsBuildsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the nextPageToken field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsBackendsBuildsListCall) PageToken(pageToken string) *ProjectsLocationsBackendsBuildsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, the request
// returns soft-deleted resources that haven't been fully-deleted yet.
func (c *ProjectsLocationsBackendsBuildsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsBackendsBuildsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsBuildsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsBuildsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsBuildsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsBuildsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsBuildsListCall) Context(ctx context.Context) *ProjectsLocationsBackendsBuildsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsBuildsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsBuildsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/builds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.builds.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBuildsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBackendsBuildsListCall) Do(opts ...googleapi.CallOption) (*ListBuildsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBuildsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.builds.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackendsBuildsListCall) Pages(ctx context.Context, f func(*ListBuildsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackendsDomainsCreateCall struct {
	s          *Service
	parent     string
	domain     *Domain
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Links a new domain to a backend.
//
//   - parent: The parent backend in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsDomainsService) Create(parent string, domain *Domain) *ProjectsLocationsBackendsDomainsCreateCall {
	c := &ProjectsLocationsBackendsDomainsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.domain = domain
	return c
}

// DomainId sets the optional parameter "domainId": Required. Id of the domain
// to create. Must be a valid domain name.
func (c *ProjectsLocationsBackendsDomainsCreateCall) DomainId(domainId string) *ProjectsLocationsBackendsDomainsCreateCall {
	c.urlParams_.Set("domainId", domainId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsDomainsCreateCall) RequestId(requestId string) *ProjectsLocationsBackendsDomainsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsBackendsDomainsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsDomainsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsDomainsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsDomainsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsDomainsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackendsDomainsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsDomainsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsDomainsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.domain)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/domains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.domains.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsDomainsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsDomainsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single domain.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{do
//     mainId}`.
func (r *ProjectsLocationsBackendsDomainsService) Delete(name string) *ProjectsLocationsBackendsDomainsDeleteCall {
	c := &ProjectsLocationsBackendsDomainsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag is out
// of date, delete will be returned FAILED_PRECONDITION error.
func (c *ProjectsLocationsBackendsDomainsDeleteCall) Etag(etag string) *ProjectsLocationsBackendsDomainsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsDomainsDeleteCall) RequestId(requestId string) *ProjectsLocationsBackendsDomainsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or deleting any resources.
func (c *ProjectsLocationsBackendsDomainsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsDomainsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsDomainsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsDomainsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsDomainsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackendsDomainsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsDomainsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsDomainsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.domains.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsDomainsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsDomainsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a domain.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{do
//     mainId}`.
func (r *ProjectsLocationsBackendsDomainsService) Get(name string) *ProjectsLocationsBackendsDomainsGetCall {
	c := &ProjectsLocationsBackendsDomainsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsDomainsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsDomainsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsDomainsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsDomainsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsDomainsGetCall) Context(ctx context.Context) *ProjectsLocationsBackendsDomainsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsDomainsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsDomainsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.domains.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Domain.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsDomainsGetCall) Do(opts ...googleapi.CallOption) (*Domain, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Domain{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsDomainsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists domains of a backend.
//
//   - parent: The parent backend in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsDomainsService) List(parent string) *ProjectsLocationsBackendsDomainsListCall {
	c := &ProjectsLocationsBackendsDomainsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. Learn more about filtering in Google's AIP 160
// standard (https://google.aip.dev/160).
func (c *ProjectsLocationsBackendsDomainsListCall) Filter(filter string) *ProjectsLocationsBackendsDomainsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results. Supported fields are `name` and `createTime`. To specify descending
// order, append a `desc` suffix.
func (c *ProjectsLocationsBackendsDomainsListCall) OrderBy(orderBy string) *ProjectsLocationsBackendsDomainsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsBackendsDomainsListCall) PageSize(pageSize int64) *ProjectsLocationsBackendsDomainsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the nextPageToken field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsBackendsDomainsListCall) PageToken(pageToken string) *ProjectsLocationsBackendsDomainsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, the request
// returns soft-deleted resources that haven't been fully-deleted yet.
func (c *ProjectsLocationsBackendsDomainsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsBackendsDomainsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsDomainsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsDomainsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsDomainsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsDomainsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsDomainsListCall) Context(ctx context.Context) *ProjectsLocationsBackendsDomainsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsDomainsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsDomainsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/domains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.domains.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDomainsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBackendsDomainsListCall) Do(opts ...googleapi.CallOption) (*ListDomainsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDomainsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackendsDomainsListCall) Pages(ctx context.Context, f func(*ListDomainsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackendsDomainsPatchCall struct {
	s          *Service
	name       string
	domain     *Domain
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the information for a single domain.
//
//   - name: Identifier. The resource name of the domain, e.g.
//     `/projects/p/locations/l/backends/b/domains/foo.com`.
func (r *ProjectsLocationsBackendsDomainsService) Patch(name string, domain *Domain) *ProjectsLocationsBackendsDomainsPatchCall {
	c := &ProjectsLocationsBackendsDomainsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.domain = domain
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// the domain is not found, a new domain will be created.
func (c *ProjectsLocationsBackendsDomainsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsBackendsDomainsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsDomainsPatchCall) RequestId(requestId string) *ProjectsLocationsBackendsDomainsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Domain resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsBackendsDomainsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackendsDomainsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or modifying any resources.
func (c *ProjectsLocationsBackendsDomainsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsDomainsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsDomainsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsDomainsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsDomainsPatchCall) Context(ctx context.Context) *ProjectsLocationsBackendsDomainsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsDomainsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsDomainsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.domain)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.domains.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsDomainsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.domains.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsRolloutsCreateCall struct {
	s          *Service
	parent     string
	rollout    *Rollout
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new rollout for a backend.
//
//   - parent: The parent backend in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsRolloutsService) Create(parent string, rollout *Rollout) *ProjectsLocationsBackendsRolloutsCreateCall {
	c := &ProjectsLocationsBackendsRolloutsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rollout = rollout
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsRolloutsCreateCall) RequestId(requestId string) *ProjectsLocationsBackendsRolloutsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// RolloutId sets the optional parameter "rolloutId": Desired ID of the rollout
// being created.
func (c *ProjectsLocationsBackendsRolloutsCreateCall) RolloutId(rolloutId string) *ProjectsLocationsBackendsRolloutsCreateCall {
	c.urlParams_.Set("rolloutId", rolloutId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsBackendsRolloutsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsRolloutsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsRolloutsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsRolloutsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsRolloutsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackendsRolloutsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsRolloutsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsRolloutsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollout)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/rollouts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.rollouts.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.rollouts.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsRolloutsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.rollouts.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsRolloutsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a rollout.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/rollouts/{r
//     olloutId}`.
func (r *ProjectsLocationsBackendsRolloutsService) Get(name string) *ProjectsLocationsBackendsRolloutsGetCall {
	c := &ProjectsLocationsBackendsRolloutsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsRolloutsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsRolloutsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsRolloutsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsRolloutsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsRolloutsGetCall) Context(ctx context.Context) *ProjectsLocationsBackendsRolloutsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsRolloutsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsRolloutsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.rollouts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.rollouts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rollout.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsRolloutsGetCall) Do(opts ...googleapi.CallOption) (*Rollout, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rollout{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.rollouts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsRolloutsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists rollouts for a backend.
//
//   - parent: The parent backend in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}`.
func (r *ProjectsLocationsBackendsRolloutsService) List(parent string) *ProjectsLocationsBackendsRolloutsListCall {
	c := &ProjectsLocationsBackendsRolloutsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. Learn more about filtering in Google's AIP 160
// standard (https://google.aip.dev/160).
func (c *ProjectsLocationsBackendsRolloutsListCall) Filter(filter string) *ProjectsLocationsBackendsRolloutsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results. Supported fields are `name` and `createTime`. To specify descending
// order, append a `desc` suffix.
func (c *ProjectsLocationsBackendsRolloutsListCall) OrderBy(orderBy string) *ProjectsLocationsBackendsRolloutsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsBackendsRolloutsListCall) PageSize(pageSize int64) *ProjectsLocationsBackendsRolloutsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the nextPageToken field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsBackendsRolloutsListCall) PageToken(pageToken string) *ProjectsLocationsBackendsRolloutsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, the request
// returns soft-deleted resources that haven't been fully-deleted yet.
func (c *ProjectsLocationsBackendsRolloutsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsBackendsRolloutsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsRolloutsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsRolloutsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsRolloutsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsRolloutsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsRolloutsListCall) Context(ctx context.Context) *ProjectsLocationsBackendsRolloutsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsRolloutsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsRolloutsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/rollouts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.rollouts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.rollouts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRolloutsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBackendsRolloutsListCall) Do(opts ...googleapi.CallOption) (*ListRolloutsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRolloutsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.rollouts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackendsRolloutsListCall) Pages(ctx context.Context, f func(*ListRolloutsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackendsTrafficGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a backend's traffic.
//
//   - name: Name of the resource in the format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
func (r *ProjectsLocationsBackendsTrafficService) Get(name string) *ProjectsLocationsBackendsTrafficGetCall {
	c := &ProjectsLocationsBackendsTrafficGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsTrafficGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsTrafficGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendsTrafficGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendsTrafficGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsTrafficGetCall) Context(ctx context.Context) *ProjectsLocationsBackendsTrafficGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsTrafficGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsTrafficGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.traffic.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.traffic.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Traffic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsTrafficGetCall) Do(opts ...googleapi.CallOption) (*Traffic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Traffic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.traffic.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendsTrafficPatchCall struct {
	s          *Service
	name       string
	traffic    *Traffic
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a backend's traffic.
//
//   - name: Identifier. The resource name of the backend's traffic. Format:
//     `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
func (r *ProjectsLocationsBackendsTrafficService) Patch(name string, traffic *Traffic) *ProjectsLocationsBackendsTrafficPatchCall {
	c := &ProjectsLocationsBackendsTrafficPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.traffic = traffic
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and t he request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsBackendsTrafficPatchCall) RequestId(requestId string) *ProjectsLocationsBackendsTrafficPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the traffic resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsBackendsTrafficPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackendsTrafficPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated, without persisting the request or updating any
// resources.
func (c *ProjectsLocationsBackendsTrafficPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBackendsTrafficPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendsTrafficPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendsTrafficPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendsTrafficPatchCall) Context(ctx context.Context) *ProjectsLocationsBackendsTrafficPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendsTrafficPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendsTrafficPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.traffic)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.traffic.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.backends.traffic.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendsTrafficPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.backends.traffic.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// [ListOperationsResponse.unreachable] field. This can only be `true` when
// reading across collections e.g. when `parent` is set to
// "projects/example/locations/-". This field is not by default supported and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseapphosting.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseapphosting.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
