// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package pubsublite provides access to the Pub/Sub Lite API.
//
// For product documentation, see: https://cloud.google.com/pubsub/lite/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/pubsublite/v1"
//	...
//	ctx := context.Background()
//	pubsubliteService, err := pubsublite.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	pubsubliteService, err := pubsublite.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	pubsubliteService, err := pubsublite.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package pubsublite // import "google.golang.org/api/pubsublite/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "pubsublite:v1"
const apiName = "pubsublite"
const apiVersion = "v1"
const basePath = "https://pubsublite.googleapis.com/"
const basePathTemplate = "https://pubsublite.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://pubsublite.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Admin = NewAdminService(s)
	s.Cursor = NewCursorService(s)
	s.TopicStats = NewTopicStatsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Admin *AdminService

	Cursor *CursorService

	TopicStats *TopicStatsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAdminService(s *Service) *AdminService {
	rs := &AdminService{s: s}
	rs.Projects = NewAdminProjectsService(s)
	return rs
}

type AdminService struct {
	s *Service

	Projects *AdminProjectsService
}

func NewAdminProjectsService(s *Service) *AdminProjectsService {
	rs := &AdminProjectsService{s: s}
	rs.Locations = NewAdminProjectsLocationsService(s)
	return rs
}

type AdminProjectsService struct {
	s *Service

	Locations *AdminProjectsLocationsService
}

func NewAdminProjectsLocationsService(s *Service) *AdminProjectsLocationsService {
	rs := &AdminProjectsLocationsService{s: s}
	rs.Operations = NewAdminProjectsLocationsOperationsService(s)
	rs.Reservations = NewAdminProjectsLocationsReservationsService(s)
	rs.Subscriptions = NewAdminProjectsLocationsSubscriptionsService(s)
	rs.Topics = NewAdminProjectsLocationsTopicsService(s)
	return rs
}

type AdminProjectsLocationsService struct {
	s *Service

	Operations *AdminProjectsLocationsOperationsService

	Reservations *AdminProjectsLocationsReservationsService

	Subscriptions *AdminProjectsLocationsSubscriptionsService

	Topics *AdminProjectsLocationsTopicsService
}

func NewAdminProjectsLocationsOperationsService(s *Service) *AdminProjectsLocationsOperationsService {
	rs := &AdminProjectsLocationsOperationsService{s: s}
	return rs
}

type AdminProjectsLocationsOperationsService struct {
	s *Service
}

func NewAdminProjectsLocationsReservationsService(s *Service) *AdminProjectsLocationsReservationsService {
	rs := &AdminProjectsLocationsReservationsService{s: s}
	rs.Topics = NewAdminProjectsLocationsReservationsTopicsService(s)
	return rs
}

type AdminProjectsLocationsReservationsService struct {
	s *Service

	Topics *AdminProjectsLocationsReservationsTopicsService
}

func NewAdminProjectsLocationsReservationsTopicsService(s *Service) *AdminProjectsLocationsReservationsTopicsService {
	rs := &AdminProjectsLocationsReservationsTopicsService{s: s}
	return rs
}

type AdminProjectsLocationsReservationsTopicsService struct {
	s *Service
}

func NewAdminProjectsLocationsSubscriptionsService(s *Service) *AdminProjectsLocationsSubscriptionsService {
	rs := &AdminProjectsLocationsSubscriptionsService{s: s}
	return rs
}

type AdminProjectsLocationsSubscriptionsService struct {
	s *Service
}

func NewAdminProjectsLocationsTopicsService(s *Service) *AdminProjectsLocationsTopicsService {
	rs := &AdminProjectsLocationsTopicsService{s: s}
	rs.Subscriptions = NewAdminProjectsLocationsTopicsSubscriptionsService(s)
	return rs
}

type AdminProjectsLocationsTopicsService struct {
	s *Service

	Subscriptions *AdminProjectsLocationsTopicsSubscriptionsService
}

func NewAdminProjectsLocationsTopicsSubscriptionsService(s *Service) *AdminProjectsLocationsTopicsSubscriptionsService {
	rs := &AdminProjectsLocationsTopicsSubscriptionsService{s: s}
	return rs
}

type AdminProjectsLocationsTopicsSubscriptionsService struct {
	s *Service
}

func NewCursorService(s *Service) *CursorService {
	rs := &CursorService{s: s}
	rs.Projects = NewCursorProjectsService(s)
	return rs
}

type CursorService struct {
	s *Service

	Projects *CursorProjectsService
}

func NewCursorProjectsService(s *Service) *CursorProjectsService {
	rs := &CursorProjectsService{s: s}
	rs.Locations = NewCursorProjectsLocationsService(s)
	return rs
}

type CursorProjectsService struct {
	s *Service

	Locations *CursorProjectsLocationsService
}

func NewCursorProjectsLocationsService(s *Service) *CursorProjectsLocationsService {
	rs := &CursorProjectsLocationsService{s: s}
	rs.Subscriptions = NewCursorProjectsLocationsSubscriptionsService(s)
	return rs
}

type CursorProjectsLocationsService struct {
	s *Service

	Subscriptions *CursorProjectsLocationsSubscriptionsService
}

func NewCursorProjectsLocationsSubscriptionsService(s *Service) *CursorProjectsLocationsSubscriptionsService {
	rs := &CursorProjectsLocationsSubscriptionsService{s: s}
	rs.Cursors = NewCursorProjectsLocationsSubscriptionsCursorsService(s)
	return rs
}

type CursorProjectsLocationsSubscriptionsService struct {
	s *Service

	Cursors *CursorProjectsLocationsSubscriptionsCursorsService
}

func NewCursorProjectsLocationsSubscriptionsCursorsService(s *Service) *CursorProjectsLocationsSubscriptionsCursorsService {
	rs := &CursorProjectsLocationsSubscriptionsCursorsService{s: s}
	return rs
}

type CursorProjectsLocationsSubscriptionsCursorsService struct {
	s *Service
}

func NewTopicStatsService(s *Service) *TopicStatsService {
	rs := &TopicStatsService{s: s}
	rs.Projects = NewTopicStatsProjectsService(s)
	return rs
}

type TopicStatsService struct {
	s *Service

	Projects *TopicStatsProjectsService
}

func NewTopicStatsProjectsService(s *Service) *TopicStatsProjectsService {
	rs := &TopicStatsProjectsService{s: s}
	rs.Locations = NewTopicStatsProjectsLocationsService(s)
	return rs
}

type TopicStatsProjectsService struct {
	s *Service

	Locations *TopicStatsProjectsLocationsService
}

func NewTopicStatsProjectsLocationsService(s *Service) *TopicStatsProjectsLocationsService {
	rs := &TopicStatsProjectsLocationsService{s: s}
	rs.Topics = NewTopicStatsProjectsLocationsTopicsService(s)
	return rs
}

type TopicStatsProjectsLocationsService struct {
	s *Service

	Topics *TopicStatsProjectsLocationsTopicsService
}

func NewTopicStatsProjectsLocationsTopicsService(s *Service) *TopicStatsProjectsLocationsTopicsService {
	rs := &TopicStatsProjectsLocationsTopicsService{s: s}
	return rs
}

type TopicStatsProjectsLocationsTopicsService struct {
	s *Service
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// Capacity: The throughput capacity configuration for each partition.
type Capacity struct {
	// PublishMibPerSec: Publish throughput capacity per partition in MiB/s. Must
	// be >= 4 and <= 16.
	PublishMibPerSec int64 `json:"publishMibPerSec,omitempty"`
	// SubscribeMibPerSec: Subscribe throughput capacity per partition in MiB/s.
	// Must be >= 4 and <= 32.
	SubscribeMibPerSec int64 `json:"subscribeMibPerSec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublishMibPerSec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublishMibPerSec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Capacity) MarshalJSON() ([]byte, error) {
	type NoMethod Capacity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommitCursorRequest: Request for CommitCursor.
type CommitCursorRequest struct {
	// Cursor: The new value for the committed cursor.
	Cursor *Cursor `json:"cursor,omitempty"`
	// Partition: The partition for which to update the cursor. Partitions are zero
	// indexed, so `partition` must be in the range [0, topic.num_partitions).
	Partition int64 `json:"partition,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Cursor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommitCursorRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CommitCursorRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommitCursorResponse: Response for CommitCursor.
type CommitCursorResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ComputeHeadCursorRequest: Compute the current head cursor for a partition.
type ComputeHeadCursorRequest struct {
	// Partition: Required. The partition for which we should compute the head
	// cursor.
	Partition int64 `json:"partition,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Partition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Partition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeHeadCursorRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeHeadCursorRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeHeadCursorResponse: Response containing the head cursor for the
// requested topic and partition.
type ComputeHeadCursorResponse struct {
	// HeadCursor: The head cursor.
	HeadCursor *Cursor `json:"headCursor,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HeadCursor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HeadCursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeHeadCursorResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeHeadCursorResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeMessageStatsRequest: Compute statistics about a range of messages in
// a given topic and partition.
type ComputeMessageStatsRequest struct {
	// EndCursor: The exclusive end of the range. The range is empty if end_cursor
	// <= start_cursor. Specifying a start_cursor before the first message and an
	// end_cursor after the last message will retrieve all messages.
	EndCursor *Cursor `json:"endCursor,omitempty"`
	// Partition: Required. The partition for which we should compute message
	// stats.
	Partition int64 `json:"partition,omitempty,string"`
	// StartCursor: The inclusive start of the range.
	StartCursor *Cursor `json:"startCursor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndCursor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndCursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeMessageStatsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeMessageStatsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeMessageStatsResponse: Response containing stats for messages in the
// requested topic and partition.
type ComputeMessageStatsResponse struct {
	// MessageBytes: The number of quota bytes accounted to these messages.
	MessageBytes int64 `json:"messageBytes,omitempty,string"`
	// MessageCount: The count of messages.
	MessageCount int64 `json:"messageCount,omitempty,string"`
	// MinimumEventTime: The minimum event timestamp across these messages. For the
	// purposes of this computation, if a message does not have an event time, we
	// use the publish time. The timestamp will be unset if there are no messages.
	MinimumEventTime string `json:"minimumEventTime,omitempty"`
	// MinimumPublishTime: The minimum publish timestamp across these messages.
	// Note that publish timestamps within a partition are not guaranteed to be
	// non-decreasing. The timestamp will be unset if there are no messages.
	MinimumPublishTime string `json:"minimumPublishTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MessageBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeMessageStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeMessageStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeTimeCursorRequest: Compute the corresponding cursor for a publish or
// event time in a topic partition.
type ComputeTimeCursorRequest struct {
	// Partition: Required. The partition for which we should compute the cursor.
	Partition int64 `json:"partition,omitempty,string"`
	// Target: Required. The target publish or event time. Specifying a future time
	// will return an unset cursor.
	Target *TimeTarget `json:"target,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Partition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Partition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeTimeCursorRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeTimeCursorRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeTimeCursorResponse: Response containing the cursor corresponding to a
// publish or event time in a topic partition.
type ComputeTimeCursorResponse struct {
	// Cursor: If present, the cursor references the first message with time
	// greater than or equal to the specified target time. If such a message cannot
	// be found, the cursor will be unset (i.e. `cursor` is not present).
	Cursor *Cursor `json:"cursor,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Cursor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeTimeCursorResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeTimeCursorResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Cursor: A cursor that describes the position of a message within a topic
// partition.
type Cursor struct {
	// Offset: The offset of a message within a topic partition. Must be greater
	// than or equal 0.
	Offset int64 `json:"offset,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Offset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Offset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Cursor) MarshalJSON() ([]byte, error) {
	type NoMethod Cursor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeliveryConfig: The settings for a subscription's message delivery.
type DeliveryConfig struct {
	// DeliveryRequirement: The DeliveryRequirement for this subscription.
	//
	// Possible values:
	//   "DELIVERY_REQUIREMENT_UNSPECIFIED" - Default value. This value is unused.
	//   "DELIVER_IMMEDIATELY" - The server does not wait for a published message
	// to be successfully written to storage before delivering it to subscribers.
	//   "DELIVER_AFTER_STORED" - The server will not deliver a published message
	// to subscribers until the message has been successfully written to storage.
	// This will result in higher end-to-end latency, but consistent delivery.
	DeliveryRequirement string `json:"deliveryRequirement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeliveryRequirement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeliveryRequirement") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeliveryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExportConfig: Configuration for a Pub/Sub Lite subscription that writes
// messages to a destination. User subscriber clients must not connect to this
// subscription.
type ExportConfig struct {
	// CurrentState: Output only. The current state of the export, which may be
	// different to the desired state due to errors. This field is output only.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACTIVE" - Messages are being exported.
	//   "PAUSED" - Exporting messages is suspended.
	//   "PERMISSION_DENIED" - Messages cannot be exported due to permission denied
	// errors. Output only.
	//   "NOT_FOUND" - Messages cannot be exported due to missing resources. Output
	// only.
	CurrentState string `json:"currentState,omitempty"`
	// DeadLetterTopic: Optional. The name of an optional Pub/Sub Lite topic to
	// publish messages that can not be exported to the destination. For example,
	// the message can not be published to the Pub/Sub service because it does not
	// satisfy the constraints documented at
	// https://cloud.google.com/pubsub/docs/publisher. Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}. Must be
	// within the same project and location as the subscription. The topic may be
	// changed or removed.
	DeadLetterTopic string `json:"deadLetterTopic,omitempty"`
	// DesiredState: The desired state of this export. Setting this to values other
	// than `ACTIVE` and `PAUSED` will result in an error.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACTIVE" - Messages are being exported.
	//   "PAUSED" - Exporting messages is suspended.
	//   "PERMISSION_DENIED" - Messages cannot be exported due to permission denied
	// errors. Output only.
	//   "NOT_FOUND" - Messages cannot be exported due to missing resources. Output
	// only.
	DesiredState string `json:"desiredState,omitempty"`
	// PubsubConfig: Messages are automatically written from the Pub/Sub Lite topic
	// associated with this subscription to a Pub/Sub topic.
	PubsubConfig *PubSubConfig `json:"pubsubConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExportConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections e.g. when attempting to list all resources across all supported
	// locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPartitionCursorsResponse: Response for ListPartitionCursors
type ListPartitionCursorsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PartitionCursors: The partition cursors from this request.
	PartitionCursors []*PartitionCursor `json:"partitionCursors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPartitionCursorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPartitionCursorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReservationTopicsResponse: Response for ListReservationTopics.
type ListReservationTopicsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page of results. If this field is omitted, there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Topics: The names of topics attached to the reservation. The order of the
	// topics is unspecified.
	Topics []string `json:"topics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReservationTopicsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReservationTopicsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReservationsResponse: Response for ListReservations.
type ListReservationsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page of results. If this field is omitted, there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Reservations: The list of reservation in the requested parent. The order of
	// the reservations is unspecified.
	Reservations []*Reservation `json:"reservations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReservationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReservationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSubscriptionsResponse: Response for ListSubscriptions.
type ListSubscriptionsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page of results. If this field is omitted, there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Subscriptions: The list of subscriptions in the requested parent. The order
	// of the subscriptions is unspecified.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSubscriptionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTopicSubscriptionsResponse: Response for ListTopicSubscriptions.
type ListTopicSubscriptionsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page of results. If this field is omitted, there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Subscriptions: The names of subscriptions attached to the topic. The order
	// of the subscriptions is unspecified.
	Subscriptions []string `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTopicSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTopicSubscriptionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTopicsResponse: Response for ListTopics.
type ListTopicsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page of results. If this field is omitted, there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Topics: The list of topic in the requested parent. The order of the topics
	// is unspecified.
	Topics []*Topic `json:"topics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTopicsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTopicsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Metadata for long running operations.
type OperationMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running. Not set if the operation
	// has not completed.
	EndTime string `json:"endTime,omitempty"`
	// Target: Resource path for the target of the operation. For example, targets
	// of seeks are subscription resources, structured like:
	// projects/{project_number}/locations/{location}/subscriptions/{subscription_id
	// }
	Target string `json:"target,omitempty"`
	// Verb: Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionConfig: The settings for a topic's partitions.
type PartitionConfig struct {
	// Capacity: The capacity configuration.
	Capacity *Capacity `json:"capacity,omitempty"`
	// Count: The number of partitions in the topic. Must be at least 1. Once a
	// topic has been created the number of partitions can be increased but not
	// decreased. Message ordering is not guaranteed across a topic resize. For
	// more information see
	// https://cloud.google.com/pubsub/lite/docs/topics#scaling_capacity
	Count int64 `json:"count,omitempty,string"`
	// Scale: DEPRECATED: Use capacity instead which can express a superset of
	// configurations. Every partition in the topic is allocated throughput
	// equivalent to `scale` times the standard partition throughput (4 MiB/s).
	// This is also reflected in the cost of this topic; a topic with `scale` of 2
	// and count of 10 is charged for 20 partitions. This value must be in the
	// range [1,4].
	Scale int64 `json:"scale,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Capacity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Capacity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionCursor: A pair of a Cursor and the partition it is for.
type PartitionCursor struct {
	// Cursor: The value of the cursor.
	Cursor *Cursor `json:"cursor,omitempty"`
	// Partition: The partition this is for.
	Partition int64 `json:"partition,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Cursor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionCursor) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionCursor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubSubConfig: Configuration for exporting to a Pub/Sub topic.
type PubSubConfig struct {
	// Topic: The name of the Pub/Sub topic. Structured like:
	// projects/{project_number}/topics/{topic_id}. The topic may be changed.
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Topic") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Topic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PubSubConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PubSubConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Reservation: Metadata about a reservation resource.
type Reservation struct {
	// Name: The name of the reservation. Structured like:
	// projects/{project_number}/locations/{location}/reservations/{reservation_id}
	Name string `json:"name,omitempty"`
	// ThroughputCapacity: The reserved throughput capacity. Every unit of
	// throughput capacity is equivalent to 1 MiB/s of published messages or 2
	// MiB/s of subscribed messages. Any topics which are declared as using
	// capacity from a Reservation will consume resources from this reservation
	// instead of being charged individually.
	ThroughputCapacity int64 `json:"throughputCapacity,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reservation) MarshalJSON() ([]byte, error) {
	type NoMethod Reservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReservationConfig: The settings for this topic's Reservation usage.
type ReservationConfig struct {
	// ThroughputReservation: The Reservation to use for this topic's throughput
	// capacity. Structured like:
	// projects/{project_number}/locations/{location}/reservations/{reservation_id}
	ThroughputReservation string `json:"throughputReservation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ThroughputReservation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ThroughputReservation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReservationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ReservationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RetentionConfig: The settings for a topic's message retention.
type RetentionConfig struct {
	// PerPartitionBytes: The provisioned storage, in bytes, per partition. If the
	// number of bytes stored in any of the topic's partitions grows beyond this
	// value, older messages will be dropped to make room for newer ones,
	// regardless of the value of `period`.
	PerPartitionBytes int64 `json:"perPartitionBytes,omitempty,string"`
	// Period: How long a published message is retained. If unset, messages will be
	// retained as long as the bytes retained for each partition is below
	// `per_partition_bytes`.
	Period string `json:"period,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PerPartitionBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PerPartitionBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetentionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RetentionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SeekSubscriptionRequest: Request for SeekSubscription.
type SeekSubscriptionRequest struct {
	// NamedTarget: Seek to a named position with respect to the message backlog.
	//
	// Possible values:
	//   "NAMED_TARGET_UNSPECIFIED" - Unspecified named target. Do not use.
	//   "TAIL" - Seek to the oldest retained message.
	//   "HEAD" - Seek past all recently published messages, skipping the entire
	// message backlog.
	NamedTarget string `json:"namedTarget,omitempty"`
	// TimeTarget: Seek to the first message whose publish or event time is greater
	// than or equal to the specified query time. If no such message can be
	// located, will seek to the end of the message backlog.
	TimeTarget *TimeTarget `json:"timeTarget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamedTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamedTarget") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SeekSubscriptionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SeekSubscriptionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SeekSubscriptionResponse: Response for SeekSubscription long running
// operation.
type SeekSubscriptionResponse struct {
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Subscription: Metadata about a subscription resource.
type Subscription struct {
	// DeliveryConfig: The settings for this subscription's message delivery.
	DeliveryConfig *DeliveryConfig `json:"deliveryConfig,omitempty"`
	// ExportConfig: If present, messages are automatically written from the
	// Pub/Sub Lite topic associated with this subscription to a destination.
	ExportConfig *ExportConfig `json:"exportConfig,omitempty"`
	// Name: The name of the subscription. Structured like:
	// projects/{project_number}/locations/{location}/subscriptions/{subscription_id
	// }
	Name string `json:"name,omitempty"`
	// Topic: The name of the topic this subscription is attached to. Structured
	// like: projects/{project_number}/locations/{location}/topics/{topic_id}
	Topic string `json:"topic,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeliveryConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeliveryConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod Subscription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeTarget: A target publish or event time. Can be used for seeking to or
// retrieving the corresponding cursor.
type TimeTarget struct {
	// EventTime: Request the cursor of the first message with event time greater
	// than or equal to `event_time`. If messages are missing an event time, the
	// publish time is used as a fallback. As event times are user supplied,
	// subsequent messages may have event times less than `event_time` and should
	// be filtered by the client, if necessary.
	EventTime string `json:"eventTime,omitempty"`
	// PublishTime: Request the cursor of the first message with publish time
	// greater than or equal to `publish_time`. All messages thereafter are
	// guaranteed to have publish times >= `publish_time`.
	PublishTime string `json:"publishTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EventTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeTarget) MarshalJSON() ([]byte, error) {
	type NoMethod TimeTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Topic: Metadata about a topic resource.
type Topic struct {
	// Name: The name of the topic. Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}
	Name string `json:"name,omitempty"`
	// PartitionConfig: The settings for this topic's partitions.
	PartitionConfig *PartitionConfig `json:"partitionConfig,omitempty"`
	// ReservationConfig: The settings for this topic's Reservation usage.
	ReservationConfig *ReservationConfig `json:"reservationConfig,omitempty"`
	// RetentionConfig: The settings for this topic's message retention.
	RetentionConfig *RetentionConfig `json:"retentionConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Topic) MarshalJSON() ([]byte, error) {
	type NoMethod Topic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TopicPartitions: Response for GetTopicPartitions.
type TopicPartitions struct {
	// PartitionCount: The number of partitions in the topic.
	PartitionCount int64 `json:"partitionCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PartitionCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartitionCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TopicPartitions) MarshalJSON() ([]byte, error) {
	type NoMethod TopicPartitions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AdminProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *AdminProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *AdminProjectsLocationsOperationsCancelCall {
	c := &AdminProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *AdminProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *AdminProjectsLocationsOperationsService) Delete(name string) *AdminProjectsLocationsOperationsDeleteCall {
	c := &AdminProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *AdminProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *AdminProjectsLocationsOperationsService) Get(name string) *AdminProjectsLocationsOperationsGetCall {
	c := &AdminProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsOperationsGetCall) Context(ctx context.Context) *AdminProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *AdminProjectsLocationsOperationsService) List(name string) *AdminProjectsLocationsOperationsListCall {
	c := &AdminProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *AdminProjectsLocationsOperationsListCall) Filter(filter string) *AdminProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *AdminProjectsLocationsOperationsListCall) PageSize(pageSize int64) *AdminProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *AdminProjectsLocationsOperationsListCall) PageToken(pageToken string) *AdminProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// [ListOperationsResponse.unreachable] field. This can only be `true` when
// reading across collections e.g. when `parent` is set to
// "projects/example/locations/-". This field is not by default supported and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *AdminProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *AdminProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsOperationsListCall) Context(ctx context.Context) *AdminProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AdminProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AdminProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AdminProjectsLocationsReservationsCreateCall struct {
	s           *Service
	parent      string
	reservation *Reservation
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new reservation.
//
//   - parent: The parent location in which to create the reservation. Structured
//     like `projects/{project_number}/locations/{location}`.
func (r *AdminProjectsLocationsReservationsService) Create(parent string, reservation *Reservation) *AdminProjectsLocationsReservationsCreateCall {
	c := &AdminProjectsLocationsReservationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.reservation = reservation
	return c
}

// ReservationId sets the optional parameter "reservationId": Required. The ID
// to use for the reservation, which will become the final component of the
// reservation's name. This value is structured like: `my-reservation-name`.
func (c *AdminProjectsLocationsReservationsCreateCall) ReservationId(reservationId string) *AdminProjectsLocationsReservationsCreateCall {
	c.urlParams_.Set("reservationId", reservationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsReservationsCreateCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsReservationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsReservationsCreateCall) Context(ctx context.Context) *AdminProjectsLocationsReservationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsReservationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsReservationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reservation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+parent}/reservations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.reservations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsReservationsCreateCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsReservationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified reservation.
//
//   - name: The name of the reservation to delete. Structured like:
//     projects/{project_number}/locations/{location}/reservations/{reservation_id
//     }.
func (r *AdminProjectsLocationsReservationsService) Delete(name string) *AdminProjectsLocationsReservationsDeleteCall {
	c := &AdminProjectsLocationsReservationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsReservationsDeleteCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsReservationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsReservationsDeleteCall) Context(ctx context.Context) *AdminProjectsLocationsReservationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsReservationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsReservationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.reservations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsReservationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsReservationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the reservation configuration.
//
//   - name: The name of the reservation whose configuration to return.
//     Structured like:
//     projects/{project_number}/locations/{location}/reservations/{reservation_id
//     }.
func (r *AdminProjectsLocationsReservationsService) Get(name string) *AdminProjectsLocationsReservationsGetCall {
	c := &AdminProjectsLocationsReservationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsReservationsGetCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsReservationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsReservationsGetCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsReservationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsReservationsGetCall) Context(ctx context.Context) *AdminProjectsLocationsReservationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsReservationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsReservationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.reservations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsReservationsGetCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsReservationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of reservations for the given project.
//
//   - parent: The parent whose reservations are to be listed. Structured like
//     `projects/{project_number}/locations/{location}`.
func (r *AdminProjectsLocationsReservationsService) List(parent string) *AdminProjectsLocationsReservationsListCall {
	c := &AdminProjectsLocationsReservationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// reservations to return. The service may return fewer than this value. If
// unset or zero, all reservations for the parent will be returned.
func (c *AdminProjectsLocationsReservationsListCall) PageSize(pageSize int64) *AdminProjectsLocationsReservationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListReservations` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListReservations` must match the call that provided the page token.
func (c *AdminProjectsLocationsReservationsListCall) PageToken(pageToken string) *AdminProjectsLocationsReservationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsReservationsListCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsReservationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsReservationsListCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsReservationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsReservationsListCall) Context(ctx context.Context) *AdminProjectsLocationsReservationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsReservationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsReservationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+parent}/reservations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.reservations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReservationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AdminProjectsLocationsReservationsListCall) Do(opts ...googleapi.CallOption) (*ListReservationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReservationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AdminProjectsLocationsReservationsListCall) Pages(ctx context.Context, f func(*ListReservationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AdminProjectsLocationsReservationsPatchCall struct {
	s           *Service
	name        string
	reservation *Reservation
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates properties of the specified reservation.
//
//   - name: The name of the reservation. Structured like:
//     projects/{project_number}/locations/{location}/reservations/{reservation_id
//     }.
func (r *AdminProjectsLocationsReservationsService) Patch(name string, reservation *Reservation) *AdminProjectsLocationsReservationsPatchCall {
	c := &AdminProjectsLocationsReservationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reservation = reservation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A mask
// specifying the reservation fields to change.
func (c *AdminProjectsLocationsReservationsPatchCall) UpdateMask(updateMask string) *AdminProjectsLocationsReservationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsReservationsPatchCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsReservationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsReservationsPatchCall) Context(ctx context.Context) *AdminProjectsLocationsReservationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsReservationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsReservationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reservation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.reservations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsReservationsPatchCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsReservationsTopicsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the topics attached to the specified reservation.
//
//   - name: The name of the reservation whose topics to list. Structured like:
//     projects/{project_number}/locations/{location}/reservations/{reservation_id
//     }.
func (r *AdminProjectsLocationsReservationsTopicsService) List(name string) *AdminProjectsLocationsReservationsTopicsListCall {
	c := &AdminProjectsLocationsReservationsTopicsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// topics to return. The service may return fewer than this value. If unset or
// zero, all topics for the given reservation will be returned.
func (c *AdminProjectsLocationsReservationsTopicsListCall) PageSize(pageSize int64) *AdminProjectsLocationsReservationsTopicsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListReservationTopics` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListReservationTopics` must match the call that provided the page token.
func (c *AdminProjectsLocationsReservationsTopicsListCall) PageToken(pageToken string) *AdminProjectsLocationsReservationsTopicsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsReservationsTopicsListCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsReservationsTopicsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsReservationsTopicsListCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsReservationsTopicsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsReservationsTopicsListCall) Context(ctx context.Context) *AdminProjectsLocationsReservationsTopicsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsReservationsTopicsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsReservationsTopicsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}/topics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.topics.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.reservations.topics.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReservationTopicsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AdminProjectsLocationsReservationsTopicsListCall) Do(opts ...googleapi.CallOption) (*ListReservationTopicsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReservationTopicsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.reservations.topics.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AdminProjectsLocationsReservationsTopicsListCall) Pages(ctx context.Context, f func(*ListReservationTopicsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AdminProjectsLocationsSubscriptionsCreateCall struct {
	s            *Service
	parent       string
	subscription *Subscription
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new subscription.
//
//   - parent: The parent location in which to create the subscription.
//     Structured like `projects/{project_number}/locations/{location}`.
func (r *AdminProjectsLocationsSubscriptionsService) Create(parent string, subscription *Subscription) *AdminProjectsLocationsSubscriptionsCreateCall {
	c := &AdminProjectsLocationsSubscriptionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.subscription = subscription
	return c
}

// SkipBacklog sets the optional parameter "skipBacklog": If true, the newly
// created subscription will only receive messages published after the
// subscription was created. Otherwise, the entire message backlog will be
// received on the subscription. Defaults to false.
func (c *AdminProjectsLocationsSubscriptionsCreateCall) SkipBacklog(skipBacklog bool) *AdminProjectsLocationsSubscriptionsCreateCall {
	c.urlParams_.Set("skipBacklog", fmt.Sprint(skipBacklog))
	return c
}

// SubscriptionId sets the optional parameter "subscriptionId": Required. The
// ID to use for the subscription, which will become the final component of the
// subscription's name. This value is structured like: `my-sub-name`.
func (c *AdminProjectsLocationsSubscriptionsCreateCall) SubscriptionId(subscriptionId string) *AdminProjectsLocationsSubscriptionsCreateCall {
	c.urlParams_.Set("subscriptionId", subscriptionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsSubscriptionsCreateCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsSubscriptionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsSubscriptionsCreateCall) Context(ctx context.Context) *AdminProjectsLocationsSubscriptionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsSubscriptionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsSubscriptionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.subscription)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+parent}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.subscriptions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsSubscriptionsCreateCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsSubscriptionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified subscription.
//
// - name: The name of the subscription to delete.
func (r *AdminProjectsLocationsSubscriptionsService) Delete(name string) *AdminProjectsLocationsSubscriptionsDeleteCall {
	c := &AdminProjectsLocationsSubscriptionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsSubscriptionsDeleteCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsSubscriptionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsSubscriptionsDeleteCall) Context(ctx context.Context) *AdminProjectsLocationsSubscriptionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsSubscriptionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsSubscriptionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.subscriptions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsSubscriptionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsSubscriptionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the subscription configuration.
//
// - name: The name of the subscription whose configuration to return.
func (r *AdminProjectsLocationsSubscriptionsService) Get(name string) *AdminProjectsLocationsSubscriptionsGetCall {
	c := &AdminProjectsLocationsSubscriptionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsSubscriptionsGetCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsSubscriptionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsSubscriptionsGetCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsSubscriptionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsSubscriptionsGetCall) Context(ctx context.Context) *AdminProjectsLocationsSubscriptionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsSubscriptionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsSubscriptionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.subscriptions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsSubscriptionsGetCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsSubscriptionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of subscriptions for the given project.
//
//   - parent: The parent whose subscriptions are to be listed. Structured like
//     `projects/{project_number}/locations/{location}`.
func (r *AdminProjectsLocationsSubscriptionsService) List(parent string) *AdminProjectsLocationsSubscriptionsListCall {
	c := &AdminProjectsLocationsSubscriptionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// subscriptions to return. The service may return fewer than this value. If
// unset or zero, all subscriptions for the parent will be returned.
func (c *AdminProjectsLocationsSubscriptionsListCall) PageSize(pageSize int64) *AdminProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListSubscriptions` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListSubscriptions` must match the call that provided the page token.
func (c *AdminProjectsLocationsSubscriptionsListCall) PageToken(pageToken string) *AdminProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsSubscriptionsListCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsSubscriptionsListCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsSubscriptionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsSubscriptionsListCall) Context(ctx context.Context) *AdminProjectsLocationsSubscriptionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsSubscriptionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsSubscriptionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+parent}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.subscriptions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSubscriptionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AdminProjectsLocationsSubscriptionsListCall) Do(opts ...googleapi.CallOption) (*ListSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AdminProjectsLocationsSubscriptionsListCall) Pages(ctx context.Context, f func(*ListSubscriptionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AdminProjectsLocationsSubscriptionsPatchCall struct {
	s            *Service
	name         string
	subscription *Subscription
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates properties of the specified subscription.
//
//   - name: The name of the subscription. Structured like:
//     projects/{project_number}/locations/{location}/subscriptions/{subscription_
//     id}.
func (r *AdminProjectsLocationsSubscriptionsService) Patch(name string, subscription *Subscription) *AdminProjectsLocationsSubscriptionsPatchCall {
	c := &AdminProjectsLocationsSubscriptionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.subscription = subscription
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A mask
// specifying the subscription fields to change.
func (c *AdminProjectsLocationsSubscriptionsPatchCall) UpdateMask(updateMask string) *AdminProjectsLocationsSubscriptionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsSubscriptionsPatchCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsSubscriptionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsSubscriptionsPatchCall) Context(ctx context.Context) *AdminProjectsLocationsSubscriptionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsSubscriptionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsSubscriptionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.subscription)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.subscriptions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsSubscriptionsPatchCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsSubscriptionsSeekCall struct {
	s                       *Service
	name                    string
	seeksubscriptionrequest *SeekSubscriptionRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Seek: Performs an out-of-band seek for a subscription to a specified target,
// which may be timestamps or named positions within the message backlog. Seek
// translates these targets to cursors for each partition and orchestrates
// subscribers to start consuming messages from these seek cursors. If an
// operation is returned, the seek has been registered and subscribers will
// eventually receive messages from the seek cursors (i.e. eventual
// consistency), as long as they are using a minimum supported client library
// version and not a system that tracks cursors independently of Pub/Sub Lite
// (e.g. Apache Beam, Dataflow, Spark). The seek operation will fail for
// unsupported clients. If clients would like to know when subscribers react to
// the seek (or not), they can poll the operation. The seek operation will
// succeed and complete once subscribers are ready to receive messages from the
// seek cursors for all partitions of the topic. This means that the seek
// operation will not complete until all subscribers come online. If the
// previous seek operation has not yet completed, it will be aborted and the
// new invocation of seek will supersede it.
//
// - name: The name of the subscription to seek.
func (r *AdminProjectsLocationsSubscriptionsService) Seek(name string, seeksubscriptionrequest *SeekSubscriptionRequest) *AdminProjectsLocationsSubscriptionsSeekCall {
	c := &AdminProjectsLocationsSubscriptionsSeekCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.seeksubscriptionrequest = seeksubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsSubscriptionsSeekCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsSubscriptionsSeekCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsSubscriptionsSeekCall) Context(ctx context.Context) *AdminProjectsLocationsSubscriptionsSeekCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsSubscriptionsSeekCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsSubscriptionsSeekCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.seeksubscriptionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}:seek")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.seek", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.subscriptions.seek" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsSubscriptionsSeekCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.subscriptions.seek", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsTopicsCreateCall struct {
	s          *Service
	parent     string
	topic      *Topic
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new topic.
//
//   - parent: The parent location in which to create the topic. Structured like
//     `projects/{project_number}/locations/{location}`.
func (r *AdminProjectsLocationsTopicsService) Create(parent string, topic *Topic) *AdminProjectsLocationsTopicsCreateCall {
	c := &AdminProjectsLocationsTopicsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.topic = topic
	return c
}

// TopicId sets the optional parameter "topicId": Required. The ID to use for
// the topic, which will become the final component of the topic's name. This
// value is structured like: `my-topic-name`.
func (c *AdminProjectsLocationsTopicsCreateCall) TopicId(topicId string) *AdminProjectsLocationsTopicsCreateCall {
	c.urlParams_.Set("topicId", topicId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsCreateCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsCreateCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.topic)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+parent}/topics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Topic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsTopicsCreateCall) Do(opts ...googleapi.CallOption) (*Topic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Topic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsTopicsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified topic.
//
// - name: The name of the topic to delete.
func (r *AdminProjectsLocationsTopicsService) Delete(name string) *AdminProjectsLocationsTopicsDeleteCall {
	c := &AdminProjectsLocationsTopicsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsDeleteCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsDeleteCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsTopicsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsTopicsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the topic configuration.
//
// - name: The name of the topic whose configuration to return.
func (r *AdminProjectsLocationsTopicsService) Get(name string) *AdminProjectsLocationsTopicsGetCall {
	c := &AdminProjectsLocationsTopicsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsGetCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsTopicsGetCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsTopicsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsGetCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Topic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsTopicsGetCall) Do(opts ...googleapi.CallOption) (*Topic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Topic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsTopicsGetPartitionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPartitions: Returns the partition information for the requested topic.
//
// - name: The topic whose partition information to return.
func (r *AdminProjectsLocationsTopicsService) GetPartitions(name string) *AdminProjectsLocationsTopicsGetPartitionsCall {
	c := &AdminProjectsLocationsTopicsGetPartitionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsGetPartitionsCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsGetPartitionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsTopicsGetPartitionsCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsTopicsGetPartitionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsGetPartitionsCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsGetPartitionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsGetPartitionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsGetPartitionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}/partitions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.getPartitions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.getPartitions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TopicPartitions.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AdminProjectsLocationsTopicsGetPartitionsCall) Do(opts ...googleapi.CallOption) (*TopicPartitions, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TopicPartitions{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.getPartitions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsTopicsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of topics for the given project.
//
//   - parent: The parent whose topics are to be listed. Structured like
//     `projects/{project_number}/locations/{location}`.
func (r *AdminProjectsLocationsTopicsService) List(parent string) *AdminProjectsLocationsTopicsListCall {
	c := &AdminProjectsLocationsTopicsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// topics to return. The service may return fewer than this value. If unset or
// zero, all topics for the parent will be returned.
func (c *AdminProjectsLocationsTopicsListCall) PageSize(pageSize int64) *AdminProjectsLocationsTopicsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListTopics` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListTopics` must
// match the call that provided the page token.
func (c *AdminProjectsLocationsTopicsListCall) PageToken(pageToken string) *AdminProjectsLocationsTopicsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsListCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsTopicsListCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsTopicsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsListCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+parent}/topics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTopicsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AdminProjectsLocationsTopicsListCall) Do(opts ...googleapi.CallOption) (*ListTopicsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTopicsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AdminProjectsLocationsTopicsListCall) Pages(ctx context.Context, f func(*ListTopicsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AdminProjectsLocationsTopicsPatchCall struct {
	s          *Service
	name       string
	topic      *Topic
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates properties of the specified topic.
//
//   - name: The name of the topic. Structured like:
//     projects/{project_number}/locations/{location}/topics/{topic_id}.
func (r *AdminProjectsLocationsTopicsService) Patch(name string, topic *Topic) *AdminProjectsLocationsTopicsPatchCall {
	c := &AdminProjectsLocationsTopicsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.topic = topic
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A mask
// specifying the topic fields to change.
func (c *AdminProjectsLocationsTopicsPatchCall) UpdateMask(updateMask string) *AdminProjectsLocationsTopicsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsPatchCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsPatchCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.topic)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Topic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AdminProjectsLocationsTopicsPatchCall) Do(opts ...googleapi.CallOption) (*Topic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Topic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AdminProjectsLocationsTopicsSubscriptionsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the subscriptions attached to the specified topic.
//
// - name: The name of the topic whose subscriptions to list.
func (r *AdminProjectsLocationsTopicsSubscriptionsService) List(name string) *AdminProjectsLocationsTopicsSubscriptionsListCall {
	c := &AdminProjectsLocationsTopicsSubscriptionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// subscriptions to return. The service may return fewer than this value. If
// unset or zero, all subscriptions for the given topic will be returned.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) PageSize(pageSize int64) *AdminProjectsLocationsTopicsSubscriptionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListTopicSubscriptions` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListTopicSubscriptions` must match the call that provided the page token.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) PageToken(pageToken string) *AdminProjectsLocationsTopicsSubscriptionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) Fields(s ...googleapi.Field) *AdminProjectsLocationsTopicsSubscriptionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) IfNoneMatch(entityTag string) *AdminProjectsLocationsTopicsSubscriptionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) Context(ctx context.Context) *AdminProjectsLocationsTopicsSubscriptionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/admin/{+name}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.subscriptions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.admin.projects.locations.topics.subscriptions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTopicSubscriptionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) Do(opts ...googleapi.CallOption) (*ListTopicSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTopicSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.admin.projects.locations.topics.subscriptions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AdminProjectsLocationsTopicsSubscriptionsListCall) Pages(ctx context.Context, f func(*ListTopicSubscriptionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CursorProjectsLocationsSubscriptionsCommitCursorCall struct {
	s                   *Service
	subscription        string
	commitcursorrequest *CommitCursorRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// CommitCursor: Updates the committed cursor.
//
// - subscription: The subscription for which to update the cursor.
func (r *CursorProjectsLocationsSubscriptionsService) CommitCursor(subscription string, commitcursorrequest *CommitCursorRequest) *CursorProjectsLocationsSubscriptionsCommitCursorCall {
	c := &CursorProjectsLocationsSubscriptionsCommitCursorCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.subscription = subscription
	c.commitcursorrequest = commitcursorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CursorProjectsLocationsSubscriptionsCommitCursorCall) Fields(s ...googleapi.Field) *CursorProjectsLocationsSubscriptionsCommitCursorCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CursorProjectsLocationsSubscriptionsCommitCursorCall) Context(ctx context.Context) *CursorProjectsLocationsSubscriptionsCommitCursorCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CursorProjectsLocationsSubscriptionsCommitCursorCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CursorProjectsLocationsSubscriptionsCommitCursorCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.commitcursorrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/cursor/{+subscription}:commitCursor")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"subscription": c.subscription,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.cursor.projects.locations.subscriptions.commitCursor", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.cursor.projects.locations.subscriptions.commitCursor" call.
// Any non-2xx status code is an error. Response headers are in either
// *CommitCursorResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CursorProjectsLocationsSubscriptionsCommitCursorCall) Do(opts ...googleapi.CallOption) (*CommitCursorResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CommitCursorResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.cursor.projects.locations.subscriptions.commitCursor", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CursorProjectsLocationsSubscriptionsCursorsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all committed cursor information for a subscription.
//
//   - parent: The subscription for which to retrieve cursors. Structured like
//     `projects/{project_number}/locations/{location}/subscriptions/{subscription
//     _id}`.
func (r *CursorProjectsLocationsSubscriptionsCursorsService) List(parent string) *CursorProjectsLocationsSubscriptionsCursorsListCall {
	c := &CursorProjectsLocationsSubscriptionsCursorsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// cursors to return. The service may return fewer than this value. If unset or
// zero, all cursors for the parent will be returned.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) PageSize(pageSize int64) *CursorProjectsLocationsSubscriptionsCursorsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPartitionCursors` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListPartitionCursors` must match the call that provided the page token.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) PageToken(pageToken string) *CursorProjectsLocationsSubscriptionsCursorsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) Fields(s ...googleapi.Field) *CursorProjectsLocationsSubscriptionsCursorsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) IfNoneMatch(entityTag string) *CursorProjectsLocationsSubscriptionsCursorsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) Context(ctx context.Context) *CursorProjectsLocationsSubscriptionsCursorsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/cursor/{+parent}/cursors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.cursor.projects.locations.subscriptions.cursors.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.cursor.projects.locations.subscriptions.cursors.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPartitionCursorsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) Do(opts ...googleapi.CallOption) (*ListPartitionCursorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPartitionCursorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.cursor.projects.locations.subscriptions.cursors.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CursorProjectsLocationsSubscriptionsCursorsListCall) Pages(ctx context.Context, f func(*ListPartitionCursorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TopicStatsProjectsLocationsTopicsComputeHeadCursorCall struct {
	s                        *Service
	topic                    string
	computeheadcursorrequest *ComputeHeadCursorRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// ComputeHeadCursor: Compute the head cursor for the partition. The head
// cursor's offset is guaranteed to be less than or equal to all messages which
// have not yet been acknowledged as published, and greater than the offset of
// any message whose publish has already been acknowledged. It is zero if there
// have never been messages in the partition.
//
// - topic: The topic for which we should compute the head cursor.
func (r *TopicStatsProjectsLocationsTopicsService) ComputeHeadCursor(topic string, computeheadcursorrequest *ComputeHeadCursorRequest) *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall {
	c := &TopicStatsProjectsLocationsTopicsComputeHeadCursorCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.topic = topic
	c.computeheadcursorrequest = computeheadcursorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall) Fields(s ...googleapi.Field) *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall) Context(ctx context.Context) *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computeheadcursorrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/topicStats/{+topic}:computeHeadCursor")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"topic": c.topic,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.topicStats.projects.locations.topics.computeHeadCursor", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.topicStats.projects.locations.topics.computeHeadCursor" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeHeadCursorResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TopicStatsProjectsLocationsTopicsComputeHeadCursorCall) Do(opts ...googleapi.CallOption) (*ComputeHeadCursorResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeHeadCursorResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.topicStats.projects.locations.topics.computeHeadCursor", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TopicStatsProjectsLocationsTopicsComputeMessageStatsCall struct {
	s                          *Service
	topic                      string
	computemessagestatsrequest *ComputeMessageStatsRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// ComputeMessageStats: Compute statistics about a range of messages in a given
// topic and partition.
//
// - topic: The topic for which we should compute message stats.
func (r *TopicStatsProjectsLocationsTopicsService) ComputeMessageStats(topic string, computemessagestatsrequest *ComputeMessageStatsRequest) *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall {
	c := &TopicStatsProjectsLocationsTopicsComputeMessageStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.topic = topic
	c.computemessagestatsrequest = computemessagestatsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall) Fields(s ...googleapi.Field) *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall) Context(ctx context.Context) *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computemessagestatsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/topicStats/{+topic}:computeMessageStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"topic": c.topic,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.topicStats.projects.locations.topics.computeMessageStats", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.topicStats.projects.locations.topics.computeMessageStats" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeMessageStatsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TopicStatsProjectsLocationsTopicsComputeMessageStatsCall) Do(opts ...googleapi.CallOption) (*ComputeMessageStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeMessageStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.topicStats.projects.locations.topics.computeMessageStats", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TopicStatsProjectsLocationsTopicsComputeTimeCursorCall struct {
	s                        *Service
	topic                    string
	computetimecursorrequest *ComputeTimeCursorRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// ComputeTimeCursor: Compute the corresponding cursor for a publish or event
// time in a topic partition.
//
// - topic: The topic for which we should compute the cursor.
func (r *TopicStatsProjectsLocationsTopicsService) ComputeTimeCursor(topic string, computetimecursorrequest *ComputeTimeCursorRequest) *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall {
	c := &TopicStatsProjectsLocationsTopicsComputeTimeCursorCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.topic = topic
	c.computetimecursorrequest = computetimecursorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall) Fields(s ...googleapi.Field) *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall) Context(ctx context.Context) *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computetimecursorrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/topicStats/{+topic}:computeTimeCursor")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"topic": c.topic,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "pubsublite.topicStats.projects.locations.topics.computeTimeCursor", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "pubsublite.topicStats.projects.locations.topics.computeTimeCursor" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeTimeCursorResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TopicStatsProjectsLocationsTopicsComputeTimeCursorCall) Do(opts ...googleapi.CallOption) (*ComputeTimeCursorResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeTimeCursorResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "pubsublite.topicStats.projects.locations.topics.computeTimeCursor", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
