// Code generated by 'ccgo -export-externs X -export-fields F -hide __syscall0,__syscall1,__syscall2,__syscall3,__syscall4,__syscall5,__syscall6,getnameinfo,gethostbyaddr_r, -nostdinc -nostdlib -o ../musl_openbsd_amd64.go -pkgname libc -static-locals-prefix _s -Iarch/x86_64 -Iarch/generic -Iobj/src/internal -Isrc/include -Isrc/internal -Iobj/include -Iinclude copyright.c ../openbsd/ctype_.c src/ctype/isalnum.c src/ctype/isalpha.c src/ctype/isdigit.c src/ctype/islower.c src/ctype/isprint.c src/ctype/isspace.c src/ctype/isupper.c src/ctype/isxdigit.c src/internal/floatscan.c src/internal/intscan.c src/internal/shgetc.c src/math/copysignl.c src/math/fabsl.c src/math/fmodl.c src/math/rint.c src/math/scalbn.c src/math/scalbnl.c src/network/freeaddrinfo.c src/network/getaddrinfo.c src/network/gethostbyaddr.c src/network/gethostbyaddr_r.c src/network/gethostbyname.c src/network/gethostbyname2.c src/network/gethostbyname2_r.c src/network/getnameinfo.c src/network/h_errno.c src/network/inet_aton.c src/network/inet_ntop.c src/network/inet_pton.c src/network/lookup_ipliteral.c src/network/lookup_name.c src/network/lookup_serv.c src/stdio/__toread.c src/stdio/__uflow.c src/stdlib/bsearch.c src/stdlib/strtod.c src/stdlib/strtol.c src/string/strdup.c src/string/strnlen.c src/string/strspn.c', DO NOT EDIT.

package libc

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer

// musl as a whole is licensed under the following standard MIT license:
//
// ----------------------------------------------------------------------
// Copyright © 2005-2020 Rich Felker, et al.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// ----------------------------------------------------------------------
//
// Authors/contributors include:
//
// A. Wilcox
// Ada Worcester
// Alex Dowad
// Alex Suykov
// Alexander Monakov
// Andre McCurdy
// Andrew Kelley
// Anthony G. Basile
// Aric Belsito
// Arvid Picciani
// Bartosz Brachaczek
// Benjamin Peterson
// Bobby Bingham
// Boris Brezillon
// Brent Cook
// Chris Spiegel
// Clément Vasseur
// Daniel Micay
// Daniel Sabogal
// Daurnimator
// David Carlier
// David Edelsohn
// Denys Vlasenko
// Dmitry Ivanov
// Dmitry V. Levin
// Drew DeVault
// Emil Renner Berthing
// Fangrui Song
// Felix Fietkau
// Felix Janda
// Gianluca Anzolin
// Hauke Mehrtens
// He X
// Hiltjo Posthuma
// Isaac Dunham
// Jaydeep Patil
// Jens Gustedt
// Jeremy Huntwork
// Jo-Philipp Wich
// Joakim Sindholt
// John Spencer
// Julien Ramseier
// Justin Cormack
// Kaarle Ritvanen
// Khem Raj
// Kylie McClain
// Leah Neukirchen
// Luca Barbato
// Luka Perkov
// M Farkas-Dyck (Strake)
// Mahesh Bodapati
// Markus Wichmann
// Masanori Ogino
// Michael Clark
// Michael Forney
// Mikhail Kremnyov
// Natanael Copa
// Nicholas J. Kain
// orc
// Pascal Cuoq
// Patrick Oppenlander
// Petr Hosek
// Petr Skocik
// Pierre Carrier
// Reini Urban
// Rich Felker
// Richard Pennington
// Ryan Fairfax
// Samuel Holland
// Segev Finer
// Shiz
// sin
// Solar Designer
// Stefan Kristiansson
// Stefan O'Rear
// Szabolcs Nagy
// Timo Teräs
// Trutz Behn
// Valentin Ochs
// Will Dietz
// William Haddon
// William Pitcock
//
// Portions of this software are derived from third-party works licensed
// under terms compatible with the above MIT license:
//
// The TRE regular expression implementation (src/regex/reg* and
// src/regex/tre*) is Copyright © 2001-2008 Ville Laurikari and licensed
// under a 2-clause BSD license (license text in the source files). The
// included version has been heavily modified by Rich Felker in 2012, in
// the interests of size, simplicity, and namespace cleanliness.
//
// Much of the math library code (src/math/* and src/complex/*) is
// Copyright © 1993,2004 Sun Microsystems or
// Copyright © 2003-2011 David Schultz or
// Copyright © 2003-2009 Steven G. Kargl or
// Copyright © 2003-2009 Bruce D. Evans or
// Copyright © 2008 Stephen L. Moshier or
// Copyright © 2017-2018 Arm Limited
// and labelled as such in comments in the individual source files. All
// have been licensed under extremely permissive terms.
//
// The ARM memcpy code (src/string/arm/memcpy.S) is Copyright © 2008
// The Android Open Source Project and is licensed under a two-clause BSD
// license. It was taken from Bionic libc, used on Android.
//
// The AArch64 memcpy and memset code (src/string/aarch64/*) are
// Copyright © 1999-2019, Arm Limited.
//
// The implementation of DES for crypt (src/crypt/crypt_des.c) is
// Copyright © 1994 David Burren. It is licensed under a BSD license.
//
// The implementation of blowfish crypt (src/crypt/crypt_blowfish.c) was
// originally written by Solar Designer and placed into the public
// domain. The code also comes with a fallback permissive license for use
// in jurisdictions that may not recognize the public domain.
//
// The smoothsort implementation (src/stdlib/qsort.c) is Copyright © 2011
// Valentin Ochs and is licensed under an MIT-style license.
//
// The x86_64 port was written by Nicholas J. Kain and is licensed under
// the standard MIT terms.
//
// The mips and microblaze ports were originally written by Richard
// Pennington for use in the ellcc project. The original code was adapted
// by Rich Felker for build system and code conventions during upstream
// integration. It is licensed under the standard MIT terms.
//
// The mips64 port was contributed by Imagination Technologies and is
// licensed under the standard MIT terms.
//
// The powerpc port was also originally written by Richard Pennington,
// and later supplemented and integrated by John Spencer. It is licensed
// under the standard MIT terms.
//
// All other files which have no copyright comments are original works
// produced specifically for use as part of this library, written either
// by Rich Felker, the main author of the library, or by one or more
// contibutors listed above. Details on authorship of individual files
// can be found in the git version control history of the project. The
// omission of copyright and license comments in each file is in the
// interest of source tree size.
//
// In addition, permission is hereby granted for all public header files
// (include/* and arch/*/bits/*) and crt files intended to be linked into
// applications (crt/*, ldso/dlstart.c, and arch/*/crt_arch.h) to omit
// the copyright notice and permission notice otherwise required by the
// license, and to use these files without any requirement of
// attribution. These files include substantial contributions from:
//
// Bobby Bingham
// John Spencer
// Nicholas J. Kain
// Rich Felker
// Richard Pennington
// Stefan Kristiansson
// Szabolcs Nagy
//
// all of whom have explicitly granted such permission.
//
// This file previously contained text expressing a belief that most of
// the files covered by the above exception were sufficiently trivial not
// to be subject to copyright, resulting in confusion over whether it
// negated the permissions granted in the license. In the spirit of
// permissive licensing, and of not having licensing issues being an
// obstacle to adoption, that text has been removed.
const ( /* copyright.c:194:1: */
	__musl__copyright__ = 0
)

const ( /* nameser.h:117:1: */
	ns_uop_delete = 0
	ns_uop_add    = 1
	ns_uop_max    = 2
)

const ( /* nameser.h:147:1: */
	ns_t_invalid  = 0
	ns_t_a        = 1
	ns_t_ns       = 2
	ns_t_md       = 3
	ns_t_mf       = 4
	ns_t_cname    = 5
	ns_t_soa      = 6
	ns_t_mb       = 7
	ns_t_mg       = 8
	ns_t_mr       = 9
	ns_t_null     = 10
	ns_t_wks      = 11
	ns_t_ptr      = 12
	ns_t_hinfo    = 13
	ns_t_minfo    = 14
	ns_t_mx       = 15
	ns_t_txt      = 16
	ns_t_rp       = 17
	ns_t_afsdb    = 18
	ns_t_x25      = 19
	ns_t_isdn     = 20
	ns_t_rt       = 21
	ns_t_nsap     = 22
	ns_t_nsap_ptr = 23
	ns_t_sig      = 24
	ns_t_key      = 25
	ns_t_px       = 26
	ns_t_gpos     = 27
	ns_t_aaaa     = 28
	ns_t_loc      = 29
	ns_t_nxt      = 30
	ns_t_eid      = 31
	ns_t_nimloc   = 32
	ns_t_srv      = 33
	ns_t_atma     = 34
	ns_t_naptr    = 35
	ns_t_kx       = 36
	ns_t_cert     = 37
	ns_t_a6       = 38
	ns_t_dname    = 39
	ns_t_sink     = 40
	ns_t_opt      = 41
	ns_t_apl      = 42
	ns_t_tkey     = 249
	ns_t_tsig     = 250
	ns_t_ixfr     = 251
	ns_t_axfr     = 252
	ns_t_mailb    = 253
	ns_t_maila    = 254
	ns_t_any      = 255
	ns_t_zxfr     = 256
	ns_t_max      = 65536
)

const ( /* nameser.h:210:1: */
	ns_c_invalid = 0
	ns_c_in      = 1
	ns_c_2       = 2
	ns_c_chaos   = 3
	ns_c_hs      = 4
	ns_c_none    = 254
	ns_c_any     = 255
	ns_c_max     = 65536
)

const ( /* nameser.h:221:1: */
	ns_kt_rsa     = 1
	ns_kt_dh      = 2
	ns_kt_dsa     = 3
	ns_kt_private = 254
)

const ( /* nameser.h:228:1: */
	cert_t_pkix = 1
	cert_t_spki = 2
	cert_t_pgp  = 3
	cert_t_url  = 253
	cert_t_oid  = 254
)

const ( /* nameser.h:28:1: */
	ns_s_qd  = 0
	ns_s_zn  = 0
	ns_s_an  = 1
	ns_s_pr  = 1
	ns_s_ns  = 2
	ns_s_ud  = 2
	ns_s_ar  = 3
	ns_s_max = 4
)

const ( /* nameser.h:75:1: */
	ns_f_qr     = 0
	ns_f_opcode = 1
	ns_f_aa     = 2
	ns_f_tc     = 3
	ns_f_rd     = 4
	ns_f_ra     = 5
	ns_f_z      = 6
	ns_f_ad     = 7
	ns_f_cd     = 8
	ns_f_rcode  = 9
	ns_f_max    = 10
)

const ( /* nameser.h:89:1: */
	ns_o_query  = 0
	ns_o_iquery = 1
	ns_o_status = 2
	ns_o_notify = 4
	ns_o_update = 5
	ns_o_max    = 6
)

const ( /* nameser.h:98:1: */
	ns_r_noerror  = 0
	ns_r_formerr  = 1
	ns_r_servfail = 2
	ns_r_nxdomain = 3
	ns_r_notimpl  = 4
	ns_r_refused  = 5
	ns_r_yxdomain = 6
	ns_r_yxrrset  = 7
	ns_r_nxrrset  = 8
	ns_r_notauth  = 9
	ns_r_notzone  = 10
	ns_r_max      = 11
	ns_r_badvers  = 16
	ns_r_badsig   = 16
	ns_r_badkey   = 17
	ns_r_badtime  = 18
)

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

// # 1 "lib/libc/gen/ctype_.c"
// # 1 "<built-in>"
// # 1 "<command-line>"
// # 1 "lib/libc/gen/ctype_.c"
// # 36 "lib/libc/gen/ctype_.c"
// # 1 "./include/ctype.h" 1
// # 43 "./include/ctype.h"
// # 1 "./sys/sys/cdefs.h" 1
// # 41 "./sys/sys/cdefs.h"
// # 1 "./machine/cdefs.h" 1
// # 42 "./sys/sys/cdefs.h" 2
// # 44 "./include/ctype.h" 2
// # 57 "./include/ctype.h"
// typedef void *locale_t;
//
//
//
//
//
// extern const char *_ctype_;
// extern const short *_tolower_tab_;
// extern const short *_toupper_tab_;
//
//
// int isalnum(int);
// int isalpha(int);
// int iscntrl(int);
// int isdigit(int);
// int isgraph(int);
// int islower(int);
// int isprint(int);
// int ispunct(int);
// int isspace(int);
// int isupper(int);
// int isxdigit(int);
// int tolower(int);
// int toupper(int);
//
//
//
// int isblank(int);
//
//
//
// int isascii(int);
// int toascii(int);
// int _tolower(int);
// int _toupper(int);
//
//
//
// int isalnum_l(int, locale_t);
// int isalpha_l(int, locale_t);
// int isblank_l(int, locale_t);
// int iscntrl_l(int, locale_t);
// int isdigit_l(int, locale_t);
// int isgraph_l(int, locale_t);
// int islower_l(int, locale_t);
// int isprint_l(int, locale_t);
// int ispunct_l(int, locale_t);
// int isspace_l(int, locale_t);
// int isupper_l(int, locale_t);
// int isxdigit_l(int, locale_t);
// int tolower_l(int, locale_t);
// int toupper_l(int, locale_t);
//
//
//
//
//
//
// extern __inline __attribute__((__gnu_inline__)) int isalnum(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & (0x01|0x02|0x04)));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isalpha(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & (0x01|0x02)));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int iscntrl(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & 0x20));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isdigit(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & 0x04));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isgraph(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & (0x10|0x01|0x02|0x04)));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int islower(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & 0x02));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isprint(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & (0x10|0x01|0x02|0x04|0x80)));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int ispunct(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & 0x10));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isspace(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & 0x08));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isupper(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & 0x01));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int isxdigit(int _c)
// {
//  return (_c == -1 ? 0 : ((_ctype_ + 1)[(unsigned char)_c] & (0x04|0x40)));
// }
//
// extern __inline __attribute__((__gnu_inline__)) int tolower(int _c)
// {
//  if ((unsigned int)_c > 255)
//   return (_c);
//  return ((_tolower_tab_ + 1)[_c]);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int toupper(int _c)
// {
//  if ((unsigned int)_c > 255)
//   return (_c);
//  return ((_toupper_tab_ + 1)[_c]);
// }
//
//

// extern __inline __attribute__((__gnu_inline__))
func Xisblank(tls *TLS, _c int32) int32 { /* ctype_.c:144:5: */
	if __ccgo_strace {
		trc("tls=%v _c=%v, (%v:)", tls, _c, origin(2))
	}
	return Bool32(_c == ' ' || _c == '\t')
}

// extern __inline __attribute__((__gnu_inline__)) int isascii(int _c)
// {
//  return ((unsigned int)_c <= 0177);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int toascii(int _c)
// {
//  return (_c & 0177);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int _tolower(int _c)
// {
//  return (_c - 'A' + 'a');
// }
//
// extern __inline __attribute__((__gnu_inline__)) int _toupper(int _c)
// {
//  return (_c - 'a' + 'A');
// }
//
//
//
// extern __inline __attribute__((__gnu_inline__)) int
// isalnum_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isalnum(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isalpha_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isalpha(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isblank_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isblank(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// iscntrl_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return iscntrl(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isdigit_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isdigit(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isgraph_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isgraph(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// islower_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return islower(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isprint_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isprint(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// ispunct_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return ispunct(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isspace_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isspace(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isupper_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isupper(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// isxdigit_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return isxdigit(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// tolower_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return tolower(_c);
// }
//
// extern __inline __attribute__((__gnu_inline__)) int
// toupper_l(int _c, locale_t _l __attribute__((__unused__)))
// {
//  return toupper(_c);
// }
//
//
//
//
//
// # 37 "lib/libc/gen/ctype_.c" 2
// # 1 "./lib/libc/include/ctype_private.h" 1
//
//
//
//
//
// # 5 "./lib/libc/include/ctype_private.h"
// #pragma GCC visibility push(hidden)
// # 5 "./lib/libc/include/ctype_private.h"
//
// extern const char _C_ctype_[];
// extern const short _C_toupper_[];
// extern const short _C_tolower_[];
//
// # 9 "./lib/libc/include/ctype_private.h"
// #pragma GCC visibility pop
// # 9 "./lib/libc/include/ctype_private.h"
//
// # 38 "lib/libc/gen/ctype_.c" 2

var X_C_ctype_ = [257]int8{
	int8(0),
	int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20),
	int8(0x20), int8(0x20 | 0x08), int8(0x20 | 0x08), int8(0x20 | 0x08), int8(0x20 | 0x08), int8(0x20 | 0x08), int8(0x20), int8(0x20),
	int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20),
	int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20), int8(0x20),
	int8(0x08 | int32(Int8FromInt32(0x80))), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10),
	int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10),
	int8(0x04), int8(0x04), int8(0x04), int8(0x04), int8(0x04), int8(0x04), int8(0x04), int8(0x04),
	int8(0x04), int8(0x04), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10),
	int8(0x10), int8(0x01 | 0x40), int8(0x01 | 0x40), int8(0x01 | 0x40), int8(0x01 | 0x40), int8(0x01 | 0x40), int8(0x01 | 0x40), int8(0x01),
	int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01),
	int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01), int8(0x01),
	int8(0x01), int8(0x01), int8(0x01), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x10),
	int8(0x10), int8(0x02 | 0x40), int8(0x02 | 0x40), int8(0x02 | 0x40), int8(0x02 | 0x40), int8(0x02 | 0x40), int8(0x02 | 0x40), int8(0x02),
	int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02),
	int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02), int8(0x02),
	int8(0x02), int8(0x02), int8(0x02), int8(0x10), int8(0x10), int8(0x10), int8(0x10), int8(0x20),

	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
	int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0), int8(0),
} /* ctype_.c:282:12 */

var X_ctype_ uintptr = 0 /* ctype_.c:319:12 */

func __isspace(tls *TLS, _c int32) int32 { /* ctype.h:26:21: */
	return Bool32(_c == ' ' || uint32(_c)-uint32('\t') < uint32(5))
}

type locale_t = uintptr /* alltypes.h:343:32 */

func Xisalnum(tls *TLS, c int32) int32 { /* isalnum.c:3:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(func() int32 {
		if 0 != 0 {
			return Xisalpha(tls, c)
		}
		return Bool32(uint32(c)|uint32(32)-uint32('a') < uint32(26))
	}() != 0 || func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, c)
		}
		return Bool32(uint32(c)-uint32('0') < uint32(10))
	}() != 0)
}

func X__isalnum_l(tls *TLS, c int32, l locale_t) int32 { /* isalnum.c:8:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisalnum(tls, c)
}

func Xisalpha(tls *TLS, c int32) int32 { /* isalpha.c:4:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(uint32(c)|uint32(32)-uint32('a') < uint32(26))
}

func X__isalpha_l(tls *TLS, c int32, l locale_t) int32 { /* isalpha.c:9:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisalpha(tls, c)
}

func Xisdigit(tls *TLS, c int32) int32 { /* isdigit.c:4:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(uint32(c)-uint32('0') < uint32(10))
}

func X__isdigit_l(tls *TLS, c int32, l locale_t) int32 { /* isdigit.c:9:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisdigit(tls, c)
}

func Xislower(tls *TLS, c int32) int32 { /* islower.c:4:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(uint32(c)-uint32('a') < uint32(26))
}

func X__islower_l(tls *TLS, c int32, l locale_t) int32 { /* islower.c:9:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xislower(tls, c)
}

func Xisprint(tls *TLS, c int32) int32 { /* isprint.c:4:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(uint32(c)-uint32(0x20) < uint32(0x5f))
}

func X__isprint_l(tls *TLS, c int32, l locale_t) int32 { /* isprint.c:9:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisprint(tls, c)
}

func Xisspace(tls *TLS, c int32) int32 { /* isspace.c:4:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(c == ' ' || uint32(c)-uint32('\t') < uint32(5))
}

func X__isspace_l(tls *TLS, c int32, l locale_t) int32 { /* isspace.c:9:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisspace(tls, c)
}

func Xisupper(tls *TLS, c int32) int32 { /* isupper.c:4:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(uint32(c)-uint32('A') < uint32(26))
}

func X__isupper_l(tls *TLS, c int32, l locale_t) int32 { /* isupper.c:9:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisupper(tls, c)
}

func Xisxdigit(tls *TLS, c int32) int32 { /* isxdigit.c:3:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v, (%v:)", tls, c, origin(2))
	}
	return Bool32(func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, c)
		}
		return Bool32(uint32(c)-uint32('0') < uint32(10))
	}() != 0 || uint32(c)|uint32(32)-uint32('a') < uint32(6))
}

func X__isxdigit_l(tls *TLS, c int32, l locale_t) int32 { /* isxdigit.c:8:5: */
	if __ccgo_strace {
		trc("tls=%v c=%v l=%v, (%v:)", tls, c, l, origin(2))
	}
	return Xisxdigit(tls, c)
}

type uintptr_t = uint64 /* alltypes.h:55:24 */

type intptr_t = int64 /* alltypes.h:70:15 */

type int8_t = int8 /* alltypes.h:96:25 */

type int16_t = int16 /* alltypes.h:101:25 */

type int32_t = int32 /* alltypes.h:106:25 */

type int64_t = int64 /* alltypes.h:111:25 */

type intmax_t = int64 /* alltypes.h:116:25 */

type uint8_t = uint8 /* alltypes.h:121:25 */

type uint16_t = uint16 /* alltypes.h:126:25 */

type uint32_t = uint32 /* alltypes.h:131:25 */

type uint64_t = uint64 /* alltypes.h:136:25 */

type uintmax_t = uint64 /* alltypes.h:146:25 */

type int_fast8_t = int8_t   /* stdint.h:22:16 */
type int_fast64_t = int64_t /* stdint.h:23:17 */

type int_least8_t = int8_t   /* stdint.h:25:17 */
type int_least16_t = int16_t /* stdint.h:26:17 */
type int_least32_t = int32_t /* stdint.h:27:17 */
type int_least64_t = int64_t /* stdint.h:28:17 */

type uint_fast8_t = uint8_t   /* stdint.h:30:17 */
type uint_fast64_t = uint64_t /* stdint.h:31:18 */

type uint_least8_t = uint8_t   /* stdint.h:33:18 */
type uint_least16_t = uint16_t /* stdint.h:34:18 */
type uint_least32_t = uint32_t /* stdint.h:35:18 */
type uint_least64_t = uint64_t /* stdint.h:36:18 */

type int_fast16_t = int32_t   /* stdint.h:1:17 */
type int_fast32_t = int32_t   /* stdint.h:2:17 */
type uint_fast16_t = uint32_t /* stdint.h:3:18 */
type uint_fast32_t = uint32_t /* stdint.h:4:18 */

type ssize_t = int64 /* alltypes.h:65:15 */

type off_t = int64 /* alltypes.h:162:16 */

type _IO_FILE = struct {
	Fflags        uint32
	F__ccgo_pad1  [4]byte
	Frpos         uintptr
	Frend         uintptr
	Fclose        uintptr
	Fwend         uintptr
	Fwpos         uintptr
	Fmustbezero_1 uintptr
	Fwbase        uintptr
	Fread         uintptr
	Fwrite        uintptr
	Fseek         uintptr
	Fbuf          uintptr
	Fbuf_size     size_t
	Fprev         uintptr
	Fnext         uintptr
	Ffd           int32
	Fpipe_pid     int32
	Flockcount    int64
	Fmode         int32
	Flock         int32
	Flbf          int32
	F__ccgo_pad2  [4]byte
	Fcookie       uintptr
	Foff          off_t
	Fgetln_buf    uintptr
	Fmustbezero_2 uintptr
	Fshend        uintptr
	Fshlim        off_t
	Fshcnt        off_t
	Fprev_locked  uintptr
	Fnext_locked  uintptr
	Flocale       uintptr
} /* alltypes.h:320:9 */

type FILE = _IO_FILE /* alltypes.h:320:25 */

type va_list = uintptr /* alltypes.h:326:27 */

type _G_fpos64_t = struct {
	F__ccgo_pad1 [0]uint64
	F__opaque    [16]int8
} /* stdio.h:54:9 */

type fpos_t = _G_fpos64_t /* stdio.h:58:3 */

type float_t = float32 /* alltypes.h:29:15 */

type double_t = float64 /* alltypes.h:34:16 */

func __FLOAT_BITS(tls *TLS, __f float32) uint32 { /* math.h:55:26: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	// var __u struct {F__f float32;} at bp, 4

	*(*float32)(unsafe.Pointer(bp)) = __f
	return *(*uint32)(unsafe.Pointer(bp))
}

func __DOUBLE_BITS(tls *TLS, __f float64) uint64 { /* math.h:61:36: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	// var __u struct {F__f float64;} at bp, 8

	*(*float64)(unsafe.Pointer(bp)) = __f
	return *(*uint64)(unsafe.Pointer(bp))
}

type syscall_arg_t = int64 /* syscall.h:22:14 */

func scanexp(tls *TLS, f uintptr, pok int32) int64 { /* floatscan.c:37:18: */
	var c int32
	var x int32
	var y int64
	var neg int32 = 0

	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if c == '+' || c == '-' {
		neg = Bool32(c == '-')
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		if uint32(c-'0') >= 10 && pok != 0 {
			if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).Frpos--
			} else {
			}
		}
	}
	if uint32(c-'0') >= 10 {
		if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).Frpos--
		} else {
		}
		return -0x7fffffffffffffff - int64(1)
	}
	for x = 0; uint32(c-'0') < 10 && x < 0x7fffffff/10; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		x = 10*x + c - '0'
	}
	for y = int64(x); uint32(c-'0') < 10 && y < 0x7fffffffffffffff/int64(100); c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		y = int64(10)*y + int64(c) - int64('0')
	}
	for ; uint32(c-'0') < 10; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
	}
	if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).Frpos--
	} else {
	}
	if neg != 0 {
		return -y
	}
	return y
}

func decfloat(tls *TLS, f uintptr, c int32, bits int32, emin int32, sign int32, pok int32) float64 { /* floatscan.c:64:20: */
	bp := tls.Alloc(512)
	defer tls.Free(512)

	// var x [128]uint32_t at bp, 512

	var i int32
	var j int32
	var k int32
	var a int32
	var z int32
	var lrp int64 = int64(0)
	var dc int64 = int64(0)
	var e10 int64 = int64(0)
	var lnz int32 = 0
	var gotdig int32 = 0
	var gotrad int32 = 0
	var rp int32
	var e2 int32
	var emax int32 = -emin - bits + 3
	var denormal int32 = 0
	var y float64
	var frac float64 = float64(0)
	var bias float64 = float64(0)

	j = 0
	k = 0

	// Don't let leading zeros consume buffer space
	for ; c == '0'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		gotdig = 1
	}
	if c == '.' {
		gotrad = 1
		for c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}(); c == '0'; c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}() {
			gotdig = 1
			lrp--
		}
	}

	*(*uint32_t)(unsafe.Pointer(bp)) = uint32_t(0)
	for ; uint32(c-'0') < 10 || c == '.'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		if c == '.' {
			if gotrad != 0 {
				break
			}
			gotrad = 1
			lrp = dc
		} else if k < 128-3 {
			dc++
			if c != '0' {
				lnz = int32(dc)
			}
			if j != 0 {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))*uint32_t(10) + uint32_t(c) - uint32_t('0')
			} else {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = uint32_t(c - '0')
			}
			if PreIncInt32(&j, 1) == 9 {
				k++
				j = 0
			}
			gotdig = 1
		} else {
			dc++
			if c != '0' {
				lnz = (128 - 4) * 9
				*(*uint32_t)(unsafe.Pointer(bp + 124*4)) |= uint32_t(1)
			}
		}
	}
	if !(gotrad != 0) {
		lrp = dc
	}

	if gotdig != 0 && c|32 == 'e' {
		e10 = scanexp(tls, f, pok)
		if e10 == -0x7fffffffffffffff-int64(1) {
			if pok != 0 {
				if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).Frpos--
				} else {
				}
			} else {
				X__shlim(tls, f, int64(0))
				return float64(0)
			}
			e10 = int64(0)
		}
		lrp = lrp + e10
	} else if c >= 0 {
		if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).Frpos--
		} else {
		}
	}
	if !(gotdig != 0) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
		X__shlim(tls, f, int64(0))
		return float64(0)
	}

	// Handle zero specially to avoid nasty special cases later
	if !(int32(*(*uint32_t)(unsafe.Pointer(bp))) != 0) {
		return float64(sign) * 0.0
	}

	// Optimize small integers (w/no exponent) and over/under-flow
	if lrp == dc && dc < int64(10) && (bits > 30 || *(*uint32_t)(unsafe.Pointer(bp))>>bits == uint32_t(0)) {
		return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp)))
	}
	if lrp > int64(-emin/2) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 1.79769313486231570815e+308 * 1.79769313486231570815e+308
	}
	if lrp < int64(emin-2*53) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 2.22507385850720138309e-308 * 2.22507385850720138309e-308
	}

	// Align incomplete final B1B digit
	if j != 0 {
		for ; j < 9; j++ {
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) *= uint32_t(10)
		}
		k++
		j = 0
	}

	a = 0
	z = k
	e2 = 0
	rp = int32(lrp)

	// Optimize small to mid-size integers (even in exp. notation)
	if lnz < 9 && lnz <= rp && rp < 18 {
		if rp == 9 {
			return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp)))
		}
		if rp < 9 {
			return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp))) / float64(_sp10s[8-rp])
		}
		var bitlim int32 = bits - 3*(rp-9)
		if bitlim > 30 || *(*uint32_t)(unsafe.Pointer(bp))>>bitlim == uint32_t(0) {
			return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp))) * float64(_sp10s[rp-10])
		}
	}

	// Drop trailing zeros
	for ; !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(z-1)*4))) != 0); z-- {
	}

	// Align radix point to B1B digit boundary
	if rp%9 != 0 {
		var rpm9 int32
		if rp >= 0 {
			rpm9 = rp % 9
		} else {
			rpm9 = rp%9 + 9
		}
		var p10 int32 = _sp10s[8-rpm9]
		var carry uint32_t = uint32_t(0)
		for k = a; k != z; k++ {
			var tmp uint32_t = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) % uint32_t(p10)
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))/uint32_t(p10) + carry
			carry = uint32_t(1000000000/p10) * tmp
			if k == a && !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))) != 0) {
				a = (a + 1) & (128 - 1)
				rp = rp - 9
			}
		}
		if carry != 0 {
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(PostIncInt32(&z, 1))*4)) = carry
		}
		rp = rp + (9 - rpm9)
	}

	// Upscale until desired number of bits are left of radix point
	for rp < 9*2 || rp == 9*2 && *(*uint32_t)(unsafe.Pointer(bp + uintptr(a)*4)) < _sth[0] {
		var carry uint32_t = uint32_t(0)
		e2 = e2 - 29
		for k = (z - 1) & (128 - 1); ; k = (k - 1) & (128 - 1) {
			var tmp uint64_t = uint64_t(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)))<<29 + uint64_t(carry)
			if tmp > uint64(1000000000) {
				carry = uint32_t(tmp / uint64(1000000000))
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = uint32_t(tmp % uint64(1000000000))
			} else {
				carry = uint32_t(0)
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = uint32_t(tmp)
			}
			if k == (z-1)&(128-1) && k != a && !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))) != 0) {
				z = k
			}
			if k == a {
				break
			}
		}
		if carry != 0 {
			rp = rp + 9
			a = (a - 1) & (128 - 1)
			if a == z {
				z = (z - 1) & (128 - 1)
				*(*uint32_t)(unsafe.Pointer(bp + uintptr((z-1)&(128-1))*4)) |= *(*uint32_t)(unsafe.Pointer(bp + uintptr(z)*4))
			}
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(a)*4)) = carry
		}
	}

	// Downscale until exactly number of bits are left of radix point
	for {
		var carry uint32_t = uint32_t(0)
		var sh int32 = 1
		for i = 0; i < 2; i++ {
			k = (a + i) & (128 - 1)
			if k == z || *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) < _sth[i] {
				i = 2
				break
			}
			if *(*uint32_t)(unsafe.Pointer(bp + uintptr((a+i)&(128-1))*4)) > _sth[i] {
				break
			}
		}
		if i == 2 && rp == 9*2 {
			break
		}
		// FIXME: find a way to compute optimal sh
		if rp > 9+9*2 {
			sh = 9
		}
		e2 = e2 + sh
		for k = a; k != z; k = (k + 1) & (128 - 1) {
			var tmp uint32_t = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) & uint32_t(int32(1)<<sh-1)
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))>>sh + carry
			carry = uint32_t(int32(1000000000)>>sh) * tmp
			if k == a && !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))) != 0) {
				a = (a + 1) & (128 - 1)
				i--
				rp = rp - 9
			}
		}
		if carry != 0 {
			if (z+1)&(128-1) != a {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(z)*4)) = carry
				z = (z + 1) & (128 - 1)
			} else {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr((z-1)&(128-1))*4)) |= uint32_t(1)
			}
		}
	}

	// Assemble desired bits into floating point variable
	for y = float64(AssignInt32(&i, 0)); i < 2; i++ {
		if (a+i)&(128-1) == z {
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(AssignInt32(&z, (z+1)&(128-1))-1)*4)) = uint32_t(0)
		}
		y = 1000000000.0*y + float64(*(*uint32_t)(unsafe.Pointer(bp + uintptr((a+i)&(128-1))*4)))
	}

	y = y * float64(sign)

	// Limit precision for denormal results
	if bits > 53+e2-emin {
		bits = 53 + e2 - emin
		if bits < 0 {
			bits = 0
		}
		denormal = 1
	}

	// Calculate bias term to force rounding, move out lower bits
	if bits < 53 {
		bias = Xcopysignl(tls, Xscalbn(tls, float64(1), 2*53-bits-1), y)
		frac = Xfmodl(tls, y, Xscalbn(tls, float64(1), 53-bits))
		y = y - frac
		y = y + bias
	}

	// Process tail of decimal input so it can affect rounding
	if (a+i)&(128-1) != z {
		var t uint32_t = *(*uint32_t)(unsafe.Pointer(bp + uintptr((a+i)&(128-1))*4))
		if t < uint32_t(500000000) && (t != 0 || (a+i+1)&(128-1) != z) {
			frac = frac + 0.25*float64(sign)
		} else if t > uint32_t(500000000) {
			frac = frac + 0.75*float64(sign)
		} else if t == uint32_t(500000000) {
			if (a+i+1)&(128-1) == z {
				frac = frac + 0.5*float64(sign)
			} else {
				frac = frac + 0.75*float64(sign)
			}
		}
		if 53-bits >= 2 && !(Xfmodl(tls, frac, float64(1)) != 0) {
			frac += 1
		}
	}

	y = y + frac
	y = y - bias

	if (e2+53)&0x7fffffff > emax-5 {
		if Xfabsl(tls, y) >= float64(float64(2))/2.22044604925031308085e-16 {
			if denormal != 0 && bits == 53+e2-emin {
				denormal = 0
			}
			y = y * 0.5
			e2++
		}
		if e2+53 > emax || denormal != 0 && frac != 0 {
			*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		}
	}

	return Xscalbnl(tls, y, e2)
}

var _sth = [2]uint32_t{uint32_t(9007199), uint32_t(254740991)} /* floatscan.c:67:24 */
var _sp10s = [8]int32{10, 100, 1000, 10000,
	100000, 1000000, 10000000, 100000000} /* floatscan.c:80:19 */

func hexfloat(tls *TLS, f uintptr, bits int32, emin int32, sign int32, pok int32) float64 { /* floatscan.c:315:20: */
	var x uint32_t = uint32_t(0)
	var y float64 = float64(0)
	var scale float64 = float64(1)
	var bias float64 = float64(0)
	var gottail int32 = 0
	var gotrad int32 = 0
	var gotdig int32 = 0
	var rp int64 = int64(0)
	var dc int64 = int64(0)
	var e2 int64 = int64(0)
	var d int32
	var c int32

	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()

	// Skip leading zeros
	for ; c == '0'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		gotdig = 1
	}

	if c == '.' {
		gotrad = 1
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		// Count zeros after the radix point before significand
		rp = int64(0)
	__1:
		if !(c == '0') {
			goto __3
		}
		gotdig = 1
		goto __2
	__2:
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		rp--
		goto __1
		goto __3
	__3:
	}

	for ; uint32(c-'0') < 10 || uint32(c|32-'a') < 6 || c == '.'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		if c == '.' {
			if gotrad != 0 {
				break
			}
			rp = dc
			gotrad = 1
		} else {
			gotdig = 1
			if c > '9' {
				d = c | 32 + 10 - 'a'
			} else {
				d = c - '0'
			}
			if dc < int64(8) {
				x = x*uint32_t(16) + uint32_t(d)
			} else if dc < int64(53/4+1) {
				y = y + float64(d)*AssignDivFloat64(&scale, float64(16))
			} else if d != 0 && !(gottail != 0) {
				y = y + 0.5*scale
				gottail = 1
			}
			dc++
		}
	}
	if !(gotdig != 0) {
		if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).Frpos--
		} else {
		}
		if pok != 0 {
			if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).Frpos--
			} else {
			}
			if gotrad != 0 {
				if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).Frpos--
				} else {
				}
			}
		} else {
			X__shlim(tls, f, int64(0))
		}
		return float64(sign) * 0.0
	}
	if !(gotrad != 0) {
		rp = dc
	}
	for dc < int64(8) {
		x = x * uint32_t(16)
		dc++
	}
	if c|32 == 'p' {
		e2 = scanexp(tls, f, pok)
		if e2 == -0x7fffffffffffffff-int64(1) {
			if pok != 0 {
				if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).Frpos--
				} else {
				}
			} else {
				X__shlim(tls, f, int64(0))
				return float64(0)
			}
			e2 = int64(0)
		}
	} else {
		if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).Frpos--
		} else {
		}
	}
	e2 = e2 + (int64(4)*rp - int64(32))

	if !(x != 0) {
		return float64(sign) * 0.0
	}
	if e2 > int64(-emin) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 1.79769313486231570815e+308 * 1.79769313486231570815e+308
	}
	if e2 < int64(emin-2*53) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 2.22507385850720138309e-308 * 2.22507385850720138309e-308
	}

	for x < 0x80000000 {
		if y >= 0.5 {
			x = x + (x + uint32_t(1))
			y = y + (y - float64(1))
		} else {
			x = x + x
			y = y + y
		}
		e2--
	}

	if int64(bits) > int64(32)+e2-int64(emin) {
		bits = int32(int64(32) + e2 - int64(emin))
		if bits < 0 {
			bits = 0
		}
	}

	if bits < 53 {
		bias = Xcopysignl(tls, Xscalbn(tls, float64(1), 32+53-bits-1), float64(sign))
	}

	if bits < 32 && y != 0 && !(x&uint32_t(1) != 0) {
		x++
		y = float64(0)
	}

	y = bias + float64(sign)*float64(x) + float64(sign)*y
	y = y - bias

	if !(y != 0) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	}

	return Xscalbnl(tls, y, int32(e2))
}

func X__floatscan(tls *TLS, f uintptr, prec int32, pok int32) float64 { /* floatscan.c:427:13: */
	if __ccgo_strace {
		trc("tls=%v f=%v prec=%v pok=%v, (%v:)", tls, f, prec, pok, origin(2))
	}
	var sign int32 = 1
	var i size_t
	var bits int32
	var emin int32
	var c int32

	switch prec {
	case 0:
		bits = 24
		emin = -125 - bits
		break
	case 1:
		bits = 53
		emin = -1021 - bits
		break
	case 2:
		bits = 53
		emin = -1021 - bits
		break
	default:
		return float64(0)
	}

	for __isspace(tls, AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}())) != 0 {
	}

	if c == '+' || c == '-' {
		sign = sign - 2*Bool32(c == '-')
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
	}

	for i = uint64(0); i < uint64(8) && c|32 == int32(*(*int8)(unsafe.Pointer(ts /* "infinity" */ + uintptr(i)))); i++ {
		if i < uint64(7) {
			c = func() int32 {
				if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
					return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
				}
				return X__shgetc(tls, f)
			}()
		}
	}
	if i == uint64(3) || i == uint64(8) || i > uint64(3) && pok != 0 {
		if i != uint64(8) {
			if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).Frpos--
			} else {
			}
			if pok != 0 {
				for ; i > uint64(3); i-- {
					if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
						(*FILE)(unsafe.Pointer(f)).Frpos--
					} else {
					}
				}
			}
		}
		return float64(float32(sign) * X__builtin_inff(tls))
	}
	if !(i != 0) {
		for i = uint64(0); i < uint64(3) && c|32 == int32(*(*int8)(unsafe.Pointer(ts + 9 /* "nan" */ + uintptr(i)))); i++ {
			if i < uint64(2) {
				c = func() int32 {
					if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
						return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
					}
					return X__shgetc(tls, f)
				}()
			}
		}
	}
	if i == uint64(3) {
		if func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}() != '(' {
			if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).Frpos--
			} else {
			}
			return float64(X__builtin_nanf(tls, ts+13))
		}
		for i = uint64(1); ; i++ {
			c = func() int32 {
				if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
					return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
				}
				return X__shgetc(tls, f)
			}()
			if uint32(c-'0') < 10 || uint32(c-'A') < 26 || uint32(c-'a') < 26 || c == '_' {
				continue
			}
			if c == ')' {
				return float64(X__builtin_nanf(tls, ts+13))
			}
			if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).Frpos--
			} else {
			}
			if !(pok != 0) {
				*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
				X__shlim(tls, f, int64(0))
				return float64(0)
			}
			for PostDecUint64(&i, 1) != 0 {
				if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).Frpos--
				} else {
				}
			}
			return float64(X__builtin_nanf(tls, ts+13))
		}
		return float64(X__builtin_nanf(tls, ts+13))
	}

	if i != 0 {
		if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).Frpos--
		} else {
		}
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
		X__shlim(tls, f, int64(0))
		return float64(0)
	}

	if c == '0' {
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		if c|32 == 'x' {
			return hexfloat(tls, f, bits, emin, sign, pok)
		}
		if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).Frpos--
		} else {
		}
		c = '0'
	}

	return decfloat(tls, f, c, bits, emin, sign, pok)
}

// Lookup table for digit values. -1==255>=36 -> invalid
var table = [257]uint8{Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	uint8(0), uint8(1), uint8(2), uint8(3), uint8(4), uint8(5), uint8(6), uint8(7), uint8(8), uint8(9), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), uint8(10), uint8(11), uint8(12), uint8(13), uint8(14), uint8(15), uint8(16), uint8(17), uint8(18), uint8(19), uint8(20), uint8(21), uint8(22), uint8(23), uint8(24),
	uint8(25), uint8(26), uint8(27), uint8(28), uint8(29), uint8(30), uint8(31), uint8(32), uint8(33), uint8(34), uint8(35), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), uint8(10), uint8(11), uint8(12), uint8(13), uint8(14), uint8(15), uint8(16), uint8(17), uint8(18), uint8(19), uint8(20), uint8(21), uint8(22), uint8(23), uint8(24),
	uint8(25), uint8(26), uint8(27), uint8(28), uint8(29), uint8(30), uint8(31), uint8(32), uint8(33), uint8(34), uint8(35), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
} /* intscan.c:7:28 */

func X__intscan(tls *TLS, f uintptr, base uint32, pok int32, lim uint64) uint64 { /* intscan.c:26:20: */
	if __ccgo_strace {
		trc("tls=%v f=%v base=%v pok=%v lim=%v, (%v:)", tls, f, base, pok, lim, origin(2))
	}
	var val uintptr
	var c int32
	var neg int32
	var x uint32
	var y uint64
	var bs int32
	val = uintptr(unsafe.Pointer(&table)) + uintptr(1)
	neg = 0
	if !(base > uint32(36) || base == uint32(1)) {
		goto __1
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
	return uint64(0)
__1:
	;
__2:
	if !(__isspace(tls, AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}())) != 0) {
		goto __3
	}
	goto __2
__3:
	;
	if !(c == '+' || c == '-') {
		goto __4
	}
	neg = -Bool32(c == '-')
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
__4:
	;
	if !((base == uint32(0) || base == uint32(16)) && c == '0') {
		goto __5
	}
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if !(c|32 == 'x') {
		goto __7
	}
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if !(int32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) >= 16) {
		goto __9
	}
	if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).Frpos--
	} else {
	}
	if !(pok != 0) {
		goto __10
	}
	if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).Frpos--
	} else {
	}
	goto __11
__10:
	X__shlim(tls, f, int64(0))
__11:
	;
	return uint64(0)
__9:
	;
	base = uint32(16)
	goto __8
__7:
	if !(base == uint32(0)) {
		goto __12
	}
	base = uint32(8)
__12:
	;
__8:
	;
	goto __6
__5:
	if !(base == uint32(0)) {
		goto __13
	}
	base = uint32(10)
__13:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) >= base) {
		goto __14
	}
	if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).Frpos--
	} else {
	}
	X__shlim(tls, f, int64(0))
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
	return uint64(0)
__14:
	;
__6:
	;
	if !(base == uint32(10)) {
		goto __15
	}
	x = uint32(0)
__17:
	if !(uint32(c-'0') < 10 && x <= 0xffffffff/uint32(10)-uint32(1)) {
		goto __19
	}
	x = x*uint32(10) + uint32(c-'0')
	goto __18
__18:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __17
	goto __19
__19:
	;
	y = uint64(x)
__20:
	if !(uint32(c-'0') < 10 && y <= (2*uint64(0x7fffffffffffffff)+uint64(1))/uint64(10) && uint64(10)*y <= 2*uint64(0x7fffffffffffffff)+uint64(1)-uint64(c-'0')) {
		goto __22
	}
	y = y*uint64(10) + uint64(c-'0')
	goto __21
__21:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __20
	goto __22
__22:
	;
	if !(uint32(c-'0') >= 10) {
		goto __23
	}
	goto done
__23:
	;
	goto __16
__15:
	if !!(base&(base-uint32(1)) != 0) {
		goto __24
	}
	bs = int32(*(*int8)(unsafe.Pointer(ts + 14 + uintptr(uint32(0x17)*base>>5&uint32(7)))))
	x = uint32(0)
__26:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && x <= 0xffffffff/uint32(32)) {
		goto __28
	}
	x = x<<bs | uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __27
__27:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __26
	goto __28
__28:
	;
	y = uint64(x)
__29:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && y <= uint64(2*uint64(0x7fffffffffffffff)+uint64(1))>>bs) {
		goto __31
	}
	y = y<<bs | uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __30
__30:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __29
	goto __31
__31:
	;
	goto __25
__24:
	x = uint32(0)
__32:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && x <= 0xffffffff/uint32(36)-uint32(1)) {
		goto __34
	}
	x = x*base + uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __33
__33:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __32
	goto __34
__34:
	;
	y = uint64(x)
__35:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && y <= (2*uint64(0x7fffffffffffffff)+uint64(1))/uint64(base) && uint64(base)*y <= 2*uint64(0x7fffffffffffffff)+uint64(1)-uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))) {
		goto __37
	}
	y = y*uint64(base) + uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __36
__36:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __35
	goto __37
__37:
	;
__25:
	;
__16:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) {
		goto __38
	}
__39:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) {
		goto __41
	}
	goto __40
__40:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).Frpos != (*FILE)(unsafe.Pointer(f)).Fshend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).Frpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __39
	goto __41
__41:
	;
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	y = lim
	if !(lim&uint64(1) != 0) {
		goto __42
	}
	neg = 0
__42:
	;
__38:
	;
done:
	if (*FILE)(unsafe.Pointer(f)).Fshlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).Frpos--
	} else {
	}
	if !(y >= lim) {
		goto __43
	}
	if !(!(lim&uint64(1) != 0) && !(neg != 0)) {
		goto __44
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	return lim - uint64(1)
	goto __45
__44:
	if !(y > lim) {
		goto __46
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	return lim
__46:
	;
__45:
	;
__43:
	;
	return y ^ uint64(neg) - uint64(neg)
}

// The shcnt field stores the number of bytes read so far, offset by
// the value of buf-rpos at the last function call (__shlim or __shgetc),
// so that between calls the inline shcnt macro can add rpos-buf to get
// the actual count.

func X__shlim(tls *TLS, f uintptr, lim off_t) { /* shgetc.c:8:6: */
	if __ccgo_strace {
		trc("tls=%v f=%v lim=%v, (%v:)", tls, f, lim, origin(2))
	}
	(*FILE)(unsafe.Pointer(f)).Fshlim = lim
	(*FILE)(unsafe.Pointer(f)).Fshcnt = (int64((*FILE)(unsafe.Pointer(f)).Fbuf) - int64((*FILE)(unsafe.Pointer(f)).Frpos)) / 1
	// If lim is nonzero, rend must be a valid pointer.
	if lim != 0 && (int64((*FILE)(unsafe.Pointer(f)).Frend)-int64((*FILE)(unsafe.Pointer(f)).Frpos))/1 > lim {
		(*FILE)(unsafe.Pointer(f)).Fshend = (*FILE)(unsafe.Pointer(f)).Frpos + uintptr(lim)
	} else {
		(*FILE)(unsafe.Pointer(f)).Fshend = (*FILE)(unsafe.Pointer(f)).Frend
	}
}

func X__shgetc(tls *TLS, f uintptr) int32 { /* shgetc.c:19:5: */
	if __ccgo_strace {
		trc("tls=%v f=%v, (%v:)", tls, f, origin(2))
	}
	var c int32
	var cnt off_t = (*FILE)(unsafe.Pointer(f)).Fshcnt + (int64((*FILE)(unsafe.Pointer(f)).Frpos)-int64((*FILE)(unsafe.Pointer(f)).Fbuf))/1
	if (*FILE)(unsafe.Pointer(f)).Fshlim != 0 && cnt >= (*FILE)(unsafe.Pointer(f)).Fshlim || AssignInt32(&c, X__uflow(tls, f)) < 0 {
		(*FILE)(unsafe.Pointer(f)).Fshcnt = (int64((*FILE)(unsafe.Pointer(f)).Fbuf)-int64((*FILE)(unsafe.Pointer(f)).Frpos))/1 + cnt
		(*FILE)(unsafe.Pointer(f)).Fshend = (*FILE)(unsafe.Pointer(f)).Frpos
		(*FILE)(unsafe.Pointer(f)).Fshlim = int64(-1)
		return -1
	}
	cnt++
	if (*FILE)(unsafe.Pointer(f)).Fshlim != 0 && (int64((*FILE)(unsafe.Pointer(f)).Frend)-int64((*FILE)(unsafe.Pointer(f)).Frpos))/1 > (*FILE)(unsafe.Pointer(f)).Fshlim-cnt {
		(*FILE)(unsafe.Pointer(f)).Fshend = (*FILE)(unsafe.Pointer(f)).Frpos + uintptr((*FILE)(unsafe.Pointer(f)).Fshlim-cnt)
	} else {
		(*FILE)(unsafe.Pointer(f)).Fshend = (*FILE)(unsafe.Pointer(f)).Frend
	}
	(*FILE)(unsafe.Pointer(f)).Fshcnt = (int64((*FILE)(unsafe.Pointer(f)).Fbuf)-int64((*FILE)(unsafe.Pointer(f)).Frpos))/1 + cnt
	if (*FILE)(unsafe.Pointer(f)).Frpos <= (*FILE)(unsafe.Pointer(f)).Fbuf {
		*(*uint8)(unsafe.Pointer((*FILE)(unsafe.Pointer(f)).Frpos + UintptrFromInt32(-1))) = uint8(c)
	}
	return c
}

func __bswap32(tls *TLS, __x uint32_t) uint32_t { /* endian.h:24:26: */
	return __x>>24 | __x>>8&uint32_t(0xff00) | __x<<8&uint32_t(0xff0000) | __x<<24
}

func Xcopysignl(tls *TLS, x float64, y float64) float64 { /* copysignl.c:4:13: */
	if __ccgo_strace {
		trc("tls=%v x=%v y=%v, (%v:)", tls, x, y, origin(2))
	}
	return Xcopysign(tls, x, y)
}

func Xfabsl(tls *TLS, x float64) float64 { /* fabsl.c:3:13: */
	if __ccgo_strace {
		trc("tls=%v x=%v, (%v:)", tls, x, origin(2))
	}
	return Xfabs(tls, x)
}

func Xfmodl(tls *TLS, x float64, y float64) float64 { /* fmodl.c:4:13: */
	if __ccgo_strace {
		trc("tls=%v x=%v y=%v, (%v:)", tls, x, y, origin(2))
	}
	return Xfmod(tls, x, y)
}

var toint double_t = float64(float64(1)) / 2.22044604925031308085e-16 /* rint.c:10:23 */

func Xrint(tls *TLS, x float64) float64 { /* rint.c:12:8: */
	if __ccgo_strace {
		trc("tls=%v x=%v, (%v:)", tls, x, origin(2))
	}
	bp := tls.Alloc(8)
	defer tls.Free(8)

	*(*struct{ Ff float64 })(unsafe.Pointer(bp)) = func() (r struct{ Ff float64 }) {
		*(*float64)(unsafe.Pointer(uintptr(unsafe.Pointer(&r)) + 0)) = x
		return r
	}()
	var e int32 = int32(*(*uint64_t)(unsafe.Pointer(bp)) >> 52 & uint64(0x7ff))
	var s int32 = int32(*(*uint64_t)(unsafe.Pointer(bp)) >> 63)
	var y double_t

	if e >= 0x3ff+52 {
		return x
	}
	if s != 0 {
		y = x - toint + toint
	} else {
		y = x + toint - toint
	}
	if y == float64(0) {
		if s != 0 {
			return -Float64FromFloat64(0.0)
		}
		return float64(0)
	}
	return y
}

func Xscalbn(tls *TLS, x float64, n int32) float64 { /* scalbn.c:4:8: */
	if __ccgo_strace {
		trc("tls=%v x=%v n=%v, (%v:)", tls, x, n, origin(2))
	}
	bp := tls.Alloc(8)
	defer tls.Free(8)

	// var u struct {Ff float64;} at bp, 8

	var y double_t = x

	if n > 1023 {
		y = y * 0x1p1023
		n = n - 1023
		if n > 1023 {
			y = y * 0x1p1023
			n = n - 1023
			if n > 1023 {
				n = 1023
			}
		}
	} else if n < -1022 {
		// make sure final n < -53 to avoid double
		// 		   rounding in the subnormal range
		y = y * (float64(0x1p-1022) * 0x1p53)
		n = n + (1022 - 53)
		if n < -1022 {
			y = y * (float64(0x1p-1022) * 0x1p53)
			n = n + (1022 - 53)
			if n < -1022 {
				n = -1022
			}
		}
	}
	*(*uint64_t)(unsafe.Pointer(bp)) = uint64_t(0x3ff+n) << 52
	x = y * *(*float64)(unsafe.Pointer(bp))
	return x
}

func Xscalbnl(tls *TLS, x float64, n int32) float64 { /* scalbnl.c:4:13: */
	if __ccgo_strace {
		trc("tls=%v x=%v n=%v, (%v:)", tls, x, n, origin(2))
	}
	return Xscalbn(tls, x, n)
}

type div_t = struct {
	Fquot int32
	Frem  int32
} /* stdlib.h:62:35 */
type ldiv_t = struct {
	Fquot int64
	Frem  int64
} /* stdlib.h:63:36 */
type lldiv_t = struct {
	Fquot int64
	Frem  int64
} /* stdlib.h:64:41 */

type max_align_t = struct {
	F__ll int64
	F__ld float64
} /* alltypes.h:41:54 */

type imaxdiv_t = struct {
	Fquot intmax_t
	Frem  intmax_t
} /* inttypes.h:14:40 */

type pid_t = int32 /* alltypes.h:235:13 */

type uid_t = uint32 /* alltypes.h:245:18 */

type gid_t = uint32 /* alltypes.h:250:18 */

type iovec = struct {
	Fiov_base uintptr
	Fiov_len  size_t
} /* alltypes.h:355:1 */

type socklen_t = uint32 /* alltypes.h:361:18 */

type sa_family_t = uint16 /* alltypes.h:366:24 */

type msghdr = struct {
	Fmsg_name       uintptr
	Fmsg_namelen    socklen_t
	F__ccgo_pad1    [4]byte
	Fmsg_iov        uintptr
	Fmsg_iovlen     int32
	F__pad1         int32
	Fmsg_control    uintptr
	Fmsg_controllen socklen_t
	F__pad2         int32
	Fmsg_flags      int32
	F__ccgo_pad2    [4]byte
} /* socket.h:22:1 */

type cmsghdr = struct {
	Fcmsg_len   socklen_t
	F__pad1     int32
	Fcmsg_level int32
	Fcmsg_type  int32
} /* socket.h:44:1 */

type linger = struct {
	Fl_onoff  int32
	Fl_linger int32
} /* socket.h:74:1 */

type sockaddr = struct {
	Fsa_family sa_family_t
	Fsa_data   [14]int8
} /* socket.h:367:1 */

type sockaddr_storage = struct {
	Fss_family    sa_family_t
	F__ss_padding [118]int8
	F__ss_align   uint64
} /* socket.h:372:1 */

type in_port_t = uint16_t                  /* in.h:12:18 */
type in_addr_t = uint32_t                  /* in.h:13:18 */
type in_addr = struct{ Fs_addr in_addr_t } /* in.h:14:1 */

type sockaddr_in = struct {
	Fsin_family sa_family_t
	Fsin_port   in_port_t
	Fsin_addr   struct{ Fs_addr in_addr_t }
	Fsin_zero   [8]uint8_t
} /* in.h:16:1 */

type in6_addr = struct {
	F__in6_union struct {
		F__ccgo_pad1 [0]uint32
		F__s6_addr   [16]uint8_t
	}
} /* in.h:23:1 */

type sockaddr_in6 = struct {
	Fsin6_family   sa_family_t
	Fsin6_port     in_port_t
	Fsin6_flowinfo uint32_t
	Fsin6_addr     struct {
		F__in6_union struct {
			F__ccgo_pad1 [0]uint32
			F__s6_addr   [16]uint8_t
		}
	}
	Fsin6_scope_id uint32_t
} /* in.h:34:1 */

type ipv6_mreq = struct {
	Fipv6mr_multiaddr struct {
		F__in6_union struct {
			F__ccgo_pad1 [0]uint32
			F__s6_addr   [16]uint8_t
		}
	}
	Fipv6mr_interface uint32
} /* in.h:42:1 */

type ip_opts = struct {
	Fip_dst  struct{ Fs_addr in_addr_t }
	Fip_opts [40]int8
} /* in.h:229:1 */

type ip_mreq = struct {
	Fimr_multiaddr struct{ Fs_addr in_addr_t }
	Fimr_interface struct{ Fs_addr in_addr_t }
} /* in.h:247:1 */

type ip_mreqn = struct {
	Fimr_multiaddr struct{ Fs_addr in_addr_t }
	Fimr_address   struct{ Fs_addr in_addr_t }
	Fimr_ifindex   int32
} /* in.h:252:1 */

type ip_mreq_source = struct {
	Fimr_multiaddr  struct{ Fs_addr in_addr_t }
	Fimr_interface  struct{ Fs_addr in_addr_t }
	Fimr_sourceaddr struct{ Fs_addr in_addr_t }
} /* in.h:258:1 */

type ip_msfilter = struct {
	Fimsf_multiaddr struct{ Fs_addr in_addr_t }
	Fimsf_interface struct{ Fs_addr in_addr_t }
	Fimsf_fmode     uint32_t
	Fimsf_numsrc    uint32_t
	Fimsf_slist     [1]struct{ Fs_addr in_addr_t }
} /* in.h:264:1 */

type group_req = struct {
	Fgr_interface uint32_t
	F__ccgo_pad1  [4]byte
	Fgr_group     struct {
		Fss_family    sa_family_t
		F__ss_padding [118]int8
		F__ss_align   uint64
	}
} /* in.h:275:1 */

type group_source_req = struct {
	Fgsr_interface uint32_t
	F__ccgo_pad1   [4]byte
	Fgsr_group     struct {
		Fss_family    sa_family_t
		F__ss_padding [118]int8
		F__ss_align   uint64
	}
	Fgsr_source struct {
		Fss_family    sa_family_t
		F__ss_padding [118]int8
		F__ss_align   uint64
	}
} /* in.h:280:1 */

type group_filter = struct {
	Fgf_interface uint32_t
	F__ccgo_pad1  [4]byte
	Fgf_group     struct {
		Fss_family    sa_family_t
		F__ss_padding [118]int8
		F__ss_align   uint64
	}
	Fgf_fmode  uint32_t
	Fgf_numsrc uint32_t
	Fgf_slist  [1]struct {
		Fss_family    sa_family_t
		F__ss_padding [118]int8
		F__ss_align   uint64
	}
} /* in.h:286:1 */

type in_pktinfo = struct {
	Fipi_ifindex  int32
	Fipi_spec_dst struct{ Fs_addr in_addr_t }
	Fipi_addr     struct{ Fs_addr in_addr_t }
} /* in.h:297:1 */

type in6_pktinfo = struct {
	Fipi6_addr struct {
		F__in6_union struct {
			F__ccgo_pad1 [0]uint32
			F__s6_addr   [16]uint8_t
		}
	}
	Fipi6_ifindex uint32
} /* in.h:303:1 */

type ip6_mtuinfo = struct {
	Fip6m_addr struct {
		Fsin6_family   sa_family_t
		Fsin6_port     in_port_t
		Fsin6_flowinfo uint32_t
		Fsin6_addr     struct {
			F__in6_union struct {
				F__ccgo_pad1 [0]uint32
				F__s6_addr   [16]uint8_t
			}
		}
		Fsin6_scope_id uint32_t
	}
	Fip6m_mtu uint32_t
} /* in.h:308:1 */

type addrinfo = struct {
	Fai_flags     int32
	Fai_family    int32
	Fai_socktype  int32
	Fai_protocol  int32
	Fai_addrlen   socklen_t
	F__ccgo_pad1  [4]byte
	Fai_addr      uintptr
	Fai_canonname uintptr
	Fai_next      uintptr
} /* netdb.h:16:1 */

// Legacy functions follow (marked OBsolete in SUS)

type netent = struct {
	Fn_name     uintptr
	Fn_aliases  uintptr
	Fn_addrtype int32
	Fn_net      uint32_t
} /* netdb.h:62:1 */

type hostent = struct {
	Fh_name      uintptr
	Fh_aliases   uintptr
	Fh_addrtype  int32
	Fh_length    int32
	Fh_addr_list uintptr
} /* netdb.h:69:1 */

type servent = struct {
	Fs_name      uintptr
	Fs_aliases   uintptr
	Fs_port      int32
	F__ccgo_pad1 [4]byte
	Fs_proto     uintptr
} /* netdb.h:78:1 */

type protoent = struct {
	Fp_name      uintptr
	Fp_aliases   uintptr
	Fp_proto     int32
	F__ccgo_pad1 [4]byte
} /* netdb.h:85:1 */

type aibuf = struct {
	Fai struct {
		Fai_flags     int32
		Fai_family    int32
		Fai_socktype  int32
		Fai_protocol  int32
		Fai_addrlen   socklen_t
		F__ccgo_pad1  [4]byte
		Fai_addr      uintptr
		Fai_canonname uintptr
		Fai_next      uintptr
	}
	Fsa struct {
		Fsin struct {
			Fsin_family sa_family_t
			Fsin_port   in_port_t
			Fsin_addr   struct{ Fs_addr in_addr_t }
			Fsin_zero   [8]uint8_t
		}
		F__ccgo_pad1 [12]byte
	}
	Flock        [1]int32
	Fslot        int16
	Fref         int16
	F__ccgo_pad1 [4]byte
} /* lookup.h:10:1 */

type sa = struct {
	Fsin struct {
		Fsin_family sa_family_t
		Fsin_port   in_port_t
		Fsin_addr   struct{ Fs_addr in_addr_t }
		Fsin_zero   [8]uint8_t
	}
	F__ccgo_pad1 [12]byte
} /* lookup.h:10:1 */

type address = struct {
	Ffamily  int32
	Fscopeid uint32
	Faddr    [16]uint8_t
	Fsortkey int32
} /* lookup.h:20:1 */

type service = struct {
	Fport     uint16_t
	Fproto    uint8
	Fsocktype uint8
} /* lookup.h:27:1 */

type resolvconf = struct {
	Fns [3]struct {
		Ffamily  int32
		Fscopeid uint32
		Faddr    [16]uint8_t
		Fsortkey int32
	}
	Fnns      uint32
	Fattempts uint32
	Fndots    uint32
	Ftimeout  uint32
} /* lookup.h:34:1 */

func Xfreeaddrinfo(tls *TLS, p uintptr) { /* freeaddrinfo.c:7:6: */
	if __ccgo_strace {
		trc("tls=%v p=%v, (%v:)", tls, p, origin(2))
	}
	var cnt size_t
	cnt = uint64(1)
__1:
	if !((*addrinfo)(unsafe.Pointer(p)).Fai_next != 0) {
		goto __3
	}
	goto __2
__2:
	cnt++
	p = (*addrinfo)(unsafe.Pointer(p)).Fai_next
	goto __1
	goto __3
__3:
	;
	var b uintptr = p - uintptr(uint64(uintptr(0)))
	b -= 88 * uintptr((*aibuf)(unsafe.Pointer(b)).Fslot)
	//TODO LOCK(b->lock);
	if !(int32(AssignSubPtrInt16(b+82, int16(cnt))) != 0) {
		Xfree(tls, b)
	}
	//TODO else UNLOCK(b->lock);
}

type time_t = int64 /* alltypes.h:85:16 */

type clockid_t = int32 /* alltypes.h:214:13 */

type timespec = struct {
	Ftv_sec  time_t
	Ftv_nsec int64
} /* alltypes.h:229:1 */

type pthread_t = uintptr /* alltypes.h:273:26 */

type pthread_once_t = int32 /* alltypes.h:279:13 */

type pthread_key_t = uint32 /* alltypes.h:284:18 */

type pthread_spinlock_t = int32 /* alltypes.h:289:13 */

type pthread_mutexattr_t = struct{ F__attr uint32 } /* alltypes.h:294:37 */

type pthread_condattr_t = struct{ F__attr uint32 } /* alltypes.h:299:37 */

type pthread_barrierattr_t = struct{ F__attr uint32 } /* alltypes.h:304:37 */

type pthread_rwlockattr_t = struct{ F__attr [2]uint32 } /* alltypes.h:309:40 */

type __sigset_t = struct{ F__bits [16]uint64 } /* alltypes.h:349:9 */

type sigset_t = __sigset_t /* alltypes.h:349:71 */

type pthread_attr_t = struct {
	F__u struct {
		F__ccgo_pad1 [0]uint64
		F__i         [14]int32
	}
} /* alltypes.h:372:147 */

type pthread_mutex_t = struct {
	F__u struct {
		F__ccgo_pad1 [0]uint64
		F__i         [10]int32
	}
} /* alltypes.h:377:157 */

type pthread_cond_t = struct {
	F__u struct {
		F__ccgo_pad1 [0]uint64
		F__i         [12]int32
	}
} /* alltypes.h:387:112 */

type pthread_rwlock_t = struct {
	F__u struct {
		F__ccgo_pad1 [0]uint64
		F__i         [14]int32
	}
} /* alltypes.h:397:139 */

type pthread_barrier_t = struct {
	F__u struct {
		F__ccgo_pad1 [0]uint64
		F__i         [8]int32
	}
} /* alltypes.h:402:137 */

type sched_param = struct {
	Fsched_priority int32
	F__reserved1    int32
	F__reserved2    [2]struct {
		F__reserved1 time_t
		F__reserved2 int64
	}
	F__reserved3 int32
	F__ccgo_pad1 [4]byte
} /* sched.h:19:1 */

type timer_t = uintptr /* alltypes.h:209:14 */

type clock_t = int64 /* alltypes.h:219:14 */

type tm = struct {
	Ftm_sec      int32
	Ftm_min      int32
	Ftm_hour     int32
	Ftm_mday     int32
	Ftm_mon      int32
	Ftm_year     int32
	Ftm_wday     int32
	Ftm_yday     int32
	Ftm_isdst    int32
	F__ccgo_pad1 [4]byte
	Ftm_gmtoff   int64
	Ftm_zone     uintptr
} /* time.h:38:1 */

type itimerspec = struct {
	Fit_interval struct {
		Ftv_sec  time_t
		Ftv_nsec int64
	}
	Fit_value struct {
		Ftv_sec  time_t
		Ftv_nsec int64
	}
} /* time.h:80:1 */

type __ptcb = struct {
	F__f    uintptr
	F__x    uintptr
	F__next uintptr
} /* pthread.h:206:1 */

type useconds_t = uint32 /* alltypes.h:260:18 */

func Xgetaddrinfo(tls *TLS, host uintptr, serv uintptr, hint uintptr, res uintptr) int32 { /* getaddrinfo.c:12:5: */
	if __ccgo_strace {
		trc("tls=%v host=%v serv=%v hint=%v res=%v, (%v:)", tls, host, serv, hint, res, origin(2))
	}
	bp := tls.Alloc(1608)
	defer tls.Free(1608)

	// var ports [2]service at bp, 8

	// var addrs [48]address at bp+8, 1344

	// var canon [256]int8 at bp+1352, 256

	var outcanon uintptr
	var nservs int32
	var naddrs int32
	var nais int32
	var canon_len int32
	var i int32
	var j int32
	var k int32
	var family int32 = 0
	var flags int32 = 0
	var proto int32 = 0
	var socktype int32 = 0
	var out uintptr

	if !(host != 0) && !(serv != 0) {
		return -2
	}

	if hint != 0 {
		family = (*addrinfo)(unsafe.Pointer(hint)).Fai_family
		flags = (*addrinfo)(unsafe.Pointer(hint)).Fai_flags
		proto = (*addrinfo)(unsafe.Pointer(hint)).Fai_protocol
		socktype = (*addrinfo)(unsafe.Pointer(hint)).Fai_socktype

		var mask int32 = 0x01 | 0x02 | 0x04 | 0x08 | 0x10 | 0x20 | 0x400
		if flags&mask != flags {
			return -1
		}

		switch family {
		case 2:
			fallthrough
		case 10:
			fallthrough
		case 0:
			break
			fallthrough
		default:
			return -6
		}
	}

	if flags&0x20 != 0 {
		Xabort(tls) //TODO-
		// 	/* Define the "an address is configured" condition for address
		// 	 * families via ability to create a socket for the family plus
		// 	 * routability of the loopback address for the family. */
		// 	static const struct sockaddr_in lo4 = {
		// 		.sin_family = AF_INET, .sin_port = 65535,
		// 		.sin_addr.s_addr = __BYTE_ORDER == __BIG_ENDIAN
		// 			? 0x7f000001 : 0x0100007f
		// 	};
		// 	static const struct sockaddr_in6 lo6 = {
		// 		.sin6_family = AF_INET6, .sin6_port = 65535,
		// 		.sin6_addr = IN6ADDR_LOOPBACK_INIT
		// 	};
		// 	int tf[2] = { AF_INET, AF_INET6 };
		// 	const void *ta[2] = { &lo4, &lo6 };
		// 	socklen_t tl[2] = { sizeof lo4, sizeof lo6 };
		// 	for (i=0; i<2; i++) {
		// 		if (family==tf[1-i]) continue;
		// 		int s = socket(tf[i], SOCK_CLOEXEC|SOCK_DGRAM,
		// 			IPPROTO_UDP);
		// 		if (s>=0) {
		// 			int cs;
		// 			pthread_setcancelstate(
		// 				PTHREAD_CANCEL_DISABLE, &cs);
		// 			int r = connect(s, ta[i], tl[i]);
		// 			pthread_setcancelstate(cs, 0);
		// 			close(s);
		// 			if (!r) continue;
		// 		}
		// 		switch (errno) {
		// 		case EADDRNOTAVAIL:
		// 		case EAFNOSUPPORT:
		// 		case EHOSTUNREACH:
		// 		case ENETDOWN:
		// 		case ENETUNREACH:
		// 			break;
		// 		default:
		// 			return EAI_SYSTEM;
		// 		}
		// 		if (family == tf[i]) return EAI_NONAME;
		// 		family = tf[1-i];
		// 	}
	}

	nservs = X__lookup_serv(tls, bp, serv, proto, socktype, flags)
	if nservs < 0 {
		return nservs
	}

	naddrs = X__lookup_name(tls, bp+8, bp+1352, host, family, flags)
	if naddrs < 0 {
		return naddrs
	}

	nais = nservs * naddrs
	canon_len = int32(Xstrlen(tls, bp+1352))
	out = Xcalloc(tls, uint64(1), uint64(nais)*uint64(unsafe.Sizeof(aibuf{}))+uint64(canon_len)+uint64(1))
	if !(out != 0) {
		return -10
	}

	if canon_len != 0 {
		outcanon = out + uintptr(nais)*88
		Xmemcpy(tls, outcanon, bp+1352, uint64(canon_len+1))
	} else {
		outcanon = uintptr(0)
	}

	for k = AssignInt32(&i, 0); i < naddrs; i++ {
		j = 0
	__1:
		if !(j < nservs) {
			goto __3
		}
		{
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fslot = int16(k)
			//TODO out[k].ai = (struct addrinfo){
			//TODO 	.ai_family = addrs[i].family,
			//TODO 	.ai_socktype = ports[j].socktype,
			//TODO 	.ai_protocol = ports[j].proto,
			//TODO 	.ai_addrlen = addrs[i].family == AF_INET
			//TODO 		? sizeof(struct sockaddr_in)
			//TODO 		: sizeof(struct sockaddr_in6),
			//TODO 	.ai_addr = (void *)&out[k].sa,
			//TODO 	.ai_canonname = outcanon };
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fai.Fai_family = (*address)(unsafe.Pointer(bp + 8 + uintptr(i)*28)).Ffamily
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fai.Fai_socktype = int32((*service)(unsafe.Pointer(bp + uintptr(j)*4)).Fsocktype)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fai.Fai_protocol = int32((*service)(unsafe.Pointer(bp + uintptr(j)*4)).Fproto)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fai.Fai_addrlen = func() uint32 {
				if (*address)(unsafe.Pointer(bp+8+uintptr(i)*28)).Ffamily == 2 {
					return uint32(unsafe.Sizeof(sockaddr_in{}))
				}
				return uint32(unsafe.Sizeof(sockaddr_in6{}))
			}()
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fai.Fai_addr = out + uintptr(k)*88 + 48
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).Fai.Fai_canonname = outcanon
			if k != 0 {
				(*aibuf)(unsafe.Pointer(out + uintptr(k-1)*88)).Fai.Fai_next = out + uintptr(k)*88
			}
			switch (*address)(unsafe.Pointer(bp + 8 + uintptr(i)*28)).Ffamily {
			case 2:
				(*sockaddr_in)(unsafe.Pointer(out + uintptr(k)*88 + 48)).Fsin_family = sa_family_t(2)
				(*sockaddr_in)(unsafe.Pointer(out + uintptr(k)*88 + 48)).Fsin_port = Xhtons(tls, (*service)(unsafe.Pointer(bp+uintptr(j)*4)).Fport)
				Xmemcpy(tls, out+uintptr(k)*88+48+4, bp+8+uintptr(i)*28+8, uint64(4))
				break
			case 10:
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*88 + 48)).Fsin6_family = sa_family_t(10)
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*88 + 48)).Fsin6_port = Xhtons(tls, (*service)(unsafe.Pointer(bp+uintptr(j)*4)).Fport)
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*88 + 48)).Fsin6_scope_id = (*address)(unsafe.Pointer(bp + 8 + uintptr(i)*28)).Fscopeid
				Xmemcpy(tls, out+uintptr(k)*88+48+8, bp+8+uintptr(i)*28+8, uint64(16))
				break
			}

		}
		goto __2
	__2:
		j++
		k++
		goto __1
		goto __3
	__3:
	}
	(*aibuf)(unsafe.Pointer(out)).Fref = int16(nais)
	*(*uintptr)(unsafe.Pointer(res)) = out
	return 0
}

type ucred = struct {
	Fpid pid_t
	Fuid uid_t
	Fgid gid_t
} /* socket.h:57:1 */

type mmsghdr = struct {
	Fmsg_hdr struct {
		Fmsg_name       uintptr
		Fmsg_namelen    socklen_t
		F__ccgo_pad1    [4]byte
		Fmsg_iov        uintptr
		Fmsg_iovlen     int32
		F__pad1         int32
		Fmsg_control    uintptr
		Fmsg_controllen socklen_t
		F__pad2         int32
		Fmsg_flags      int32
		F__ccgo_pad2    [4]byte
	}
	Fmsg_len     uint32
	F__ccgo_pad1 [4]byte
} /* socket.h:63:1 */

func Xgethostbyaddr(tls *TLS, a uintptr, l socklen_t, af int32) uintptr { /* gethostbyaddr.c:7:16: */
	if __ccgo_strace {
		trc("tls=%v a=%v l=%v af=%v, (%v:)", tls, a, l, af, origin(2))
	}
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var size size_t = uint64(63)
	// var res uintptr at bp, 8

	var err int32
	for __ccgo := true; __ccgo; __ccgo = err == 34 {
		Xfree(tls, _sh)
		_sh = Xmalloc(tls, AssignAddUint64(&size, size+uint64(1)))
		if !(_sh != 0) {
			*(*int32)(unsafe.Pointer(X__h_errno_location(tls))) = 3
			return uintptr(0)
		}
		err = Xgethostbyaddr_r(tls, a, l, af, _sh,
			_sh+uintptr(1)*32, size-size_t(unsafe.Sizeof(hostent{})), bp, X__h_errno_location(tls))
	}
	if err != 0 {
		return uintptr(0)
	}
	return _sh
}

var _sh uintptr /* gethostbyaddr.c:9:24: */

func Xgethostbyname(tls *TLS, name uintptr) uintptr { /* gethostbyname.c:8:16: */
	if __ccgo_strace {
		trc("tls=%v name=%v, (%v:)", tls, name, origin(2))
	}
	return Xgethostbyname2(tls, name, 2)
}

func Xgethostbyname2(tls *TLS, name uintptr, af int32) uintptr { /* gethostbyname2.c:8:16: */
	if __ccgo_strace {
		trc("tls=%v name=%v af=%v, (%v:)", tls, name, af, origin(2))
	}
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var size size_t = uint64(63)
	// var res uintptr at bp, 8

	var err int32
	for __ccgo := true; __ccgo; __ccgo = err == 34 {
		Xfree(tls, _sh1)
		_sh1 = Xmalloc(tls, AssignAddUint64(&size, size+uint64(1)))
		if !(_sh1 != 0) {
			*(*int32)(unsafe.Pointer(X__h_errno_location(tls))) = 3
			return uintptr(0)
		}
		err = Xgethostbyname2_r(tls, name, af, _sh1,
			_sh1+uintptr(1)*32, size-size_t(unsafe.Sizeof(hostent{})), bp, X__h_errno_location(tls))
	}
	if err != 0 {
		return uintptr(0)
	}
	return _sh1
}

var _sh1 uintptr /* gethostbyname2.c:10:24: */

func Xgethostbyname2_r(tls *TLS, name uintptr, af int32, h uintptr, buf uintptr, buflen size_t, res uintptr, err uintptr) int32 { /* gethostbyname2_r.c:11:5: */
	if __ccgo_strace {
		trc("tls=%v name=%v af=%v h=%v buf=%v buflen=%v res=%v err=%v, (%v:)", tls, name, af, h, buf, buflen, res, err, origin(2))
	}
	bp := tls.Alloc(1600)
	defer tls.Free(1600)

	// var addrs [48]address at bp, 1344

	// var canon [256]int8 at bp+1344, 256

	var i int32
	var cnt int32
	var align size_t
	var need size_t

	*(*uintptr)(unsafe.Pointer(res)) = uintptr(0)
	cnt = X__lookup_name(tls, bp, bp+1344, name, af, 0x02)
	if cnt < 0 {
		switch cnt {
		case -2:
			*(*int32)(unsafe.Pointer(err)) = 1
			return 2
			fallthrough
		case -3:
			*(*int32)(unsafe.Pointer(err)) = 2
			return 11
			fallthrough
		default:
			fallthrough
		case -4:
			*(*int32)(unsafe.Pointer(err)) = 3
			return 74
			fallthrough
		case -10:
			fallthrough
		case -11:
			*(*int32)(unsafe.Pointer(err)) = 3
			return *(*int32)(unsafe.Pointer(X___errno_location(tls)))
		}
	}

	(*hostent)(unsafe.Pointer(h)).Fh_addrtype = af
	(*hostent)(unsafe.Pointer(h)).Fh_length = func() int32 {
		if af == 10 {
			return 16
		}
		return 4
	}()

	// Align buffer
	align = -uintptr_t(buf) & (uint64(unsafe.Sizeof(uintptr(0))) - uint64(1))

	need = uint64(4) * uint64(unsafe.Sizeof(uintptr(0)))
	need = need + uint64(cnt+1)*(uint64(unsafe.Sizeof(uintptr(0)))+uint64((*hostent)(unsafe.Pointer(h)).Fh_length))
	need = need + (Xstrlen(tls, name) + uint64(1))
	need = need + (Xstrlen(tls, bp+1344) + uint64(1))
	need = need + align

	if need > buflen {
		return 34
	}

	buf += uintptr(align)
	(*hostent)(unsafe.Pointer(h)).Fh_aliases = buf
	buf += uintptr(uint64(3) * uint64(unsafe.Sizeof(uintptr(0))))
	(*hostent)(unsafe.Pointer(h)).Fh_addr_list = buf
	buf += uintptr(uint64(cnt+1) * uint64(unsafe.Sizeof(uintptr(0))))

	for i = 0; i < cnt; i++ {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_addr_list + uintptr(i)*8)) = buf
		buf += uintptr((*hostent)(unsafe.Pointer(h)).Fh_length)
		Xmemcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_addr_list + uintptr(i)*8)), bp+uintptr(i)*28+8, uint64((*hostent)(unsafe.Pointer(h)).Fh_length))
	}
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_addr_list + uintptr(i)*8)) = uintptr(0)

	(*hostent)(unsafe.Pointer(h)).Fh_name = AssignPtrUintptr((*hostent)(unsafe.Pointer(h)).Fh_aliases, buf)
	Xstrcpy(tls, (*hostent)(unsafe.Pointer(h)).Fh_name, bp+1344)
	buf += uintptr(Xstrlen(tls, (*hostent)(unsafe.Pointer(h)).Fh_name) + uint64(1))

	if Xstrcmp(tls, (*hostent)(unsafe.Pointer(h)).Fh_name, name) != 0 {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_aliases + 1*8)) = buf
		Xstrcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_aliases + 1*8)), name)
		buf += uintptr(Xstrlen(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_aliases + 1*8))) + uint64(1))
	} else {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_aliases + 1*8)) = uintptr(0)
	}

	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).Fh_aliases + 2*8)) = uintptr(0)

	*(*uintptr)(unsafe.Pointer(res)) = h
	return 0
}

type if_nameindex = struct {
	Fif_index    uint32
	F__ccgo_pad1 [4]byte
	Fif_name     uintptr
} /* if.h:12:1 */

type ifaddr = struct {
	Fifa_addr struct {
		Fsa_family sa_family_t
		Fsa_data   [14]int8
	}
	Fifa_ifu struct {
		Fifu_broadaddr struct {
			Fsa_family sa_family_t
			Fsa_data   [14]int8
		}
	}
	Fifa_ifp  uintptr
	Fifa_next uintptr
} /* if.h:51:1 */

type ifmap = struct {
	Fmem_start   uint64
	Fmem_end     uint64
	Fbase_addr   uint16
	Firq         uint8
	Fdma         uint8
	Fport        uint8
	F__ccgo_pad1 [3]byte
} /* if.h:64:1 */

type ifreq = struct {
	Fifr_ifrn struct{ Fifrn_name [16]int8 }
	Fifr_ifru struct {
		F__ccgo_pad1 [0]uint64
		Fifru_addr   struct {
			Fsa_family sa_family_t
			Fsa_data   [14]int8
		}
		F__ccgo_pad2 [8]byte
	}
} /* if.h:76:1 */

type ifconf = struct {
	Fifc_len     int32
	F__ccgo_pad1 [4]byte
	Fifc_ifcu    struct{ Fifcu_buf uintptr }
} /* if.h:116:1 */

type ns_sect = uint32 /* nameser.h:37:3 */

type __ns_msg = struct {
	F_msg        uintptr
	F_eom        uintptr
	F_id         uint16_t
	F_flags      uint16_t
	F_counts     [4]uint16_t
	F__ccgo_pad1 [4]byte
	F_sections   [4]uintptr
	F_sect       ns_sect
	F_rrnum      int32
	F_msg_ptr    uintptr
} /* nameser.h:39:9 */

type ns_msg = __ns_msg /* nameser.h:46:3 */

type _ns_flagdata = struct {
	Fmask  int32
	Fshift int32
} /* nameser.h:48:1 */

type __ns_rr = struct {
	Fname        [1025]int8
	F__ccgo_pad1 [1]byte
	Ftype        uint16_t
	Frr_class    uint16_t
	F__ccgo_pad2 [2]byte
	Fttl         uint32_t
	Frdlength    uint16_t
	F__ccgo_pad3 [2]byte
	Frdata       uintptr
} /* nameser.h:59:9 */

type ns_rr = __ns_rr /* nameser.h:66:3 */

type ns_flag = uint32 /* nameser.h:87:3 */

type ns_opcode = uint32 /* nameser.h:96:3 */

type ns_rcode = uint32 /* nameser.h:115:3 */

type ns_update_operation = uint32 /* nameser.h:121:3 */

type ns_tsig_key1 = struct {
	Fname        [1025]int8
	Falg         [1025]int8
	F__ccgo_pad1 [6]byte
	Fdata        uintptr
	Flen         int32
	F__ccgo_pad2 [4]byte
} /* nameser.h:123:1 */

type ns_tsig_key = ns_tsig_key1 /* nameser.h:128:28 */

type ns_tcp_tsig_state1 = struct {
	Fcounter     int32
	F__ccgo_pad1 [4]byte
	Fkey         uintptr
	Fctx         uintptr
	Fsig         [512]uint8
	Fsiglen      int32
	F__ccgo_pad2 [4]byte
} /* nameser.h:130:1 */

type ns_tcp_tsig_state = ns_tcp_tsig_state1 /* nameser.h:137:34 */

type ns_type = uint32 /* nameser.h:200:3 */

type ns_class = uint32 /* nameser.h:219:3 */

type ns_key_types = uint32 /* nameser.h:226:3 */

type ns_cert_types = uint32 /* nameser.h:234:3 */

type HEADER = struct {
	F__ccgo_pad1 [0]uint32
	Fid          uint32 /* unsigned id: 16, unsigned rd: 1, unsigned tc: 1, unsigned aa: 1, unsigned opcode: 4, unsigned qr: 1, unsigned rcode: 4, unsigned cd: 1, unsigned ad: 1, unsigned unused: 1, unsigned ra: 1 */
	Fqdcount     uint32 /* unsigned qdcount: 16, unsigned ancount: 16 */
	Fnscount     uint32 /* unsigned nscount: 16, unsigned arcount: 16 */
} /* nameser.h:353:3 */

// unused; purely for broken apps
type __res_state = struct {
	Fretrans     int32
	Fretry       int32
	Foptions     uint64
	Fnscount     int32
	Fnsaddr_list [3]struct {
		Fsin_family sa_family_t
		Fsin_port   in_port_t
		Fsin_addr   struct{ Fs_addr in_addr_t }
		Fsin_zero   [8]uint8_t
	}
	Fid          uint16
	F__ccgo_pad1 [2]byte
	Fdnsrch      [7]uintptr
	Fdefdname    [256]int8
	Fpfcode      uint64
	Fndots       uint32 /* unsigned ndots: 4, unsigned nsort: 4, unsigned ipv6_unavail: 1, unsigned unused: 23 */
	F__ccgo_pad2 [4]byte
	Fsort_list   [10]struct {
		Faddr struct{ Fs_addr in_addr_t }
		Fmask uint32_t
	}
	Fqhook       uintptr
	Frhook       uintptr
	Fres_h_errno int32
	F_vcsock     int32
	F_flags      uint32
	F__ccgo_pad3 [4]byte
	F_u          struct {
		F__ccgo_pad1 [0]uint64
		Fpad         [52]int8
		F__ccgo_pad2 [4]byte
	}
} /* resolv.h:26:9 */

// unused; purely for broken apps
type res_state = uintptr /* resolv.h:62:3 */

type res_sym = struct {
	Fnumber      int32
	F__ccgo_pad1 [4]byte
	Fname        uintptr
	Fhumanname   uintptr
} /* resolv.h:70:1 */

func itoa(tls *TLS, p uintptr, x uint32) uintptr { /* getnameinfo.c:18:13: */
	p += uintptr(uint64(3) * uint64(unsafe.Sizeof(int32(0))))
	*(*int8)(unsafe.Pointer(PreDecUintptr(&p, 1))) = int8(0)
	for __ccgo := true; __ccgo; __ccgo = x != 0 {
		*(*int8)(unsafe.Pointer(PreDecUintptr(&p, 1))) = int8(uint32('0') + x%uint32(10))
		x = x / uint32(10)
	}
	return p
}

func mkptr4(tls *TLS, s uintptr, ip uintptr) { /* getnameinfo.c:28:13: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	Xsprintf(tls, s, ts+23,
		VaList(bp, int32(*(*uint8)(unsafe.Pointer(ip + 3))), int32(*(*uint8)(unsafe.Pointer(ip + 2))), int32(*(*uint8)(unsafe.Pointer(ip + 1))), int32(*(*uint8)(unsafe.Pointer(ip)))))
}

func mkptr6(tls *TLS, s uintptr, ip uintptr) { /* getnameinfo.c:34:13: */
	var i int32
	for i = 15; i >= 0; i-- {
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = _sxdigits[int32(*(*uint8)(unsafe.Pointer(ip + uintptr(i))))&15]
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = int8('.')
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = _sxdigits[int32(*(*uint8)(unsafe.Pointer(ip + uintptr(i))))>>4]
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = int8('.')
	}
	Xstrcpy(tls, s, ts+48)
}

var _sxdigits = *(*[17]int8)(unsafe.Pointer(ts + 57)) /* getnameinfo.c:36:20 */

func reverse_hosts(tls *TLS, buf uintptr, a uintptr, scopeid uint32, family int32) { /* getnameinfo.c:45:13: */
	bp := tls.Alloc(556)
	defer tls.Free(556)

	// var line [512]int8 at bp+16, 512

	var p uintptr
	var z uintptr
	var _buf [1032]uint8
	_ = _buf
	// var atmp [16]uint8 at bp, 16

	// var iplit address at bp+528, 28

	//TODO FILE _f, *f = __fopen_rb_ca("/etc/hosts", &_f, _buf, sizeof _buf);
	var f uintptr = Xfopen(tls, ts+74, ts+85)
	if !(f != 0) {
		return
	}
	if family == 2 {
		Xmemcpy(tls, bp+uintptr(12), a, uint64(4))
		Xmemcpy(tls, bp, ts+88, uint64(12))
		a = bp /* &atmp[0] */
	}
	for Xfgets(tls, bp+16, int32(unsafe.Sizeof([512]int8{})), f) != 0 {
		if AssignUintptr(&p, Xstrchr(tls, bp+16, '#')) != 0 {
			*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8('\n')
			*(*int8)(unsafe.Pointer(p)) = int8(0)
		}

		for p = bp + 16; /* &line[0] */ *(*int8)(unsafe.Pointer(p)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8(0)
		if X__lookup_ipliteral(tls, bp+528, bp+16, 0) <= 0 {
			continue
		}

		if (*address)(unsafe.Pointer(bp+528)).Ffamily == 2 {
			Xmemcpy(tls, bp+528+8+uintptr(12), bp+528+8, uint64(4))
			Xmemcpy(tls, bp+528+8, ts+88, uint64(12))
			(*address)(unsafe.Pointer(bp + 528 /* &iplit */)).Fscopeid = uint32(0)
		}

		if Xmemcmp(tls, a, bp+528+8, uint64(16)) != 0 || (*address)(unsafe.Pointer(bp+528)).Fscopeid != scopeid {
			continue
		}

		for ; *(*int8)(unsafe.Pointer(p)) != 0 && __isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0; p++ {
		}
		for z = p; *(*int8)(unsafe.Pointer(z)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(z)))) != 0); z++ {
		}
		*(*int8)(unsafe.Pointer(z)) = int8(0)
		if (int64(z)-int64(p))/1 < int64(256) {
			Xmemcpy(tls, buf, p, uint64((int64(z)-int64(p))/1+int64(1)))
			break
		}
	}
	//TODO __fclose_ca(f);
	Xfclose(tls, f)
}

func reverse_services(tls *TLS, buf uintptr, port int32, dgram int32) { /* getnameinfo.c:87:13: */
	Xabort(tls) //TODO-
	// unsigned long svport;
	// char line[128], *p, *z;
	// unsigned char _buf[1032];
	// FILE _f, *f = __fopen_rb_ca("/etc/services", &_f, _buf, sizeof _buf);
	// if (!f) return;
	// while (fgets(line, sizeof line, f)) {
	// 	if ((p=strchr(line, '#'))) *p++='\n', *p=0;

	// 	for (p=line; *p && !isspace(*p); p++);
	// 	if (!*p) continue;
	// 	*p++ = 0;
	// 	svport = strtoul(p, &z, 10);

	// 	if (svport != port || z==p) continue;
	// 	if (dgram && strncmp(z, "/udp", 4)) continue;
	// 	if (!dgram && strncmp(z, "/tcp", 4)) continue;
	// 	if (p-line > 32) continue;

	// 	memcpy(buf, line, p-line);
	// 	break;
	// }
	// __fclose_ca(f);
}

var Xh_errno int32 /* h_errno.c:4:5: */

func X__h_errno_location(tls *TLS) uintptr { /* h_errno.c:6:5: */
	if __ccgo_strace {
		trc("tls=%v, (%v:)", tls, origin(2))
	}
	return uintptr(unsafe.Pointer(&Xh_errno))
}

func X__inet_aton(tls *TLS, s0 uintptr, dest uintptr) int32 { /* inet_aton.c:7:5: */
	if __ccgo_strace {
		trc("tls=%v s0=%v dest=%v, (%v:)", tls, s0, dest, origin(2))
	}
	bp := tls.Alloc(40)
	defer tls.Free(40)

	var s uintptr = s0
	var d uintptr = dest
	*(*[4]uint64)(unsafe.Pointer(bp /* a */)) = [4]uint64{0: uint64(0)}
	// var z uintptr at bp+32, 8

	var i int32

	for i = 0; i < 4; i++ {
		*(*uint64)(unsafe.Pointer(bp + uintptr(i)*8)) = Xstrtoul(tls, s, bp+32, 0)
		if *(*uintptr)(unsafe.Pointer(bp + 32)) == s || *(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 32)))) != 0 && int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 32))))) != '.' || !(func() int32 {
			if 0 != 0 {
				return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(s))))
			}
			return Bool32(uint32(*(*int8)(unsafe.Pointer(s)))-uint32('0') < uint32(10))
		}() != 0) {
			return 0
		}
		if !(int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 32))))) != 0) {
			break
		}
		s = *(*uintptr)(unsafe.Pointer(bp + 32)) + uintptr(1)
	}
	if i == 4 {
		return 0
	}
	switch i {
	case 0:
		*(*uint64)(unsafe.Pointer(bp + 1*8)) = *(*uint64)(unsafe.Pointer(bp)) & uint64(0xffffff)
		AssignShrPtrUint64(bp, int(24))
		fallthrough
	case 1:
		*(*uint64)(unsafe.Pointer(bp + 2*8)) = *(*uint64)(unsafe.Pointer(bp + 1*8)) & uint64(0xffff)
		AssignShrPtrUint64(bp+1*8, int(16))
		fallthrough
	case 2:
		*(*uint64)(unsafe.Pointer(bp + 3*8)) = *(*uint64)(unsafe.Pointer(bp + 2*8)) & uint64(0xff)
		AssignShrPtrUint64(bp+2*8, int(8))
	}
	for i = 0; i < 4; i++ {
		if *(*uint64)(unsafe.Pointer(bp + uintptr(i)*8)) > uint64(255) {
			return 0
		}
		*(*uint8)(unsafe.Pointer(d + uintptr(i))) = uint8(*(*uint64)(unsafe.Pointer(bp + uintptr(i)*8)))
	}
	return 1
}

func Xinet_ntop(tls *TLS, af int32, a0 uintptr, s uintptr, l socklen_t) uintptr { /* inet_ntop.c:7:12: */
	if __ccgo_strace {
		trc("tls=%v af=%v a0=%v s=%v l=%v, (%v:)", tls, af, a0, s, l, origin(2))
	}
	bp := tls.Alloc(276)
	defer tls.Free(276)

	var a uintptr = a0
	var i int32
	var j int32
	var max int32
	var best int32
	// var buf [100]int8 at bp+176, 100

	switch af {
	case 2:
		if socklen_t(Xsnprintf(tls, s, uint64(l), ts+101, VaList(bp, int32(*(*uint8)(unsafe.Pointer(a))), int32(*(*uint8)(unsafe.Pointer(a + 1))), int32(*(*uint8)(unsafe.Pointer(a + 2))), int32(*(*uint8)(unsafe.Pointer(a + 3)))))) < l {
			return s
		}
		break
	case 10:
		if Xmemcmp(tls, a, ts+88, uint64(12)) != 0 {
			Xsnprintf(tls, bp+176, uint64(unsafe.Sizeof([100]int8{})),
				ts+113,
				VaList(bp+32, 256*int32(*(*uint8)(unsafe.Pointer(a)))+int32(*(*uint8)(unsafe.Pointer(a + 1))), 256*int32(*(*uint8)(unsafe.Pointer(a + 2)))+int32(*(*uint8)(unsafe.Pointer(a + 3))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 4)))+int32(*(*uint8)(unsafe.Pointer(a + 5))), 256*int32(*(*uint8)(unsafe.Pointer(a + 6)))+int32(*(*uint8)(unsafe.Pointer(a + 7))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 8)))+int32(*(*uint8)(unsafe.Pointer(a + 9))), 256*int32(*(*uint8)(unsafe.Pointer(a + 10)))+int32(*(*uint8)(unsafe.Pointer(a + 11))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 12)))+int32(*(*uint8)(unsafe.Pointer(a + 13))), 256*int32(*(*uint8)(unsafe.Pointer(a + 14)))+int32(*(*uint8)(unsafe.Pointer(a + 15)))))
		} else {
			Xsnprintf(tls, bp+176, uint64(unsafe.Sizeof([100]int8{})),
				ts+137,
				VaList(bp+96, 256*int32(*(*uint8)(unsafe.Pointer(a)))+int32(*(*uint8)(unsafe.Pointer(a + 1))), 256*int32(*(*uint8)(unsafe.Pointer(a + 2)))+int32(*(*uint8)(unsafe.Pointer(a + 3))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 4)))+int32(*(*uint8)(unsafe.Pointer(a + 5))), 256*int32(*(*uint8)(unsafe.Pointer(a + 6)))+int32(*(*uint8)(unsafe.Pointer(a + 7))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 8)))+int32(*(*uint8)(unsafe.Pointer(a + 9))), 256*int32(*(*uint8)(unsafe.Pointer(a + 10)))+int32(*(*uint8)(unsafe.Pointer(a + 11))),
					int32(*(*uint8)(unsafe.Pointer(a + 12))), int32(*(*uint8)(unsafe.Pointer(a + 13))), int32(*(*uint8)(unsafe.Pointer(a + 14))), int32(*(*uint8)(unsafe.Pointer(a + 15)))))
		}
		// Replace longest /(^0|:)[:0]{2,}/ with "::"
		i = AssignInt32(&best, 0)
		max = 2
		for ; *(*int8)(unsafe.Pointer(bp + 176 + uintptr(i))) != 0; i++ {
			if i != 0 && int32(*(*int8)(unsafe.Pointer(bp + 176 + uintptr(i)))) != ':' {
				continue
			}
			j = int32(Xstrspn(tls, bp+176+uintptr(i), ts+167))
			if j > max {
				best = i
				max = j
			}
		}
		if max > 3 {
			*(*int8)(unsafe.Pointer(bp + 176 + uintptr(best))) = AssignPtrInt8(bp+176+uintptr(best+1), int8(':'))
			Xmemmove(tls, bp+176+uintptr(best)+uintptr(2), bp+176+uintptr(best)+uintptr(max), uint64(i-best-max+1))
		}
		if Xstrlen(tls, bp+176) < size_t(l) {
			Xstrcpy(tls, s, bp+176)
			return s
		}
		break
	default:
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 97
		return uintptr(0)
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 28
	return uintptr(0)
}

func hexval(tls *TLS, c uint32) int32 { /* inet_pton.c:7:12: */
	if c-uint32('0') < uint32(10) {
		return int32(c - uint32('0'))
	}
	c = c | uint32(32)
	if c-uint32('a') < uint32(6) {
		return int32(c - uint32('a') + uint32(10))
	}
	return -1
}

func Xinet_pton(tls *TLS, af int32, s uintptr, a0 uintptr) int32 { /* inet_pton.c:15:5: */
	if __ccgo_strace {
		trc("tls=%v af=%v s=%v a0=%v, (%v:)", tls, af, s, a0, origin(2))
	}
	bp := tls.Alloc(16)
	defer tls.Free(16)

	// var ip [8]uint16_t at bp, 16

	var a uintptr = a0
	var i int32
	var j int32
	var v int32
	var d int32
	var brk int32 = -1
	var need_v4 int32 = 0

	if af == 2 {
		for i = 0; i < 4; i++ {
			for v = AssignInt32(&j, 0); j < 3 && func() int32 {
				if 0 != 0 {
					return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))))
				}
				return Bool32(uint32(*(*int8)(unsafe.Pointer(s + uintptr(j))))-uint32('0') < uint32(10))
			}() != 0; j++ {
				v = 10*v + int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) - '0'
			}
			if j == 0 || j > 1 && int32(*(*int8)(unsafe.Pointer(s))) == '0' || v > 255 {
				return 0
			}
			*(*uint8)(unsafe.Pointer(a + uintptr(i))) = uint8(v)
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) == 0 && i == 3 {
				return 1
			}
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != '.' {
				return 0
			}
			s += uintptr(j + 1)
		}
		return 0
	} else if af != 10 {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 97
		return -1
	}

	if int32(*(*int8)(unsafe.Pointer(s))) == ':' && int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&s, 1)))) != ':' {
		return 0
	}

	for i = 0; ; i++ {
		if int32(*(*int8)(unsafe.Pointer(s))) == ':' && brk < 0 {
			brk = i
			*(*uint16_t)(unsafe.Pointer(bp + uintptr(i&7)*2)) = uint16_t(0)
			if !(int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&s, 1)))) != 0) {
				break
			}
			if i == 7 {
				return 0
			}
			continue
		}
		for v = AssignInt32(&j, 0); j < 4 && AssignInt32(&d, hexval(tls, uint32(*(*int8)(unsafe.Pointer(s + uintptr(j)))))) >= 0; j++ {
			v = 16*v + d
		}
		if j == 0 {
			return 0
		}
		*(*uint16_t)(unsafe.Pointer(bp + uintptr(i&7)*2)) = uint16_t(v)
		if !(int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != 0) && (brk >= 0 || i == 7) {
			break
		}
		if i == 7 {
			return 0
		}
		if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != ':' {
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != '.' || i < 6 && brk < 0 {
				return 0
			}
			need_v4 = 1
			i++
			break
		}
		s += uintptr(j + 1)
	}
	if brk >= 0 {
		Xmemmove(tls, bp+uintptr(brk)*2+uintptr(7)*2-uintptr(i)*2, bp+uintptr(brk)*2, uint64(2*(i+1-brk)))
		for j = 0; j < 7-i; j++ {
			*(*uint16_t)(unsafe.Pointer(bp + uintptr(brk+j)*2)) = uint16_t(0)
		}
	}
	for j = 0; j < 8; j++ {
		*(*uint8)(unsafe.Pointer(PostIncUintptr(&a, 1))) = uint8(int32(*(*uint16_t)(unsafe.Pointer(bp + uintptr(j)*2))) >> 8)
		*(*uint8)(unsafe.Pointer(PostIncUintptr(&a, 1))) = uint8(*(*uint16_t)(unsafe.Pointer(bp + uintptr(j)*2)))
	}
	if need_v4 != 0 && Xinet_pton(tls, 2, s, a-uintptr(4)) <= 0 {
		return 0
	}
	return 1
}

func X__lookup_ipliteral(tls *TLS, buf uintptr, name uintptr, family int32) int32 { /* lookup_ipliteral.c:12:5: */
	if __ccgo_strace {
		trc("tls=%v buf=%v name=%v family=%v, (%v:)", tls, buf, name, family, origin(2))
	}
	bp := tls.Alloc(96)
	defer tls.Free(96)

	// var a4 in_addr at bp, 4

	// var a6 in6_addr at bp+68, 16

	if X__inet_aton(tls, name, bp) > 0 {
		if family == 10 { // wrong family
			return -2
		}
		Xmemcpy(tls, buf+8, bp, uint64(unsafe.Sizeof(in_addr{})))
		(*address)(unsafe.Pointer(buf)).Ffamily = 2
		(*address)(unsafe.Pointer(buf)).Fscopeid = uint32(0)
		return 1
	}
	// var tmp [64]int8 at bp+4, 64

	var p uintptr = Xstrchr(tls, name, '%')
	// var z uintptr at bp+88, 8

	var scopeid uint64 = uint64(0)
	if p != 0 && (int64(p)-int64(name))/1 < int64(64) {
		Xmemcpy(tls, bp+4, name, uint64((int64(p)-int64(name))/1))
		*(*int8)(unsafe.Pointer(bp + 4 + uintptr((int64(p)-int64(name))/1))) = int8(0)
		name = bp + 4 /* &tmp[0] */
	}

	if Xinet_pton(tls, 10, name, bp+68) <= 0 {
		return 0
	}
	if family == 2 { // wrong family
		return -2
	}

	Xmemcpy(tls, buf+8, bp+68, uint64(unsafe.Sizeof(in6_addr{})))
	(*address)(unsafe.Pointer(buf)).Ffamily = 10
	if p != 0 {
		if func() int32 {
			if 0 != 0 {
				return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&p, 1)))))
			}
			return Bool32(uint32(*(*int8)(unsafe.Pointer(PreIncUintptr(&p, 1))))-uint32('0') < uint32(10))
		}() != 0 {
			scopeid = Xstrtoull(tls, p, bp+88, 10)
		} else {
			*(*uintptr)(unsafe.Pointer(bp + 88 /* z */)) = p - uintptr(1)
		}
		if *(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 88)))) != 0 {
			Xabort(tls) //TODO-
			// if (!IN6_IS_ADDR_LINKLOCAL(&a6) &&
			//     !IN6_IS_ADDR_MC_LINKLOCAL(&a6))
			// 	return EAI_NONAME;
			// scopeid = if_nametoindex(p);
			// if (!scopeid) return EAI_NONAME;
		}
		if scopeid > uint64(0xffffffff) {
			return -2
		}
	}
	(*address)(unsafe.Pointer(buf)).Fscopeid = uint32(scopeid)
	return 1
}

type mode_t = uint32 /* alltypes.h:152:18 */

type flock = struct {
	Fl_type      int16
	Fl_whence    int16
	F__ccgo_pad1 [4]byte
	Fl_start     off_t
	Fl_len       off_t
	Fl_pid       pid_t
	F__ccgo_pad2 [4]byte
} /* fcntl.h:24:1 */

func is_valid_hostname(tls *TLS, host uintptr) int32 { /* lookup_name.c:18:12: */
	var s uintptr
	//TODO if (strnlen(host, 255)-1 >= 254 || mbstowcs(0, host, 0) == -1) return 0;
	if Xstrnlen(tls, host, uint64(255))-uint64(1) >= uint64(254) {
		return 0
	}
	for s = host; int32(*(*uint8)(unsafe.Pointer(s))) >= 0x80 || int32(*(*uint8)(unsafe.Pointer(s))) == '.' || int32(*(*uint8)(unsafe.Pointer(s))) == '-' || Xisalnum(tls, int32(*(*uint8)(unsafe.Pointer(s)))) != 0; s++ {
	}
	return BoolInt32(!(*(*uint8)(unsafe.Pointer(s)) != 0))
}

var Xzero_struct_address address /* lookup_name.c:27:16: */

func name_from_null(tls *TLS, buf uintptr, name uintptr, family int32, flags int32) int32 { /* lookup_name.c:29:12: */
	var cnt int32 = 0
	if name != 0 {
		return 0
	}
	if flags&0x01 != 0 {
		//TODO if (family != AF_INET6)
		//TODO 	buf[cnt++] = (struct address){ .family = AF_INET };
		if family != 10 {
			var x = Xzero_struct_address
			x.Ffamily = 2
			*(*address)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*28)) = x
		}
		//TODO if (family != AF_INET)
		//TODO 	buf[cnt++] = (struct address){ .family = AF_INET6 };
		if family != 2 {
			var x = Xzero_struct_address
			x.Ffamily = 10
			*(*address)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*28)) = x
		}
	} else {
		Xabort(tls) //TODO-
		// 	if (family != AF_INET6)
		// 		buf[cnt++] = (struct address){ .family = AF_INET, .addr = { 127,0,0,1 } };
		// 	if (family != AF_INET)
		// 		buf[cnt++] = (struct address){ .family = AF_INET6, .addr = { [15] = 1 } };
	}
	return cnt
}

func name_from_numeric(tls *TLS, buf uintptr, name uintptr, family int32) int32 { /* lookup_name.c:58:12: */
	return X__lookup_ipliteral(tls, buf, name, family)
}

func name_from_hosts(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32) int32 { /* lookup_name.c:63:12: */
	bp := tls.Alloc(512)
	defer tls.Free(512)

	// var line [512]int8 at bp, 512

	var l size_t = Xstrlen(tls, name)
	var cnt int32 = 0
	var badfam int32 = 0
	var _buf [1032]uint8
	_ = _buf
	//TODO FILE _f, *f = __fopen_rb_ca("/etc/hosts", &_f, _buf, sizeof _buf);
	var _f FILE
	_ = _f
	var f uintptr = Xfopen(tls, ts+74, ts+85)
	if !(f != 0) {
		switch *(*int32)(unsafe.Pointer(X___errno_location(tls))) {
		case 2:
			fallthrough
		case 20:
			fallthrough
		case 13:
			return 0
			fallthrough
		default:
			return -11
		}
	}
	for Xfgets(tls, bp, int32(unsafe.Sizeof([512]int8{})), f) != 0 && cnt < 48 {
		var p uintptr
		var z uintptr

		if AssignUintptr(&p, Xstrchr(tls, bp, '#')) != 0 {
			*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8('\n')
			*(*int8)(unsafe.Pointer(p)) = int8(0)
		}
		for p = bp + uintptr(1); AssignUintptr(&p, Xstrstr(tls, p, name)) != 0 && (!(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p + UintptrFromInt32(-1))))) != 0) || !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p + uintptr(l))))) != 0)); p++ {
		}
		if !(p != 0) {
			continue
		}

		// Isolate IP address to parse
		for p = bp; /* &line[0] */ *(*int8)(unsafe.Pointer(p)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8(0)
		switch name_from_numeric(tls, buf+uintptr(cnt)*28, bp, family) {
		case 1:
			cnt++
			break
		case 0:
			continue
		default:
			badfam = -2
			continue
		}

		// Extract first name as canonical name
		for ; *(*int8)(unsafe.Pointer(p)) != 0 && __isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0; p++ {
		}
		for z = p; *(*int8)(unsafe.Pointer(z)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(z)))) != 0); z++ {
		}
		*(*int8)(unsafe.Pointer(z)) = int8(0)
		if is_valid_hostname(tls, p) != 0 {
			Xmemcpy(tls, canon, p, uint64((int64(z)-int64(p))/1+int64(1)))
		}
	}
	//TODO __fclose_ca(f);
	Xfclose(tls, f)
	if cnt != 0 {
		return cnt
	}
	return badfam
}

type dpc_ctx = struct {
	Faddrs       uintptr
	Fcanon       uintptr
	Fcnt         int32
	F__ccgo_pad1 [4]byte
} /* lookup_name.c:112:1 */

func name_from_dns_search(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32) int32 { /* lookup_name.c:191:12: */
	return -1 //TODO-
	Xabort(tls)
	return int32(0) //TODO-
	// char search[256];
	// struct resolvconf conf;
	// size_t l, dots;
	// char *p, *z;

	// if (__get_resolv_conf(&conf, search, sizeof search) < 0) return -1;

	// /* Count dots, suppress search when >=ndots or name ends in
	//  * a dot, which is an explicit request for global scope. */
	// for (dots=l=0; name[l]; l++) if (name[l]=='.') dots++;
	// if (dots >= conf.ndots || name[l-1]=='.') *search = 0;

	// /* Strip final dot for canon, fail if multiple trailing dots. */
	// if (name[l-1]=='.') l--;
	// if (!l || name[l-1]=='.') return EAI_NONAME;

	// /* This can never happen; the caller already checked length. */
	// if (l >= 256) return EAI_NONAME;

	// /* Name with search domain appended is setup in canon[]. This both
	//  * provides the desired default canonical name (if the requested
	//  * name is not a CNAME record) and serves as a buffer for passing
	//  * the full requested name to name_from_dns. */
	// memcpy(canon, name, l);
	// canon[l] = '.';

	// for (p=search; *p; p=z) {
	// 	for (; isspace(*p); p++);
	// 	for (z=p; *z && !isspace(*z); z++);
	// 	if (z==p) break;
	// 	if (z-p < 256 - l - 1) {
	// 		memcpy(canon+l+1, p, z-p);
	// 		canon[z-p+1+l] = 0;
	// 		int cnt = name_from_dns(buf, canon, canon, family, &conf);
	// 		if (cnt) return cnt;
	// 	}
	// }

	// canon[l] = 0;
	// return name_from_dns(buf, canon, name, family, &conf);
}

type policy = struct {
	Faddr  [16]uint8
	Flen   uint8
	Fmask  uint8
	Fprec  uint8
	Flabel uint8
} /* lookup_name.c:237:14 */

var defpolicy = [6]policy{
	{Faddr: *(*[16]uint8)(unsafe.Pointer(ts + 170)), Flen: uint8(15), Fmask: uint8(0xff), Fprec: uint8(50)},
	{Faddr: *(*[16]uint8)(unsafe.Pointer(ts + 187)), Flen: uint8(11), Fmask: uint8(0xff), Fprec: uint8(35), Flabel: uint8(4)},
	{Faddr: *(*[16]uint8)(unsafe.Pointer(ts + 203)), Flen: uint8(1), Fmask: uint8(0xff), Fprec: uint8(30), Flabel: uint8(2)},
	{Faddr: *(*[16]uint8)(unsafe.Pointer(ts + 219)), Flen: uint8(3), Fmask: uint8(0xff), Fprec: uint8(5), Flabel: uint8(5)},
	{Faddr: *(*[16]uint8)(unsafe.Pointer(ts + 235)), Fmask: uint8(0xfe), Fprec: uint8(3), Flabel: uint8(13)},
	// Last rule must match all addresses to stop loop.
	{Faddr: *(*[16]uint8)(unsafe.Pointer(ts + 251)), Fprec: uint8(40), Flabel: uint8(1)},
} /* lookup_name.c:241:3 */

func policyof(tls *TLS, a uintptr) uintptr { /* lookup_name.c:259:28: */
	var i int32
	for i = 0; ; i++ {
		if Xmemcmp(tls, a, uintptr(unsafe.Pointer(&defpolicy))+uintptr(i)*20, uint64(defpolicy[i].Flen)) != 0 {
			continue
		}
		if int32(*(*uint8_t)(unsafe.Pointer(a + uintptr(defpolicy[i].Flen))))&int32(defpolicy[i].Fmask) !=
			int32(*(*uint8)(unsafe.Pointer(uintptr(unsafe.Pointer(&defpolicy)) + uintptr(i)*20 + uintptr(defpolicy[i].Flen)))) {
			continue
		}
		return uintptr(unsafe.Pointer(&defpolicy)) + uintptr(i)*20
	}
	return uintptr(0)
}

func labelof(tls *TLS, a uintptr) int32 { /* lookup_name.c:272:12: */
	return int32((*policy)(unsafe.Pointer(policyof(tls, a))).Flabel)
}

func scopeof(tls *TLS, a uintptr) int32 { /* lookup_name.c:277:12: */
	if int32(*(*uint8_t)(unsafe.Pointer(a))) == 0xff {
		return int32(*(*uint8_t)(unsafe.Pointer(a + 1))) & 15
	}
	if int32(*(*uint8_t)(unsafe.Pointer(a))) == 0xfe && int32(*(*uint8_t)(unsafe.Pointer(a + 1)))&0xc0 == 0x80 {
		return 2
	}
	if *(*uint32_t)(unsafe.Pointer(a)) == uint32_t(0) && *(*uint32_t)(unsafe.Pointer(a + 1*4)) == uint32_t(0) && *(*uint32_t)(unsafe.Pointer(a + 2*4)) == uint32_t(0) && int32(*(*uint8_t)(unsafe.Pointer(a + 12))) == 0 && int32(*(*uint8_t)(unsafe.Pointer(a + 13))) == 0 && int32(*(*uint8_t)(unsafe.Pointer(a + 14))) == 0 && int32(*(*uint8_t)(unsafe.Pointer(a + 15))) == 1 {
		return 2
	}
	if int32(*(*uint8_t)(unsafe.Pointer(a))) == 0xfe && int32(*(*uint8_t)(unsafe.Pointer(a + 1)))&0xc0 == 0xc0 {
		return 5
	}
	return 14
}

func prefixmatch(tls *TLS, s uintptr, d uintptr) int32 { /* lookup_name.c:286:12: */
	// FIXME: The common prefix length should be limited to no greater
	// than the nominal length of the prefix portion of the source
	// address. However the definition of the source prefix length is
	// not clear and thus this limiting is not yet implemented.
	var i uint32
	for i = uint32(0); i < uint32(128) && !((int32(*(*uint8_t)(unsafe.Pointer(s /* &.__in6_union */ /* &.__s6_addr */ + uintptr(i/uint32(8)))))^int32(*(*uint8_t)(unsafe.Pointer(d /* &.__in6_union */ /* &.__s6_addr */ + uintptr(i/uint32(8))))))&(int32(128)>>(i%uint32(8))) != 0); i++ {
	}
	return int32(i)
}

func addrcmp(tls *TLS, _a uintptr, _b uintptr) int32 { /* lookup_name.c:305:12: */
	var a uintptr = _a
	var b uintptr = _b
	return (*address)(unsafe.Pointer(b)).Fsortkey - (*address)(unsafe.Pointer(a)).Fsortkey
}

func X__lookup_name(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32, flags int32) int32 { /* lookup_name.c:311:5: */
	if __ccgo_strace {
		trc("tls=%v buf=%v canon=%v name=%v family=%v flags=%v, (%v:)", tls, buf, canon, name, family, flags, origin(2))
	}
	bp := tls.Alloc(92)
	defer tls.Free(92)

	var cnt int32 = 0
	var i int32
	var j int32
	_ = j

	*(*int8)(unsafe.Pointer(canon)) = int8(0)
	if name != 0 {
		// reject empty name and check len so it fits into temp bufs
		var l size_t = Xstrnlen(tls, name, uint64(255))
		if l-uint64(1) >= uint64(254) {
			return -2
		}
		Xmemcpy(tls, canon, name, l+uint64(1))
	}

	// Procedurally, a request for v6 addresses with the v4-mapped
	// flag set is like a request for unspecified family, followed
	// by filtering of the results.
	if flags&0x08 != 0 {
		if family == 10 {
			family = 0
		} else {
			flags = flags - 0x08
		}
	}

	// Try each backend until there's at least one result.
	cnt = name_from_null(tls, buf, name, family, flags)
	if !(cnt != 0) {
		cnt = name_from_numeric(tls, buf, name, family)
	}
	if !(cnt != 0) && !(flags&0x04 != 0) {
		cnt = name_from_hosts(tls, buf, canon, name, family)
		if !(cnt != 0) {
			cnt = name_from_dns_search(tls, buf, canon, name, family)
		}
	}
	if cnt <= 0 {
		if cnt != 0 {
			return cnt
		}
		return -2
	}

	// Filter/transform results for v4-mapped lookup, if requested.
	if flags&0x08 != 0 {
		Xabort(tls) //TODO-
		// 	if (!(flags & AI_ALL)) {
		// 		/* If any v6 results exist, remove v4 results. */
		// 		for (i=0; i<cnt && buf[i].family != AF_INET6; i++);
		// 		if (i<cnt) {
		// 			for (j=0; i<cnt; i++) {
		// 				if (buf[i].family == AF_INET6)
		// 					buf[j++] = buf[i];
		// 			}
		// 			cnt = i = j;
		// 		}
		// 	}
		// 	/* Translate any remaining v4 results to v6 */
		// 	for (i=0; i<cnt; i++) {
		// 		if (buf[i].family != AF_INET) continue;
		// 		memcpy(buf[i].addr+12, buf[i].addr, 4);
		// 		memcpy(buf[i].addr, "\0\0\0\0\0\0\0\0\0\0\xff\xff", 12);
		// 		buf[i].family = AF_INET6;
		// 	}
	}

	// No further processing is needed if there are fewer than 2
	// results or if there are only IPv4 results.
	if cnt < 2 || family == 2 {
		return cnt
	}
	for i = 0; i < cnt; i++ {
		if (*address)(unsafe.Pointer(buf+uintptr(i)*28)).Ffamily != 2 {
			break
		}
	}
	if i == cnt {
		return cnt
	}
	var cs int32
	_ = cs
	//TODO pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, &cs);

	// The following implements a subset of RFC 3484/6724 destination
	// address selection by generating a single 31-bit sort key for
	// each address. Rules 3, 4, and 7 are omitted for having
	// excessive runtime and code size cost and dubious benefit.
	// So far the label/precedence table cannot be customized.
	for i = 0; i < cnt; i++ {
		var family int32 = (*address)(unsafe.Pointer(buf + uintptr(i)*28)).Ffamily
		var key int32 = 0
		*(*sockaddr_in6)(unsafe.Pointer(bp + 28 /* sa6 */)) = sockaddr_in6{}
		*(*sockaddr_in6)(unsafe.Pointer(bp /* da6 */)) = sockaddr_in6{Fsin6_family: sa_family_t(10), Fsin6_port: in_port_t(65535), Fsin6_scope_id: (*address)(unsafe.Pointer(buf + uintptr(i)*28)).Fscopeid}
		*(*sockaddr_in)(unsafe.Pointer(bp + 72 /* sa4 */)) = sockaddr_in{}
		*(*sockaddr_in)(unsafe.Pointer(bp + 56 /* da4 */)) = sockaddr_in{Fsin_family: sa_family_t(2), Fsin_port: in_port_t(65535)}
		var sa1 uintptr
		var da uintptr
		// var salen socklen_t at bp+88, 4

		var dalen socklen_t
		if family == 10 {
			Xmemcpy(tls, bp+8, buf+uintptr(i)*28+8, uint64(16))
			da = bp /* &da6 */
			dalen = socklen_t(unsafe.Sizeof(sockaddr_in6{}))
			sa1 = bp + 28 /* &sa6 */
			*(*socklen_t)(unsafe.Pointer(bp + 88 /* salen */)) = socklen_t(unsafe.Sizeof(sockaddr_in6{}))
		} else {
			Xmemcpy(tls, bp+28+8,
				ts+88, uint64(12))
			Xmemcpy(tls, bp+8+uintptr(12), buf+uintptr(i)*28+8, uint64(4))
			Xmemcpy(tls, bp+8,
				ts+88, uint64(12))
			Xmemcpy(tls, bp+8+uintptr(12), buf+uintptr(i)*28+8, uint64(4))
			Xmemcpy(tls, bp+56+4, buf+uintptr(i)*28+8, uint64(4))
			da = bp + 56 /* &da4 */
			dalen = socklen_t(unsafe.Sizeof(sockaddr_in{}))
			sa1 = bp + 72 /* &sa4 */
			*(*socklen_t)(unsafe.Pointer(bp + 88 /* salen */)) = socklen_t(unsafe.Sizeof(sockaddr_in{}))
		}
		var dpolicy uintptr = policyof(tls, bp+8)
		var dscope int32 = scopeof(tls, bp+8)
		var dlabel int32 = int32((*policy)(unsafe.Pointer(dpolicy)).Flabel)
		var dprec int32 = int32((*policy)(unsafe.Pointer(dpolicy)).Fprec)
		var prefixlen int32 = 0
		var fd int32 = Xsocket(tls, family, 2|02000000, 17)
		if fd >= 0 {
			if !(Xconnect(tls, fd, da, dalen) != 0) {
				key = key | 0x40000000
				if !(Xgetsockname(tls, fd, sa1, bp+88) != 0) {
					if family == 2 {
						Xmemcpy(tls,
							bp+28+8+uintptr(12),
							bp+72+4, uint64(4))
					}
					if dscope == scopeof(tls, bp+28+8) {
						key = key | 0x20000000
					}
					if dlabel == labelof(tls, bp+28+8) {
						key = key | 0x10000000
					}
					prefixlen = prefixmatch(tls, bp+28+8,
						bp+8)
				}
			}
			Xclose(tls, fd)
		}
		key = key | dprec<<20
		key = key | (15-dscope)<<16
		key = key | prefixlen<<8
		key = key | (48-i)<<0
		(*address)(unsafe.Pointer(buf + uintptr(i)*28)).Fsortkey = key
	}
	Xqsort(tls, buf, uint64(cnt), uint64(unsafe.Sizeof(address{})), *(*uintptr)(unsafe.Pointer(&struct {
		f func(*TLS, uintptr, uintptr) int32
	}{addrcmp})))

	//TODO pthread_setcancelstate(cs, 0);

	return cnt
}

func X__lookup_serv(tls *TLS, buf uintptr, name uintptr, proto int32, socktype int32, flags int32) int32 { /* lookup_serv.c:12:5: */
	if __ccgo_strace {
		trc("tls=%v buf=%v name=%v proto=%v socktype=%v flags=%v, (%v:)", tls, buf, name, proto, socktype, flags, origin(2))
	}
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var line [128]int8
	_ = line
	var cnt int32 = 0
	var p uintptr
	_ = p
	*(*uintptr)(unsafe.Pointer(bp /* z */)) = ts + 13 /* "" */
	var port uint64 = uint64(0)

	switch socktype {
	case 1:
		switch proto {
		case 0:
			proto = 6
			fallthrough
		case 6:
			break
		default:
			return -8
		}
		break
	case 2:
		switch proto {
		case 0:
			proto = 17
			fallthrough
		case 17:
			break
		default:
			return -8
		}
		fallthrough
	case 0:
		break
	default:
		if name != 0 {
			return -8
		}
		(*service)(unsafe.Pointer(buf)).Fport = uint16_t(0)
		(*service)(unsafe.Pointer(buf)).Fproto = uint8(proto)
		(*service)(unsafe.Pointer(buf)).Fsocktype = uint8(socktype)
		return 1
	}

	if name != 0 {
		if !(int32(*(*int8)(unsafe.Pointer(name))) != 0) {
			return -8
		}
		port = Xstrtoul(tls, name, bp, 10)
	}
	if !(int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp))))) != 0) {
		if port > uint64(65535) {
			return -8
		}
		if proto != 17 {
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).Fport = uint16_t(port)
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).Fsocktype = uint8(1)
			(*service)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*4)).Fproto = uint8(6)
		}
		if proto != 6 {
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).Fport = uint16_t(port)
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).Fsocktype = uint8(2)
			(*service)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*4)).Fproto = uint8(17)
		}
		return cnt
	}

	if flags&0x400 != 0 {
		return -2
	}

	var l size_t = Xstrlen(tls, name)
	_ = l

	Xabort(tls) //TODO-
	// unsigned char _buf[1032];
	// FILE _f, *f = __fopen_rb_ca("/etc/services", &_f, _buf, sizeof _buf);
	// if (!f) switch (errno) {
	// case ENOENT:
	// case ENOTDIR:
	// case EACCES:
	// 	return EAI_SERVICE;
	// default:
	// 	return EAI_SYSTEM;
	// }

	Xabort(tls) //TODO-
	// while (fgets(line, sizeof line, f) && cnt < MAXSERVS) {
	// 	if ((p=strchr(line, '#'))) *p++='\n', *p=0;

	// 	/* Find service name */
	// 	for(p=line; (p=strstr(p, name)); p++) {
	// 		if (p>line && !isspace(p[-1])) continue;
	// 		if (p[l] && !isspace(p[l])) continue;
	// 		break;
	// 	}
	// 	if (!p) continue;

	// 	/* Skip past canonical name at beginning of line */
	// 	for (p=line; *p && !isspace(*p); p++);

	// 	port = strtoul(p, &z, 10);
	// 	if (port > 65535 || z==p) continue;
	// 	if (!strncmp(z, "/udp", 4)) {
	// 		if (proto == IPPROTO_TCP) continue;
	// 		buf[cnt].port = port;
	// 		buf[cnt].socktype = SOCK_DGRAM;
	// 		buf[cnt++].proto = IPPROTO_UDP;
	// 	}
	// 	if (!strncmp(z, "/tcp", 4)) {
	// 		if (proto == IPPROTO_UDP) continue;
	// 		buf[cnt].port = port;
	// 		buf[cnt].socktype = SOCK_STREAM;
	// 		buf[cnt++].proto = IPPROTO_TCP;
	// 	}
	// }
	// __fclose_ca(f);
	// return cnt > 0 ? cnt : EAI_SERVICE;
	Xabort(tls)
	return int32(0) //TODO-
}

func X__toread(tls *TLS, f uintptr) int32 { /* __toread.c:3:5: */
	if __ccgo_strace {
		trc("tls=%v f=%v, (%v:)", tls, f, origin(2))
	}
	*(*int32)(unsafe.Pointer(f + 136)) |= (*FILE)(unsafe.Pointer(f)).Fmode - 1
	if (*FILE)(unsafe.Pointer(f)).Fwpos != (*FILE)(unsafe.Pointer(f)).Fwbase {
		(*struct {
			f func(*TLS, uintptr, uintptr, size_t) size_t
		})(unsafe.Pointer(&struct{ uintptr }{(*FILE)(unsafe.Pointer(f)).Fwrite})).f(tls, f, uintptr(0), uint64(0))
	}
	(*FILE)(unsafe.Pointer(f)).Fwpos = AssignPtrUintptr(f+56, AssignPtrUintptr(f+32, uintptr(0)))
	if (*FILE)(unsafe.Pointer(f)).Fflags&uint32(4) != 0 {
		*(*uint32)(unsafe.Pointer(f)) |= uint32(32)
		return -1
	}
	(*FILE)(unsafe.Pointer(f)).Frpos = AssignPtrUintptr(f+16, (*FILE)(unsafe.Pointer(f)).Fbuf+uintptr((*FILE)(unsafe.Pointer(f)).Fbuf_size))
	if (*FILE)(unsafe.Pointer(f)).Fflags&uint32(16) != 0 {
		return -1
	}
	return 0
}

func X__toread_needs_stdio_exit(tls *TLS) { /* __toread.c:16:13: */
	if __ccgo_strace {
		trc("tls=%v, (%v:)", tls, origin(2))
	}
	X__builtin_abort(tls) //TODO-
	// __stdio_exit_needed();
}

// This function assumes it will never be called if there is already
// data buffered for reading.

func X__uflow(tls *TLS, f uintptr) int32 { /* __uflow.c:6:5: */
	if __ccgo_strace {
		trc("tls=%v f=%v, (%v:)", tls, f, origin(2))
	}
	bp := tls.Alloc(1)
	defer tls.Free(1)

	// var c uint8 at bp, 1

	if !(X__toread(tls, f) != 0) && (*struct {
		f func(*TLS, uintptr, uintptr, size_t) size_t
	})(unsafe.Pointer(&struct{ uintptr }{(*FILE)(unsafe.Pointer(f)).Fread})).f(tls, f, bp, uint64(1)) == uint64(1) {
		return int32(*(*uint8)(unsafe.Pointer(bp)))
	}
	return -1
}

func Xbsearch(tls *TLS, key uintptr, base uintptr, nel size_t, width size_t, cmp uintptr) uintptr { /* bsearch.c:3:6: */
	if __ccgo_strace {
		trc("tls=%v key=%v base=%v nel=%v width=%v cmp=%v, (%v:)", tls, key, base, nel, width, cmp, origin(2))
	}
	var try uintptr
	var sign int32
	for nel > uint64(0) {
		try = base + uintptr(width*(nel/uint64(2)))
		sign = (*struct {
			f func(*TLS, uintptr, uintptr) int32
		})(unsafe.Pointer(&struct{ uintptr }{cmp})).f(tls, key, try)
		if sign < 0 {
			nel = nel / uint64(2)
		} else if sign > 0 {
			base = try + uintptr(width)
			nel = nel - (nel/uint64(2) + uint64(1))
		} else {
			return try
		}
	}
	return uintptr(0)
}

func strtox(tls *TLS, s uintptr, p uintptr, prec int32) float64 { /* strtod.c:6:20: */
	bp := tls.Alloc(232)
	defer tls.Free(232)

	// var f FILE at bp, 232

	(*FILE)(unsafe.Pointer(bp)).Fbuf = AssignPtrUintptr(bp+8, s)
	(*FILE)(unsafe.Pointer(bp)).Frend = UintptrFromInt32(-1)
	X__shlim(tls, bp, int64(0))
	var y float64 = X__floatscan(tls, bp, prec, 1)
	var cnt off_t = (*FILE)(unsafe.Pointer(bp)).Fshcnt + (int64((*FILE)(unsafe.Pointer(bp)).Frpos)-int64((*FILE)(unsafe.Pointer(bp)).Fbuf))/1
	if p != 0 {
		*(*uintptr)(unsafe.Pointer(p)) = func() uintptr {
			if cnt != 0 {
				return s + uintptr(cnt)
			}
			return s
		}()
	}
	return y
}

func Xstrtof(tls *TLS, s uintptr, p uintptr) float32 { /* strtod.c:17:7: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v, (%v:)", tls, s, p, origin(2))
	}
	return float32(strtox(tls, s, p, 0))
}

func Xstrtod(tls *TLS, s uintptr, p uintptr) float64 { /* strtod.c:22:8: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v, (%v:)", tls, s, p, origin(2))
	}
	return strtox(tls, s, p, 1)
}

func Xstrtold(tls *TLS, s uintptr, p uintptr) float64 { /* strtod.c:27:13: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v, (%v:)", tls, s, p, origin(2))
	}
	return strtox(tls, s, p, 2)
}

func strtox1(tls *TLS, s uintptr, p uintptr, base int32, lim uint64) uint64 { /* strtol.c:8:27: */
	bp := tls.Alloc(232)
	defer tls.Free(232)

	// var f FILE at bp, 232

	(*FILE)(unsafe.Pointer(bp)).Fbuf = AssignPtrUintptr(bp+8, s)
	(*FILE)(unsafe.Pointer(bp)).Frend = UintptrFromInt32(-1)
	X__shlim(tls, bp, int64(0))
	var y uint64 = X__intscan(tls, bp, uint32(base), 1, lim)
	if p != 0 {
		var cnt size_t = size_t((*FILE)(unsafe.Pointer(bp)).Fshcnt + (int64((*FILE)(unsafe.Pointer(bp)).Frpos)-int64((*FILE)(unsafe.Pointer(bp)).Fbuf))/1)
		*(*uintptr)(unsafe.Pointer(p)) = s + uintptr(cnt)
	}
	return y
}

func Xstrtoull(tls *TLS, s uintptr, p uintptr, base int32) uint64 { /* strtol.c:21:20: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v base=%v, (%v:)", tls, s, p, base, origin(2))
	}
	return strtox1(tls, s, p, base, 2*uint64(0x7fffffffffffffff)+uint64(1))
}

func Xstrtoll(tls *TLS, s uintptr, p uintptr, base int32) int64 { /* strtol.c:26:11: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v base=%v, (%v:)", tls, s, p, base, origin(2))
	}
	return int64(strtox1(tls, s, p, base, Uint64FromInt64(-0x7fffffffffffffff-int64(1))))
}

func Xstrtoul(tls *TLS, s uintptr, p uintptr, base int32) uint64 { /* strtol.c:31:15: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v base=%v, (%v:)", tls, s, p, base, origin(2))
	}
	return uint64(strtox1(tls, s, p, base, 2*uint64(0x7fffffffffffffff)+uint64(1)))
}

func Xstrtol(tls *TLS, s uintptr, p uintptr, base int32) int64 { /* strtol.c:36:6: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v base=%v, (%v:)", tls, s, p, base, origin(2))
	}
	return int64(strtox1(tls, s, p, base, 0+Uint64FromInt64(Int64(-Int64(0x7fffffffffffffff))-Int64FromInt32(1))))
}

func Xstrtoimax(tls *TLS, s uintptr, p uintptr, base int32) intmax_t { /* strtol.c:41:10: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v base=%v, (%v:)", tls, s, p, base, origin(2))
	}
	return intmax_t(Xstrtoll(tls, s, p, base))
}

func Xstrtoumax(tls *TLS, s uintptr, p uintptr, base int32) uintmax_t { /* strtol.c:46:11: */
	if __ccgo_strace {
		trc("tls=%v s=%v p=%v base=%v, (%v:)", tls, s, p, base, origin(2))
	}
	return uintmax_t(Xstrtoull(tls, s, p, base))
}

func Xstrdup(tls *TLS, s uintptr) uintptr { /* strdup.c:4:6: */
	if __ccgo_strace {
		trc("tls=%v s=%v, (%v:)", tls, s, origin(2))
	}
	var l size_t = Xstrlen(tls, s)
	var d uintptr = Xmalloc(tls, l+uint64(1))
	if !(d != 0) {
		return uintptr(0)
	}
	return Xmemcpy(tls, d, s, l+uint64(1))
}

func Xstrnlen(tls *TLS, s uintptr, n size_t) size_t { /* strnlen.c:3:8: */
	if __ccgo_strace {
		trc("tls=%v s=%v n=%v, (%v:)", tls, s, n, origin(2))
	}
	var p uintptr = Xmemchr(tls, s, 0, n)
	if p != 0 {
		return uint64((int64(p) - int64(s)) / 1)
	}
	return n
}

func Xstrspn(tls *TLS, s uintptr, c uintptr) size_t { /* strspn.c:6:8: */
	if __ccgo_strace {
		trc("tls=%v s=%v c=%v, (%v:)", tls, s, c, origin(2))
	}
	bp := tls.Alloc(32)
	defer tls.Free(32)

	var a uintptr = s
	*(*[4]size_t)(unsafe.Pointer(bp /* byteset */)) = [4]size_t{0: uint64(0)}

	if !(int32(*(*int8)(unsafe.Pointer(c))) != 0) {
		return uint64(0)
	}
	if !(int32(*(*int8)(unsafe.Pointer(c + 1))) != 0) {
		for ; int32(*(*int8)(unsafe.Pointer(s))) == int32(*(*int8)(unsafe.Pointer(c))); s++ {
		}
		return size_t((int64(s) - int64(a)) / 1)
	}

	for ; *(*int8)(unsafe.Pointer(c)) != 0 && AssignOrPtrUint64(bp+uintptr(size_t(*(*uint8)(unsafe.Pointer(c)))/(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))*8, size_t(uint64(1))<<(size_t(*(*uint8)(unsafe.Pointer(c)))%(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))) != 0; c++ {
	}
	for ; *(*int8)(unsafe.Pointer(s)) != 0 && *(*size_t)(unsafe.Pointer(bp + uintptr(size_t(*(*uint8)(unsafe.Pointer(s)))/(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))*8))&(size_t(uint64(1))<<(size_t(*(*uint8)(unsafe.Pointer(s)))%(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))) != 0; s++ {
	}
	return size_t((int64(s) - int64(a)) / 1)
}

func init() {
	*(*uintptr)(unsafe.Pointer(uintptr(unsafe.Pointer(&X_ctype_)) + 0)) = uintptr(unsafe.Pointer(&X_C_ctype_)) // ctype_.c:319:23:
}

var ts1 = "infinity\x00nan\x00\x00\x00\x01\x02\x04\a\x03\x06\x05\x00%d.%d.%d.%d.in-addr.arpa\x00ip6.arpa\x000123456789abcdef\x00/etc/hosts\x00rb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00%d.%d.%d.%d\x00%x:%x:%x:%x:%x:%x:%x:%x\x00%x:%x:%x:%x:%x:%x:%d.%d.%d.%d\x00:0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00 \x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
