/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jmeld.JMeldException;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMDiff;
import org.jmeld.diff.JMRevision;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.DiffScrollComponent;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.RevisionBar;
import org.jmeld.ui.SavePanelDialog;
import org.jmeld.ui.ScrollSynchronizer;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHit;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.text.AbstractBufferDocument;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.text.JMDocumentEvent;
import org.jmeld.util.StringUtil;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.JMDiffNode;

public class BufferDiffPanel
extends AbstractContentPanel {
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    private JMeldPanel mainPanel;
    private FilePanel[] filePanels;
    private JMDiffNode diffNode;
    int filePanelSelectedIndex = -1;
    private JMRevision currentRevision;
    private JMDelta selectedDelta;
    private int selectedLine;
    private ScrollSynchronizer scrollSynchronizer;
    private JMDiff diff;

    BufferDiffPanel(JMeldPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.diff = new JMDiff();
        this.filePanels = new FilePanel[3];
        this.init();
        this.setFocusable(true);
    }

    public void setDiffNode(JMDiffNode diffNode) {
        this.diffNode = diffNode;
        BufferNode bnLeft = diffNode.getBufferNodeLeft();
        BufferNode bnRight = diffNode.getBufferNodeRight();
        this.setBufferDocuments(bnLeft == null ? null : bnLeft.getDocument(), bnRight == null ? null : bnRight.getDocument(), diffNode.getDiff(), diffNode.getRevision());
    }

    private void setBufferDocuments(BufferDocumentIF bd1, BufferDocumentIF bd2, JMDiff diff, JMRevision revision) {
        this.diff = diff;
        this.currentRevision = revision;
        if (bd1 != null) {
            this.filePanels[0].setBufferDocument(bd1);
        }
        if (bd2 != null) {
            this.filePanels[2].setBufferDocument(bd2);
        }
        if (bd1 != null && bd2 != null) {
            this.filePanels[0].updateFileLabel(bd1.getName(), bd2.getName());
            this.filePanels[2].updateFileLabel(bd2.getName(), bd1.getName());
        }
        if (bd1 != null && bd2 != null) {
            this.reDisplay();
        }
    }

    private void reDisplay() {
        for (FilePanel fp : this.filePanels) {
            if (fp == null) continue;
            fp.reDisplay();
        }
        this.mainPanel.repaint();
    }

    public String getTitle() {
        String title = "";
        ArrayList<String> titles = new ArrayList<String>();
        for (FilePanel filePanel : this.filePanels) {
            BufferDocumentIF bd;
            if (filePanel == null || (bd = filePanel.getBufferDocument()) == null || StringUtil.isEmpty(title = bd.getShortName())) continue;
            titles.add(title);
        }
        title = "";
        title = titles.size() == 1 ? (String)titles.get(0) : (((String)titles.get(0)).equals(titles.get(1)) ? (String)titles.get(0) : (String)titles.get(0) + "-" + (String)titles.get(1));
        return title;
    }

    public boolean revisionChanged(JMDocumentEvent de) {
        if (this.currentRevision == null) {
            this.diff();
        } else {
            BufferDocumentIF bd2;
            FilePanel fp = this.getFilePanel(de.getDocument());
            if (fp == null) {
                return false;
            }
            BufferDocumentIF bd1 = this.filePanels[0].getBufferDocument();
            if (!this.currentRevision.update(bd1 != null ? bd1.getLines() : null, (bd2 = this.filePanels[2].getBufferDocument()) != null ? bd2.getLines() : null, fp == this.filePanels[0], de.getStartLine(), de.getNumberOfLines())) {
                return false;
            }
            this.reDisplay();
        }
        return true;
    }

    private FilePanel getFilePanel(AbstractBufferDocument document) {
        for (FilePanel fp : this.filePanels) {
            if (fp == null || fp.getBufferDocument() != document) continue;
            return fp;
        }
        return null;
    }

    public void diff() {
        BufferDocumentIF bd1 = this.filePanels[0].getBufferDocument();
        BufferDocumentIF bd2 = this.filePanels[2].getBufferDocument();
        if (bd1 != null && bd2 != null) {
            try {
                this.currentRevision = this.diff.diff(bd1.getLines(), bd2.getLines(), this.diffNode.getIgnore());
                this.reDisplay();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void init() {
        String columns = "3px, pref, 3px, 0:grow, 5px, min, 60px, 0:grow, 25px, min, 3px, pref, 3px";
        String rows = "6px, pref, 3px, fill:0:grow, pref";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.filePanels[0] = new FilePanel(this, "Original", 0);
        this.filePanels[2] = new FilePanel(this, "Revised", 2);
        this.add((Component)new RevisionBar(this, this.filePanels[0], true), cc.xy(2, 4));
        this.add((Component)this.filePanels[0].getSaveButton(), cc.xy(2, 2));
        this.add((Component)this.filePanels[0].getFileLabel(), cc.xyw(4, 2, 3));
        this.add((Component)this.filePanels[0].getScrollPane(), cc.xyw(4, 4, 3));
        this.add((Component)this.filePanels[0].getFilePanelBar(), cc.xyw(4, 5, 3));
        this.add((Component)new DiffScrollComponent(this, 0, 2), cc.xy(7, 4));
        this.add((Component)new RevisionBar(this, this.filePanels[2], false), cc.xy(12, 4));
        this.add((Component)this.filePanels[2].getFileLabel(), cc.xyw(8, 2, 3));
        this.add((Component)this.filePanels[2].getScrollPane(), cc.xyw(8, 4, 3));
        this.add((Component)this.filePanels[2].getSaveButton(), cc.xy(12, 2));
        this.add((Component)this.filePanels[2].getFilePanelBar(), cc.xyw(8, 5, 3));
        this.scrollSynchronizer = new ScrollSynchronizer(this, this.filePanels[0], this.filePanels[2]);
        this.setSelectedPanel(this.filePanels[0]);
    }

    void toNextDelta(boolean next) {
        if (next) {
            this.doDown();
        } else {
            this.doUp();
        }
    }

    JMRevision getCurrentRevision() {
        return this.currentRevision;
    }

    public boolean checkSave() {
        if (!this.isSaveEnabled()) {
            return true;
        }
        SavePanelDialog dialog = new SavePanelDialog(this.mainPanel);
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null) continue;
            dialog.add(filePanel.getBufferDocument());
        }
        dialog.show();
        if (dialog.isOK()) {
            dialog.doSave();
            return true;
        }
        return false;
    }

    public void doSave() {
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null || !filePanel.isDocumentChanged()) continue;
            BufferDocumentIF document = filePanel.getBufferDocument();
            try {
                document.write();
            }
            catch (JMeldException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.mainPanel, "Can't write file" + document.getName(), "Problem writing file", 0);
            }
        }
    }

    public boolean isSaveEnabled() {
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null || !filePanel.isDocumentChanged()) continue;
            return true;
        }
        return false;
    }

    public void doStopSearch() {
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null) continue;
            filePanel.doStopSearch();
        }
    }

    public SearchCommand getSearchCommand() {
        return this.mainPanel.getSearchCommand();
    }

    public SearchHits doSearch() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return null;
        }
        SearchHits searchHits = fp.doSearch();
        this.scrollToSearch(fp, searchHits);
        return searchHits;
    }

    public void doNextSearch() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return;
        }
        SearchHits searchHits = fp.getSearchHits();
        searchHits.next();
        fp.reDisplay();
        this.scrollToSearch(fp, searchHits);
    }

    public void doPreviousSearch() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return;
        }
        SearchHits searchHits = fp.getSearchHits();
        searchHits.previous();
        fp.reDisplay();
        this.scrollToSearch(fp, searchHits);
    }

    public void doRefresh() {
        this.diff();
    }

    public void doMergeMode(boolean mergeMode) {
        for (FilePanel fp : this.filePanels) {
            if (fp == null) continue;
            fp.getEditor().setFocusable(!mergeMode);
        }
    }

    private void scrollToSearch(FilePanel fp, SearchHits searchHits) {
        if (searchHits == null) {
            return;
        }
        SearchHit currentHit = searchHits.getCurrent();
        if (currentHit != null) {
            int line = currentHit.getLine();
            this.scrollSynchronizer.scrollToLine(fp, line);
            this.setSelectedLine(line);
        }
    }

    private FilePanel getSelectedPanel() {
        if (this.filePanelSelectedIndex >= 0 && this.filePanelSelectedIndex < this.filePanels.length) {
            return this.filePanels[this.filePanelSelectedIndex];
        }
        return null;
    }

    void setSelectedPanel(FilePanel fp) {
        int index = -1;
        for (int i = 0; i < this.filePanels.length; ++i) {
            if (this.filePanels[i] != fp) continue;
            index = i;
        }
        if (index != this.filePanelSelectedIndex) {
            if (this.filePanelSelectedIndex != -1) {
                this.filePanels[this.filePanelSelectedIndex].setSelected(false);
            }
            this.filePanelSelectedIndex = index;
            if (this.filePanelSelectedIndex != -1) {
                this.filePanels[this.filePanelSelectedIndex].setSelected(true);
            }
        }
    }

    public void checkActions() {
        this.mainPanel.checkActions();
    }

    public void doLeft() {
        this.runChange(2, 0);
    }

    public void doRight() {
        this.runChange(0, 2);
    }

    void runChange(int fromPanelIndex, int toPanelIndex) {
        JMDelta delta = this.getSelectedDelta();
        if (delta == null) {
            return;
        }
        if (fromPanelIndex < 0 || fromPanelIndex >= this.filePanels.length) {
            return;
        }
        if (toPanelIndex < 0 || toPanelIndex >= this.filePanels.length) {
            return;
        }
        try {
            JMChunk toChunk;
            JMChunk fromChunk;
            BufferDocumentIF fromBufferDocument = this.filePanels[fromPanelIndex].getBufferDocument();
            BufferDocumentIF toBufferDocument = this.filePanels[toPanelIndex].getBufferDocument();
            if (fromPanelIndex < toPanelIndex) {
                fromChunk = delta.getOriginal();
                toChunk = delta.getRevised();
            } else {
                fromChunk = delta.getRevised();
                toChunk = delta.getOriginal();
            }
            JTextArea toEditor = this.filePanels[toPanelIndex].getEditor();
            if (fromBufferDocument == null || toBufferDocument == null) {
                return;
            }
            int fromLine = fromChunk.getAnchor();
            int size = fromChunk.getSize();
            int fromOffset = fromBufferDocument.getOffsetForLine(fromLine);
            if (fromOffset < 0) {
                return;
            }
            int toOffset = fromBufferDocument.getOffsetForLine(fromLine + size);
            if (toOffset < 0) {
                return;
            }
            PlainDocument from = fromBufferDocument.getDocument();
            String s = from.getText(fromOffset, toOffset - fromOffset);
            fromLine = toChunk.getAnchor();
            size = toChunk.getSize();
            fromOffset = toBufferDocument.getOffsetForLine(fromLine);
            if (fromOffset < 0) {
                return;
            }
            toOffset = toBufferDocument.getOffsetForLine(fromLine + size);
            if (toOffset < 0) {
                return;
            }
            this.getUndoHandler().start("replace");
            toEditor.setSelectionStart(fromOffset);
            toEditor.setSelectionEnd(toOffset);
            toEditor.replaceSelection(s);
            this.getUndoHandler().end("replace");
            this.setSelectedDelta(null);
            this.setSelectedLine(delta.getOriginal().getAnchor());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void runDelete(int fromPanelIndex, int toPanelIndex) {
        try {
            JMDelta delta = this.getSelectedDelta();
            if (delta == null) {
                return;
            }
            if (fromPanelIndex < 0 || fromPanelIndex >= this.filePanels.length) {
                return;
            }
            if (toPanelIndex < 0 || toPanelIndex >= this.filePanels.length) {
                return;
            }
            BufferDocumentIF bufferDocument = this.filePanels[fromPanelIndex].getBufferDocument();
            JMChunk chunk = fromPanelIndex < toPanelIndex ? delta.getOriginal() : delta.getRevised();
            JTextArea toEditor = this.filePanels[fromPanelIndex].getEditor();
            if (bufferDocument == null) {
                return;
            }
            PlainDocument document = bufferDocument.getDocument();
            int fromLine = chunk.getAnchor();
            int size = chunk.getSize();
            int fromOffset = bufferDocument.getOffsetForLine(fromLine);
            if (fromOffset < 0) {
                return;
            }
            int toOffset = bufferDocument.getOffsetForLine(fromLine + size);
            if (toOffset < 0) {
                return;
            }
            this.getUndoHandler().start("remove");
            toEditor.setSelectionStart(fromOffset);
            toEditor.setSelectionEnd(toOffset);
            toEditor.replaceSelection("");
            this.getUndoHandler().end("remove");
            this.setSelectedDelta(null);
            this.setSelectedLine(delta.getOriginal().getAnchor());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doDown() {
        JMDelta sd;
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        int index = deltas.indexOf(sd = this.getSelectedDelta());
        if (index == -1 || sd.getOriginal().getAnchor() != this.selectedLine) {
            JMDelta d = null;
            Iterator<JMDelta> i$ = deltas.iterator();
            while (i$.hasNext()) {
                JMDelta delta;
                d = delta = i$.next();
                if (delta.getOriginal().getAnchor() <= this.selectedLine) continue;
                break;
            }
            this.setSelectedDelta(d);
        } else if (index + 1 < deltas.size()) {
            this.setSelectedDelta(deltas.get(index + 1));
        }
        this.showSelectedDelta();
    }

    public void doUp() {
        JMDelta sd;
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        int index = deltas.indexOf(sd = this.getSelectedDelta());
        if (index == -1 || sd.getOriginal().getAnchor() != this.selectedLine) {
            JMDelta d = null;
            JMDelta previousDelta = null;
            Iterator<JMDelta> i$ = deltas.iterator();
            while (i$.hasNext()) {
                JMDelta delta;
                d = delta = i$.next();
                if (delta.getOriginal().getAnchor() > this.selectedLine) {
                    if (previousDelta == null) break;
                    d = previousDelta;
                    break;
                }
                previousDelta = delta;
            }
            this.setSelectedDelta(d);
        } else if (index - 1 >= 0) {
            this.setSelectedDelta(deltas.get(index - 1));
        }
        this.showSelectedDelta();
    }

    public void doGotoDelta(JMDelta delta) {
        this.setSelectedDelta(delta);
        this.showSelectedDelta();
    }

    public void doGotoLine(int line) {
        this.setSelectedLine(line);
        FilePanel fp = this.getFilePanel(0);
        BufferDocumentIF bd = fp.getBufferDocument();
        if (bd == null) {
            return;
        }
        int offset = bd.getOffsetForLine(line);
        JViewport viewport = fp.getScrollPane().getViewport();
        JTextArea editor = fp.getEditor();
        Rectangle rect = viewport.getViewRect();
        int startOffset = editor.viewToModel(rect.getLocation());
        int endOffset = editor.viewToModel(new Point(rect.x, rect.y + rect.height));
        if (offset >= startOffset && offset <= endOffset) {
            return;
        }
        try {
            Point p = editor.modelToView(offset).getLocation();
            p.x = 0;
            viewport.setViewPosition(p);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    public void doZoom(boolean direction) {
        for (FilePanel p : this.filePanels) {
            if (p == null) continue;
            JTextArea c = p.getEditor();
            Zoom zoom = (Zoom)c.getClientProperty("JMeld.zoom");
            if (zoom == null) {
                zoom = new Zoom();
                zoom.font = c.getFont();
                c.putClientProperty("JMeld.zoom", zoom);
            }
            float size = (float)c.getFont().getSize() + (direction ? 1.0f : -1.0f);
            size = size > 100.0f ? 100.0f : size;
            size = size < 5.0f ? 5.0f : size;
            ((JComponent)c).setFont(zoom.font.deriveFont(size));
        }
    }

    public void doGoToSelected() {
        this.showSelectedDelta();
    }

    public void doGoToFirst() {
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        if (deltas.size() > 0) {
            this.setSelectedDelta(deltas.get(0));
            this.showSelectedDelta();
        }
    }

    public void doGoToLast() {
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        if (deltas.size() > 0) {
            this.setSelectedDelta(deltas.get(deltas.size() - 1));
            this.showSelectedDelta();
        }
    }

    public void doGoToLine(int line) {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return;
        }
        this.scrollSynchronizer.scrollToLine(fp, line);
        this.setSelectedLine(line);
    }

    void setSelectedDelta(JMDelta delta) {
        this.selectedDelta = delta;
        this.setSelectedLine(delta == null ? 0 : delta.getOriginal().getAnchor());
    }

    private void setSelectedLine(int line) {
        this.selectedLine = line;
    }

    private void showSelectedDelta() {
        JMDelta delta = this.getSelectedDelta();
        if (delta == null) {
            return;
        }
        this.scrollSynchronizer.showDelta(delta);
    }

    public JMDelta getSelectedDelta() {
        if (this.currentRevision == null) {
            return null;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        if (deltas.size() == 0) {
            return null;
        }
        return this.selectedDelta;
    }

    FilePanel getFilePanel(int index) {
        if (index < 0 || index > this.filePanels.length) {
            return null;
        }
        return this.filePanels[index];
    }

    public String getSelectedText() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return null;
        }
        return fp.getSelectedText();
    }

    class Zoom {
        Font font;

        Zoom() {
        }
    }
}

