/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import net.sourceforge.squirrel_sql.fw.gui.DirectoryListComboBox;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;

public class SkinLookAndFeelController
extends DefaultLookAndFeelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SkinLookAndFeelController.class);
    private static final ILogger s_log = LoggerController.createLogger(SkinLookAndFeelController.class);
    public static final String SKINNABLE_LAF_CLASS_NAME = "com.l2fprod.gui.plaf.skin.SkinLookAndFeel";
    public static final String SKIN_CLASS_NAME = "com.l2fprod.gui.plaf.skin.Skin";
    private SkinPreferences _prefs;
    private FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();

    SkinLookAndFeelController(LAFPlugin plugin) throws IOException {
        XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
        Iterator it = cache.getAllForClass(SkinPreferences.class);
        if (it.hasNext()) {
            this._prefs = (SkinPreferences)it.next();
        } else {
            this._prefs = new SkinPreferences();
            try {
                cache.add((IHasIdentifier)this._prefs);
            }
            catch (DuplicateObjectException ex) {
                s_log.error((Object)"SkinPreferences object already in XMLObjectCache", (Throwable)ex);
            }
        }
        FileWrapper themePackDir = this.fileWrapperFactory.create(plugin.getPluginAppSettingsFolder(), "skinlf-theme-packs");
        this._prefs.setThemePackDirectory(themePackDir.getAbsolutePath());
        if (!themePackDir.exists()) {
            themePackDir.mkdirs();
        }
    }

    @Override
    public void aboutToBeInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        try {
            File themePackFile;
            String dir = this._prefs.getThemePackDirectory();
            String name = this._prefs.getThemePackName();
            if (dir != null && name != null && (themePackFile = new File(dir, name)).exists()) {
                ClassLoader cl = lafRegister.getLookAndFeelClassLoader();
                Class<?> skinLafClass = Class.forName(SKINNABLE_LAF_CLASS_NAME, false, cl);
                Class<?> skinClass = Class.forName(SKIN_CLASS_NAME, false, cl);
                Method loadThemePack = skinLafClass.getMethod("loadThemePack", String.class);
                Method setSkin = skinLafClass.getMethod("setSkin", skinClass);
                Object[] parms = new Object[]{dir + "/" + name};
                Object skin = loadThemePack.invoke(skinLafClass, parms);
                setSkin.invoke(skinLafClass, skin);
            }
        }
        catch (Throwable th) {
            s_log.error((Object)"Error loading a Skinnable Look and Feel", th);
        }
    }

    @Override
    public void hasBeenInstalled(LAFRegister lafRegister, LookAndFeel laf) {
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return new SkinPrefsPanel(this);
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        this.fileWrapperFactory = fileWrapperFactory;
    }

    public static final class SkinPreferences
    implements IHasIdentifier {
        private String _themePackDir;
        private String _themePackName;
        private IntegerIdentifier _id = new IntegerIdentifier(1);

        public String getThemePackDirectory() {
            return this._themePackDir;
        }

        public void setThemePackDirectory(String value) {
            this._themePackDir = value;
        }

        public String getThemePackName() {
            return this._themePackName;
        }

        public void setThemePackName(String value) {
            this._themePackName = value;
        }

        public IIdentifier getIdentifier() {
            return this._id;
        }
    }

    private static final class SkinPrefsPanel
    extends BaseLAFPreferencesPanelComponent {
        private static final long serialVersionUID = 1L;
        private SkinLookAndFeelController _ctrl;
        private DirectoryListComboBox _themePackCmb = new DirectoryListComboBox();

        SkinPrefsPanel(SkinLookAndFeelController ctrl) {
            super(new GridBagLayout());
            this._ctrl = ctrl;
            this.createUserInterface();
        }

        private void createUserInterface() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)new JLabel(SkinPrefsPanelI18n.THEME_PACK, 4), gbc);
            ++gbc.gridx;
            this.add((Component)this._themePackCmb, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)new JLabel(SkinPrefsPanelI18n.THEMEPACK_LOC, 4), gbc);
            ++gbc.gridx;
            String themePackDir = this._ctrl._prefs.getThemePackDirectory();
            this.add((Component)new OutputLabel(themePackDir), gbc);
        }

        @Override
        public void loadPreferencesPanel() {
            super.loadPreferencesPanel();
            String themePackDir = this._ctrl._prefs.getThemePackDirectory();
            FileExtensionFilter filter = new FileExtensionFilter(s_stringMgr.getString("laf.jarZip"), new String[]{".jar", ".zip"});
            this._themePackCmb.load(new File(themePackDir), (FilenameFilter)filter);
            this._themePackCmb.setSelectedItem((Object)this._ctrl._prefs.getThemePackName());
            if (this._themePackCmb.getSelectedIndex() == -1 && this._themePackCmb.getModel().getSize() > 0) {
                this._themePackCmb.setSelectedIndex(0);
            }
        }

        @Override
        public boolean applyChanges() {
            super.applyChanges();
            this._ctrl._prefs.setThemePackName((String)this._themePackCmb.getSelectedItem());
            return true;
        }

        static interface SkinPrefsPanelI18n {
            public static final String THEME_PACK = SkinLookAndFeelController.access$000().getString("laf.skinThemPack");
            public static final String THEMEPACK_LOC = SkinLookAndFeelController.access$000().getString("laf.skinThemePackDir");
        }
    }
}

