/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.AliasWindowFactory;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AliasWindowManager {
    private static final ILogger s_log = LoggerController.createLogger(AliasWindowManager.class);
    private final IApplication _app;
    private final AliasWindowFactory _aliasWinFactory;

    public AliasWindowManager(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this._aliasWinFactory = new AliasWindowFactory(this._app);
    }

    public void showModifyAliasInternalFrame(ISQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLAlias == null");
        }
        this.moveToFront(this._aliasWinFactory.getModifySheet(alias));
    }

    public void showNewAliasInternalFrame() {
        this.moveToFront(this._aliasWinFactory.getCreateSheet());
    }

    public void showCopyAliasInternalFrame(SQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLAlias == null");
        }
        this.moveToFront(this._aliasWinFactory.getCopySheet(alias));
    }

    public void moveToFront(final AliasInternalFrame fr) {
        if (fr != null) {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    fr.moveToFront();
                }
            });
        } else {
            s_log.debug("JInternalFrame == null");
        }
    }
}

