/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.sql.DriverPropertyInfo;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class DriverPropertiesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverPropertiesTableModel.class);
    private static final int COLUMN_COUNT = 5;
    private static final ILogger s_log = LoggerController.createLogger(DriverPropertiesTableModel.class);
    private transient SQLDriverPropertyCollection _props = new SQLDriverPropertyCollection();

    DriverPropertiesTableModel(SQLDriverPropertyCollection props) {
        if (props == null) {
            throw new IllegalArgumentException("SQLDriverPropertyCollection[] == null");
        }
        this.load(props);
    }

    @Override
    public Object getValueAt(int row, int col) {
        SQLDriverProperty sdp = this._props.getDriverProperty(row);
        switch (col) {
            case 0: {
                return sdp.getName();
            }
            case 1: {
                return sdp.isSpecified();
            }
            case 2: {
                return sdp.getValue();
            }
            case 3: {
                DriverPropertyInfo dpi = sdp.getDriverPropertyInfo();
                if (dpi != null) {
                    return dpi.required;
                }
                return Boolean.FALSE;
            }
            case 4: {
                DriverPropertyInfo dpi = sdp.getDriverPropertyInfo();
                if (dpi != null) {
                    return dpi.description;
                }
                return s_stringMgr.getString("DriverPropertiesTableModel.unknown");
            }
        }
        s_log.error("Invalid column index: " + col);
        return "???????";
    }

    @Override
    public int getRowCount() {
        return this._props.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Object.class;
            }
            case 4: {
                return String.class;
            }
        }
        s_log.error("Invalid column index: " + col);
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            SQLDriverProperty sdp = this._props.getDriverProperty(row);
            sdp.setValue(value.toString());
        } else if (col == 1) {
            SQLDriverProperty sdp = this._props.getDriverProperty(row);
            Boolean bool = Boolean.valueOf(value.toString());
            sdp.setIsSpecified(bool);
        } else {
            throw new IllegalStateException("Can only edit value/specify column. Trying to edit " + col);
        }
    }

    public void addRow(String name, String value, String description) {
        DriverPropertyInfo propInfo = new DriverPropertyInfo(name, value);
        propInfo.description = description;
        SQLDriverProperty newProp = new SQLDriverProperty(propInfo);
        this._props.addDriverProperty(newProp);
        this.fireTableDataChanged();
    }

    public void removeRow(String name) {
        this._props.removeDriverProperty(name);
        this.fireTableDataChanged();
    }

    SQLDriverPropertyCollection getSQLDriverProperties() {
        return this._props;
    }

    private final void load(SQLDriverPropertyCollection props) {
        int origSize = this.getRowCount();
        if (origSize > 0) {
            this.fireTableRowsDeleted(0, origSize - 1);
        }
        this._props = props;
        int newSize = this.getRowCount();
        if (newSize > 0) {
            this.fireTableRowsInserted(0, newSize - 1);
        }
    }

    static interface IColumnIndexes {
        public static final int IDX_NAME = 0;
        public static final int IDX_SPECIFY = 1;
        public static final int IDX_VALUE = 2;
        public static final int IDX_REQUIRED = 3;
        public static final int IDX_DESCRIPTION = 4;
    }
}

