/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin;

import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.plugin.DefaultPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginDatabaseObjectType;
import net.sourceforge.squirrel_sql.client.plugin.ISessionPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class DefaultSessionPlugin
extends DefaultPlugin
implements ISessionPlugin {
    private JMenu sessionMenu = null;
    private static final ILogger s_log = LoggerController.createLogger(DefaultSessionPlugin.class);

    @Override
    public void sessionCreated(ISession session) {
    }

    @Override
    public boolean allowsSessionStartedInBackground() {
        return false;
    }

    @Override
    public void sessionEnding(ISession session) {
    }

    @Override
    public ISessionPropertiesPanel[] getSessionPropertiesPanels(ISession session) {
        return null;
    }

    @Override
    public IPluginDatabaseObjectType[] getObjectTypes(ISession session) {
        return null;
    }

    @Override
    public INodeExpander getDefaultNodeExpander(ISession session, DatabaseObjectType type) {
        return null;
    }

    protected boolean isPluginSession(ISession session) {
        if (s_log.isDebugEnabled() && this.sessionMenu != null) {
            s_log.debug("The default isPluginSession() impl was called for session \"" + session.getAlias().getName() + "\", but sessionMenu (" + this.sessionMenu.getText() + ")is not null - this is probably a bug.");
        }
        return true;
    }

    protected void registerSessionMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu cannot be null");
        }
        this.sessionMenu = menu;
        this._app.getSessionManager().addSessionListener(new SessionListener());
    }

    private class SessionListener
    extends SessionAdapter {
        private SessionListener() {
        }

        @Override
        public void sessionActivated(SessionEvent evt) {
            boolean enable = DefaultSessionPlugin.this.isPluginSession(evt.getSession());
            DefaultSessionPlugin.this.sessionMenu.setEnabled(enable);
        }
    }
}

