/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class RangeSlider
extends JSlider {
    private static final String uiClassID = "RangeSliderUI";

    public RangeSlider() {
    }

    public RangeSlider(int orientation) {
        super(orientation);
    }

    public RangeSlider(int min, int max) {
        super(min, max);
    }

    public RangeSlider(int min, int max, int low, int high) {
        super(new DefaultBoundedRangeModel(low, high - low, min, max));
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public int getLowValue() {
        return this.getModel().getValue();
    }

    public int getHighValue() {
        return this.getModel().getValue() + this.getModel().getExtent();
    }

    public boolean contains(int value) {
        return value >= this.getLowValue() && value <= this.getHighValue();
    }

    public void setLowValue(int lowValue) {
        int high = lowValue + this.getModel().getExtent() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        int extent = high - lowValue;
        this.getModel().setRangeProperties(lowValue, extent, this.getMinimum(), this.getMaximum(), true);
    }

    public void setHighValue(int highValue) {
        this.getModel().setExtent(highValue - this.getLowValue());
    }
}

