package com.jclark.xsl.om;

import java.net.URL;

public interface Node {
  static byte ELEMENT = 0;
  static byte TEXT = 1;
  static byte ATTRIBUTE = 2;
  static byte ROOT = 3;
  static byte PROCESSING_INSTRUCTION = 4;
  static byte COMMENT = 5;
  static int N_TYPES = 6;
  byte getType();
  /**
   * Returns element type name for element; attribute name for an attribute;
   * target for a PI.
   */
  Name getName();
  /**
   * Returns text for TEXT node; value for attribute node;
   * content for comment node;
   * content after PI for PI node; null otherwise.
   */
  String getData();
  Node getParent();
  SafeNodeIterator getChildren();
  SafeNodeIterator getFollowingSiblings();
  URL getURL();
  int getLineNumber();
  NamespacePrefixMap getNamespacePrefixMap();
  int compareTo(Node node);
  Node getElementWithId(String id);
  boolean isId(String id);
  String getAttributeValue(Name name);
  Node getAttribute(Name name);
  SafeNodeIterator getAttributes();
  String getGeneratedId();
  String getUnparsedEntityURI(String name);
  Node getRoot();
}
