package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import com.jclark.xsl.expr.StringExpr;

class DocumentAction implements Action {
  private StringExpr hrefExpr;
  private OutputMethod outputMethod;
  private Action content;

  DocumentAction(StringExpr hrefExpr,
		 OutputMethod outputMethod,
		 Action content) {
    this.hrefExpr = hrefExpr;
    this.outputMethod = outputMethod;
    this.content = content;
  }

  public void invoke(ProcessContext context, Node sourceNode, Result result) throws XSLException {
    result = result.createResult(hrefExpr.eval(sourceNode, context));
    if (result != null) {
      result.start(outputMethod);
      content.invoke(context, sourceNode, result);
      result.end();
    }
  }
}
